/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.ExpectedProblem;
import org.eclipse.jdt.apt.tests.annotations.ProcessorTestStatus;

public class ExceptionHandlingTests
extends APTTestBase {
    public ExceptionHandlingTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ExceptionHandlingTests.class);
    }

    public void testWrapperClassForPrimitiveValue() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath testPath = env.addClass(srcRoot, "test", "Test", ExceptionHandlingTests.getCodeForTest("booleanValue = Boolean.valueOf(true)"));
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemFor(testPath, new ExpectedProblem("Test", "Type mismatch: cannot convert from Boolean to boolean", testPath));
        ExceptionHandlingTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testOtherPrimitiveForBooleanValue() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath testPath = env.addClass(srcRoot, "test", "Test", ExceptionHandlingTests.getCodeForTest("booleanValue = 2"));
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemFor(testPath, new ExpectedProblem("Test", "Type mismatch: cannot convert from int to boolean", testPath));
        ExceptionHandlingTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testStringForBooleanValue() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath testPath = env.addClass(srcRoot, "test", "Test", ExceptionHandlingTests.getCodeForTest("booleanValue = \"not a boolean\""));
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemFor(testPath, new ExpectedProblem("Test", "Type mismatch: cannot convert from String to boolean", testPath));
        ExceptionHandlingTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testArrayForBooleanValue() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath testPath = env.addClass(srcRoot, "test", "Test", ExceptionHandlingTests.getCodeForTest("booleanValue = {}"));
        this.fullBuild(project.getFullPath());
        ExpectedProblem ep = new ExpectedProblem("Test", "Type mismatch: cannot convert from Object[] to boolean", testPath);
        this.expectingOnlySpecificProblemFor(testPath, ep);
        ExceptionHandlingTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testPrimitiveForStringValue() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath testPath = env.addClass(srcRoot, "test", "Test", ExceptionHandlingTests.getCodeForTest("strValue = true"));
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemFor(testPath, new ExpectedProblem("Test", "Type mismatch: cannot convert from boolean to String", testPath));
        ExceptionHandlingTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testOtherClassForStringValue() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath testPath = env.addClass(srcRoot, "test", "Test", ExceptionHandlingTests.getCodeForTest("strValue = new Object()"));
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemFor(testPath, new ExpectedProblem("Test", "Type mismatch: cannot convert from Object to String", testPath));
        ExceptionHandlingTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testArrayForStringValue() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath testPath = env.addClass(srcRoot, "test", "Test", ExceptionHandlingTests.getCodeForTest("strValue = {}"));
        this.fullBuild(project.getFullPath());
        ExpectedProblem ep = new ExpectedProblem("Test", "Type mismatch: cannot convert from Object[] to String", testPath);
        this.expectingOnlySpecificProblemFor(testPath, ep);
        ExceptionHandlingTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testPrimitiveForArrayValue() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath testPath = env.addClass(srcRoot, "test", "Test", ExceptionHandlingTests.getCodeForTest("arrValue = 'c'"));
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemFor(testPath, new ExpectedProblem("Test", "Type mismatch: cannot convert from char to String[]", testPath));
        ExceptionHandlingTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testNonArrayForArrayValue() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath testPath = env.addClass(srcRoot, "test", "Test", ExceptionHandlingTests.getCodeForTest("arrValue = new Object()"));
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemFor(testPath, new ExpectedProblem("Test", "Type mismatch: cannot convert from Object to String[]", testPath));
        ExceptionHandlingTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testAnnotationForEnumArrayValue() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath testPath = env.addClass(srcRoot, "test", "Test", ExceptionHandlingTests.getCodeForTest("enumsValue = @ExceptionHandlingAnnotation()"));
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemFor(testPath, new ExpectedProblem("Test", "Type mismatch: cannot convert from ExceptionHandlingAnnotation to ExceptionHandlingAnnotation.EHAEnum[]", testPath));
        ExceptionHandlingTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    private static String getCodeForTest(String annoValue) {
        return "package test;\nimport org.eclipse.jdt.apt.tests.annotations.exceptionhandling.ExceptionHandlingAnnotation;\n@ExceptionHandlingAnnotation(" + annoValue + ")" + "\n" + "public class Test" + "\n" + "{" + "\n" + "}";
    }
}

