/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.tests.builder.Problem;

public class ExpectedProblem {
    private final String _location;
    private final String _message;
    private final IPath _resourcePath;
    private final int _start;
    private final int _end;

    public ExpectedProblem(String location, String message, IPath resourcePath) {
        this(location, message, resourcePath, -1, -1);
    }

    public ExpectedProblem(String location, String message, IPath resourcePath, int start, int end) {
        this._location = location;
        this._message = message;
        this._resourcePath = resourcePath;
        this._start = start;
        this._end = end;
    }

    public String getLocation() {
        return this._location;
    }

    public boolean equalsProblem(Problem problem) {
        if (problem == null) {
            return false;
        }
        if (!this._message.equals(problem.getMessage())) {
            return false;
        }
        if (!this._resourcePath.equals((Object)problem.getResourcePath())) {
            return false;
        }
        if (this._start != -1 && this._start != problem.getStart()) {
            return false;
        }
        return this._end == -1 || this._end == problem.getEnd();
    }

    public String toString() {
        return "Problem : " + this._message + " [ resource : <" + this._resourcePath + ">" + " range : <" + this._start + "," + this._end + ">" + "]";
    }
}

