/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.annotations.ProcessorTestStatus;
import org.eclipse.jdt.apt.tests.annotations.filegen.TextGenAnnotationProcessor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class FileGenerationTests
extends APTTestBase {
    public FileGenerationTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(FileGenerationTests.class);
    }

    public void testSourceGenPackages() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.filegen.FileGenLocationAnnotation;\n@FileGenLocationAnnotation\npublic class Test\n{\n}";
        env.addClass(srcRoot, "test", "Test", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FileGenerationTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testSourceGenOverwrite() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.filegen.FirstGenAnnotation;\n@FirstGenAnnotation\npublic class Test\n{\n}";
        env.addClass(srcRoot, "test", "Test", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FileGenerationTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testSourceGenAfterDirChange() throws Exception {
        IJavaProject jproj = env.getJavaProject(this.getProjectName());
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\n@HelloWorldAnnotation\npublic class Test\n{\n\tgeneratedfilepackage.GeneratedFileTest gft;\n}";
        AptConfig.setGenSrcDir((IJavaProject)jproj, (String)"__foo_src");
        env.addClass(srcRoot, "test", "Test", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        Map options = AptConfig.getProcessorOptions((IJavaProject)jproj, (boolean)false);
        String sourcepath = (String)options.get("-sourcepath");
        FileGenerationTests.assertTrue((boolean)sourcepath.contains("__foo_src"));
        FileGenerationTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testSourceGenSubDir() throws Exception {
        IJavaProject jproj = env.getJavaProject(this.getProjectName());
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\n@HelloWorldAnnotation\npublic class Test\n{\n\tgeneratedfilepackage.GeneratedFileTest gft;\n}";
        AptConfig.setGenSrcDir((IJavaProject)jproj, (String)"gen/foo");
        env.addClass(srcRoot, "test", "Test", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FileGenerationTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testTextFileGen() throws Exception {
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            return;
        }
        this.clearProcessorResult(TextGenAnnotationProcessor.class);
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.filegen.TextGenAnnotation;\n@TextGenAnnotation(\"TextFile.txt\")\npublic class Test\n{\n}";
        env.addClass(srcRoot, "test", "Test", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        Map options = AptConfig.getProcessorOptions((IJavaProject)JavaCore.create((IProject)project), (boolean)false);
        String outputRootPath = (String)options.get("-d");
        File theFile = new File(new File(outputRootPath), "TextFile.txt");
        FileGenerationTests.assertTrue((String)("File was not found: " + theFile.getAbsolutePath()), (boolean)theFile.exists());
        this.incrementalBuild(project.getFullPath());
        this.expectingNoProblems();
        this.checkProcessorResult(TextGenAnnotationProcessor.class);
        FileGenerationTests.assertTrue((String)("File was not found: " + theFile.getAbsolutePath()), (boolean)theFile.exists());
        code = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.filegen.TextGenAnnotation;\n@TextGenAnnotation(\">.txt\")\npublic class Test\n{\n}";
        env.addClass(srcRoot, "test", "Test", code);
        this.incrementalBuild(project.getFullPath());
        this.expectingNoProblems();
        FileGenerationTests.assertEquals((String)"Could not generate text file due to IOException", (String)this.getProcessorResult(TextGenAnnotationProcessor.class));
        FileGenerationTests.assertTrue((String)("File was found, but should be deleted: " + theFile.getAbsolutePath()), (!theFile.exists() ? 1 : 0) != 0);
        code = "package test;\npublic class Test\n{\n}";
        env.addClass(srcRoot, "test", "Test", code);
        this.incrementalBuild(project.getFullPath());
        this.expectingNoProblems();
        FileGenerationTests.assertEquals(null, (String)this.getProcessorResult(TextGenAnnotationProcessor.class));
        FileGenerationTests.assertTrue((String)("File was found, but should be deleted: " + theFile.getAbsolutePath()), (!theFile.exists() ? 1 : 0) != 0);
    }

    public void testIsGeneratedOrParentFile() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.filegen.FileGenLocationAnnotation;\n@FileGenLocationAnnotation\npublic class Test\n{\n}";
        env.addClass(srcRoot, "test", "Test", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        AptProject aptProj = new AptProject(env.getJavaProject(this.getProjectName()));
        GeneratedFileManager gfm = aptProj.getGeneratedFileManager(false);
        String genSrcDir = AptConfig.getGenSrcDir((IJavaProject)env.getJavaProject(this.getProjectName()));
        String P = File.separator;
        IFile parentFile = project.getFile("src" + P + "test" + P + "Test.java");
        IFile generatedFile = project.getFile(String.valueOf(genSrcDir) + P + "test" + P + "A.java");
        FileGenerationTests.assertTrue((String)"expected src/test/Test.java to be designated as parent file", (boolean)gfm.isParentFile(parentFile));
        FileGenerationTests.assertTrue((String)"expected .apt_generated/test/A.java to be designated as generated file", (boolean)gfm.isGeneratedFile(generatedFile));
    }

    public void testTestSourceGen() throws Exception {
        IJavaProject jproj = env.getJavaProject(this.getProjectName());
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String mainCode = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\n@HelloWorldAnnotation(\"GeneratedFileMain\")\npublic class Main\n{\n\tgeneratedfilepackage.GeneratedFileMain gfm;\n}";
        String testCode = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\n@HelloWorldAnnotation\npublic class Test\n{\n\tgeneratedfilepackage.GeneratedFileTest gft;\n\tgeneratedfilepackage.GeneratedFileMain gfm;\n}";
        AptConfig.setGenSrcDir((IJavaProject)jproj, (String)"__main_foo_src");
        AptConfig.setGenTestSrcDir((IJavaProject)jproj, (String)"__test_foo_src");
        IPath testSrcRoot = this.addTestSourceFolder();
        env.addClass(srcRoot, "test", "Main", mainCode);
        env.addClass(testSrcRoot, "test", "Test", testCode);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FileGenerationTests.assertTrue((boolean)((String)AptConfig.getProcessorOptions((IJavaProject)jproj, (boolean)false).get("-sourcepath")).contains("__main_foo_src"));
        FileGenerationTests.assertTrue((boolean)((String)AptConfig.getProcessorOptions((IJavaProject)jproj, (boolean)true).get("-sourcepath")).contains("__test_foo_src"));
        FileGenerationTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
        String P = File.separator;
        AptProject aptProj = new AptProject(env.getJavaProject(this.getProjectName()));
        GeneratedFileManager maingfm = aptProj.getGeneratedFileManager(false);
        GeneratedFileManager testgfm = aptProj.getGeneratedFileManager(true);
        IFile mainParentFile = project.getFile("src" + P + "test" + P + "Main.java");
        IFile mainGeneratedFile = project.getFile("__main_foo_src" + P + "generatedfilepackage" + P + "GeneratedFileMain.java");
        IFile testParentFile = project.getFile("src-tests" + P + "test" + P + "Test.java");
        IFile testGeneratedFile = project.getFile("__test_foo_src" + P + "generatedfilepackage" + P + "GeneratedFileTest.java");
        FileGenerationTests.assertTrue((String)("expected " + mainParentFile.getProjectRelativePath() + " to be designated as main parent file"), (boolean)maingfm.isParentFile(mainParentFile));
        FileGenerationTests.assertTrue((String)("expected " + mainGeneratedFile.getProjectRelativePath() + " to be designated as main generated file"), (boolean)maingfm.isGeneratedFile(mainGeneratedFile));
        FileGenerationTests.assertFalse((String)("expected " + testParentFile.getProjectRelativePath() + " not to be designated as main parent file"), (boolean)maingfm.isParentFile(testParentFile));
        FileGenerationTests.assertFalse((String)("expected " + testGeneratedFile.getProjectRelativePath() + " not to be designated as main generated file"), (boolean)maingfm.isGeneratedFile(testGeneratedFile));
        FileGenerationTests.assertTrue((String)("expected " + testParentFile.getProjectRelativePath() + " to be designated as test parent file"), (boolean)testgfm.isParentFile(testParentFile));
        FileGenerationTests.assertTrue((String)("expected " + testGeneratedFile.getProjectRelativePath() + " to be designated as test generated file"), (boolean)testgfm.isGeneratedFile(testGeneratedFile));
        FileGenerationTests.assertFalse((String)("expected " + mainParentFile.getProjectRelativePath() + " not to be designated as test parent file"), (boolean)testgfm.isParentFile(mainParentFile));
        FileGenerationTests.assertFalse((String)("expected " + mainGeneratedFile.getProjectRelativePath() + " not to be designated as test generated file"), (boolean)testgfm.isGeneratedFile(mainGeneratedFile));
    }
}

