/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.zip.ZipInputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;

public class PerfTests
extends BuilderTests {
    private IPath projectPath;

    public PerfTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PerfTests.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        IWorkspace ws = env.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IPath path = root.getLocation();
        File destRoot = path.toFile();
        URL platformURL = Platform.getBundle((String)"org.eclipse.jdt.core.tests.binaries").getEntry("/");
        File f = new File(FileLocator.toFileURL((URL)platformURL).getFile());
        f = new File(f, "perf-test-project.zip");
        FileInputStream in = new FileInputStream(f);
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            TestUtil.unzip(zipIn, destRoot);
        }
        this.projectPath = env.addProject("org.eclipse.jdt.core", "1.4");
        System.out.println("Performing full build...");
        this.fullBuild(this.projectPath);
        System.out.println("Completed build.");
        this.assertNoUnexpectedProblems();
    }

    private void assertNoUnexpectedProblems() {
        Problem[] problems;
        Problem[] problemArray = problems = env.getProblems();
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (!(problem.getMessage().startsWith("TODO") || problem.getMessage().startsWith("XXX") || problem.getMessage().startsWith("FIXME") || problem.getMessage().equals("The type IWorkingCopy is deprecated"))) {
                PerfTests.fail((String)("Found unexpected problem: " + problem));
            }
            ++n2;
        }
    }

    public static String getProjectName() {
        return String.valueOf(PerfTests.class.getName()) + "Project";
    }

    public IPath getSourcePath() {
        IProject project = env.getProject(PerfTests.getProjectName());
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        return srcRoot;
    }

    public void testBuilding() throws Throwable {
        IProject proj = env.getProject(this.projectPath);
        IJavaProject jproj = JavaCore.create((IProject)proj);
        this.assertNoUnexpectedProblems();
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)false);
        proj.build(15, null);
        this.assertNoUnexpectedProblems();
        System.out.println("Performing full build without apt...");
        long start = System.currentTimeMillis();
        proj.build(6, null);
        long totalWithoutAPT = System.currentTimeMillis() - start;
        System.out.println("Completed full build without APT in " + totalWithoutAPT + "ms.");
        this.assertNoUnexpectedProblems();
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
        proj.build(15, null);
        this.assertNoUnexpectedProblems();
        System.out.println("Performing full build with apt...");
        start = System.currentTimeMillis();
        proj.build(6, null);
        long totalWithAPT = System.currentTimeMillis() - start;
        System.out.println("Completed full build with APT in " + totalWithAPT + "ms.");
        this.assertNoUnexpectedProblems();
        if ((double)totalWithAPT > (double)totalWithoutAPT * 1.15) {
            PerfTests.fail((String)"APT performance degradation greater than 15%");
        }
    }
}

