/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.tests.util.Util;

public class ScalingTests
extends APTTestBase {
    private final boolean VERBOSE = true;

    public ScalingTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ScalingTests.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testGeneratingLotsOfFiles() throws Exception {
        String projName = String.valueOf(ScalingTests.class.getName()) + "LotsOfFilesProject";
        IPath projectPath = env.addProject(projName, "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        TestUtil.createAndAddAnnotationJar(env.getJavaProject(projectPath));
        IProject project = env.getProject(projName);
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        String template = "package p;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\n@HelloWorldAnnotation(\"Generated%05d\")\npublic class Test%05d { generatedfilepackage.Generated%05d _t; }";
        int i = 1;
        while (i <= 4000) {
            String name = String.format("Test%05d", i);
            String contents = String.format(template, i, i, 4000 - i + 1);
            env.addClass(srcRoot, "p", name, contents);
            if (i % 200 == 0) {
                System.out.println("Created " + i + " files; pausing for indexer");
                Thread.sleep(2000L);
            }
            ++i;
        }
        System.out.println("Done creating source files");
        IJavaProject jproj = env.getJavaProject(projName);
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
        long start = System.currentTimeMillis();
        this.fullBuild(project.getFullPath());
        System.out.println("Done with build after " + (System.currentTimeMillis() - start) / 1000L + " sec");
        this.expectingNoProblems();
        IPath projPath = jproj.getProject().getLocation();
        int i2 = 1;
        while (i2 <= 4000) {
            String genFileName = String.format(".apt_generated/generatedfilepackage/Generated%05d.java", i2);
            File genFile = new File(projPath.append(genFileName).toOSString());
            ScalingTests.assertTrue((String)("Expected generated source file " + genFileName + " was not found"), (genFile != null && genFile.exists() ? 1 : 0) != 0);
            String genClassName = String.format("bin/generatedfilepackage/Generated%05d.class", i2);
            File genClass = new File(projPath.append(genClassName).toOSString());
            ScalingTests.assertTrue((String)("Compiled file " + genClassName + " was not found"), (genClass != null && genClass.exists() ? 1 : 0) != 0);
            ++i2;
        }
        System.out.println("Done checking output");
        Util.delete((IResource)project);
    }
}

