/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.compiler.tool.tests;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.compiler.regression.BatchCompilerTest;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompiler;

public class AbstractCompilerToolTest
extends BatchCompilerTest {
    static EclipseCompiler COMPILER = new EclipseCompiler();
    static JavaCompiler JAVAC_COMPILER = ToolProvider.getSystemJavaCompiler();

    public AbstractCompilerToolTest(String name) {
        super(name);
    }

    protected boolean invokeCompiler(PrintWriter out, PrintWriter err, Object extraArguments, AbstractBatchCompilerTest.TestCompilationProgress compilationProgress) {
        boolean bl;
        CompilerInvocationTestsArguments arguments = (CompilerInvocationTestsArguments)extraArguments;
        StandardJavaFileManager manager = arguments.standardJavaFileManager;
        boolean ownsManager = false;
        if (manager == null) {
            manager = COMPILER.getStandardFileManager(null, null, null);
            ownsManager = true;
        }
        try {
            ArrayList<File> files = new ArrayList<File>();
            String[] fileNames = arguments.fileNames;
            int i = 0;
            int l = fileNames.length;
            while (i < l) {
                if (fileNames[i].startsWith(OUTPUT_DIR)) {
                    files.add(new File(fileNames[i]));
                } else {
                    files.add(new File(String.valueOf(OUTPUT_DIR) + File.separator + fileNames[i]));
                }
                ++i;
            }
            JavaCompiler.CompilationTask task = COMPILER.getTask((Writer)out, (JavaFileManager)arguments.standardJavaFileManager, (DiagnosticListener)new CompilerInvocationDiagnosticListener(err), arguments.options, null, manager.getJavaFileObjectsFromFiles(files));
            bl = task.call();
        }
        catch (Throwable throwable) {
            try {
                if (ownsManager) {
                    manager.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (ownsManager) {
                manager.close();
            }
        }
        catch (IOException iOException) {}
        return bl;
    }

    static class CompilerInvocationDiagnosticListener
    implements DiagnosticListener<JavaFileObject> {
        public static final int NONE = 0;
        public static final int ERROR = 1;
        public static final int INFO = 2;
        public static final int WARNING = 4;
        private PrintWriter err;
        public int kind;

        public CompilerInvocationDiagnosticListener(PrintWriter err) {
            this.err = err;
            this.kind = 0;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.err.println(diagnostic);
            if (this.kind == 0) {
                switch (diagnostic.getKind()) {
                    case ERROR: {
                        this.kind = 1;
                        break;
                    }
                    case WARNING: 
                    case MANDATORY_WARNING: {
                        this.kind = 4;
                        break;
                    }
                    case NOTE: 
                    case OTHER: {
                        this.kind = 2;
                    }
                }
            }
        }
    }

    static class CompilerInvocationTestsArguments {
        StandardJavaFileManager standardJavaFileManager;
        List<String> options;
        String[] fileNames;

        CompilerInvocationTestsArguments(StandardJavaFileManager standardJavaFileManager, List<String> options, String[] fileNames) {
            this.standardJavaFileManager = standardJavaFileManager;
            this.options = options;
            this.fileNames = fileNames;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            for (String option : this.options) {
                result.append(option);
                result.append(' ');
            }
            return result.toString();
        }
    }
}

