/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;
import org.junit.Assert;
import org.junit.internal.ArrayComparisonFailure;

public class Bug530366Test
extends BuilderTests {
    private IPath project;
    private IPath src;
    private IPath somePackage;

    public Bug530366Test(String name) {
        super(name);
    }

    public static Test suite() {
        return Bug530366Test.buildTestSuite(Bug530366Test.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.project = env.addProject("TestProjectBug530366");
        env.addExternalJars(this.project, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(this.project, "");
        this.src = env.addPackageFragmentRoot(this.project, "src");
        this.somePackage = env.addPackage(this.src, "somepackage");
    }

    @Override
    protected void tearDown() throws Exception {
        env.removeProject(this.project);
        super.tearDown();
    }

    public void testBug530366() throws Exception {
        this.defineNestingClass("MyClass1");
        this.fullBuild();
        this.expectingNoProblems();
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject("TestProjectBug530366");
        IFile myClass1InnerClass = testProject.getFile("bin/somepackage/MyClass1$InnerClass.class");
        URI compilationArtifactUri = myClass1InnerClass.getLocationURI();
        byte[] expectedContents = Files.readAllBytes(Paths.get(compilationArtifactUri));
        String sourceName = "MyClass2";
        String className = "MyClass1";
        IPath myClass2 = this.defineNestingClass(sourceName, className);
        this.incrementalBuild();
        this.expectProblems(myClass2);
        byte[] actualContents = Files.readAllBytes(Paths.get(compilationArtifactUri));
        this.assertEqualContents(expectedContents, actualContents);
        this.redefineNestingClass("MyClass2");
        this.incrementalBuild();
        this.expectingNoProblems();
        Bug530366Test.assertTrue((String)"Java builder removed compilation artifact, but should not have", (boolean)myClass1InnerClass.exists());
    }

    private IPath redefineNestingClass(String className) {
        env.removeClass(this.somePackage, className);
        return this.defineNestingClass(className);
    }

    private IPath defineNestingClass(String className) {
        return this.defineNestingClass(className, className);
    }

    private IPath defineNestingClass(String sourceName, String className) {
        String classContents = String.join((CharSequence)"\n", "package somepackage;", "", "public class " + className + " {", "", "    public static class InnerClass {}", "}");
        IPath source = env.addClass(this.src, "somepackage", sourceName, classContents);
        return source;
    }

    private void expectProblems(IPath myClass2) {
        Problem mismatchedSource = new Problem("", "The public type MyClass1 must be defined in its own file", myClass2, 35, 43, 40, 2);
        Problem alreadyDefined = new Problem("", "The type MyClass1 is already defined", myClass2, 35, 43, -1, 2);
        Problem[] expectedProblems = new Problem[]{mismatchedSource, alreadyDefined};
        this.expectingOnlySpecificProblemsFor(myClass2, expectedProblems);
    }

    private void assertEqualContents(byte[] expectedContents, byte[] actualContents) throws ArrayComparisonFailure {
        String failMessage = String.join((CharSequence)System.lineSeparator(), "Java builder overwrote existing class file, but should not have", "expected class file contents: ", new String(expectedContents), "actual class file contents: ", new String(actualContents));
        Assert.assertArrayEquals((String)failMessage, (byte[])expectedContents, (byte[])actualContents);
    }
}

