/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.ParticipantBuildTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.builder.TestBuilderParticipant;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;

public class Bug531382Test
extends BuilderTests {
    private IPath project;
    private IPath src;
    private IPath srcPackage;
    private int previousLimit;

    public Bug531382Test(String name) {
        super(name);
    }

    public static Test suite() {
        return Bug531382Test.buildTestSuite(Bug531382Test.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.project = env.addProject("TestProjectBug531382");
        env.addExternalJars(this.project, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(this.project, "");
        this.src = env.addPackageFragmentRoot(this.project, "src");
        this.srcPackage = env.addPackage(this.src, "p");
        this.previousLimit = AbstractImageBuilder.MAX_AT_ONCE;
        AbstractImageBuilder.MAX_AT_ONCE = 42;
    }

    @Override
    protected void tearDown() throws Exception {
        TestBuilderParticipant.PARTICIPANT = null;
        AbstractImageBuilder.MAX_AT_ONCE = this.previousLimit;
        env.removeProject(this.project);
        super.tearDown();
    }

    public void testBug531382() throws Exception {
        IFolder srcPackageFolder = env.getWorkspace().getRoot().getFolder(this.srcPackage);
        Bug531382Test.assertTrue((String)"package in source must exist", (boolean)srcPackageFolder.exists());
        int i = 0;
        while (i < AbstractImageBuilder.MAX_AT_ONCE) {
            env.addClass(this.src, "p", "X" + i, "package p;\n public class X" + i + " {}");
            ++i;
        }
        IFile generatedFile = srcPackageFolder.getFile("Generated.java");
        class GenerateBrokenSource
        extends ParticipantBuildTests.BuildTestParticipant {
            private final /* synthetic */ IFile val$generatedFile;

            GenerateBrokenSource(IFile iFile) {
                this.val$generatedFile = iFile;
            }

            public void buildStarting(BuildContext[] files, boolean isBatch) {
                if (files.length > 0 && !this.val$generatedFile.exists()) {
                    BuildContext context = files[0];
                    Bug531382Test.this.createFile(this.val$generatedFile, "package p;\n public class NameMismatch {}");
                    IFile[] generatedFiles = new IFile[]{this.val$generatedFile};
                    context.recordAddedGeneratedFiles(generatedFiles);
                }
            }
        }
        new GenerateBrokenSource(generatedFile);
        Bug531382Test.assertFalse((String)"source to be generated from build participant should not exist before build", (boolean)generatedFile.exists());
        this.fullBuild(this.project);
        Bug531382Test.assertTrue((String)"expected source to be generated from build participant", (boolean)generatedFile.exists());
        this.expectCompileProblem("The public type NameMismatch must be defined in its own file");
    }

    protected void createFile(IFile generatedFile, String contents) {
        boolean force = true;
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            generatedFile.create((InputStream)new ByteArrayInputStream(contents.getBytes()), force, (IProgressMonitor)monitor);
            generatedFile.setDerived(true, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            throw new AssertionError("failed to generate file in build participant", e);
        }
    }

    private void expectCompileProblem(String expectedProblemMessage) {
        ArrayList<String> actualProblemMessages = new ArrayList<String>();
        Problem[] problems = env.getProblemsFor(this.project, "org.eclipse.jdt.core.tests.compile.problem");
        if (problems != null) {
            Problem[] problemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                Problem problem = problemArray[n2];
                actualProblemMessages.add(problem.getMessage());
                ++n2;
            }
        }
        List<String> expectedProblemMessages = Arrays.asList(expectedProblemMessage);
        Bug531382Test.assertEquals((String)"expected build participant to cause compile problems", expectedProblemMessages, actualProblemMessages);
    }
}

