/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Util;

public class BuildpathTests
extends BuilderTests {
    public BuildpathTests(String name) {
        super(name);
    }

    public static Test suite() {
        return BuildpathTests.buildTestSuite(BuildpathTests.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    private String getJdkLevelProblem(String expectedRuntime, String path, int severity) {
        Object target = JavaModel.getTarget((IPath)new Path(path).makeAbsolute(), (boolean)true);
        long libraryJDK = Util.getJdkLevel((Object)target);
        String jclRuntime = CompilerOptions.versionFromJdkLevel((long)libraryJDK);
        StringBuffer jdkLevelProblem = new StringBuffer("Problem : Incompatible .class files version in required binaries. Project 'Project' is targeting a ");
        jdkLevelProblem.append(expectedRuntime);
        jdkLevelProblem.append(" runtime, but is compiled against '");
        jdkLevelProblem.append(path);
        jdkLevelProblem.append("' which requires a ");
        jdkLevelProblem.append(jclRuntime);
        jdkLevelProblem.append(" runtime [ resource : </Project> range : <-1,-1> category : <10> severity : <");
        jdkLevelProblem.append(severity);
        jdkLevelProblem.append(">]");
        return jdkLevelProblem.toString();
    }

    public void testClasspathFileChange() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.addExternalJars(projectPath, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "bin");
        IPath classTest1 = env.addClass(root, "p1", "Test1", "package p1;\npublic class Test1 extends Zork1 {}");
        IPath src2Path = env.addFolder(projectPath, "src2");
        IPath src2p1Path = env.addFolder(src2Path, "p1");
        env.addFile(src2p1Path, "Zork1.java", "package p1;\npublic class Zork1 {}");
        this.fullBuild();
        this.expectingSpecificProblemFor(classTest1, new Problem("src", "Zork1 cannot be resolved to a type", classTest1, 39, 44, 40, 2));
        StringBuffer buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<classpath>\n");
        buffer.append("    <classpathentry kind=\"src\" path=\"src\"/>\n");
        buffer.append("    <classpathentry kind=\"src\" path=\"src2\"/>\n");
        String[] classlibs = org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs();
        int i = 0;
        while (i < classlibs.length) {
            buffer.append("    <classpathentry kind=\"lib\" path=\"").append(classlibs[i]).append("\"/>\n");
            ++i;
        }
        buffer.append("    <classpathentry kind=\"output\" path=\"bin\"/>\n");
        buffer.append("</classpath>");
        boolean wasAutoBuilding = env.isAutoBuilding();
        try {
            env.setAutoBuilding(true);
            env.addFile(projectPath, ".classpath", buffer.toString());
            env.waitForAutoBuild();
            this.expectingNoProblems();
        }
        finally {
            env.setAutoBuilding(wasAutoBuilding);
        }
    }

    public void testClosedProject() throws JavaModelException, IOException {
        IPath project1Path = env.addProject("CP1");
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("CP1");
        env.addExternalJars(project1Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        String jarFile = String.valueOf(project1.getLocation().toOSString()) + File.separator + "temp.jar";
        org.eclipse.jdt.core.tests.util.Util.createEmptyJar((String)jarFile, (String)"1.4");
        IPath jarPath = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(jarFile);
            int length = fis.available();
            byte[] jarContent = new byte[length];
            fis.read(jarContent);
            jarPath = env.addInternalJar(project1Path, "temp.jar", jarContent);
        }
        IPath project2Path = env.addProject("CP2");
        env.addExternalJars(project2Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        IPath project3Path = env.addProject("CP3");
        env.addExternalJars(project3Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.addExternalJar(project3Path, jarPath.toString());
        this.fullBuild();
        this.expectingNoProblems();
        env.closeProject(project1Path);
        this.incrementalBuild();
        this.expectingOnlyProblemsFor(new IPath[]{project2Path, project3Path});
        this.expectingOnlySpecificProblemsFor(project2Path, new Problem[]{new Problem("", "The project cannot be built until build path errors are resolved", project2Path, -1, -1, 10, 2), new Problem("Build path", "Project 'CP2' is missing required Java project: 'CP1'", project2Path, -1, -1, 10, 2)});
        this.expectingOnlySpecificProblemsFor(project3Path, new Problem[]{new Problem("", "The project cannot be built until build path errors are resolved", project3Path, -1, -1, 10, 2), new Problem("Build path", "Project 'CP3' is missing required library: '/CP1/temp.jar'", project3Path, -1, -1, 10, 2)});
        env.openProject(project1Path);
        this.incrementalBuild();
        this.expectingNoProblems();
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
        JavaCore.setOptions((Hashtable)options);
        env.closeProject(project1Path);
        env.waitForManualRefresh();
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingOnlyProblemsFor(new IPath[]{project2Path, project3Path});
        this.expectingOnlySpecificProblemFor(project2Path, new Problem("Build path", "Project 'CP2' is missing required Java project: 'CP1'", project2Path, -1, -1, 10, 2));
        this.expectingOnlySpecificProblemFor(project3Path, new Problem("Build path", "Project 'CP3' is missing required library: '/CP1/temp.jar'", project3Path, -1, -1, 10, 2));
        env.openProject(project1Path);
        this.incrementalBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
    }

    public void testCorruptBuilder() throws JavaModelException {
        IPath project1Path = env.addProject("P1");
        env.addExternalJars(project1Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.addClass(project1Path, "p", "Test", "package p;public class Test {}");
        this.fullBuild();
        this.expectingNoProblems();
        IPath outputFolderPackage = env.getOutputLocation(project1Path).append("p");
        env.removeBinaryClass(outputFolderPackage, "Test");
        IPath subTest = env.addClass(project1Path, "", "SubTest", "public class SubTest extends p.Test {}");
        this.incrementalBuild();
        this.expectingOnlySpecificProblemFor(subTest, new Problem("", "p.Test cannot be resolved to a type", subTest, 29, 35, 40, 2));
        env.addClass(project1Path, "p", "Test", "package p;public class Test {}");
        this.fullBuild();
        this.expectingNoProblems();
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.builder.recreateModifiedClassFileInOutputFolder", "enabled");
        JavaCore.setOptions((Hashtable)options);
        env.removeBinaryClass(outputFolderPackage, "Test");
        env.waitForManualRefresh();
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
    }

    public void testCorruptBuilder2() throws JavaModelException {
        IPath project1Path = env.addProject("P2");
        env.addExternalJars(project1Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.removePackageFragmentRoot(project1Path, "");
        IPath src = env.addPackageFragmentRoot(project1Path, "src");
        IPath bin = env.setOutputFolder(project1Path, "bin");
        env.addClass(src, "p", "Test", "package p;public class Test {}");
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        IPath outputFolderPackage = bin.append("p");
        env.removeBinaryClass(outputFolderPackage, "Test");
        IPath subTest = env.addClass(src, "p2", "SubTest", "package p2;public class SubTest extends p.Test {}");
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingOnlySpecificProblemFor(subTest, new Problem("", "p.Test cannot be resolved to a type", subTest, 40, 46, 40, 2));
        env.addClass(src, "p", "Test", "package p;public class Test {}");
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.builder.recreateModifiedClassFileInOutputFolder", "enabled");
        JavaCore.setOptions((Hashtable)options);
        env.removeBinaryClass(outputFolderPackage, "Test");
        env.waitForManualRefresh();
        this.incrementalBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
    }

    public void testChangeExternalFolder() throws CoreException {
        String externalLib = String.valueOf(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()) + File.separator + "externalLib";
        IPath projectPath = env.addProject("Project");
        try {
            new File(externalLib).mkdirs();
            org.eclipse.jdt.core.tests.util.Util.compile((String[])new String[]{"p/X.java", "package p;\npublic class X {\n  public void foo() {\n  }\n}"}, new HashMap(), (String)externalLib);
            env.addExternalJars(projectPath, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
            env.addExternalFolders(projectPath, new String[]{externalLib});
            IPath root = env.getPackageFragmentRootPath(projectPath, "");
            env.setOutputFolder(projectPath, "");
            IPath classY = env.addClass(root, "q", "Y", "package q;\npublic class Y {\n  void bar(p.X x) {\n    x.foo();\n  }\n}");
            this.fullBuild(projectPath);
            env.waitForAutoBuild();
            this.expectingNoProblems();
            String externalClassFile = String.valueOf(externalLib) + File.separator + "p" + File.separator + "X.class";
            long lastModified = new File(externalClassFile).lastModified();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            org.eclipse.jdt.core.tests.util.Util.compile((String[])new String[]{"p/X.java", "package p;\npublic class X {\n}"}, new HashMap(), (String)externalLib);
            new File(externalClassFile).setLastModified(lastModified + 1000L);
            env.getProject(projectPath).refreshLocal(2, null);
            env.waitForManualRefresh();
            this.incrementalBuild(projectPath);
            env.waitForAutoBuild();
            this.expectingProblemsFor(classY, "Problem : The method foo() is undefined for the type X [ resource : </Project/q/Y.java> range : <54,57> category : <50> severity : <2>]");
        }
        finally {
            new File(externalLib).delete();
            env.removeProject(projectPath);
        }
    }

    public void testChangeZIPArchive1() throws Exception {
        String externalLib = String.valueOf(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()) + File.separator + "externalLib.abc";
        IPath projectPath = env.addProject("Project");
        try {
            org.eclipse.jdt.core.tests.util.Util.createJar((String[])new String[]{"p/X.java", "package p;\npublic class X {\n  public void foo() {\n  }\n}"}, (String)externalLib, (String)"1.4");
            env.addExternalJars(projectPath, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
            env.addExternalJars(projectPath, new String[]{externalLib});
            IPath root = env.getPackageFragmentRootPath(projectPath, "");
            env.setOutputFolder(projectPath, "");
            IPath classY = env.addClass(root, "q", "Y", "package q;\npublic class Y {\n  void bar(p.X x) {\n    x.foo();\n  }\n}");
            this.fullBuild(projectPath);
            this.expectingNoProblems();
            org.eclipse.jdt.core.tests.util.Util.createJar((String[])new String[]{"p/X.java", "package p;\npublic class X {\n}"}, (String)externalLib, (String)"1.4");
            IJavaProject p = env.getJavaProject(projectPath);
            p.getJavaModel().refreshExternalArchives(new IJavaElement[]{p}, null);
            this.incrementalBuild(projectPath);
            this.expectingProblemsFor(classY, "Problem : The method foo() is undefined for the type X [ resource : </Project/q/Y.java> range : <54,57> category : <50> severity : <2>]");
        }
        finally {
            new File(externalLib).delete();
            env.removeProject(projectPath);
        }
    }

    public void testChangeZIPArchive2() throws Exception {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        String internalLib = String.valueOf(env.getProject("Project").getLocation().toOSString()) + File.separator + "internalLib.abc";
        org.eclipse.jdt.core.tests.util.Util.createJar((String[])new String[]{"p/X.java", "package p;\npublic class X {\n  public void foo() {\n  }\n}"}, (String)internalLib, (String)"1.4");
        env.getProject(projectPath).refreshLocal(2, null);
        env.addEntry(projectPath, JavaCore.newLibraryEntry((IPath)new Path("/Project/internalLib.abc"), null, null));
        IPath root = env.getPackageFragmentRootPath(projectPath, "");
        env.setOutputFolder(projectPath, "");
        IPath classY = env.addClass(root, "q", "Y", "package q;\npublic class Y {\n  void bar(p.X x) {\n    x.foo();\n  }\n}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        org.eclipse.jdt.core.tests.util.Util.createJar((String[])new String[]{"p/X.java", "package p;\npublic class X {\n}"}, (String)internalLib, (String)"1.4");
        env.getProject(projectPath).refreshLocal(2, null);
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(classY, "Problem : The method foo() is undefined for the type X [ resource : </Project/q/Y.java> range : <54,57> category : <50> severity : <2>]");
        env.removeProject(projectPath);
    }

    public void testExternalJarChange() throws JavaModelException, IOException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        IPath root = env.getPackageFragmentRootPath(projectPath, "");
        IPath classTest = env.addClass(root, "p", "X", "package p;\npublic class X {\n  void foo() {\n    new q.Y().bar();\n  }\n}");
        String externalJar = String.valueOf(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()) + File.separator + "test.jar";
        org.eclipse.jdt.core.tests.util.Util.createJar((String[])new String[]{"q/Y.java", "package q;\npublic class Y {\n}"}, new HashMap(), (String)externalJar);
        env.addExternalJar(projectPath, externalJar);
        this.fullBuild();
        this.expectingProblemsFor(classTest, "Problem : The method bar() is undefined for the type Y [ resource : </Project/p/X.java> range : <57,60> category : <50> severity : <2>]");
        org.eclipse.jdt.core.tests.util.Util.createJar((String[])new String[]{"q/Y.java", "package q;\npublic class Y {\n  public void bar() {\n  }\n}"}, new HashMap(), (String)externalJar);
        IJavaProject project = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject("Project"));
        project.getJavaModel().refreshExternalArchives(new IJavaElement[]{project}, null);
        this.incrementalBuild();
        this.expectingNoProblems();
        env.removeProject(projectPath);
    }

    public void testMissingBuilder() throws JavaModelException {
        IPath project1Path = env.addProject("P1");
        env.addExternalJars(project1Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        IPath project2Path = env.addProject("P2");
        env.addExternalJars(project2Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        env.addClass(project1Path, "", "Test", "public class Test {}");
        IPath sub = env.addClass(project2Path, "", "SubTest", "public class SubTest extends Test {}");
        this.fullBuild();
        this.expectingNoProblems();
        env.removeRequiredProject(project2Path, project1Path);
        this.incrementalBuild();
        this.expectingOnlySpecificProblemFor(sub, new Problem("", "Test cannot be resolved to a type", sub, 29, 33, 40, 2));
        env.addRequiredProject(project2Path, project1Path);
        try {
            JavaProject p = (JavaProject)env.getJavaProject(project1Path);
            p.deconfigure();
            JavaModelManager.getJavaModelManager().setLastBuiltState(p.getProject(), null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        env.addClass(project2Path, "", "SubTest", "public class SubTest extends Test {}");
        this.incrementalBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
        env.removeProject(project2Path);
    }

    public void testMissingFieldType() throws JavaModelException {
        IPath projectPath = env.addProject("Project1");
        env.addExternalJars(projectPath, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        IPath root = env.getPackageFragmentRootPath(projectPath, "");
        env.addClass(root, "p1", "Test", "package p1;\npublic class Test {}");
        this.fullBuild();
        this.expectingNoProblems();
        IPath projectPath2 = env.addProject("Project2");
        env.addExternalJars(projectPath2, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.addRequiredProject(projectPath2, projectPath);
        IPath root2 = env.getPackageFragmentRootPath(projectPath2, "");
        env.addClass(root2, "p2", "Test2", "package p2;\npublic class Test2 {\n\tpublic static p1.Test field;\n}");
        this.incrementalBuild();
        this.expectingNoProblems();
        IPath projectPath3 = env.addProject("Project3");
        env.addExternalJars(projectPath3, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.addRequiredProject(projectPath3, projectPath2);
        IPath root3 = env.getPackageFragmentRootPath(projectPath3, "");
        env.addClass(root3, "p3", "Test3", "package p3;\npublic class Test3 extends p2.Test2 {\n\tstatic Object field;\n}");
        this.incrementalBuild();
        this.expectingNoProblems();
        env.removeProject(projectPath);
    }

    public void testMissingLibrary1() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        IPath classTest1 = env.addClass(root, "p1", "Test1", "package p1;\npublic class Test1 {}");
        this.fullBuild();
        this.expectingOnlyProblemsFor(new IPath[]{projectPath, classTest1});
        this.expectingOnlySpecificProblemsFor(projectPath, new Problem[]{new Problem("", "The project was not built since its build path is incomplete. Cannot find the class file for java.lang.Object. Fix the build path then try building this project", projectPath, -1, -1, 10, 2), new Problem("p1", "The type java.lang.Object cannot be resolved. It is indirectly referenced from required .class files", classTest1, 0, 1, 10, 2)});
        env.addExternalJars(projectPath, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{bin.append("p1").append("Test1.class")});
        env.removeProject(projectPath);
    }

    public void testMissingLibrary2() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        IPath classTest1 = env.addClass(root, "p2", "Test1", "package p2;\npublic class Test1 {}");
        IPath classTest2 = env.addClass(root, "p2", "Test2", "package p2;\npublic class Test2 {}");
        IPath classTest3 = env.addClass(root, "p3", "Test3", "package p3;\npublic class Test3 {}");
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(projectPath, new Problem("", "The project was not built since its build path is incomplete. Cannot find the class file for java.lang.Object. Fix the build path then try building this project", projectPath, -1, -1, 10, 2));
        Problem[] prob1 = env.getProblemsFor(classTest1);
        Problem[] prob2 = env.getProblemsFor(classTest2);
        Problem[] prob3 = env.getProblemsFor(classTest3);
        BuildpathTests.assertEquals((String)"too many problems", (int)(prob1.length + prob2.length + prob3.length), (int)1);
        if (prob1.length == 1) {
            this.expectingSpecificProblemFor(classTest1, new Problem("p2", "The type java.lang.Object cannot be resolved. It is indirectly referenced from required .class files", classTest1, 0, 1, 10, 2));
        } else if (prob2.length == 1) {
            this.expectingSpecificProblemFor(classTest2, new Problem("p2", "The type java.lang.Object cannot be resolved. It is indirectly referenced from required .class files", classTest2, -1, -1, -1, 2));
        } else {
            this.expectingSpecificProblemFor(classTest3, new Problem("p3", "The type java.lang.Object cannot be resolved. It is indirectly referenced from required .class files", classTest3, -1, -1, -1, 2));
        }
        env.addExternalJars(projectPath, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{bin.append("p2").append("Test1.class"), bin.append("p2").append("Test2.class"), bin.append("p3").append("Test3.class")});
        env.removeProject(projectPath);
    }

    public void testMissingLibrary3() throws JavaModelException {
        this.abortOnFailure = false;
        IPath projectPath = env.addProject("Project");
        IJavaProject project = env.getJavaProject(projectPath);
        this.fullBuild();
        this.expectingNoProblems();
        project.setOption("org.eclipse.jdt.core.incompleteClasspath", "warning");
        env.waitForManualRefresh();
        env.addLibrary(projectPath, projectPath.append("/lib/dummy.jar"), null, null);
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(projectPath, new Problem("Build path", "Project 'Project' is missing required library: 'lib/dummy.jar'", projectPath, -1, -1, 10, 1));
        project.setOption("org.eclipse.jdt.core.incompleteClasspath", "error");
        env.waitForManualRefresh();
        IClasspathEntry[] classpath = project.getRawClasspath();
        IPath outputLocation = project.getOutputLocation();
        project.setRawClasspath(null, outputLocation, false, null);
        project.setRawClasspath(classpath, outputLocation, false, null);
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(projectPath, new Problem("", "The project cannot be built until build path errors are resolved", projectPath, -1, -1, 10, 2));
        this.expectingSpecificProblemFor(projectPath, new Problem("Build path", "Project 'Project' is missing required library: 'lib/dummy.jar'", projectPath, -1, -1, 10, 2));
        env.removeProject(projectPath);
    }

    public void testMissingLibrary4() throws JavaModelException {
        this.abortOnFailure = false;
        IPath projectPath = env.addProject("Project");
        IJavaProject project = env.getJavaProject(projectPath);
        this.fullBuild();
        this.expectingNoProblems();
        env.addLibrary(projectPath, projectPath.append("/lib/dummy.jar"), null, null);
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(projectPath, new Problem("", "The project cannot be built until build path errors are resolved", projectPath, -1, -1, 10, 2));
        this.expectingSpecificProblemFor(projectPath, new Problem("Build path", "Project 'Project' is missing required library: 'lib/dummy.jar'", projectPath, -1, -1, 10, 2));
        project.setOption("org.eclipse.jdt.core.incompleteClasspath", "warning");
        env.waitForManualRefresh();
        this.incrementalBuild();
        env.waitForManualRefresh();
        this.expectingSpecificProblemFor(projectPath, new Problem("Build path", "Project 'Project' is missing required library: 'lib/dummy.jar'", projectPath, -1, -1, 10, 1));
        env.removeProject(projectPath);
    }

    public void testIncompatibleJdkLEvelOnProject() throws JavaModelException {
        long libraryJDK;
        Object target;
        String path;
        IPath projectPath = env.addProject("Project");
        IJavaProject project = env.getJavaProject(projectPath);
        Object[] classlibs = org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs();
        env.addExternalJars(projectPath, (String[])classlibs);
        Arrays.sort(classlibs);
        this.fullBuild();
        this.expectingNoProblems();
        String projectRuntime = project.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        project.setOption("org.eclipse.jdt.core.incompatibleJDKLevel", "warning");
        env.waitForManualRefresh();
        this.incrementalBuild();
        env.waitForAutoBuild();
        long projectRuntimeJDKLevel = CompilerOptions.versionToJdkLevel((String)projectRuntime);
        int max = classlibs.length;
        ArrayList<String> expectedProblems = new ArrayList<String>();
        int i = 0;
        while (i < max) {
            path = project.getPackageFragmentRoot((String)classlibs[i]).getPath().makeRelative().toString();
            target = JavaModel.getTarget((IPath)new Path(path).makeAbsolute(), (boolean)true);
            libraryJDK = Util.getJdkLevel((Object)target);
            if (libraryJDK > projectRuntimeJDKLevel) {
                expectedProblems.add(this.getJdkLevelProblem(projectRuntime, path, 1));
            }
            ++i;
        }
        this.expectingProblemsFor(projectPath, expectedProblems);
        project.setOption("org.eclipse.jdt.core.incompatibleJDKLevel", "error");
        env.waitForManualRefresh();
        this.incrementalBuild();
        env.waitForAutoBuild();
        expectedProblems = new ArrayList();
        i = 0;
        while (i < max) {
            path = project.getPackageFragmentRoot((String)classlibs[i]).getPath().makeRelative().toString();
            target = JavaModel.getTarget((IPath)new Path(path).makeAbsolute(), (boolean)true);
            libraryJDK = Util.getJdkLevel((Object)target);
            if (libraryJDK > projectRuntimeJDKLevel) {
                expectedProblems.add(this.getJdkLevelProblem(projectRuntime, path, 2));
            }
            ++i;
        }
        expectedProblems.add("Problem : The project cannot be built until build path errors are resolved [ resource : </Project> range : <-1,-1> category : <10> severity : <2>]");
        this.expectingProblemsFor(projectPath, expectedProblems);
        env.removeProject(projectPath);
    }

    public void testIncompatibleJdkLEvelOnWksp() throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        IEclipsePreferences preferences = manager.getInstancePreferences();
        String incompatibleJdkLevel = preferences.get("org.eclipse.jdt.core.incompatibleJDKLevel", null);
        try {
            long libraryJDK;
            Object target;
            String path;
            IPath projectPath = env.addProject("Project");
            IJavaProject project = env.getJavaProject(projectPath);
            Object[] classlibs = org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs();
            env.addExternalJars(projectPath, (String[])classlibs);
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingNoProblems();
            String wkspRuntime = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            long wkspRuntimeJDKLevel = CompilerOptions.versionToJdkLevel((String)wkspRuntime);
            Arrays.sort(classlibs);
            preferences.put("org.eclipse.jdt.core.incompatibleJDKLevel", "warning");
            env.waitForManualRefresh();
            this.incrementalBuild();
            env.waitForAutoBuild();
            ArrayList<String> expectedProblems = new ArrayList<String>();
            int max = classlibs.length;
            int i = 0;
            while (i < max) {
                path = project.getPackageFragmentRoot((String)classlibs[i]).getPath().makeRelative().toString();
                target = JavaModel.getTarget((IPath)new Path(path).makeAbsolute(), (boolean)true);
                libraryJDK = Util.getJdkLevel((Object)target);
                if (libraryJDK > wkspRuntimeJDKLevel) {
                    expectedProblems.add(this.getJdkLevelProblem(wkspRuntime, path, 1));
                }
                ++i;
            }
            this.expectingProblemsFor(projectPath, expectedProblems);
            preferences.put("org.eclipse.jdt.core.incompatibleJDKLevel", "error");
            env.waitForManualRefresh();
            this.incrementalBuild();
            env.waitForAutoBuild();
            expectedProblems = new ArrayList();
            i = 0;
            while (i < max) {
                path = project.getPackageFragmentRoot((String)classlibs[i]).getPath().makeRelative().toString();
                target = JavaModel.getTarget((IPath)new Path(path).makeAbsolute(), (boolean)true);
                libraryJDK = Util.getJdkLevel((Object)target);
                if (libraryJDK > wkspRuntimeJDKLevel) {
                    expectedProblems.add(this.getJdkLevelProblem(wkspRuntime, path, 2));
                }
                ++i;
            }
            expectedProblems.add("Problem : The project cannot be built until build path errors are resolved [ resource : </Project> range : <-1,-1> category : <10> severity : <2>]");
            this.expectingProblemsFor(projectPath, expectedProblems);
            env.removeProject(projectPath);
        }
        finally {
            if (incompatibleJdkLevel == null) {
                preferences.remove("org.eclipse.jdt.core.incompatibleJDKLevel");
            } else {
                preferences.put("org.eclipse.jdt.core.incompatibleJDKLevel", incompatibleJdkLevel);
            }
        }
    }

    public void testMissingProject() throws JavaModelException {
        IPath project1Path = env.addProject("MP1");
        env.addExternalJars(project1Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        IPath project2Path = env.addProject("MP2");
        env.addExternalJars(project2Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        this.fullBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingOnlyProblemsFor(project2Path);
        this.expectingOnlySpecificProblemsFor(project2Path, new Problem[]{new Problem("", "The project cannot be built until build path errors are resolved", project2Path, -1, -1, 10, 2), new Problem("Build path", "Project 'MP2' is missing required Java project: 'MP1'", project2Path, -1, -1, 10, 2)});
        project1Path = env.addProject("MP1");
        env.addExternalJars(project1Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
        JavaCore.setOptions((Hashtable)options);
        env.waitForManualRefresh();
        env.removeProject(project1Path);
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingOnlyProblemsFor(project2Path);
        this.expectingOnlySpecificProblemFor(project2Path, new Problem("Build path", "Project 'MP2' is missing required Java project: 'MP1'", project2Path, -1, -1, 10, 2));
        project1Path = env.addProject("MP1");
        env.addExternalJars(project1Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
        env.removeProject(project2Path);
    }

    public void testMissingOptionalProject() throws JavaModelException {
        IPath project1Path = env.addProject("MP1");
        env.addExternalJars(project1Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        IPath project2Path = env.addProject("MP2");
        env.addExternalJars(project2Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, true);
        this.fullBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
        this.incrementalBuild();
        this.expectingNoProblems();
        project1Path = env.addProject("MP1");
        env.addExternalJars(project1Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        this.incrementalBuild();
        this.expectingNoProblems();
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
        JavaCore.setOptions((Hashtable)options);
        env.waitForManualRefresh();
        env.removeProject(project1Path);
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        project1Path = env.addProject("MP1");
        env.addExternalJars(project1Path, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        this.incrementalBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
        env.removeProject(project2Path);
    }

    public void test0100() throws JavaModelException {
        if (!AbstractCompilerTest.isJRELevel((int)4)) {
            return;
        }
        IPath projectPath = env.addProject("P", "1.5");
        IPath defaultPackagePath = env.addPackage(projectPath, "");
        env.addExternalJars(projectPath, org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs());
        env.addClass(defaultPackagePath, "X", "public interface X<E extends Object & X.Entry> {\n  interface Entry {\n    interface Internal extends Entry {\n      Internal createEntry();\n    }\n  }\n}");
        this.fullBuild();
        this.expectingNoProblems();
        env.addClass(defaultPackagePath, "Y", "public class Y implements X.Entry.Internal {\n  public Internal createEntry() {\n    return null;\n  }\n}");
        this.incrementalBuild();
        this.expectingNoProblems();
        env.removeProject(projectPath);
    }

    public void testMissingOutputFolder() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        this.fullBuild();
        this.expectingNoProblems();
        env.removeFolder(bin);
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(bin);
        if (!env.getProject(projectPath).getFolder("bin").isDerived()) {
            BuildpathTests.fail((String)"output folder is not derived");
        }
        env.removeProject(projectPath);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

