/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import junit.framework.Test;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.util.Util;

public class EfficiencyTests
extends BuilderTests {
    public EfficiencyTests(String name) {
        super(name);
    }

    public static Test suite() {
        return EfficiencyTests.buildTestSuite(EfficiencyTests.class);
    }

    public void testProjectAsClassFolder() throws JavaModelException {
        IPath projectPath1 = env.addProject("Project1");
        env.addExternalJars(projectPath1, Util.getJavaClassLibs());
        IPath projectPath2 = env.addProject("Project2");
        env.addExternalJars(projectPath2, Util.getJavaClassLibs());
        env.addClassFolder(projectPath2, projectPath1, false);
        env.addClass(projectPath2, "p1", "X", "package p1;\npublic abstract class X {}\n");
        env.addClass(projectPath2, "p2", "Y", "package p2;\npublic class Y {}\n");
        this.fullBuild();
        env.addClass(projectPath2, "p1", "X", "package p1;\npublic class X {}\n");
        this.incrementalBuild(projectPath2);
        this.expectingCompiledClasses(new String[]{"p1.X"});
    }

    public void testEfficiency() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Indicted", "package p1;\npublic abstract class Indicted {\n}\n");
        env.addClass(root, "p2", "Collaborator", "package p2;\nimport p1.*;\npublic class Collaborator extends Indicted{\n}\n");
        this.fullBuild(projectPath);
        env.addClass(root, "p1", "Indicted", "package p1;\npublic abstract class Indicted {\n   public abstract void foo();\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingCompiledClasses(new String[]{"p2.Collaborator", "p1.Indicted"});
        this.expectingCompilingOrder(new String[]{"/Project/src/p1/Indicted.java", "/Project/src/p2/Collaborator.java"});
    }

    public void testMethodAddition() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo() {\t\n\t}\n}\n");
        env.addClass(root, "p2", "Y", "package p2;\nimport p1.*;\npublic class Y extends X{\n}\n");
        env.addClass(root, "p3", "Z", "package p2;\nimport p1.*;\npublic class Z{\n}\n");
        this.fullBuild(projectPath);
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid bar(){}\t\n\tvoid foo() {\t\n\t\t};\t\n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingCompiledClasses(new String[]{"p1.X", "p2.Y"});
        this.expectingCompilingOrder(new String[]{"/Project/src/p1/X.java", "/Project/src/p2/Y.java"});
    }

    public void testLocalTypeAddition() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo() {\t\n\t}\n}\n");
        env.addClass(root, "p2", "Y", "package p2;\nimport p1.*;\npublic class Y extends X{\n}\n");
        env.addClass(root, "p3", "Z", "package p2;\nimport p1.*;\npublic class Z{\n}\n");
        this.fullBuild(projectPath);
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo() {\t\n\t\tnew Object(){\t\n\t\t};\t\n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingCompiledClasses(new String[]{"p1.X", "p1.X$1"});
        this.expectingCompilingOrder(new String[]{"/Project/src/p1/X.java"});
    }

    public void testLocalTypeAddition2() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo() {\t\n\t\tnew X(){\t\n\t\t\tvoid bar(){}\t\n\t\t};\t\n\t}\n}\n");
        env.addClass(root, "p2", "Y", "package p2;\nimport p1.*;\npublic class Y extends X{\n}\n");
        env.addClass(root, "p3", "Z", "package p2;\nimport p1.*;\npublic class Z{\n}\n");
        this.fullBuild(projectPath);
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo() {\t\n\t\tnew Object(){\t\n\t\t};\t\n\t\tnew X(){\t\n\t\t\tvoid bar(){}\t\n\t\t};\t\n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingCompiledClasses(new String[]{"p1.X", "p1.X$1", "p1.X$2"});
        this.expectingCompilingOrder(new String[]{"/Project/src/p1/X.java"});
    }

    public void testLocalTypeRemoval() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo() {\t\n\t\tnew Object(){\t\n\t\t};\t\n\t}\n}\n");
        env.addClass(root, "p2", "Y", "package p2;\nimport p1.*;\npublic class Y extends X{\n}\n");
        env.addClass(root, "p3", "Z", "package p2;\nimport p1.*;\npublic class Z{\n}\n");
        this.fullBuild(projectPath);
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo() {\t\n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingCompiledClasses(new String[]{"p1.X"});
        this.expectingCompilingOrder(new String[]{"/Project/src/p1/X.java"});
    }

    public void testLocalTypeRemoval2() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo() {\t\n\t\tnew Object(){\t\n\t\t};\t\n\t\tnew X(){\t\n\t\t\tvoid bar(){}\t\n\t\t};\t\n\t}\n}\n");
        env.addClass(root, "p2", "Y", "package p2;\nimport p1.*;\npublic class Y extends X{\n}\n");
        env.addClass(root, "p3", "Z", "package p2;\nimport p1.*;\npublic class Z{\n}\n");
        this.fullBuild(projectPath);
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo() {\t\n\t\tnew X(){\t\n\t\t\tvoid bar(){}\t\n\t\t};\t\n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingCompiledClasses(new String[]{"p1.X", "p1.X$1"});
        this.expectingCompilingOrder(new String[]{"/Project/src/p1/X.java"});
    }

    public void testMissingType001() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo(p2.Y y) {\t\n\t\ty.bar(null);\t}\n}\n");
        env.addClass(root, "p2", "Y", "package p2;\npublic class Y {\n\tpublic void bar(Z z) {}\n}\n");
        this.fullBuild(projectPath);
        env.addClass(root, "p2", "Z", "package p2;\npublic class Z {\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingCompiledClasses(new String[]{"p1.X", "p2.Y", "p2.Z"});
        this.expectingCompilingOrder(new String[]{"/Project/src/p2/Z.java", "/Project/src/p2/Y.java", "/Project/src/p1/X.java"});
    }
}

