/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.osgi.framework.Bundle;

public class IncrementalTests18
extends BuilderTests {
    public IncrementalTests18(String name) {
        super(name);
    }

    public static Test suite() {
        return AbstractCompilerTest.buildUniqueComplianceTestSuite(IncrementalTests18.class, (long)0x340000L);
    }

    private void setupProjectForNullAnnotations() throws IOException, JavaModelException {
        Bundle[] bundles = Platform.getBundles((String)"org.eclipse.jdt.annotation", (String)"[2.0.0,3.0.0)");
        File bundleFile = FileLocator.getBundleFile((Bundle)bundles[0]);
        String annotationsLib = bundleFile.isDirectory() ? String.valueOf(bundleFile.getPath()) + "/bin" : bundleFile.getPath();
        IJavaProject javaProject = env.getJavaProject("Project");
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        int len = rawClasspath.length;
        IClasspathEntry[] iClasspathEntryArray = rawClasspath;
        rawClasspath = new IClasspathEntry[len + 1];
        System.arraycopy(iClasspathEntryArray, 0, rawClasspath, 0, len);
        rawClasspath[len] = JavaCore.newLibraryEntry((IPath)new Path(annotationsLib), null, null);
        javaProject.setRawClasspath(rawClasspath, null);
        javaProject.setOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
    }

    public void test423122() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "I", "package p;\t\npublic interface I { void foo(); }\t\n");
        env.addClass(root, "p", "X", "package p;\t\npublic class X { I i = () -> {}; }\t\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p", "I", "package p;\t\npublic interface I { }\t\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : The target type of this expression must be a functional interface [ resource : </Project/src/p/X.java> range : <35,40> category : <40> severity : <2>]");
    }

    public void test423122a() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "test1", "I", "package test1;\npublic interface I {\n    int method(int a); // change argument type to Object\n}\n");
        env.addClass(root, "test1", "E", "package test1;\npublic class E {\n    void take(I i) {\n    }\n}\n");
        env.addClass(root, "test1", "Ref", "package test1;\npublic class Ref {\n    void foo(E e) {\n        e.take((x) -> x+2); // not recompiled when I#method changed\n    }\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "test1", "I", "package test1;\npublic interface I {\n    int method(Object a); // change argument type to Object\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : The operator + is undefined for the argument type(s) Object, int [ resource : </Project/src/test1/Ref.java> range : <76,79> category : <60> severity : <2>]");
        env.addClass(root, "test1", "I", "package test1;\npublic interface I {\n    int method(int a); // change argument type back to int\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void test427105() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "X", "import java.util.List;\npublic class X implements I {\n\tpublic void f(List x, List<I> ls) {                                      \n\t}\n}\n");
        env.addClass(root, "", "I", "import java.util.List;\npublic interface I {\n\tvoid f(@T List x, List<I> ls);\n}\n");
        env.addClass(root, "", "T", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\npublic @interface T {\n}\n");
        env.getJavaProject("Project").setOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.fullBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/I.java> range : <55,59> category : <130> severity : <1>]\nProblem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/X.java> range : <68,72> category : <130> severity : <1>]");
        env.addClass(root, "", "X", "import java.util.List;\npublic class X implements I {\n\tpublic void f(List x, List<I> ls) {                                      \n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/I.java> range : <55,59> category : <130> severity : <1>]\nProblem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/X.java> range : <68,72> category : <130> severity : <1>]");
    }

    public void test427105a() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "X", "import java.util.List;\npublic class X implements I {\n\tpublic void f(List x, List<I> ls) {                                      \n\t}\n}\n");
        env.addClass(root, "", "I", "import java.util.List;\npublic interface I {\n\tvoid f(@T List x, List<I> ls);\n}\n");
        env.addClass(root, "", "T", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\npublic @interface T {\n}\n");
        env.getJavaProject("Project").setOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.fullBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/I.java> range : <55,59> category : <130> severity : <1>]\nProblem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/X.java> range : <68,72> category : <130> severity : <1>]");
        env.addClass(root, "", "X", "import java.util.List;\npublic class X implements I {\n\tpublic void f(@T List x, List<I> ls) {                                      \n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/I.java> range : <55,59> category : <130> severity : <1>]\nProblem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/X.java> range : <71,75> category : <130> severity : <1>]");
    }

    public void test428071() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "K1", "import java.util.List;\nimport java.util.Map;\ninterface K1 {\n\tpublic Map<String,List> get();\n}\n");
        env.addClass(root, "", "K", "import java.util.List;\nimport java.util.Map;\npublic class K implements K1 {\n\tpublic Map<String, List> get() {\n\t\treturn null;\n\t}\n}\n");
        env.getJavaProject("Project").setOption("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "", "K", "import java.util.List;\nimport java.util.Map;\npublic class K implements K1 {\n\tpublic Map<String, List> get() {\n\t\treturn null;\n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void test430425() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        String jreDirectory = Util.getJREDirectory();
        String jfxJar = Util.toNativePath((String)(String.valueOf(jreDirectory) + "/lib/ext/jfxrt.jar"));
        File file = new File(jfxJar);
        if (!file.exists()) {
            return;
        }
        env.addExternalJars(projectPath, Util.concatWithClassLibs((String)jfxJar, (boolean)false));
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "javafx.css", "StyleConverter", "package javafx.css;\nimport com.sun.javafx.css.converters.InsetsConverter;\nimport javafx.geometry.Insets;\npublic class StyleConverter<F, T> {\n    public static StyleConverter<ParsedValue[], Insets> getInsetsConverter() {\n        return InsetsConverter.getInstance();\n    }\n    void fred5555() {\n    }\n}\n");
        env.addClass(root, "com.sun.javafx.css.converters", "InsetsConverter", "package com.sun.javafx.css.converters;\nimport com.sun.javafx.css.StyleConverterImpl;\nimport javafx.css.ParsedValue;\nimport javafx.css.StyleConverter;\nimport javafx.geometry.Insets;\npublic final class InsetsConverter extends StyleConverterImpl<ParsedValue[], Insets> {\n    public static StyleConverter<ParsedValue[], Insets> getInstance() {\n        return null;\n    }\n}\n");
        env.addClass(root, "javafx.css", "ParsedValue", "package javafx.css;\npublic class ParsedValue<V, T> {\n}\n");
        env.getJavaProject("Project").setOption("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "javafx.css", "StyleConverter", "package javafx.css;\nimport com.sun.javafx.css.converters.InsetsConverter;\nimport javafx.geometry.Insets;\npublic class StyleConverter<F, T> {\n    public static StyleConverter<ParsedValue[], Insets> getInsetsConverter() {\n        return InsetsConverter.getInstance();\n    }\n    void fred555() {\n    }\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void test435544() throws JavaModelException, IOException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations();
        env.addClass(root, "p", "Y", "package p;\t\npublic enum Y {\n\tA,\n\tB\n}\n\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p", "X", "package p;\t\nimport org.eclipse.jdt.annotation.NonNull;\npublic class X {\n\t@NonNull\n\tpublic Y y = Y.A; // warning without fix\n\tvoid foo(@NonNull Y y) {}\n   void bar() {\n\t\tfoo(Y.A); // warning without fix\n   }\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testBug442452() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "bin");
        env.addClass(projectPath, "", "Entity", "public class Entity implements IEntity<Entity> {\n\tpublic int compareTo(IBasicItem o) {\n\t\treturn 0;\n\t}\n}\n");
        env.addClass(projectPath, "", "IEntity", "public interface IEntity<T extends IEntity<T>> extends IBasicItem {\n}\n");
        env.addClass(projectPath, "", "IBasicItem", "public interface IBasicItem extends Comparable<IBasicItem> {\n}\n");
        env.addClass(projectPath, "", "IAdvancedItem", "public interface IAdvancedItem extends Comparable<IBasicItem> {\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(projectPath, "", "Entity", "public class Entity implements IEntity<Entity>, IAdvancedItem {\n\tpublic int compareTo(IBasicItem o) {\n\t\treturn 0;\n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testBug442755() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "bin");
        env.addClass(projectPath, "", "Z", "public interface Z <X1 extends X, Y1 extends Y> {}\n");
        this.fullBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : X cannot be resolved to a type [ resource : </Project/Z.java> range : <31,32> category : <40> severity : <2>]\nProblem : Y cannot be resolved to a type [ resource : </Project/Z.java> range : <45,46> category : <40> severity : <2>]");
        env.addClass(projectPath, "", "Unmarshaller", "public abstract class Unmarshaller<CONTEXT extends Context, DESCRIPTOR extends Z> {\n\tpublic CONTEXT getContext() {\n\t\treturn null;\n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : The project was not built since its build path is incomplete. Cannot find the class file for Y. Fix the build path then try building this project [ resource : </Project> range : <-1,-1> category : <10> severity : <2>]\nProblem : The type Y cannot be resolved. It is indirectly referenced from required .class files [ resource : </Project/Unmarshaller.java> range : <0,1> category : <10> severity : <2>]");
    }

    public void testBug442755a() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "bin");
        env.addClass(projectPath, "", "Z", "public class Z <Y2 extends Y> {}\n");
        this.fullBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : Y cannot be resolved to a type [ resource : </Project/Z.java> range : <27,28> category : <40> severity : <2>]");
        env.addClass(projectPath, "", "X", "public class X <Z> {}\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : The project was not built since its build path is incomplete. Cannot find the class file for Y. Fix the build path then try building this project [ resource : </Project> range : <-1,-1> category : <10> severity : <2>]\nProblem : The type Y cannot be resolved. It is indirectly referenced from required .class files [ resource : </Project/X.java> range : <0,1> category : <10> severity : <2>]");
    }

    public void test445049() throws JavaModelException, IOException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations();
        env.addClass(root, "", "I", "public interface I { int f = 0;}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "", "X", "class X implements I { int i = I.super.f;}");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : No enclosing instance of the type I is accessible in scope [ resource : </Project/src/X.java> range : <31,38> category : <40> severity : <2>]");
    }

    public void testBug481276a() throws Exception {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations();
        env.addClass(root, "testNullAnnotations", "package-info", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage testNullAnnotations;\n");
        env.addClass(root, "testNullAnnotations", "NonNullUtils", "package testNullAnnotations;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic final class NonNullUtils {\n\n    public static <T> T[] checkNotNull(T @Nullable [] array) {\n        if (array == null) {\n            throw new NullPointerException();\n        }\n        return array;\n    }\n}\n");
        env.addClass(root, "testNullAnnotations", "Snippet", "package testNullAnnotations;\n\nimport static testNullAnnotations.NonNullUtils.checkNotNull;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic class Snippet {\n\t@SuppressWarnings(\"unused\")\n\tpublic void foo() {\n        @NonNull Object @Nullable [] objects = null;\n        @NonNull Object @NonNull [] checked3 = checkNotNull(objects); \n\t}\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "testNullAnnotations", "NonNullUtils", "package testNullAnnotations;\n\npublic final class NonNullUtils {\n\n    public static <T> T[] checkNotNull(T [] array) {\n        if (array == null) {\n            throw new NullPointerException();\n        }\n        return array;\n    }\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : Dead code [ resource : </Project/src/testNullAnnotations/NonNullUtils.java> range : <145,202> category : <90> severity : <1>]\nProblem : Null type mismatch (type annotations): required '@NonNull Object @NonNull[]' but this expression has type '@NonNull Object @Nullable[]' [ resource : </Project/src/testNullAnnotations/Snippet.java> range : <316,323> category : <90> severity : <2>]");
    }

    public void testBug481276b() throws Exception {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations();
        env.addClass(root, "testNullAnnotations", "package-info", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage testNullAnnotations;\n");
        env.addClass(root, "testNullAnnotations", "NonNullUtils", "package testNullAnnotations;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic final class NonNullUtils {\n\n    public static <@Nullable T> T[] checkNotNull(T @Nullable[] array) {\n        if (array == null) {\n            throw new NullPointerException();\n        }\n        return array;\n    }\n}\n");
        env.addClass(root, "testNullAnnotations", "Snippet", "package testNullAnnotations;\n\nimport static testNullAnnotations.NonNullUtils.checkNotNull;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic class Snippet {\n\t@SuppressWarnings(\"unused\")\n\tpublic void foo() {\n        @NonNull Object @Nullable [] objects = new @NonNull Object[0];\n        @NonNull Object @NonNull [] checked3 = checkNotNull(objects); \n\t}\n}\n");
        this.fullBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : Null type mismatch (type annotations): required '@NonNull Object @NonNull[]' but this expression has type '@Nullable Object @NonNull[]' [ resource : </Project/src/testNullAnnotations/Snippet.java> range : <321,342> category : <90> severity : <2>]\nProblem : Null type mismatch (type annotations): required '@Nullable Object @Nullable[]' but this expression has type '@NonNull Object @Nullable[]' [ resource : </Project/src/testNullAnnotations/Snippet.java> range : <334,341> category : <90> severity : <2>]");
        env.addClass(root, "testNullAnnotations", "NonNullUtils", "package testNullAnnotations;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic final class NonNullUtils {\n\n    public static <T> T[] checkNotNull(T @Nullable[] array) {\n        if (array == null) {\n            throw new NullPointerException();\n        }\n        return array;\n    }\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testBug481276c() throws Exception {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations();
        env.addClass(root, "testNullAnnotations", "package-info", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage testNullAnnotations;\n");
        env.addClass(root, "testNullAnnotations", "NonNullUtils", "package testNullAnnotations;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic final class NonNullUtils {\n\n    public static <T> T[] checkNotNull(T @Nullable [] array) {\n        if (array == null) {\n            throw new NullPointerException();\n        }\n        return array;\n    }\n}\n");
        env.addClass(root, "testNullAnnotations", "Snippet", "package testNullAnnotations;\n\nimport static testNullAnnotations.NonNullUtils.checkNotNull;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic class Snippet {\n\t@SuppressWarnings(\"unused\")\n\tpublic void foo() {\n        @NonNull Object @Nullable [] objects = null;\n        @NonNull Object @NonNull [] checked3 = checkNotNull(objects); \n\t}\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "testNullAnnotations", "package-info", "@org.eclipse.jdt.annotation.NonNullByDefault({})\npackage testNullAnnotations;\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : Null type safety (type annotations): The expression of type '@NonNull Object []' needs unchecked conversion to conform to '@NonNull Object @NonNull[]' [ resource : </Project/src/testNullAnnotations/Snippet.java> range : <303,324> category : <90> severity : <1>]");
    }

    public void testBug483744_remove() throws JavaModelException, IOException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations();
        env.addClass(root, "testNullAnnotations", "package-info", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage testNullAnnotations;\n");
        env.addClass(root, "testNullAnnotations", "NonNullUtils", "package testNullAnnotations;\n\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\n\npublic final class NonNullUtils {\n\n    public static <T> List<@NonNull T> checkNotNullContents(List<@Nullable T> list, List<@NonNull T> nList) {\n        return nList;\n    }\n}\n");
        env.addClass(root, "testNullAnnotations", "Snippet", "package testNullAnnotations;\n\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\n\nimport static testNullAnnotations.NonNullUtils.checkNotNullContents;\n\npublic class Snippet {\n\tpublic List<@NonNull String> foo(List<@Nullable String> inList, List<@NonNull String> nList) {\n        return checkNotNullContents(inList, nList); \n\t}\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "testNullAnnotations", "NonNullUtils", "package testNullAnnotations;\n\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\n\npublic final class NonNullUtils {\n\n    public static <T> List<@NonNull T> checkNotNullContents(List<T> list, List<@NonNull T> nList) {\n        return nList;\n    }\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "testNullAnnotations", "NonNullUtils", "package testNullAnnotations;\n\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\n\npublic final class NonNullUtils {\n\n    public static <T> List<@NonNull T> checkNotNullContents(List<@Nullable T> list, List<@NonNull T> nList) {\n        return nList;\n    }\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }
}

