/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;
import org.osgi.framework.Bundle;

public class PackageInfoTest
extends BuilderTests {
    public PackageInfoTest(String name) {
        super(name);
    }

    public static Test suite() {
        return PackageInfoTest.buildTestSuite(PackageInfoTest.class);
    }

    public void test001() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "pack", "Annot", "package pack;\npublic @interface Annot {}");
        this.incrementalBuild(projectPath);
        IPath packageInfoPath = env.addFile(root, "pack/package-info.java", "@Annot package p1");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(packageInfoPath);
        Object[] problems = env.getProblems();
        Arrays.sort(problems);
        PackageInfoTest.assertNotNull((Object)problems);
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        int problemsLength = problems.length;
        if (problemsLength == 1) {
            writer.print(((Problem)problems[0]).getMessage());
        } else {
            int i = 0;
            while (i < problemsLength - 1) {
                writer.println(((Problem)problems[i]).getMessage());
                ++i;
            }
            writer.print(((Problem)problems[problemsLength - 1]).getMessage());
        }
        writer.close();
        this.assertSourceEquals("Different messages", "Syntax error on token \"p1\", ; expected after this token\nThe declared package \"p1\" does not match the expected package \"pack\"", stringWriter.toString());
    }

    public void test002() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "testcase", "Main", "package testcase;\n\npublic class Main {\n    public static void main(String[] argv) throws Exception {\n\t\tPackage pkg = Package.getPackage(\"testcase\");\n\t\tSystem.out.print(pkg.getAnnotation(TestAnnotation.class));\n\t\tpkg = Class.forName(\"testcase.package-info\").getPackage();\n\t\tSystem.out.print(pkg.getAnnotation(TestAnnotation.class));\n    }\n}");
        env.addClass(root, "testcase", "TestAnnotation", "package testcase;\n\nimport static java.lang.annotation.ElementType.PACKAGE;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\n\n@Target(PACKAGE)\n@Retention(RUNTIME)\npublic @interface TestAnnotation {\n}");
        env.addFile(root, "testcase/package-info.java", "@TestAnnotation package testcase;");
        this.incrementalBuild(projectPath);
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null && JavaCore.compareJavaVersions((String)javaVersion, (String)"9") >= 0) {
            this.expectingProblemsFor((IPath)new Path("/Project/src/testcase/Main.java"), "Problem : The method getPackage(String) from the type Package is deprecated [ resource : </Project/src/testcase/Main.java> range : <125,147> category : <110> severity : <1>]");
        } else {
            this.expectingNoProblems();
        }
        this.executeClass(projectPath, "testcase.Main", "@testcase.TestAnnotation()@testcase.TestAnnotation()", "");
    }

    public void test003() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addPackage(root, "testcase");
        IPath packageInfoPath = env.addFile(root, "testcase/package-info.java", "");
        this.incrementalBuild(projectPath);
        this.expectingOnlySpecificProblemFor(packageInfoPath, new Problem("testcase/package-info.java", "The declared package \"\" does not match the expected package \"testcase\"", packageInfoPath, 0, 0, 60, 2));
    }

    public void test004() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath otherRoot = env.addPackageFragmentRoot(projectPath, "test");
        env.setOutputFolder(projectPath, "bin");
        env.addPackage(root, "my.foo");
        env.addPackage(otherRoot, "my.foo");
        env.addFile(root, "my/foo/package-info.java", "/**\n* A demo package for foo.\n*/\npackage my.foo;\n");
        IPath otherPackageInfoPath = env.addFile(otherRoot, "my/foo/package-info.java", "/**\n* A demo package for foo.\n*/\npackage my.foo;\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlySpecificProblemFor(otherPackageInfoPath, new Problem("my/foo/package-info.java", "The type package-info is already defined", otherPackageInfoPath, 0, 0, 40, 2));
    }

    public void test258145() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath otherRoot = env.addPackageFragmentRoot(projectPath, "test");
        env.setOutputFolder(projectPath, "bin");
        env.addPackage(root, "my.foo");
        env.addFile(root, "my/foo/package-info.java", "/**\n* A demo package for foo.\n*/\npackage my.foo;\n");
        this.fullBuild(projectPath);
        env.addPackage(otherRoot, "my.foo");
        IPath otherPackageInfoPath = env.addFile(otherRoot, "my/foo/package-info.java", "/**\n* A demo package for foo.\n*/\npackage my.foo;\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlySpecificProblemFor(otherPackageInfoPath, new Problem("my/foo/package-info.java", "The type package-info is already defined", otherPackageInfoPath, 0, 0, 40, 2));
    }

    public void test323785() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.fullBuild(projectPath);
        env.addFile(root, "package-info.java", "");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void test323785a() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath xJavaPath = env.addFile(root, "X.java", "class X extends Y {}\n");
        this.fullBuild(projectPath);
        env.addFile(root, "package-info.java", "class Y {}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
        env.addFile(root, "package-info.java", "final class Y {}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlySpecificProblemFor(xJavaPath, new Problem("X.java", "The type X cannot subclass the final class Y", xJavaPath, 16, 17, 40, 2));
    }

    public void testBug372012() throws JavaModelException, IOException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath srcRoot = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations(projectPath);
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "error");
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "error");
        String test1Code = "package p1;\npublic class Test1 {\n    public void foo() {\n        new Test2().bar(\"\");\n    }\n\t class Test1Inner{}\n}";
        String test2Code = "package p1;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class Test2 {\n    public void bar(String str) {}\n}";
        String test3Code = "package p1;\npublic class Test3 {\n    public void bar(String str) {}\n}";
        IPath test1Path = env.addClass(srcRoot, "p1", "Test1", test1Code);
        env.addClass(srcRoot, "p1", "Test2", test2Code);
        env.addClass(srcRoot, "p1", "Test3", test3Code);
        this.fullBuild(projectPath);
        this.expectingNoProblemsFor(test1Path);
        this.expectingProblemsFor(srcRoot, "Problem : A default nullness annotation has not been specified for the package p1 [ resource : </Project/src/p1> range : <8,10> category : <90> severity : <2>]");
        String packageInfoCode = "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p1;\n";
        env.addClass(srcRoot, "p1", "package-info", packageInfoCode);
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : Nullness default is redundant with a default specified for the enclosing package p1 [ resource : </Project/src/p1/Test2.java> range : <12,56> category : <120> severity : <2>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.Test1$Test1Inner", "p1.Test2", "p1.Test3", "p1.package-info"});
    }

    public void testBug372012a() throws JavaModelException, IOException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath srcRoot = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations(projectPath);
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "error");
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "error");
        String test1Code = "package p1;\npublic class Test1 {\n    public void foo() {\n        new Test2().bar(\"\");\n    }\n\t class Test1Inner{}\n}";
        String test2Code = "package p1;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class Test2 {\n    public void bar(String str) {}\n}";
        IPath test1Path = env.addClass(srcRoot, "p1", "Test1", test1Code);
        env.addClass(srcRoot, "p1", "Test2", test2Code);
        this.fullBuild(projectPath);
        this.expectingNoProblemsFor(test1Path);
        this.expectingProblemsFor(srcRoot, "Problem : A default nullness annotation has not been specified for the package p1 [ resource : </Project/src/p1> range : <8,10> category : <90> severity : <2>]");
        test1Code = "package p1;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class Test1 {\n    public void foo() {\n        new Test2().bar(\"\");\n    }\n\t class Test1Inner{}\n}";
        env.addClass(srcRoot, "p1", "Test1", test1Code);
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(srcRoot, "Problem : A default nullness annotation has not been specified for the package p1 [ resource : </Project/src/p1> range : <8,10> category : <90> severity : <2>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.Test1$Test1Inner"});
    }

    public void testBug372012b() throws JavaModelException, IOException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath srcRoot = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations(projectPath);
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "error");
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "error");
        String test1Code = "package p1;\npublic class Test1 {\n    public void foo() {\n        new Test2().bar(\"\");\n    }\n\t class Test1Inner{}\n}";
        String test2Code = "package p1;\npublic class Test2 {\n    public void bar(String str) {}\n}";
        IPath test1Path = env.addClass(srcRoot, "p1", "Test1", test1Code);
        env.addClass(srcRoot, "p1", "Test2", test2Code);
        this.fullBuild(projectPath);
        this.expectingNoProblemsFor(test1Path);
        this.expectingProblemsFor(srcRoot, "Problem : A default nullness annotation has not been specified for the package p1 [ resource : </Project/src/p1> range : <8,10> category : <90> severity : <2>]");
        test1Code = "package p1;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class Test1 {\n    public void foo() {\n        new Test2().bar(\"\");\n    }\n\t class Test1Inner{}\n}";
        env.addClass(srcRoot, "p1", "Test1", test1Code);
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(srcRoot, "Problem : A default nullness annotation has not been specified for the package p1 [ resource : </Project/src/p1> range : <8,10> category : <90> severity : <2>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.Test1$Test1Inner"});
    }

    public void testBug372012c() throws JavaModelException, IOException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath srcRoot = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations(projectPath);
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "error");
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "error");
        String test1Code = "package p1;\npublic class Test1 {\n    public void foo() {\n        new Test2().bar(\"\");\n    }\n\t class Test1Inner{}\n}";
        String test2Code = "package p1;\npublic class Test2 {\n    public void bar(String str) {}\n}";
        String packageInfoCode = "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p1;\n";
        env.addClass(srcRoot, "p1", "package-info", packageInfoCode);
        env.addClass(srcRoot, "p1", "Test1", test1Code);
        env.addClass(srcRoot, "p1", "Test2", test2Code);
        env.addClass(srcRoot, "p1", "package-info", packageInfoCode);
        this.fullBuild(projectPath);
        this.expectingNoProblemsFor(srcRoot);
        packageInfoCode = "package p1;\n";
        env.addClass(srcRoot, "p1", "package-info", packageInfoCode);
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : A default nullness annotation has not been specified for the package p1 [ resource : </Project/src/p1/package-info.java> range : <8,10> category : <90> severity : <2>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.Test1$Test1Inner", "p1.Test2", "p1.package-info"});
    }

    public void testBug367836() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath src = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(src, "p", "A", "package p;\npublic class A {}");
        IPath bPath = env.addClass(src, "p", "package-info", "");
        this.fullBuild();
        this.expectingOnlySpecificProblemFor(bPath, new Problem("", "The declared package \"\" does not match the expected package \"p\"", bPath, 0, 0, 60, 2));
    }

    public void testBug374063() throws JavaModelException, IOException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath srcRoot = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations(projectPath);
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "error");
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "error");
        String test1Code = "package p1;\npublic class Test1 {\n    public String output(List<Integer> integers) {\n        return \"\";\n    }\n\t public void output(List<Double> doubles) {}\n}";
        env.addClass(srcRoot, "p1", "Test1", test1Code);
        this.fullBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : A default nullness annotation has not been specified for the package p1 [ resource : </Project/src/p1> range : <8,10> category : <90> severity : <2>]\nProblem : List cannot be resolved to a type [ resource : </Project/src/p1/Test1.java> range : <130,134> category : <40> severity : <2>]\nProblem : List cannot be resolved to a type [ resource : </Project/src/p1/Test1.java> range : <58,62> category : <40> severity : <2>]");
        String packageInfoCode = "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p1;\n";
        env.addClass(srcRoot, "p1", "package-info", packageInfoCode);
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List cannot be resolved to a type [ resource : </Project/src/p1/Test1.java> range : <130,134> category : <40> severity : <2>]\nProblem : List cannot be resolved to a type [ resource : </Project/src/p1/Test1.java> range : <58,62> category : <40> severity : <2>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.package-info"});
    }

    public void testBug382960() throws JavaModelException, IOException, CoreException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath srcRoot = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations(projectPath);
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "error");
        String test1Code = "package p1;\npublic class Test1 {\n    public String output(List<Integer> integers) {\n        return \"\";\n    }\n\t public void output(List<Double> doubles) {}\n}";
        env.addClass(srcRoot, "p1", "Test1", test1Code);
        String packageInfoCode = "package p1;\n";
        env.addClass(srcRoot, "p1", "package-info", packageInfoCode);
        this.fullBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : A default nullness annotation has not been specified for the package p1 [ resource : </Project/src/p1/package-info.java> range : <8,10> category : <90> severity : <2>]\nProblem : List cannot be resolved to a type [ resource : </Project/src/p1/Test1.java> range : <130,134> category : <40> severity : <2>]\nProblem : List cannot be resolved to a type [ resource : </Project/src/p1/Test1.java> range : <58,62> category : <40> severity : <2>]");
        packageInfoCode = "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p1;\n";
        env.addClass(srcRoot, "p1", "package-info", packageInfoCode);
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List cannot be resolved to a type [ resource : </Project/src/p1/Test1.java> range : <130,134> category : <40> severity : <2>]\nProblem : List cannot be resolved to a type [ resource : </Project/src/p1/Test1.java> range : <58,62> category : <40> severity : <2>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.package-info"});
        IProject project = env.getProject(projectPath);
        IFile packageInfo = project.getFile("/src/p1/package-info.java");
        packageInfo.touch(null);
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List cannot be resolved to a type [ resource : </Project/src/p1/Test1.java> range : <130,134> category : <40> severity : <2>]\nProblem : List cannot be resolved to a type [ resource : </Project/src/p1/Test1.java> range : <58,62> category : <40> severity : <2>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.package-info"});
    }

    public void testBug525469() throws JavaModelException, IOException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath srcRoot1 = env.addPackageFragmentRoot(projectPath, "src1");
        IPath srcRoot2 = env.addPackageFragmentRoot(projectPath, "src2");
        env.setOutputFolder(projectPath, "bin");
        this.setupProjectForNullAnnotations(projectPath);
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "error");
        env.getJavaProject(projectPath).setOption("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "error");
        String test1Code = "package p1;\npublic class Test1 {\n}";
        env.addClass(srcRoot1, "p1", "Test1", test1Code);
        String otherClassCode = "package p2;\npublic class OtherClass {\n}";
        env.addClass(srcRoot1, "p2", "OtherClass", otherClassCode);
        String packageInfoCode2 = "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p2;\n";
        env.addClass(srcRoot1, "p2", "package-info", packageInfoCode2);
        this.fullBuild(projectPath);
        String test2Code = "package p1;\npublic class Test2 {\n}";
        env.addClass(srcRoot2, "p1", "Test2", test2Code);
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : A default nullness annotation has not been specified for the package p1 [ resource : </Project/src1/p1> range : <8,10> category : <90> severity : <2>]\nProblem : A default nullness annotation has not been specified for the package p1 [ resource : </Project/src2/p1> range : <8,10> category : <90> severity : <2>]");
        String packageInfoCode1 = "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p1;\n";
        env.addClass(srcRoot1, "p1", "package-info", packageInfoCode1);
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "");
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.Test2", "p1.package-info", "p2.OtherClass", "p2.package-info"});
    }

    void setupProjectForNullAnnotations(IPath projectPath) throws IOException, JavaModelException {
        File bundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"org.eclipse.jdt.annotation"));
        String annotationsLib = bundleFile.isDirectory() ? String.valueOf(bundleFile.getPath()) + "/bin" : bundleFile.getPath();
        IJavaProject javaProject = env.getJavaProject(projectPath);
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        int len = rawClasspath.length;
        IClasspathEntry[] iClasspathEntryArray = rawClasspath;
        rawClasspath = new IClasspathEntry[len + 1];
        System.arraycopy(iClasspathEntryArray, 0, rawClasspath, 0, len);
        rawClasspath[len] = JavaCore.newLibraryEntry((IPath)new Path(annotationsLib), null, null);
        javaProject.setRawClasspath(rawClasspath, null);
        javaProject.setOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
    }

    protected void assertSourceEquals(String message, String expected, String actual) {
        if (actual == null) {
            PackageInfoTest.assertEquals((String)message, (String)expected, null);
            return;
        }
        if (!(actual = Util.convertToIndependantLineDelimiter((String)actual)).equals(expected)) {
            System.out.print(Util.displayString((String)actual.toString(), (int)0));
        }
        PackageInfoTest.assertEquals((String)message, (String)expected, (String)actual);
    }

    public static Class testClass() {
        return PackageInfoTest.class;
    }
}

