/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.util.Util;

public class TestAttributeBuilderTests
extends BuilderTests {
    public TestAttributeBuilderTests(String name) {
        super(name);
    }

    public static Test suite() {
        return TestAttributeBuilderTests.buildTestSuite(TestAttributeBuilderTests.class);
    }

    public void testWithProjectAsMainDependency() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.removePackageFragmentRoot(project1Path, "");
        IPath src1 = env.addPackageFragmentRoot(project1Path, "src", null, "bin");
        IPath tests1 = env.addTestPackageFragmentRoot(project1Path, "tests");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.addClass(src1, "p1", "P1Class", "package p1;\n\npublic class P1Class {\n}\n");
        env.addClass(src1, "p1", "Production1", "package p1;\n\npublic class Production1 {\n\tvoid p1() {\n\t\tnew P1Class(); // ok\n\t\tnew T1Class(); // forbidden\n\t}\n}\n");
        env.addClass(tests1, "p1", "T1Class", "package p1;\n\npublic class T1Class {\n}\n");
        env.addClass(tests1, "p1", "Test1", "package p1;\n\npublic class Test1 {\n\tvoid test1() {\n\t\tnew P1Class(); // ok\n\t\tnew T1Class(); // ok\n\t}\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.removePackageFragmentRoot(project2Path, "");
        IPath src2 = env.addPackageFragmentRoot(project2Path, "src", null, "bin");
        IPath tests2 = env.addTestPackageFragmentRoot(project2Path, "tests");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        env.addClass(src2, "p2", "P2Class", "package p2;\n\npublic class P2Class {\n}\n");
        env.addClass(src2, "p2", "Production2", "package p2;\n\nimport p1.P1Class;\nimport p1.T1Class;\n\npublic class Production2 {\n\tvoid p2() {\n\t\tnew P1Class(); // ok\n\t\tnew P2Class(); // ok\n\t\tnew T1Class(); // forbidden\n\t\tnew T2Class(); // forbidden\n\t}\n}\n");
        env.addClass(tests2, "p2", "T2Class", "package p2;\n\npublic class T2Class {\n}\n");
        env.addClass(tests2, "p2", "Test2", "package p2;\n\nimport p1.P1Class;\nimport p1.T1Class;\n\npublic class Test2 {\n\tvoid test2() {\n\t\tnew P1Class(); // ok\n\t\tnew P2Class(); // ok\n\t\tnew T1Class(); // ok\n\t\tnew T2Class(); // ok\n\t}\n}\n");
        this.fullBuild();
        this.expectingProblemsFor(env.getWorkspaceRootPath(), "Problem : T1Class cannot be resolved to a type [ resource : </Project1/src/p1/Production1.java> range : <82,89> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <144,151> category : <40> severity : <2>]\nProblem : T2Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <174,181> category : <40> severity : <2>]\nProblem : The import p1.T1Class cannot be resolved [ resource : </Project2/src/p2/Production2.java> range : <39,49> category : <30> severity : <2>]");
    }

    public void testWithProjectAsTestDependency() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.removePackageFragmentRoot(project1Path, "");
        IPath src1 = env.addPackageFragmentRoot(project1Path, "src", null, "bin");
        IPath tests1 = env.addTestPackageFragmentRoot(project1Path, "tests");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.addClass(src1, "p1", "P1Class", "package p1;\n\npublic class P1Class {\n}\n");
        env.addClass(src1, "p1", "Production1", "package p1;\n\npublic class Production1 {\n\tvoid p1() {\n\t\tnew P1Class(); // ok\n\t\tnew T1Class(); // forbidden\n\t}\n}\n");
        env.addClass(tests1, "p1", "T1Class", "package p1;\n\npublic class T1Class {\n}\n");
        env.addClass(tests1, "p1", "Test1", "package p1;\n\npublic class Test1 {\n\tvoid test1() {\n\t\tnew P1Class(); // ok\n\t\tnew T1Class(); // ok\n\t}\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.removePackageFragmentRoot(project2Path, "");
        IPath src2 = env.addPackageFragmentRoot(project2Path, "src", null, "bin");
        IPath tests2 = env.addTestPackageFragmentRoot(project2Path, "tests");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredTestProject(project2Path, project1Path);
        env.addClass(src2, "p2", "P2Class", "package p2;\n\npublic class P2Class {\n}\n");
        env.addClass(src2, "p2", "Production2", "package p2;\n\nimport p1.P1Class;\nimport p1.T1Class;\n\npublic class Production2 {\n\tvoid p2() {\n\t\tnew P1Class(); // forbidden\n\t\tnew P2Class(); // ok\n\t\tnew T1Class(); // forbidden\n\t\tnew T2Class(); // forbidden\n\t}\n}\n");
        env.addClass(tests2, "p2", "T2Class", "package p2;\n\npublic class T2Class {\n}\n");
        env.addClass(tests2, "p2", "Test2", "package p2;\n\nimport p1.P1Class;\nimport p1.T1Class;\n\npublic class Test2 {\n\tvoid test2() {\n\t\tnew P1Class(); // ok\n\t\tnew P2Class(); // ok\n\t\tnew T1Class(); // ok\n\t\tnew T2Class(); // ok\n\t}\n}\n");
        this.fullBuild();
        this.expectingProblemsFor(env.getWorkspaceRootPath(), "Problem : P1Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <98,105> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project1/src/p1/Production1.java> range : <82,89> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <151,158> category : <40> severity : <2>]\nProblem : T2Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <181,188> category : <40> severity : <2>]\nProblem : The import p1 cannot be resolved [ resource : </Project2/src/p2/Production2.java> range : <20,22> category : <30> severity : <2>]\nProblem : The import p1 cannot be resolved [ resource : </Project2/src/p2/Production2.java> range : <39,41> category : <30> severity : <2>]");
    }

    public void testWithProjectAsMainDependencyWithoutTestCode() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.removePackageFragmentRoot(project1Path, "");
        IPath src1 = env.addPackageFragmentRoot(project1Path, "src", null, "bin");
        IPath tests1 = env.addTestPackageFragmentRoot(project1Path, "tests");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.addClass(src1, "p1", "P1Class", "package p1;\n\npublic class P1Class {\n}\n");
        env.addClass(src1, "p1", "Production1", "package p1;\n\npublic class Production1 {\n\tvoid p1() {\n\t\tnew P1Class(); // ok\n\t\tnew T1Class(); // forbidden\n\t}\n}\n");
        env.addClass(tests1, "p1", "T1Class", "package p1;\n\npublic class T1Class {\n}\n");
        env.addClass(tests1, "p1", "Test1", "package p1;\n\npublic class Test1 {\n\tvoid test1() {\n\t\tnew P1Class(); // ok\n\t\tnew T1Class(); // ok\n\t}\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.removePackageFragmentRoot(project2Path, "");
        IPath src2 = env.addPackageFragmentRoot(project2Path, "src", null, "bin");
        IPath tests2 = env.addTestPackageFragmentRoot(project2Path, "tests");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProjectWithoutTestCode(project2Path, project1Path);
        env.addClass(src2, "p2", "P2Class", "package p2;\n\npublic class P2Class {\n}\n");
        env.addClass(src2, "p2", "Production2", "package p2;\n\nimport p1.P1Class;\nimport p1.T1Class;\n\npublic class Production2 {\n\tvoid p2() {\n\t\tnew P1Class(); // ok\n\t\tnew P2Class(); // ok\n\t\tnew T1Class(); // forbidden\n\t\tnew T2Class(); // forbidden\n\t}\n}\n");
        env.addClass(tests2, "p2", "T2Class", "package p2;\n\npublic class T2Class {\n}\n");
        env.addClass(tests2, "p2", "Test2", "package p2;\n\nimport p1.P1Class;\nimport p1.T1Class;\n\npublic class Test2 {\n\tvoid test2() {\n\t\tnew P1Class(); // ok\n\t\tnew P2Class(); // ok\n\t\tnew T1Class(); // ok\n\t\tnew T2Class(); // ok\n\t}\n}\n");
        this.fullBuild();
        this.expectingProblemsFor(env.getWorkspaceRootPath(), "Problem : T1Class cannot be resolved to a type [ resource : </Project1/src/p1/Production1.java> range : <82,89> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <144,151> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project2/tests/p2/Test2.java> range : <141,148> category : <40> severity : <2>]\nProblem : T2Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <174,181> category : <40> severity : <2>]\nProblem : The import p1.T1Class cannot be resolved [ resource : </Project2/src/p2/Production2.java> range : <39,49> category : <30> severity : <2>]\nProblem : The import p1.T1Class cannot be resolved [ resource : </Project2/tests/p2/Test2.java> range : <39,49> category : <30> severity : <2>]");
    }

    public void testWithProjectAsTestDependencyWithoutTestCode() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.removePackageFragmentRoot(project1Path, "");
        IPath src1 = env.addPackageFragmentRoot(project1Path, "src", null, "bin");
        IPath tests1 = env.addTestPackageFragmentRoot(project1Path, "tests");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.addClass(src1, "p1", "P1Class", "package p1;\n\npublic class P1Class {\n}\n");
        env.addClass(src1, "p1", "Production1", "package p1;\n\npublic class Production1 {\n\tvoid p1() {\n\t\tnew P1Class(); // ok\n\t\tnew T1Class(); // forbidden\n\t}\n}\n");
        env.addClass(tests1, "p1", "T1Class", "package p1;\n\npublic class T1Class {\n}\n");
        env.addClass(tests1, "p1", "Test1", "package p1;\n\npublic class Test1 {\n\tvoid test1() {\n\t\tnew P1Class(); // ok\n\t\tnew T1Class(); // ok\n\t}\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.removePackageFragmentRoot(project2Path, "");
        IPath src2 = env.addPackageFragmentRoot(project2Path, "src", null, "bin");
        IPath tests2 = env.addTestPackageFragmentRoot(project2Path, "tests");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredTestProjectWithoutTestCode(project2Path, project1Path);
        env.addClass(src2, "p2", "P2Class", "package p2;\n\npublic class P2Class {\n}\n");
        env.addClass(src2, "p2", "Production2", "package p2;\n\nimport p1.P1Class;\nimport p1.T1Class;\n\npublic class Production2 {\n\tvoid p2() {\n\t\tnew P1Class(); // forbidden\n\t\tnew P2Class(); // ok\n\t\tnew T1Class(); // forbidden\n\t\tnew T2Class(); // forbidden\n\t}\n}\n");
        env.addClass(tests2, "p2", "T2Class", "package p2;\n\npublic class T2Class {\n}\n");
        env.addClass(tests2, "p2", "Test2", "package p2;\n\nimport p1.P1Class;\nimport p1.T1Class;\n\npublic class Test2 {\n\tvoid test2() {\n\t\tnew P1Class(); // ok\n\t\tnew P2Class(); // ok\n\t\tnew T1Class(); // ok\n\t\tnew T2Class(); // ok\n\t}\n}\n");
        this.fullBuild();
        this.expectingProblemsFor(env.getWorkspaceRootPath(), "Problem : P1Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <98,105> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project1/src/p1/Production1.java> range : <82,89> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <151,158> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project2/tests/p2/Test2.java> range : <141,148> category : <40> severity : <2>]\nProblem : T2Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <181,188> category : <40> severity : <2>]\nProblem : The import p1 cannot be resolved [ resource : </Project2/src/p2/Production2.java> range : <20,22> category : <30> severity : <2>]\nProblem : The import p1 cannot be resolved [ resource : </Project2/src/p2/Production2.java> range : <39,41> category : <30> severity : <2>]\nProblem : The import p1.T1Class cannot be resolved [ resource : </Project2/tests/p2/Test2.java> range : <39,49> category : <30> severity : <2>]");
    }

    public void testIncrementalBuildMainChange() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.removePackageFragmentRoot(project1Path, "");
        IPath src1 = env.addPackageFragmentRoot(project1Path, "src", null, "bin");
        IPath tests1 = env.addTestPackageFragmentRoot(project1Path, "tests");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.addClass(src1, "p1", "P1Class", "package p1;\n\nclass P1Class {\n}\n");
        env.addClass(tests1, "p1", "T1Class", "package p1;\n\npublic class T1Class extends P1Class {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.removePackageFragmentRoot(project2Path, "");
        IPath src2 = env.addPackageFragmentRoot(project2Path, "src", null, "bin");
        IPath tests2 = env.addTestPackageFragmentRoot(project2Path, "tests");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        env.addClass(src2, "p2", "P2Class", "package p2;\n\npublic class P2Class extends p1.P1Class {\n}\n");
        env.addClass(tests2, "p2", "T2Class", "package p2;\n\npublic class T2Class {\n}\n");
        env.addClass(tests2, "p2", "Test2", "package p2;\n\npublic class Test2 {\n\tvoid test2() {\n\t\tnew P2Class();\n\t}\n}\n");
        this.fullBuild();
        this.expectingProblemsFor(env.getWorkspaceRootPath(), "Problem : The type p1.P1Class is not visible [ resource : </Project2/src/p2/P2Class.java> range : <42,52> category : <40> severity : <2>]");
        env.addClass(src1, "p1", "P1Class", "package p1;\n\npublic class P1Class {\n}\n");
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingCompiledClasses(new String[]{"p1.P1Class", "p1.T1Class", "p2.P2Class", "p2.Test2"});
        this.expectingCompilingOrder(new String[]{"/Project1/src/p1/P1Class.java", "/Project1/tests/p1/T1Class.java", "/Project2/src/p2/P2Class.java", "/Project2/tests/p2/Test2.java"});
    }

    public void testIncrementalBuildTestChange() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.removePackageFragmentRoot(project1Path, "");
        IPath src1 = env.addPackageFragmentRoot(project1Path, "src", null, "bin");
        IPath tests1 = env.addTestPackageFragmentRoot(project1Path, "tests");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.addClass(src1, "p1", "P1Class", "package p1;\n\npublic class P1Class {\n}\n");
        env.addClass(tests1, "p1", "T1Class", "package p1;\n\npublic class T1Class {\n}\n");
        env.addClass(tests1, "p1", "Test1", "package p1;\n\npublic class Test1 {\n\tvoid test1() {\n\t\tnew P1Class();\t\tnew T1Class();\t}\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.removePackageFragmentRoot(project2Path, "");
        IPath src2 = env.addPackageFragmentRoot(project2Path, "src", null, "bin");
        IPath tests2 = env.addTestPackageFragmentRoot(project2Path, "tests");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        env.addClass(src2, "p2", "P2Class", "package p2;\n\npublic class P2Class extends p1.P1Class {\n}\n");
        env.addClass(tests2, "p2", "T2Class", "package p2;\n\npublic class T2Class extends p1.T1Class {\n}\n");
        env.addClass(tests2, "p2", "Test2", "package p2;\n\npublic class Test2 extends p2.T2Class {\n\tvoid test2(T2Class t) {\n\t}\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        env.addClass(tests1, "p1", "T1Class", "package p1;\n\npublic class T1Class extends P1Class {\n}\n");
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingCompiledClasses(new String[]{"p1.T1Class", "p1.Test1", "p2.T2Class", "p2.Test2"});
        this.expectingCompilingOrder(new String[]{"/Project1/tests/p1/T1Class.java", "/Project1/tests/p1/Test1.java", "/Project2/tests/p2/T2Class.java", "/Project2/tests/p2/Test2.java"});
    }

    public void testIncrementalBuildTestOnlyProject() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.removePackageFragmentRoot(project1Path, "");
        IPath tests1 = env.addTestPackageFragmentRoot(project1Path, "tests");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.addClass(tests1, "p1", "T1Class", "package p1;\n\npublic class T1Class {\n}\n");
        env.addClass(tests1, "p1", "Test1", "package p1;\n\npublic class Test1 {\n\tvoid test1() {\n\t\tnew T1Class();\t}\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        IPath test1 = env.addClass(tests1, "p1", "Test1", "package p1;\n\npublic class Test1 {\n\tvoid test1() {\n\t\tnew X1Class();\t}\n}\n");
        this.incrementalBuild();
        this.expectingProblemsFor(test1, "Problem : X1Class cannot be resolved to a type [ resource : </Project1/tests/p1/Test1.java> range : <56,63> category : <40> severity : <2>]");
        this.expectingCompiledClasses(new String[]{"p1.Test1"});
        this.expectingCompilingOrder(new String[]{"/Project1/tests/p1/Test1.java"});
    }

    public void testClasspathEntryTestAttributeChanges() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.removePackageFragmentRoot(project1Path, "");
        IPath src1 = env.addPackageFragmentRoot(project1Path, "src", null, "bin");
        IPath tests1 = env.addTestPackageFragmentRoot(project1Path, "tests");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.addClass(src1, "p1", "P1Class", "package p1;\n\npublic class P1Class {\n}\n");
        env.addClass(src1, "p1", "P1Unrelated", "package p1;\n\npublic class P1Unrelated {\n}\n");
        env.addClass(src1, "p1", "Production1", "package p1;\n\npublic class Production1 {\n\tvoid p1() {\n\t\tnew P1Class(); // ok\n\t\tnew T1Class(); // forbidden\n\t}\n}\n");
        env.addClass(tests1, "p1", "T1Class", "package p1;\n\npublic class T1Class {\n}\n");
        env.addClass(tests1, "p1", "Test1", "package p1;\n\npublic class Test1 {\n\tvoid test1() {\n\t\tnew P1Class(); // ok\n\t\tnew T1Class(); // ok\n\t}\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.removePackageFragmentRoot(project2Path, "");
        IPath src2 = env.addPackageFragmentRoot(project2Path, "src", null, "bin");
        IPath tests2 = env.addTestPackageFragmentRoot(project2Path, "tests");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        env.addClass(src2, "p2", "P2Class", "package p2;\n\npublic class P2Class {\n}\n");
        env.addClass(src1, "p2", "P2Unrelated", "package p2;\n\npublic class P2Unrelated {\n}\n");
        env.addClass(src2, "p2", "Production2", "package p2;\n\nimport p1.P1Class;\nimport p1.T1Class;\n\npublic class Production2 {\n\tvoid p2() {\n\t\tnew P1Class(); // ok\n\t\tnew P2Class(); // ok\n\t\tnew T1Class(); // forbidden\n\t\tnew T2Class(); // forbidden\n\t}\n}\n");
        env.addClass(tests2, "p2", "T2Class", "package p2;\n\npublic class T2Class {\n}\n");
        env.addClass(tests2, "p2", "Test2", "package p2;\n\nimport p1.P1Class;\nimport p1.T1Class;\n\npublic class Test2 {\n\tvoid test2() {\n\t\tnew P1Class(); // ok\n\t\tnew P2Class(); // ok\n\t\tnew T1Class(); // ok\n\t\tnew T2Class(); // ok\n\t}\n}\n");
        this.fullBuild();
        this.expectingProblemsFor(env.getWorkspaceRootPath(), "Problem : T1Class cannot be resolved to a type [ resource : </Project1/src/p1/Production1.java> range : <82,89> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <144,151> category : <40> severity : <2>]\nProblem : T2Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <174,181> category : <40> severity : <2>]\nProblem : The import p1.T1Class cannot be resolved [ resource : </Project2/src/p2/Production2.java> range : <39,49> category : <30> severity : <2>]");
        env.changePackageFragmentRootTestAttribute(project2Path, tests2, false);
        this.incrementalBuild();
        this.expectingProblemsFor(env.getWorkspaceRootPath(), "Problem : T1Class cannot be resolved to a type [ resource : </Project1/src/p1/Production1.java> range : <82,89> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <144,151> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project2/tests/p2/Test2.java> range : <141,148> category : <40> severity : <2>]\nProblem : The import p1.T1Class cannot be resolved [ resource : </Project2/src/p2/Production2.java> range : <39,49> category : <30> severity : <2>]\nProblem : The import p1.T1Class cannot be resolved [ resource : </Project2/tests/p2/Test2.java> range : <39,49> category : <30> severity : <2>]");
        this.expectingCompiledClasses(new String[]{"p2.P2Class", "p2.Production2", "p2.T2Class", "p2.Test2"});
        env.changePackageFragmentRootTestAttribute(project1Path, tests1, false);
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingCompiledClasses(new String[]{"p1.P1Class", "p1.P1Unrelated", "p1.Production1", "p1.T1Class", "p1.Test1", "p2.P2Class", "p2.P2Unrelated", "p2.Production2", "p2.T2Class", "p2.Test2"});
        env.changePackageFragmentRootTestAttribute(project2Path, tests2, true);
        this.incrementalBuild();
        this.expectingProblemsFor(env.getWorkspaceRootPath(), "Problem : T2Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <174,181> category : <40> severity : <2>]");
        this.expectingCompiledClasses(new String[]{"p2.P2Class", "p2.Production2", "p2.T2Class", "p2.Test2"});
        env.changePackageFragmentRootTestAttribute(project1Path, tests1, true);
        this.incrementalBuild();
        this.expectingProblemsFor(env.getWorkspaceRootPath(), "Problem : T1Class cannot be resolved to a type [ resource : </Project1/src/p1/Production1.java> range : <82,89> category : <40> severity : <2>]\nProblem : T1Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <144,151> category : <40> severity : <2>]\nProblem : T2Class cannot be resolved to a type [ resource : </Project2/src/p2/Production2.java> range : <174,181> category : <40> severity : <2>]\nProblem : The import p1.T1Class cannot be resolved [ resource : </Project2/src/p2/Production2.java> range : <39,49> category : <30> severity : <2>]");
        this.expectingCompiledClasses(new String[]{"p1.P1Class", "p1.P1Unrelated", "p1.Production1", "p1.T1Class", "p1.Test1", "p2.P2Class", "p2.P2Unrelated", "p2.Production2", "p2.T2Class", "p2.Test2"});
        env.changePackageFragmentRootTestAttribute(project2Path, tests2, false);
        env.changePackageFragmentRootTestAttribute(project1Path, tests1, false);
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingCompiledClasses(new String[]{"p1.P1Class", "p1.P1Unrelated", "p1.Production1", "p1.T1Class", "p1.Test1", "p2.P2Class", "p2.P2Unrelated", "p2.Production2", "p2.T2Class", "p2.Test2"});
    }

    public void testExternalTestJarChanged() throws CoreException, IOException {
        IPath projectPath = env.addProject("Project");
        env.removePackageFragmentRoot(projectPath, "");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IPath tests = env.addTestPackageFragmentRoot(projectPath, "tests");
        IPath classTest = env.addClass(tests, "p", "X", "package p;\npublic class X {\n  void foo() {\n    new q.Y().bar();\n  }\n}");
        String externalJar = String.valueOf(Util.getOutputDirectory()) + File.separator + "test.jar";
        Util.createJar((String[])new String[]{"q/Y.java", "package q;\npublic class Y {\n}"}, new HashMap(), (String)externalJar);
        this.fullBuild();
        this.expectingProblemsFor(classTest, "Problem : q cannot be resolved to a type [ resource : </Project/tests/p/X.java> range : <51,52> category : <40> severity : <2>]");
        env.addExternalTestJar(projectPath, externalJar, false);
        this.incrementalBuild();
        this.expectingProblemsFor(classTest, "Problem : The method bar() is undefined for the type Y [ resource : </Project/tests/p/X.java> range : <57,60> category : <50> severity : <2>]");
        Util.createJar((String[])new String[]{"q/Y.java", "package q;\npublic class Y {\n  public void bar() {\n  }\n}"}, new HashMap(), (String)externalJar);
        env.getProject(projectPath).touch(null);
        this.incrementalBuild();
        this.expectingNoProblems();
    }

    public void testBug536868() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.removePackageFragmentRoot(project1Path, "");
        IPath tests1 = env.addTestPackageFragmentRoot(project1Path, "tests");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.addClass(tests1, "p1", "T1Class", "package p1;\n\npublic class T1Class {\n}\n");
        IPath projectXPath = env.addProject("ProjectX");
        env.addRequiredProjectWithoutTestCode(projectXPath, project1Path, true);
        IPath project2Path = env.addProject("Project2");
        env.removePackageFragmentRoot(project2Path, "");
        IPath tests2 = env.addTestPackageFragmentRoot(project2Path, "tests");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, projectXPath);
        env.addRequiredTestProject(project2Path, project1Path);
        env.addClass(tests2, "p2", "Test2", "package p2;\n\nimport p1.T1Class;\n\npublic class Test2 {\n\tvoid test2() {\n\t\tnew T1Class(); // ok\n\t}\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
    }
}

