/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.nd.indexer.Indexer;

public class TestingEnvironment {
    private boolean isOpen = false;
    private IWorkspace workspace = null;
    private Hashtable projects = null;
    private File tmpDirectory;

    private void addBuilderSpecs(String projectName) {
        try {
            IProject project = this.getProject(projectName);
            IProjectDescription description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public IPath addBinaryClass(IPath packagePath, String className, byte[] contents) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IPath classPath = packagePath.append(String.valueOf(className) + ".class");
        this.createFile(classPath, contents);
        return classPath;
    }

    public IPath addBinaryClass(IPath packageFragmentRootPath, String packageName, String className, byte[] contents) {
        if (packageName != null && packageName.length() > 0) {
            IPath packagePath = this.addPackage(packageFragmentRootPath, packageName);
            return this.addBinaryClass(packagePath, className, contents);
        }
        return this.addBinaryClass(packageFragmentRootPath, className, contents);
    }

    public IPath addClass(IPath packagePath, String className, String contents) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IPath classPath = packagePath.append(String.valueOf(className) + ".java");
        try {
            this.createFile(classPath, contents.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.checkAssertion("e1", false);
        }
        return classPath;
    }

    public IPath addClass(IPath packageFragmentRootPath, String packageName, String className, String contents) {
        if (packageName != null && packageName.length() > 0) {
            IPath packagePath = this.addPackage(packageFragmentRootPath, packageName);
            return this.addClass(packagePath, className, contents);
        }
        return this.addClass(packageFragmentRootPath, className, contents);
    }

    public void addClassFolder(IPath projectPath, IPath classFolderPath, boolean isExported) throws JavaModelException {
        this.addEntry(projectPath, JavaCore.newLibraryEntry((IPath)classFolderPath, null, null, (boolean)isExported));
    }

    public IPath addPackage(IPath packageFragmentRootPath, String packageName) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IPath path = packageFragmentRootPath.append(packageName.replace('.', '/'));
        this.createFolder(path);
        return path;
    }

    public IPath addPackageFragmentRoot(IPath projectPath, String sourceFolderName) throws JavaModelException {
        return this.addPackageFragmentRoot(projectPath, sourceFolderName, null, null);
    }

    public IPath addTestPackageFragmentRoot(IPath projectPath, String sourceFolderName) throws JavaModelException {
        return this.addPackageFragmentRoot(projectPath, sourceFolderName, null, null, "bin-" + sourceFolderName, true);
    }

    public IPath addPackageFragmentRoot(IPath projectPath, String sourceFolderName, IPath[] exclusionPatterns, String specificOutputLocation) throws JavaModelException {
        return this.addPackageFragmentRoot(projectPath, sourceFolderName, null, exclusionPatterns, specificOutputLocation);
    }

    public IPath addPackageFragmentRoot(IPath projectPath, String sourceFolderName, IPath[] inclusionPatterns, IPath[] exclusionPatterns, String specificOutputLocation) throws JavaModelException {
        return this.addPackageFragmentRoot(projectPath, sourceFolderName, inclusionPatterns, exclusionPatterns, specificOutputLocation, false);
    }

    public IPath addPackageFragmentRoot(IPath projectPath, String sourceFolderName, IPath[] inclusionPatterns, IPath[] exclusionPatterns, String specificOutputLocation, boolean isTest) throws JavaModelException {
        IClasspathAttribute[] iClasspathAttributeArray;
        this.checkAssertion("a workspace must be open", this.isOpen);
        IPath path = this.getPackageFragmentRootPath(projectPath, sourceFolderName);
        this.createFolder(path);
        IPath outputPath = null;
        if (specificOutputLocation != null) {
            outputPath = this.getPackageFragmentRootPath(projectPath, specificOutputLocation);
            this.createFolder(outputPath);
        }
        Object[] objectArray = inclusionPatterns == null ? new Path[]{} : inclusionPatterns;
        Object[] objectArray2 = exclusionPatterns == null ? new Path[]{} : exclusionPatterns;
        if (isTest) {
            IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
            iClasspathAttributeArray = iClasspathAttributeArray2;
            iClasspathAttributeArray2[0] = JavaCore.newClasspathAttribute((String)"test", (String)"true");
        } else {
            iClasspathAttributeArray = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
        }
        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path, (IPath[])objectArray, (IPath[])objectArray2, (IPath)outputPath, (IClasspathAttribute[])iClasspathAttributeArray);
        this.addEntry(projectPath, entry);
        return path;
    }

    public void addProject(IProject project) {
        this.projects.put(project.getName(), project);
    }

    public IPath addProject(String projectName) {
        return this.addProject(projectName, "1.4");
    }

    public IPath addProject(String projectName, String compliance) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IProject project = this.createProject(projectName);
        int requiredComplianceFlag = 0;
        String compilerVersion = null;
        if ("1.5".equals(compliance)) {
            requiredComplianceFlag = 4;
            compilerVersion = "1.5";
        } else if ("1.6".equals(compliance)) {
            requiredComplianceFlag = 8;
            compilerVersion = "1.6";
        } else if ("1.7".equals(compliance)) {
            requiredComplianceFlag = 16;
            compilerVersion = "1.7";
        } else if ("1.8".equals(compliance)) {
            requiredComplianceFlag = 32;
            compilerVersion = "1.8";
        } else if ("9".equals(compliance)) {
            requiredComplianceFlag = 64;
            compilerVersion = "9";
        } else if (!"1.4".equals(compliance) && !"1.3".equals(compliance)) {
            throw new UnsupportedOperationException("Test framework doesn't support compliance level: " + compliance);
        }
        if (requiredComplianceFlag != 0) {
            if (CompilerOptions.versionToJdkLevel((String)System.getProperty("java.specification.version")) < (long)requiredComplianceFlag) {
                throw new RuntimeException("This test requires a " + compliance + " JRE");
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("org.eclipse.jdt.core.compiler.compliance", compilerVersion);
            options.put("org.eclipse.jdt.core.compiler.source", compilerVersion);
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compilerVersion);
            javaProject.setOptions(options);
        }
        return project.getFullPath();
    }

    public void addRequiredProject(IPath projectPath, IPath requiredProjectPath) throws JavaModelException {
        this.addRequiredProject(projectPath, requiredProjectPath, new IPath[0], new IPath[0], false);
    }

    public void addRequiredTestProject(IPath projectPath, IPath requiredProjectPath) throws JavaModelException {
        this.checkAssertion("required project must not be in project", !projectPath.isPrefixOf(requiredProjectPath));
        IAccessRule[] accessRules = ClasspathEntry.getAccessRules((IPath[])new IPath[0], (IPath[])new IPath[0]);
        this.addEntry(projectPath, JavaCore.newProjectEntry((IPath)requiredProjectPath, (IAccessRule[])accessRules, (boolean)true, (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"test", (String)"true")}, (boolean)false));
    }

    public void addRequiredProjectWithoutTestCode(IPath projectPath, IPath requiredProjectPath) throws JavaModelException {
        this.addRequiredProjectWithoutTestCode(projectPath, requiredProjectPath, false);
    }

    public void addRequiredProjectWithoutTestCode(IPath projectPath, IPath requiredProjectPath, boolean isExported) throws JavaModelException {
        this.checkAssertion("required project must not be in project", !projectPath.isPrefixOf(requiredProjectPath));
        IAccessRule[] accessRules = ClasspathEntry.getAccessRules((IPath[])new IPath[0], (IPath[])new IPath[0]);
        this.addEntry(projectPath, JavaCore.newProjectEntry((IPath)requiredProjectPath, (IAccessRule[])accessRules, (boolean)true, (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"without_test_code", (String)"true")}, (boolean)isExported));
    }

    public void addRequiredTestProjectWithoutTestCode(IPath projectPath, IPath requiredProjectPath) throws JavaModelException {
        this.checkAssertion("required project must not be in project", !projectPath.isPrefixOf(requiredProjectPath));
        IAccessRule[] accessRules = ClasspathEntry.getAccessRules((IPath[])new IPath[0], (IPath[])new IPath[0]);
        this.addEntry(projectPath, JavaCore.newProjectEntry((IPath)requiredProjectPath, (IAccessRule[])accessRules, (boolean)true, (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"test", (String)"true"), JavaCore.newClasspathAttribute((String)"without_test_code", (String)"true")}, (boolean)false));
    }

    public void addRequiredProject(IPath projectPath, IPath requiredProjectPath, IPath[] accessibleFiles, IPath[] nonAccessibleFiles, boolean isExported) throws JavaModelException {
        this.checkAssertion("required project must not be in project", !projectPath.isPrefixOf(requiredProjectPath));
        IAccessRule[] accessRules = ClasspathEntry.getAccessRules((IPath[])accessibleFiles, (IPath[])nonAccessibleFiles);
        this.addEntry(projectPath, JavaCore.newProjectEntry((IPath)requiredProjectPath, (IAccessRule[])accessRules, (boolean)true, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)isExported));
    }

    public void addRequiredProject(IPath projectPath, IPath requiredProjectPath, IPath rule, int ruleKind) throws JavaModelException {
        this.checkAssertion("required project must not be in project", !projectPath.isPrefixOf(requiredProjectPath));
        IAccessRule accessRule = JavaCore.newAccessRule((IPath)rule, (int)ruleKind);
        this.addEntry(projectPath, JavaCore.newProjectEntry((IPath)requiredProjectPath, (IAccessRule[])new IAccessRule[]{accessRule}, (boolean)true, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false));
    }

    public void addRequiredProject(IPath projectPath, IPath requiredProjectPath, boolean isOptional) throws JavaModelException {
        IClasspathAttribute[] iClasspathAttributeArray;
        this.checkAssertion("required project must not be in project", !projectPath.isPrefixOf(requiredProjectPath));
        if (isOptional) {
            IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
            iClasspathAttributeArray = iClasspathAttributeArray2;
            iClasspathAttributeArray2[0] = JavaCore.newClasspathAttribute((String)"optional", (String)"true");
        } else {
            iClasspathAttributeArray = new IClasspathAttribute[]{};
        }
        IClasspathAttribute[] attributes = iClasspathAttributeArray;
        this.addEntry(projectPath, JavaCore.newProjectEntry((IPath)requiredProjectPath, null, (boolean)true, (IClasspathAttribute[])attributes, (boolean)false));
    }

    public void addExternalFolders(IPath projectPath, String[] folders) throws JavaModelException {
        this.addExternalFolders(projectPath, folders, false);
    }

    public void addExternalFolders(IPath projectPath, String[] folders, boolean isExported) throws JavaModelException {
        int i = 0;
        int max = folders.length;
        while (i < max) {
            String folder = folders[i];
            this.checkAssertion("folder name must not end with .zip or .jar", !folder.endsWith(".zip") && !folder.endsWith(".jar"));
            this.addEntry(projectPath, JavaCore.newLibraryEntry((IPath)new Path(folder), null, null, (boolean)isExported));
            ++i;
        }
    }

    public void addExternalJars(IPath projectPath, String[] jars) throws JavaModelException {
        this.addExternalJars(projectPath, jars, false);
    }

    public void addExternalJar(IPath projectPath, String jar) throws JavaModelException {
        this.addExternalJar(projectPath, jar, false);
    }

    public void addExternalJars(IPath projectPath, String[] jars, boolean isExported) throws JavaModelException {
        int i = 0;
        int max = jars.length;
        while (i < max) {
            String jar = jars[i];
            this.addEntry(projectPath, JavaCore.newLibraryEntry((IPath)new Path(jar), null, null, (boolean)isExported));
            ++i;
        }
    }

    public void addExternalJar(IPath projectPath, String jar, boolean isExported) throws JavaModelException {
        this.addEntry(projectPath, JavaCore.newLibraryEntry((IPath)new Path(jar), null, null, (boolean)isExported));
    }

    public void addExternalTestJar(IPath projectPath, String jar, boolean isExported) throws JavaModelException {
        this.addEntry(projectPath, JavaCore.newLibraryEntry((IPath)new Path(jar), null, null, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"test", (String)"true")}, (boolean)isExported));
    }

    public void addLibrary(IPath projectPath, IPath libraryPath, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath) throws JavaModelException {
        this.addEntry(projectPath, JavaCore.newLibraryEntry((IPath)libraryPath, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath));
    }

    public void addEntry(IPath projectPath, IClasspathEntry entryPath) throws JavaModelException {
        IClasspathEntry[] classpath = this.getRawClasspath(projectPath);
        IClasspathEntry[] newClaspath = new IClasspathEntry[classpath.length + 1];
        System.arraycopy(classpath, 0, newClaspath, 0, classpath.length);
        newClaspath[classpath.length] = entryPath;
        this.setClasspath(projectPath, newClaspath);
    }

    public IPath addFile(IPath root, String fileName, String contents) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IPath filePath = root.append(fileName);
        try {
            this.createFile(filePath, contents.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.checkAssertion("e1", false);
        }
        return filePath;
    }

    public IPath addFolder(IPath root, String folderName) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IPath folderPath = root.append(folderName);
        this.createFolder(folderPath);
        return folderPath;
    }

    public IPath addInternalJar(IPath projectPath, String zipName, byte[] contents) throws JavaModelException {
        return this.addInternalJar(projectPath, zipName, contents, false);
    }

    public IPath addInternalJar(IPath projectPath, String zipName, byte[] contents, boolean isExported) throws JavaModelException {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IPath path = projectPath.append(zipName);
        this.removeInternalJar(projectPath, zipName);
        this.createFile(path, contents);
        this.addEntry(projectPath, JavaCore.newLibraryEntry((IPath)path, null, null, (boolean)isExported));
        return path;
    }

    private void checkAssertion(String message, boolean b) {
        Assert.isTrue((boolean)b, (String)message);
    }

    public void cleanBuild() {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getWorkspace().build(15, null);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
    }

    public void cleanBuild(String projectName) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getProject(projectName).build(15, null);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
    }

    public void close() {
        try {
            if (this.projects != null) {
                Enumeration projectNames = this.projects.keys();
                while (projectNames.hasMoreElements()) {
                    String projectName = (String)projectNames.nextElement();
                    this.getJavaProject(projectName).getJavaModel().close();
                }
            }
            this.closeWorkspace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void closeProject(IPath projectPath) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getJavaProject(projectPath).getProject().close(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void closeWorkspace() {
        this.isOpen = false;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IFile createFile(IPath path, byte[] contents) {
        ByteArrayInputStream is = null;
        IFile file = this.workspace.getRoot().getFile(path);
        is = new ByteArrayInputStream(contents);
        if (file.exists()) {
            file.setContents((InputStream)is, true, false, null);
        } else {
            file.create((InputStream)is, true, null);
        }
        IFile iFile = file;
        if (is == null) return iFile;
        try {
            is.close();
            return iFile;
        }
        catch (IOException iOException) {}
        return iFile;
        catch (CoreException e) {
            try {
                this.handle((Exception)((Object)e));
                if (is == null) return null;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    private IFolder createFolder(IPath path) {
        this.checkAssertion("root", !path.isRoot());
        if (path.segmentCount() <= 1) {
            return null;
        }
        IFolder folder = this.workspace.getRoot().getFolder(path);
        if (!folder.exists()) {
            this.createFolder(path.removeLastSegments(1));
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                this.handle((Exception)((Object)e));
            }
        }
        return folder;
    }

    private IProject createProject(String projectName) {
        final IProject project = this.workspace.getRoot().getProject(projectName);
        try {
            IWorkspaceRunnable create = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.create(null, null);
                    project.open(null);
                }
            };
            this.workspace.run(create, null);
            this.projects.put(projectName, project);
            this.addBuilderSpecs(projectName);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
        return project;
    }

    void deleteResource(IResource resource) {
        int retryCount = 0;
        IStatus status = null;
        while (++retryCount <= 6) {
            status = Util.delete((IResource)resource);
            if (status.isOK()) {
                return;
            }
            System.gc();
        }
        this.handleCoreException(new CoreException(status));
    }

    public void fullBuild() {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getWorkspace().build(6, null);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
    }

    public void fullBuild(IPath projectPath) {
        this.fullBuild(projectPath.lastSegment());
    }

    public void fullBuild(String projectName) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getProject(projectName).build(6, null);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
    }

    public IClasspathEntry[] getClasspath(IPath projectPath) {
        try {
            this.checkAssertion("a workspace must be open", this.isOpen);
            JavaProject javaProject = (JavaProject)JavaCore.create((IProject)this.getProject(projectPath));
            return javaProject.getExpandedClasspath();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            this.checkAssertion("JavaModelException", false);
            return null;
        }
    }

    public IClasspathEntry[] getRawClasspath(IPath projectPath) {
        try {
            this.checkAssertion("a workspace must be open", this.isOpen);
            JavaProject javaProject = (JavaProject)JavaCore.create((IProject)this.getProject(projectPath));
            return javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            this.checkAssertion("JavaModelException", false);
            return null;
        }
    }

    public IJavaProject getJavaProject(IPath projectPath) {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject(projectPath));
        Assert.isNotNull((Object)javaProject);
        return javaProject;
    }

    public IJavaProject getJavaProject(String projectName) {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject(projectName));
        Assert.isNotNull((Object)javaProject);
        return javaProject;
    }

    public IPath getOutputLocation(IPath projectPath) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.getProject(projectPath));
            return javaProject.getOutputLocation();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public Problem[] getProblems() {
        return this.getProblemsFor(this.getWorkspaceRootPath());
    }

    public Problem[] getProblemsFor(IPath path) {
        return this.getProblemsFor(path, null);
    }

    public Problem[] getProblemsFor(IPath path, String additionalMarkerType) {
        IProject p;
        Object resource = path.equals((Object)this.getWorkspaceRootPath()) ? this.getWorkspace().getRoot() : ((p = this.getProject(path)) != null && path.equals((Object)p.getFullPath()) ? this.getProject(path.lastSegment()) : (path.getFileExtension() == null ? this.getWorkspace().getRoot().getFolder(path) : this.getWorkspace().getRoot().getFile(path)));
        try {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            IMarker[] markers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            int i = 0;
            while (i < markers.length) {
                problems.add(new Problem(markers[i]));
                ++i;
            }
            markers = resource.findMarkers("org.eclipse.jdt.core.buildpath_problem", true, 2);
            i = 0;
            while (i < markers.length) {
                problems.add(new Problem(markers[i]));
                ++i;
            }
            markers = resource.findMarkers("org.eclipse.jdt.core.task", true, 2);
            i = 0;
            while (i < markers.length) {
                problems.add(new Problem(markers[i]));
                ++i;
            }
            if (additionalMarkerType != null) {
                markers = resource.findMarkers(additionalMarkerType, true, 2);
                i = 0;
                while (i < markers.length) {
                    problems.add(new Problem(markers[i]));
                    ++i;
                }
            }
            Problem[] result = new Problem[problems.size()];
            problems.toArray(result);
            Arrays.sort(result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            return result;
        }
        catch (CoreException coreException) {
            return new Problem[0];
        }
    }

    public IMarker[] getTaskMarkersFor(IPath path) {
        IProject p;
        Object resource = null;
        resource = path.equals((Object)this.getWorkspaceRootPath()) ? this.getWorkspace().getRoot() : ((p = this.getProject(path)) != null && path.equals((Object)p.getFullPath()) ? this.getProject(path.lastSegment()) : (path.getFileExtension() == null ? this.getWorkspace().getRoot().getFolder(path) : this.getWorkspace().getRoot().getFile(path)));
        try {
            if (resource != null) {
                IMarker[] markers = resource.findMarkers("org.eclipse.jdt.core.task", true, 2);
                if (markers.length > 1) {
                    Arrays.sort(markers, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            IMarker marker1 = (IMarker)o1;
                            IMarker marker2 = (IMarker)o2;
                            try {
                                int start1 = (Integer)marker1.getAttribute("charStart");
                                int start2 = (Integer)marker2.getAttribute("charStart");
                                return start1 - start2;
                            }
                            catch (CoreException coreException) {
                                return 0;
                            }
                        }
                    });
                }
                return markers;
            }
        }
        catch (CoreException coreException) {}
        return new IMarker[0];
    }

    public IPath getPackagePath(IPath root, String packageName) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        if (packageName.length() == 0) {
            return root;
        }
        return root.append(packageName.replace('.', '/'));
    }

    public IPath getPackageFragmentRootPath(IPath projectPath, String name) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        if (name.length() == 0) {
            return projectPath;
        }
        return projectPath.append(name);
    }

    public IProject getProject(String projectName) {
        return (IProject)this.projects.get(projectName);
    }

    public IProject getProject(IPath projectPath) {
        return (IProject)this.projects.get(projectPath.lastSegment());
    }

    File getTmpDirectory() {
        if (this.tmpDirectory == null) {
            this.tmpDirectory = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "org.eclipse.jdt.core.builder.tests.tmp");
            if (this.tmpDirectory.exists() && !this.tmpDirectory.isDirectory()) {
                Util.delete((File)this.tmpDirectory);
            }
            this.tmpDirectory.mkdir();
        }
        return this.tmpDirectory;
    }

    void deleteTmpDirectory() {
        if (this.tmpDirectory != null) {
            Util.delete((File)this.tmpDirectory);
            this.tmpDirectory = null;
        }
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public IPath getWorkspaceRootPath() {
        return this.getWorkspace().getRoot().getLocation();
    }

    private IPath getJarRootPath(IPath projectPath) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        return this.getProject(projectPath).getFullPath();
    }

    void handle(Exception e) {
        if (e instanceof CoreException) {
            this.handleCoreException((CoreException)((Object)e));
        } else {
            e.printStackTrace();
            Assert.isTrue((boolean)false);
        }
    }

    private void handleCoreException(CoreException e) {
        e.printStackTrace();
        IStatus status = e.getStatus();
        String message = e.getMessage();
        if (status.isMultiStatus()) {
            MultiStatus multiStatus = (MultiStatus)status;
            IStatus[] children = multiStatus.getChildren();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            int max = children.length;
            while (i < max) {
                IStatus child = children[i];
                if (child != null) {
                    buffer.append(child.getMessage());
                    buffer.append(System.getProperty("line.separator"));
                    Throwable childException = child.getException();
                    if (childException != null) {
                        childException.printStackTrace();
                    }
                }
                ++i;
            }
            message = buffer.toString();
        }
        Assert.isTrue((boolean)false, (String)("Core exception in testing environment: " + message));
    }

    public void incrementalBuild() {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getWorkspace().build(10, null);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
    }

    public void incrementalBuild(IPath projectPath) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getProject(projectPath).build(10, null);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isAutoBuilding() {
        IWorkspace w = this.getWorkspace();
        IWorkspaceDescription d = w.getDescription();
        return d.isAutoBuilding();
    }

    public void openEmptyWorkspace() {
        this.close();
        this.openWorkspace();
        this.projects = new Hashtable(10);
        this.setup();
    }

    public void openProject(IPath projectPath) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getJavaProject(projectPath).getProject().open(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void openWorkspace() {
        try {
            this.closeWorkspace();
            this.workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = this.workspace.getDescription();
            description.setAutoBuilding(false);
            this.workspace.setDescription(description);
        }
        catch (Exception e) {
            this.handle(e);
        }
    }

    public void renameCU(IPath packagePath, String cuName, String newName) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IFolder packageFolder = this.workspace.getRoot().getFolder(packagePath);
        try {
            packageFolder.getFile(cuName).move(packageFolder.getFile(newName).getFullPath(), true, null);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
    }

    public void removeBinaryClass(IPath packagePath, String className) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        className = String.valueOf(className) + ".class";
        IFolder packageFolder = this.workspace.getRoot().getFolder(packagePath);
        this.deleteResource((IResource)packageFolder.getFile(className));
    }

    public void removeClass(IPath packagePath, String className) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        className = String.valueOf(className) + ".java";
        IFolder packageFolder = this.workspace.getRoot().getFolder(packagePath);
        this.deleteResource((IResource)packageFolder.getFile(className));
    }

    public void removePackage(IPath packageFragmentRootPath, String packageName) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IPath path = packageFragmentRootPath.append(packageName.replace('.', '/'));
        IFolder folder = this.workspace.getRoot().getFolder(path);
        this.deleteResource((IResource)folder);
    }

    public void removePackageFragmentRoot(IPath projectPath, String packageFragmentRootName) throws JavaModelException {
        IFolder folder;
        this.checkAssertion("a workspace must be open", this.isOpen);
        if (packageFragmentRootName.length() > 0 && (folder = this.getProject(projectPath).getFolder(packageFragmentRootName)).exists()) {
            this.deleteResource((IResource)folder);
        }
        IPath rootPath = this.getPackageFragmentRootPath(projectPath, packageFragmentRootName);
        this.removeEntry(projectPath, rootPath);
    }

    public void removeProject(IPath projectPath) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getJavaProject(projectPath).close();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        IProject project = this.getProject(projectPath);
        this.deleteResource((IResource)project);
    }

    public void removeRequiredProject(IPath projectPath, IPath requiredProject) throws JavaModelException {
        this.removeEntry(projectPath, requiredProject);
    }

    public void resetWorkspace() {
        if (this.projects != null) {
            Enumeration projectNames = this.projects.keys();
            while (projectNames.hasMoreElements()) {
                String projectName = (String)projectNames.nextElement();
                this.removeProject(this.getProject(projectName).getFullPath());
            }
        }
    }

    public void removeInternalJar(IPath projectPath, String zipName) throws JavaModelException {
        this.checkAssertion("a workspace must be open", this.isOpen);
        this.checkAssertion("zipName must end with .zip or .jar", zipName.endsWith(".zip") || zipName.endsWith(".jar"));
        IPath zipPath = this.getJarRootPath(projectPath).append(zipName);
        try {
            this.getJavaProject(projectPath).getPackageFragmentRoot((IResource)this.getWorkspace().getRoot().getFile(zipPath)).close();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        this.removePackageFragmentRoot(projectPath, zipName);
        IFile file = this.getProject(projectPath).getFile(zipName);
        this.deleteResource((IResource)file);
    }

    public void removeExternalJar(IPath projectPath, IPath jarPath) throws JavaModelException {
        this.checkAssertion("a workspace must be open", this.isOpen);
        this.removeEntry(projectPath, jarPath);
    }

    private void removeEntry(IPath projectPath, IPath entryPath) throws JavaModelException {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IClasspathEntry[] oldEntries = this.getRawClasspath(projectPath);
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].getPath().equals((Object)entryPath)) {
                IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length - 1];
                System.arraycopy(oldEntries, 0, newEntries, 0, i);
                System.arraycopy(oldEntries, i + 1, newEntries, i, oldEntries.length - i - 1);
                this.setClasspath(projectPath, newEntries);
            }
            ++i;
        }
    }

    public void changePackageFragmentRootTestAttribute(IPath projectPath, IPath entryPath, boolean isTest) throws JavaModelException {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IClasspathEntry[] oldEntries = this.getRawClasspath(projectPath);
        int i = 0;
        while (i < oldEntries.length) {
            IClasspathEntry oldEntry = oldEntries[i];
            if (oldEntry.getPath().equals((Object)entryPath)) {
                IClasspathEntry entry;
                IClasspathEntry[] newEntries = (IClasspathEntry[])oldEntries.clone();
                IClasspathAttribute[] classpathAttributes = (IClasspathAttribute[])Arrays.stream(oldEntry.getExtraAttributes()).filter(e -> !e.getName().equals("test")).toArray(IClasspathAttribute[]::new);
                if (isTest) {
                    int length = classpathAttributes.length;
                    IClasspathAttribute[] iClasspathAttributeArray = classpathAttributes;
                    classpathAttributes = new IClasspathAttribute[length + 1];
                    System.arraycopy(iClasspathAttributeArray, 0, classpathAttributes, 0, length);
                    classpathAttributes[length] = JavaCore.newClasspathAttribute((String)"test", (String)"true");
                }
                newEntries[i] = entry = JavaCore.newSourceEntry((IPath)entryPath, (IPath[])oldEntry.getInclusionPatterns(), (IPath[])oldEntry.getExclusionPatterns(), (IPath)oldEntry.getOutputLocation(), (IClasspathAttribute[])classpathAttributes);
                this.setClasspath(projectPath, newEntries);
                return;
            }
            ++i;
        }
    }

    public void removeFile(IPath filePath) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        this.deleteResource((IResource)this.workspace.getRoot().getFile(filePath));
    }

    public void removeFolder(IPath folderPath) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IFolder folder = this.workspace.getRoot().getFolder(folderPath);
        this.deleteResource((IResource)folder);
    }

    public void setAutoBuilding(boolean value) {
        try {
            IWorkspace w = this.getWorkspace();
            IWorkspaceDescription d = w.getDescription();
            d.setAutoBuilding(value);
            w.setDescription(d);
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.checkAssertion("CoreException", false);
        }
    }

    public void setBuildOrder(String[] projects) {
        try {
            IWorkspace w = this.getWorkspace();
            IWorkspaceDescription d = w.getDescription();
            d.setBuildOrder(projects);
            w.setDescription(d);
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.checkAssertion("CoreException", false);
        }
    }

    public void setClasspath(IPath projectPath, IClasspathEntry[] entries) throws JavaModelException {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject(projectPath));
        javaProject.setRawClasspath(entries, null);
    }

    public IPath setExternalOutputFolder(IPath projectPath, String name, IPath externalOutputLocation) {
        IPath result = null;
        try {
            this.checkAssertion("a workspace must be open", this.isOpen);
            IProject p = this.getProject(projectPath);
            IFolder f = p.getFolder(name);
            f.createLink(externalOutputLocation, 16, null);
            result = f.getFullPath();
            IJavaProject javaProject = JavaCore.create((IProject)p);
            javaProject.setOutputLocation(result, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.checkAssertion("CoreException", false);
        }
        return result;
    }

    public IPath setOutputFolder(IPath projectPath, String outputFolder) {
        IPath outputPath = null;
        try {
            this.checkAssertion("a workspace must be open", this.isOpen);
            IJavaProject javaProject = JavaCore.create((IProject)this.getProject(projectPath));
            outputPath = projectPath.append(outputFolder);
            javaProject.setOutputLocation(outputPath, null);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            this.checkAssertion("JavaModelException", false);
        }
        return outputPath;
    }

    private void setup() {
        this.isOpen = true;
    }

    public void waitForAutoBuild() {
        this.checkAssertion("a workspace must be open", this.isOpen);
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                Indexer.getInstance().waitForIndex(null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                this.handle((Exception)((Object)e));
            }
            catch (InterruptedException interruptedException) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public void waitForManualRefresh() {
        this.checkAssertion("a workspace must be open", this.isOpen);
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
                Indexer.getInstance().waitForIndex(null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                this.handle((Exception)((Object)e));
            }
            catch (InterruptedException interruptedException) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }
}

