/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class ClassLiteralAccessCompletionTest
extends AbstractCompletionTest {
    public ClassLiteralAccessCompletionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return ClassLiteralAccessCompletionTest.buildAllCompliancesTestSuite(ClassLiteralAccessCompletionTest.class);
    }

    public void testArrayType() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tString[].;\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "String[].", "<CompleteOnClassLiteralAccess:String[].>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnClassLiteralAccess:String[].>;\n  }\n}\n", "", "String[].", "<complete on array type member>");
    }

    public void testArrayTypeWithNonEmptyIdentifier() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tString[].class;\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "String[].cl", "<CompleteOnClassLiteralAccess:String[].cl>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnClassLiteralAccess:String[].cl>;\n  }\n}\n", "cl", "String[].class", "<complete on array type member with non empty identifier>");
    }

    public void testPrimitiveArrayType() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tint[].;\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "int[].", "<CompleteOnClassLiteralAccess:int[].>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnClassLiteralAccess:int[].>;\n  }\n}\n", "", "int[].", "<complete on primitive array type member>");
    }

    public void testPrimitiveArrayTypeWithNonEmptyIdentifier() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tint[].class;\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "int[].cl", "<CompleteOnClassLiteralAccess:int[].cl>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnClassLiteralAccess:int[].cl>;\n  }\n}\n", "cl", "int[].class", "<complete on primitive array type member with non empty identifier>");
    }

    public void testPrimitiveType() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tint.;\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "int.", "<CompleteOnClassLiteralAccess:int.>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnClassLiteralAccess:int.>;\n  }\n}\n", "", "int.", "<complete on primitive type member>");
    }

    public void testPrimitiveTypeWithNonEmptyIdentifier() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tint.class;\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "int.cl", "<CompleteOnClassLiteralAccess:int.cl>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnClassLiteralAccess:int.cl>;\n  }\n}\n", "cl", "int.class", "<complete on primitive type member with non empty identifier>");
    }
}

