/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class MethodInvocationCompletionTest
extends AbstractCompletionTest {
    public MethodInvocationCompletionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return MethodInvocationCompletionTest.buildAllCompliancesTestSuite(MethodInvocationCompletionTest.class);
    }

    public void test1FVVWS8_1() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tfor (int i = 10; i > 0; --i)\t\t\n\t\t\tfred(\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:fred()>", "class X {\n  X() {\n  }\n  void foo() {\n    int i;\n    <CompleteOnMessageSend:fred()>;\n  }\n}\n", "", "fred(", "<1FVVWS8_1>");
    }

    public void test1FVVWS8_2() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tif (true)\t\t\t\t\t\t\t\n\t\t\tfred(\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:fred()>", "class X {\n  X() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:fred()>;\n  }\n}\n", "", "fred(", "<1FVVWS8_2>");
    }

    public void test1FW2ZTB_1() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\t\t\n\tint[] array;\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tfor (int i = this.array.length; i > 0; --i)\t\n\t\t\tfred(\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:fred()>", "class X {\n  int[] array;\n  X() {\n  }\n  void foo() {\n    int i;\n    <CompleteOnMessageSend:fred()>;\n  }\n}\n", "", "fred(", "<1FW2ZTB_1");
    }

    public void test1FW2ZTB_2() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\t\t\n\tint[] array;\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\n\t\tbar(this.array.length, 10, fred(\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:fred()>", "class X {\n  int[] array;\n  X() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:fred()>;\n  }\n}\n", "", "fred(", "<1FW2ZTB_2");
    }

    public void test1FW35YZ_1() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tbar(primary().fred(\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:primary().fred()>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:primary().fred()>;\n  }\n}\n", "", "fred(", "<1FW35YZ_1>");
    }

    public void test1FW35YZ_2() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tbar(primary().new X(\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "X(", "<CompleteOnQualifiedAllocationExpression:primary().new X()>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnQualifiedAllocationExpression:primary().new X()>;\n  }\n}\n", "", "", "<1FW35YZ_2>");
    }

    public void test1FWYBKF() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\t\tthis.x.bar(\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "bar(", "<CompleteOnMessageSend:this.x.bar()>", "class X {\n  X() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:this.x.bar()>;\n  }\n}\n", "", "bar(", "<1FWYBKF>");
    }

    public void test1GAJBUQ() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tx.y.Z.fred(buzz());\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(buzz()", "<CompleteOnMessageSend:x.y.Z.fred(buzz())>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:x.y.Z.fred(buzz())>;\n  }\n}\n", "", "fred(buzz()", "<1GAJBUQ>");
    }

    public void testAfterEmptyAnonymous() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tthis.fred(new Runnable() {}, 2, i);\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(new Runnable() {}, ", "<CompleteOnMessageSend:this.fred(new Runnable() {\n})>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:this.fred(new Runnable() {\n})>;\n  }\n}\n", "", "fred(new Runnable() {}, ", "<completion just before second parameter, the first parameter being an empty anonymous class>");
    }

    public void testAfterFirstParameter() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tthis.fred(\"abc\" , 2, i);\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(\"abc\" ", "<CompleteOnMessageSend:this.fred(\"abc\")>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:this.fred(\"abc\")>;\n  }\n}\n", "", "fred(\"abc\" ", "<completion just after first parameter>");
    }

    public void testBeforeFirstParameter() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tthis.fred(1, 2, i);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:this.fred()>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:this.fred()>;\n  }\n}\n", "", "fred(", "<completion just before first parameter>");
    }

    public void testBeforeLastParameter() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tthis.fred(1, 2, i);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(1, 2,", "<CompleteOnMessageSend:this.fred(1, 2)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:this.fred(1, 2)>;\n  }\n}\n", "", "fred(1, 2,", "<completion just before last parameter>");
    }

    public void testBeforeSecondParameter() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tthis.fred(1, 2, i);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(1, ", "<CompleteOnMessageSend:this.fred(1)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:this.fred(1)>;\n  }\n}\n", "", "fred(1, ", "<completion just before second parameter>");
    }

    public void testEmptyInFirstParameter() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tthis.fred(\"abc\" + , 2, i);\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(\"abc\" +", "<CompleteOnName:>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    (\"abc\" + <CompleteOnName:>);\n  }\n}\n", "", "", "<completion empty in first parameter>");
    }

    public void testInFirstParameter() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tthis.fred(\"abc\" + bizz, 2, i);\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(\"abc\" + bi", "<CompleteOnName:bi>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    (\"abc\" + <CompleteOnName:bi>);\n  }\n}\n", "bi", "bizz", "<completion inside first parameter>");
    }

    public void testInIfStatement() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tif (true) {\t\t\t\t\t\t\t\n\t\t\tbar.fred();\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:bar.fred()>", "class X {\n  X() {\n  }\n  void foo() {\n    {\n      <CompleteOnMessageSend:bar.fred()>;\n    }\n  }\n}\n", "", "fred(", "<completion inside a if statement>");
    }

    public void testLabeledWithExpressionReceiver() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tlabel1: bar().fred(1, 2, o);\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(1, 2,", "<CompleteOnMessageSend:bar().fred(1, 2)>", "class X {\n  X() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:bar().fred(1, 2)>;\n  }\n}\n", "", "fred(1, 2,", new String[]{"label1"}, "<completion in labeled method invocation with expression receiver>");
    }

    public void testLabeledWithoutReceiver() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tlabel1: fred(1, 2, o);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(1, 2,", "<CompleteOnMessageSend:fred(1, 2)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:fred(1, 2)>;\n  }\n}\n", "", "fred(1, 2,", new String[]{"label1"}, "<completion in labeled method invocation without receiver>");
    }

    public void testNoReceiver() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tfred();\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:fred()>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:fred()>;\n  }\n}\n", "", "fred(", "<completion on method invocation with no receiver>");
    }

    public void testSpaceThenFirstParameter() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tthis.fred( 1, 2, i);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred( ", "<CompleteOnMessageSend:this.fred()>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:this.fred()>;\n  }\n}\n", "", "fred( ", "<completion just before first parameter with a space after open parenthesis>");
    }

    public void testSuper() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tsuper.fred(1, 2, i);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:super.fred()>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:super.fred()>;\n  }\n}\n", "", "fred(", "<completion on super method invocation>");
    }

    public void testWithExpressionReceiver() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tbar().fred();\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:bar().fred()>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:bar().fred()>;\n  }\n}\n", "", "fred(", "<completion on method invocation with expression receiver>");
    }

    public void testWithNameReceiver() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tVector v = new Vector();\t\t\t\n\t\tv.addElement(\"1\");\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "addElement(", "<CompleteOnMessageSend:v.addElement()>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    Vector v;\n    <CompleteOnMessageSend:v.addElement()>;\n  }\n}\n", "", "addElement(", "<completion with name receiver>");
    }

    public void testWithNameReceiverAfterConditionalExpression() {
        this.runTestCheckMethodParse("class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tbuzz.test(cond ? max : min);\t\t\n\t\tbar.fred();\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:bar.fred()>", "class X {\n  X() {\n  }\n  void foo() {\n    <CompleteOnMessageSend:bar.fred()>;\n  }\n}\n", "", "fred(", new String[0], "<completion with name receiver after conditional expression>");
    }

    public void testWithNameReceiverAndTwoArgs() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tX x = new X();\t\t\t\t\t\t\n\t\tx.fred(1, 2, o);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x.fred(1, 2,", "<CompleteOnMessageSend:x.fred(1, 2)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    X x;\n    <CompleteOnMessageSend:x.fred(1, 2)>;\n  }\n}\n", "", "fred(1, 2,", "<completion with name receiver and 2 arguments>");
    }

    public void testWithQualifiedNameReceiver() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tX x = new X();\t\t\t\t\t\t\n\t\ty.x.fred(1, 2, o);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x.fred(1, 2,", "<CompleteOnMessageSend:y.x.fred(1, 2)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    X x;\n    <CompleteOnMessageSend:y.x.fred(1, 2)>;\n  }\n}\n", "", "fred(1, 2,", "<completion with qualified name receiver>");
    }
}

