/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractSyntaxTreeTest;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class ModuleDeclarationSyntaxTest
extends AbstractSyntaxTreeTest {
    public ModuleDeclarationSyntaxTest(String name, String referenceCompiler, String referenceCompilerTestsScratchArea) {
        super(name, referenceCompiler, referenceCompilerTestsScratchArea);
    }

    public static Class<?> testClass() {
        return ModuleDeclarationSyntaxTest.class;
    }

    @Override
    public void initialize(CompilerTestSetup setUp) {
        super.initialize(setUp);
    }

    public static Test suite() {
        return ModuleDeclarationSyntaxTest.buildMinimalComplianceTestSuite(ModuleDeclarationSyntaxTest.testClass(), 64);
    }

    public ModuleDeclarationSyntaxTest(String testName) {
        super(testName, null, null);
    }

    public void test0001() throws IOException {
        String source = "module com.greetings {\n}\n";
        String expectedUnitToString = "module com.greetings {\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0002() throws IOException {
        String source = "module com.greetings {\nrequires org.astro;}\n";
        String expectedUnitToString = "module com.greetings {\n  requires org.astro;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0003() throws IOException {
        String source = "module org.astro {\n    exports org.astro;\n}\n";
        String expectedUnitToString = "module org.astro {\n  exports org.astro;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0004() throws IOException {
        String source = "module org.astro {\n    exports org.astro to com.greetings, com.example1, com.example2;\n}\n";
        String expectedUnitToString = "module org.astro {\n  exports org.astro to com.greetings, com.example1, com.example2;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0005() throws IOException {
        String source = "module com.socket {\n    exports com.socket;\n    exports com.socket.spi;\n    uses com.socket.spi.NetworkSocketProvider;\n}\n";
        String expectedUnitToString = "module com.socket {\n  exports com.socket;\n  exports com.socket.spi;\n  uses com.socket.spi.NetworkSocketProvider;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0006() throws IOException {
        String source = "module org.fastsocket {\n    requires com.socket;\n    provides com.socket.spi.NetworkSocketProvider\n      with org.fastsocket.FastNetworkSocketProvider;\n}\n";
        String expectedUnitToString = "module org.fastsocket {\n  requires com.socket;\n  provides com.socket.spi.NetworkSocketProvider with org.fastsocket.FastNetworkSocketProvider;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0007() throws IOException {
        String source = "module org.fastsocket {\n    requires com.socket;\n    provides com.socket.spi.NetworkSocketProvider;\n}\n";
        String expectedErrorString = "----------\n1. ERROR in module-info (at line 3)\n\tprovides com.socket.spi.NetworkSocketProvider;\n\t                       ^\nSyntax error on token \".\", with expected\n----------\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), expectedErrorString, "module-info", null, null, options);
    }

    public void test0008() throws IOException {
        String source = "module @Marker com.greetings {\n\trequires org.astro;}\n";
        String errorMsg = "----------\n1. ERROR in module-info (at line 1)\n\tmodule @Marker com.greetings {\n\t^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in module-info (at line 1)\n\tmodule @Marker com.greetings {\n\t        ^^^^^^\nSyntax error on token \"Marker\", module expected after this token\n----------\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), errorMsg, "module-info", null, null, options);
    }

    public void test0009() throws IOException {
        String source = "module com.greetings {\n\trequires @Marker org.astro;\n}\n";
        String errorMsg = "----------\n1. ERROR in module-info (at line 1)\n\tmodule com.greetings {\n\trequires @Marker org.astro;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in module-info (at line 2)\n\trequires @Marker org.astro;\n\t          ^^^^^^\nSyntax error on token \"Marker\", package expected after this token\n----------\n3. ERROR in module-info (at line 3)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), errorMsg, "module-info", null, null, options);
    }

    public void test0010() throws IOException {
        String source = "module com.greetings {\n\trequires private org.astro;\n}\n";
        String errorMsg = "----------\n1. ERROR in module-info (at line 2)\n\trequires private org.astro;\n\t         ^^^^^^^\nSyntax error on token \"private\", delete this token\n----------\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), errorMsg, "module-info", null, null, options);
    }

    public void test0011() throws IOException {
        String source = "module com.greetings {\n\texports @Marker com.greetings;\n}\n";
        String errorMsg = "----------\n1. ERROR in module-info (at line 1)\n\tmodule com.greetings {\n\texports @Marker com.greetings;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in module-info (at line 2)\n\texports @Marker com.greetings;\n\t         ^^^^^^\nSyntax error on token \"Marker\", package expected after this token\n----------\n3. ERROR in module-info (at line 3)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), errorMsg, "module-info", null, null, options);
    }

    public void test0012() throws IOException {
        String source = "module com.greetings {\n\texports com.greetings to @Marker org.astro;\n}\n";
        String errorMsg = "----------\n1. ERROR in module-info (at line 2)\n\texports com.greetings to @Marker org.astro;\n\t                         ^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), errorMsg, "module-info", null, null, options);
    }

    public void test0013() throws IOException {
        String source = "module com.greetings {\n\tuses @Marker org.astro.World;\n}\n";
        String errorMsg = "----------\n1. ERROR in module-info (at line 2)\n\tuses @Marker org.astro.World;\n\t     ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), errorMsg, "module-info", null, null, options);
    }

    public void test0014() throws IOException {
        String source = "module com.greetings {\n\tprovides @Marker org.astro.World with @Marker com.greetings.Main;\n}\n";
        String errorMsg = "----------\n1. ERROR in module-info (at line 2)\n\tprovides @Marker org.astro.World with @Marker com.greetings.Main;\n\t         ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in module-info (at line 2)\n\tprovides @Marker org.astro.World with @Marker com.greetings.Main;\n\t                                      ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), errorMsg, "module-info", null, null, options);
    }

    public void test0015() throws IOException {
        String source = "module com.greetings {\nrequires transitive org.astro;}\n";
        String expectedUnitToString = "module com.greetings {\n  requires transitive org.astro;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0016() throws IOException {
        String source = "module com.greetings {\nrequires static org.astro;}\n";
        String expectedUnitToString = "module com.greetings {\n  requires static org.astro;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0017() throws IOException {
        String source = "module com.greetings {\nrequires transitive static org.astro;}\n";
        String expectedUnitToString = "module com.greetings {\n  requires transitive static org.astro;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0018() throws IOException {
        String source = "import com.socket.spi.NetworkSocketProvider;\nmodule org.fastsocket {\n    requires com.socket;\n    provides NetworkSocketProvider\n      with org.fastsocket.FastNetworkSocketProvider;\n}\n";
        String expectedUnitToString = "import com.socket.spi.NetworkSocketProvider;\nmodule org.fastsocket {\n  requires com.socket;\n  provides NetworkSocketProvider with org.fastsocket.FastNetworkSocketProvider;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0019() throws IOException {
        String source = "import com.socket.spi.*;\nmodule org.fastsocket {\n    requires com.socket;\n    provides NetworkSocketProvider\n      with org.fastsocket.FastNetworkSocketProvider;\n}\n";
        String expectedUnitToString = "import com.socket.spi.*;\nmodule org.fastsocket {\n  requires com.socket;\n  provides NetworkSocketProvider with org.fastsocket.FastNetworkSocketProvider;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0020() throws IOException {
        String source = "open module com.greetings {\nrequires transitive static org.astro;}\n";
        String expectedUnitToString = "open module com.greetings {\n  requires transitive static org.astro;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0021() throws IOException {
        String source = "module org.fastsocket {\n    requires com.socket;\n    provides com.socket.spi.NetworkSocketProvider\n      with org.fastsocket.FastNetworkSocketProvider, org.fastSocket.SlowNetworkSocketProvider;\n}\n";
        String expectedUnitToString = "module org.fastsocket {\n  requires com.socket;\n  provides com.socket.spi.NetworkSocketProvider with org.fastsocket.FastNetworkSocketProvider, org.fastSocket.SlowNetworkSocketProvider;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0022() throws IOException {
        String source = "module org.astro {\n    opens org.astro;\n}\n";
        String expectedUnitToString = "module org.astro {\n  opens org.astro;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0023() throws IOException {
        String source = "module org.astro {\n    opens org.astro to com.greetings, com.example1, com.example2;\n}\n";
        String expectedUnitToString = "module org.astro {\n  opens org.astro to com.greetings, com.example1, com.example2;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0024() throws IOException {
        String source = "module org.astro {\n    exports org.astro to com.greetings, com.example1, com.example2;\n    opens org.astro to com.greetings, com.example1, com.example2;\n    opens org.astro.galaxy to com.greetings, com.example1, com.example2;\n}\n";
        String expectedUnitToString = "module org.astro {\n  exports org.astro to com.greetings, com.example1, com.example2;\n  opens org.astro to com.greetings, com.example1, com.example2;\n  opens org.astro.galaxy to com.greetings, com.example1, com.example2;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0025() throws IOException {
        String source = "@Foo\nmodule org.astro {\n    exports org.astro to com.greetings, com.example1, com.example2;\n    opens org.astro to com.greetings, com.example1, com.example2;\n    opens org.astro.galaxy to com.greetings, com.example1, com.example2;\n}\n";
        String expectedUnitToString = "@Foo\nmodule org.astro {\n  exports org.astro to com.greetings, com.example1, com.example2;\n  opens org.astro to com.greetings, com.example1, com.example2;\n  opens org.astro.galaxy to com.greetings, com.example1, com.example2;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0026() throws IOException {
        String source = "@Foo\nopen module org.astro {\n    exports org.astro to com.greetings, com.example1, com.example2;\n    opens org.astro to com.greetings, com.example1, com.example2;\n    opens org.astro.galaxy to com.greetings, com.example1, com.example2;\n}\n";
        String expectedUnitToString = "@Foo\nopen module org.astro {\n  exports org.astro to com.greetings, com.example1, com.example2;\n  opens org.astro to com.greetings, com.example1, com.example2;\n  opens org.astro.galaxy to com.greetings, com.example1, com.example2;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void test0027() throws IOException {
        String source = "@Foo @Bar(x = 2) @Baz(\"true\")\nopen module org.astro {\n    exports org.astro to com.greetings, com.example1, com.example2;\n    opens org.astro to com.greetings, com.example1, com.example2;\n    opens org.astro.galaxy to com.greetings, com.example1, com.example2;\n}\n";
        String expectedUnitToString = "@Foo @Bar(x = 2) @Baz(\"true\")\nopen module org.astro {\n  exports org.astro to com.greetings, com.example1, com.example2;\n  opens org.astro to com.greetings, com.example1, com.example2;\n  opens org.astro.galaxy to com.greetings, com.example1, com.example2;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void testBug518626() throws IOException {
        String source = "module module.test {\n    provides X with Y;\n}\n";
        String expectedUnitToString = "module module.test {\n  provides X with Y;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void testbug488541() throws IOException {
        String source = "module module {\n   requires requires;\n   exports to to exports;\n   uses module;\n   provides uses with to;\n}\n";
        String expectedUnitToString = "module module {\n  requires requires;\n  exports to to exports;\n  uses module;\n  provides uses with to;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void testbug488541a() throws IOException {
        String source = "import module.pack1.exports.pack2;\nimport module.open.pack1.opens.pack2;\n@open @module(true)\nopen module module.module.module {\n   requires static transitive requires;\n   requires transitive static transitive;\n   exports to to exports;\n   opens module.to.pack1 to to.exports;\n   uses module;\n   provides uses with to;\n}\n";
        String expectedUnitToString = "import module.pack1.exports.pack2;\nimport module.open.pack1.opens.pack2;\n@open @module(true)\nopen module module.module.module {\n  requires transitive static requires;\n  requires transitive static transitive;\n  exports to to exports;\n  opens module.to.pack1 to to.exports;\n  uses module;\n  provides uses with to;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }

    public void testbug488541b() throws IOException {
        String source = "module module {\n   requires requires;\n   exports to to exports, module;\n   uses module;\n   provides uses with to, open, module;\n}\n";
        String expectedUnitToString = "module module {\n  requires requires;\n  exports to to exports, module;\n  uses module;\n  provides uses with to, open, module;\n}\n";
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.complianceLevel = 0x350000L;
        options.sourceLevel = 0x350000L;
        options.targetJDK = 0x350000L;
        this.checkParse(1, source.toCharArray(), null, "module-info", expectedUnitToString, null, options);
    }
}

