/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class StatementRecoveryTest
extends AbstractCompilerTest {
    public static final boolean ONLY_DIET_PLUS_BODY_WITH_STATEMENT_RECOVERY = false;
    public static boolean optimizeStringLiterals = false;
    public static long sourceLevel = 0x2F0000L;

    public static Test suite() {
        return StatementRecoveryTest.buildAllCompliancesTestSuite(StatementRecoveryTest.class);
    }

    public StatementRecoveryTest(String testName) {
        super(testName);
    }

    public void checkParse(char[] source, String expectedDietUnitToString, String expectedDietWithStatementRecoveryUnitToString, String expectedDietPlusBodyUnitToString, String expectedDietPlusBodyWithStatementRecoveryUnitToString, String expectedFullUnitToString, String expectedFullWithStatementRecoveryUnitToString, String testName) {
        int length;
        int i;
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        parser.setMethodsFullRecovery(false);
        parser.setStatementsRecovery(false);
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        String computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietWithStatementRecoveryUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest.assertEquals("Invalid unit diet structure with statement recovery enabled" + testName, expectedDietWithStatementRecoveryUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        parser.setMethodsFullRecovery(false);
        parser.setStatementsRecovery(false);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            i = 0;
            length = computedUnit.types.length;
            while (i < length) {
                computedUnit.types[i].parseMethods(parser, computedUnit);
                ++i;
            }
        }
        if (!expectedDietPlusBodyUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest.assertEquals("Invalid unit diet+body structure" + testName, expectedDietPlusBodyUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietWithStatementRecoveryUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietWithStatementRecoveryUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            i = 0;
            length = computedUnit.types.length;
            while (i < length) {
                computedUnit.types[i].parseMethods(parser, computedUnit);
                ++i;
            }
        }
        if (!expectedDietPlusBodyWithStatementRecoveryUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest.assertEquals("Invalid unit diet+body structure with statement recovery enabled" + testName, expectedDietPlusBodyWithStatementRecoveryUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        parser.setMethodsFullRecovery(false);
        parser.setStatementsRecovery(false);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest.assertEquals("Invalid unit full structure" + testName, expectedFullUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullWithStatementRecoveryUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest.assertEquals("Invalid unit full structure with statement recovery enabled" + testName, expectedFullWithStatementRecoveryUnitToString, computedUnitToString);
    }

    public void test0001() {
        String expectedFullUnitToString;
        String expectedDietPlusBodyUnitToString;
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = expectedDietPlusBodyUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0002() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0003() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #                    \t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0004() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0005() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #                    \t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0006() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    System.out.println();\n    System.out.println();\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0007() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      System.out.println();\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    if (true)\n        {\n          System.out.println();\n        }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0008() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      System.out.println();\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #                    \t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    if (true)\n        {\n          System.out.println();\n        }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0009() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      System.out.println();\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      System.out.println();\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    if (true)\n        {\n          System.out.println();\n        }\n    System.out.println();\n    System.out.println();\n    if (true)\n        {\n          System.out.println();\n        }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0010() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {}\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietPlusBodyUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0011() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {}\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0012() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {}\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0013() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {}\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Y {\t\t\t\t\t\t\t\t\n      void foo() {}\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n      }\n    }\n    System.out.println();\n    System.out.println();\n    class Y {\n      Y() {\n        super();\n      }\n      void foo() {\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0014() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n        System.out.println();\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0015() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n        System.out.println();\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0016() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n        System.out.println();\n      }\n    }\n    System.out.println();\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n        System.out.println();\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0017() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        #\t\t\t\t\t\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0018() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        #\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0019() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        #\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0020() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        #\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n      }\n    }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0021() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {}\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void foo() {\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void foo() {\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietPlusBodyUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0022() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {}\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void foo() {\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0023() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void bar() {}\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void bar() {\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0024() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void bar() {}\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void bar() {}\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void bar() {\n      }\n    };\n    System.out.println();\n    System.out.println();\n    new Object() {\n      void bar() {\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0025() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void foo() {\n        System.out.println();\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0026() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void foo() {\n        System.out.println();\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0027() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void foo() {\n        System.out.println();\n      }\n    };\n    System.out.println();\n    System.out.println();\n    new Object() {\n      void foo() {\n        System.out.println();\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0028() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        #\t\t\t\t\t\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void foo() {\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0029() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        #\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void foo() {\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0030() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        #\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void foo() {\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0031() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        #\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new Object() {\n      void foo() {\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n        System.out.println();\n        if (true)\n            {\n              System.out.println();\n            }\n        System.out.println();\n      }\n    };\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0032() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    bar(new Object() {\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        #\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        if(true) {\t\t\t\t\t\t\t\n          System.out.println();\t\t\t\t\n        }\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    });\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    bar(new Object() {\n  void foo() {\n    System.out.println();\n    if (true)\n        {\n          System.out.println();\n        }\n    System.out.println();\n    System.out.println();\n    if (true)\n        {\n          System.out.println();\n        }\n    System.out.println();\n  }\n});\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0033() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    class Z {\n      Z() {\n        super();\n      }\n      void foo() {\n        System.out.println();\n      }\n    }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0034() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    new Object() {\t\t\t\t\t\t\t\n      void foo() {\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    };\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    new Object() {\n      void foo() {\n        System.out.println();\n      }\n    };\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0035() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    bar(\\u0029\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    bar();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0036() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      foo();\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    for(;\t\t\t\t\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      foo();\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    if (true)\n        {\n          foo();\n        }\n    for (; ; ) \n      ;\n    if (true)\n        {\n          foo();\n        }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0037() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    if() {\t\t\t\t\t\t\t\t\t\n      foo();\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    if ($missing$)\n        {\n          foo();\n        }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0038() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\t\n\tpublic interface B {\t\t\t\t\t\t\t\n\t\tpublic abstract void aMethod (int A);\t\t\n\t\tpublic interface C {\t\t\t\t\t\t\n\t\t\tpublic abstract void anotherMethod(int A);\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class aClass implements B, B.C {\t\t\t\n\t\tpublic void aMethod (int A) {\t\t\t\t\n\t\t\tpublic void anotherMethod(int A) {};\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n   \tpublic static void main (String argv[]) {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package p1;\npublic class A {\n  public interface B {\n    public interface C {\n      public abstract void anotherMethod(int A);\n    }\n    public abstract void aMethod(int A);\n  }\n  public class aClass implements B, B.C {\n    public aClass() {\n    }\n    public void aMethod(int A) {\n    }\n  }\n  public A() {\n  }\n  public static void main(String[] argv) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package p1;\npublic class A {\n  public interface B {\n    public interface C {\n      public abstract void anotherMethod(int A);\n    }\n    public abstract void aMethod(int A);\n  }\n  public class aClass implements B, B.C {\n    public aClass() {\n      super();\n    }\n    public void aMethod(int A) {\n    }\n  }\n  public A() {\n    super();\n  }\n  public static void main(String[] argv) {\n    System.out.println(\"SUCCESS\");\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package p1;\npublic class A {\n  public interface B {\n    public interface C {\n      public abstract void anotherMethod(int A);\n    }\n    public abstract void aMethod(int A);\n  }\n  public class aClass implements B, B.C {\n    public aClass() {\n      super();\n    }\n    public void aMethod(int A) {\n      public void anotherMethod;\n      int A;\n      ;\n    }\n  }\n  public A() {\n    super();\n  }\n  public static void main(String[] argv) {\n    System.out.println(\"SUCCESS\");\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "package p1;\npublic class A {\n  public interface B {\n    public interface C {\n      public abstract void anotherMethod(int A);\n    }\n    public abstract void aMethod(int A);\n  }\n  public class aClass implements B, B.C {\n    public aClass() {\n    }\n    public void aMethod(int A) {\n    }\n    public void anotherMethod(int A) {\n    }\n  }\n  {\n  }\n  public A() {\n  }\n  public static void main(String[] argv) {\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0039() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  {\t\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    foo()\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  {\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  {\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  {\n    System.out.println();\n    foo();\n    System.out.println();\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0040() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  {\t\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Y {\t\t\t\t\t\t\t\t\n      {\t\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        foo()\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  {\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  {\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  {\n    System.out.println();\n    class Y {\n      {\n        System.out.println();\n        foo();\n        System.out.println();\n      }\n      Y() {\n        super();\n      }\n    }\n    System.out.println();\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0041() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  {\t\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Y {\t\t\t\t\t\t\t\t\n      {\t\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        foo()\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    class Z {\t\t\t\t\t\t\t\t\n      {\t\t\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n        foo()\t\t\t\t\t\t\t\t\n        System.out.println();\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    foo()\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  {\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  {\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  {\n    System.out.println();\n    class Y {\n      {\n        System.out.println();\n        foo();\n        System.out.println();\n      }\n      Y() {\n        super();\n      }\n    }\n    System.out.println();\n    class Z {\n      {\n        System.out.println();\n        foo();\n        System.out.println();\n      }\n      Z() {\n        super();\n      }\n    }\n    System.out.println();\n    foo();\n    System.out.println();\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0042() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    for(int i\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    for (int i;; ; ) \n      ;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0043() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic interface Test {\t\t\t\t\t\t\n  public void myMethod()\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic interface Test {\n  public void myMethod() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic interface Test {\n  public void myMethod() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic interface Test {\n  public void myMethod() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0044() {
        String expectedDietUnitToString;
        String s = "import java.io.EOFException;\nimport java.io.FileNotFoundException;\nimport java.io.IOException;\nimport org.xml.sax.SAXException;\npublic class X {\npublic void doSomething() throws FileNotFoundException, EOFException, SAXException{\n\n}\npublic void doSomethingElse() {\ntry {\n\tdoSomething();\n}\n catch ( SAXException exception) {\n\n}  \ncatch ( FileNotFoundException exception ) {\n\n}    \ncatch (\n\t// working before the slashes\n) {\n\n} \n} \n}\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "import java.io.EOFException;\nimport java.io.FileNotFoundException;\nimport java.io.IOException;\nimport org.xml.sax.SAXException;\npublic class X {\n  public X() {\n  }\n  public void doSomething() throws FileNotFoundException, EOFException, SAXException {\n  }\n  public void doSomethingElse() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "import java.io.EOFException;\nimport java.io.FileNotFoundException;\nimport java.io.IOException;\nimport org.xml.sax.SAXException;\npublic class X {\n  public X() {\n    super();\n  }\n  public void doSomething() throws FileNotFoundException, EOFException, SAXException {\n  }\n  public void doSomethingElse() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "import java.io.EOFException;\nimport java.io.FileNotFoundException;\nimport java.io.IOException;\nimport org.xml.sax.SAXException;\npublic class X {\n  public X() {\n    super();\n  }\n  public void doSomething() throws FileNotFoundException, EOFException, SAXException {\n  }\n  public void doSomethingElse() {\n    try\n      {\n        doSomething();\n      }\n    catch (SAXException exception)\n      {\n      }\n    catch (FileNotFoundException exception)\n      {\n      }\n    catch ($missing$ $missing$)\n      {\n      }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0045() {
        String expectedDietUnitToString;
        String s = "public class BadClass {\n\n   public void method(Object obj) {\n\n\t  /*//this version compiles\n\t  People oPeople;\n\t  {oPeople= (People) obj;}//*/\n\n\t  /*//this version fails, but the compiler errors are fine\n      class People oPeople;\n\t  oPeople= (class People) obj;//*/\n\n\t  //this version fails with internal compiler error\n\t  class People oPeople;\n\t  {oPeople= (class People) obj;}\n   }\n\n}\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class BadClass {\n  public BadClass() {\n  }\n  public void method(Object obj) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class BadClass {\n  public BadClass() {\n    super();\n  }\n  public void method(Object obj) {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class BadClass {\n  public BadClass() {\n    super();\n  }\n  public void method(Object obj) {\n    class People {\n      {\n        class People {\n          People() {\n            super();\n          }\n        }\n      }\n      People() {\n        super();\n      }\n    }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0046() {
        String expectedDietUnitToString;
        String s = "public class X {\n\tpublic void foo() { \n\t\tclass Y ;\n\t\t\n\t\t\t{\n\t\t\t\tclass Z ;\n\t\t\t\t}\n\t}\n}\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  public void foo() {\n    class Y {\n      {\n        class Z {\n          Z() {\n            super();\n          }\n        }\n      }\n      Y() {\n        super();\n      }\n    }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0047() {
        String expectedDietUnitToString;
        String s = "public class X {\n\tpublic void foo() { \n\t\tclass Y ;\n\t\t\n\t\t\tvoid bar() {\n\t\t\t\tclass Z ;\n\t\t\t\t}\n\t}\n}\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  public void foo() {\n    class Y {\n      Y() {\n        super();\n      }\n      void bar() {\n        class Z {\n          Z() {\n            super();\n          }\n        }\n      }\n    }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void testBug430336() {
        String expectedDietUnitToString;
        String s = "package test1;\nimport java.util.Collection;\npublic class E {\n    void foo(Collection collection) {\n        collection\n    }\n}\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package test1;\nimport java.util.Collection;\npublic class E {\n  public E() {\n  }\n  void foo(Collection collection) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package test1;\nimport java.util.Collection;\npublic class E {\n  public E() {\n    super();\n  }\n  void foo(Collection collection) {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package test1;\nimport java.util.Collection;\npublic class E {\n  public E() {\n    super();\n  }\n  void foo(Collection collection) {\n    collection = $missing$;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }
}

