/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.env.AutomaticModuleNaming;

public class AutomaticModuleNamingTest
extends AbstractRegressionTest {
    public AutomaticModuleNamingTest(String name) {
        super(name);
    }

    public static Test suite() {
        return AutomaticModuleNamingTest.buildMinimalComplianceTestSuite(AutomaticModuleNamingTest.testClass(), 32);
    }

    public static Class<?> testClass() {
        return AutomaticModuleNamingTest.class;
    }

    public void testManifest() throws Exception {
        String dirName = String.valueOf(OUTPUT_DIR) + File.separator + "automatic";
        try {
            String metaInfDir = String.valueOf(dirName) + File.separator + "META-INF";
            new File(metaInfDir).mkdirs();
            Util.createFile(String.valueOf(metaInfDir) + File.separator + "MANIFEST.MF", "Manifest-Version: 1.0\nAutomatic-Module-Name: module.123\n");
            Util.zip(new File(dirName), String.valueOf(dirName) + File.separator + "foo.bar-1.2.3.jar");
            AutomaticModuleNamingTest.assertEquals("module.123", new String(AutomaticModuleNaming.determineAutomaticModuleName((String)(String.valueOf(dirName) + File.separator + "foo.bar-1.2.3.jar").toString())));
        }
        finally {
            Util.delete(dirName);
        }
    }

    public void testSimple() throws Exception {
        AutomaticModuleNamingTest.assertEquals("junit", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)"junit.jar", (boolean)false, (boolean)true)));
    }

    public void testWithVersion() throws Exception {
        AutomaticModuleNamingTest.assertEquals("junit", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)"junit-4.8.2.jar", (boolean)false, (boolean)true)));
    }

    public void testMultiParts() throws Exception {
        AutomaticModuleNamingTest.assertEquals("foo.bar", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)"foo-bar.jar", (boolean)false, (boolean)true)));
    }

    public void testMultiPartWithVersion() throws Exception {
        AutomaticModuleNamingTest.assertEquals("foo.bar", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)"foo-bar-1.2.3-SNAPSHOT.jar", (boolean)false, (boolean)true)));
    }

    public void testMultiPartWithNumberWithoutDot() throws Exception {
        AutomaticModuleNamingTest.assertEquals("foo.bar.3d", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)"foo-bar-3d-1.2.3-SNAPSHOT.jar", (boolean)false, (boolean)true)));
    }

    public void testSpecialCharacters() throws Exception {
        AutomaticModuleNamingTest.assertEquals("foo.bar", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)"?foo?bar?-1.2.3-SNAPSHOT.jar", (boolean)false, (boolean)true)));
    }

    public void testMultipleSpecialCharacters() throws Exception {
        AutomaticModuleNamingTest.assertEquals("foo.bar", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)"?@#foo?@#bar?@#-1.2.3-SNAPSHOT.jar", (boolean)false, (boolean)true)));
    }

    public void testMultipleSpecialCharactersWithDirectory() throws Exception {
        AutomaticModuleNamingTest.assertEquals("foo.bar.bla", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)(String.valueOf(File.separator) + "somedir" + File.separator + "?@#foo?@#bar?@#bla?@#-1.2.3-SNAPSHOT.jar"), (boolean)true, (boolean)true)));
    }

    public void testFileEndsWithDotJar() throws Exception {
        AutomaticModuleNamingTest.assertEquals("module.jar", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)("somedir" + File.separator + "module.jar.jar"), (boolean)true, (boolean)true)));
    }

    public void testProjectNameEndsWithDotJar() throws Exception {
        AutomaticModuleNamingTest.assertEquals("module.jar", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)("somedir" + File.separator + "module.jar"), (boolean)true, (boolean)false)));
    }

    public void testUPPERCASE() throws Exception {
        AutomaticModuleNamingTest.assertEquals("FOO.BAR", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)"FOO-BAR.JAR", (boolean)true, (boolean)true)));
    }

    public void testZip() throws Exception {
        AutomaticModuleNamingTest.assertEquals("CLASSES12.ZIP", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)"CLASSES12.ZIP", (boolean)true, (boolean)true)));
    }

    public void testBug529680() throws Exception {
        AutomaticModuleNamingTest.assertEquals("hibernate.jpa", new String(AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)"hibernate-jpa-2.1-api-1.0.0.Final.jar", (boolean)true, (boolean)true)));
    }
}

