/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;

public class CastTest
extends AbstractRegressionTest {
    public CastTest(String name) {
        super(name);
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        return defaultOptions;
    }

    public static Test suite() {
        return CastTest.buildAllCompliancesTestSuite(CastTest.testClass());
    }

    public void test001() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n       Cloneable c1 = new int[0]; \n\t\tCloneable c2 = (Cloneable)c1; \n\t\tSystem.out.print(\"SUCCESS\");\t\n    }\t\n}\t\n"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  newarray int [10]\n     3  astore_1 [c1]\n     4  aload_1 [c1]\n     5  astore_2 [c2]\n     6  getstatic java.lang.System.out : java.io.PrintStream [16]\n     9  ldc <String \"SUCCESS\"> [22]\n    11  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    14  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 4, line: 4]\n        [pc: 6, line: 5]\n        [pc: 14, line: 6]\n      Local variable table:\n        [pc: 0, pc: 15] local: args index: 0 type: java.lang.String[]\n        [pc: 4, pc: 15] local: c1 index: 1 type: java.lang.Cloneable\n        [pc: 6, pc: 15] local: c2 index: 2 type: java.lang.Cloneable\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            CastTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test002() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// standard expressions\n\t\tString s = (String) null;\t// UNnecessary\n\t\tString t = (String) \"hello\";\t// UNnecessary\n\t\tfloat f = (float) 12;\t\t\t// UNnecessary\n\t\tint i = (int)12.0;\t\t\t\t//   necessary\n\t}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\tString s = (String) null;\t// UNnecessary\n\t           ^^^^^^^^^^^^^\nUnnecessary cast from null to String\n----------\n2. ERROR in X.java (at line 5)\n\tString t = (String) \"hello\";\t// UNnecessary\n\t           ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n3. ERROR in X.java (at line 6)\n\tfloat f = (float) 12;\t\t\t// UNnecessary\n\t          ^^^^^^^^^^\nUnnecessary cast from int to float\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test003() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// message sends\t\t\n\t\tfoo((Object) \"hello\");\t\t//   necessary\n\t\tfoo((String) \"hello\");\t\t\t// UNnecessary\n\t\tfoo((Object) null);\t\t\t//   necessary\n\t\tfoo((String) null);\t\t\t\t// UNnecessary but keep as useful documentation \n\t}\n\tstatic void foo(String s) {\n\t\tSystem.out.println(\"foo(String):\"+s);\n\t}\n\tstatic void foo(Object o) {\n\t\tSystem.out.println(\"foo(Object):\"+o);\n\t}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 5)\n\tfoo((String) \"hello\");\t\t\t// UNnecessary\n\t    ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test004() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// constructors\n\t\tnew X((Object) \"hello\");\t//   necessary\n\t\tnew X((String) \"hello\");\t// UNnecessary\n\t\tnew X((Object) null);\t\t//   necessary\n\t\tnew X((String) null);\t\t// UNnecessary but keep as useful documentation\n\t}\n\tX(){}\n\tX(String s){\n\t\tSystem.out.println(\"new X(String):\"+s);\n\t}\n\tX(Object o){\n\t\tSystem.out.println(\"new X(Object):\"+o);\n\t}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 5)\n\tnew X((String) \"hello\");\t// UNnecessary\n\t      ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// qualified allocations\n\t\tnew X().new XM3((Object) \"hello\");\t//   necessary\n\t\tnew X().new XM3((String) \"hello\");\t// UNnecessary\n\t\tnew X().new XM3((Object) null);\t\t//   necessary\n\t\tnew X().new XM3((String) null);\t\t// UNnecessary but keep as useful documentation\n\t\tnew X().new XM3((Object) \"hello\"){};\t//   necessary\n\t\tnew X().new XM3((String) \"hello\"){};\t// UNnecessary\n\t\tnew X().new XM3((Object) null){};\t\t//   necessary\n\t\tnew X().new XM3((String) null){};\t\t// UNnecessary but keep as useful documentation\n\t}\n\tX(){}\n\tstatic class XM1 extends X {}\n\tstatic class XM2 extends X {}\n\tclass XM3 {\n\t\tXM3(String s){\n\t\t\tSystem.out.println(\"new XM3(String):\"+s);\n\t\t}\n\t\tXM3(Object o){\n\t\t\tSystem.out.println(\"new XM3(Object):\"+o);\n\t\t}\n\t}\t\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 5)\n\tnew X().new XM3((String) \"hello\");\t// UNnecessary\n\t                ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n2. ERROR in X.java (at line 9)\n\tnew X().new XM3((String) \"hello\"){};\t// UNnecessary\n\t                ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void _test006() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// ternary operator\n\t\tString s = null, t = null;\t\n\t\tX x0 = s == t\n\t\t\t? (X)new XM1()\t\t\t// UNnecessary\n\t\t\t: new X();\n\t\tX x1 = s == t \n\t\t\t? (X)new XM1()\t\t\t//   necessary\n\t\t\t: new XM2();\n\t\tX x2 = s == t \n\t\t\t? new XM1()\n\t\t\t: (X)new XM2();\t\t\t//   necessary\n\t\tX x3 = s == t \n\t\t\t? (X)new XM1()\t\t\t//   necessary\n\t\t\t: (X)new XM2();\t\t\t//   necessary\n\t}\n\tX(){}\n\tstatic class XM1 extends X {}\n\tstatic class XM2 extends X {}\n}\n"}, "x", null, true, customOptions);
    }

    public void test007() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tX(){}\n\tclass XM3 {\n\t\tXM3(String s){\n\t\t\tSystem.out.println(\"new XM3(String):\"+s);\n\t\t}\n\t\tXM3(Object o){\n\t\t\tSystem.out.println(\"new XM3(Object):\"+o);\n\t\t}\n\t}\t\n\t\n\tclass XM4 extends XM3 {\n\t\tXM4(String s){\n\t\t\tsuper((Object) s); // necessary\n\t\t\tSystem.out.println(\"new XM4(String):\"+s);\n\t\t}\n\t\tXM4(Object o){\n\t\t\tsuper((String) o); // necessary\n\t\t\tSystem.out.println(\"new XM4(Object):\"+o);\n\t\t}\n\t\tXM4(Thread t){\n\t\t\tsuper((Object) t); // UNnecessary\n\t\t\tSystem.out.println(\"new XM4(Thread):\"+t);\n\t\t}\n\t\tXM4(){\n\t\t\tsuper((String)null); // UNnecessary but keep as useful documentation\n\t\t\tSystem.out.println(\"new XM4():\");\n\t\t}\n\t\tXM4(int i){\n\t\t\tsuper((Object)null); // necessary\n\t\t\tSystem.out.println(\"new XM4():\");\n\t\t}\n\t}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 22)\n\tsuper((Object) t); // UNnecessary\n\t      ^^^^^^^^^^\nUnnecessary cast from Thread to Object\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test008() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean b1 = new XM1() instanceof X; // UNnecessary\n\t\tboolean b2 = new X() instanceof XM1; // necessary\n\t\tboolean b3 = null instanceof X;\n\t}\n\tstatic class XM1 extends X {}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tboolean b1 = new XM1() instanceof X; // UNnecessary\n\t             ^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type X.XM1 is already an instance of type X\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test009() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean b1 = ((X) new XM1()) == new X(); // UNnecessary\n\t\tboolean b2 = ((X) new XM1()) == new XM2(); // necessary\n\t\tboolean b3 = ((X) null) == new X(); // UNnecessary\n\t}\n\tstatic class XM1 extends X {}\n\tstatic class XM2 extends X {}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tboolean b1 = ((X) new XM1()) == new X(); // UNnecessary\n\t             ^^^^^^^^^^^^^^^\nUnnecessary cast from X.XM1 to X\n----------\n2. ERROR in X.java (at line 5)\n\tboolean b3 = ((X) null) == new X(); // UNnecessary\n\t             ^^^^^^^^^^\nUnnecessary cast from null to X\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test010() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tlong l1 = ((long) 1) + 2L; // UNnecessary\n\t\tlong l2 = ((long)1) + 2; // necessary\n\t\tlong l3 = 0;\t\tl3 += (long)12; // UNnecessary\n\t}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tlong l1 = ((long) 1) + 2L; // UNnecessary\n\t          ^^^^^^^^^^\nUnnecessary cast from int to long\n----------\n2. ERROR in X.java (at line 5)\n\tlong l3 = 0;\t\tl3 += (long)12; // UNnecessary\n\t            \t\t      ^^^^^^^^\nUnnecessary cast from int to long\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test011() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tString s1 = ((long) 1) + \"hello\"; // necessary\n\t\tString s2 = ((String)\"hello\") + 2; // UNnecessary\n\t\tString s3 = ((String)null) + null; // necessary\n\t\tString s4 = ((int) (byte)1) + \"hello\"; // necessary\n\t}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\tString s2 = ((String)\"hello\") + 2; // UNnecessary\n\t            ^^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test012() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// message sends\t\t\n\t\tX x = new YM1();\t\n\t\tfoo((X) x);\t\t\t// UNnecessary\n\t\tfoo((XM1) x);\t// UNnecessary\n\t\tfoo((YM1) x);\t// necessary \n\t}\n\tstatic void foo(X x) {}\n\tstatic void foo(YM1 ym1) {}\n  static class XM1 extends X {}\n  static class YM1 extends XM1 {}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 5)\n\tfoo((X) x);\t\t\t// UNnecessary\n\t    ^^^^^\nUnnecessary cast from X to X\n----------\n2. ERROR in X.java (at line 6)\n\tfoo((XM1) x);\t// UNnecessary\n\t    ^^^^^^^\nUnnecessary cast from X to X.XM1\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test013() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\n\t\tint a = 0, b = 1;\n\t\tlong d;\n\t\td = (long)a; \t\t\t\t// unnecessary\n\t\td = (long)a + b; \t\t// necessary \n\t\td = d + a + (long)b; \t// unnecessary\n\t}\n}\n\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 6)\n\td = (long)a; \t\t\t\t// unnecessary\n\t    ^^^^^^^\nUnnecessary cast from int to long\n----------\n2. ERROR in X.java (at line 8)\n\td = d + a + (long)b; \t// unnecessary\n\t            ^^^^^^^\nUnnecessary cast from int to long\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test014() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tboolean b = new Cloneable() {} instanceof Cloneable;\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\tboolean b = new Cloneable() {} instanceof Cloneable;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type new Cloneable(){} is already an instance of type Cloneable\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test015() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tvoid foo() {\t\n    int lineCount = 10; \n    long time = 1000; \n    double linePerSeconds1 = ((int) (lineCount * 10000.0 / time)) / 10.0; // necessary \n    double linePerSeconds2 = ((double) (lineCount * 10000.0 / time)) / 10.0; // UNnecessary \n  } \n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 6)\n\tdouble linePerSeconds2 = ((double) (lineCount * 10000.0 / time)) / 10.0; // UNnecessary \n\t                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from double to double\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test016() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tvoid foo() {\t\n    int lineCount = 10; \n    long time = 1000; \n    print((int) (lineCount * 10000.0 / time)); // necessary \n    print((double) (lineCount * 10000.0 / time)); // UNnecessary \n  } \n  void print(double d) {}  \n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 6)\n\tprint((double) (lineCount * 10000.0 / time)); // UNnecessary \n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from double to double\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test017() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar() {\n\t\tfoo((X) this);\n\t\tfoo((X) zork());\n\t}\n\tvoid foo(X x) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfoo((X) this);\n\t    ^^^^^^^^\nUnnecessary cast from X to X\n----------\n2. ERROR in X.java (at line 4)\n\tfoo((X) zork());\n\t        ^^^^\nThe method zork() is undefined for the type X\n----------\n", null, true, customOptions);
    }

    public void test018() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "class Y {\n\tstatic Y[] foo(int[] tab) {\n\t\treturn null;\n\t}\n}\npublic class X extends Y {\n\tY[] bar() {\n\t\treturn (Y[]) Y.foo(new double[] {});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\treturn (Y[]) Y.foo(new double[] {});\n\t               ^^^\nThe method foo(int[]) in the type Y is not applicable for the arguments (double[])\n----------\n", null, true, customOptions);
    }

    public void tes019() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar() {\n\t\tX x1 =(X) this;\n\t\tX x2 = (X) zork();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX x1 =(X) this;\n\t      ^^^^^^^^\nUnnecessary cast to type X for expression of type X\n----------\n2. ERROR in X.java (at line 4)\n\tX x2 = (X) zork();\n\t           ^^^^\nThe method zork() is undefined for the type X\n----------\n", null, true, customOptions);
    }

    public void test020() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar() {\n\t\tlong l = (long)zork() + 2;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tlong l = (long)zork() + 2;\n\t               ^^^^\nThe method zork() is undefined for the type X\n----------\n", null, true, customOptions);
    }

    public void test021() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tpublic class Member1 {}\n\tpublic class Member2 {}\n\tclass Member3 {}\n   public static class Member4 {\n\t   public static class M4Member {}\n   }\n}\n", "p2/B.java", "package p2;\nimport p1.A;\npublic class B extends A {\n\tpublic class Member1 {}\n}\n", "p1/C.java", "package p1;\nimport p2.B;\npublic class C extends B {\n\tvoid baz(B b) {\n\t\t((A)b).new Member1(); // necessary since would bind to B.Member instead\n\t\t((A)b).new Member2(); // UNnecessary\n\t\t((A)b).new Member3(); // necessary since visibility issue\n\t\t((A)b).new Member4().new M4Member(); // fault tolerance\n\t\t((A)zork()).new Member1(); // fault-tolerance\n\t\t// anonymous\n\t\t((A)b).new Member1(){}; // necessary since would bind to B.Member instead\n\t\t((A)b).new Member2(){}; // UNnecessary\n\t\t((A)b).new Member3(){}; // necessary since visibility issue\n\t\t((A)b).new Member4().new M4Member(){}; // fault tolerance\n\t\t((A)zork()).new Member1(){}; // fault-tolerance\n\t}\n}\n"}, "----------\n1. ERROR in p1\\C.java (at line 6)\n\t((A)b).new Member2(); // UNnecessary\n\t^^^^^^\nUnnecessary cast from B to A\n----------\n2. ERROR in p1\\C.java (at line 8)\n\t((A)b).new Member4().new M4Member(); // fault tolerance\n\t^^^^^^\nUnnecessary cast from B to A\n----------\n3. ERROR in p1\\C.java (at line 9)\n\t((A)zork()).new Member1(); // fault-tolerance\n\t    ^^^^\nThe method zork() is undefined for the type C\n----------\n4. ERROR in p1\\C.java (at line 12)\n\t((A)b).new Member2(){}; // UNnecessary\n\t^^^^^^\nUnnecessary cast from B to A\n----------\n5. ERROR in p1\\C.java (at line 14)\n\t((A)b).new Member4().new M4Member(){}; // fault tolerance\n\t^^^^^^\nUnnecessary cast from B to A\n----------\n6. ERROR in p1\\C.java (at line 15)\n\t((A)zork()).new Member1(){}; // fault-tolerance\n\t    ^^^^\nThe method zork() is undefined for the type C\n----------\n", null, true, customOptions);
    }

    public void test022() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\t\n  void foo(java.util.Map map){ \n    int[] fillPattern = new int[0]; \n    if (fillPattern.equals((int[])map.get(\"x\"))) { \n    }  \n  } \n} \n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\tif (fillPattern.equals((int[])map.get(\"x\"))) { \n\t                       ^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object to int[]\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test023() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tfinal long lgLow32BitMask1 = ~(~((long) 0) << 32);\t\t// necessary\n\t\tfinal long lgLow32BitMask2 = ~(~0 << 32);\t\t\t\t\t// necessary\n\t\tfinal long lgLow32BitMask3 = ~(~((long) 0L) << 32);\t// unnecessary\n\t\tfinal long lgLow32BitMask4 = ~(~((int) 0L) << 32);\t\t// necessary\n\t\tSystem.out.println(\"lgLow32BitMask1: \"+lgLow32BitMask1);\n\t\tSystem.out.println(\"lgLow32BitMask2: \"+lgLow32BitMask2);\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 6)\n\tfinal long lgLow32BitMask3 = ~(~((long) 0L) << 32);\t// unnecessary\n\t                                ^^^^^^^^^^^\nUnnecessary cast from long to long\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test024() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic void foo(Object bar) {\n\t\tSystem.out.println(((Object) bar).toString());\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(((Object) bar).toString());\n\t                   ^^^^^^^^^^^^^^\nUnnecessary cast from Object to Object\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test025() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tint i;\n\tpublic void foo(X bar) {\n\t\tSystem.out.println(((X) bar).i);\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\tSystem.out.println(((X) bar).i);\n\t                   ^^^^^^^^^\nUnnecessary cast from X to X\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test026() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    B b = (B) a;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tB b = (B) a;\n\t      ^^^^^\nCannot cast from A to B\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    B b = (B) a;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "");
    }

    public void test027() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    boolean b = a instanceof B;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tboolean b = a instanceof B;\n\t            ^^^^^^^^^^^^^^\nIncompatible conditional operand types A and B\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    boolean b = a instanceof B;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "");
    }

    public void test028() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    B b = null;\n    boolean c = a == b;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tboolean c = a == b;\n\t            ^^^^^^\nIncompatible operand types A and B\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    B b = null;\n    boolean c = a == b;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n\t\ttry {\t\n\t\t    char[][] qName;\t\n\t\t\tqName = null;\t\n\t\t\tqName[0] = new char[1];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t    char[][] qName;\t\n\t\t\tqName = (char[][])null;\t\n\t\t\tqName[0] = new char[1];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t    char[][] qName;\t\n\t\t\tqName = (char[][])(char[][])(char[][])null;\t\n\t\t\tqName[0] = new char[2];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t    char[][] qName;\t\n\t\t\tqName = args.length > 1 ? new char[1][2] : null;\t\n\t\t\tqName[0] = new char[3];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n\t\ttry {\t\n\t\t\tchar[][] qName = null;\t\n\t\t\tqName[0] = new char[1];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = (char[][])null;\t\n\t\t\tqName[0] = new char[1];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = (char[][])(char[][])(char[][])null;\t\n\t\t\tqName[0] = new char[2];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = args.length > 1 ? new char[1][2] : null;\t\n\t\t\tqName[0] = new char[3];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n\t\ttry {\t\n\t\t\tchar[][] qName = null;\t\n\t\t\tsetName(qName[0]);\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = (char[][])null;\t\n\t\t\tsetName(qName[0]);\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = (char[][])(char[][])(char[][])null;\t\n\t\t\tsetName(qName[0]);\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = args.length > 1 ? new char[1][2] : null;\t\n\t\t\tsetName(qName[0]);\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tstatic void setName(char[] name) {\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n\t\t\ttry {\n\t\t\t\t((int[]) null)[0] = 0;\n\t\t\t\t((int[]) null)[0] += 1;\n\t\t\t\t((int[]) null)[0] ++;\n\t\t\t} catch (NullPointerException e) {\n\t\t\t\tSystem.out.print(\"SUCCESS\");\n\t\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test033() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n    public static void main(String [] args) {\n        List list = (List) new ArrayList();\n        list = (List) new ArrayList();\n        \n        String s = (String) \"hello\";\n        s += (List) new ArrayList();\n        \n        ArrayList alist = new ArrayList();\n        List list2 = (List) alist;\n        list2 = (List) alist;\n        \n        String s2 = (String) \"hello\";\n        s2 += (List) alist;\n    }\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 6)\n\tList list = (List) new ArrayList();\n\t            ^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n2. ERROR in X.java (at line 7)\n\tlist = (List) new ArrayList();\n\t       ^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n3. ERROR in X.java (at line 9)\n\tString s = (String) \"hello\";\n\t           ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n4. ERROR in X.java (at line 10)\n\ts += (List) new ArrayList();\n\t     ^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n5. ERROR in X.java (at line 13)\n\tList list2 = (List) alist;\n\t             ^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n6. ERROR in X.java (at line 14)\n\tlist2 = (List) alist;\n\t        ^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n7. ERROR in X.java (at line 16)\n\tString s2 = (String) \"hello\";\n\t            ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n8. ERROR in X.java (at line 17)\n\ts2 += (List) alist;\n\t      ^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test034() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n    public static void main(String [] args) {\n        List list = (List) new ArrayList();\n        list = (List) new ArrayList();\n        \n        ArrayList alist = new ArrayList();\n        List list2 = (List) alist;\n        list2 = (List) alist;\n        \n       System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 4\n  public static void main(java.lang.String[] args);\n     0  new java.util.ArrayList [16]\n     3  dup\n     4  invokespecial java.util.ArrayList() [18]\n     7  astore_1 [list]\n     8  new java.util.ArrayList [16]\n    11  dup\n    12  invokespecial java.util.ArrayList() [18]\n    15  astore_1 [list]\n    16  new java.util.ArrayList [16]\n    19  dup\n    20  invokespecial java.util.ArrayList() [18]\n    23  astore_2 [alist]\n    24  aload_2 [alist]\n    25  astore_3 [list2]\n    26  aload_2 [alist]\n    27  astore_3 [list2]\n    28  getstatic java.lang.System.out : java.io.PrintStream [19]\n    31  ldc <String \"SUCCESS\"> [25]\n    33  invokevirtual java.io.PrintStream.println(java.lang.String) : void [27]\n    36  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 8, line: 7]\n        [pc: 16, line: 9]\n        [pc: 24, line: 10]\n        [pc: 26, line: 11]\n        [pc: 28, line: 13]\n        [pc: 36, line: 14]\n      Local variable table:\n        [pc: 0, pc: 37] local: args index: 0 type: java.lang.String[]\n        [pc: 8, pc: 37] local: list index: 1 type: java.util.List\n        [pc: 24, pc: 37] local: alist index: 2 type: java.util.ArrayList\n        [pc: 26, pc: 37] local: list2 index: 3 type: java.util.List\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            CastTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test035() {
        String[] sources = new String[]{"Test231.java", "public class Test231 implements Test231i\n{\n\tvoid\tfoo()\n\t{\n\t\tnew Object()\n\t\t{\n\t\t\tTest231i\tbar()\n\t\t\t{\n\t\t\t\treturn\t(Test231i)this;\n\t\t\t}\n\t\t};\n\t}\n}\n\n\ninterface Test231i\n{\n}\n"};
        if (this.complianceLevel < 0x350000L) {
            this.runNegativeTest(sources, "----------\n1. ERROR in Test231.java (at line 9)\n\treturn\t(Test231i)this;\n\t      \t^^^^^^^^^^^^^^\nCannot cast from new Object(){} to Test231i\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
        } else {
            this.runConformTest(sources, "");
        }
    }

    public void test036() {
        this.runConformTest(true, new String[]{"X.java", "public final class X {\n\tprivate static final boolean DO_BUG = true;\n\n\t// Workaround: cast null to Base\n\tprivate static Base base = DO_BUG ?\n\t// (Base)null\n\t\t\tnull : new Base() {\n\t\t\t\tpublic final String test() {\n\t\t\t\t\treturn (\"anonymous\");\n\t\t\t\t}\n\t\t\t};\n\n\tprivate X() {\n\t}\n\n\tpublic static void main(String[] argv) {\n\t\tif (base == null)\n\t\t\tSystem.out.println(\"no base\");\n\t\telse\n\t\t\tSystem.out.println(base.test());\n\t}\n\n\tprivate static abstract class Base {\n\t\tpublic Base() {\n\t\t}\n\n\t\tpublic abstract String test();\n\t}\n}\n"}, "", "no base", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacGeneratesByteCodeUponWhichJavaThrowsAnException);
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger[] integers = {};\n\t\tint[] ints = (int[]) integers;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tint[] ints = (int[]) integers;\n\t             ^^^^^^^^^^^^^^^^\nCannot cast from Integer[] to int[]\n----------\n");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tSystem.out.println(null instanceof Object);\n      Zork z;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\r\n\tZork z;\r\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tObject fo = (String) new Object();\n\tvoid foo(ArrayList al) {\n\t\tList l = (List) al;\n\t\tObject o;\n\t\to = (ArrayList) al;\n\t\tObject o2 = (ArrayList) al;\n\t\to = (ArrayList) l;\n\t\tObject o3 = (ArrayList) l;\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tObject fo = (String) new Object();\n\t            ^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object to String\n----------\n2. WARNING in X.java (at line 5)\n\tList l = (List) al;\n\t         ^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n3. WARNING in X.java (at line 7)\n\to = (ArrayList) al;\n\t    ^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList to ArrayList\n----------\n4. WARNING in X.java (at line 8)\n\tObject o2 = (ArrayList) al;\n\t            ^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList to ArrayList\n----------\n5. WARNING in X.java (at line 9)\n\to = (ArrayList) l;\n\t    ^^^^^^^^^^^^^\nUnnecessary cast from List to ArrayList\n----------\n6. WARNING in X.java (at line 10)\n\tObject o3 = (ArrayList) l;\n\t            ^^^^^^^^^^^^^\nUnnecessary cast from List to ArrayList\n----------\n7. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t{\n\t\tint i = 12;\n\t\tint j = (byte) i;\n\t\tfloat f = (float) i;\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tfloat f = (float) i;\n\t          ^^^^^^^^^\nUnnecessary cast from int to float\n----------\n2. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X {\n    class A extends X {\n        public void callMe() {\n        }\n    }\n    public abstract void callMe();\n    class B {\n        public void callSite() {\n            // expect warning not there:\n            ((A) this.getAA()).callMe();\n            Integer max = Integer.valueOf(1);\n            // execpted warning there:\n            Integer other = (Integer) max;\n        }\n        public X getAA() {\n            Zork z;\n            return null;\n        }\n    }\n}"}, "----------\n1. WARNING in X.java (at line 13)\n\tInteger other = (Integer) max;\n\t                ^^^^^^^^^^^^^\nUnnecessary cast from Integer to Integer\n----------\n2. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\t\n\t}\n\t\n\tpublic static void foo(boolean b, List l) {\n\t\tif (b) {\n\t\t\tString s = (String) l.get(0);\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test043() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\t\n\t}\n\t\n\tpublic static void foo(boolean b, List l) {\n\t\tif (b) {\n\t\t\tObject o = (Object) l.get(0);\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static String s;\n    public static void main(String[] args) throws Throwable {\n      if (args.length == 0) {\n        Class c = Class.forName(\"X\");\n        String s = ((X) c.newInstance()).s;\n        System.out.println(s);\n      }\n      System.out.println();\n    }\n}"}, "null");
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(castLongToInt(3));\n\t}\n\tprivate static int castLongToInt(long longVal) {\n\t\treturn (int)((long)longVal);\n\t}\n}\n"}, "3");
    }

    public void test046() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tchar a = 65;\n\t\tString b = \"\" + a; // -> \"A\"\n\t\tString c = \"\" + (int) a;\n\t\tSystem.out.print(b);\n\t\tSystem.out.print(c);\n\t\t\n\t\tString logText = \" second case \";\n\t\tchar firstChar = 65;\n\t\tlogText += (int) firstChar;\n\t\tSystem.out.println(logText);\n\t}\n}"}, "", "A65 second case 65", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test047() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X{\n\tvoid test() {\t\tInteger a = 1;\n\t\tArrayList<Character> aList = new ArrayList<Character>(1);\n\t\ta = (Integer)a + (Integer)2;\n\t\tif ((Character)aList.get(0) == 'c')\n\t\t\tSystem.out.println();\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 5)\n\ta = (Integer)a + (Integer)2;\n\t    ^^^^^^^^^^\nUnnecessary cast from Integer to Integer\n----------\n2. WARNING in X.java (at line 5)\n\ta = (Integer)a + (Integer)2;\n\t                 ^^^^^^^^^^\nUnnecessary cast from int to Integer\n----------\n3. WARNING in X.java (at line 6)\n\tif ((Character)aList.get(0) == 'c')\n\t    ^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Character to Character\n----------\n");
    }

    public void test048() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            return;
        }
        this.runNegativeTest(new String[]{"A.java", "public class A<T> extends D<T> {\n    public class A1 extends D1 {\n    }\n    void m1(A<T> tree) {\n        A.A1 v = ((A.A1) tree.root);\n    }\n    Zork z;\n}\nclass D<T> {\n    protected D1 root;\n    protected class D1 {\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test049() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            return;
        }
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tvoid foo(Other2<?>.Member2<?> om2) {\n\t\tOther<?>.Member m = (Other<?>.Member) om2;\n\t\tm = om2;\n\t}\n}\nclass Other<T> {\n\tclass Member {}\n}\nclass Other2<T> extends Other<T> {\n\tclass Member2<U> extends Other<U>.Member {\n\t}\n}\n"}, "----------\n1. WARNING in A.java (at line 3)\n\tOther<?>.Member m = (Other<?>.Member) om2;\n\t                    ^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Other2<?>.Member2<capture#1-of ?> to Other<?>.Member\n----------\n");
    }

    public void test050() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            return;
        }
        this.runNegativeTest(new String[]{"A.java", "public class A<T> extends D<T> {\n    public class A1 extends D.D1 {\n    }\n    void m1(A<T> tree) {\n        A.A1 v = ((A.A1) tree.root);\n    }\n    Zork z;\n}\nclass D<T> {\n    protected D1 root;\n    protected class D1 {\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test051() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\tboolean y = (boolean) x;\n\t\tSystem.out.println(y);\n\t}\n\tpublic static Object foo() {\n\t\treturn Boolean.TRUE;\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 4)\n\tboolean y = (boolean) x;\n\t            ^^^^^^^^^^^\nCannot cast from Object to boolean\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "true");
        }
    }

    public void test052() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\tbyte y = (byte) x;\n\t\tSystem.out.println(y);\n\t}\n\tpublic static Object foo() {\n\t\treturn Byte.valueOf((byte)1);\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 4)\n\tbyte y = (byte) x;\n\t         ^^^^^^^^\nCannot cast from Object to byte\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "1");
        }
    }

    public void test053() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\tchar y = (char) x;\n\t\tSystem.out.println(y);\n\t}\n\tpublic static Object foo() {\n\t\treturn Character.valueOf('d');\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 4)\n\tchar y = (char) x;\n\t         ^^^^^^^^\nCannot cast from Object to char\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "d");
        }
    }

    public void test054() throws Exception {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\tint y = (int) x;\n\t\tSystem.out.println(y);\n\t}\n\tpublic static Object foo() {\n\t\treturn Integer.valueOf(1);\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 4)\n\tint y = (int) x;\n\t        ^^^^^^^\nCannot cast from Object to int\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "1");
            String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  invokestatic X.foo() : java.lang.Object [16]\n     3  astore_1 [x]\n     4  aload_1 [x]\n     5  checkcast java.lang.Integer [20]\n     8  invokevirtual java.lang.Integer.intValue() : int [22]\n    11  istore_2 [y]\n    12  getstatic java.lang.System.out : java.io.PrintStream [26]\n    15  iload_2 [y]\n    16  invokevirtual java.io.PrintStream.println(int) : void [32]\n    19  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 4, line: 4]\n        [pc: 12, line: 5]\n        [pc: 19, line: 6]\n      Local variable table:\n        [pc: 0, pc: 20] local: args index: 0 type: java.lang.String[]\n        [pc: 4, pc: 20] local: x index: 1 type: java.lang.Object\n        [pc: 12, pc: 20] local: y index: 2 type: int\n  \n";
            File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
            byte[] classFileBytes = Util.getFileByteContent((File)f);
            ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
            String result = disassembler.disassemble(classFileBytes, "\n", 1);
            int index = result.indexOf(expectedOutput);
            if (index == -1 || expectedOutput.length() == 0) {
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
            }
            if (index == -1) {
                CastTest.assertEquals("Wrong contents", expectedOutput, result);
            }
        }
    }

    public void test055() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\tlong y = (long) x;\n\t\tSystem.out.println(y);\n\t}\n\tpublic static Object foo() {\n\t\treturn Long.valueOf(Long.MAX_VALUE);\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 4)\n\tlong y = (long) x;\n\t         ^^^^^^^^\nCannot cast from Object to long\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "9223372036854775807");
        }
    }

    public void test056() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\tshort y = (short) x;\n\t\tSystem.out.println(y);\n\t}\n\tpublic static Object foo() {\n\t\treturn Short.valueOf((short) 1);\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 4)\n\tshort y = (short) x;\n\t          ^^^^^^^^^\nCannot cast from Object to short\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "1");
        }
    }

    public void test057() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\tdouble y = (double) x;\n\t\tSystem.out.println(y);\n\t}\n\tpublic static Object foo() {\n\t\treturn Double.valueOf(1.0);\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 4)\n\tdouble y = (double) x;\n\t           ^^^^^^^^^^\nCannot cast from Object to double\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "1.0");
        }
    }

    public void test058() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\tfloat y = (float) x;\n\t\tSystem.out.println(y);\n\t}\n\tpublic static Object foo() {\n\t\treturn Float.valueOf(1.0f);\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 4)\n\tfloat y = (float) x;\n\t          ^^^^^^^^^\nCannot cast from Object to float\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "1.0");
        }
    }

    public void test059() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\ttry {\n\t\t\tint y = (int) x;\n\t\t} catch (ClassCastException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\treturn;\n\t\t}\n\t\tSystem.out.println(\"FAIL\");\n\t}\n\tpublic static Object foo() {\n\t\treturn Float.valueOf(1.0f);\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 5)\n\tint y = (int) x;\n\t        ^^^^^^^\nCannot cast from Object to int\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "SUCCESS");
        }
    }

    public void test059b() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\ttry {\n\t\t\tint y = (int) x;\n\t\t} catch (ClassCastException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\treturn;\n\t\t}\n\t\tSystem.out.println(\"FAIL\");\n\t}\n\tpublic static Object foo() {\n\t\treturn Boolean.TRUE;\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 5)\n\tint y = (int) x;\n\t        ^^^^^^^\nCannot cast from Object to int\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "SUCCESS");
        }
    }

    public void test059c() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\ttry {\n\t\t\tchar y = (char) x;\n\t\t} catch (ClassCastException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\treturn;\n\t\t}\n\t\tSystem.out.println(\"FAIL\");\n\t}\n\tpublic static Object foo() {\n\t\treturn Boolean.TRUE;\n\t}\n}";
        if (options.sourceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 5)\n\tchar y = (char) x;\n\t         ^^^^^^^^\nCannot cast from Object to char\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", source}, "SUCCESS");
        }
    }

    public void test060() {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\tBoolean y = (Boolean) x;\n\t\tSystem.out.println(y);\n\t}\n\tpublic static Object foo() {\n\t\treturn Boolean.TRUE;\n\t}\n}";
        this.runConformTest(new String[]{"X.java", source}, "true");
    }

    public void test061() {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject x = foo();\n\t\ttry {\n\t\t\tFloat y = (Float) x;\n\t\t} catch (ClassCastException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\treturn;\n\t\t}\n\t\tSystem.out.println(\"FAIL\");\n\t}\n\tpublic static Object foo() {\n\t\treturn Boolean.TRUE;\n\t}\n}";
        this.runConformTest(new String[]{"X.java", source}, "SUCCESS");
    }

    public void test061b() throws Exception {
        String source = "public class X {\npublic X() {\n    Object[] x = (Object[])null;\n}\n}\n";
        this.runConformTest(new String[]{"X.java", source}, "");
        String expectedOutput = "public class X {\n  \n  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 2\n  public X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [8]\n     4  aconst_null\n     5  checkcast java.lang.Object[] [10]\n     8  astore_1 [x]\n     9  return\n      Line numbers:\n        [pc: 0, line: 2]\n        [pc: 4, line: 3]\n        [pc: 9, line: 4]\n      Local variable table:\n        [pc: 0, pc: 10] local: this index: 0 type: X\n        [pc: 9, pc: 10] local: x index: 1 type: java.lang.Object[]\n}";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            CastTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test420283() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\npublic class X {\n    void foo(List<Integer> l) {\n        Integer i = (Integer & Serializable) l.get(0);\n    }\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tInteger i = (Integer & Serializable) l.get(0);\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Integer to Integer & Serializable\n----------\n2. ERROR in X.java (at line 5)\n\tInteger i = (Integer & Serializable) l.get(0);\n\t             ^^^^^^^^^^^^^^^^^^^^^^\nAdditional bounds are not allowed in cast operator at source levels below 1.8\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\npublic class X {\n    void foo(List<Integer> l) {\n        Integer i = (Integer & Serializable) l.get(0);\n    }\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void testBug428274() {
        String source = "public class Junk4 {\n    static void setValue(Number n) {\n        int rounded = (int) Math.round((double) n);\n\t\tSystem.out.println(rounded);\n    }\n\tpublic static void main(String[] args) {\n\t\tsetValue(Double.valueOf(3.3));\n\t\tsetValue(Double.valueOf(3.7));\n\t}\n}\n";
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"Junk4.java", source}, "----------\n1. ERROR in Junk4.java (at line 3)\n\tint rounded = (int) Math.round((double) n);\n\t                               ^^^^^^^^^^\nCannot cast from Number to double\n----------\n");
        } else {
            this.runConformTest(new String[]{"Junk4.java", source}, "3\n4");
        }
    }

    public void testBug428274b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        String source = "public class Junk4<T> {\n    void setValue(T n) {\n        int rounded = (int) Math.round((double) n);\n\t\tSystem.out.println(rounded);\n    }\n\tpublic static void main(String[] args) {\n\t\tJunk4<Number> j = new Junk4<Number>();\n\t\tj.setValue(Double.valueOf(3.3));\n\t\tj.setValue(Double.valueOf(3.7));\n\t}\n}\n";
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"Junk4.java", source}, "----------\n1. ERROR in Junk4.java (at line 3)\n\tint rounded = (int) Math.round((double) n);\n\t                               ^^^^^^^^^^\nCannot cast from T to double\n----------\n");
        } else {
            this.runConformTest(new String[]{"Junk4.java", source}, "3\n4");
        }
    }

    public void testBug428274c() {
        String source = "public class Junk4 {\n    static void setValue(Object[] n) {\n        int rounded = (int) Math.round((double) n);\n\t\tSystem.out.println(rounded);\n    }\n\tpublic static void main(String[] args) {\n\t\tsetValue(new Double[] { Double.valueOf(3.3) });\n\t}\n}\n";
        this.runNegativeTest(new String[]{"Junk4.java", source}, "----------\n1. ERROR in Junk4.java (at line 3)\n\tint rounded = (int) Math.round((double) n);\n\t                               ^^^^^^^^^^\nCannot cast from Object[] to double\n----------\n");
    }

    public void test428388() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n\tint x = (int) \"Hello\";\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint x = (int) \"Hello\";\n\t        ^^^^^^^^^^^^^\nCannot cast from String to int\n----------\n");
    }

    public void test428388a() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n    static void setValue(Number n) {\n       int rounded = (int) Math.round((double) n);\n\t\tSystem.out.println(rounded);\n    }\n\tpublic static void main(String[] args) {\n\t\tsetValue(Double.valueOf(3.3));\n\t\tsetValue(Double.valueOf(3.7));\n\t}\n}\n"}, "3\n4");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 (Ljava/lang/Number;)V\n  // Stack: 2, Locals: 2\n  static void setValue(java.lang.Number n);\n     0  aload_0 [n]\n     1  checkcast java.lang.Double [16]\n     4  invokevirtual java.lang.Double.doubleValue() : double [18]\n     7  invokestatic java.lang.Math.round(double) : long [22]\n    10  l2i\n    11  istore_1 [rounded]\n    12  getstatic java.lang.System.out : java.io.PrintStream [28]\n    15  iload_1 [rounded]\n    16  invokevirtual java.io.PrintStream.println(int) : void [34]\n    19  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 12, line: 4]\n        [pc: 19, line: 5]\n      Local variable table:\n        [pc: 0, pc: 20] local: n index: 0 type: java.lang.Number\n        [pc: 12, pc: 20] local: rounded index: 1 type: int\n  \n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            CastTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test428388b() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static void setValue(Number n) {\n       char rounded = (char) n;\n\t\tSystem.out.println(rounded);\n    }\n\tpublic static void main(String[] args) {\n\t\tsetValue(Double.valueOf(3.3));\n\t\tsetValue(Double.valueOf(3.7));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tchar rounded = (char) n;\n\t               ^^^^^^^^\nCannot cast from Number to char\n----------\n");
    }

    public void test428388c() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n    static void setValue(Number n) {\n       try {\n           byte rounded = (byte) n;\n\t\t    System.out.println(rounded);\n       } catch (ClassCastException c) {\n           System.out.println(\"CCE\");\n       }\n    }\n\tpublic static void main(String[] args) {\n\t\tsetValue(Double.valueOf(3.3));\n\t\tsetValue(Double.valueOf(3.7));\n\t}\n}\n"}, "CCE\nCCE");
    }

    public void test428388d() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X implements Serializable {\n\tstatic int test(Serializable v) {\n       try {\n\t\t    return (int)v;\n       } catch (ClassCastException c) {\n           System.out.println(\"CCE\");\n       }\n       return -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = test(new X());\n\t\tSystem.out.println(i);\n\t}\n}\n"}, "CCE\n-1");
    }

    public void test428388e() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X implements Serializable {\n\tstatic int test(Serializable v) {\n       try {\n\t\t    return (int)v;\n       } catch (ClassCastException c) {\n           System.out.println(\"CCE\");\n       }\n       return -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = test(new Long(1234));\n\t\tSystem.out.println(i);\n\t}\n}\n"}, "CCE\n-1");
    }

    public void test428388f() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X implements Serializable {\n\tstatic int test(Serializable v) {\n       try {\n\t\t    return (int)v;\n       } catch (ClassCastException c) {\n           System.out.println(\"CCE\");\n       }\n       return -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = test(new Integer(1234));\n\t\tSystem.out.println(i);\n\t}\n}\n"}, "1234");
    }

    public void test428388g() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X implements Serializable {\n  static <S extends Boolean & Serializable>int test(S b) {\n    return (int) b;\n  }\n\n  public static void main(String[] args) {\n    int i = test(Boolean.TRUE);\n    System.out.println(i);\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic class X implements Serializable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 3)\n\tstatic <S extends Boolean & Serializable>int test(S b) {\n\t                  ^^^^^^^\nThe type parameter S should not be bounded by the final type Boolean. Final types cannot be further extended\n----------\n3. ERROR in X.java (at line 4)\n\treturn (int) b;\n\t       ^^^^^^^\nCannot cast from S to int\n----------\n");
    }

    public void test428388h() throws Exception {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X implements Serializable {\n  static int test(Serializable b) {\n    return (int) (Boolean & Serializable) b;\n  }\n  public static void main(String[] args) {\n    int i = test(Boolean.TRUE);\n    System.out.println(i);\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic class X implements Serializable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 4)\n\treturn (int) (Boolean & Serializable) b;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from Boolean & Serializable to int\n----------\n");
    }

    public void test428388i() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X implements Serializable {\n\tstatic int test(Serializable v) {\n       try {\n\t\t    return (int)v;\n       } catch (ClassCastException c) {\n           System.out.println(\"CCE\");\n       }\n       return -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = test(new Integer(1234));\n\t\tSystem.out.println(i);\n\t}\n}\n"}, "1234");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #17 (Ljava/io/Serializable;)I\n  // Stack: 2, Locals: 2\n  static int test(java.io.Serializable v);\n     0  aload_0 [v]\n     1  checkcast java.lang.Integer [18]\n     4  invokevirtual java.lang.Integer.intValue() : int [20]\n     7  ireturn\n     8  astore_1 [c]\n     9  getstatic java.lang.System.out : java.io.PrintStream [24]\n    12  ldc <String \"CCE\"> [30]\n    14  invokevirtual java.io.PrintStream.println(java.lang.String) : void [32]\n    17  iconst_m1\n    18  ireturn\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            CastTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test428388j() throws Exception {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X implements Serializable {\n  static int test(Serializable b) {\n    return (int) (Integer & Serializable) b;\n  }\n  public static void main(String[] args) {\n    int i = test(10101010);\n    System.out.println(i);\n  }\n}\n"}, "10101010");
    }

    public void test428522() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String args[]) {\n    \tlong l = (long) ((Object) 100L);\n    \tSystem.out.println(\"OK\");\n    }\n}\n"}, "OK", customOptions);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  ldc2_w <Long 100> [16]\n     3  invokestatic java.lang.Long.valueOf(long) : java.lang.Long [18]\n     6  checkcast java.lang.Long [19]\n     9  invokevirtual java.lang.Long.longValue() : long [24]\n    12  pop2\n    13  getstatic java.lang.System.out : java.io.PrintStream [28]\n    16  ldc <String \"OK\"> [34]\n    18  invokevirtual java.io.PrintStream.println(java.lang.String) : void [36]\n    21  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 13, line: 4]\n        [pc: 21, line: 5]\n      Local variable table:\n        [pc: 0, pc: 22] local: args index: 0 type: java.lang.String[]\n}";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            CastTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test428522a() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String args[]) {\n    \tlong l = (long) ((Object) 100L);\n    \tSystem.out.println(\"OK\");\n    }\n}\n"}, "OK", customOptions);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  ldc2_w <Long 100> [16]\n     3  invokestatic java.lang.Long.valueOf(long) : java.lang.Long [18]\n     6  checkcast java.lang.Long [19]\n     9  invokevirtual java.lang.Long.longValue() : long [24]\n    12  lstore_1 [l]\n    13  getstatic java.lang.System.out : java.io.PrintStream [28]\n    16  ldc <String \"OK\"> [34]\n    18  invokevirtual java.io.PrintStream.println(java.lang.String) : void [36]\n    21  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 13, line: 4]\n        [pc: 21, line: 5]\n      Local variable table:\n        [pc: 0, pc: 22] local: args index: 0 type: java.lang.String[]\n        [pc: 13, pc: 22] local: l index: 1 type: long\n}";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            CastTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test428522b() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String args[]) {\n       try {\n    \t    int l = (int) ((Object) 100L);\n       } catch (ClassCastException c) {\n    \t    System.out.println(\"CCE:OK\");\n       }\n    }\n}\n"}, "CCE:OK", customOptions);
    }

    public void test428522c() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String args[]) {\n    \tint l = (int) ((Object) 100);\n    \tSystem.out.println(\"OK\");\n    }\n}\n"}, "OK", customOptions);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  bipush 100\n     2  invokestatic java.lang.Integer.valueOf(int) : java.lang.Integer [16]\n     5  checkcast java.lang.Integer [17]\n     8  invokevirtual java.lang.Integer.intValue() : int [22]\n    11  pop\n    12  getstatic java.lang.System.out : java.io.PrintStream [26]\n    15  ldc <String \"OK\"> [32]\n    17  invokevirtual java.io.PrintStream.println(java.lang.String) : void [34]\n    20  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 12, line: 4]\n        [pc: 20, line: 5]\n      Local variable table:\n        [pc: 0, pc: 21] local: args index: 0 type: java.lang.String[]\n}";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            CastTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test441731() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runConformTest(new String[]{"X.java", "interface MUIElement {}\ninterface MUIElementContainer<T extends MUIElement> extends MUIElement{}\ninterface MWindowElement extends MUIElement {}\ninterface MWindow extends MUIElementContainer<MWindowElement> {}\npublic class X {\n\tvoid test(MUIElementContainer<MUIElement> me) {\n\t\tif(((MUIElement) me) instanceof MWindow) return;\n\t\tMWindow mw = (MWindow)((MUIElement)me);\n\t}\n}\n"}, customOptions);
    }

    public void test448112() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n\n  static class Y {\n\t  public Object getAttribute(String name) {\n\t  \treturn new Long(100L);\n\t  }\n\t}\n\tpublic static void foo2(Y y) {\n\n\t\ttry {\n\t\t\tlong v1 = (Long) y.getAttribute(\"v1\");\n\t\t\tlong v2 = (Long) y.getAttribute(\"v2\");\n\n\t\t\tSystem.out.println(String.valueOf(v1));\n\n\t\t} catch (java.lang.Throwable t) {}\n\t}\n\t\n\tpublic static void main(String args[]) {\n\t\tfoo2(new Y());\n  }\n}"}, "100", customOptions);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  public static void foo2(X.Y y);\n     0  aload_0 [y]\n     1  ldc <String \"v1\"> [16]\n     3  invokevirtual X$Y.getAttribute(java.lang.String) : java.lang.Object [18]\n     6  checkcast java.lang.Long [24]\n     9  invokevirtual java.lang.Long.longValue() : long [26]\n    12  lstore_1 [v1]\n    13  aload_0 [y]\n    14  ldc <String \"v2\"> [30]\n    16  invokevirtual X$Y.getAttribute(java.lang.String) : java.lang.Object [18]\n    19  checkcast java.lang.Long [24]\n    22  pop\n    23  getstatic java.lang.System.out : java.io.PrintStream [32]\n    26  lload_1 [v1]\n    27  invokestatic java.lang.String.valueOf(long) : java.lang.String [38]\n    30  invokevirtual java.io.PrintStream.println(java.lang.String) : void [44]\n    33  goto 37\n    36  pop\n    37  return\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            CastTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test461706() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runConformTest(new String[]{"Bug.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class Bug {\n\tprivate static class AndCondition implements ICondition {\n\t\tpublic AndCondition(ICondition cond1, ICondition cond2) {\n\t\t\t// todo\n\t\t}\n\t}\n\tprivate static class SimpleCondition implements ICondition {\n\t}\n\tprivate static interface ICondition {\n\t\tICondition TRUE = new SimpleCondition();\n\t\tdefault ICondition and(final ICondition cond) {\n\t\t\treturn new AndCondition(this, cond);\n\t\t}\n\t}\n\tpublic static void main(final String[] args) {\n\t\tfinal List<SimpleCondition> conditions = new ArrayList<>();\n\t\tconditions.stream()\n\t\t\t\t.map(x -> (ICondition)x)\n\t\t\t\t.reduce((x, y) -> x.and(y))\n\t\t\t\t.orElse(ICondition.TRUE);\n\t}\n}"}, customOptions);
    }

    public void test461706a() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"Bug.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class Bug {\n\tprivate static class AndCondition implements ICondition {\n\t\tpublic AndCondition(ICondition cond1, ICondition cond2) {\n\t\t\t// todo\n\t\t}\n\t}\n\tstatic class SimpleCondition implements ICondition {\n\t}\n\tprivate static interface ICondition {\n\t\tICondition TRUE = new SimpleCondition();\n\t\tdefault ICondition and(final ICondition cond) {\n\t\t\treturn new AndCondition(this, cond);\n\t\t}\n\t}\n\tpublic static void main(final String[] args) {\n\t\tfinal List<ICondition> conditions = new ArrayList<>();\n\t\tconditions.stream()\n\t\t\t\t.map(x -> (ICondition)x)\n\t\t\t\t.reduce((x, y) -> x.and(y))\n\t\t\t\t.orElse(ICondition.TRUE);\n\t}\n}"}, "----------\n1. ERROR in Bug.java (at line 20)\n\t.map(x -> (ICondition)x)\n\t          ^^^^^^^^^^^^^\nUnnecessary cast from Bug.ICondition to Bug.ICondition\n----------\n", null, true, customOptions);
    }

    public void testAnonymous_bug520727() {
        String[] source = new String[]{"O.java", "import java.io.Serializable;\npublic class O {\n\tObject in = new Object() {\n        public Object foo() {\n                return (Serializable) this;\n        }\n\t};\n}\n"};
        if (this.complianceLevel < 0x350000L) {
            this.runNegativeTest(source, "----------\n1. ERROR in O.java (at line 5)\n\treturn (Serializable) this;\n\t       ^^^^^^^^^^^^^^^^^^^\nCannot cast from new Object(){} to Serializable\n----------\n");
        } else {
            this.runConformTest(source, "");
        }
    }

    public static Class testClass() {
        return CastTest.class;
    }
}

