/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.ModuleCompilationTests;
import org.eclipse.jdt.core.tests.util.Util;

public class ClasspathJmodTests
extends ModuleCompilationTests {
    public ClasspathJmodTests(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("modules.to.load", "java.base");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        System.setProperty("modules.to.load", "");
    }

    public static Test suite() {
        return ClasspathJmodTests.buildMinimalComplianceTestSuite(ClasspathJmodTests.testClass(), 64);
    }

    public static Class<?> testClass() {
        return ClasspathJmodTests.class;
    }

    private String getJavaSqlJMod() {
        String home = Util.getJREDirectory();
        return String.valueOf(home) + File.separator + "jmods" + File.separator + "java.sql.jmod" + File.pathSeparator;
    }

    @Override
    public void test001() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n  requires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" --module-path \"").append(this.getJavaSqlJMod()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false, "p.X");
    }

    @Override
    public void test002() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n  requires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" --module-path \"").append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\trequires java.sql;\n\t         ^^^^^^^^\njava.sql cannot be resolved to a module\n----------\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 3)\n\tpublic static java.sql.Connection getConnection() {\n\t              ^^^^^^^^\njava.sql cannot be resolved to a type\n----------\n2 problems (2 errors)\n", false, "p.X");
    }

    @Override
    public void test003() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n  requires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(this.getJavaSqlJMod()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\trequires java.sql;\n\t         ^^^^^^^^\njava.sql cannot be resolved to a module\n----------\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 3)\n\tpublic static java.sql.Connection getConnection() {\n\t              ^^^^^^^^\njava.sql cannot be resolved to a type\n----------\n2 problems (2 errors)\n", false, "p.X");
    }

    @Override
    public void test004() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" --module-path \"").append(this.getJavaSqlJMod()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 3)\n\tpublic static java.sql.Connection getConnection() {\n\t              ^^^^^^^^\njava.sql cannot be resolved to a type\n----------\n1 problem (1 error)\n", false, "p.X");
    }

    @Override
    public void test005() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p;\n\trequires mod.two;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\nimport q.Y;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn Y.con;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports q;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   public static java.sql.Connection con = null;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" --module-path \"").append(this.getJavaSqlJMod()).append("\" ").append(" -warn:-exports").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }
}

