/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DebugAttributeTest
extends AbstractRegressionTest {
    public DebugAttributeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return DebugAttributeTest.buildAllCompliancesTestSuite(DebugAttributeTest.testClass());
    }

    public static Class testClass() {
        return DebugAttributeTest.class;
    }

    public void test001() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        String s;\n        if(args.length == 0) {\n          s = \"SUCCESS\";\n        } else {\n          return;\n        }\n        System.out.println(s);\n    }\n}"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "      Local variable table:\n        [pc: 0, pc: 20] local: args index: 0 type: java.lang.String[]\n        [pc: 8, pc: 11] local: s index: 1 type: java.lang.String\n        [pc: 12, pc: 20] local: s index: 1 type: java.lang.String\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            DebugAttributeTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test002() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"line 1\");\n\t\tmyBlock: {\n\t\t\tSystem.out.print(\"line 2\");\n\t\t\tif (false) {\n\t\t\t\tbreak myBlock;\n\t\t\t}\n\t\t\tSystem.out.print(\"line 3\");\n\t\t}\n\t\tSystem.out.print(\"line 4\");\n\t}}"}, "line 1line 2line 3line 4");
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  ldc <String \"line 1\"> [22]\n     5  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n     8  getstatic java.lang.System.out : java.io.PrintStream [16]\n    11  ldc <String \"line 2\"> [30]\n    13  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    16  getstatic java.lang.System.out : java.io.PrintStream [16]\n    19  ldc <String \"line 3\"> [32]\n    21  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    24  getstatic java.lang.System.out : java.io.PrintStream [16]\n    27  ldc <String \"line 4\"> [34]\n    29  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    32  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 8, line: 5]\n        [pc: 16, line: 9]\n        [pc: 24, line: 11]\n        [pc: 32, line: 12]\n      Local variable table:\n        [pc: 0, pc: 33] local: args index: 0 type: java.lang.String[]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            DebugAttributeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test003() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\nimport java.util.Iterator;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList l = new ArrayList();\n\t\tList l2 = new ArrayList();\n\t\tl.add(new X());\n\t\tfor (Iterator iterator = l.iterator(); iterator.hasNext() ;) {\n\t\t\tl2.add(((X) iterator.next()).toString()\n\t\t\t\t.substring(3));\n\t\t}\n\t\tfor (Iterator iterator = l2.iterator(); iterator.hasNext() ;) {\n\t\t\tSystem.out.println(iterator.next());\n\t\t}\n\t}\tpublic String toString() {\n\t\treturn \"NO_SUCCESS\";\n\t}\n}"}, "SUCCESS");
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 3, Locals: 4\n  public static void main(java.lang.String[] args);\n      0  new java.util.ArrayList [16]\n      3  dup\n      4  invokespecial java.util.ArrayList() [18]\n      7  astore_1 [l]\n      8  new java.util.ArrayList [16]\n     11  dup\n     12  invokespecial java.util.ArrayList() [18]\n     15  astore_2 [l2]\n     16  aload_1 [l]\n     17  new X [1]\n     20  dup\n     21  invokespecial X() [19]\n     24  invokeinterface java.util.List.add(java.lang.Object) : boolean [20] [nargs: 2]\n     29  pop\n     30  aload_1 [l]\n     31  invokeinterface java.util.List.iterator() : java.util.Iterator [26] [nargs: 1]\n     36  astore_3 [iterator]\n     37  goto 63\n     40  aload_2 [l2]\n     41  aload_3 [iterator]\n     42  invokeinterface java.util.Iterator.next() : java.lang.Object [30] [nargs: 1]\n     47  checkcast X [1]\n     50  invokevirtual X.toString() : java.lang.String [36]\n     53  iconst_3\n     54  invokevirtual java.lang.String.substring(int) : java.lang.String [40]\n     57  invokeinterface java.util.List.add(java.lang.Object) : boolean [20] [nargs: 2]\n     62  pop\n     63  aload_3 [iterator]\n     64  invokeinterface java.util.Iterator.hasNext() : boolean [46] [nargs: 1]\n     69  ifne 40\n     72  aload_2 [l2]\n     73  invokeinterface java.util.List.iterator() : java.util.Iterator [26] [nargs: 1]\n     78  astore_3 [iterator]\n     79  goto 94\n     82  getstatic java.lang.System.out : java.io.PrintStream [50]\n     85  aload_3 [iterator]\n     86  invokeinterface java.util.Iterator.next() : java.lang.Object [30] [nargs: 1]\n     91  invokevirtual java.io.PrintStream.println(java.lang.Object) : void [56]\n     94  aload_3 [iterator]\n     95  invokeinterface java.util.Iterator.hasNext() : boolean [46] [nargs: 1]\n    100  ifne 82\n    103  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 8, line: 7]\n        [pc: 16, line: 8]\n        [pc: 30, line: 9]\n        [pc: 40, line: 10]\n        [pc: 53, line: 11]\n        [pc: 57, line: 10]\n        [pc: 63, line: 9]\n        [pc: 72, line: 13]\n        [pc: 82, line: 14]\n        [pc: 94, line: 13]\n        [pc: 103, line: 16]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            DebugAttributeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test004() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X{\n\tpublic class Inner {\n\t\tpublic void foo() {\n\t\t\tint i = 0;\n\t\t\tfinal int NEW = 1;\n\t\t\tif (i == NEW) {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\tbar();\n\t\t}\n\t}\n\tpublic void bar() {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new Inner().foo();\n\t}\n}"}, "SUCCESS");
        String expectedOutput = "    22  return\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 2, line: 5]\n        [pc: 4, line: 6]\n        [pc: 9, line: 7]\n        [pc: 15, line: 9]\n        [pc: 22, line: 10]\n      Local variable table:\n        [pc: 0, pc: 23] local: this index: 0 type: X.Inner\n        [pc: 2, pc: 23] local: i index: 1 type: int\n        [pc: 4, pc: 23] local: NEW index: 2 type: int\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Inner.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            DebugAttributeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }
}

