/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ExternalizeStringLiterals15Test
extends AbstractRegressionTest {
    public ExternalizeStringLiterals15Test(String name) {
        super(name);
    }

    public static Test suite() {
        return ExternalizeStringLiterals15Test.buildUniqueComplianceTestSuite(ExternalizeStringLiterals15Test.testClass(), 0x310000L);
    }

    public void test001() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runConformTest(new String[]{"X.java", "import static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\n@Target({TYPE, FIELD, METHOD,\n         PARAMETER, CONSTRUCTOR,\n         LOCAL_VARIABLE, PACKAGE})\n@Retention(CLASS)\npublic @interface X\n{\n    String[] value() default {};\n    String justification() default \"\";\n}"}, "", null, true, null, customOptions, null);
    }

    public void test002() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(true, new String[]{"X.java", "class X {\n\tString s2 = \"test1\"; //$NON-NLS-1$\n\tString s3 = \"test2\"; //$NON-NLS-1$//$NON-NLS-2$\n\n\n\tvoid foo() {\n\t\tString s4 = null;\n\t\tString s5 = \"test3\";\n\t\tString s6 = \"test4\";\n\t\tSystem.out.println(\"test5\");\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tString s3 = \"test2\"; //$NON-NLS-1$//$NON-NLS-2$\n\t                                  ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n2. ERROR in X.java (at line 8)\n\tString s5 = \"test3\";\n\t            ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n3. ERROR in X.java (at line 9)\n\tString s6 = \"test4\";\n\t            ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n4. ERROR in X.java (at line 10)\n\tSystem.out.println(\"test5\");\n\t                   ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test003() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(true, new String[]{"X.java", "class X {\n\tString s2 = \"test1\"; //$NON-NLS-1$\n\tString s3 = \"test2\"; //$NON-NLS-1$//$NON-NLS-2$\n\n\n\tvoid foo() {\n\t\tString s4 = null;\n\t\tString s5 = null;//$NON-NLS-1$\n\t\tString s6 = \"test4\";\n\t\tSystem.out.println(\"test5\");\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tString s3 = \"test2\"; //$NON-NLS-1$//$NON-NLS-2$\n\t                                  ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n2. ERROR in X.java (at line 8)\n\tString s5 = null;//$NON-NLS-1$\n\t                 ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n3. ERROR in X.java (at line 9)\n\tString s6 = \"test4\";\n\t            ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n4. ERROR in X.java (at line 10)\n\tSystem.out.println(\"test5\");\n\t                   ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test004() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runConformTest(true, new String[]{"X.java", "class X {\n\tString s2 = \"test1\"; //$NON-NLS-1$\n\tString s3 = \"test2\"; //$NON-NLS-1$//$NON-NLS-2$\n\t\n\t@SuppressWarnings(\"nls\")\n\tvoid foo() {\n\t\tString s4 = null;\n\t\tString s5 = null;//$NON-NLS-1$\n\t\tString s6 = \"test4\";\n\t\tSystem.out.println(\"test5\");\n\t}\n}"}, null, customOptions, "----------\n1. WARNING in X.java (at line 3)\n\tString s3 = \"test2\"; //$NON-NLS-1$//$NON-NLS-2$\n\t                                  ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test005() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(true, new String[]{"X.java", "class X {\n\n\tvoid foo() {\n\t\tString s6 = \"SUCCESS\";\n\t\tSystem.out.println(s6);\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\tString s6 = \"SUCCESS\";\n\t            ^^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test006() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"nls\")\n\tpublic static void main(String[] args) {\n\t\tString s6 = \"SUCCESS\";\n\t\tSystem.out.println(s6);\n\t}\n}"}, "SUCCESS", null, true, null, customOptions, null);
    }

    public void test007() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Annot({\n\t\t@A(name = \"name\", //$NON-NLS-1$\n \t\tvalue = \"Test\") //$NON-NLS-1$\n\t})\n\t@X2(\"\") //$NON-NLS-1$\n\tvoid foo() {\n\t}\n}\n@interface Annot {\n\tA[] value();\n}\n@interface A {\n\tString name();\n\tString value();\n}\n@interface X2 {\n\tString value();\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\t@A(name = \"name\", //$NON-NLS-1$\n\t                  ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n2. ERROR in X.java (at line 4)\n\tvalue = \"Test\") //$NON-NLS-1$\n\t                ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n3. ERROR in X.java (at line 6)\n\t@X2(\"\") //$NON-NLS-1$\n\t        ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n", null, true, customOptions);
    }

    public static Class testClass() {
        return ExternalizeStringLiterals15Test.class;
    }
}

