/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractNullAnnotationTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class FlowAnalysisTest8
extends AbstractNullAnnotationTest {
    public FlowAnalysisTest8(String name) {
        super(name);
    }

    public static Test suite() {
        return FlowAnalysisTest8.buildMinimalComplianceTestSuite(FlowAnalysisTest8.testClass(), 32);
    }

    public static Class testClass() {
        return FlowAnalysisTest8.class;
    }

    public void testLambda_01() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"ISAM.java", "import org.eclipse.jdt.annotation.*;\npublic interface ISAM {\n\t@NonNull String toString(@NonNull String prefix, @Nullable Object o);\n}\n", "X.java", "public class X {\n\tvoid test() {\n\t\tISAM printer = (p,o) -> p.concat(o.toString());\n\t}\n}\n"}, customOptions, "----------\n1. WARNING in X.java (at line 3)\n\tISAM printer = (p,o) -> p.concat(o.toString());\n\t                        ^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n2. ERROR in X.java (at line 3)\n\tISAM printer = (p,o) -> p.concat(o.toString());\n\t                                 ^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n");
    }

    public void testLambda_02() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"ISAM.java", "import org.eclipse.jdt.annotation.*;\npublic interface ISAM {\n\tvoid process(@NonNull Object nn, @Nullable Object n, Object u);\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid test() {\n\t\tISAM printer = (@NonNull  Object o1, @NonNull \tObject o2, @NonNull\t Object o3) -> System.out.println(2);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\tISAM printer = (@NonNull  Object o1, @NonNull \tObject o2, @NonNull\t Object o3) -> System.out.println(2);\n\t                                     ^^^^^^^^^^^^^^^^\nIllegal redefinition of parameter o2, inherited method from ISAM declares this parameter as @Nullable\n----------\n2. ERROR in X.java (at line 4)\n\tISAM printer = (@NonNull  Object o1, @NonNull \tObject o2, @NonNull\t Object o3) -> System.out.println(2);\n\t                                              \t           ^^^^^^^^^^^^^^^^\nIllegal redefinition of parameter o3, inherited method from ISAM does not constrain this parameter\n----------\n");
    }

    public void testLambda_03() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"ISAM.java", "import org.eclipse.jdt.annotation.*;\npublic interface ISAM {\n\tvoid process(@NonNull Object nn, @Nullable Object n, Object u);\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid test() {\n\t\tISAM printer1 = (Object \t\t  o1, \t\t\tObject o2, \t\t\t Object o3) \n\t\t\t\t\t\t\t-> System.out.println(o1.toString()+o2.toString()+o3.toString());\n\t\tISAM printer3 = (@Nullable Object o1, @Nullable Object o2, @Nullable Object o3) \n\t\t\t\t\t\t\t-> System.out.println(o1.toString()+o2.toString()+o3.toString());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 5)\n\t-> System.out.println(o1.toString()+o2.toString()+o3.toString());\n\t                                    ^^\nPotential null pointer access: The variable o2 may be null at this location\n----------\n2. ERROR in X.java (at line 7)\n\t-> System.out.println(o1.toString()+o2.toString()+o3.toString());\n\t                      ^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n3. ERROR in X.java (at line 7)\n\t-> System.out.println(o1.toString()+o2.toString()+o3.toString());\n\t                                    ^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n4. ERROR in X.java (at line 7)\n\t-> System.out.println(o1.toString()+o2.toString()+o3.toString());\n\t                                                  ^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n");
    }

    public void testLambda_04() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"ISAM.java", "public interface ISAM {\n\tvoid process(int i);\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid test() {\n\t\tISAM printer1 = (@NonNull int i) \n\t\t\t\t\t\t\t-> System.out.println(i);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\tISAM printer1 = (@NonNull int i) \n\t                 ^^^^^^^^\nThe nullness annotation @NonNull is not applicable for the primitive type int\n----------\n");
    }

    public void testLambda_05() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"ISAM.java", "import org.eclipse.jdt.annotation.*;\npublic interface ISAM {\n\t@NonNull String toString(Object o);\n}\n", "X.java", "public class X {\n\tvoid test() {\n\t\tISAM printer = (o) -> {\n\t\t\tSystem.out.print(13);\n\t\t\treturn null; // error\n\t\t};\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 5)\n\treturn null; // error\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testLambda_05a() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"ISAM.java", "import org.eclipse.jdt.annotation.*;\npublic interface ISAM {\n\t@NonNull String toString();\n}\n", "X.java", "public class X {\n\tvoid test() {\n\t\tISAM printer = () -> {\n\t\t\tSystem.out.print(13);\n\t\t\treturn null;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tISAM printer = () -> {\n\t               ^^^^^\nThe target type of this expression must be a functional interface\n----------\n", this.LIBS, true, customOptions);
    }

    public void testReferenceExpression1() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n\tpublic void bar();\n}\n", "X.java", "public class X {\n\tpublic void moo() {}\n\tpublic static void soo() {}\n\tvoid testAssignment() {\n\t\tX x;\n\t\tI i = x::moo; // x is unassigned\n\t\ti.bar();\n\t\tI i2 = X::soo;\n\t}\n\tvoid testStatic() {\n\t\tX xs;\n\t\tI is = xs::soo;\n\t}\n\tvoid testUse() {\n\t\tX x1 = this, x2 = this; // x2 is not used, only x is\n\t\tI i = x1::moo;\n\t\ti.bar();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = x::moo; // x is unassigned\n\t      ^\nThe local variable x may not have been initialized\n----------\n2. ERROR in X.java (at line 12)\n\tI is = xs::soo;\n\t       ^^^^^^^\nThe method soo() from the type X should be accessed in a static way \n----------\n3. ERROR in X.java (at line 15)\n\tX x1 = this, x2 = this; // x2 is not used, only x is\n\t             ^^\nThe value of the local variable x2 is not used\n----------\n", null, true, options);
    }

    public void testReferenceExpression_null_1() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.nullReference", "error");
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError, new String[]{"I.java", "public interface I {\n\tpublic void foo();\n}\n", "X.java", "public class X {\n\tpublic void bar() {}\n\tvoid test() {\n\t\tX x = null;\n\t\tI i = x::bar;\n\t\ti.foo();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tI i = x::bar;\n\t      ^\nNull pointer access: The variable x can only be null at this location\n----------\n", null, true, options);
    }

    public void testReferenceExpression_nullAnnotation_1() {
        this.runNegativeTestWithLibs(new String[]{"I.java", "import org.eclipse.jdt.annotation.*;\npublic interface I {\n\tpublic @NonNull String foo(@Nullable Object s);\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tpublic @Nullable String bar(@NonNull Object s) { return s.toString(); }\n\tvoid test() {\n\t\tI i = this::bar;\n\t\tSystem.out.print(i.foo(null));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tI i = this::bar;\n\t      ^^^^^^^^^\nNull type mismatch at parameter 1: required '@NonNull Object' but provided '@Nullable Object' via method descriptor I.foo(Object)\n----------\n2. ERROR in X.java (at line 5)\n\tI i = this::bar;\n\t      ^^^^^^^^^\nNull type mismatch at method return type: Method descriptor I.foo(Object) promises '@NonNull String' but referenced method provides '@Nullable String'\n----------\n");
    }

    public void testReferenceExpression_nullAnnotation_2() {
        this.runWarningTestWithLibs(true, new String[]{"I.java", "import org.eclipse.jdt.annotation.*;\npublic interface I {\n\tpublic @NonNull String foo(@Nullable Object s);\n}\n", "X.java", "public class X {\n\tpublic String bar(Object s) { return s.toString(); }\n\tvoid test() {\n\t\tI i = this::bar;\n\t\tSystem.out.print(i.foo(null));\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 4)\n\tI i = this::bar;\n\t      ^^^^^^^^^\nNull type safety at method return type: Method descriptor I.foo(Object) promises '@NonNull String' but referenced method provides 'String'\n----------\n");
    }

    public void testReferenceExpression_nullAnnotation_3() {
        this.runNegativeTest(new String[]{"I.java", "import org.eclipse.jdt.annotation.*;\npublic interface I {\n\tpublic @NonNull String foo(Object s);\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tpublic @NonNull String bar(@NonNull Object s) { return \"\"; }\n\tvoid test() {\n\t\tI i = this::bar;\n\t\tSystem.out.print(i.foo(null));\n\t}\n\tZork zork;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tI i = this::bar;\n\t      ^^^^^^^^^\nNull type safety: parameter 1 provided via method descriptor I.foo(Object) needs unchecked conversion to conform to '@NonNull Object'\n----------\n2. ERROR in X.java (at line 8)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", this.LIBS, true, this.getCompilerOptions());
    }

    public void testBug535308a() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        runner.testFiles = new String[]{"X.java", "public class X {\n\tpublic int someTest() {\n\t\tboolean unused = false;\n\t\tfinal boolean thisIsFalse = false;\n\t\tif (getSomeValue() == thisIsFalse) {\n\t\t\treturn 0;\n\t\t}\n\t\treturn 1;\n\t}\n\tprivate boolean getSomeValue() {\n\t\treturn true;\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 3)\n\tboolean unused = false;\n\t        ^^^^^^\nThe value of the local variable unused is not used\n----------\n";
        runner.classLibraries = this.LIBS;
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void testBug535308b() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        runner.testFiles = new String[]{"X.java", "public class X {\n\tpublic int someTest() {\n\t\tboolean unused = false;\n\t\tfinal boolean thisIsFalse = false;\n\t\tif (getSomeValue() != thisIsFalse) {\n\t\t\treturn 0;\n\t\t}\n\t\treturn 1;\n\t}\n\n\tprivate boolean getSomeValue() {\n\t\treturn true;\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 3)\n\tboolean unused = false;\n\t        ^^^^^^\nThe value of the local variable unused is not used\n----------\n";
        runner.classLibraries = this.LIBS;
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void testBug535308c() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        runner.testFiles = new String[]{"X.java", "public class X {\n\tpublic int someTest() {\n\t\tboolean unused = false;\n\t\tfinal boolean thisIsFalse = false;\n\t\tif (thisIsFalse != getSomeValue()) {\n\t\t\treturn 0;\n\t\t}\n\t\treturn 1;\n\t}\n\n\tprivate boolean getSomeValue() {\n\t\treturn true;\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 3)\n\tboolean unused = false;\n\t        ^^^^^^\nThe value of the local variable unused is not used\n----------\n";
        runner.classLibraries = this.LIBS;
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void testBug535308d() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        runner.testFiles = new String[]{"X.java", "public class X {\n\tpublic int someTest() {\n\t\tboolean unused = false;\n\t\tfinal boolean thisIsFalse = false;\n\t\tif (thisIsFalse == getSomeValue()) {\n\t\t\treturn 0;\n\t\t}\n\t\treturn 1;\n\t}\n\n\tprivate boolean getSomeValue() {\n\t\treturn true;\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 3)\n\tboolean unused = false;\n\t        ^^^^^^\nThe value of the local variable unused is not used\n----------\n";
        runner.classLibraries = this.LIBS;
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void testBug535308e() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        runner.testFiles = new String[]{"X.java", "public class X {\n\tpublic int someTest() {\n\t\tboolean used = false;\n\t\tfinal boolean thisIsFalse = false;\n\t\tif (used == getSomeValue()) {\n\t\t\treturn 0;\n\t\t}\n\t\treturn 1;\n\t}\n\n\tprivate boolean getSomeValue() {\n\t\treturn true;\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 4)\n\tfinal boolean thisIsFalse = false;\n\t              ^^^^^^^^^^^\nThe value of the local variable thisIsFalse is not used\n----------\n";
        runner.classLibraries = this.LIBS;
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }
}

