/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class GrammarCoverageTests308
extends AbstractRegressionTest {
    public static Class testClass() {
        return GrammarCoverageTests308.class;
    }

    public static Test suite() {
        return GrammarCoverageTests308.buildMinimalComplianceTestSuite(GrammarCoverageTests308.testClass(), 32);
    }

    public GrammarCoverageTests308(String testName) {
        super(testName);
    }

    public void test000() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X extends @Marker @SingleMember(0) @Normal(Value = 0) Object {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends @Marker @SingleMember(0) @Normal(Value = 0) Object {\n\t                        ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X extends @Marker @SingleMember(0) @Normal(Value = 0) Object {\n\t                                ^^^^^^^^^^^^\nSingleMember cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X extends @Marker @SingleMember(0) @Normal(Value = 0) Object {\n\t                                                 ^^^^^^\nNormal cannot be resolved to a type\n----------\n");
    }

    public void test001() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    @Marker int x;\n    Zork z;\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Marker int x;\n\t^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test002() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    @Marker <T> @Marker int x() { return 10; };\n    Zork z;\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Marker <T> @Marker int x() { return 10; };\n\t^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 2)\n\t@Marker <T> @Marker int x() { return 10; };\n\t            ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n3. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test003() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    @Marker int x() { return 10; };\n    Zork z;\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Marker int x() { return 10; };\n\t^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test004() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    int x(@Marker int p) { return 10; };\n    Zork z;\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint x(@Marker int p) { return 10; };\n\t      ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test005() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    int x(@Marker int ... p) { return 10; };\n    Zork z;\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint x(@Marker int ... p) { return 10; };\n\t      ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test006() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    int x(@Marker int [] @Marker ... p) { return 10; };\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint x(@Marker int [] @Marker ... p) { return 10; };\n\t       ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tint x(@Marker int [] @Marker ... p) { return 10; };\n\t                      ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test007() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    int x() {\n        try {\n        } catch (@Marker NullPointerException | @Marker ArrayIndexOutOfBoundsException e) {\n        }\n        return 10;\n    }\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t} catch (@Marker NullPointerException | @Marker ArrayIndexOutOfBoundsException e) {\n\t          ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t} catch (@Marker NullPointerException | @Marker ArrayIndexOutOfBoundsException e) {\n\t                                         ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test008() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    int x() {\n        @Marker int p;\n        final @Marker int q;\n        @Marker final int r;\n        return 10;\n    }\n    Zork z;\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@Marker int p;\n\t^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 4)\n\tfinal @Marker int q;\n\t      ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n3. ERROR in X.java (at line 5)\n\t@Marker final int r;\n\t^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n4. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test009() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    int x() {\n        try (@Marker Integer p = null; final @Marker Integer q = null; @Marker final Integer r = null) {\n        }\n        return 10;\n    }\n    Zork z;\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (@Marker Integer p = null; final @Marker Integer q = null; @Marker final Integer r = null) {\n\t     ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 3)\n\ttry (@Marker Integer p = null; final @Marker Integer q = null; @Marker final Integer r = null) {\n\t             ^^^^^^^\nThe resource type Integer does not implement java.lang.AutoCloseable\n----------\n3. ERROR in X.java (at line 3)\n\ttry (@Marker Integer p = null; final @Marker Integer q = null; @Marker final Integer r = null) {\n\t                                     ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n4. ERROR in X.java (at line 3)\n\ttry (@Marker Integer p = null; final @Marker Integer q = null; @Marker final Integer r = null) {\n\t                                             ^^^^^^^\nThe resource type Integer does not implement java.lang.AutoCloseable\n----------\n5. ERROR in X.java (at line 3)\n\ttry (@Marker Integer p = null; final @Marker Integer q = null; @Marker final Integer r = null) {\n\t                                                               ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n6. ERROR in X.java (at line 3)\n\ttry (@Marker Integer p = null; final @Marker Integer q = null; @Marker final Integer r = null) {\n\t                                                                             ^^^^^^^\nThe resource type Integer does not implement java.lang.AutoCloseable\n----------\n7. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test010() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    int x() {\n        for (@Marker int i: new int[3]) {}\n        for (final @Marker int i: new int[3]) {}\n        for (@Marker final int i: new int[3]) {}\n        return 10;\n    }\n    Zork z;\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfor (@Marker int i: new int[3]) {}\n\t     ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 4)\n\tfor (final @Marker int i: new int[3]) {}\n\t           ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n3. ERROR in X.java (at line 5)\n\tfor (@Marker final int i: new int[3]) {}\n\t     ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n4. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test011() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public @interface X { \n\tpublic @Marker String value(); \n\t@Marker String value2(); \n\t@Marker public String value3(); \n\tpublic @Marker <T> @Marker String value4(); \n\t@Marker <T> @Marker String value5(); \n\t@Marker public <T> @Marker String value6(); \n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic @Marker String value(); \n\t       ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 3)\n\t@Marker String value2(); \n\t^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n3. ERROR in X.java (at line 4)\n\t@Marker public String value3(); \n\t^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n4. ERROR in X.java (at line 5)\n\tpublic @Marker <T> @Marker String value4(); \n\t       ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n5. ERROR in X.java (at line 5)\n\tpublic @Marker <T> @Marker String value4(); \n\t                   ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n6. ERROR in X.java (at line 5)\n\tpublic @Marker <T> @Marker String value4(); \n\t                                  ^^^^^^^^\nAnnotation attributes cannot be generic\n----------\n7. ERROR in X.java (at line 6)\n\t@Marker <T> @Marker String value5(); \n\t^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n8. ERROR in X.java (at line 6)\n\t@Marker <T> @Marker String value5(); \n\t            ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n9. ERROR in X.java (at line 6)\n\t@Marker <T> @Marker String value5(); \n\t                           ^^^^^^^^\nAnnotation attributes cannot be generic\n----------\n10. ERROR in X.java (at line 7)\n\t@Marker public <T> @Marker String value6(); \n\t^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n11. ERROR in X.java (at line 7)\n\t@Marker public <T> @Marker String value6(); \n\t                   ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n12. ERROR in X.java (at line 7)\n\t@Marker public <T> @Marker String value6(); \n\t                                  ^^^^^^^^\nAnnotation attributes cannot be generic\n----------\n");
    }

    public void test012() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic void value() {\n\t\tObject o = @Marker int.class;\n\t\tObject o2 = @Marker int @Marker[] [] @Marker[].class;\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = @Marker int.class;\n\t           ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 4)\n\tObject o2 = @Marker int @Marker[] [] @Marker[].class;\n\t            ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 4)\n\tObject o2 = @Marker int @Marker[] [] @Marker[].class;\n\t                        ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 4)\n\tObject o2 = @Marker int @Marker[] [] @Marker[].class;\n\t                                     ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test013() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    Object copy(int [] ia);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = @Marker int @Marker []::<String>clone;\n        Zork z;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = @Marker int @Marker []::<String>clone;\n\t       ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\tI i = @Marker int @Marker []::<String>clone;\n\t                   ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. WARNING in X.java (at line 6)\n\tI i = @Marker int @Marker []::<String>clone;\n\t                               ^^^^^^\nUnused type arguments for the non generic method clone() of type Object; it should not be parameterized with arguments <String>\n----------\n4. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test014() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n    public static void main(String [] args) {\n        int i [] = new @Marker int @Marker [4];\n        int j [] = new @Marker int @Marker [] { 10 };\n        Zork z;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint i [] = new @Marker int @Marker [4];\n\t                ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tint i [] = new @Marker int @Marker [4];\n\t                            ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\tint j [] = new @Marker int @Marker [] { 10 };\n\t                ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 4)\n\tint j [] = new @Marker int @Marker [] { 10 };\n\t                            ^^^^^^\nMarker cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test015() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n    public static void main(String [] args) {\n        int i = (@Marker int) 0;\n        int j [] = (@Marker int @Marker []) null;\n        Zork z;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint i = (@Marker int) 0;\n\t          ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tint j [] = (@Marker int @Marker []) null;\n\t             ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\tint j [] = (@Marker int @Marker []) null;\n\t                         ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test016() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n    public static void main(String [] args) {\n        if (args instanceof @Readonly String) {\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (args instanceof @Readonly String) {\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types String[] and String\n----------\n2. ERROR in X.java (at line 3)\n\tif (args instanceof @Readonly String) {\n\t                     ^^^^^^^^\nReadonly cannot be resolved to a type\n----------\n");
    }

    public void test017() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y<@Marker Integer, String> {}\nclass Y<T, V> {\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Y<@Marker Integer, String> {}\n\t                          ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test018() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y<@Marker Integer> {}\nclass Y<T> {\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Y<@Marker Integer> {}\n\t                          ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test019() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Object & Comparable<? super @Marker String>> {}\nclass Y<T> {\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T extends Object & Comparable<? super @Marker String>> {}\n\t                                                      ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test020() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X<A extends X<X<X<@Marker String>>>> {}\nclass Y<T> {\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<A extends X<X<X<@Marker String>>>> {}\n\t                           ^\nBound mismatch: The type X<X<String>> is not a valid substitute for the bounded parameter <A extends X<X<X<String>>>> of the type X<A>\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X<A extends X<X<X<@Marker String>>>> {}\n\t                             ^\nBound mismatch: The type X<String> is not a valid substitute for the bounded parameter <A extends X<X<X<String>>>> of the type X<A>\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X<A extends X<X<X<@Marker String>>>> {}\n\t                               ^^^^^^^^^^^^^^\nBound mismatch: The type String is not a valid substitute for the bounded parameter <A extends X<X<X<String>>>> of the type X<A>\n----------\n4. ERROR in X.java (at line 1)\n\tpublic class X<A extends X<X<X<@Marker String>>>> {}\n\t                                ^^^^^^\nMarker cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test021() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Map<@Marker ? super @Marker Object, @Marker ? extends @Marker String> m){}\n   void goo(Map<@Marker ? extends @Marker Object, @Marker ? super @Marker String> m){}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Map<@Marker ? super @Marker Object, @Marker ? extends @Marker String> m){}\n\t         ^^^\nMap cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(Map<@Marker ? super @Marker Object, @Marker ? extends @Marker String> m){}\n\t              ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tvoid foo(Map<@Marker ? super @Marker Object, @Marker ? extends @Marker String> m){}\n\t                              ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 2)\n\tvoid foo(Map<@Marker ? super @Marker Object, @Marker ? extends @Marker String> m){}\n\t                                              ^^^^^^\nMarker cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 2)\n\tvoid foo(Map<@Marker ? super @Marker Object, @Marker ? extends @Marker String> m){}\n\t                                                                ^^^^^^\nMarker cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 3)\n\tvoid goo(Map<@Marker ? extends @Marker Object, @Marker ? super @Marker String> m){}\n\t         ^^^\nMap cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 3)\n\tvoid goo(Map<@Marker ? extends @Marker Object, @Marker ? super @Marker String> m){}\n\t              ^^^^^^\nMarker cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 3)\n\tvoid goo(Map<@Marker ? extends @Marker Object, @Marker ? super @Marker String> m){}\n\t                                ^^^^^^\nMarker cannot be resolved to a type\n----------\n9. ERROR in X.java (at line 3)\n\tvoid goo(Map<@Marker ? extends @Marker Object, @Marker ? super @Marker String> m){}\n\t                                                ^^^^^^\nMarker cannot be resolved to a type\n----------\n10. ERROR in X.java (at line 3)\n\tvoid goo(Map<@Marker ? extends @Marker Object, @Marker ? super @Marker String> m){}\n\t                                                                ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test022() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X <@Marker T extends @Marker Y<@Marker ?>, @Marker Q extends @Marker Integer> {\n}\nclass Y<T> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <@Marker T extends @Marker Y<@Marker ?>, @Marker Q extends @Marker Integer> {\n\t                 ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <@Marker T extends @Marker Y<@Marker ?>, @Marker Q extends @Marker Integer> {\n\t                                   ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X <@Marker T extends @Marker Y<@Marker ?>, @Marker Q extends @Marker Integer> {\n\t                                             ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 1)\n\tpublic class X <@Marker T extends @Marker Y<@Marker ?>, @Marker Q extends @Marker Integer> {\n\t                                                         ^^^^^^\nMarker cannot be resolved to a type\n----------\n5. WARNING in X.java (at line 1)\n\tpublic class X <@Marker T extends @Marker Y<@Marker ?>, @Marker Q extends @Marker Integer> {\n\t                                                                          ^^^^^^^^^^^^^^^\nThe type parameter Q should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n6. ERROR in X.java (at line 1)\n\tpublic class X <@Marker T extends @Marker Y<@Marker ?>, @Marker Q extends @Marker Integer> {\n\t                                                                           ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test023() throws Exception {
        this.runNegativeTest(new String[]{"I.java", "public interface I<U extends J<? extends I<U>>> {\n}\ninterface J<T extends I<? extends J<T>>> {\n}\nclass CI<U extends CJ<T, U> & @Marker J<@Marker T>,\n\t\t\tT extends CI<U, T> & @Marker I<U>>\n\timplements I<U> {\n}\nclass CJ<T extends CI<U, T> & @Marker I<@Marker U>,\n\t\t\tU extends CJ<T, U> & J<T>>\n\timplements J<T> {\n}\n"}, "----------\n1. ERROR in I.java (at line 5)\n\tclass CI<U extends CJ<T, U> & @Marker J<@Marker T>,\n\t                               ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in I.java (at line 5)\n\tclass CI<U extends CJ<T, U> & @Marker J<@Marker T>,\n\t                                         ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in I.java (at line 6)\n\tT extends CI<U, T> & @Marker I<U>>\n\t                      ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in I.java (at line 9)\n\tclass CJ<T extends CI<U, T> & @Marker I<@Marker U>,\n\t                               ^^^^^^\nMarker cannot be resolved to a type\n----------\n5. ERROR in I.java (at line 9)\n\tclass CJ<T extends CI<U, T> & @Marker I<@Marker U>,\n\t                                         ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test024() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n  class Y {\n    E e;\n    E getOtherElement(Object other) {\n      if (!(other instanceof @Marker X<?>.Y)) {};\n      return null;\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tif (!(other instanceof @Marker X<?>.Y)) {};\n\t                        ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test025() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X<P, C> {\n  public X() {\n    if (!(this instanceof @Marker X)) {}\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (!(this instanceof @Marker X)) {}\n\t                       ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test026() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    void foo(Y<String>.Z z, int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y<String>.@Marker Z::foo;\n        i.foo(new Y<String>().new Z(), 10); \n        Zork z;\n    }\n}\nclass Y<T> {\n    class Z {\n        void foo(int x) {\n\t    System.out.println(x);\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = Y<String>.@Marker Z::foo;\n\t                 ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test027() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n    public static void main(String [] args) {\n        X [] x = new @Marker X @Marker [5];\n        X [] x2 = new @Marker X @Marker [] { null };\n        Zork z;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX [] x = new @Marker X @Marker [5];\n\t              ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tX [] x = new @Marker X @Marker [5];\n\t                        ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\tX [] x2 = new @Marker X @Marker [] { null };\n\t               ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 4)\n\tX [] x2 = new @Marker X @Marker [] { null };\n\t                         ^^^^^^\nMarker cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test028() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n    public static void main(String [] args) {\n        java.util.Map.Entry [] e = (java.util.Map<String, String>.@Marker Entry []) null;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tjava.util.Map.Entry [] e = (java.util.Map<String, String>.@Marker Entry []) null;\n\t^^^^^^^^^^^^^^^^^^^\nMap.Entry is a raw type. References to generic type Map.Entry<K,V> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tjava.util.Map.Entry [] e = (java.util.Map<String, String>.@Marker Entry []) null;\n\t                            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe member type Map.Entry<K,V> cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type Map<String,String>\n----------\n3. ERROR in X.java (at line 3)\n\tjava.util.Map.Entry [] e = (java.util.Map<String, String>.@Marker Entry []) null;\n\t                                                           ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test029() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\npublic class X<T extends Comparable<T> & Serializable> {\n\tvoid foo(List<? extends @Marker Comparable<T>> p) {} \n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tvoid foo(List<? extends @Marker Comparable<T>> p) {} \n\t                         ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test030() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "class Base {\n}\nclass Foo<U extends Base, V extends Bar<U, @Marker Foo<U, V>>> {\n}\nclass Bar<E extends Base, F extends Foo<E, @Marker Bar<E, F>>> {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tclass Foo<U extends Base, V extends Bar<U, @Marker Foo<U, V>>> {\n\t                                           ^^^^^^^^^^^\nBound mismatch: The type Foo<U,V> is not a valid substitute for the bounded parameter <F extends Foo<E,Bar<E,F>>> of the type Bar<E,F>\n----------\n2. ERROR in X.java (at line 3)\n\tclass Foo<U extends Base, V extends Bar<U, @Marker Foo<U, V>>> {\n\t                                            ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tclass Bar<E extends Base, F extends Foo<E, @Marker Bar<E, F>>> {\n\t                                           ^^^^^^^^^^^\nBound mismatch: The type Bar<E,F> is not a valid substitute for the bounded parameter <V extends Bar<U,Foo<U,V>>> of the type Foo<U,V>\n----------\n4. ERROR in X.java (at line 5)\n\tclass Bar<E extends Base, F extends Foo<E, @Marker Bar<E, F>>> {\n\t                                            ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test031() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X extends @Marker Object {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends @Marker Object {\n\t                        ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test032() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    X x = new @Marker X();\n    X y = new <String> @Marker X();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tX x = new @Marker X();\n\t           ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 3)\n\tX y = new <String> @Marker X();\n\t           ^^^^^^\nUnused type arguments for the non generic constructor X() of type X; it should not be parameterized with arguments <String>\n----------\n3. ERROR in X.java (at line 3)\n\tX y = new <String> @Marker X();\n\t                    ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test033() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    class Y {\n    }\n    Y y1 = new @Marker X().new @Marker Y();\n    Y y2 = new @Marker X().new <String> @Marker Y();\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tY y1 = new @Marker X().new @Marker Y();\n\t            ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tY y1 = new @Marker X().new @Marker Y();\n\t                            ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tY y2 = new @Marker X().new <String> @Marker Y();\n\t            ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. WARNING in X.java (at line 5)\n\tY y2 = new @Marker X().new <String> @Marker Y();\n\t                            ^^^^^^\nUnused type arguments for the non generic constructor X.Y() of type X.Y; it should not be parameterized with arguments <String>\n----------\n5. ERROR in X.java (at line 5)\n\tY y2 = new @Marker X().new <String> @Marker Y();\n\t                                     ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test034() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    X x;\n    class Y {\n    }\n    Y y1 = @Marker x.new @Marker Y();\n    Y y2 = @Marker x.new <String> @Marker Y();\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tY y1 = @Marker x.new @Marker Y();\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 5)\n\tY y1 = @Marker x.new @Marker Y();\n\t                      ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 6)\n\tY y2 = @Marker x.new <String> @Marker Y();\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. WARNING in X.java (at line 6)\n\tY y2 = @Marker x.new <String> @Marker Y();\n\t                      ^^^^^^\nUnused type arguments for the non generic constructor X.Y() of type X.Y; it should not be parameterized with arguments <String>\n----------\n5. ERROR in X.java (at line 6)\n\tY y2 = @Marker x.new <String> @Marker Y();\n\t                               ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test035() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    void foo() throws @Marker NullPointerException, @Marker ArrayIndexOutOfBoundsException {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo() throws @Marker NullPointerException, @Marker ArrayIndexOutOfBoundsException {}\n\t                   ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo() throws @Marker NullPointerException, @Marker ArrayIndexOutOfBoundsException {}\n\t                                                 ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test036() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\ninterface J {}\ninterface K extends @Marker I, @Marker J {}\ninterface L {}\npublic class X implements @Marker K, @Marker L {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tinterface K extends @Marker I, @Marker J {}\n\t                     ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tinterface K extends @Marker I, @Marker J {}\n\t                                ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tpublic class X implements @Marker K, @Marker L {\n\t                           ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 5)\n\tpublic class X implements @Marker K, @Marker L {\n\t                                      ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test037() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    void foo(int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = @Marker Y. @Marker Z @Marker [] [] @Marker [] ::foo;\n        i.foo(10); \n        Zork z;\n    }\n}\nclass Y {\n    static class Z {\n        public static void foo(int x) {\n\t    System.out.println(x);\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = @Marker Y. @Marker Z @Marker [] [] @Marker [] ::foo;\n\t      ^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n2. ERROR in X.java (at line 6)\n\tI i = @Marker Y. @Marker Z @Marker [] [] @Marker [] ::foo;\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe type Y.Z[][][] does not define foo(int) that is applicable here\n----------\n3. ERROR in X.java (at line 6)\n\tI i = @Marker Y. @Marker Z @Marker [] [] @Marker [] ::foo;\n\t       ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 6)\n\tI i = @Marker Y. @Marker Z @Marker [] [] @Marker [] ::foo;\n\t                  ^^^^^^\nMarker cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 6)\n\tI i = @Marker Y. @Marker Z @Marker [] [] @Marker [] ::foo;\n\t                            ^^^^^^\nMarker cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 6)\n\tI i = @Marker Y. @Marker Z @Marker [] [] @Marker [] ::foo;\n\t                                          ^^^^^^\nMarker cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test038() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    Y foo(int x);\n}\npublic class X  {\n    class Z extends Y {\n        public Z(int x) {\n            super(x);\n            System.out.println();\n        }\n    }\n    public static void main(String [] args) {\n        i = @Marker W<@Marker Integer>::<@Marker String> new;\n    }\n}\nclass W<T> extends Y {\n    public W(T x) {\n        super(0);\n        System.out.println(x);\n    }\n}\nclass Y {\n    public Y(int x) {\n        System.out.println(x);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\ti = @Marker W<@Marker Integer>::<@Marker String> new;\n\t^\ni cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 12)\n\ti = @Marker W<@Marker Integer>::<@Marker String> new;\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n3. ERROR in X.java (at line 12)\n\ti = @Marker W<@Marker Integer>::<@Marker String> new;\n\t     ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 12)\n\ti = @Marker W<@Marker Integer>::<@Marker String> new;\n\t               ^^^^^^\nMarker cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 12)\n\ti = @Marker W<@Marker Integer>::<@Marker String> new;\n\t                                  ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test039() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n    Object o = (@Marker X) null;\n    Object p = (@Marker X @Marker []) null;\n    Object q = (@Marker java. @Marker util. @Marker List<@Marker String> []) null;\n    Object r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tObject o = (@Marker X) null;\n\t             ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tObject p = (@Marker X @Marker []) null;\n\t             ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 3)\n\tObject p = (@Marker X @Marker []) null;\n\t                       ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 4)\n\tObject q = (@Marker java. @Marker util. @Marker List<@Marker String> []) null;\n\t            ^^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n5. ERROR in X.java (at line 4)\n\tObject q = (@Marker java. @Marker util. @Marker List<@Marker String> []) null;\n\t             ^^^^^^\nMarker cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 4)\n\tObject q = (@Marker java. @Marker util. @Marker List<@Marker String> []) null;\n\t                          ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n7. ERROR in X.java (at line 4)\n\tObject q = (@Marker java. @Marker util. @Marker List<@Marker String> []) null;\n\t                                         ^^^^^^\nMarker cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 4)\n\tObject q = (@Marker java. @Marker util. @Marker List<@Marker String> []) null;\n\t                                                      ^^^^^^\nMarker cannot be resolved to a type\n----------\n9. ERROR in X.java (at line 5)\n\tObject r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n\t            ^^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n10. ERROR in X.java (at line 5)\n\tObject r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe member type Map.Entry<K,V> cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type Map<String,String>\n----------\n11. ERROR in X.java (at line 5)\n\tObject r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n\t             ^^^^^^\nMarker cannot be resolved to a type\n----------\n12. ERROR in X.java (at line 5)\n\tObject r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n\t                          ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n13. ERROR in X.java (at line 5)\n\tObject r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n\t                                       ^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n14. ERROR in X.java (at line 5)\n\tObject r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n\t                                        ^^^^^^\nMarker cannot be resolved to a type\n----------\n15. ERROR in X.java (at line 5)\n\tObject r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n\t                                                    ^^^^^^\nMarker cannot be resolved to a type\n----------\n16. ERROR in X.java (at line 5)\n\tObject r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n\t                                                                    ^^^^^^\nMarker cannot be resolved to a type\n----------\n17. ERROR in X.java (at line 5)\n\tObject r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n\t                                                                                    ^^^^^^\nMarker cannot be resolved to a type\n----------\n18. ERROR in X.java (at line 5)\n\tObject r = (@Marker java. @Marker util.@Marker Map<@Marker String, @Marker String>.@Marker Entry @Marker []) null;\n\t                                                                                                  ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }
}

