/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class InitializationTests
extends AbstractRegressionTest {
    public InitializationTests(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = InitializationTests.buildAllCompliancesTestSuite(InitializationTests.testClass());
        return suite;
    }

    public void test318020a() {
        this.runConformTest(new String[]{"X.java", "class X {\n\tpublic void foo() throws Exception{\n\t\tString temp;\n\t\tObject temp2= new String(\"test\");\n\t\tif(temp2 instanceof String) {\n\t\t\ttemp = (String) temp2;\n\t\t} else {\n\t\t\tif (true) {\n\t\t\t\tthrow new Exception(\"not a string\");\n\t\t\t}\n\t\t}\n\t\ttemp.trim();\n\t}\n}"}, "");
    }

    public void test318020b() {
        this.runConformTest(new String[]{"X.java", "class X {\n\t{\n\t\tif (true)\n\t\t\tthrow new NullPointerException();\n\t}\n\tpublic X(){}\n}"}, "");
    }

    public void test318020c() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   public int a;\tpublic X (int a) {\n\t\tthis.a = a;\n\t}\n\tpublic int returnA () {\n\t\treturn a;\n\t}\n\tpublic void foo() {\n\t\tfinal X abc;\t\tif (true || (abc = new X(2)).returnA() == 2) {\n\t\t\tSystem.out.println(\"Hello\");\n       } else { \n\t\t\tabc = new X(1);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tabc = new X(1);\n\t^^^\nThe final local variable abc may already have been assigned\n----------\n", null, false, options);
    }

    public void test318020d() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   private int a;\tpublic X (int a) {\n\t\tthis.a = a;\n\t}\n\tpublic int returnA () {\n\t\treturn a;\n\t}\n\tpublic static boolean comparison (X x, int val) {\n\t\treturn (x.returnA() == val);\n\t}\n\tpublic void foo() {\n\t\tfinal X abc;\n\t\tboolean comp = X.comparison((abc = new X(2)), (abc = new X(1)).returnA());\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tboolean comp = X.comparison((abc = new X(2)), (abc = new X(1)).returnA());\n\t                                               ^^^\nThe final local variable abc may already have been assigned\n----------\n", null, false, options);
    }

    public void test318020e() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   private int a;\tpublic X (int a) {\n\t\tthis.a = a;\n\t}\n\tpublic int returnA () {\n\t\treturn a;\n\t}\n\tpublic void foo() {\n\t\tfinal X abc;\n\t\tboolean comp = ((abc = new X(2)).returnA() == 1 || (abc = new X(1)).returnA() == 1);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tboolean comp = ((abc = new X(2)).returnA() == 1 || (abc = new X(1)).returnA() == 1);\n\t                                                    ^^^\nThe final local variable abc may already have been assigned\n----------\n", null, false, options);
    }

    public void test318020f() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   private int a;\tpublic X (int a) {\n\t\tthis.a = a;\n\t}\n\tpublic int returnA () {\n\t\treturn a;\n\t}\n\tpublic void foo() {\n\t\tfinal X abc;\n\t\tint val;\n\t\tif (true || (abc = new X(1)).returnA() == 1)\n\t\t\tval = (abc = new X(2)).returnA();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tval = (abc = new X(2)).returnA();\n\t       ^^^\nThe final local variable abc may already have been assigned\n----------\n", null, false, options);
    }

    public void test318020g() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   private int a;\tpublic X (int a) {\n\t\tthis.a = a;\n\t}\n\tpublic int returnA () {\n\t\treturn a;\n\t}\n\tpublic void foo() {\n\t\tfinal X abc;\n\t\tint val;\n\t\tif (true) {\n\t\t\tval = 0;\n\t\t} else {\n\t\t\tval = (abc = new X(1)).returnA();\n\t\t}\n\t\tabc = new X(2);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 16)\n\tabc = new X(2);\n\t^^^\nThe final local variable abc may already have been assigned\n----------\n", null, false, options);
    }

    public void test318020h() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tfinal static X[] abc;\n\tstatic {\n\t\tfor (Object[] j = new Object[1]; !(((abc = new X[10]).length) == 10); ){\n\t\t\tbreak;\n\t\t}\n\t}\n\t//Zork z;\n}\n"}, "");
    }

    public void test318020i() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   private int a;\tclass Inner {\n\t\tpublic int aInner;\n\t\tpublic Inner(int a){\n\t\t\tthis.aInner = a;\n\t\t}\n\t}\n\tpublic X (int a) {\n\t\tthis.a = a;\n\t}\n\tpublic int returnA () {\n\t\treturn a;\n\t}\n\tpublic void foo() {\n\t\tint val;\t\tfinal int int1;\n\t\tfinal  int int2;\n\t\tval = new X(int1 = 1).new Inner(int2 = int1).aInner;\n\t\tSystem.out.println(int1 + int2);\n\t}\n}\n"}, "");
    }

    public void test318020j() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   private int a;\tpublic X (int a) {\n\t\tthis.a = a;\n\t}\n\tpublic int returnA () {\n\t\treturn a;\n\t}\n\tpublic void foo() {\n\t\tfinal int abc;\n\t\tabc = new X(abc = 2).returnA();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tabc = new X(abc = 2).returnA();\n\t^^^\nThe final local variable abc may already have been assigned\n----------\n", null, false, options);
    }

    public void test318020k() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   private int a;\n\tfinal int x;\n\t{\n\t\tx = new X(x = 2).returnA();\t}\n\tpublic X (int a) {\n\t\tthis.a = a;\n\t}\n\tpublic int returnA () {\n\t\treturn a;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tx = new X(x = 2).returnA();\t}\n\t^\nThe final field x may already have been assigned\n----------\n", null, false, options);
    }

    public void test325567() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tbar(3);\n\t}\n\tpublic static void bar(int i) {\n\t\tfinal String before;\n\t\ttry {\n\t\t\tbefore = foo();\n\t\t} catch (IOException e) {\n\t\t\t// ignore\n\t\t}\n\t\tB b = new B(new I() {\n\t\t\tpublic String bar() {\n\t\t\t\treturn new String(before);\n\t\t\t}\n\t\t});\n\t\ttry {\n\t\t\tb.i.bar();\n\t\t} catch(Exception e) {\n\t\t\t// ignore\n\t\t}\n\t}\n\n\tprivate static String foo() throws IOException {\n\t\treturn null;\n\t}\n\t\n\tstatic class B {\n\t\tI i;\n\t\tB(I i) {\n\t\t\tthis.i = i;\n\t\t}\n\t}\n\tstatic interface I {\n\t\tString bar();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 16)\n\treturn new String(before);\n\t                  ^^^^^^\nThe local variable before may not have been initialized\n----------\n", null, false, options);
    }

    public void testBug324178b() {
        this.runConformTest(new String[]{"Bug324178.java", "public class Bug324178 {\n\t boolean foo(boolean b) {\n        boolean v;\n        if (b ? false : (true && (v = true)))\n            return v;\n        return false;\n    }\n    public static void main(String[] args) {\n        System.out.print(new Bug324178().foo(false));\n    }\n}\n"}, "true");
    }

    public void testBug324178c() {
        this.runConformTest(new String[]{"Bug324178.java", "public class Bug324178 {\n\t boolean foo() {\n        boolean r=false;        boolean v;\n        if ((true && (v = true)) ? true : true && (v = false)) r = v;\n        return r;\n    }\n    public static void main(String[] args) {\n        System.out.print(new Bug324178().foo());\n    }\n}\n"}, "true");
    }

    public void testBug324178d() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runNegativeTest(new String[]{"Bug324178.java", "public class Bug324178 {\n\t boolean foo(boolean b1) {\n  \t\t Boolean b2;\n        if (b1 ? (b2 = Boolean.TRUE) : null)\n          return b2;\n        return false;\n    }\n    public static void main(String[] args) {\n        System.out.print(new Bug324178().foo(true));\n    }\n}\n"}, "----------\n1. ERROR in Bug324178.java (at line 5)\n\treturn b2;\n\t       ^^\nThe local variable b2 may not have been initialized\n----------\n");
    }

    public void testBug383690() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t final Object o; // report here!\n\t final static Object oStatic; // report here!\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tfinal Object o; // report here!\n\t             ^\nThe blank final field o may not have been initialized\n----------\n2. ERROR in X.java (at line 3)\n\tfinal static Object oStatic; // report here!\n\t                    ^^^^^^^\nThe blank final field oStatic may not have been initialized\n----------\n");
    }

    public static Class testClass() {
        return InitializationTests.class;
    }
}

