/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.junit.Assert;

public class JEP286Test
extends AbstractRegressionTest {
    private static final Map<String, String> simpleTypeNames = new HashMap<String, String>();

    static {
        simpleTypeNames.put("String", "java.lang.String");
        simpleTypeNames.put("Object", "java.lang.Object");
        simpleTypeNames.put("Bar", "X.Bar");
        simpleTypeNames.put("AnonymousObjectSubclass", "new java.lang.Object(){}");
        simpleTypeNames.put("AnonymousRunnableSubclass", "new java.lang.Runnable(){}");
        simpleTypeNames.put("CollectionOfExtString", "Collection<? extends java.lang.String>");
        simpleTypeNames.put("CollectionOfSuperString", "Collection<? super java.lang.String>");
        simpleTypeNames.put("CollectionAny", "Collection<?>");
        simpleTypeNames.put("ComparableAny", "Comparable<?>");
        simpleTypeNames.put("CollectionExt_ComparableAny", "Collection<? extends Comparable<?>>");
        simpleTypeNames.put("CollectionSuperComparableAny", "Collection<? super Comparable<?>>");
        simpleTypeNames.put("IntLongFloat", "java.lang.Number & Comparable<?>");
        simpleTypeNames.put("ListTestAndSerializable", "List<? extends Z & java.io.Serializable>");
        simpleTypeNames.put("TestAndSerializable", "Z & java.io.Serializable");
    }

    public static Class testClass() {
        return JEP286Test.class;
    }

    @Override
    public void initialize(CompilerTestSetup setUp) {
        super.initialize(setUp);
    }

    public static Test suite() {
        return JEP286Test.buildMinimalComplianceTestSuite(JEP286Test.testClass(), 128);
    }

    public JEP286Test(String testName) {
        super(testName);
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "10");
        options.put("org.eclipse.jdt.core.compiler.source", "10");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "10");
        return options;
    }

    static void assertInferredType(LocalDeclaration varDecl) {
        String varName = new String(varDecl.name);
        int underscoreIndex = varName.indexOf(95);
        Assert.assertNotEquals((long)-1L, (long)underscoreIndex);
        String typeNamePart = varName.substring(underscoreIndex + 1);
        typeNamePart = typeNamePart.replaceAll("ARRAY", "[]");
        String expectedTypeName = simpleTypeNames.getOrDefault(typeNamePart, typeNamePart);
        String actualTypeName = varDecl.binding.type.debugName();
        Assert.assertEquals((String)("Type of variable " + varName), (Object)expectedTypeName, (Object)actualTypeName);
    }

    public void test0001_local_variable_inference() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        var x = \"SUCCESS\";\n        System.out.println(x);\n    }\n}\n"}, "SUCCESS");
    }

    public void test0002_inferred_for() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n\t\tint sum = 0;\n\t\tfor(var n = 1; n <= 2; ++n) {\n\t\t\tsum += n;\n       }\n\t\tSystem.out.println(\"SUCCESS \" + sum);\n    }\n}\n"}, "SUCCESS 3");
    }

    public void test0003_inferred_enhanced_for() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n\t\tint sum = 0;\n\t\tfor(var n : java.util.List.of(1, 2)) {\n\t\t\tsum += n;\n       }\n\t\tSystem.out.println(\"SUCCESS \" + sum);\n    }\n}\n"}, "SUCCESS 3");
    }

    public void test0004_try_with_resources() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (StringWriter w = new StringWriter();){
            ((Writer)w).write("SUCCESS!\n");
            System.out.println(((Object)w).toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) throws Exception {\n\t\ttry(var w = new java.io.StringWriter()) {\n\t\t\tw.write(\"SUCCESS\\n\");\t\t\tSystem.out.println(w.toString());\n       }\n    }\n}\n"}, "SUCCESS");
    }

    public void test0005_no_initializer() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] argv) {\n\t\tvar a;\n\t\tfor(var b;;);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvar a;\n\t    ^\nCannot use 'var' on variable without initializer\n----------\n2. ERROR in X.java (at line 4)\n\tfor(var b;;);\n\t        ^\nCannot use 'var' on variable without initializer\n----------\n");
    }

    public void test0006_multiple_declarators() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] argv) {\n\t\tvar a = 1, b = 2;\n\t\tfor(var c = 1, d = 20; c<d; c++);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvar a = 1, b = 2;\n\t           ^\n'var' is not allowed in a compound declaration\n----------\n2. ERROR in X.java (at line 4)\n\tfor(var c = 1, d = 20; c<d; c++);\n\t               ^\n'var' is not allowed in a compound declaration\n----------\n");
    }

    public void test0007_var_in_wrong_place() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate var someField = 0;\n\tpublic var method() {\n\t\treturn null;\n\t}\n\tpublic void main(var arg) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate var someField = 0;\n\t        ^^^\n'var' is not allowed here\n----------\n2. ERROR in X.java (at line 3)\n\tpublic var method() {\n\t       ^^^\n'var' is not allowed here\n----------\n3. ERROR in X.java (at line 6)\n\tpublic void main(var arg) {\n\t                 ^^^\n'var' is not allowed here\n----------\n");
    }

    public void test0008_null_initializer() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void main(String[] arg) {\n\t\tvar notMuch = null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvar notMuch = null;\n\t    ^^^^^^^\nCannot infer type for local variable initialized to 'null'\n----------\n");
    }

    public void test0008_void_initializer() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo() {\n\t}\n\n\tpublic void baz() {\n\t\tvar nothingHere = foo();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tvar nothingHere = foo();\n\t    ^^^^^^^^^^^\nVariable initializer is 'void' -- cannot infer variable type\n----------\n");
    }

    public void test0009_var_as_type_name() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic enum var { V, A, R };\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic enum var { V, A, R };\n\t            ^^^\n'var' is not a valid type name\n----------\n");
    }

    public void test0010_array_initializer() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void main(String [] args) {\n\t\tvar myArray = { 1, 2, 3 };\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvar myArray = { 1, 2, 3 };\n\t    ^^^^^^^\nArray initializer needs an explicit target-type\n----------\n");
    }

    public void test0011_array_type() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void main(String [] args) {\n\t\tvar myArray[] = new int[42];\n\t\tvar[] moreArray = new int[1337];\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvar myArray[] = new int[42];\n\t    ^^^^^^^\n'var' is not allowed as an element type of an array\n----------\n2. ERROR in X.java (at line 4)\n\tvar[] moreArray = new int[1337];\n\t      ^^^^^^^^^\n'var' is not allowed as an element type of an array\n----------\n");
    }

    public void test0012_self_reference() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void main(String [] args) {\n\t\tvar a = 42 + a;\n\t\tvar b = ((java.util.concurrent.Callable<Integer>)(() -> true ? 1 : b)).call();\n       var c = new java.util.concurrent.Callable<Integer>() {\n           public Integer call() {\n               int c = 42; return c;\n           }\n       }.call();       var d = new java.util.concurrent.Callable<Integer>() {\n           int d = 42;\n           public Integer call() {\n               return d;\n           }\n       }.call();\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvar a = 42 + a;\n\t    ^\nDeclaration using 'var' may not contain references to itself\n----------\n2. ERROR in X.java (at line 4)\n\tvar b = ((java.util.concurrent.Callable<Integer>)(() -> true ? 1 : b)).call();\n\t    ^\nDeclaration using 'var' may not contain references to itself\n----------\n3. WARNING in X.java (at line 7)\n\tint c = 42; return c;\n\t    ^\nThe local variable c is hiding another local variable defined in an enclosing scope\n----------\n3. WARNING in X.java (at line 10)\n\tint d = 42;\n\t    ^\nThe field new Callable<Integer>(){}.d is hiding another local variable defined in an enclosing scope\n----------\n");
    }

    public void test0013_lambda() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void main(String [] args) {\n\t\tvar a = (int i) -> 42;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvar a = (int i) -> 42;\n\t    ^\nLambda expression needs an explicit target-type\n----------\n");
    }

    public void test0014_method_reference() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void main(String [] args) {\n\t\tvar a = X::main;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvar a = X::main;\n\t    ^\nMethod reference needs an explicit target-type\n----------\n");
    }

    public void test0015_complain_over_first_poly_encountered() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void main(String [] args) {\n\t\tvar a = args.length > 1 ? X::main : (int i) -> 42;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvar a = args.length > 1 ? X::main : (int i) -> 42;\n\t    ^\nMethod reference needs an explicit target-type\n----------\n");
    }

    public void test0016_dont_capture_deep_poly_expressions() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) throws Exception {\n\t\tvar z = ((java.util.concurrent.Callable<String>)(() -> \"SUCCESS\"));\n\t\tvar x = args.length > 1 ? \"FAILURE\" : z.call();\n\t\tSystem.out.println(x);\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0017_simple_variable_types() throws Exception {
        InferredTypeVerifier typeVerifier = new InferredTypeVerifier();
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n    void test() {\n        var i_String = \"\";\n        for (var i2_String = \"\" ; ; ) { break; }\n        for (var i2_String : iterableOfString()) { break; }\n        for (var i2_String : arrayOfString()) { break; }\n        try (var i2_Bar = new Bar()) { } finally { }\n        try (var i2_Bar = new Bar(); var i3_Bar = new Bar()) { } finally { }\n    }\n\n    Iterable<String> iterableOfString() { return null; }\n    String[] arrayOfString() { return null; }\n\n    static class Bar implements AutoCloseable {\n        @Override\n        public void close() { }\n    }\n}\n\n"}, typeVerifier);
        Assert.assertEquals((long)7L, (long)typeVerifier.localsChecked);
    }

    public void test0018_primitive_variable_types() throws Exception {
        InferredTypeVerifier typeVerifier = new InferredTypeVerifier();
        this.runConformTest(new String[]{"Y.java", "class Y {\n    boolean[] booleanArray = { true };\n    byte[] byteArray = { 1 };\n    char[] charArray = { 'c' };\n    short[] shortArray = { 42 };\n    int[] intArray = { 42 };\n    long[] longArray = { 42L };\n    float[] floatArray = { 0.1f };\n    double[] doubleArray = { 0.2d };\n\n    void testBuiltins() {\n        var z_boolean = false;\n        var b_byte = (byte)0xff;\n        var c_char = 'c';\n        var s_short = (short)42;\n        var i_int = 42;\n        var l_long = 42L;\n        var f_float = 0.25f;\n        var d_double = 0.35d;\n    }\n\n    void testBuiltinsForEach() {\n        for (var z_boolean : booleanArray) { System.out.print(\".\"); }\n        for (var b_byte : byteArray) { System.out.print(\".\"); }\n        for (var c_char : charArray) { System.out.print(\".\"); }\n        for (var s_short : shortArray) { System.out.print(\".\"); }\n        for (var i_int : intArray) { System.out.print(\".\"); }\n        for (var l_long : longArray) { System.out.print(\".\"); }\n        for (var f_float : floatArray) { System.out.print(\".\"); }\n        for (var d_double : doubleArray) { System.out.print(\".\"); }\n    }\n    void testBuiltinsArray() {\n        var z_booleanARRAY = booleanArray;\n        var b_byteARRAY = byteArray;\n        var c_charARRAY = charArray;\n        var s_shortARRAY = shortArray;\n        var i_intARRAY = intArray;\n        var l_longARRAY = longArray;\n        var f_floatARRAY = floatArray;\n        var d_doubleARRAY = doubleArray;\n    }\n\n}\n"}, typeVerifier);
        Assert.assertEquals((long)24L, (long)typeVerifier.localsChecked);
    }

    public void test0018_project_variable_types() throws Exception {
        InferredTypeVerifier typeVerifier = new InferredTypeVerifier();
        this.runConformTest(new String[]{"Z.java", "import java.util.Collection;\nimport java.util.List;\nimport java.io.Serializable;\n\nclass Z {\n\n    void testExtends() {\n        var l1_CollectionOfExtString = extendsString();\n        for (var l2_CollectionOfExtString = extendsString() ; ; ) { break; }\n        for (var l3_CollectionOfExtString : extendsStringArr()) { break; }\n        for (var l4_CollectionOfExtString : extendsCollectionIterable()) { break; }\n        for (var l5_String : extendsString()) { break; }\n    }\n\n    void testExtendsFbound() { \n        var l1_CollectionExt_ComparableAny = extendsTBound();\n        for (var l2_CollectionExt_ComparableAny = extendsTBound() ; ; ) { break; }\n        for (var l3_CollectionExt_ComparableAny : extendsTBoundArray()) { break; }\n        for (var l3_CollectionExt_ComparableAny : extendsTBoundIter()) { break; }\n        for (var l4_ComparableAny : extendsTBound()) { break; }\n    }\n\n    void testSuperTBound() {\n        var s_CollectionAny = superTBound();\n        for (var s2_CollectionAny = superTBound() ; ; ) { break; }\n        for (var s2_CollectionAny : superTBoundArray()) { break; }\n        for (var s2_CollectionAny : superTBoundIter()) { break; }\n        for (var s2_Object : superTBound()) { break; }\n    }\n\n    void testCollectSuper() {\n        var s_CollectionOfSuperString = superString();\n        for (var s2_CollectionOfSuperString = superString() ; ; ) { break; }\n        for (var s2_CollectionOfSuperString : superStringArray()) { break; }\n        for (var s2_CollectionOfSuperString : superCollectionIterable()) { break; }\n        for (var s2_Object : superString()) { break; }\n    }\n\n    void testUnbound() {\n        var s_CollectionAny = unboundedString();\n        for (var s2_CollectionAny = unboundedString() ; ; ) { break; }\n        for (var s2_CollectionAny : unboundedStringArray()) { break; }\n        for (var s2_CollectionAny : unboundedCollectionIterable()) { break; }\n        for (var s2_Object : unboundedString()) { break; }\n    }\n\n    void testTypeOfAnAnonymousClass() {\n        var o_AnonymousObjectSubclass = new Object() { };\n        for (var s2_AnonymousObjectSubclass = new Object() { } ; ; ) { break; }\n        for (var s2_AnonymousObjectSubclass : arrayOf(new Object() { })) { break; }\n        for (var s2_AnonymousObjectSubclass : listOf(new Object() { })) { break; }\n    }\n\n    void testTypeOfAnAnonymousInterface() {\n        var r_AnonymousRunnableSubclass = new Runnable() { public void run() { } };\n        for (var s2_AnonymousRunnableSubclass = new Runnable() { public void run() { } } ; ; ) { break; }\n        for (var s2_AnonymousRunnableSubclass : arrayOf(new Runnable() { public void run() { } })) { break; }\n        for (var s2_AnonymousRunnableSubclass : listOf(new Runnable() { public void run() { } })) { break; }\n    }\n\n    void testTypeOfIntersectionType() {\n        var c_IntLongFloat = choose(1, 1L);\n        for (var s2_IntLongFloat = choose(1, 1L) ; ;) { break; }\n        for (var s2_IntLongFloat : arrayOf(choose(1, 1L))) { break; }\n        for (var s2_IntLongFloat : listOf(choose(1, 1L))) { break; }\n    }\n\n    public void testProjections() {\n        var inter_ListTestAndSerializable = getIntersections();\n        var r_TestAndSerializable = inter_ListTestAndSerializable.get(0);\n    }\n\n    Collection<? extends String> extendsString() { return null; }\n    Collection<? super String> superString() { return null; }\n    Collection<?> unboundedString() { return null; }\n\n    Collection<? extends String>[] extendsStringArr() { return null; }\n    Collection<? super String>[] superStringArray() { return null; }\n    Collection<?>[] unboundedStringArray() { return null; }\n\n    Iterable<? extends Collection<? extends String>> extendsCollectionIterable() { return null; }\n    Iterable<? extends Collection<? super String>> superCollectionIterable() { return null; }\n    Iterable<? extends Collection<?>> unboundedCollectionIterable() { return null; }\n\n    <TBound extends Comparable<TBound>> Collection<? extends TBound> extendsTBound() { return null; }\n    <TBound extends Comparable<TBound>> Collection<? super TBound> superTBound() { return null; }\n\n    <TBound extends Comparable<TBound>> Collection<? extends TBound>[] extendsTBoundArray() { return null; }\n    <TBound extends Comparable<TBound>> Collection<? super TBound>[] superTBoundArray() { return null; }\n\n    <TBound extends Comparable<TBound>> Iterable<? extends Collection<? extends TBound>> extendsTBoundIter() { return null; }\n    <TBound extends Comparable<TBound>> Iterable<? extends Collection<? super TBound>> superTBoundIter() { return null; }\n\n    <TBound> Collection<TBound> listOf(TBound b) { return null; }\n    <TBound> TBound[] arrayOf(TBound b) { return null; }\n\n    <TBound> TBound choose(TBound b1, TBound b2) { return b1; }\n    <T extends Z & Serializable> List<? extends T> getIntersections() {\n        return null;\n    }\n}"}, typeVerifier);
        Assert.assertEquals((long)39L, (long)typeVerifier.localsChecked);
    }

    public void testBug531832() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        for (var[] v : args) { }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfor (var[] v : args) { }\n\t           ^\n'var' is not allowed as an element type of an array\n----------\n");
    }

    public void testBug530879() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void foo() { }\n    public static void main(String [] args) {\n        for (var v : foo()) { }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tfor (var v : foo()) { }\n\t         ^\nVariable initializer is 'void' -- cannot infer variable type\n----------\n2. ERROR in X.java (at line 4)\n\tfor (var v : foo()) { }\n\t             ^^^^^\nCan only iterate over an array or an instance of java.lang.Iterable\n----------\n");
    }

    public void testBug530879a() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        for (var v : null) { }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfor (var v : null) { }\n\t         ^\nCannot infer type for local variable initialized to 'null'\n----------\n2. ERROR in X.java (at line 3)\n\tfor (var v : null) { }\n\t             ^^^^\nCan only iterate over an array or an instance of java.lang.Iterable\n----------\n");
    }

    public void testBug532349() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Boolean p) {\n\t\tY<? super Boolean> y = new Y<>();\n\t\tvar v = y;\n\t\tY<? super Boolean> tmp = v;\n\t}\n}\nclass Y<T extends Boolean> {\n}"});
    }

    public void testBug532349a() throws IOException {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\npublic class X {\n\tpublic static void foo(Boolean p) {\n\t\tList<Y<? super Boolean>> l = new ArrayList<>();\n\t\tvar dlv = l;\n\t\tfor (var iv : dlv) {\n\t\t\tY<? super Boolean> id = iv;\n\t\t}\t}\n}\nclass Y<T extends Boolean> {}"});
    }

    public void testBug532349b() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Boolean p) {\n\t\tY<? super Boolean> y = new Y<>();\n\t\ttry (var v = y) {\n\t\t\tY<? super Boolean> tmp = v;\n\t\t} catch (Exception e) { }\n\t}\n}\nclass Y<T extends Boolean> implements AutoCloseable {\n\t@Override\n\tpublic void close() throws Exception {}\n}"});
    }

    public void testBug532351() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void foo(Boolean p) {\n    Y<? super Number> y = new Y<Number>(); // Javac reports, ECJ accepts\n    var v = y;\n    Y<? super Number> tmp = v;\n  }\n  class Y<T extends Number> {\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tY<? super Number> y = new Y<Number>(); // Javac reports, ECJ accepts\n\t                      ^^^^^^^^^^^^^^^\nNo enclosing instance of type X is accessible. Must qualify the allocation with an enclosing instance of type X (e.g. x.new A() where x is an instance of X).\n----------\n");
    }

    public void testBug531025() {
        this.runNegativeTest(new String[]{"a/Ann.java", "package a;\npublic @interface Ann {}\n", "a/AnnM.java", "package a;\nimport java.lang.annotation.*;\n@Target(ElementType.METHOD)\npublic @interface AnnM {}\n", "a/AnnD.java", "package a;\nimport java.lang.annotation.*;\n@Target(ElementType.LOCAL_VARIABLE)\npublic @interface AnnD {}\n", "a/AnnT.java", "package a;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\npublic @interface AnnT {}\n", "a/AnnDT.java", "package a;\nimport java.lang.annotation.*;\n@Target({ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})\npublic @interface AnnDT {}\n", "X.java", "import a.*;\nimport java.util.*;\npublic class X {\n\tvoid test(List<String> strings) {\n\t\t@Ann   var v  = strings;\n\t\t@AnnM  var vm = strings;\n\t\t@AnnD  var vd = strings;\n\t\t@AnnT  var vt = \"\";\n\t\t@AnnDT var vdt = this;\n\t\tfor (@AnnD var fvd : strings) {}\n\t\tfor (@AnnT var fvt : strings) {}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t@AnnM  var vm = strings;\n\t^^^^^\nThe annotation @AnnM is disallowed for this location\n----------\n2. ERROR in X.java (at line 8)\n\t@AnnT  var vt = \"\";\n\t^^^^^\nThe annotation @AnnT is disallowed for this location\n----------\n3. ERROR in X.java (at line 11)\n\tfor (@AnnT var fvt : strings) {}\n\t     ^^^^^\nThe annotation @AnnT is disallowed for this location\n----------\n");
    }

    public void testBug532349_001() throws IOException {
        this.runConformTest(new String[]{"X.java", "class X {\n\tpublic static void foo() {\n\t\tY<? extends Number> y = new Y<>();\n\t\tvar v = y.t;\n\t\tInteger dsbType0 = v;\n\t}\n}\nclass Y<T extends Integer> {\n\tpublic T t;\n}"});
    }

    public void testBug532349_002() throws IOException {
        this.runConformTest(new String[]{"X.java", "class X {\n\tpublic static void foo() {\n\t\tY<? extends I> y = new Y<>();\n\t\tvar v = y.t;\n\t\tInteger dsbType0 = v;\n\t}\n}\ninterface I { }\nclass Y<T extends Integer> {\n\tpublic T t;\n}"});
    }

    public void testBug532349_003() throws IOException {
        this.runConformTest(new String[]{"X.java", "class X {\n\tpublic static void foo(Y<? extends I> y) {\n\t\tvar v = y.t;\n\t\tInteger dsbType0 = v;\n\t\tI i = v;\n\t}\n}\ninterface I { }\nclass Y<T extends Integer> {\n\tpublic T t;\n}"});
    }

    public void testBug532349_004() throws IOException {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nclass X {\n\tpublic static void foo() {\n\t\tY<? extends Integer> y = new Y<>();\n\t\tvar v = y.t;\n\t\tInteger dsbType0 = v;\n\t\tSerializable s = v;\n\t}\n}\nclass Y<T extends Number&Serializable> {\n\tpublic T t;\n}"});
    }

    public void testBug532349_005() throws IOException {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nclass X {\n\tpublic static void foo() {\n\t\tY<?> y = new Y<>();\n\t\tvar v = y.t;\n\t\tI i = v;\n\t\tSerializable s = v;\n\t}\n}\ninterface I { }\nclass Y<T extends I&Serializable> {\n\tpublic T t;\n}"});
    }

    public void testBug532349_006() throws IOException {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nclass X {\n\tpublic static void foo() {\n\t\tY<? extends I> y = new Y<>();\n\t\tvar v = y.t;\n\t\tI i = v;\n\t\tSerializable s = v;\n\t}\n}\ninterface I { }\nclass Y<T extends Serializable> {\n\tpublic T t;\n}"});
    }

    public void testBug532349_007() throws IOException {
        this.runConformTest(new String[]{"X.java", "class X {\n\tpublic static void foo() {\n\t\tZ<? extends I> z = new Z<>();\n\t\tvar v = z.t;\n\t\tX x = v.t;\n\t\tv.doSomething();\n\t}\n}\ninterface I { void doSomething();}\nclass Z<T extends Y<?>> {\n\tpublic T t;\n}\nclass Y<T extends X> {\n\tpublic T t;\n}"});
    }

    public void testBug532349_008() throws IOException {
        this.runConformTest(new String[]{"X.java", "class X {\n\tpublic static void foo() {\n\t\tZ<? extends Y<? extends C>> z = new Z<>();\n\t\tvar v = z.t;\n\t\tC c = v.t;\n\t\tv.doSomething();\n\t}\n}\ninterface I { void doSomething();}\nclass C extends X{ }\nclass Z<T extends I> {\n\tpublic T t;\n}\nclass Y<T extends X> {\n\tpublic T t;\n}"});
    }

    public void testBug532349_009() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nclass X {\n\tpublic static void foo() {\n\t\tY<? super J> y = new Y<>();\n\t\tvar v = y.t;\n\t\tI i = v;\n\t\tSerializable s = v;\n\t}\n}\ninterface I { }\ninterface J extends I{}class Y<T extends I> {\n\tpublic T t;\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tSerializable s = v;\n\t                 ^\nType mismatch: cannot convert from I to Serializable\n----------\n");
    }

    public void testBug532349_010() throws IOException {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nclass X {\n\tpublic static void foo(C<?> c) {\n\t\tvar v = c.t;\n\t\tv = (I&Serializable) new D();\n\t\tv.doSomething();\n\t}\n}\ninterface I { void doSomething();}\nclass C<T extends I&Serializable>{ T t;}\nclass D implements I, Serializable { public void doSomething() {} }\n"});
    }

    public void testBug532349_11() throws IOException {
        this.runConformTest(new String[]{"X.java", "class X {\n\tstatic <R extends D<? extends Y>> W<? extends R> boo() {\n\t\treturn null;\n\t}\n\tpublic static void foo() {\n\t\tvar v = boo();\n\t\tvar var = v.t;\n\t\tY y = var.r;\n\t}\n}\nclass Y extends X { }\nclass D<R extends X>{ R r;}\nclass W<T extends D<?>> { T t; }\n"});
    }

    public void testBug532349_12() throws IOException {
        this.runConformTest(new String[]{"X.java", "class X {\n\tpublic static void foo(D<?> d) {\n\t\tvar v = d;\n\t\tD<? extends Y> dy = v;\n\t\tD<? extends X> dx = v;\n\t}\n}\nclass Y extends X{ }\nclass D<R extends Y>{ R r;}\n"});
    }

    public void testBug532349_13() throws IOException {
        this.runConformTest(new String[]{"X.java", "class X {\n\tpublic static void foo(D<Y<? extends Integer>> d) {\n\t\tvar v = d.r;\n\t\tY<? extends Number> yn = v;\n\t\tY<? extends Integer> yi = v;\n\t}\n}\nclass Y<T extends Integer>{ }\nclass D<R extends Y<? extends Number>>{ R r;}\n"});
    }

    public void testBug532349_14() throws IOException {
        this.runConformTest(new String[]{"X.java", "class X {\n\tpublic static void foo(A<? super C> ac) {\n\t\tC c = new C(100);\n\t\tvar c1 = ac;\n\t\tA<? super C> a1 = c1;\n\t\tA<? super C> a2 = new A<B>(new B());\n\t\ta2 = c1;\n\t}\n}\nclass C<T> extends B{\n\tT t;\n\tC(T t) {\n\t\tthis.t = t;\n\t}\n}\nclass B { }\nclass A<Q> {\n\tA(Q e) {}\n}"});
    }

    public void testBug532349_15() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t    public static <T> A<T> m(T t) {\n        return new A(t);\n    }\n    public static <U extends I1<?>> A<? extends U> m2(A<? super U> u) {\n        return new A(u);\n    }\n    public static void main(String argv[]) {\n        A<?> checkValue1 = new C(10);\n        var varValue = m2(m(checkValue1));\n        if(!varValue.t.t.equals(10)) {\n            System.out.println(\"Error:\");\n        }\n        if(varValue.t.methodOnI1() != true) {\n            System.out.println(\"Error:\");\n        }\n    }}\nclass A<E> {\n    E t;\n    A(E t) {\n        this.t = t;\n    }\n    A<E> u;\n    A (A<E> u) {\n        this(u.t);\n        this.u = u;\n    }\n}\ninterface I1<E> {\n    default boolean methodOnI1() {\n        return true;\n    }\n}\nclass C<T> extends A implements I1 {\n    C(T t) {\n        super(t);\n    }\n}"}, "");
    }

    public void testBug532349_0016() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tpublic static void foo() {\n\t\tY<? extends I> yi = new Y<>();\n\t\tvar vi = yi.t;\n\t\tY<Integer> yj = new Y<>();\n\t\tvi = yj.t;\n\t}\n}\ninterface I { }\nclass Y<T extends Number> {\n\tpublic T t;\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tvi = yj.t;\n\t     ^^^^\nType mismatch: cannot convert from Integer to Number & I\n----------\n");
    }

    public void testBug532349_0017() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tpublic static <Q extends Number & I> void foo(Y<? super Q> y) {\n\t\tvar vy = y;\n\t\tY<Integer> yi = new Y<>();\n\t\tvy = yi;\n\t}\n}\ninterface I { }\nclass Y<T extends Number> {\n\tpublic T t;\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tvy = yi;\n\t     ^^\nType mismatch: cannot convert from Y<Integer> to Y<? super Q>\n----------\n");
    }

    public void testBug532920() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Iterator;\npublic class X {\n  static void foo(Z<?> ef) {  \n    for (var l : ef.t) {\n      l = new Object();\n    }\n  }\n}\nclass I<T> {// implements Iterable<T> {\n T t;\n}\nclass Q {}\nclass Y extends Q{ }\nclass Z<T extends Iterable<? super Y>> {\n  I<T> t;\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tfor (var l : ef.t) {\n\t             ^^^^\nCan only iterate over an array or an instance of java.lang.Iterable\n----------\n");
    }

    private static final class InferredTypeVerifier
    extends ASTVisitor {
        public int localsChecked = 0;

        public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
            return false;
        }

        public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
            if (!new String(methodDeclaration.selector).startsWith("test")) {
                return false;
            }
            return super.visit(methodDeclaration, scope);
        }

        public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
            JEP286Test.assertInferredType(localDeclaration);
            ++this.localsChecked;
            return super.visit(localDeclaration, scope);
        }
    }
}

