/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class LambdaShapeTests
extends AbstractRegressionTest {
    public LambdaShapeTests(String name) {
        super(name);
    }

    public static Test suite() {
        return LambdaShapeTests.buildMinimalComplianceTestSuite(LambdaShapeTests.testClass(), 32);
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "interface VoidI {\n\tvoid foo(String s);\n}\nclass Test {\n\tpublic String gooVoid(VoidI i){return \"\";}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTest test = new Test();\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (false) {\n\t\t\t\tx += \"a\";\n\t\t\t}\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (true);\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (true) {\n\t\t\t\tx += \"a\";\n\t\t\t}\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tfinal boolean val = true;\n\t\t\tif (val) {\n\t\t\t\tx += \"a\";\n\t\t\t}\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tfinal boolean val = true;\n\t\t\tif (val);\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tfinal boolean val = false;\n\t\t\tif (val) {\n\t\t\t\tx += \"a\";\n\t\t\t}\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (x != null) {\n\t\t\t\tx += \"a\";\n\t\t\t}\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tfinal boolean val = true;\n\t\t\tif (x != null);\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (false) {\n\t\t\t\tx += \"a\";\n\t\t\t} else {\n\t\t\t\tx += \"b\";\n\t\t\t}\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (false) {\n\t\t\t\tx += \"a\";\n\t\t\t} else;\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tfinal boolean val = false;\n\t\t\tif (val) {\n\t\t\t\tx += \"a\";\n\t\t\t} else {\n\t\t\t\tx += \"b\";\n\t\t\t}\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tfinal boolean val = false;\n\t\t\tif (val) {\n\t\t\t\tx += \"a\";\n\t\t\t} else;\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (x != null) {\n\t\t\t\tx += \"a\";\n\t\t\t} else {\n\t\t\t\tx += \"b\";\n\t\t\t}\n\t\t});\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (x != null) {\n\t\t\t\tx += \"a\";\n\t\t\t} else;\n\t\t});\n\t}\n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo(int x); \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tfinal boolean FALSE = false;\n\t\tgoo((x) -> {\n\t\t\tif(true) return \"\";\n\t\t\telse return null;\n\t\t});\n\t\tgoo((x) -> {\n\t\t\tif(false) return \"\";\n\t\t\telse return null;\n\t\t});\n\t\tgoo((x) -> {\n\t\t\tif(x > 0) return \"\";\n\t\t\telse return null;\n\t\t});\n\t\tgoo((x) -> {\n\t\t\tif(FALSE) return \"\";\n\t\t\telse return null;\n\t\t});\n\t\tgoo((x) -> {\n\t\t\tif(!FALSE) return \"\";\n\t\t\telse return null;\n\t\t});\n\t\tgoo((x) -> {\n\t\t\tif(!FALSE) return \"\";\n\t\t\telse return null;\n\t\t});\n\t}\n}\n"});
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "interface VoidI {\n\tvoid foo(String s);\n}\nclass Test {\n\tpublic String gooVoid(VoidI i){return \"\";}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTest test = new Test();\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (true) {\n\t\t\t\treturn 0;\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ttest.gooVoid((x) -> {\n\t     ^^^^^^^\nThe method gooVoid(VoidI) in the type Test is not applicable for the arguments ((<no type> x) -> {})\n----------\n2. ERROR in X.java (at line 12)\n\treturn 0;\n\t^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "interface VoidI {\n\tvoid foo(String s);\n}\nclass Test {\n\tpublic String gooVoid(VoidI i){return \"\";}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTest test = new Test();\n\t\ttest.gooVoid((x) -> {\n\t\t\tfinal boolean val = true;\n\t\t\tif (val) {\n\t\t\t\treturn x;\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ttest.gooVoid((x) -> {\n\t     ^^^^^^^\nThe method gooVoid(VoidI) in the type Test is not applicable for the arguments ((<no type> x) -> {})\n----------\n2. ERROR in X.java (at line 13)\n\treturn x;\n\t^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "interface VoidI {\n\tvoid foo(String s);\n}\nclass Test {\n\tpublic String gooVoid(VoidI i){return \"\";}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTest test = new Test();\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (x != null) {\n\t\t\t\treturn 0;\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ttest.gooVoid((x) -> {\n\t     ^^^^^^^\nThe method gooVoid(VoidI) in the type Test is not applicable for the arguments ((<no type> x) -> {})\n----------\n2. ERROR in X.java (at line 12)\n\treturn 0;\n\t^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "interface VoidI {\n\tvoid foo(String s);\n}\nclass Test {\n\tpublic String gooVoid(VoidI i){return \"\";}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTest test = new Test();\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (false) {\n\t\t\t\tx += \"a\";\n\t\t\t} else {\n\t\t\t\treturn 0;\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ttest.gooVoid((x) -> {\n\t     ^^^^^^^\nThe method gooVoid(VoidI) in the type Test is not applicable for the arguments ((<no type> x) -> {})\n----------\n2. ERROR in X.java (at line 14)\n\treturn 0;\n\t^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "interface VoidI {\n\tvoid foo(String s);\n}\nclass Test {\n\tpublic String gooVoid(VoidI i){return \"\";}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTest test = new Test();\n\t\ttest.gooVoid((x) -> {\n\t\t\tfinal boolean val = false;\n\t\t\tif (val) {\n\t\t\t\tx += \"a\";\n\t\t\t} else {\n\t\t\t\treturn 0;\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ttest.gooVoid((x) -> {\n\t     ^^^^^^^\nThe method gooVoid(VoidI) in the type Test is not applicable for the arguments ((<no type> x) -> {})\n----------\n2. ERROR in X.java (at line 15)\n\treturn 0;\n\t^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "interface VoidI {\n\tvoid foo(String s);\n}\nclass Test {\n\tpublic String gooVoid(VoidI i){return \"\";}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTest test = new Test();\n\t\ttest.gooVoid((x) -> {\n\t\t\tif (x != null) {\n\t\t\t\tx += \"a\";\n\t\t\t} else {\n\t\t\t\treturn 0;\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ttest.gooVoid((x) -> {\n\t     ^^^^^^^\nThe method gooVoid(VoidI) in the type Test is not applicable for the arguments ((<no type> x) -> {})\n----------\n2. ERROR in X.java (at line 14)\n\treturn 0;\n\t^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x); \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tfinal boolean FALSE = false;\n\t\tgoo((x) -> {\n\t\t\tif(FALSE) return \"\";\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x); \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {\n\t\t\tif(true);\n\t\t\telse return \"\";\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 9)\n\telse return \"\";\n\t     ^^^^^^^^^^\nDead code\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x); \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {\n\t\t\tif(false) return null;\n\t\t\telse;\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 8)\n\tif(false) return null;\n\t          ^^^^^^^^^^^^\nDead code\n----------\n3. WARNING in X.java (at line 9)\n\telse;\n\t    ^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x); \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {\n\t\t\tif(x > 0) return \"\";\n\t\t\telse;\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 9)\n\telse;\n\t    ^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x); \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {\n\t\t\tif(x > 0);\n\t\t\telse return \"\";\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x); \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {\n\t\t\tif(x < 0) return null;\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x); \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tfinal boolean FALSE = false;\n\t\tgoo((x) -> {\n\t\t\tif(!FALSE) return \"\";\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tfinal boolean FALSE = false;\n\t\tgoo((x) -> {while (FALSE) throw new Exception();});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tgoo((x) -> {while (FALSE) throw new Exception();});\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments ((<no type> x) -> {})\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {while (false) return \"\";});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {while (false) return \"\";});\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. ERROR in X.java (at line 7)\n\tgoo((x) -> {while (false) return \"\";});\n\t                          ^^^^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {while (x > 0) {\n\t\t\tif(x > 0) {return \"\";} else {break;}\n\t\t\t}});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {while (x > 0) {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 8)\n\tif(x > 0) {return \"\";} else {break;}\n\t                            ^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {while (x > 0) {\n\t\t\tif(x > 0) {return \"\";}\n\t\t}});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {while (x > 0) {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo(int x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tfinal boolean TRUE = true;\n\t\tgoo((x) -> {while (TRUE) {\n\t\t\tif(x > 0) {System.out.println();}\n\t\t\t}});\n\t\tgoo((x) -> {while (true) {\n\t\t\tif(x > 0) {System.out.println();}\n\t\t\t}});\n\t}\n}\n"});
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {\n\t\t\tint i = 100;\n\t\t\touter: while(x > 0) {\n\t\t\t\tinner: while(i > 0) {\n\t\t\t\tif(--i > 50) {\n\t\t\t\t\treturn \"\";\n\t\t\t\t}\n\t\t\t\tif(i > 90) {\n\t\t\t\t\tbreak outer;\n\t\t\t\t}\n\t\t\t\treturn \"\";\n\t\t\t\t}\n\t\t\t}});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 10)\n\tinner: while(i > 0) {\n\t^^^^^\nThe label inner is never explicitly referenced\n----------\n");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(String s) throws Exception;\n}\npublic class X {\n\tvoid zoo(I i) {}\n\tvoid test() {\n\t\tfinal boolean FALSE = false;\n\t\tfinal boolean TRUE = true;\n\t\tzoo((x) -> {while (TRUE) throw new Exception();});\n\t\tzoo((x) -> {while (!FALSE) return ;});\n\t\tzoo((x) -> {while (x.length() > 0) {\n\t\t\tif(x.length() > 0) {return ;} else {break;}\n\t\t\t}});\n\t\tzoo((x) -> {while (x.length() > 0) {\n\t\t\tif(x.length() > 0) {return ;}\n\t\t\t}});\n\t\tzoo((x) -> {while (true) {\n\t\t\tif(x.length() > 0) {System.out.println();}\n\t\t\t}});\n\t\tzoo((x) -> {while (TRUE) {\n\t\t\tif(x.length() > 0) {System.out.println();}\n\t\t\t}});\n\t\tzoo((x) -> {\n\t\t\tint i = 100;\n\t\t\touter: while(x.length() > 0) {\n\t\t\t\tinner: while(i > 0) {\n\t\t\t\tif(--i > 50) {\n\t\t\t\t\tbreak inner ;\n\t\t\t\t}\n\t\t\t\tif(i > 90) {\n\t\t\t\t\tbreak outer;\n\t\t\t\t}\n\t\t\t\treturn ;\n\t\t\t\t}\n\t\t\t}});\n\t}\n}\n"});
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo(int x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tfinal boolean FALSE = false;\n\t\tfinal boolean TRUE = true;\n\t\tgoo((x) -> {do {throw new Exception();}while (FALSE);});\n\t\tgoo((x) -> {do { return \"\";}while (false);});\n\t\tgoo((x) -> {do {\n\t\t\tif(x > 0) {System.out.println();}\n\t\t\t}while (true);});\n\t\tgoo((x) -> {do {\n\t\t\tif(x > 0) {System.out.println();}\n\t\t\t}while (TRUE);});\n\t}\n}\n"});
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {do {\n\t\t\tif(x > 0) {return \"\";} else {break;}\n\t\t\t}while (x > 0);});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {do {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 8)\n\tif(x > 0) {return \"\";} else {break;}\n\t                            ^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {do {\n\t\t\tif(x > 0) {return \"\";}\n\t\t\t}while (x > 0);});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {do {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(int x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {\n\t\t\tint i = 100;\n\t\t\touter: do {\n\t\t\t\tinner: do {\n\t\t\t\tif(--i > 50) {\n\t\t\t\t\treturn \"\";\n\t\t\t\t}\n\t\t\t\tif(i > 90) {\n\t\t\t\t\tbreak outer;\n\t\t\t\t}\n\t\t\t\treturn \"\";\n\t\t\t\t}while(i > 0);\n\t\t\t}while(x > 0);});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 10)\n\tinner: do {\n\t^^^^^\nThe label inner is never explicitly referenced\n----------\n");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(String s) throws Exception;\n}\npublic class X {\n\tvoid zoo(I i) {}\n\tvoid test() {\n\t\tzoo((x) -> {do {\n\t\t\tif(x.length() > 0) {System.out.println();}\n\t\t\t}while (true);});\n\t\tzoo((x) -> {do {throw new Exception();}while (false);});\n\t\tzoo((x) -> {do { return ;}while (false);});\n\t\tzoo((x) -> {do { continue ;}while (true);});\n\t\tzoo((x) -> {do {\n\t\t\tif(x.length() > 0) {return ;} else {break;}\n\t\t\t}while (x.length() > 0);\n\t\t});\n\t\tzoo((x) -> {do {\n\t\t\tif(x.length() > 0) {return ;}\n\t\t\t}while (x.length() > 0);\n\t\t});\n\t\tzoo((x) -> {\n\t\tint i = 100;\n\t\touter: do {\n\t\t\tinner: do {\n\t\t\tif(--i > 50) {\n\t\t\t\tbreak inner ;\n\t\t\t}\n\t\t\tif(i > 90) {\n\t\t\t\tbreak outer;\n\t\t\t}\n\t\t\treturn ;\n\t\t\t}while(i > 0);\n\t\t}while(x.length() > 0);});\n\t}\n}\n"});
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tfinal boolean FALSE = false; \n\t\tfinal boolean TRUE = true; \n\t\tgoo((x) -> {\n\t\t\tfor(;TRUE;){\n\t\t\t}});\n\t\tgoo((x) -> {\n\t\t\tfor(int i = 0;i < 100; i+= 10){\n\t\t\t\tswitch(i) {\n\t\t\t\tcase 90: {\n\t\t\t\t\tSystem.out.println();\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tcase 80: {\n\t\t\t\t\tif(x > 10) return null;\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tdefault:\n\t\t\t\t\treturn \"\";\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn \"\";\n\t\t});\n\t\t\n\t\tgoo((x) -> {\n\t\t\tfor(;TRUE;){\n\t\t\t\tif(x < 100) return \"\";\n\t\t\t\telse return null;\n\t\t}});\n\t\tgoo((x) -> {\n\t\t\tfor(;x > 0;){\n\t\t\t\tif(x < 100) return \"\";\n\t\t\t\telse return null;\n\t\t\t}\n\t\t\treturn null;\n\t\t});\n\t}\n}\n"});
    }

    public void test029() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tfinal boolean FALSE = false; \n\t\tgoo((x) -> {\n\t\t\tfor(;FALSE;){\n\t\t\t}});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tgoo((x) -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments ((<no type> x) -> {})\n----------\n");
    }

    public void test030() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {\n\t\t\tfor(;x > 0;){\n\t\t\t\tif(x < 100) return \"\";\n\t\t\t\telse return null;\n\t\t}});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 10)\n\telse return null;\n\t     ^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {\n\t\t\tfor(int i = 0;i < 100; i+= 10){\n\t\t\t\tswitch(i) {\n\t\t\t\tcase 90: {\n\t\t\t\t\tSystem.out.println();\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tcase 80: {\n\t\t\t\t\tif(x > 10) return null;\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tdefault:\n\t\t\t\t\treturn \"\";\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test() {\n\t\tgoo((x) -> {\n\t\t\touter: for(int i = 0;i < 100; i+= 10){\n\t\t\t\tinner : for(int j = x; j > 0; j--) {\n\t\t\t\t\tswitch(i) {\n\t\t\t\t\tcase 90: {\n\t\t\t\t\t\tSystem.out.println();\n\t\t\t\t\t\tbreak inner;\n\t\t\t\t\t}\n\t\t\t\t\tcase 80: {\n\t\t\t\t\t\tif(x > 10) return null;\n\t\t\t\t\t\tbreak outer;\n\t\t\t\t\t}\n\t\t\t\t\tdefault:\n\t\t\t\t\t\treturn \"\";\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 9)\n\tinner : for(int j = x; j > 0; j--) {\n\t                              ^^^\nDead code\n----------\n");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\tfor(String str : strs){\n\t\t\t\tif(str.length() > 0) {\n\t\t\t\t\treturn \"yes\";\n\t\t\t\t} else {\n\t\t\t\t\treturn \"no\";\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn null;\n\t\t});\n\t\tgoo((x) -> {\n\t\t\tfor(String str : strs){\n\t\t\t\treturn \"no\";\n\t\t\t}\n\t\t\treturn \"\";\n\t\t});\n\t\t\n\t\tgoo((x) -> {\n\t\t\tfor(String str : strs){\n\t\t\t\tif(str.length() > 0) break;\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\treturn \"\";\n\t\t});\n\t}\n}\n"});
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\tfor(String str : strs){\n\t\t\t\tif(str.length() > 0) {\n\t\t\t\t\treturn \"yes\";\n\t\t\t\t} else {\n\t\t\t\t\treturn \"no\";\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 11)\n\t} else {\n\t\t\t\t\treturn \"no\";\n\t\t\t\t}\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\tfor(String str : strs){\n\t\t\t\treturn \"no\";\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\tfor(String str : strs){\n\t\t\t\tswitch(str.length()) {\n\t\t\t\tcase 9: {\n\t\t\t\t\tSystem.out.println();\n\t\t\t\t\treturn \"nine\";\n\t\t\t\t}\n\t\t\t\tcase 1: {\n\t\t\t\t\tif(x > 10) return null;\n\t\t\t\t\treturn \"one\";\n\t\t\t\t}\n\t\t\t\tdefault:\n\t\t\t\t\treturn \"\";\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\touter: for(String str : strs){\n\t\t\t\tinner : for(int j = x; j > 0; j--) {\n\t\t\t\t\tswitch(str.length()) {\n\t\t\t\t\tcase 9: {\n\t\t\t\t\t\tSystem.out.println();\n\t\t\t\t\t\tbreak inner;\n\t\t\t\t\t}\n\t\t\t\t\tcase 8: {\n\t\t\t\t\t\tif(x > 10) return null;\n\t\t\t\t\t\tbreak outer;\n\t\t\t\t\t}\n\t\t\t\t\tdefault:\n\t\t\t\t\t\treturn \"\";\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 9)\n\tinner : for(int j = x; j > 0; j--) {\n\t                              ^^^\nDead code\n----------\n");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\tswitch(x) {\n\t\t\tcase 0 : if(x > 10) return \">10\";\n\t\t\tcase 1: return \"1\";\n\t\t\tdefault: return \"-1\";\n\t\t\t}\n\t\t});\n\t\tgoo((x) -> {\n\t\t\tString str = \"\";\n\t\t\tswitch(x) {\n\t\t\tcase 0 : if(x > 10) break; else {str = \"0\"; break;}\n\t\t\tcase 1: str = \"1\";break;\n\t\t\tdefault: break;\n\t\t\t}\n\t\t\treturn str;\n\t\t});\n\t\tgoo((x) -> {\n\t\t\tString str = \"\";\n\t\t\tswitch(x){}\n\t\t\treturn str;\n\t\t});\n\t}\n}\n"});
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\tswitch(x) {\n\t\t\tcase 0 : if(x > 10) return \">10\";\n\t\t\tcase 1: return \"1\";\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\tString str = \"\";\n\t\t\tswitch(x) {\n\t\t\tcase 0 : if(x > 10) break; else {str = \"0\"; break;}\n\t\t\tcase 1: str = \"1\";break;\n\t\t\tdefault: break;\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments ((<no type> x) -> {})\n----------\n");
    }

    public void test041() {
        this.runConformTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\ttry {\n\t\t\t\treturn \"\";\n\t\t\t} finally {\n\t\t\t\t\n\t\t\t}\n\t\t});\n\t\tgoo((x) -> {\n\t\t\t\ttry {\n\t\t\t\t\tthrow new Exception();\n\t\t\t\t} finally {\n\t\t\t\t}\n\t\t});\n\t\tgoo((x) -> {\n\t\t\t\ttry {\n\t\t\t\t\tif(x > 0) \n\t\t\t\t\t\tthrow new RuntimeException();\n\t\t\t\t} catch (NullPointerException e) {return null;} \n\t\t\t\tcatch(ClassCastException c) {\n\t\t\t\t}\n\t\t\t\tfinally {\n\t\t\t\t\treturn \"\";\n\t\t\t\t}\n\t\t});\n\t\t\n\t}\n}\n"});
    }

    public void test042() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\ttry {\n\t\t\t\tif(x > 0) {\n\t\t\t\t\treturn \"\";\n\t\t\t\t}\n\t\t\t} finally {}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\ttry {\n\t\t\t\treturn \"\";\n\t\t\t}catch (Exception e) {}\n\t\t\tfinally {\n\t\t\t\t\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\ttry {\n\t\t\t\t//if(x > 0) \n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t} catch (NullPointerException e) {return null;} \n\t\t\tcatch(ClassCastException c) {\n\t\t\t}\n\t\t});\n\t\tgoo((x) -> {\n\t\t\ttry {\n\t\t\t\tif(x > 0) \n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t} catch (NullPointerException e) {return null;} \n\t\t\tcatch(ClassCastException c) {\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. ERROR in X.java (at line 15)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\ttry {\n\t\t\t\tif(x > 0) \n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t} catch (NullPointerException e) {return null;} \n\t\t\tcatch(ClassCastException c) {\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tString foo(int x) throws Exception; \n}\npublic class X {\n\tvoid goo(I i) {}\n\tvoid test(String[] strs) {\n\t\tgoo((x) -> {\n\t\t\tif (true) {\n\t\t\t\ttry {\n\t\t\t\t\tif(x > 0)\n\t\t\t\t\t\tthrow new Exception();\n\t\t\t\t} finally {\n\t\t\t\t\treturn \"\";\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo((x) -> {\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 12)\n\t} finally {\n\t\t\t\t\treturn \"\";\n\t\t\t\t}\n\t          ^^^^^^^^^^^^^^^^^^^^^^^\nfinally block does not complete normally\n----------\n");
    }

    public void testSwitch() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tswitch (args.length) {\n\t\t\tcase 0:\n\t\t\t\tSystem.out.println(0);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tcase 1:\n\t\t\t\tSystem.out.println(1);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tcase 2:\n\t\t\t\tSystem.out.println(2);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tdefault: \n\t\t\t\tSystem.out.println(\"default\");\n\t\t\t\tthrow new RuntimeException();\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testSwitch2() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tswitch (args.length) {\n\t\t\tcase 0:\n\t\t\t\tSystem.out.println(0);\n\t\t\t\tbreak;\n\t\t\tcase 1:\n\t\t\t\tSystem.out.println(1);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tcase 2:\n\t\t\t\tSystem.out.println(2);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tdefault: \n\t\t\t\tSystem.out.println(\"default\");\n\t\t\t\tthrow new RuntimeException();\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testSwitch3() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tswitch (args.length) {\n\t\t\tcase 0:\n\t\t\t\tSystem.out.println(0);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tcase 1:\n\t\t\t\tSystem.out.println(1);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tcase 2:\n\t\t\t\tSystem.out.println(2);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tdefault: \n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testSwitch4() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tswitch (args.length) {\n\t\t\tcase 0:\n\t\t\t\tSystem.out.println(0);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tcase 1:\n\t\t\t\tSystem.out.println(1);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tcase 2:\n\t\t\t\tSystem.out.println(2);\n\t\t\t\tthrow new RuntimeException();\n\t\t\tdefault: \n\t\t\t    break;\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testSwitch5() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\npublic class X {\n\tstatic void goo(I i) {}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tswitch (args.length){\n\t\t\tcase 1:\n\t\t\t\tif (args == null)\n\t\t\t\t\tbreak;\n\t\t\t\telse\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testSwitch6() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\npublic class X {\n\tstatic void goo(I i) {}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tswitch (args.length){\n\t\t\tcase 1:\n\t\t\t\tif (args == null)\n\t\t\t\t\tbreak;\n           throw new RuntimeException();\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testWhileThis() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tboolean t = true;\n\t\t\twhile (t) {\n\t\t\t\tSystem.out.println();\n\t\t\t\tthrow new RuntimeException();\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testWhile2() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\twhile (t) {\n\t\t\t\tSystem.out.println();\n\t\t\t\tthrow new RuntimeException();\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testWhile3() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\twhile (t && !!t) {\n\t\t\t\tSystem.out.println();\n\t\t\t\tthrow new RuntimeException();\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testWhile4() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\twhile (t && !!!t) {\n\t\t\t\tSystem.out.println();\n\t\t\t\tthrow new RuntimeException();\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tboolean t = true;\n\t\t\tdo {\n\t\t\t\tSystem.out.println();\n\t\t\t\tthrow new RuntimeException();\n\t\t\t} while (t);\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testDo2() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tdo {\n\t\t\t\tSystem.out.println();\n\t\t\t\tthrow new RuntimeException();\n\t\t\t} while (t);\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testDo3() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tdo { \n\t\t\t\tSystem.out.println();\n\t\t\t\tthrow new RuntimeException();\n\t\t\t} while (t && !!t);\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testDo4() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tdo {\n\t\t\t\tSystem.out.println();\n\t\t\t} while (t && !!!t);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo5() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\tbreak;\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo6() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\tif (args == null) break;\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo7() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\tif (args == null) throw new RuntimeException();\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo8() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\tthrow new RuntimeException();\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testDo9() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\tcontinue;\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "J");
    }

    public void testDo10() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n               if (true) \n\t\t\t\t    continue;\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo11() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n               if (true) \n\t\t\t\t    continue;\n               else \n                   continue;\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo12() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n               if (true) \n\t\t\t\t    continue;\n               else \n                   throw new RuntimeException();\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo13() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n               if (true) \n                   throw new RuntimeException();\n               else \n                   throw new RuntimeException();\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "I");
    }

    public void testDo14() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n               if (true) { \n                   System.out.println();\n\t\t\t\t    continue;\n               }\n               else {\n                   continue;\n               }\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo15() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tlabel:\n\t\t\tdo {\n\t\t\t\tcontinue label;\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo16() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\tblah:\n\t\t\t\tcontinue;\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo17() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\tsynchronized(args) {\n\t\t\t\t    continue;\n               }\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testDo18() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\ttry {\n\t\t\t\t\tcontinue;\n\t\t\t\t} finally {\n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t\t}\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "I");
    }

    public void testDo19() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\ttry {\n\t\t\t\t\tcontinue;\n\t\t\t\t} finally {\n\t\t\t\t}\n\t\t\t} while (false);\t\n\t\t});\n\t}\n}\n"}, "J");
    }

    public void testDo20() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\tswitch (args.length){\n\t\t\t\tdefault:\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\t\t\t} while (false);\t\n\t\t});\n\t}\n}\n"}, "J");
    }

    public void testDo21() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\twhile (true) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\t\t\t} while (false);\t\n\t\t});\n\t}\n}\n"}, "I");
    }

    public void testDo22() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tlabel:\n\t\t\tdo {\n\t\t\t\twhile (true) {\n\t\t\t\t\tcontinue label;\n\t\t\t\t}\n\t\t\t} while (false);\t\n\t\t});\n\t}\n}\n"}, "J");
    }

    public void testDo23() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tlabel:\n\t\t\twhile (true) {\n\t\t\t\twhile (true) {\n\t\t\t\t\tcontinue label;\n\t\t\t\t}\n\t\t\t}\t\n\t\t});\n\t}\n}\n"}, "I");
    }

    public void testDo24() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tlabel:\n\t\t\tdo {\n\t\t\t\tfor (;;) {\n\t\t\t\t\tcontinue label;\n\t\t\t\t}\n\t\t\t} while (false);\t\n\t\t});\n\t}\n}\n"}, "J");
    }

    public void testDo25() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tlabel:\n\t\t\tdo {\n\t\t\t\tdo {\n\t\t\t\t\tcontinue label;\n\t\t\t\t} while (true);\n\t\t\t} while (false);\t\n\t\t});\n\t}\n}\n"}, "J");
    }

    public void testDo26() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tdo {\n\t\t\t\tlabel:\n\t\t\t\t\twhile (true) {\n\t\t\t\t\t\tcontinue label;\n\t\t\t\t\t}\n\t\t\t} while (false);\n\t\t});\n\t}\n}\n"}, "I");
    }

    public void testForeach() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tfor (String s: args) {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testForeach2() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tfor (String s: args) {\n\t\t\t\tSystem.out.println();\n\t\t\tdo {\n\t\t\t\tSystem.out.println();\n\t\t\t\tswitch (args.length) {\n\t\t\t\tcase 0:\n\t\t\t\t\tSystem.out.println(0);\n\t\t\t\t\tbreak;\n\t\t\t\tcase 1:\n\t\t\t\t\tSystem.out.println(1);\n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t\tcase 2:\n\t\t\t\t\tSystem.out.println(2);\n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t\tdefault: \n\t\t\t\t\tSystem.out.println(\"default\");\n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t\t}\n\t\t\t} while (t);\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testForeach3() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tfor (String s: args) {\n\t\t\t\tSystem.out.println();\n\t\t\tdo {\n\t\t\t\tSystem.out.println();\n\t\t\t\tswitch (args.length) {\n\t\t\t\tcase 0:\n\t\t\t\t\tSystem.out.println(0);\n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t\tcase 1:\n\t\t\t\t\tSystem.out.println(1);\n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t\tcase 2:\n\t\t\t\t\tSystem.out.println(2);\n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t\tdefault: \n\t\t\t\t\tSystem.out.println(\"default\");\n\t\t\t\t\tthrow new RuntimeException();\n\t\t\t\t}\n\t\t\t} while (t);\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testForeach4() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tfor (String s: args) {\n\t\t\t\tSystem.out.println();\n\t\t\t\tthrow new RuntimeException();\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testIf() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tif (t) \n               throw new RuntimeException();\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testIf2() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tif (true) \n               throw new RuntimeException();\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testIf3() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tif (true) \n               throw new RuntimeException();\n           else \n               throw new RuntimeException();\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testCFor() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tboolean t = true;\n\t\t\tfor (; t ;) { \n               throw new RuntimeException();\n           }\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testCFor2() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tfinal boolean t = true;\n\t\t\tfor (; t ;) { \n               throw new RuntimeException();\n           }\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testTry() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n           try {\n           } finally {\n               throw new RuntimeException();\n           }\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testTry2() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n           try {\n           } finally {\n           }\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testTry3() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n           try {\n           } catch (RuntimeException e) {\n               throw new RuntimeException();\n           }\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testTry4() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n   static void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n           try {\n               throw new RuntimeException();\n           } catch (RuntimeException e) {\n               throw new RuntimeException();\n           }\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testWhileTrue() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n            System.out.println(\"goo(I)\");\n        }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\twhile (true) {\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testWhileTrue2() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n            System.out.println(\"goo(I)\");\n        }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\twhile (true) {\n\t\t\t    while (true) {\n                   if (args == null) break;\n\t\t\t    }\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "goo(I)");
    }

    public void testWhileTrue3() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n            System.out.println(\"goo(I)\");\n        }\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\twhile (true) {\n                   if (args == null) break;\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(() -> {\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void testLabeledStatement() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\tlabel: \n\t\t\twhile (true) {\n\t\t\t\twhile (true) {\n\t\t\t\t\tbreak label;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "J");
    }

    public void testLabeledStatement2() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\touterlabel: \n\t\t\tlabel: \n\t\t\twhile (true) {\n\t\t\t\twhile (true) {\n\t\t\t\t\tbreak outerlabel;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "J");
    }

    public void testLabeledStatement3() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\touterlabel: \n\t\t\tlabel: \n\t\t\twhile (true) {\n\t\t\t\twhile (true) {\n\t\t\t\t\tbreak outerlabel;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "J");
    }

    public void testLabeledStatement4() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\touterlabel: \n\t\t\tlabel: \n\t\t\twhile (true) {\n\t\t\t\twhile (true) {\n\t\t\t\t\tbreak label;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "J");
    }

    public void testLabeledStatement5() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"I\");\n\t}\n\tstatic void goo(J i) {\n\t\tSystem.out.println(\"J\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(() -> {\n\t\t\touterlabel: \n\t\t\tlabel: \n\t\t\twhile (true) {\n\t\t\t\twhile (true) {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}\n"}, "I");
    }

    public void testBug470232_While() {
        this.runConformTest(new String[]{"While.java", "import java.util.function.Consumer;\nclass While {\n    void m() {\n        t(Long.class, value -> {\n            int x = 1;\n            while (--x >= 0)\n                ;\n        });\n    }\n    <T> void t(Class<T> clazz, Consumer<T> object) {\n    }\n}\n"});
    }

    public void testBug470232_Do() {
        this.runConformTest(new String[]{"While.java", "import java.util.function.Consumer;\nclass While {\n    void m() {\n        t(Long.class, value -> {\n            int x = 1;\n            do {\n            }while (--x >= 0);\n        });\n    }\n    <T> void t(Class<T> clazz, Consumer<T> object) {\n    }\n}\n"});
    }

    public void testBug470232_For() {
        this.runConformTest(new String[]{"While.java", "import java.util.function.Consumer;\nclass While {\n    void m() {\n        t(Long.class, value -> {\n            int x = 1;\n            for(;--x >= 0;)\n            \t;\n        });\n    }\n    <T> void t(Class<T> clazz, Consumer<T> object) {\n    }\n}\n"});
    }

    public static Class testClass() {
        return LambdaShapeTests.class;
    }
}

