/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.util.Util;

public class LineNumberAttributeTest
extends AbstractRegressionTest {
    public LineNumberAttributeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return LineNumberAttributeTest.buildAllCompliancesTestSuite(LineNumberAttributeTest.testClass());
    }

    public void test001() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX next;\n\n\tX(X next) {\n\t\tthis.next = next;\n\t}\n\n\tpublic static void main(String args[]) {\n\t\ttry {\n\t\t\tX x = new X(new X(new X(null)));\n\t\t\tx.\n\t\t\t\tnext.\n\t\t\t\t\tnext.\n\t\t\t\t\t\tnext.\n\t\t\t\t\t\t\tnext.\n\t\t\t\t\t\t\t\tnext.\n\t\t\t\t\t\t\t\t\ttoString();\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #19 ([Ljava/lang/String;)V\n  // Stack: 7, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  new X [1]\n     3  dup\n     4  new X [1]\n     7  dup\n     8  new X [1]\n    11  dup\n    12  aconst_null\n    13  invokespecial X(X) [20]\n    16  invokespecial X(X) [20]\n    19  invokespecial X(X) [20]\n    22  astore_1 [x]\n    23  aload_1 [x]\n    24  getfield X.next : X [13]\n    27  getfield X.next : X [13]\n    30  getfield X.next : X [13]\n    33  getfield X.next : X [13]\n    36  getfield X.next : X [13]\n    39  invokevirtual java.lang.Object.toString() : java.lang.String [22]\n    42  pop\n    43  goto 55\n    46  astore_1 [e]\n    47  getstatic java.lang.System.out : java.io.PrintStream [26]\n    50  ldc <String \"SUCCESS\"> [32]\n    52  invokevirtual java.io.PrintStream.println(java.lang.String) : void [34]\n    55  return\n      Exception Table:\n        [pc: 0, pc: 43] -> 46 when : java.lang.NullPointerException\n      Line numbers:\n        [pc: 0, line: 10]\n        [pc: 23, line: 11]\n        [pc: 24, line: 12]\n        [pc: 27, line: 13]\n        [pc: 30, line: 14]\n        [pc: 33, line: 15]\n        [pc: 36, line: 16]\n        [pc: 39, line: 17]\n        [pc: 43, line: 18]\n        [pc: 47, line: 19]\n        [pc: 55, line: 21]\n      Local variable table:\n        [pc: 0, pc: 56] local: args index: 0 type: java.lang.String[]\n        [pc: 23, pc: 43] local: x index: 1 type: X\n        [pc: 47, pc: 55] local: e index: 1 type: java.lang.NullPointerException\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            LineNumberAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test002() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX x;\n\n\tX next;\n\n\tX(X next) {\n\t\tthis.next = next;\n\t}\n\n\tpublic static void main(String args[]) {\n\t\tX x = new X(new X(new X(null)));\n\t\tx.x = x;\n\t\tx.foo();\n\t}\n\n\tpublic void foo() {\n\t\ttry {\n\t\t\tthis.\n\t\t\t\tx.\n\t\t\t\t\tnext.\n\t\t\t\t\t\tnext.\n\t\t\t\t\t\t\tnext.\n\t\t\t\t\t\t\t\tnext.\n\t\t\t\t\t\t\t\t\tnext.\n\t\t\t\t\t\t\t\t\t\ttoString();\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #13 ()V\n  // Stack: 2, Locals: 2\n  public void foo();\n     0  aload_0 [this]\n     1  getfield X.x : X [23]\n     4  getfield X.next : X [14]\n     7  getfield X.next : X [14]\n    10  getfield X.next : X [14]\n    13  getfield X.next : X [14]\n    16  getfield X.next : X [14]\n    19  invokevirtual java.lang.Object.toString() : java.lang.String [30]\n    22  pop\n    23  goto 35\n    26  astore_1 [e]\n    27  getstatic java.lang.System.out : java.io.PrintStream [34]\n    30  ldc <String \"SUCCESS\"> [40]\n    32  invokevirtual java.io.PrintStream.println(java.lang.String) : void [42]\n    35  return\n      Exception Table:\n        [pc: 0, pc: 23] -> 26 when : java.lang.NullPointerException\n      Line numbers:\n        [pc: 0, line: 18]\n        [pc: 1, line: 19]\n        [pc: 4, line: 20]\n        [pc: 7, line: 21]\n        [pc: 10, line: 22]\n        [pc: 13, line: 23]\n        [pc: 16, line: 24]\n        [pc: 19, line: 25]\n        [pc: 23, line: 26]\n        [pc: 27, line: 27]\n        [pc: 35, line: 29]\n      Local variable table:\n        [pc: 0, pc: 36] local: this index: 0 type: X\n        [pc: 27, pc: 35] local: e index: 1 type: java.lang.NullPointerException\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            LineNumberAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void testBug509027() throws Exception {
        this.runConformTest(new String[]{"linenumber/Test.java", "package linenumber;\n\npublic class Test {\n\tint[] f = { 1, // linebreak\n\t\t\t2 };\n}\n"});
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "linenumber" + File.separator + "Test.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #8 ()V\n  // Stack: 5, Locals: 1\n  public Test();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [10]\n     4  aload_0 [this]\n     5  iconst_2\n     6  newarray int [10]\n     8  dup\n     9  iconst_0\n    10  iconst_1\n    11  iastore\n    12  dup\n    13  iconst_1\n    14  iconst_2\n    15  iastore\n    16  putfield linenumber.Test.f : int[] [12]\n    19  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 4, line: 4]\n        [pc: 14, line: 5]\n        [pc: 19, line: 3]\n      Local variable table:\n        [pc: 0, pc: 20] local: this index: 0 type: linenumber.Test\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            LineNumberAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void testBug520714() throws Exception {
        this.runConformTest(new String[]{"TestAnon.java", "public class TestAnon {\n\tvoid f1() {\n\t\tnew Object() {\n\t\t};\n\t}\n}"});
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "TestAnon$1.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "     9  return\n      Line numbers:\n        [pc: 0, line: 3]\n      Local variable table:\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            LineNumberAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public static Class testClass() {
        return LineNumberAttributeTest.class;
    }
}

