/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.util.ManifestAnalyzer;

public class ManifestAnalyzerTest
extends AbstractRegressionTest {
    private static final String FIRST_JAR = "firstJar.jar";
    private static final String SECOND_JAR = "secondJar.jar";
    private static final String WHITESPACE = " ";
    ManifestAnalyzer manifestAnalyzer = new ManifestAnalyzer();

    public ManifestAnalyzerTest(String name) {
        super(name);
    }

    public void testWithOneJar() throws IOException {
        String testWithOneJar = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar\nBuild-Reference: Version toto";
        this.analyzeManifestContents(testWithOneJar);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)1, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
    }

    private void analyzeManifestContents(String contents) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes());){
            this.manifestAnalyzer.analyzeManifestContents((InputStream)stream);
        }
    }

    public void testWithOneJarWithWiteSpace() throws IOException {
        String testWithOneJarWithWiteSpace = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar \nBuild-Reference: Version toto";
        this.analyzeManifestContents(testWithOneJarWithWiteSpace);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)1, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
    }

    public void testWithSecondJarOnNextLine() throws IOException {
        String testWithSecondJarOnNextLine = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar\n  secondJar.jar\nBuild-Reference: Version toto";
        this.analyzeManifestContents(testWithSecondJarOnNextLine);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)2, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
        ManifestAnalyzerTest.assertEquals((Object)SECOND_JAR, jars.get(1));
    }

    public void testWithSecondJarOnTwoLine() throws IOException {
        String testWithSecondJarOnTwoLine = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar second\n Jar.jar\nBuild-Reference: Version toto";
        this.analyzeManifestContents(testWithSecondJarOnTwoLine);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)2, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
        ManifestAnalyzerTest.assertEquals((Object)SECOND_JAR, jars.get(1));
    }

    public void testWithSecondJarOnTwoLine2() throws IOException {
        String testWithSecondJarOnTwoLine = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar second\n  Jar.jar\nBuild-Reference: Version toto";
        this.analyzeManifestContents(testWithSecondJarOnTwoLine);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)3, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
        ManifestAnalyzerTest.assertEquals((Object)"second", jars.get(1));
        ManifestAnalyzerTest.assertEquals((Object)"Jar.jar", jars.get(2));
    }

    public void testWithSecondJarOnTwoLine3() throws IOException {
        String testWithSecondJarOnTwoLine = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar second\nJar.jar\nBuild-Reference: Version toto";
        this.analyzeManifestContents(testWithSecondJarOnTwoLine);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)2, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
        ManifestAnalyzerTest.assertEquals((Object)"second", jars.get(1));
    }

    public void testWithSecondJarOnTwoLine4() throws IOException {
        String testWithSecondJarOnTwoLine = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar\nsecond\n Jar.jar\nBuild-Reference: Version toto";
        this.analyzeManifestContents(testWithSecondJarOnTwoLine);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)1, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
    }

    public void testWithSecondJarOnNextLine5() throws IOException {
        String testWithSecondJarOnNextLine = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar\n secondJar.jar\nBuild-Reference: Version toto";
        this.analyzeManifestContents(testWithSecondJarOnNextLine);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)1, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)"firstJar.jarsecondJar.jar", jars.get(0));
    }

    public void testWithSecondJarOnTwoLineEndedWithEOF() throws IOException {
        String testWithSecondJarOnTwoLineEndedWithEOF = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar second\n Jar.jar";
        this.analyzeManifestContents(testWithSecondJarOnTwoLineEndedWithEOF);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)1, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
    }

    public void testWithSecondJarOnTwoLineEndedWithEOF2() throws IOException {
        String testWithSecondJarOnTwoLineEndedWithEOF = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar second\n Jar.jar\n";
        this.analyzeManifestContents(testWithSecondJarOnTwoLineEndedWithEOF);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)2, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
        ManifestAnalyzerTest.assertEquals((Object)SECOND_JAR, jars.get(1));
    }

    public void testWithSecondJarOnTwoLineEndedWithWhiteSpaceEOF() throws IOException {
        String testWithSecondJarOnTwoLineEndedWithWhiteSpaceEOF = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar second\n Jar.jar ";
        this.analyzeManifestContents(testWithSecondJarOnTwoLineEndedWithWhiteSpaceEOF);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)2, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
        ManifestAnalyzerTest.assertEquals((Object)SECOND_JAR, jars.get(1));
    }

    public void testWithSecondJarOnTwoLineEndedWithWhiteSpaceNewLineEOF() throws IOException {
        String testWithSecondJarOnTwoLineEndedWithWhiteSpaceNewLineEOF = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar second\n Jar.jar \n";
        this.analyzeManifestContents(testWithSecondJarOnTwoLineEndedWithWhiteSpaceNewLineEOF);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)2, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
        ManifestAnalyzerTest.assertEquals((Object)SECOND_JAR, jars.get(1));
    }

    public void testWithSecondJarOnTwoLineEndedWithNewLineEOF() throws IOException {
        String testWithSecondJarOnTwoLineEndedWithNewLineEOF = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.6.5\nCreated-By: 1.5.0_14-b03 (Sun Microsystems Inc.)\nClass-Path: firstJar.jar second\n Jar.jar\n";
        this.analyzeManifestContents(testWithSecondJarOnTwoLineEndedWithNewLineEOF);
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)2, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)FIRST_JAR, jars.get(0));
        ManifestAnalyzerTest.assertEquals((Object)SECOND_JAR, jars.get(1));
    }

    public void testWithOneJarUsingUTF8Name() throws IOException {
        try (InputStream inputStream = ManifestAnalyzerTest.class.getResourceAsStream("MANIFEST.MF");){
            this.manifestAnalyzer.analyzeManifestContents(inputStream);
        }
        List jars = this.manifestAnalyzer.getCalledFileNames();
        ManifestAnalyzerTest.assertEquals((String)"Wrong size", (int)1, (int)jars.size());
        ManifestAnalyzerTest.assertEquals((Object)"called\u3042.jar", jars.get(0));
    }
}

