/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractNullAnnotationTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class NullTypeAnnotationTest
extends AbstractNullAnnotationTest {
    public NullTypeAnnotationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return NullTypeAnnotationTest.buildMinimalComplianceTestSuite(NullTypeAnnotationTest.testClass(), 32);
    }

    public static Class testClass() {
        return NullTypeAnnotationTest.class;
    }

    public void test_nonnull_list_elements_01() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.List;\npublic class X {\n    void foo(List<@Nullable Object> l) {\n        System.out.print(l.get(0).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n    void bar(java.util.List<@Nullable Object> l) {\n        System.out.print(l.get(1).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.print(l.get(0).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n2. ERROR in X.java (at line 9)\n\tSystem.out.print(l.get(1).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n");
    }

    public void test_nonnull_list_elements_01a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "org.foo.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.NonNull");
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError, new String[]{"org/foo/Nullable.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface Nullable {\n}\n", "org/foo/NonNull.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface NonNull {\n}\n", "X.java", "import org.foo.*;\nimport java.util.List;\npublic class X {\n    void foo(List<@Nullable Object> l) {\n        System.out.print(l.get(0).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n    void bar(java.util.List<@Nullable Object> l) {\n        System.out.print(l.get(1).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.print(l.get(0).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n2. ERROR in X.java (at line 9)\n\tSystem.out.print(l.get(1).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n", null, true, customOptions);
    }

    public void test_nonnull_list_elements_02() {
        this.runNegativeTestWithLibs(new String[]{"Dummy.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface Dummy {\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.List;\npublic class X {\n    void foo(List<@Dummy @Nullable Object> l) {\n        System.out.print(l.get(0).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n    void bar(java.util.List<@Dummy @Nullable Object> l) {\n        System.out.print(l.get(1).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n    void bar2(java.util.List<java.lang.@Dummy @Nullable Object> l2) {\n        System.out.print(l2.get(1).toString()); // problem: retrieved element can be null\n        l2.add(null);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.print(l.get(0).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n2. ERROR in X.java (at line 9)\n\tSystem.out.print(l.get(1).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n3. ERROR in X.java (at line 13)\n\tSystem.out.print(l2.get(1).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n");
    }

    public void test_nonnull_list_elements_03() {
        this.runNegativeTestWithLibs(new String[]{"Dummy.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface Dummy {\n}\n", "p/List.java", "package p;\npublic interface List<T> {\n\tT get(int i);\n void add(T e);\n void add(int i, T e);\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\nimport p.List;\npublic class X {\n    void foo(@Nullable List<@NonNull Object> l) {\n        System.out.print(l.get(0).toString()); // problem: l may be null\n        l.add(null); // problem: cannot insert 'null' into this list\n    }\n    void bar(@Nullable List<java.lang.@NonNull Object> l) {\n        System.out.print(l.get(0).toString()); // problem: l may be null\n        l.add(0, null); // problem: cannot insert 'null' into this list\n    }\n    void bar2(@Dummy p.@Nullable List<java.lang.@NonNull Object> l2) {\n        System.out.print(l2.get(0).toString()); // problem: l2 may be null\n        l2.add(0, null); // problem: cannot insert 'null' into this list\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.print(l.get(0).toString()); // problem: l may be null\n\t                 ^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n2. ERROR in X.java (at line 6)\n\tl.add(null); // problem: cannot insert 'null' into this list\n\t      ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n3. ERROR in X.java (at line 9)\n\tSystem.out.print(l.get(0).toString()); // problem: l may be null\n\t                 ^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n4. ERROR in X.java (at line 10)\n\tl.add(0, null); // problem: cannot insert 'null' into this list\n\t         ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n5. ERROR in X.java (at line 13)\n\tSystem.out.print(l2.get(0).toString()); // problem: l2 may be null\n\t                 ^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n6. ERROR in X.java (at line 14)\n\tl2.add(0, null); // problem: cannot insert 'null' into this list\n\t          ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nestedType_01() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A<X> {\n    public class I<Y> {\n        X anX;\n        public X foo(Y l) {\n            return anX;\n        }\n        public I(X x) {\n            anX = x;\n        }\n    }\n    void bar(A<@Nullable Object>.I<@NonNull Object> i) {\n        @NonNull Object o = i.foo(null); // problems: argument and assignment violate null contracts\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 13)\n\t@NonNull Object o = i.foo(null); // problems: argument and assignment violate null contracts\n\t                    ^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable Object'\n----------\n2. ERROR in A.java (at line 13)\n\t@NonNull Object o = i.foo(null); // problems: argument and assignment violate null contracts\n\t                          ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nestedType_02() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "public class A<X> {\n    public abstract class I<Y> {\n        public abstract X foo(Y l);\n        public X idX(X in) { return in; }\n        public Y idY(Y in) { return in; }\n    }\n}\n", "B.java", "import org.eclipse.jdt.annotation.*;\npublic class B extends A<@NonNull Object> {\n    public class J extends I<@Nullable String> {\n        @Override\n        public @NonNull Object foo(@Nullable String l) {\n            System.out.print(idX(null));\n            return idY(null);\n        }\n    }\n}\n"}, "----------\n1. ERROR in B.java (at line 6)\n\tSystem.out.print(idX(null));\n\t                     ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in B.java (at line 7)\n\treturn idY(null);\n\t       ^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable String'\n----------\n");
    }

    public void test_nestedType_03() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "public class A<X> {\n    public abstract class I<Y> {\n        public abstract X foo(Y l);\n    }\n}\n", "B.java", "import org.eclipse.jdt.annotation.*;\npublic class B extends A<@NonNull Object> {\n    public class J extends I<@Nullable String> {\n        @Override\n        public @Nullable Object foo(@NonNull String l) {\n            return null;\n        }\n    }\n}\n"}, "----------\n1. ERROR in B.java (at line 5)\n\tpublic @Nullable Object foo(@NonNull String l) {\n\t       ^^^^^^^^^^^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from A<Object>.I<String>.foo(String) (mismatching null constraints)\n----------\n2. ERROR in B.java (at line 5)\n\tpublic @Nullable Object foo(@NonNull String l) {\n\t                            ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter l, inherited method from A<Object>.I<String> declares this parameter as @Nullable\n----------\n");
    }

    public void test_nestedType_04() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "public class A<X> {\n    public abstract class I<Y> {\n        public abstract X foo(Y l);\n    }\n}\n", "B.java", "import org.eclipse.jdt.annotation.*;\npublic class B {\n    public void foo(A<Object>.@Nullable I<@NonNull String> ai) {\n            ai.foo(null); // problems: ai can be null, arg must not be null\n    }\n}\n"}, "----------\n1. ERROR in B.java (at line 4)\n\tai.foo(null); // problems: ai can be null, arg must not be null\n\t^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n2. ERROR in B.java (at line 4)\n\tai.foo(null); // problems: ai can be null, arg must not be null\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void test_nestedType_05() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "public class A<X> {\n    public abstract class I<Y> {\n        public abstract X foo(Y l);\n    }\n}\n", "B.java", "import org.eclipse.jdt.annotation.*;\npublic class B {\n    public void foo(A<@NonNull Object>.@Nullable I<@NonNull String> ai1) {\n\t\tA<@Nullable Object>.@Nullable I<@NonNull String> ai2 = ai1;\n    }\n}\n"}, "----------\n1. ERROR in B.java (at line 4)\n\tA<@Nullable Object>.@Nullable I<@NonNull String> ai2 = ai1;\n\t                                                       ^^^\nNull type mismatch (type annotations): required 'A<@Nullable Object>.@Nullable I<@NonNull String>' but this expression has type 'A<@NonNull Object>.@Nullable I<@NonNull String>'\n----------\n");
    }

    public void testMissingAnnotationTypes_01() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic class U {}\n   @Missing1 X.@Missing2 U fU;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@Missing1 X.@Missing2 U fU;\n\t ^^^^^^^^\nMissing1 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\t@Missing1 X.@Missing2 U fU;\n\t             ^^^^^^^^\nMissing2 cannot be resolved to a type\n----------\n", this.LIBS, true);
    }

    public void testArrayType_01() {
        this.runNegativeTestWithLibs(new String[]{"Wrapper.java", "public class Wrapper<T> {\n\tT content;\tpublic Wrapper(T t) { content = t; }\n\tpublic T content() { return content; }\n}\n", "A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void bar(Wrapper<@NonNull String[]> realStrings, Wrapper<@Nullable String[]> maybeStrings) {\n        System.out.println(realStrings.content()[0].toUpperCase()); // no problem\n        realStrings.content()[0] = null; // problem: cannot assign null as @NonNull element\n        System.out.println(maybeStrings.content()[0].toUpperCase()); // problem: element can be null\n        maybeStrings.content()[0] = null; // no problem\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 5)\n\trealStrings.content()[0] = null; // problem: cannot assign null as @NonNull element\n\t                           ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. ERROR in A.java (at line 6)\n\tSystem.out.println(maybeStrings.content()[0].toUpperCase()); // problem: element can be null\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n");
    }

    public void testArrayType_02() {
        this.runNegativeTestWithLibs(new String[]{"Wrapper.java", "public class Wrapper<T> {\n\tT content;\tpublic Wrapper(T t) { content = t; }\n\tpublic T content() { return content; }\n}\n", "A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void bar(Wrapper<@NonNull String[][]> realStrings, Wrapper<@Nullable String[][]> maybeStrings) {\n        System.out.println(realStrings.content()[0][0].toUpperCase()); // no problem\n        realStrings.content()[0][0] = null; // problem: cannot assign null as @NonNull element\n        System.out.println(maybeStrings.content()[0][0].toUpperCase()); // problem: element can be null\n        maybeStrings.content()[0][0] = null; // no problem\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 5)\n\trealStrings.content()[0][0] = null; // problem: cannot assign null as @NonNull element\n\t                              ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. ERROR in A.java (at line 6)\n\tSystem.out.println(maybeStrings.content()[0][0].toUpperCase()); // problem: element can be null\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n");
    }

    public void testArrayType_03() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void array(String @NonNull[] realStringArray, String @Nullable[] maybeStringArray) {\n        @NonNull Object array;\n        array = realStringArray;  // no problem\n        realStringArray = null; \t // problem: cannot assign null as @NonNull array\n        array = maybeStringArray; // problem: array can be null\n        maybeStringArray = null;  // no problem\n    }\n    void leaf(String @NonNull[] realStringArray, String @Nullable[] maybeStringArray, boolean b) {\n        @NonNull String string;\n        string = realStringArray[0];  // problem: unchecked conversion\n        realStringArray[0] = null; \t // no problem\n        if (b)\n            string = maybeStringArray[0]; // problems: indexing nullable array & unchecked conversion\n        else\n            maybeStringArray[0] = null; \t // problem: indexing nullable array\n        maybeStringArray[0] = null; \t // problem protected by previous dereference\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 6)\n\trealStringArray = null; \t // problem: cannot assign null as @NonNull array\n\t                  ^^^^\nNull type mismatch: required 'String @NonNull[]' but the provided value is null\n----------\n2. ERROR in A.java (at line 7)\n\tarray = maybeStringArray; // problem: array can be null\n\t        ^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type 'String @Nullable[]'\n----------\n3. WARNING in A.java (at line 12)\n\tstring = realStringArray[0];  // problem: unchecked conversion\n\t         ^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n4. ERROR in A.java (at line 15)\n\tstring = maybeStringArray[0]; // problems: indexing nullable array & unchecked conversion\n\t         ^^^^^^^^^^^^^^^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n5. WARNING in A.java (at line 15)\n\tstring = maybeStringArray[0]; // problems: indexing nullable array & unchecked conversion\n\t         ^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n6. ERROR in A.java (at line 17)\n\tmaybeStringArray[0] = null; \t // problem: indexing nullable array\n\t^^^^^^^^^^^^^^^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n");
    }

    public void testArrayType_04() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void outer(String [] @NonNull[] realArrays, String [] @Nullable[] maybeArrays) {\n        @NonNull Object array;\n        array = realArrays; \t\t// problem: unchecked conversion\n        realArrays = null; \t\t// no problem, outer array is unspecified\n        array = maybeArrays; \t// problem: unchecked conversion\n        maybeArrays = null; \t\t// no problem\n    }\n    void inner(String [] @NonNull[] realArrays, String [] @Nullable[] maybeArrays) {\n        @NonNull Object array;\n        array = realArrays[0]; \t// no problem\n        realArrays[0] = null; \t// problem: cannot assign null to @NonNull array\n        array = maybeArrays[0]; \t// problem: element can be null\n        maybeArrays[0] = null; \t// no problem\n    }\n    void leaf(String [] @NonNull[] realArrays, String [] @Nullable[] maybeArrays) {\n        @NonNull Object array;\n        array = realArrays[0][0]; // problem: unchecked conversion\n        realArrays[0][0] = null;  // no problem, element type is unspecified\n        array = maybeArrays[0][0]; // problems: indexing nullable array & unchecked conversion\n        maybeArrays[0][0] = null; // problem: indexing nullable array\n    }\n}\n"}, "----------\n1. WARNING in A.java (at line 5)\n\tarray = realArrays; \t\t// problem: unchecked conversion\n\t        ^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String [] @NonNull[]' needs unchecked conversion to conform to '@NonNull Object'\n----------\n2. WARNING in A.java (at line 7)\n\tarray = maybeArrays; \t// problem: unchecked conversion\n\t        ^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String [] @Nullable[]' needs unchecked conversion to conform to '@NonNull Object'\n----------\n3. ERROR in A.java (at line 13)\n\trealArrays[0] = null; \t// problem: cannot assign null to @NonNull array\n\t                ^^^^\nNull type mismatch: required 'String @NonNull[]' but the provided value is null\n----------\n4. ERROR in A.java (at line 14)\n\tarray = maybeArrays[0]; \t// problem: element can be null\n\t        ^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type 'String @Nullable[]'\n----------\n5. WARNING in A.java (at line 19)\n\tarray = realArrays[0][0]; // problem: unchecked conversion\n\t        ^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull Object'\n----------\n6. ERROR in A.java (at line 21)\n\tarray = maybeArrays[0][0]; // problems: indexing nullable array & unchecked conversion\n\t        ^^^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n7. WARNING in A.java (at line 21)\n\tarray = maybeArrays[0][0]; // problems: indexing nullable array & unchecked conversion\n\t        ^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull Object'\n----------\n8. ERROR in A.java (at line 22)\n\tmaybeArrays[0][0] = null; // problem: indexing nullable array\n\t^^^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n");
    }

    public void testArrayType_05() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void outer(String @NonNull[] @NonNull[] realArrays, String @NonNull[] @Nullable[] maybeArrays, String @Nullable[][] unknownArrays) {\n        realArrays[0] = maybeArrays[0];\t\t// problem: inner array can be null\n        realArrays[0] = unknownArrays[0];\t// problems: inner array is unspecified, outer can be null\n    }\n    void oneDim(String @Nullable[] maybeStrings, String[] unknownStrings) {\n        String @NonNull[] s = maybeStrings;\n        s = unknownStrings;\n        consume(maybeStrings);\n        consume(unknownStrings);\n    }\n    void consume(String @NonNull[] s) {};\n}\n"}, "----------\n1. ERROR in A.java (at line 4)\n\trealArrays[0] = maybeArrays[0];\t\t// problem: inner array can be null\n\t                ^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[]' but this expression has type 'String @Nullable[]'\n----------\n2. ERROR in A.java (at line 5)\n\trealArrays[0] = unknownArrays[0];\t// problems: inner array is unspecified, outer can be null\n\t                ^^^^^^^^^^^^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n3. WARNING in A.java (at line 5)\n\trealArrays[0] = unknownArrays[0];\t// problems: inner array is unspecified, outer can be null\n\t                ^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to 'String @NonNull[]'\n----------\n4. ERROR in A.java (at line 8)\n\tString @NonNull[] s = maybeStrings;\n\t                      ^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[]' but this expression has type 'String @Nullable[]'\n----------\n5. WARNING in A.java (at line 9)\n\ts = unknownStrings;\n\t    ^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to 'String @NonNull[]'\n----------\n6. ERROR in A.java (at line 10)\n\tconsume(maybeStrings);\n\t        ^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[]' but this expression has type 'String @Nullable[]'\n----------\n7. WARNING in A.java (at line 11)\n\tconsume(unknownStrings);\n\t        ^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to 'String @NonNull[]'\n----------\n");
    }

    public void testArrayType_10() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void outer(String @NonNull[] @NonNull[] realArrays, String @NonNull[] @Nullable[] maybeArrays, String @Nullable[][] unknownArrays, String @NonNull[][] mixedArrays) {\n        realArrays = maybeArrays;\t\t\t// problem on inner dimension!\n        realArrays = unknownArrays; \t\t\t// problems on both dimensions\n        maybeArrays = realArrays;\t\t\t// problem on inner dimension\n        unknownArrays = maybeArrays;\t\t\t// no problem: outer @NonNull is compatible to expected @Nullable, inner @Nullable is compatible to inner unspecified\n        realArrays = mixedArrays;\t\t\t// problem on inner\n        maybeArrays = mixedArrays;\t\t\t// problem on inner\n        consume(maybeArrays, mixedArrays, maybeArrays);\n    }\n    void consume(String @NonNull[] @NonNull[] realStrings, String @NonNull[] @Nullable[] maybeArrays, String @Nullable[][] unknownArrays) {\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 4)\n\trealArrays = maybeArrays;\t\t\t// problem on inner dimension!\n\t             ^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[] @NonNull[]' but this expression has type 'String @NonNull[] @Nullable[]'\n----------\n2. ERROR in A.java (at line 5)\n\trealArrays = unknownArrays; \t\t\t// problems on both dimensions\n\t             ^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[] @NonNull[]' but this expression has type 'String @Nullable[] []'\n----------\n3. ERROR in A.java (at line 6)\n\tmaybeArrays = realArrays;\t\t\t// problem on inner dimension\n\t              ^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[] @Nullable[]' but this expression has type 'String @NonNull[] @NonNull[]'\n----------\n4. WARNING in A.java (at line 8)\n\trealArrays = mixedArrays;\t\t\t// problem on inner\n\t             ^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String @NonNull[] []' needs unchecked conversion to conform to 'String @NonNull[] @NonNull[]'\n----------\n5. WARNING in A.java (at line 9)\n\tmaybeArrays = mixedArrays;\t\t\t// problem on inner\n\t              ^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String @NonNull[] []' needs unchecked conversion to conform to 'String @NonNull[] @Nullable[]'\n----------\n6. ERROR in A.java (at line 10)\n\tconsume(maybeArrays, mixedArrays, maybeArrays);\n\t        ^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[] @NonNull[]' but this expression has type 'String @NonNull[] @Nullable[]'\n----------\n7. WARNING in A.java (at line 10)\n\tconsume(maybeArrays, mixedArrays, maybeArrays);\n\t                     ^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String @NonNull[] []' needs unchecked conversion to conform to 'String @NonNull[] @Nullable[]'\n----------\n");
    }

    public void testArrayType_11() {
        this.runNegativeTestWithLibs(new String[]{"ArrayTest.java", "import org.eclipse.jdt.annotation.*;\n\npublic class ArrayTest {\n\t\n\t@NonNull Object @NonNull[] test1(@NonNull Object @Nullable[] in) {\n\t\tif (in == null) throw new NullPointerException(); \n\t\treturn in; // array needs check, element is OK\n\t}\n\t@NonNull Object @NonNull[] test2(@Nullable Object @Nullable[] in) {\n\t\tif (in == null) throw new NullPointerException(); \n\t\treturn in; // array needs check, element is NOK\n\t}\n\t@NonNull Object @NonNull[]@NonNull[] test3(@NonNull Object @Nullable[][] in) {\n\t\tif (in == null) throw new NullPointerException(); \n\t\treturn in; // outer needs check, inner is unchecked, element is OK\n\t}\n\t@NonNull Object @NonNull[]@NonNull[] test4(@Nullable Object @Nullable[][] in) {\n\t\tif (in == null) throw new NullPointerException(); \n\t\treturn in; // outer needs check, inner is unchecked, element is NOK\n\t}\n\t@NonNull Object @NonNull[]@NonNull[] test5(@NonNull Object @Nullable[]@Nullable[] in) {\n\t\tif (in == null) throw new NullPointerException(); \n\t\treturn in; // outer needs check, inner is NOK, element is OK\n\t}\n\t@NonNull Object @NonNull[]@NonNull[] test6(@NonNull Object @Nullable[]@NonNull[] in) {\n\t\tif (in == null) throw new NullPointerException(); \n\t\treturn in; // outer needs check, inner is OK, element is OK\n\t}\n}\n"}, "----------\n1. ERROR in ArrayTest.java (at line 11)\n\treturn in; // array needs check, element is NOK\n\t       ^^\nNull type mismatch (type annotations): required '@NonNull Object @NonNull[]' but this expression has type '@Nullable Object @Nullable[]'\n----------\n2. WARNING in ArrayTest.java (at line 15)\n\treturn in; // outer needs check, inner is unchecked, element is OK\n\t       ^^\nNull type safety (type annotations): The expression of type '@NonNull Object @Nullable[] []' needs unchecked conversion to conform to '@NonNull Object @NonNull[] @NonNull[]'\n----------\n3. ERROR in ArrayTest.java (at line 19)\n\treturn in; // outer needs check, inner is unchecked, element is NOK\n\t       ^^\nNull type mismatch (type annotations): required '@NonNull Object @NonNull[] @NonNull[]' but this expression has type '@Nullable Object @Nullable[] []'\n----------\n4. ERROR in ArrayTest.java (at line 23)\n\treturn in; // outer needs check, inner is NOK, element is OK\n\t       ^^\nNull type mismatch (type annotations): required '@NonNull Object @NonNull[] @NonNull[]' but this expression has type '@NonNull Object @Nullable[] @Nullable[]'\n----------\n");
    }

    public void testBug403216_1() {
        this.runConformTestWithLibs(new String[]{"Test.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\npublic class Test {}\n\nclass X {\n\tclass Y {\n\t\tpublic void foo( @A X. @B Y this) {}\n\t}\n}\n@Target(value={ElementType.TYPE_USE})\n@interface A {}\n@Target(value={ElementType.TYPE_USE})\n@interface B {}\n"}, null, "");
    }

    public void testBug403216_2() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n    void test(List<@NonNull String> strings) {\n        List<String> someStrings;\n        someStrings = strings;\n    }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug403216_3a() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.*;\n\npublic class Test {}\n\nclass X {\n\tclass Y {\n\t\tpublic void foo( @A X. @NonNull Y this) {}\n\t}\n}\n@Target(value={ElementType.TYPE_USE})\n@interface A {}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Test.java (at line 9)\n\tpublic void foo( @A X. @NonNull Y this) {}\n\t                 ^^^^^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n");
    }

    public void testBug403216_3b() {
        this.runConformTestWithLibs(new String[]{"Test.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\npublic class Test {}\n\nclass X {\n\tclass Y {\n\t\tpublic void foo( @A X. @A Y this) {}\n\t}\n}\n@Target(value={ElementType.TYPE_USE})\n@interface A {}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug403457_1() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.*;\n\npublic class X {\n\tvoid foo(Map<@Marker ? super @Marker Object, @Marker ? extends @Marker String> m){}\n   void goo(Map<@Marker ? extends @Marker Object, @Marker ? super @Marker String> m){}\n}\n\n@Target(ElementType.TYPE_USE)\n@interface Marker {\n\t\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tvoid foo(Map<@Marker ? super @Marker Object, @Marker ? extends @Marker String> m){}\n\t         ^^^\nMap cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 7)\n\tvoid goo(Map<@Marker ? extends @Marker Object, @Marker ? super @Marker String> m){}\n\t         ^^^\nMap cannot be resolved to a type\n----------\n", this.LIBS, true);
    }

    public void testBug403457_2() {
        this.runNegativeTest(new String[]{"X.java", "// import java.util.Map;\nimport org.eclipse.jdt.annotation.*;\n\npublic class X {\n\tvoid foo(Map<@Nullable ? super @Nullable Object, @Nullable ? extends @Nullable String> m){}\n   void goo(Map<@Nullable ? extends @Nullable Object, @Nullable ? super @Nullable String> m){}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo(Map<@Nullable ? super @Nullable Object, @Nullable ? extends @Nullable String> m){}\n\t         ^^^\nMap cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\tvoid goo(Map<@Nullable ? extends @Nullable Object, @Nullable ? super @Nullable String> m){}\n\t         ^^^\nMap cannot be resolved to a type\n----------\n", this.LIBS, true);
    }

    public void testBinary01() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runConformTestWithLibs(new String[]{"p/X.java", "package p;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n\tpublic List<@Nullable String> getSomeStrings() { return null; }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import p.X;\npublic class Y {\n\tpublic void test(X x) {\n\t\tString s0 = x.getSomeStrings().get(0);\n\t\tSystem.out.println(s0.toUpperCase());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y.java (at line 5)\n\tSystem.out.println(s0.toUpperCase());\n\t                   ^^\nPotential null pointer access: The variable s0 may be null at this location\n----------\n");
    }

    public void testBinary02() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runConformTestWithLibs(new String[]{"p/X.java", "package p;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.*;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target(TYPE_USE)\n@interface Immutable {}\npublic class X {\n\tpublic void setAllStrings(@Immutable X this, int dummy, List<@NonNull String> ss) { }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import p.X;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.*;\npublic class Y {\n\tpublic void test(X x, List<@Nullable String> ss) {\n\t\tx.setAllStrings(-1, ss);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y.java (at line 6)\n\tx.setAllStrings(-1, ss);\n\t                    ^^\nNull type mismatch (type annotations): required 'List<@NonNull String>' but this expression has type 'List<@Nullable String>'\n----------\n");
    }

    public void testBinary03() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 {\n\tpublic static String @Nullable [] f1 = null;\n\tpublic static String [] @Nullable [] f2 = new String[] @Nullable[] { null };\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\npublic class Y1 {\n\tpublic void test() {\n\t\tSystem.out.println(p.X1.f1.length);\n\t\tSystem.out.println(X1.f2[0].length);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 4)\n\tSystem.out.println(p.X1.f1.length);\n\t                        ^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n2. ERROR in Y1.java (at line 5)\n\tSystem.out.println(X1.f2[0].length);\n\t                   ^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n");
    }

    public void testBinary04() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\n@SuppressWarnings(\"serial\")\npublic abstract class X1 extends ArrayList<@Nullable String> {\n}\n", "p/X2.java", "package p;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X2 implements List<@Nullable String> {\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\npublic class Y1 {\n\tpublic void test(X1 x) {\n\t\tString s0 = x.get(0);\n\t\tSystem.out.println(s0.toUpperCase());\n\t}\n}\n", "Y2.java", "import p.X2;\npublic class Y2 {\n\tpublic void test(X2 x) {\n\t\tString s0 = x.get(0);\n\t\tSystem.out.println(s0.toUpperCase());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 5)\n\tSystem.out.println(s0.toUpperCase());\n\t                   ^^\nPotential null pointer access: The variable s0 may be null at this location\n----------\n----------\n1. ERROR in Y2.java (at line 5)\n\tSystem.out.println(s0.toUpperCase());\n\t                   ^^\nPotential null pointer access: The variable s0 may be null at this location\n----------\n");
    }

    public void testBinary05() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\n@SuppressWarnings(\"serial\")\npublic abstract class X1<@NonNull T> extends ArrayList<T> {\n    public <@Nullable S> void foo(S s) {}\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\nimport org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tX1<@Nullable String> maybeStrings;\n\tvoid test(X1<@NonNull String> x) {\n\t\tx.<@NonNull Object>foo(new Object());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 4)\n\tX1<@Nullable String> maybeStrings;\n\t   ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter '@NonNull T extends Object'\n----------\n2. ERROR in Y1.java (at line 6)\n\tx.<@NonNull Object>foo(new Object());\n\t   ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Object' is not a valid substitute for the type parameter '@Nullable S extends Object'\n----------\n");
    }

    public void testBinary06() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\n@SuppressWarnings(\"serial\")\npublic abstract class X1<T extends @NonNull Object> extends ArrayList<T> {\n    public <U, V extends @Nullable Object> void foo(U u, V v) {}\n}\n", "p/X2.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X2<@NonNull W extends @Nullable Object> {}\n"}, customOptions, "----------\n1. ERROR in p\\X2.java (at line 3)\n\tpublic class X2<@NonNull W extends @Nullable Object> {}\n\t                                   ^^^^^^^^^\nThis nullness annotation conflicts with a '@NonNull' annotation which is effective on the same type parameter \n----------\n");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\n@SuppressWarnings(\"serial\")\npublic abstract class X1<T extends @NonNull Object> extends ArrayList<T> {\n    public <U, V extends @Nullable Object> void foo(U u, V v) {}\n}\n", "p/X2.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X2<@Nullable W extends Object> {}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\nimport p.X2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tX1<@Nullable String> maybeStrings;\n   X2<@NonNull String> strings;\n\tvoid test(X1<@NonNull String> x) {\n\t\tx.<Y1, @NonNull Object>foo(this, new Object());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 5)\n\tX1<@Nullable String> maybeStrings;\n\t   ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter 'T extends @NonNull Object'\n----------\n2. ERROR in Y1.java (at line 6)\n\tX2<@NonNull String> strings;\n\t   ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable W extends Object'\n----------\n");
    }

    public void testBinary06b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\n@SuppressWarnings(\"serial\")\npublic abstract class X1<T extends java.lang.@NonNull Object> extends ArrayList<T> {\n    public <U, V extends java.lang.@Nullable Object> void foo(U u, V v) {}\n}\n", "p/X2.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X2<@NonNull W extends java.lang.@Nullable Object> {}\n"}, customOptions, "----------\n1. ERROR in p\\X2.java (at line 3)\n\tpublic class X2<@NonNull W extends java.lang.@Nullable Object> {}\n\t                                             ^^^^^^^^^\nThis nullness annotation conflicts with a '@NonNull' annotation which is effective on the same type parameter \n----------\n");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\n@SuppressWarnings(\"serial\")\npublic abstract class X1<T extends java.lang.@NonNull Object> extends ArrayList<T> {\n    public <U, V extends java.lang.@Nullable Object> void foo(U u, V v) {}\n}\n", "p/X2.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X2<@Nullable W extends Object> {}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tp.X1<java.lang.@Nullable String> maybeStrings;\n   p.X2<java.lang.@NonNull String> strings;\n\tvoid test(p.X1<java.lang.@NonNull String> x) {\n\t\tx.<Y1, java.lang.@NonNull Object>foo(this, new Object());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 3)\n\tp.X1<java.lang.@Nullable String> maybeStrings;\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter 'T extends @NonNull Object'\n----------\n2. ERROR in Y1.java (at line 4)\n\tp.X2<java.lang.@NonNull String> strings;\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable W extends Object'\n----------\n");
    }

    public void testBinary07() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTestWithLibs(new String[]{"p/List.java", "package p;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic interface List<T> {\n\tT get(int i);\n}\n", "p/X1.java", "package p;\nimport java.util.Map;\nimport p.List;\nimport org.eclipse.jdt.annotation.*;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target(TYPE_USE)\n@interface Immutable {}\npublic abstract class X1 {\n    public <@NonNull U, V extends @Nullable Object> List<@NonNull Map<Object, @NonNull String>> foo(@Immutable X1 this, U u, V v) { return null; }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\nimport org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tvoid test(X1 x) {\n\t\tx.<@NonNull Y1, @NonNull Object>foo(this, new Object())\n\t\t\t.get(0).put(null, null);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 6)\n\t.get(0).put(null, null);\n\t                  ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBinary08() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 {\n    public class Inner {}\n    public Object []@NonNull[] arrays(Object @NonNull[][] oa1) { return null; }\n    public void nesting(@NonNull Inner i1, X1.@Nullable Inner i2) { }\n    public void wildcard1(List<@Nullable ? extends @NonNull X1> l) { } // contradiction\n    public void wildcard2(List<? super @NonNull X1> l) { }\n}\n"}, customOptions, "----------\n1. ERROR in p\\X1.java (at line 8)\n\tpublic void wildcard1(List<@Nullable ? extends @NonNull X1> l) { } // contradiction\n\t                                               ^^^^^^^^\nThis nullness annotation conflicts with a '@Nullable' annotation which is effective on the same type parameter \n----------\n");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 {\n    public class Inner {}\n    public Object []@NonNull[] arrays(Object @NonNull[][] oa1) { return null; }\n    public void nesting(@NonNull Inner i1, X1.@Nullable Inner i2) { }\n    public void wildcard1(List<@Nullable ? extends X1> l) { }\n    public void wildcard2(List<? super @NonNull X1> l) { }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\nimport org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Y1 {\n\tvoid test(X1 x) {\n\t\tObject @NonNull[][] a = new Object[0][]; // safe: new is never null\n\t\tx.arrays(a)[0] = null; // illegal\n\t\tx.nesting(null, null); // 1st null is illegal\n\t\tx.wildcard2(new ArrayList<@NonNull Object>());\n\t\tx.wildcard2(new ArrayList<@Nullable Object>()); // OK\n\t\tx.wildcard1(new ArrayList<@NonNull X1>()); // incompatible\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 7)\n\tx.arrays(a)[0] = null; // illegal\n\t                 ^^^^\nNull type mismatch: required 'Object @NonNull[]' but the provided value is null\n----------\n2. ERROR in Y1.java (at line 8)\n\tx.nesting(null, null); // 1st null is illegal\n\t          ^^^^\nNull type mismatch: required 'X1.@NonNull Inner' but the provided value is null\n----------\n3. ERROR in Y1.java (at line 11)\n\tx.wildcard1(new ArrayList<@NonNull X1>()); // incompatible\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@Nullable ? extends X1>' but this expression has type 'ArrayList<@NonNull X1>', corresponding supertype is 'List<@NonNull X1>'\n----------\n");
    }

    public void testBinary08b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTestWithLibs(new String[]{"p/X1.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 {\n    public class Inner {}\n    public java.lang.Object []@NonNull[] arrays(java.lang.Object @NonNull[][] oa1) { return null; }\n    public void nesting(@NonNull Inner i1, X1.@Nullable Inner i2) { }\n    public void wildcard1(java.util.List<@Nullable ? extends p.@NonNull X1> l) { } // contradiction\n    public void wildcard2(java.util.List<? super p.@NonNull X1> l) { }\n}\n"}, customOptions, "----------\n1. ERROR in p\\X1.java (at line 7)\n\tpublic void wildcard1(java.util.List<@Nullable ? extends p.@NonNull X1> l) { } // contradiction\n\t                                                           ^^^^^^^^\nThis nullness annotation conflicts with a '@Nullable' annotation which is effective on the same type parameter \n----------\n");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 {\n    public class Inner {}\n    public java.lang.Object []@NonNull[] arrays(java.lang.Object @NonNull[][] oa1) { return null; }\n    public void nesting(@NonNull Inner i1, p.X1.@Nullable Inner i2) { }\n    public void wildcard1(List<@Nullable ? extends p.X1> l) { }\n    public void wildcard2(List<? super p.@NonNull X1> l) { }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\nimport org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Y1 {\n\tvoid test(X1 x) {\n\t\tjava.lang.Object @NonNull[][] a = new java.lang.Object[0][]; // safe: new is never null\n\t\tx.arrays(a)[0] = null; // illegal\n\t\tx.nesting(null, null); // 1st null is illegal\n\t\tx.wildcard2(new ArrayList<java.lang.@NonNull Object>());\n\t\tx.wildcard2(new ArrayList<java.lang.@Nullable Object>());\n\t\tx.wildcard1(new ArrayList<p.@NonNull X1>()); // incompatible\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 7)\n\tx.arrays(a)[0] = null; // illegal\n\t                 ^^^^\nNull type mismatch: required 'Object @NonNull[]' but the provided value is null\n----------\n2. ERROR in Y1.java (at line 8)\n\tx.nesting(null, null); // 1st null is illegal\n\t          ^^^^\nNull type mismatch: required 'X1.@NonNull Inner' but the provided value is null\n----------\n3. ERROR in Y1.java (at line 11)\n\tx.wildcard1(new ArrayList<p.@NonNull X1>()); // incompatible\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@Nullable ? extends X1>' but this expression has type 'ArrayList<@NonNull X1>', corresponding supertype is 'List<@NonNull X1>'\n----------\n");
    }

    public void testBinary09() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\npublic class X {\n\t@NonNull String @Nullable [] f @NonNull [] = null;\n\tstatic void foo(@NonNull String @Nullable [] p @NonNull []) {\n\t\tp = null;\n\t\t@NonNull String @Nullable [] l @NonNull [] = null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@NonNull String @Nullable [] f @NonNull [] = null;\n\t                                             ^^^^\nNull type mismatch: required '@NonNull String @NonNull[] @Nullable[]' but the provided value is null\n----------\n2. ERROR in X.java (at line 6)\n\tp = null;\n\t    ^^^^\nNull type mismatch: required '@NonNull String @NonNull[] @Nullable[]' but the provided value is null\n----------\n3. ERROR in X.java (at line 7)\n\t@NonNull String @Nullable [] l @NonNull [] = null;\n\t                                             ^^^^\nNull type mismatch: required '@NonNull String @NonNull[] @Nullable[]' but the provided value is null\n----------\n");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\npublic class X {\n\t@NonNull String @Nullable [] f @NonNull [] = new @NonNull String @NonNull [0] @Nullable [];\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n\tvoid test(X x) {\n       x.f = null;\n       x.f[0] = null;\n       x.f[0][0] = null;\n\t}\n}\n"}, customOptions, "----------\n1. WARNING in Y.java (at line 1)\n\timport org.eclipse.jdt.annotation.*;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import org.eclipse.jdt.annotation is never used\n----------\n2. ERROR in Y.java (at line 4)\n\tx.f = null;\n\t      ^^^^\nNull type mismatch: required '@NonNull String @NonNull[] @Nullable[]' but the provided value is null\n----------\n3. ERROR in Y.java (at line 6)\n\tx.f[0][0] = null;\n\t^^^^^^\nPotential null pointer access: array element may be null\n----------\n4. ERROR in Y.java (at line 6)\n\tx.f[0][0] = null;\n\t            ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBinary10() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class X  {\n\tvoid foo(ArrayList<String> @NonNull [] p) {\n\t}\n}\nclass Y extends X {\n\tvoid foo() {\n\t\tsuper.foo(null);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tsuper.foo(null);\n\t          ^^^^\nNull type mismatch: required 'ArrayList<String> @NonNull[]' but the provided value is null\n----------\n");
        this.runConformTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class X  {\n\tvoid foo(ArrayList<String> @NonNull [] p) {\n\t}\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "public class Y extends X {\n\tvoid foo() {\n\t\tsuper.foo(null);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y.java (at line 3)\n\tsuper.foo(null);\n\t          ^^^^\nNull type mismatch: required 'ArrayList<String> @NonNull[]' but the provided value is null\n----------\n");
    }

    public void testConditional1() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<@NonNull String> foo(List<@NonNull String> good, List<String> dubious, int f) {\n\t\tif (f < 2)\n\t\t\treturn f == 0 ? good : dubious;\n\t\tif (f < 4)\n\t\t\treturn f == 2 ? dubious : good;\n\t\tif (f < 6)\n\t\t\treturn f == 4 ? good : good;\n\t\treturn null;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 6)\n\treturn f == 0 ? good : dubious;\n\t                       ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n2. WARNING in X.java (at line 8)\n\treturn f == 2 ? dubious : good;\n\t                ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n");
    }

    public void testConditional2() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<@NonNull String> foo(List<@NonNull String> good, ArrayList<String> dubious, int f) {\n\t\tif (f < 2)\n\t\t\treturn f == 0 ? good : dubious;\n\t\tif (f < 4)\n\t\t\treturn f == 2 ? dubious : good;\n\t\tif (f < 6)\n\t\t\treturn f == 4 ? good : good;\n\t\treturn null;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 6)\n\treturn f == 0 ? good : dubious;\n\t                       ^^^^^^^\nNull type safety (type annotations): The expression of type 'ArrayList<String>' needs unchecked conversion to conform to 'List<@NonNull String>', corresponding supertype is 'List<String>'\n----------\n2. WARNING in X.java (at line 8)\n\treturn f == 2 ? dubious : good;\n\t                ^^^^^^^\nNull type safety (type annotations): The expression of type 'ArrayList<String>' needs unchecked conversion to conform to 'List<@NonNull String>', corresponding supertype is 'List<String>'\n----------\n");
    }

    public void testConditional3() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tvoid foo(List<@NonNull String> good, List<String> dubious, int f) {\n\t\tconsume(f == 0 ? good : dubious);\n\t\tconsume(f == 2 ? dubious : good);\n\t\tconsume(f == 4 ? good : good);\n\t}\n\tvoid consume(List<@NonNull String> strings) {}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 5)\n\tconsume(f == 0 ? good : dubious);\n\t                        ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n2. WARNING in X.java (at line 6)\n\tconsume(f == 2 ? dubious : good);\n\t                 ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n");
    }

    public void testCompatibility1() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<@NonNull String> return1(List<@NonNull String> noNulls) {\n\t\treturn noNulls;\n\t}\n\tList<@Nullable String> return2(List<@Nullable String> withNulls) {\n\t\treturn withNulls;\n\t}\n\tvoid assigns(List<@NonNull String> noNulls, List<String> dubious, List<@Nullable String> withNulls) {\n\t\tList<@NonNull String> l1 = noNulls;\n\t\tList<@Nullable String> l2 = withNulls;\n\t\tList<String> l3 = dubious;\n\t}\n\tvoid arguments(List<@NonNull String> noNulls, List<String> dubious, List<@Nullable String> withNulls) {\n\t\tassigns(noNulls, dubious, withNulls);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testCompatibility1a() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull String[] return1(@NonNull String[] noNulls) {\n\t\treturn noNulls;\n\t}\n\t@Nullable String[] return2(@Nullable String[] noNulls) {\n\t\treturn noNulls;\n\t}\n\tvoid assigns(@NonNull String[] noNulls, String dubious[], @Nullable String[] withNulls) {\n\t\t@NonNull String[] l1 = noNulls;\n\t\t@Nullable String[] l2 = withNulls;\n\t\tString[] l3 = dubious;\n\t}\n\tvoid arguments(@NonNull String[] noNulls, String[] dubious, @Nullable String[] withNulls) {\n\t\tassigns(noNulls, dubious, withNulls);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testCompatibility2() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<String> return1(List<@NonNull String> noNulls) {\n\t\treturn noNulls;\n\t}\n\tList<String> return2(List<String> dubious) {\n\t\treturn dubious;\n\t}\n\tList<String> return3(List<@Nullable String> withNulls) {\n\t\treturn withNulls;\n\t}\n\tvoid assigns(List<@NonNull String> noNulls, List<String> dubious, List<@Nullable String> withNulls) {\n\t\tList<String> l1 = noNulls;\n\t\tList<String> l2 = dubious;\n\t\tList<String> l3 = withNulls;\n\t}\n\tvoid arguments(List<@NonNull String> noNulls, List<String> dubious, List<@Nullable String> withNulls) {\n\t\ttakeAny(noNulls);\n\t\ttakeAny(dubious);\n\t\ttakeAny(withNulls);\n\t}\n\tvoid takeAny(List<String> any) {}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testCompatibility2a() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tString[] return1(@NonNull String[] noNulls) {\n\t\treturn noNulls;\n\t}\n\tString[] return2(String[] dubious) {\n\t\treturn dubious;\n\t}\n\tString[] return3(@Nullable String[] withNulls) {\n\t\treturn withNulls;\n\t}\n\tvoid assigns(@NonNull String[] noNulls, String[] dubious, @Nullable String[] withNulls) {\n\t\tString[] l1 = noNulls;\n\t\tString[] l2 = dubious;\n\t\tString[] l3 = withNulls;\n\t}\n\tvoid arguments(@NonNull String[] noNulls, String[] dubious, @Nullable String[] withNulls) {\n\t\ttakeAny(noNulls);\n\t\ttakeAny(dubious);\n\t\ttakeAny(withNulls);\n\t}\n\tvoid takeAny(String[] any) {}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testCompatibility3() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<@NonNull String> return1(List<String> dubious) {\n\t\treturn dubious;\n\t}\n\tList<@Nullable String> return2(List<String> dubious) {\n\t\treturn dubious;\n\t}\n\tvoid assigns(List<String> dubious) {\n\t\tList<@Nullable String> l1 = dubious;\n\t\tList<@NonNull String> l2 = dubious;\n\t}\n\tvoid arguments(List<String> dubious) {\n\t\tacceptNulls(dubious);\n\t\tacceptNoNulls(dubious);\n\t}\n\tvoid acceptNulls(List<@NonNull String> noNulls) {}\n\tvoid acceptNoNulls(List<@NonNull String> noNulls) {}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 5)\n\treturn dubious;\n\t       ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n2. WARNING in X.java (at line 8)\n\treturn dubious;\n\t       ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@Nullable String>'\n----------\n3. WARNING in X.java (at line 11)\n\tList<@Nullable String> l1 = dubious;\n\t                            ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@Nullable String>'\n----------\n4. WARNING in X.java (at line 12)\n\tList<@NonNull String> l2 = dubious;\n\t                           ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n5. WARNING in X.java (at line 15)\n\tacceptNulls(dubious);\n\t            ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n6. WARNING in X.java (at line 16)\n\tacceptNoNulls(dubious);\n\t              ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n");
    }

    public void testCompatibility3a() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull String[] return1(String[] dubious) {\n\t\treturn dubious;\n\t}\n\t@Nullable String[] return2(String[] dubious) {\n\t\treturn dubious;\n\t}\n\tvoid assigns(String[] dubious) {\n\t\t@Nullable String[] l1 = dubious;\n\t\t@NonNull String[] l2 = dubious;\n\t}\n\tvoid arguments(String[] dubious) {\n\t\tacceptNulls(dubious);\n\t\tacceptNoNulls(dubious);\n\t}\n\tvoid acceptNulls(@Nullable String[] withNulls) {}\n\tvoid acceptNoNulls(@NonNull String[] noNulls) {}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 4)\n\treturn dubious;\n\t       ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@NonNull String []'\n----------\n2. WARNING in X.java (at line 7)\n\treturn dubious;\n\t       ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@Nullable String []'\n----------\n3. WARNING in X.java (at line 10)\n\t@Nullable String[] l1 = dubious;\n\t                        ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@Nullable String []'\n----------\n4. WARNING in X.java (at line 11)\n\t@NonNull String[] l2 = dubious;\n\t                       ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@NonNull String []'\n----------\n5. WARNING in X.java (at line 14)\n\tacceptNulls(dubious);\n\t            ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@Nullable String []'\n----------\n6. WARNING in X.java (at line 15)\n\tacceptNoNulls(dubious);\n\t              ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@NonNull String []'\n----------\n");
    }

    public void testCompatibility4() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<@Nullable String> return1(List<@NonNull String> noNulls) {\n\t\treturn noNulls;\n\t}\n\tList<@NonNull String> return2(List<@Nullable String> withNulls) {\n\t\treturn withNulls;\n\t}\n\tvoid assigns(List<@NonNull String> noNulls, List<@Nullable String> withNulls) {\n\t\tList<@NonNull String> l1 = withNulls;\n\t\tList<@Nullable String> l2 = noNulls;\n\t}\n\tvoid arguments(List<@NonNull String> noNulls, List<@Nullable String> withNulls) {\n\t\tassigns(withNulls, noNulls);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn noNulls;\n\t       ^^^^^^^\nNull type mismatch (type annotations): required 'List<@Nullable String>' but this expression has type 'List<@NonNull String>'\n----------\n2. ERROR in X.java (at line 8)\n\treturn withNulls;\n\t       ^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull String>' but this expression has type 'List<@Nullable String>'\n----------\n3. ERROR in X.java (at line 11)\n\tList<@NonNull String> l1 = withNulls;\n\t                           ^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull String>' but this expression has type 'List<@Nullable String>'\n----------\n4. ERROR in X.java (at line 12)\n\tList<@Nullable String> l2 = noNulls;\n\t                            ^^^^^^^\nNull type mismatch (type annotations): required 'List<@Nullable String>' but this expression has type 'List<@NonNull String>'\n----------\n5. ERROR in X.java (at line 15)\n\tassigns(withNulls, noNulls);\n\t        ^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull String>' but this expression has type 'List<@Nullable String>'\n----------\n6. ERROR in X.java (at line 15)\n\tassigns(withNulls, noNulls);\n\t                   ^^^^^^^\nNull type mismatch (type annotations): required 'List<@Nullable String>' but this expression has type 'List<@NonNull String>'\n----------\n");
    }

    public void testCompatibility4a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@Nullable String[] return1(@NonNull String[] noNulls) {\n\t\treturn noNulls;\n\t}\n\t@NonNull String[] return2(@Nullable String[] withNulls) {\n\t\treturn withNulls;\n\t}\n\tvoid assigns(@NonNull String[] noNulls, @Nullable String[] withNulls) {\n\t\t@NonNull String[] l1 = withNulls;\n\t\t@Nullable String[] l2 = noNulls;\n\t}\n\tvoid arguments(@NonNull String[] noNulls, @Nullable String[] withNulls) {\n\t\tassigns(withNulls, noNulls);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn noNulls;\n\t       ^^^^^^^\nNull type mismatch (type annotations): required '@Nullable String []' but this expression has type '@NonNull String []'\n----------\n2. ERROR in X.java (at line 7)\n\treturn withNulls;\n\t       ^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String []' but this expression has type '@Nullable String []'\n----------\n3. ERROR in X.java (at line 10)\n\t@NonNull String[] l1 = withNulls;\n\t                       ^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String []' but this expression has type '@Nullable String []'\n----------\n4. ERROR in X.java (at line 11)\n\t@Nullable String[] l2 = noNulls;\n\t                        ^^^^^^^\nNull type mismatch (type annotations): required '@Nullable String []' but this expression has type '@NonNull String []'\n----------\n5. ERROR in X.java (at line 14)\n\tassigns(withNulls, noNulls);\n\t        ^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String []' but this expression has type '@Nullable String []'\n----------\n6. ERROR in X.java (at line 14)\n\tassigns(withNulls, noNulls);\n\t                   ^^^^^^^\nNull type mismatch (type annotations): required '@Nullable String []' but this expression has type '@NonNull String []'\n----------\n");
    }

    public void testCompatibility5() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.Map;\n\nimport org.eclipse.jdt.annotation.*;\n\nabstract public class X<Y> implements Map<@NonNull String,Y> {\n\tvoid foo(X<Object> x) {\n\t\tMap<@NonNull String, Object> m1 = x; // OK\n\t\tMap<@Nullable String, Object> m2 = x; // NOK\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\tMap<@Nullable String, Object> m2 = x; // NOK\n\t                                   ^\nNull type mismatch (type annotations): required 'Map<@Nullable String,Object>' but this expression has type 'X<Object>', corresponding supertype is 'Map<@NonNull String,Object>'\n----------\n");
    }

    public void testCompatibility6() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.Map;\n\nimport org.eclipse.jdt.annotation.*;\n\nabstract public class X<@Nullable Y> implements Map<@Nullable String,Y> {\n\tvoid foo(X<@Nullable Object> x) {\n\t\tMap<@Nullable String, @Nullable Object> m1 = x; // OK\n\t\tMap<@Nullable String, @NonNull Object> m2 = x; // NOK\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\tMap<@Nullable String, @NonNull Object> m2 = x; // NOK\n\t                                            ^\nNull type mismatch (type annotations): required 'Map<@Nullable String,@NonNull Object>' but this expression has type 'X<@Nullable Object>', corresponding supertype is 'Map<@Nullable String,@Nullable Object>'\n----------\n");
    }

    public void testUnsupportedLocation01() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic @NonNull class X {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic @NonNull class X {}\n\t       ^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location\n----------\n");
    }

    public void testUnsupportedLocation02() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    class Inner {}\n    @NonNull X.Inner f;\n    @NonNull X.Inner foo(@NonNull X.Inner arg) {\n        @NonNull X.Inner local = arg;\n        return local;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@NonNull X.Inner f;\n\t^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location, it must be placed directly before the nested type name.\n----------\n2. ERROR in X.java (at line 5)\n\t@NonNull X.Inner foo(@NonNull X.Inner arg) {\n\t^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location, it must be placed directly before the nested type name.\n----------\n3. ERROR in X.java (at line 5)\n\t@NonNull X.Inner foo(@NonNull X.Inner arg) {\n\t                     ^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location, it must be placed directly before the nested type name.\n----------\n4. ERROR in X.java (at line 6)\n\t@NonNull X.Inner local = arg;\n\t^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location, it must be placed directly before the nested type name.\n----------\n");
    }

    public void testUnsupportedLocation03() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull X foo(X arg) {\n        if (!(arg instanceof @NonNull X))\n\t\t\treturn (@NonNull X)arg;\n        return arg;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (!(arg instanceof @NonNull X))\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type X is already an instance of type X\n----------\n2. ERROR in X.java (at line 4)\n\tif (!(arg instanceof @NonNull X))\n\t                     ^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n3. WARNING in X.java (at line 5)\n\treturn (@NonNull X)arg;\n\t       ^^^^^^^^^^^^^^^\nNull type safety: Unchecked cast from X to @NonNull X\n----------\n");
    }

    public void testUnsupportedLocation04() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n    List<@NonNull X> parameterized(List<X> arg) {\n        if (!(arg instanceof List<@NonNull X>))\n\t\t\treturn (java.util.List<@NonNull X>)arg;\n        return arg;\n    }\n    X @NonNull[] arrays(X[] arg) {\n        if (!(arg instanceof X @NonNull[]))\n\t\t\treturn (p.X @NonNull[])arg;\n        return arg;\n    }\n\tArrayList<@NonNull String> foo(List<@NonNull String> l) {\n\t\treturn (ArrayList<@NonNull String>) l;\n\t}\tArrayList<@NonNull String> foo2(List<@NonNull String> l) {\n\t\treturn (ArrayList<String>) l;\n\t}}\n"}, "----------\n1. ERROR in p\\X.java (at line 6)\n\tif (!(arg instanceof List<@NonNull X>))\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type List<X>. Use the form List<?> instead since further generic type information will be erased at runtime\n----------\n2. ERROR in p\\X.java (at line 6)\n\tif (!(arg instanceof List<@NonNull X>))\n\t                     ^^^^^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n3. WARNING in p\\X.java (at line 7)\n\treturn (java.util.List<@NonNull X>)arg;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety: Unchecked cast from List<X> to List<@NonNull X>\n----------\n4. WARNING in p\\X.java (at line 11)\n\tif (!(arg instanceof X @NonNull[]))\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type X[] is already an instance of type X[]\n----------\n5. ERROR in p\\X.java (at line 11)\n\tif (!(arg instanceof X @NonNull[]))\n\t                     ^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n6. WARNING in p\\X.java (at line 12)\n\treturn (p.X @NonNull[])arg;\n\t       ^^^^^^^^^^^^^^^^^^^\nNull type safety: Unchecked cast from X[] to X @NonNull[]\n----------\n7. WARNING in p\\X.java (at line 18)\n\treturn (ArrayList<String>) l;\n\t       ^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'ArrayList<String>' needs unchecked conversion to conform to 'ArrayList<@NonNull String>'\n----------\n", this.LIBS, true);
    }

    public void testUnsupportedLocation04a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tboolean instanceOf2(Object o) {\n\t\treturn o instanceof List<@Nullable ?>;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn o instanceof List<@Nullable ?>;\n\t                    ^^^^^^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n");
    }

    public void testUnsupportedLocation05() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tX x = new @NonNull X();\n\tclass Inner {}\n   Inner i = this.new @Nullable Inner();\n\tjava.util.List<@NonNull String> s = new java.util.ArrayList<@NonNull String>();\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX x = new @NonNull X();\n\t          ^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location\n----------\n2. ERROR in X.java (at line 5)\n\tInner i = this.new @Nullable Inner();\n\t                   ^^^^^^^^^\nThe nullness annotation 'Nullable' is not applicable at this location\n----------\n");
    }

    public void testUnsupportedLocation06() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid receiver(@Nullable X this, Object o) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid receiver(@Nullable X this, Object o) {}\n\t              ^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n");
    }

    public void testUnsupportedLocation07() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.function.Supplier;\npublic class X {\n\tvoid consume(Supplier<Object> c) {}\n\tstatic Object supply() { return null; }\n\tvoid consumeSupplied() {\n\t\tconsume(@NonNull X::supply);\n\t\tconsume(@NonNull X::new);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tconsume(@NonNull X::supply);\n\t        ^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n2. ERROR in X.java (at line 8)\n\tconsume(@NonNull X::new);\n\t        ^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n");
    }

    public void testUnsupportedLocation08() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.io.*;\npublic class X {\n\tvoid throwsDecl() throws @Nullable IOException {}\n\tvoid excParam() {\n\t\ttry {\n\t\t\tthrowsDecl();\n\t\t} catch (@NonNull IOException ioe) {}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tvoid throwsDecl() throws @Nullable IOException {}\n\t                         ^^^^^^^^^^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n2. ERROR in X.java (at line 8)\n\t} catch (@NonNull IOException ioe) {}\n\t                  ^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n");
    }

    public void testForeach() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tvoid foo(List<@NonNull String> nns) {\n\t\tfor(String s1 : nns) {\n\t\t\tlogMsg(s1);\n\t\t}\n\t\tfor(String s2 : getStrings()) {\n\t\t\tlogMsg(s2);\n\t\t}\n\t}\n\tCollection<@Nullable String> getStrings() { return null; }\n\tvoid logMsg(@NonNull String msg) { }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tlogMsg(s2);\n\t       ^^\nNull type mismatch: required '@NonNull String' but the provided value is inferred as @Nullable\n----------\n");
    }

    public void testNullTypeInference1() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation", "ignore");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\t<T> List<T> polyNullMethod(List<T> in) { return in; }\n\t@NonNull String test1(List<@NonNull String> strings) {\n\t\t return polyNullMethod(strings).get(0);\n\t}\n\t@NonNull String test2(List<@Nullable String> strings) {\n\t\t return polyNullMethod(strings).get(0);\n\t}\n\t@Nullable String test3(List<@NonNull String> strings) {\n\t\t return polyNullMethod(strings).get(0);\n\t}\n\t@Nullable String test4(List<@Nullable String> strings) {\n\t\t return polyNullMethod(strings).get(0);\n\t}\n}\n"}, compilerOptions, "----------\n1. ERROR in X.java (at line 9)\n\treturn polyNullMethod(strings).get(0);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testNullTypeInference2a() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface NNFunc {\n\t@NonNull String a(@NonNull String i);\n}\npublic class PolyNull {\n\t@NonNull String extract(NNFunc f, @NonNull String s) { return f.a(s); }\n\t@NonNull String testOK() {\n\t\treturn extract(i -> i, \"hallo\");\n\t}\n\t@NonNull String testERR() {\n\t\treturn extract(i -> null, \"hallo\"); // err\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in PolyNull.java (at line 12)\n\treturn extract(i -> null, \"hallo\"); // err\n\t                    ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testNullTypeInference2b() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface Func<T>  {\n\tT a(T i);\n}\npublic class PolyNull {\n\t@NonNull String extract(Func<@NonNull String> f, @NonNull String s) { return f.a(s); }\n\t@NonNull String testOK() {\n\t\treturn extract(i -> i, \"hallo\");\n\t}\n\t@NonNull String testERR() {\n\t\treturn extract(i -> null, \"hallo\"); // err\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in PolyNull.java (at line 12)\n\treturn extract(i -> null, \"hallo\"); // err\n\t                    ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testNullTypeInference2c() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface Func<T>  {\n\tT a(T i);\n}\npublic class PolyNull {\n\t<X> X extract(Func<X> f, X s) { return f.a(s); }\n\t@NonNull String testOK() {\n\t\treturn extract((@NonNull String i) -> i, \"hallo\");\n\t}\n\t@NonNull String testERR() {\n\t\treturn extract((@NonNull String i) -> null, \"hallo\"); // err\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in PolyNull.java (at line 12)\n\treturn extract((@NonNull String i) -> null, \"hallo\"); // err\n\t                                      ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testNullTypeInference2d() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface Func<T>  {\n\tT a(T i);\n}\npublic class PolyNull {\n\t<X> X extract(Func<X> f, X s) { return f.a(s); }\n\t@NonNull String testOK() {\n\t\treturn extract(i -> i, \"hallo\");\n\t}\n\t@NonNull String testERR() {\n\t\treturn extract(i -> null, \"hallo\"); // err\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in PolyNull.java (at line 12)\n\treturn extract(i -> null, \"hallo\"); // err\n\t                    ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testNullTypeInference2e() {
        this.runWarningTestWithLibs(true, new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface Func<T>  {\n\tT a(T i);\n}\npublic class PolyNull {\n\tString extract(Func<@Nullable String> f, @Nullable String s) { return f.a(s); }\n\t@NonNull String testWARN() {\n\t\treturn extract(i -> null, \"hallo\"); // OK to pass null\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in PolyNull.java (at line 9)\n\treturn extract(i -> null, \"hallo\"); // OK to pass null\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n");
    }

    public void testNullTypeInference2f() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface Func<T>  {\n\tT a(T i);\n}\npublic class PolyNull {\n\t<X> X extract(Func<@Nullable X> f, @Nullable X s) { return f.a(s); }\n\t@NonNull String testERR() {\n\t\treturn extract(i -> needNN(i), \"ola\");\n\t}\n\t@NonNull String needNN(@NonNull String s) { return \"\"; }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in PolyNull.java (at line 7)\n\t<X> X extract(Func<@Nullable X> f, @Nullable X s) { return f.a(s); }\n\t                                                           ^^^^^^\nNull type mismatch (type annotations): required 'X' but this expression has type '@Nullable X', where 'X' is a free type variable\n----------\n2. ERROR in PolyNull.java (at line 9)\n\treturn extract(i -> needNN(i), \"ola\");\n\t                           ^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testNullTypeInference3() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runNegativeTestWithLibs(new String[]{"Generics.java", "import org.eclipse.jdt.annotation.*;\n\npublic class Generics {\n\t<X> X m(@Nullable X a) { return null; }\n\tvoid test(@NonNull String in) {\n\t\t@NonNull String s = m(in);\n\t\tSystem.out.println(s.toLowerCase());\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Generics().test(\"hallo\");\n\t}\n}\n"}, compilerOptions, "----------\n1. ERROR in Generics.java (at line 4)\n\t<X> X m(@Nullable X a) { return null; }\n\t                                ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'X'\n----------\n");
    }

    public void testNullTypeInference3b() {
        this.runNegativeTestWithLibs(new String[]{"Generics.java", "import org.eclipse.jdt.annotation.*;\n\npublic class Generics {\n\t<X> @Nullable X m1(@Nullable X a) { return null; }\n\t<X> @Nullable X m2(X a) { return null; }\n\tvoid test(@NonNull String in) {\n\t\t@NonNull String s1 = m1(in);\n\t\t@NonNull String s2 = m2(in);\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Generics().test(\"hallo\");\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Generics.java (at line 7)\n\t@NonNull String s1 = m1(in);\n\t                     ^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n2. ERROR in Generics.java (at line 8)\n\t@NonNull String s2 = m2(in);\n\t                     ^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testNullTypeInference3c() {
        this.runNegativeTestWithLibs(new String[]{"Generics.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\n\ninterface Function<I,O> { }\nabstract class MyFunc implements Function<@NonNull Object, @Nullable String> { }\n  \npublic class Generics {\n  <@NonNull I,@Nullable O> \n  Collection<O> map1(Collection<I> in, Function<I, O> f) { return null; }\n  <@Nullable I,@NonNull O> \n  Collection<O> map2(Collection<I> in, Function<I, O> f) { return null; }\n\tvoid test(@NonNull List<Object> inList, MyFunc f) {\n\t\tCollection<@Nullable String> result = map1(inList, f);\n\t\tmap2(inList, f);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Generics.java (at line 13)\n\tCollection<@Nullable String> result = map1(inList, f);\n\t                                           ^^^^^^\nNull type safety (type annotations): The expression of type '@NonNull List<Object>' needs unchecked conversion to conform to 'Collection<@NonNull Object>', corresponding supertype is 'Collection<Object>'\n----------\n2. WARNING in Generics.java (at line 14)\n\tmap2(inList, f);\n\t     ^^^^^^\nNull type safety (type annotations): The expression of type '@NonNull List<Object>' needs unchecked conversion to conform to 'Collection<@Nullable Object>', corresponding supertype is 'Collection<Object>'\n----------\n3. ERROR in Generics.java (at line 14)\n\tmap2(inList, f);\n\t             ^\nNull type mismatch (type annotations): required 'Function<@Nullable Object,@NonNull String>' but this expression has type 'MyFunc', corresponding supertype is 'Function<@NonNull Object,@Nullable String>'\n----------\n");
    }

    public void testBug415850_01() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@NonNull foo() {}\n\t         ^^^^^\nReturn type for the method is missing\n----------\n", this.LIBS, true);
    }

    public void testBug415850_02() {
        this.runConformTestWithLibs(new String[]{"Callable.java", "interface Callable<T> {\n\tpublic enum Result {\n\t\tGOOD, BAD\n\t};\n\tpublic Result call(T arg);\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug415850_03() throws Exception {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        runner.javacTestOptions = new AbstractRegressionTest.JavacTestOptions.SuppressWarnings("deprecation");
        runner.classLibraries = this.LIBS;
        runner.testFiles = new String[]{"X.java", "import java.lang.annotation.*;\nimport java.util.Date;\nimport static java.lang.annotation.ElementType.*; \n@Target(TYPE_USE)\n@interface Vernal {}\ninterface I {\n\tint f(Date d);\n}\nclass X {\n\tstatic void monitorTemperature(Object myObject) {\n\t\tI i = @Vernal Date::getDay;\n\t}\n}\n"};
        runner.runConformTest();
    }

    public void testBug415850_04() throws Exception {
        this.runConformTestWithLibs(new String[]{"X.java", "public class X implements @B @C('i') J { }", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "J.java", "interface J {}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug415850_05() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class X {\n\tpublic void foo() {\n\t\tint @Marker [][][] i = new @Marker int @Marker [2] @Marker [@Marker bar()] @Marker [];\n\t}\n\tpublic int bar() {\n\t\treturn 2;\n\t}\n}\n@Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tint @Marker [][][] i = new @Marker int @Marker [2] @Marker [@Marker bar()] @Marker [];\n\t                                                            ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n", this.LIBS, true);
    }

    public void testBug415850_06() {
        this.runConformTestWithLibs(new String[]{"X.java", "import java.lang.annotation.Target;\npublic class X {\n\tpublic void foo() {\n\t\tint @Marker [][][] i = new @Marker int @Marker [2] @Marker [bar()] @Marker [];\n\t}\n\tpublic int bar() {\n\t\treturn 2;\n\t}\n}\n@Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug416172() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X {\n   class Y {}\n   X.@NonNull Y  foo(X.@NonNull Y xy) {\n       return new X().new Y();\n   }\n}\n\nclass Z extends X {\n   @Override\n   X.@NonNull Y  foo(X.Y xy) {\n       return null;\n   }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 12)\n\tX.@NonNull Y  foo(X.Y xy) {\n\t                  ^^^\nMissing non-null annotation: inherited method from X specifies this parameter as @NonNull\n----------\n2. ERROR in X.java (at line 13)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required 'X.@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testBug416174() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped", "ignore");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic class X {\n\tvoid  foo1(List<X> lx) {}\n\tvoid  foo2(List<@NonNull X> lx) {}\n\tvoid  foo3(List<@Nullable X> lx) {}\n\tvoid  foo4(@NonNull List<@Nullable X> lx) {}\n}\n\nclass Z extends X {\n\t@Override void foo1(List<@NonNull X> xy) {}\n\t@Override void foo2(List<X> lx) {}\n\t@Override void foo3(List<X> lx) {}\n\t@Override void foo4(List<@Nullable X> lx) {}\n}\n"}, options, "----------\n1. ERROR in X.java (at line 13)\n\t@Override void foo1(List<@NonNull X> xy) {}\n\t                    ^^^^\nIllegal redefinition of parameter xy, inherited method from X declares this parameter as 'List<X>' (mismatching null constraints)\n----------\n2. ERROR in X.java (at line 14)\n\t@Override void foo2(List<X> lx) {}\n\t                    ^^^^\nIllegal redefinition of parameter lx, inherited method from X declares this parameter as 'List<@NonNull X>' (mismatching null constraints)\n----------\n3. ERROR in X.java (at line 15)\n\t@Override void foo3(List<X> lx) {}\n\t                    ^^^^\nIllegal redefinition of parameter lx, inherited method from X declares this parameter as 'List<@Nullable X>' (mismatching null constraints)\n----------\n");
    }

    public void testBug416174b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.*;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic abstract class X {\n\tList<X> foo1() {\n\t\treturn null;\n\t}\n\tList<@Nullable X> foo2() {\n\t\treturn null;\n\t}\n\tabstract @NonNull List<@NonNull X> foo3();\n\tList<@Nullable X> foo4() {\n\t\treturn null;\n\t}\n}\n\nabstract class Z extends X {\n\t@Override\n\tList<@NonNull X> foo1() {\n\t\treturn null;\n\t}\n\t@Override\n\tList<@NonNull X> foo2() {\n\t\treturn null;\n\t}\n\t@Override\n\t@NonNull List<X> foo3() {\n\t\treturn new ArrayList<>();\n\t}\n\t@Override\n\t@NonNull List<@Nullable X> foo4() {\n\t\treturn new ArrayList<>();\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 20)\n\tList<@NonNull X> foo1() {\n\t^^^^\nThe return type is incompatible with 'List<X>' returned from X.foo1() (mismatching null constraints)\n----------\n2. ERROR in X.java (at line 24)\n\tList<@NonNull X> foo2() {\n\t^^^^\nThe return type is incompatible with 'List<@Nullable X>' returned from X.foo2() (mismatching null constraints)\n----------\n3. ERROR in X.java (at line 28)\n\t@NonNull List<X> foo3() {\n\t         ^^^^\nThe return type is incompatible with '@NonNull List<@NonNull X>' returned from X.foo3() (mismatching null constraints)\n----------\n");
    }

    public void testNullableReturn() {
        this.runConformTestWithLibs(new String[]{"X.java", "\nimport org.eclipse.jdt.annotation.*;\n\npublic abstract class X {\n\tX foo1() {\n\t\treturn null;\n\t}\n}\n\nabstract class Z extends X {\n\t@Override\n\t@Nullable X foo1() {\n\t\treturn null;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug416175() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<@NonNull ? extends @NonNull String> ls = new ArrayList<String>();\n\t\tls.add(null);\n\t\t@NonNull String s = ls.get(0);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 8)\n\tList<@NonNull ? extends @NonNull String> ls = new ArrayList<String>();\n\t                                              ^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'ArrayList<String>' needs unchecked conversion to conform to 'List<@NonNull ? extends @NonNull String>', corresponding supertype is 'List<String>'\n----------\n2. ERROR in X.java (at line 9)\n\tls.add(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull ? extends @NonNull String' but the provided value is null\n----------\n3. INFO in X.java (at line 10)\n\t@NonNull String s = ls.get(0);\n\t                    ^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type 'List<@NonNull capture#of ? extends @NonNull String>'. Type 'List<E>' doesn't seem to be designed with null type annotations in mind\n----------\n");
    }

    public void testBug416176() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<@NonNull T> {\n\tT foo(T t) {\n\t\treturn t;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug416176a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class X<@NonNull T> {\n\tT foo(T t) {\n\t\treturn t;\n\t}\n\t@NonNull T bar1(@NonNull T t) {\n\t\treturn t;\n\t}\n\t@NonNull T bar2(@Nullable T t) { // argument: no contradiction (1)\n\t\treturn t; // mismatch (1)\n\t}\n\t@Nullable T bar3(T t) { // return type: no contradiction (2)\n\t\t@Nullable T l = t; // local: no contradiction (3)\n\t\treturn l;\n\t}\n\tclass Inner {\n\t\t@Nullable T f; // field: no contradiction (4)\n\t}\n\tT bar3() {\n\t\treturn null; // mismatch (2)\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 12)\n\treturn t; // mismatch (1)\n\t       ^\nNull type mismatch (type annotations): required '@NonNull T' but this expression has type '@Nullable T'\n----------\n2. ERROR in X.java (at line 22)\n\treturn null; // mismatch (2)\n\t       ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n");
    }

    public void testBug416176b() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class X<T> {\n\t@NonNull T bar(@NonNull T t) {\n\t\treturn t;\n\t}\n\t@NonNull T bar(@Nullable T t) {\n\t\treturn t;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t@NonNull T bar(@NonNull T t) {\n\t           ^^^^^^^^^^^^^^^^^\nDuplicate method bar(T) in type X<T>\n----------\n2. ERROR in X.java (at line 8)\n\t@NonNull T bar(@Nullable T t) {\n\t           ^^^^^^^^^^^^^^^^^^\nDuplicate method bar(T) in type X<T>\n----------\n", this.LIBS, true);
    }

    public void testBug416180() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n\tT foo(T t) {\n\t\treturn t;\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new Y();\n\t}\n} \n\nclass Y extends X<@NonNull String> {\n   @Override\n\t@NonNull String foo(java.lang.@NonNull String t) {\n\t\treturn \"\";\n\t};\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug416181() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n\tclass Y {\n\t\t\n\t}\n\t\n\tX<String>.@NonNull Y y = null; // 1st error here.\n\t\n\t@NonNull Y y2 = null; // 2nd error here.\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\tX<String>.@NonNull Y y = null; // 1st error here.\n\t                         ^^^^\nNull type mismatch: required 'X<String>.@NonNull Y' but the provided value is null\n----------\n2. ERROR in X.java (at line 10)\n\t@NonNull Y y2 = null; // 2nd error here.\n\t                ^^^^\nNull type mismatch: required 'X<T>.@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testBug416182() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class X<T> {\n\tT foo(@NonNull T t) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<@Nullable String> xs = new X<String>();\n\t\txs.foo(null);\n\t}\n\t\n\tpublic void test(X<String> x) {\n\t\tX<@Nullable String> xs = x;\n\t\txs.bar(null);\n\t}\n\tpublic void bar(T t) {}\n\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 9)\n\tX<@Nullable String> xs = new X<String>();\n\t                         ^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'X<String>' needs unchecked conversion to conform to 'X<@Nullable String>'\n----------\n2. ERROR in X.java (at line 10)\n\txs.foo(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n3. WARNING in X.java (at line 14)\n\tX<@Nullable String> xs = x;\n\t                         ^\nNull type safety (type annotations): The expression of type 'X<String>' needs unchecked conversion to conform to 'X<@Nullable String>'\n----------\n");
    }

    public void testBug416182a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class X<T> {\n\tT foo(@NonNull T t) {\n\t\treturn t;\n\t}\n\tvoid foo() {}\n\tpublic static void main(String[] args) {\n\t\tX<@Nullable String> xs = new X<String>();\n\t\txs.foo();\n\t\txs.foo(null);\n\t}\n\t\n\tpublic void test(X<String> x) {\n\t\tX<@Nullable String> xs = x;\n\t\txs.bar(null);\n\t}\n\tpublic void bar(T t) {}\n\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 10)\n\tX<@Nullable String> xs = new X<String>();\n\t                         ^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'X<String>' needs unchecked conversion to conform to 'X<@Nullable String>'\n----------\n2. ERROR in X.java (at line 12)\n\txs.foo(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n3. WARNING in X.java (at line 16)\n\tX<@Nullable String> xs = x;\n\t                         ^\nNull type safety (type annotations): The expression of type 'X<String>' needs unchecked conversion to conform to 'X<@Nullable String>'\n----------\n");
    }

    public void testBug416182b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class X<T> {\n\tT foo(@NonNull T t) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<@Nullable String> xs = new X<>();\n\t\txs.foo(null);\n\t}\n\t\n\tpublic void test(X<String> x) {\n\t\tX<@Nullable String> xs = x;\n\t\txs.bar(null);\n\t}\n\tpublic void bar(T t) {}\n\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 10)\n\txs.foo(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. WARNING in X.java (at line 14)\n\tX<@Nullable String> xs = x;\n\t                         ^\nNull type safety (type annotations): The expression of type 'X<String>' needs unchecked conversion to conform to 'X<@Nullable String>'\n----------\n");
    }

    public void testBug416183() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n\tT foo(@NonNull T t) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> xs = new X<String>();\n\t\txs.foo(\"\");\n\t}\n\t\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testSubstitution() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport java.util.List;\nimport java.util.ArrayList;\npublic class X<T> {\n\tT foo(@NonNull List<@NonNull T> l) {\n\t\treturn l.get(0);\n\t}\t\n\tpublic static void main(String[] args) {\n\t\tX<String> s = new X<>();\n\t\ts.foo(new ArrayList<String>()); // (1)\n\t\ts.foo(null); // (2)\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. INFO in X.java (at line 6)\n\treturn l.get(0);\n\t       ^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type '@NonNull List<@NonNull T>'. Type 'List<E>' doesn't seem to be designed with null type annotations in mind\n----------\n2. WARNING in X.java (at line 10)\n\ts.foo(new ArrayList<String>()); // (1)\n\t      ^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'ArrayList<String>' needs unchecked conversion to conform to '@NonNull List<@NonNull String>', corresponding supertype is 'List<String>'\n----------\n3. ERROR in X.java (at line 11)\n\ts.foo(null); // (2)\n\t      ^^^^\nNull type mismatch: required '@NonNull List<@NonNull String>' but the provided value is null\n----------\n");
    }

    public void testSubstitution2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\npublic class X<T> {\n\tT foo(@NonNull T @NonNull [] l) {\n\t\treturn l[0];\n\t}\t\n\tpublic static void main(String[] args) {\n\t\tX<String> s = new X<>();\n       s.foo(new String [] { null });\n       s.foo(new String @Nullable [] { null });\n       s.foo(new String @NonNull [] { null });\n       s.foo(new @Nullable String @NonNull [] { null });\n       s.foo(new @NonNull String @NonNull [] { \"\" });\n\t\ts.foo(null); // (2)\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 9)\n\ts.foo(new String [] { null });\n\t      ^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@NonNull String @NonNull[]'\n----------\n2. WARNING in X.java (at line 10)\n\ts.foo(new String @Nullable [] { null });\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String @Nullable[]' needs unchecked conversion to conform to '@NonNull String @NonNull[]'\n----------\n3. WARNING in X.java (at line 11)\n\ts.foo(new String @NonNull [] { null });\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String @NonNull[]' needs unchecked conversion to conform to '@NonNull String @NonNull[]'\n----------\n4. ERROR in X.java (at line 12)\n\ts.foo(new @Nullable String @NonNull [] { null });\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[]' but this expression has type '@Nullable String @NonNull[]'\n----------\n5. ERROR in X.java (at line 14)\n\ts.foo(null); // (2)\n\t      ^^^^\nNull type mismatch: required '@NonNull String @NonNull[]' but the provided value is null\n----------\n");
    }

    public void testSubstitution3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class X<T> {\n\tT foo(@NonNull T l) {\n\t\treturn l;\n\t}\t\n\tpublic static void main(String[] args) {\n\t\tX<String> s = new X<>();\n       s.foo(null);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\ts.foo(null);\n\t      ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testSubstitution4() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.NonNull;\n@Target(ElementType.TYPE_USE)\n@interface TypeAnnotation {\n}\npublic class X<T> {\n    class Y {}\n    void foo(@TypeAnnotation X<T>.@NonNull Y l) {\n    }\t\n    public static void main(String[] args) {\n        X<String> s = new X<>();\n        s.foo(null);\n    }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 13)\n\ts.foo(null);\n\t      ^^^^\nNull type mismatch: required 'X<String>.@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testSubstitution5() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class X<T> {\n    void foo(@NonNull X<@NonNull ? extends T> p) {\n    }\t\n    public static void main(String[] args) {\n        X<String> s = new X<>();\n        X<@NonNull String> s2 = new X<@NonNull String>();\n        s.foo(s);\n        s.foo(s2);\n    }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 8)\n\ts.foo(s);\n\t      ^\nNull type safety (type annotations): The expression of type 'X<String>' needs unchecked conversion to conform to '@NonNull X<@NonNull ? extends String>'\n----------\n");
    }

    public void testArray1() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n   \n\tpublic static void main(String[] args) {\n\t\t@NonNull String @NonNull [] s = new @NonNull String [] { null };\n\t\tif (s != null && s[0] != null) {\n\t\t\tSystem.out.println(\"Not null\");\n\t\t}\n\t\tSystem.out.println(\"Length = \" + s[0].length());\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\t@NonNull String @NonNull [] s = new @NonNull String [] { null };\n\t                                                         ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. ERROR in X.java (at line 7)\n\tif (s != null && s[0] != null) {\n\t    ^\nRedundant null check: comparing '@NonNull String @NonNull[]' against null\n----------\n3. ERROR in X.java (at line 7)\n\tif (s != null && s[0] != null) {\n\t                 ^^^^\nRedundant null check: comparing '@NonNull String' against null\n----------\n");
    }

    public void testArray2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n   \n\tpublic static void main(String[] args) {\n\t\t@NonNull String @NonNull [][] s1 = new @NonNull String @NonNull [][] { null, { null} }; // problem at inner null\n\t\t@NonNull String @NonNull [][] s2 = new @NonNull String [] @NonNull [] { null, { null} }; // problem at both nulls\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\t@NonNull String @NonNull [][] s1 = new @NonNull String @NonNull [][] { null, { null} }; // problem at inner null\n\t                                                                               ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. ERROR in X.java (at line 7)\n\t@NonNull String @NonNull [][] s2 = new @NonNull String [] @NonNull [] { null, { null} }; // problem at both nulls\n\t                                                                        ^^^^\nNull type mismatch: required '@NonNull String @NonNull[]' but the provided value is null\n----------\n3. ERROR in X.java (at line 7)\n\t@NonNull String @NonNull [][] s2 = new @NonNull String [] @NonNull [] { null, { null} }; // problem at both nulls\n\t                                                                                ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testArray3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n   \n\tpublic static void main(String[] args) {\n\t\t@NonNull String [][] @NonNull [] s = new @NonNull String []@NonNull [][] { null, { {null}, null/*ok*/ } };\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 6)\n\t@NonNull String [][] @NonNull [] s = new @NonNull String []@NonNull [][] { null, { {null}, null/*ok*/ } };\n\t                                     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type '@NonNull String [] @NonNull[] []' needs unchecked conversion to conform to '@NonNull String [] [] @NonNull[]'\n----------\n2. ERROR in X.java (at line 6)\n\t@NonNull String [][] @NonNull [] s = new @NonNull String []@NonNull [][] { null, { {null}, null/*ok*/ } };\n\t                                                                           ^^^^\nNull type mismatch: required '@NonNull String @NonNull[] []' but the provided value is null\n----------\n3. ERROR in X.java (at line 6)\n\t@NonNull String [][] @NonNull [] s = new @NonNull String []@NonNull [][] { null, { {null}, null/*ok*/ } };\n\t                                                                                    ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug417759() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n\npublic class X<T> {\n\tvoid foo(@NonNull X<@NonNull ?> l) { \n\t}\t\n\tpublic static void main(String[] args) {\n\t\t@NonNull X<String> s = new X<>();\n       s.foo(s);  // String vs. @NonNull ?\n       @NonNull X<@Nullable String> s2 = new X<>();\n\t\ts.foo(s2); // @Nullable String vs. @NonNull ?\n       @NonNull X<@NonNull String> s3 = new X<>();\n\t\ts.foo(s3); // good\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 8)\n\ts.foo(s);  // String vs. @NonNull ?\n\t      ^\nNull type safety (type annotations): The expression of type '@NonNull X<String>' needs unchecked conversion to conform to '@NonNull X<@NonNull ?>'\n----------\n2. ERROR in X.java (at line 10)\n\ts.foo(s2); // @Nullable String vs. @NonNull ?\n\t      ^^\nNull type mismatch (type annotations): required '@NonNull X<@NonNull ?>' but this expression has type '@NonNull X<@Nullable String>'\n----------\n");
    }

    public void testTypeVariable1() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.NonNull;\n@Target(ElementType.TYPE_USE)\n@interface Junk {\n}\npublic class X<@NonNull T> {\n\tT t = null;\n\t@Junk T t2 = null;\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\tT t = null;\n\t      ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n2. ERROR in X.java (at line 9)\n\t@Junk T t2 = null;\n\t             ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n");
    }

    public void testTypeVariable2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X<T> {\n\tvoid consumeAny(T t) {\n\t\tconsume(t); // error, t can be null\n\t\tconsumeObject(t); // error, t can be null\n\t}\n\tvoid consumeNullable(@Nullable T t) {\n\t\tconsume(t); // error, both sides explicit, mismatch\n\t\tconsumeObject(t); // error, both sides explicit, mismatch\n\t}\n\tvoid consume(@NonNull T t) {}\n\tvoid consumeObject(@NonNull Object o) {}\n\tT produce() {\n\t\treturn null; // error, T may not accept null\n\t}\n\tT produceFromNullable(@Nullable T t) {\n\t\treturn t; // error, T may not accept nullable\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\tconsume(t); // error, t can be null\n\t        ^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in X.java (at line 5)\n\tconsumeObject(t); // error, t can be null\n\t              ^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n3. ERROR in X.java (at line 8)\n\tconsume(t); // error, both sides explicit, mismatch\n\t        ^\nNull type mismatch (type annotations): required '@NonNull T' but this expression has type '@Nullable T'\n----------\n4. ERROR in X.java (at line 9)\n\tconsumeObject(t); // error, both sides explicit, mismatch\n\t              ^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable T'\n----------\n5. ERROR in X.java (at line 14)\n\treturn null; // error, T may not accept null\n\t       ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'T'\n----------\n6. ERROR in X.java (at line 17)\n\treturn t; // error, T may not accept nullable\n\t       ^\nNull type mismatch (type annotations): required 'T' but this expression has type '@Nullable T', where 'T' is a free type variable\n----------\n");
    }

    public void testTypeVariable3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X<T extends Number> {\n\tvoid consumeAny(T t) {\n\t\tconsume(t); // error, t can be null\n\t\tconsumeObject(t); // error, t can be null\n\t}\n\tvoid consumeNullable(@Nullable T t) {\n\t\tconsume(t); // error, both sides explicit, mismatch\n\t\tconsumeObject(t); // error, both sides explicit, mismatch\n\t}\n\tvoid consume(@NonNull T t) {}\n\tvoid consumeObject(@NonNull Object o) {}\n\tT produce() {\n\t\treturn null; // error, T may not accept null\n\t}\n\tT produceFromNullable(@Nullable T t) {\n\t\treturn t; // error, T may not accept nullable\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\tconsume(t); // error, t can be null\n\t        ^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in X.java (at line 5)\n\tconsumeObject(t); // error, t can be null\n\t              ^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n3. ERROR in X.java (at line 8)\n\tconsume(t); // error, both sides explicit, mismatch\n\t        ^\nNull type mismatch (type annotations): required '@NonNull T extends Number' but this expression has type '@Nullable T extends Number'\n----------\n4. ERROR in X.java (at line 9)\n\tconsumeObject(t); // error, both sides explicit, mismatch\n\t              ^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable T extends Number'\n----------\n5. ERROR in X.java (at line 14)\n\treturn null; // error, T may not accept null\n\t       ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'T'\n----------\n6. ERROR in X.java (at line 17)\n\treturn t; // error, T may not accept nullable\n\t       ^\nNull type mismatch (type annotations): required 'T' but this expression has type '@Nullable T extends Number', where 'T' is a free type variable\n----------\n");
    }

    public void testTypeVariable4() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.*;\nimport org.eclipse.jdt.annotation.*;\n@Target(ElementType.TYPE_USE) @interface TypeMarker {}\npublic class X<T> {\n\tT passThrough1(@TypeMarker T t) {\n\t\treturn t; // OK\n\t}\n\t@TypeMarker T passThrough2(T t) {\n\t\treturn t; // OK\n\t}\n\t@TypeMarker T passThrough3(@Nullable @TypeMarker T t) {\n\t\treturn t; // Not OK\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 12)\n\treturn t; // Not OK\n\t       ^\nNull type mismatch (type annotations): required 'T' but this expression has type '@Nullable T', where 'T' is a free type variable\n----------\n");
    }

    public void testTypeVariable5() {
        this.runConformTestWithLibs(new String[]{"ExFunction.java", "@FunctionalInterface\npublic interface ExFunction<T, R, E extends Exception> {\n\tR apply(T t1) throws E;\n\n\tdefault <V>  ExFunction<V, R, E> compose(ExFunction<? super V, ? extends T, E> before) {\n\t\tjava.util.Objects.requireNonNull(before);\n\t\t//warning on before.apply(v):\n\t\t//Null type safety (type annotations): The expression of type 'capture#of ? extends T' needs unchecked conversion to conform to 'T'\n\t\treturn (V v) -> apply(before.apply(v));\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testSE7AnnotationCopy() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.NonNull;\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\npublic class X {\n\tclass Y {}\n\tvoid foo(@T X.@NonNull Y p) {\n\t\tfoo(null);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 10)\n\tfoo(null);\n\t    ^^^^\nNull type mismatch: required 'X.@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testWildcardCapture() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport java.util.ArrayList;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.NonNull;\n\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n       List<X> ax = new ArrayList<X>();\n       ax.add(new X());\n\t\tList<? extends X> lx = ax;\n\t\tgetAdd(lx);\n\t}\n\tstatic <@NonNull P>  void getAdd(List<P> lt) {\n\t\tlt.add(lt.get(0));\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 16)\n\tgetAdd(lx);\n\t       ^^\nNull type safety (type annotations): The expression of type 'List<capture#of ? extends X>' needs unchecked conversion to conform to 'List<@NonNull capture#of ? extends X>'\n----------\n");
    }

    public void testWildcardCapture2() {
        this.runConformTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport java.util.ArrayList;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.NonNull;\n\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n       List<@NonNull X> ax = new ArrayList<@NonNull X>();\n       ax.add(new X());\n\t\tList<@NonNull ? extends X> lx = ax;\n\t\tgetAdd(lx);\n\t}\n\tstatic <@NonNull P>  void getAdd(List<P> lt) {\n\t\tlt.add(lt.get(0));\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testWildcardCapture3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport java.util.ArrayList;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n       List<@Nullable X> ax = new ArrayList<@Nullable X>();\n       ax.add(new X());\n\t\tList<@Nullable ? extends X> lx = ax;\n\t\tgetAdd(lx);\n\t}\n\tstatic <@NonNull P>  void getAdd(List<P> lt) {\n\t\tlt.add(lt.get(0));\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 17)\n\tgetAdd(lx);\n\t       ^^\nNull type mismatch (type annotations): required 'List<@NonNull capture#of ? extends X>' but this expression has type 'List<@Nullable capture#of ? extends X>'\n----------\n");
    }

    public void testLocalArrays() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n       class L {};\n       L @NonNull [] @Nullable [] la = new L[5][];\n       L @Nullable [] @NonNull [] la2 = new L[3][];\n       la = la2;\n   }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 13)\n\tL @NonNull [] @Nullable [] la = new L[5][];\n\t                                ^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'L[][]' needs unchecked conversion to conform to 'L @NonNull[] @Nullable[]'\n----------\n2. WARNING in X.java (at line 14)\n\tL @Nullable [] @NonNull [] la2 = new L[3][];\n\t                                 ^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'L[][]' needs unchecked conversion to conform to 'L @Nullable[] @NonNull[]'\n----------\n3. ERROR in X.java (at line 15)\n\tla = la2;\n\t     ^^^\nNull type mismatch (type annotations): required 'L @NonNull[] @Nullable[]' but this expression has type 'L @Nullable[] @NonNull[]'\n----------\n");
        this.runConformTestWithLibs(false, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n       class L {};\n       L [] [] la = new L[5][];\n       L []  [] la2 = new L[3][];\n       la = la2;\n       System.out.println(\"Done\");\n   }\n}\n"}, this.getCompilerOptions(), "", "Done");
    }

    public void testRawType() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class X<T> {\n\tclass Y <P> {}\n\tpublic static void main(String[] args) {\n\t\t@NonNull X x = null;\n\t\tX.@NonNull Y xy = null;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 5)\n\t@NonNull X x = null;\n\t         ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\t@NonNull X x = null;\n\t               ^^^^\nNull type mismatch: required '@NonNull X' but the provided value is null\n----------\n3. WARNING in X.java (at line 6)\n\tX.@NonNull Y xy = null;\n\t^^^^^^^^^^^^\nX.Y is a raw type. References to generic type X<T>.Y<P> should be parameterized\n----------\n4. ERROR in X.java (at line 6)\n\tX.@NonNull Y xy = null;\n\t                  ^^^^\nNull type mismatch: required 'X.@NonNull Y' but the provided value is null\n----------\n");
    }

    public void test420456() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "ignore");
        this.runConformTestWithLibs(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n\tpublic static void main(String [] args) {\n\t\tInteger [] array = new Integer[] { 1234, 5678, 789 };\n\t\tArrays.sort(array, Integer::compare);\n       System.out.println(\"\" + array[0] + array[1] + array[2]);\n\t}\n}\n"}, compilerOptions, "", "78912345678");
    }

    public void test422134() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collections;\npublic class X {\n\tpublic static void main(String args[]) {\n\t\tCollections.sort(new ArrayList(), (o1, o2) -> {\n\t\t\treturn o1.compareToIgnoreCase(o1);\n\t\t});\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tCollections.sort(new ArrayList(), (o1, o2) -> {\n\t\t\treturn o1.compareToIgnoreCase(o1);\n\t\t});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation sort(ArrayList, (<no type> o1, <no type> o2) -> {}) of the generic method sort(List<T>, Comparator<? super T>) of type Collections\n----------\n2. WARNING in X.java (at line 5)\n\tCollections.sort(new ArrayList(), (o1, o2) -> {\n\t                 ^^^^^^^^^^^^^^^\nType safety: The expression of type ArrayList needs unchecked conversion to conform to List<Object>\n----------\n3. WARNING in X.java (at line 5)\n\tCollections.sort(new ArrayList(), (o1, o2) -> {\n\t                     ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n4. ERROR in X.java (at line 6)\n\treturn o1.compareToIgnoreCase(o1);\n\t          ^^^^^^^^^^^^^^^^^^^\nThe method compareToIgnoreCase(Object) is undefined for the type Object\n----------\n", this.LIBS, true);
    }

    public void testBug424725() {
        this.runConformTestWithLibs(new String[]{"AnnotatedRecordMapper.java", "import java.lang.invoke.MethodHandle;\n\npublic final class AnnotatedRecordMapper<T> {\n  private MethodHandle afterLoadStore;\n\n  public void invokeAfterLoadStore(Object object, Object database) {\n    if(afterLoadStore != null) {\n      try {\n        afterLoadStore.invoke(object, database);\n      }\n      catch(Throwable e) {\n        throw new RuntimeException(e);\n      }\n    }\n  }\n}"}, null, "");
    }

    public void testBug424727() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "@org.eclipse.jdt.annotation.NonNull public class X {\n\tstatic X singleton = new X();\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 1)\n\t@org.eclipse.jdt.annotation.NonNull public class X {\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location\n----------\n");
    }

    public void testBug424637() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\nimport java.nio.file.Files;\nimport java.nio.file.Path;\nimport java.util.function.Function;\nimport java.util.stream.Stream;\n\npublic class X {\n  public static void method() {\n    Function<Path, Stream<Path>> method = Files::walk;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tFunction<Path, Stream<Path>> method = Files::walk;\n\t                                      ^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n", this.LIBS, true);
    }

    public void testBug424637a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.nio.file.FileVisitOption;\nimport java.nio.file.Path;\nimport java.util.function.BiFunction;\nimport java.util.stream.Stream;\nimport org.eclipse.jdt.annotation.*;\n\ninterface TriFunc<A,B,C,D> { D apply(A a, B b, C c); }\npublic class X {\n  public static Stream<Path> myWalk(Path p, @NonNull FileVisitOption ... options) { return null; }\n  public static void method() {\n    BiFunction<Path, @Nullable FileVisitOption, Stream<Path>> method1 = X::myWalk;\n    BiFunction<Path, @Nullable FileVisitOption[], Stream<Path>> method2 = X::myWalk;\n    BiFunction<Path, FileVisitOption[], Stream<Path>> method3 = X::myWalk;\n \t TriFunc<Path, @NonNull FileVisitOption, @Nullable FileVisitOption, Stream<Path>> method4 = X::myWalk;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tBiFunction<Path, @Nullable FileVisitOption, Stream<Path>> method1 = X::myWalk;\n\t                                                                    ^^^^^^^^^\nNull type mismatch at parameter 2: required '@NonNull FileVisitOption' but provided '@Nullable FileVisitOption' via method descriptor BiFunction<Path,FileVisitOption,Stream<Path>>.apply(Path, FileVisitOption)\n----------\n2. ERROR in X.java (at line 12)\n\tBiFunction<Path, @Nullable FileVisitOption[], Stream<Path>> method2 = X::myWalk;\n\t                                                                      ^^^^^^^^^\nNull type mismatch at parameter 2: required '@NonNull FileVisitOption []' but provided '@Nullable FileVisitOption []' via method descriptor BiFunction<Path,FileVisitOption[],Stream<Path>>.apply(Path, FileVisitOption[])\n----------\n3. WARNING in X.java (at line 13)\n\tBiFunction<Path, FileVisitOption[], Stream<Path>> method3 = X::myWalk;\n\t                                                            ^^^^^^^^^\nNull type safety: parameter 2 provided via method descriptor BiFunction<Path,FileVisitOption[],Stream<Path>>.apply(Path, FileVisitOption[]) needs unchecked conversion to conform to '@NonNull FileVisitOption []'\n----------\n4. ERROR in X.java (at line 14)\n\tTriFunc<Path, @NonNull FileVisitOption, @Nullable FileVisitOption, Stream<Path>> method4 = X::myWalk;\n\t                                                                                           ^^^^^^^^^\nNull type mismatch at parameter 3: required '@NonNull FileVisitOption' but provided '@Nullable FileVisitOption' via method descriptor TriFunc<Path,FileVisitOption,FileVisitOption,Stream<Path>>.apply(Path, FileVisitOption, FileVisitOption)\n----------\n");
    }

    public void testBug424637_comment3() {
        this.runConformTestWithLibs(new String[]{"VarArgsMethodReferenceTest.java", "import java.util.function.Consumer;\npublic class VarArgsMethodReferenceTest {\n  public static void main(String[] argv) {\n    Consumer<String> printffer;\n    printffer = System.out::printf;\n  }\n}"}, null, "");
    }

    public void testBug427163() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid consume(@NonNull String @Nullable... strings) {\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug427163b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid consume1(@NonNull @Nullable String @Nullable[] strings) {}\n\tvoid consume2(@Nullable String @NonNull @Nullable... strings) {}\n\tvoid consume3(@Nullable String[] @NonNull @Nullable[] strings) {}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 3)\n\tvoid consume1(@NonNull @Nullable String @Nullable[] strings) {}\n\t                       ^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n2. ERROR in X.java (at line 4)\n\tvoid consume2(@Nullable String @NonNull @Nullable... strings) {}\n\t                               ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n3. ERROR in X.java (at line 5)\n\tvoid consume3(@Nullable String[] @NonNull @Nullable[] strings) {}\n\t                                 ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n");
    }

    public void testBug427163c() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tString[][] strings0 = new @NonNull String @Nullable[] @Nullable[] {};\n\tString[] strings1 = new String @NonNull @Nullable[] {};\n\tObject[] objects2 = new Object @NonNull @Nullable[1];\n\tString[] strings3 = new @NonNull @Nullable String [1];\n\tString[] strings4 = new @NonNull String  @Nullable @NonNull[1];\n\tString[][] strings5 = new String[] @NonNull @Nullable[] {};\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\tString[] strings1 = new String @NonNull @Nullable[] {};\n\t                               ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n2. ERROR in X.java (at line 5)\n\tObject[] objects2 = new Object @NonNull @Nullable[1];\n\t                               ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n3. ERROR in X.java (at line 6)\n\tString[] strings3 = new @NonNull @Nullable String [1];\n\t                        ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n4. ERROR in X.java (at line 7)\n\tString[] strings4 = new @NonNull String  @Nullable @NonNull[1];\n\t                                         ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n5. ERROR in X.java (at line 8)\n\tString[][] strings5 = new String[] @NonNull @Nullable[] {};\n\t                                   ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n");
    }

    public void testTypeBounds1() {
        this.runNegativeTestWithLibs(new String[]{"C.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass A { }\nclass B extends A {}\npublic class C {\n\t\n\t@NonNull A testExtends(List<@NonNull B> lb1, List<@Nullable B> lb2, boolean f) {\n\t\tList<? extends @NonNull A> la1 = lb1;\n\t\tla1.add(null); // ERR1\n\t\tif (la1.size() > 0)\n\t\t\treturn la1.get(0); // OK\n\t\tla1 = lb2; // ERR2\n\t\tList<? extends @Nullable A> la2 = lb1; // OK\n\t\tla2.add(null); // ERR3\n\t\tif (la2.size() > 0)\n\t\t\treturn la2.get(0); // ERR4\n\t\tla2 = lb2; // OK\n\t\tif (f)\n\t\t\treturn mExtends1(lb1); // OK, since we infer T to @NonNull B\n\t\treturn mExtends2(lb1);\n\t}\n\t<T extends @Nullable A> T mExtends1(List<T> t) { return null; /*ERR5*/ }\n\t<T extends @NonNull A> T mExtends2(List<T> t) { return null; /*ERR6*/ }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 12)\n\tla1.add(null); // ERR1\n\t        ^^^^\nNull type mismatch: required '? extends @NonNull A' but the provided value is null\n----------\n2. INFO in C.java (at line 14)\n\treturn la1.get(0); // OK\n\t       ^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type 'List<capture#of ? extends @NonNull A>'. Type 'List<E>' doesn't seem to be designed with null type annotations in mind\n----------\n3. ERROR in C.java (at line 15)\n\tla1 = lb2; // ERR2\n\t      ^^^\nNull type mismatch (type annotations): required 'List<? extends @NonNull A>' but this expression has type 'List<@Nullable B>'\n----------\n4. ERROR in C.java (at line 17)\n\tla2.add(null); // ERR3\n\t        ^^^^\nNull type mismatch: required '? extends @Nullable A' but the provided value is null\n----------\n5. ERROR in C.java (at line 19)\n\treturn la2.get(0); // ERR4\n\t       ^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull A' but this expression has type 'capture#of ? extends @Nullable A'\n----------\n6. ERROR in C.java (at line 25)\n\t<T extends @Nullable A> T mExtends1(List<T> t) { return null; /*ERR5*/ }\n\t                                                        ^^^^\nNull type mismatch: required 'T extends @Nullable A' but the provided value is null\n----------\n7. ERROR in C.java (at line 26)\n\t<T extends @NonNull A> T mExtends2(List<T> t) { return null; /*ERR6*/ }\n\t                                                       ^^^^\nNull type mismatch: required 'T extends @NonNull A' but the provided value is null\n----------\n");
    }

    public void testTypeBounds2() {
        this.runNegativeTestWithLibs(new String[]{"C.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass A { }\nclass B extends A {}\npublic class C {\n\t\n\t@NonNull Object testSuper(List<@Nullable A> la1, List<@NonNull A> la2, boolean f) {\n\t\tList<? super @NonNull B> lb1 = la1; // OK\n\t\tlb1.add(null); // ERR1\n\t\tif (lb1.size() > 0)\n\t\t\treturn lb1.get(0); // ERR2\n\t\tlb1 = la2; // OK\n\t\tList<? super @Nullable B> lb2 = la1;\n\t\tlb2.add(null);\n\t\tif (lb2.size() > 0)\n\t\t\treturn lb2.get(0); // ERR3\n\t\tlb2 = la2; // ERR4\n\t\tif (f)\n\t\t\treturn mSuper1(la1); // ERR5\n\t\treturn mSuper2(la1); // ERR6 on arg\n\t}\n\t<T extends @Nullable A> T mSuper1(List<T> t) { return null; /*ERR7*/ }\n\t<T extends @NonNull A> T mSuper2(List<T> t) { return null; /*ERR8*/ }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 12)\n\tlb1.add(null); // ERR1\n\t        ^^^^\nNull type mismatch: required '? super @NonNull B' but the provided value is null\n----------\n2. ERROR in C.java (at line 14)\n\treturn lb1.get(0); // ERR2\n\t       ^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type 'capture#of ? super @NonNull B'\n----------\n3. ERROR in C.java (at line 19)\n\treturn lb2.get(0); // ERR3\n\t       ^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type 'capture#of ? super @Nullable B'\n----------\n4. ERROR in C.java (at line 20)\n\tlb2 = la2; // ERR4\n\t      ^^^\nNull type mismatch (type annotations): required 'List<? super @Nullable B>' but this expression has type 'List<@NonNull A>'\n----------\n5. ERROR in C.java (at line 22)\n\treturn mSuper1(la1); // ERR5\n\t       ^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable A'\n----------\n6. ERROR in C.java (at line 23)\n\treturn mSuper2(la1); // ERR6 on arg\n\t               ^^^\nNull type mismatch (type annotations): required 'List<@NonNull A>' but this expression has type 'List<@Nullable A>'\n----------\n7. ERROR in C.java (at line 25)\n\t<T extends @Nullable A> T mSuper1(List<T> t) { return null; /*ERR7*/ }\n\t                                                      ^^^^\nNull type mismatch: required 'T extends @Nullable A' but the provided value is null\n----------\n8. ERROR in C.java (at line 26)\n\t<T extends @NonNull A> T mSuper2(List<T> t) { return null; /*ERR8*/ }\n\t                                                     ^^^^\nNull type mismatch: required 'T extends @NonNull A' but the provided value is null\n----------\n");
    }

    public void testTypeBounds3() {
        this.runNegativeTestWithLibs(new String[]{"C.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass A { }\nclass B extends A {}\npublic class C {\n\t\n\tvoid testExtends(List<? extends @NonNull B> lb1, List<? extends @Nullable B> lb2) {\n\t\tList<? extends @NonNull A> la1 = lb1;\n\t\tla1 = lb2; // ERR\n\t\tList<? extends @Nullable A> la2 = lb1;\n\t\tla2 = lb2;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 12)\n\tla1 = lb2; // ERR\n\t      ^^^\nNull type mismatch (type annotations): required 'List<? extends @NonNull A>' but this expression has type 'List<capture#of ? extends @Nullable B>'\n----------\n");
    }

    public void testTypeBounds4() {
        this.runNegativeTestWithLibs(new String[]{"C.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass A { }\nclass B extends A {}\npublic class C {\n\t\n\tvoid testSuper(List<? super @Nullable A> la1, List<? super @NonNull A> la2) {\n\t\tList<? super @NonNull B> lb1 = la1; // OK\n\t\tlb1 = la2; // OK\n\t\tList<? super @Nullable B> lb2 = la1;\n\t\tlb2 = la2; // ERR4\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 14)\n\tlb2 = la2; // ERR4\n\t      ^^^\nNull type mismatch (type annotations): required 'List<? super @Nullable B>' but this expression has type 'List<capture#of ? super @NonNull A>'\n----------\n");
    }

    public void test429387() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.BiFunction;\nimport java.util.function.Supplier;\nimport java.util.function.ToIntFunction;\nimport java.util.stream.IntStream;\nimport java.util.stream.Stream;\npublic interface X {\nstatic <BT, T extends BT, IS extends IntStream, E extends Exception> IntStreamy<E>\ninternalFlatMapToInt(Functionish<BT, IS, E> mapper,\nClass<E> classOfE,\nSupplier<Stream<T>> maker) {\nBiFunction<Stream<T>, ToIntFunction<BT>, IntStream> func = (Stream<T> t, ToIntFunction<BT, IS> m) -> t.flatmmapToInt(m);\nreturn IntStreamy.fromFlatMap(func, mapper, classOfE, maker);\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tstatic <BT, T extends BT, IS extends IntStream, E extends Exception> IntStreamy<E>\n\t                                                                     ^^^^^^^^^^\nIntStreamy cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 8)\n\tinternalFlatMapToInt(Functionish<BT, IS, E> mapper,\n\t                     ^^^^^^^^^^^\nFunctionish cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 11)\n\tBiFunction<Stream<T>, ToIntFunction<BT>, IntStream> func = (Stream<T> t, ToIntFunction<BT, IS> m) -> t.flatmmapToInt(m);\n\t                                                                         ^^^^^^^^^^^^^\nIncorrect number of arguments for type ToIntFunction<T>; it cannot be parameterized with arguments <BT, IS>\n----------\n4. ERROR in X.java (at line 11)\n\tBiFunction<Stream<T>, ToIntFunction<BT>, IntStream> func = (Stream<T> t, ToIntFunction<BT, IS> m) -> t.flatmmapToInt(m);\n\t                                                                                                                     ^\nm cannot be resolved to a variable\n----------\n5. ERROR in X.java (at line 12)\n\treturn IntStreamy.fromFlatMap(func, mapper, classOfE, maker);\n\t       ^^^^^^^^^^\nIntStreamy cannot be resolved\n----------\n", this.LIBS, true);
    }

    public void testBug429403() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\nclass Person {}\npublic class X {\n\tList<@NonNull Person> l = new ArrayList<@Nullable Person>();}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tList<@NonNull Person> l = new ArrayList<@Nullable Person>();}\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull Person>' but this expression has type 'ArrayList<@Nullable Person>', corresponding supertype is 'List<@Nullable Person>'\n----------\n");
    }

    public void testBug430219() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\npublic class X {\n       void foo(int @NonNull [] x) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tvoid foo(int @NonNull [] x) {}\n\t              ^^^^^^^\nNonNull cannot be resolved to a type\n----------\n", this.LIBS, true);
    }

    public void testBug430219a() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE) @interface Marker{}\n@NonNullByDefault\npublic class X {\n       void foo(int @Marker[] x) {}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testDefault01() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\n@NonNullByDefault(DefaultLocation.TYPE_ARGUMENT)\npublic class X {\n\tList<Number> test1(List<Number> in) {\n\t\tin.add(null); // ERR\n\t\treturn new ArrayList<@Nullable Number>(); // ERR\n\t}\n\tjava.util.List<java.lang.Number> test2(java.util.List<java.lang.Number> in) {\n\t\tin.add(null); // ERR\n\t\treturn new ArrayList<java.lang.@Nullable Number>(); // ERR\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\tin.add(null); // ERR\n\t       ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n2. ERROR in X.java (at line 7)\n\treturn new ArrayList<@Nullable Number>(); // ERR\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull Number>' but this expression has type 'ArrayList<@Nullable Number>', corresponding supertype is 'List<@Nullable Number>'\n----------\n3. ERROR in X.java (at line 10)\n\tin.add(null); // ERR\n\t       ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n4. ERROR in X.java (at line 11)\n\treturn new ArrayList<java.lang.@Nullable Number>(); // ERR\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull Number>' but this expression has type 'ArrayList<@Nullable Number>', corresponding supertype is 'List<@Nullable Number>'\n----------\n");
    }

    public void testDefault01b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\n@NonNullByDefault(DefaultLocation.TYPE_ARGUMENT)\npublic class X<T> {\n\tList<T> test(List<? extends Number> in) {\n\t\tin.add(null); // NOK, cannot assume nullable\n\t\tneedNN(in.get(0)); // NOK, cannot assume nonnull\n\t\treturn new ArrayList<@Nullable T>(); // NOK, cannot assume nullable for T in List<T>\n\t}\n\tvoid needNN(@NonNull Number n) {}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\tin.add(null); // NOK, cannot assume nullable\n\t       ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable '? extends Number'\n----------\n2. ERROR in X.java (at line 7)\n\tneedNN(in.get(0)); // NOK, cannot assume nonnull\n\t       ^^^^^^^^^\nNull type safety: required '@NonNull' but this expression has type 'capture#2-of ? extends java.lang.Number', a free type variable that may represent a '@Nullable' type\n----------\n3. ERROR in X.java (at line 8)\n\treturn new ArrayList<@Nullable T>(); // NOK, cannot assume nullable for T in List<T>\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<T>' but this expression has type 'ArrayList<@Nullable T>', corresponding supertype is 'List<@Nullable T>'\n----------\n");
    }

    public void testDefault02() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.PARAMETER)\npublic class X {\n\tNumber test1(Number in) {\n\t\tSystem.out.print(in.intValue()); // OK\n\t\ttest1(null); // ERR\n\t\treturn null; // OK\n\t}\n\tjava.lang.Number test2(java.lang.Number in) {\n\t\tSystem.out.print(in.intValue()); // OK\n\t\ttest2(null); // ERR\n\t\treturn null; // OK\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\ttest1(null); // ERR\n\t      ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n2. ERROR in X.java (at line 11)\n\ttest2(null); // ERR\n\t      ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault03() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\tNumber test(Number in) {\n\t\tSystem.out.print(in.intValue());\n\t\ttest(null); // OK\n\t\treturn null; // ERR\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 7)\n\treturn null; // ERR\n\t       ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault04() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.FIELD)\npublic class X {\n\tNumber field; // ERR since uninitialized\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\tNumber field; // ERR since uninitialized\n\t       ^^^^^\nThe @NonNull field field may not have been initialized\n----------\n");
    }

    public void testDefault05() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n\tNumber field; // ERR since uninitialized\n\tvoid test1(Number[] ns) {\n\t\tns[0] = null; // OK since not affected by default\n\t}\n\tvoid test2(java.lang.Number[] ns) {\n\t\tns[0] = null; // OK since not affected by default\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\tNumber field; // ERR since uninitialized\n\t       ^^^^^\nThe @NonNull field field may not have been initialized\n----------\n");
    }

    public void testDefault05_custom() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "org.foo.Nullable");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.NonNull");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "org.foo.NonNullByDefault");
        runner.testFiles = new String[]{"org/foo/Nullable.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface Nullable {\n}\n", "org/foo/NonNull.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface NonNull {\n}\n", "org/foo/NonNullByDefault.java", "package org.foo;\nimport java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({PACKAGE, TYPE, METHOD, CONSTRUCTOR })\npublic @interface NonNullByDefault {\n}\n", "test/package-info.java", "@org.foo.NonNullByDefault\npackage test;\n", "test/X.java", "package test;\npublic class X {\n\tNumber field; // ERR since uninitialized\n\tvoid test1(Number[] ns) {\n\t\tns[0] = null; // OK since not affected by default\n\t}\n\tvoid test2(java.lang.Number[] ns) {\n\t\tns[0] = null; // OK since not affected by default\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in test\\X.java (at line 3)\n\tNumber field; // ERR since uninitialized\n\t       ^^^^^\nThe @NonNull field field may not have been initialized\n----------\n";
        runner.runNegativeTest();
    }

    public void testDefault05_custom2() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "org.foo.Nullable");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.NonNull");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "org.foo.NonNullByDefault");
        runner.testFiles = new String[]{"org/foo/Nullable.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface Nullable {\n}\n", "org/foo/NonNull.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface NonNull {\n}\n", "org/foo/NonNullByDefault.java", "package org.foo;\nimport java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({PACKAGE, TYPE, METHOD, CONSTRUCTOR })\npublic @interface NonNullByDefault {\n}\n"};
        runner.runConformTest();
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"test/package-info.java", "@org.foo.NonNullByDefault\npackage test;\n", "test/X.java", "package test;\npublic class X {\n\tNumber field; // ERR since uninitialized\n\tvoid test1(Number[] ns) {\n\t\tns[0] = null; // OK since not affected by default\n\t}\n\tvoid test2(java.lang.Number[] ns) {\n\t\tns[0] = null; // OK since not affected by default\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in test\\X.java (at line 3)\n\tNumber field; // ERR since uninitialized\n\t       ^^^^^\nThe @NonNull field field may not have been initialized\n----------\n";
        runner.runNegativeTest();
    }

    public void testDefault06() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.TYPE_PARAMETER)\npublic class X {\n\tclass Inner<T> {\n\t\tT process(T t) {\n\t\t\t@NonNull T t2 = t; // OK\n\t\t\treturn null; // ERR\n \t\t}\n\t}\n\tvoid test(Inner<Number> inum) {\n\t\t@NonNull Number nnn = inum.process(null); // ERR on argument\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 7)\n\treturn null; // ERR\n\t       ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n2. ERROR in X.java (at line 10)\n\tvoid test(Inner<Number> inum) {\n\t                ^^^^^^\nNull constraint mismatch: The type 'Number' is not a valid substitute for the type parameter '@NonNull T'\n----------\n3. ERROR in X.java (at line 11)\n\t@NonNull Number nnn = inum.process(null); // ERR on argument\n\t                                   ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault06_b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault({DefaultLocation.TYPE_PARAMETER, DefaultLocation.TYPE_ARGUMENT})\n\tclass Inner<T> {\n\t\tT process(T t) {\n\t\t\t@NonNull T t2 = t; // OK\n\t\t\treturn null; // ERR\n \t\t}\n\t}\n@NonNullByDefault({DefaultLocation.TYPE_PARAMETER, DefaultLocation.TYPE_ARGUMENT})\npublic class X {\n\tvoid test(Inner<Number> inum) {\n\t\t@NonNull Number nnn = inum.process(null); // ERR on argument\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\treturn null; // ERR\n\t       ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n2. ERROR in X.java (at line 12)\n\t@NonNull Number nnn = inum.process(null); // ERR on argument\n\t                                   ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault07() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\n@NonNullByDefault(DefaultLocation.TYPE_BOUND)\npublic class X {\n\tclass Inner {\n\t\t<T extends Number> T process(T t, List<? extends Number> l) {\n\t\t\t@NonNull T t2 = t; // OK\n\t\t\t@NonNull Number n = l.get(0); // OK\n\t\t\treturn null; // ERR\n \t\t}\n\t}\n\tvoid test(Inner inner) {\n\t\t@NonNull Number nnn = inner.process(Integer.valueOf(3), new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. INFO in X.java (at line 8)\n\t@NonNull Number n = l.get(0); // OK\n\t                    ^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type 'List<capture#of ? extends @NonNull Number>'. Type 'List<E>' doesn't seem to be designed with null type annotations in mind\n----------\n2. ERROR in X.java (at line 9)\n\treturn null; // ERR\n\t       ^^^^\nNull type mismatch: required 'T extends @NonNull Number' but the provided value is null\n----------\n3. WARNING in X.java (at line 13)\n\t@NonNull Number nnn = inner.process(Integer.valueOf(3), new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t                                    ^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Integer' needs unchecked conversion to conform to '@NonNull Integer'\n----------\n4. ERROR in X.java (at line 13)\n\t@NonNull Number nnn = inner.process(Integer.valueOf(3), new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t                                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<? extends @NonNull Number>' but this expression has type 'ArrayList<@Nullable Integer>', corresponding supertype is 'List<@Nullable Integer>'\n----------\n");
    }

    public void testDefault01_bin() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\nimport java.lang.annotation.*;\n\n@Target(ElementType.TYPE_USE) @Retention(RetentionPolicy.CLASS) @interface Important {}\n\n@NonNullByDefault(DefaultLocation.TYPE_ARGUMENT)\npublic class X {\n\tList<Number> test1(List<@Important Number> in) {\n\t\treturn new ArrayList<@NonNull Number>();\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Y {\n\tvoid test(List<Number> in, X x) {\n\t\tx.test1(new ArrayList<@Nullable Number>()) // ERR at arg\n\t\t\t.add(null); // ERR\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Y.java (at line 5)\n\tx.test1(new ArrayList<@Nullable Number>()) // ERR at arg\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull Number>' but this expression has type 'ArrayList<@Nullable Number>', corresponding supertype is 'List<@Nullable Number>'\n----------\n2. ERROR in Y.java (at line 6)\n\t.add(null); // ERR\n\t     ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault02_bin() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.PARAMETER)\npublic class X {\n\tNumber test1(Number in) {\n\t\treturn null; // OK\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n\t@NonNull Number test(X x) {\n\t\treturn x.test1(null); // error at arg, unchecked at return\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Y.java (at line 4)\n\treturn x.test1(null); // error at arg, unchecked at return\n\t       ^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Number' needs unchecked conversion to conform to '@NonNull Number'\n----------\n2. ERROR in Y.java (at line 4)\n\treturn x.test1(null); // error at arg, unchecked at return\n\t               ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault03_bin() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        runner.classLibraries = this.LIBS;
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\tNumber test(Number in) {\n\t\treturn new Integer(13);\n\t}\n}\n"};
        runner.javacTestOptions = new AbstractRegressionTest.JavacTestOptions.SuppressWarnings("deprecation");
        runner.runConformTest();
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n\t@NonNull Number test(X x) {\n\t\treturn x.test(null); // both OK\n\t}\n}\n"};
        runner.runConformTest();
    }

    public void testDefault04_bin() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        runner.classLibraries = this.LIBS;
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE) @Retention(RetentionPolicy.CLASS) @interface Important {}\n@NonNullByDefault(DefaultLocation.FIELD)\npublic class X {\n\t@Important Number field = new Double(1.1);\n}\n"};
        runner.javacTestOptions = new AbstractRegressionTest.JavacTestOptions.SuppressWarnings("deprecation");
        runner.runConformTest();
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"Y.java", "public class Y {\n\tvoid test(X x) {\n\t\tx.field = null; // ERR\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Y.java (at line 3)\n\tx.field = null; // ERR\n\t          ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n";
        runner.runNegativeTest();
    }

    public void testDefault05_bin() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        runner.classLibraries = this.LIBS;
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n\tNumber field = new Long(13);\n\tvoid test1(Number[] ns) {\n\t\tns[0] = null; // OK since not affected by default\n\t}\n}\n"};
        runner.runConformTest();
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n\tvoid test(X x, @Nullable Number @NonNull[] ns) {\n\t\tx.test1(ns); // OK since not affected by default\n\t\tx.field = null; // ERR\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Y.java (at line 5)\n\tx.field = null; // ERR\n\t          ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault06_bin() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.TYPE_PARAMETER)\npublic class X {\n\tstatic class Inner<T> {\n\t\tT process(T t) {\n\t\t\treturn t;\n \t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n\tvoid test(X.Inner<Number> inum) { // illegal substitution\n\t\t@NonNull Number nnn = inum.process(null); // ERR on argument\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Y.java (at line 3)\n\tvoid test(X.Inner<Number> inum) { // illegal substitution\n\t                  ^^^^^^\nNull constraint mismatch: The type 'Number' is not a valid substitute for the type parameter '@NonNull T extends Object'\n----------\n2. ERROR in Y.java (at line 4)\n\t@NonNull Number nnn = inum.process(null); // ERR on argument\n\t                                   ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault07_bin() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\n@NonNullByDefault(DefaultLocation.TYPE_BOUND)\npublic class X {\n\tstatic class Inner {\n\t\t<T extends Number> T process(T t, List<? extends Number> l) {\n\t\t\treturn t;\n \t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Y {\n\tvoid test(X.Inner inner) {\n\t\t@NonNull Number nnn = inner.process(Integer.valueOf(3), new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Y.java (at line 5)\n\t@NonNull Number nnn = inner.process(Integer.valueOf(3), new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t                                    ^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Integer' needs unchecked conversion to conform to '@NonNull Integer'\n----------\n2. ERROR in Y.java (at line 5)\n\t@NonNull Number nnn = inner.process(Integer.valueOf(3), new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t                                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<? extends @NonNull Number>' but this expression has type 'ArrayList<@Nullable Integer>', corresponding supertype is 'List<@Nullable Integer>'\n----------\n");
    }

    public void testBug431269() {
        this.runNegativeTest(new String[]{"p/QField.java", "package p;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic class QField<R extends QField<R, ? >, T> {\n\t@NonNull\n\tprotected R m_root;\n\n\tpublic QField(@Nullable R root, @Nullable QField<R, ? > parent, @Nullable String propertyNameInParent) {\n\t\tm_root = root;\n\t}\n}\n", "p/PLogLine.java", "package p;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic class PLogLine<R extends QField<R, ? >> extends QField<R, LogLine> {\n\tpublic PLogLine(@Nullable R root, @Nullable QField<R, ? > parent, @Nullable String name) {\n\t\tsuper(root, parent, name);\n\t}\n\n\t@NonNull\n\tpublic final QField<R, java.lang.String> lastName() {\n\t\treturn new QField<R, java.lang.Long>(m_root, this, \"lastName\");\n\t}\n\n}\n", "p/LogLine.java", "package p;\n\npublic class LogLine {\n\tprivate String m_lastName;\n\n\tpublic String getLastName() {\n\t\treturn m_lastName;\n\t}\n\n\tpublic void setLastName(String property) {\n\t\tm_lastName = property;\n\t}\n}\n"}, "----------\n1. ERROR in p\\QField.java (at line 10)\n\tm_root = root;\n\t         ^^^^\nNull type mismatch (type annotations): required '@NonNull R extends QField<R extends QField<R,?>,?>' but this expression has type '@Nullable R extends QField<R extends QField<R,?>,?>'\n----------\n----------\n1. ERROR in p\\PLogLine.java (at line 12)\n\treturn new QField<R, java.lang.Long>(m_root, this, \"lastName\");\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from QField<R,Long> to QField<R,String>\n----------\n", this.LIBS, true);
    }

    public void testBug432223() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tString val;\n\tpublic static @NonNull <T> T assertNotNull(@Nullable T object) {\n\t\treturn assertNotNull(null, object);\n\t}\n\n\tpublic static @NonNull <T> T assertNotNull(@Nullable String message, @Nullable T object) {\n\t\tif (object == null) {\n\t\t\tthrow new NullPointerException(message);\n\t\t}\n\t\treturn object;\n\t}\n\tvoid test(@Nullable X x) {\n\t\t@NonNull X safe = assertNotNull(x);\n\t\tSystem.out.println(safe.val);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug432977() {
        this.runConformTestWithLibs(new String[]{"Bar.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Bar {\n\tprivate String prop = \"\";\n\n\tpublic String getProp() {\n\t\treturn prop;\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"Fu.java", "public class Fu {\n\tprivate Bar fubar = new Bar();\n\t\n\tpublic void method() {\n\t\tfubar.getProp().equals(\"\");\n\t}\t\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug433586() {
        this.runConformTestWithLibs(new String[]{"NullConversionWarning.java", "import java.util.function.Consumer;\npublic class NullConversionWarning<T> {\n\n\tpublic Consumer<T> peek2(Consumer<? super T> action) {\n\t\t// Null type safety: parameter 1 provided via\n\t\t// method descriptor Consumer<T>.accept(T) needs\n\t\t// unchecked conversion to conform to 'capture#of ? super T'\n\t\tConsumer<T> action2 = action::accept;\n\t\treturn action2;\n\t}\n\tvoid foo(Consumer<? super T> action, T t) {\n\t  Consumer<T> action2 = t2 -> action.accept(t2);\n\t  action.accept(t);\n\t  action2.accept(t);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug433478() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault class Y { }\n\ninterface I<T> {\n       @Nullable T foo();\n}\n\n@NonNullByDefault \nclass X implements I<Y> {\n       @Override\n       public Y foo() {\n               return null;\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required '@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testTypeVariable6() {
        this.runNegativeTestWithLibs(new String[]{"Assert.java", "import org.eclipse.jdt.annotation.*;\npublic class Assert {\n\tpublic static void caller() {\n\t\tassertNotNull(\"not null\");\t// Compiler error\n\t\tassertNotNull(null);\t\t// Compiler error\n\t}\n\tprivate static @NonNull <T> T assertNotNull(@Nullable T object) {\n\t\treturn object; // this IS bogus\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Assert.java (at line 8)\n\treturn object; // this IS bogus\n\t       ^^^^^^\nNull type mismatch (type annotations): required '@NonNull T' but this expression has type '@Nullable T'\n----------\n");
    }

    public void testTypeVariable6a() {
        this.runConformTestWithLibs(new String[]{"Assert.java", "import org.eclipse.jdt.annotation.*;\npublic class Assert {\n\tpublic static Object caller() {\n\t\t@NonNull Object result = assertNotNull(\"not null\");\n\t\tresult = assertNotNull(null);\n\t\treturn result;\n\t}\n\tprivate static @NonNull <T> T assertNotNull(@Nullable T object) {\n\t\tif (object == null) throw new NullPointerException();\n\t\treturn object;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testTypeVariable7() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\ninterface I1 <@NonNull T> { T get(); }\npublic class X {\n\t<U> U m(I1<U> in) { return in.get(); }\n\tpublic void test(I1<@NonNull String> in) {\n\t\t@NonNull String s = m(in);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\t<U> U m(I1<U> in) { return in.get(); }\n\t           ^\nNull constraint mismatch: The type 'U' is not a valid substitute for the type parameter '@NonNull T'\n----------\n");
    }

    public void testTypeVariable7a() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "warning");
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\ninterface I1 <@NonNull T> { T get(); }\npublic class X {\n\t<U> U m(I1<U> in) { return in.get(); }\n\tpublic void test1() {\n\t\t@Nullable String s = m(() -> \"OK\");\n\t\tSystem.out.println(s);\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().test1();\n\t}\n}\n"}, compilerOptions, "----------\n1. WARNING in X.java (at line 4)\n\t<U> U m(I1<U> in) { return in.get(); }\n\t           ^\nNull constraint mismatch: The type 'U' is not a valid substitute for the type parameter '@NonNull T'\n----------\n2. WARNING in X.java (at line 6)\n\t@Nullable String s = m(() -> \"OK\");\n\t                       ^^^^^^^^^^\nContradictory null annotations: function type was inferred as '@NonNull @Nullable String ()', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n", "OK");
    }

    public void testTypeVariable7err() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\ninterface I1 <@Nullable T> { T get(); }\npublic class X {\n\t<U> U m(I1<U> in) { return in.get(); }\n\tpublic void test1() {\n\t\t@NonNull String s = m(() -> \"\");\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\t<U> U m(I1<U> in) { return in.get(); }\n\t           ^\nNull constraint mismatch: The type 'U' is not a valid substitute for the type parameter '@Nullable T'\n----------\n2. ERROR in X.java (at line 4)\n\t<U> U m(I1<U> in) { return in.get(); }\n\t                           ^^^^^^^^\nNull type mismatch (type annotations): required 'U' but this expression has type '@Nullable U', where 'U' is a free type variable\n----------\n3. ERROR in X.java (at line 6)\n\t@NonNull String s = m(() -> \"\");\n\t                      ^^^^^^^^\nContradictory null annotations: function type was inferred as '@Nullable @NonNull String ()', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n");
    }

    public void testTypeVariable8() {
        this.runConformTestWithLibs(new String[]{"Test.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npublic class Test<E extends Exception> {\n\tvoid test() throws E {}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testTypeVariable9() {
        this.runConformTestWithLibs(new String[]{"Bar.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport static org.eclipse.jdt.annotation.DefaultLocation.*;\n\n@NonNullByDefault({ PARAMETER, RETURN_TYPE, FIELD, TYPE_BOUND, TYPE_ARGUMENT, TYPE_PARAMETER })\ninterface Bar<V> {\n    V getV(V in);\n    void setV(V v);\n}"}, this.getCompilerOptions(), "");
    }

    public void testTypeVariable10() {
        this.runConformTestWithLibs(new String[]{"X.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npublic class X<T> {\n\tvoid test(T t) {}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"Y.java", "public class Y {\n\tvoid foo(X<@org.eclipse.jdt.annotation.Nullable String> xs) {\n\t\txs.test(null);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testTypeVariable10a() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X<T> {\n\tvoid test(@Nullable T t) {}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"Y.java", "public class Y {\n\tvoid foo(X<String> xs) {\n\t\txs.test(\"OK\");\n\t\txs.test(null);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testTypeVariable11() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.DefaultLocation;\n@org.eclipse.jdt.annotation.NonNullByDefault({DefaultLocation.TYPE_BOUND})\npublic class X<T extends Object> {\n\tvoid test(T t) {}\n}\n", "Y.java", "public class Y {\n\tvoid foo(X<@org.eclipse.jdt.annotation.Nullable String> xs) {\n\t\txs.test(null);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 3)\n\tpublic class X<T extends Object> {\n\t                         ^^^^^^\nThe explicit type bound 'Object' is not affected by the nullness default for DefaultLocation.TYPE_BOUND.\n----------\n");
    }

    public void testTypeVariable12() {
        this.runConformTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Test {\n\tprivate Fu<String> fu = new Fu<>();\n\tpublic void foo() {\n\t\tfu.method();   // 'Contradictory null annotations' error\n\t}\n}\nclass Fu<T> {\n\t@Nullable T method() {\n\t\treturn null;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testTypeVariable13() {
        this.runConformTestWithLibs(new String[]{"FooBar.java", "@org.eclipse.jdt.annotation.NonNullByDefault(org.eclipse.jdt.annotation.DefaultLocation.TYPE_BOUND)\npublic interface FooBar {\n    <@org.eclipse.jdt.annotation.Nullable R extends Runnable> R foobar(R r);\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testTypeVariable14() {
        this.runConformTestWithLibs(new String[]{"ITest.java", "interface ITest {\n\t<T> T foo(T arg); // or arg Class<T> or TypeToken<T> + return TypeAdapter<T>, etc.\n}"}, this.getCompilerOptions(), "");
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runConformTestWithLibs(false, new String[]{"Test.java", "class Test implements ITest {\n\t@Override\n\t@SuppressWarnings(\"null\")\n\tpublic <T> @org.eclipse.jdt.annotation.Nullable T foo(T arg) {\n\t\treturn null;\n\t}\n}\n"}, options, "");
    }

    public void testTypeVariable15() {
        this.runNegativeTestWithLibs(new String[]{"ITest.java", "interface ITest {\n\t<T> T foo(T arg); // or arg Class<T> or TypeToken<T> + return TypeAdapter<T>, etc.\n}", "Test.java", "class Test implements ITest {\n\t@Override\n\tpublic <T> @org.eclipse.jdt.annotation.Nullable T foo(T arg) {\n\t\treturn null;\n\t}\n}\n", "Test2.java", "class Test2 implements ITest {\n\t@Override\n\tpublic <T> T foo(@org.eclipse.jdt.annotation.NonNull T arg) {\n\t\treturn arg;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Test.java (at line 3)\n\tpublic <T> @org.eclipse.jdt.annotation.Nullable T foo(T arg) {\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe return type is incompatible with the free type variable 'T' returned from ITest.foo(T) (mismatching null constraints)\n----------\n----------\n1. ERROR in Test2.java (at line 3)\n\tpublic <T> T foo(@org.eclipse.jdt.annotation.NonNull T arg) {\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIllegal redefinition of parameter arg, inherited method from ITest does not constrain this parameter\n----------\n");
    }

    public void testTypeVariable15a() {
        this.runNegativeTestWithLibs(new String[]{"ITest.java", "import java.util.List;\ninterface ITest {\n\t<T> T foo(List<T> arg); // or arg Class<T> or TypeToken<T> + return TypeAdapter<T>, etc.\n}", "Test.java", "import java.util.List;\nclass Test implements ITest {\n\t@Override\n\tpublic <T> T foo(List<@org.eclipse.jdt.annotation.NonNull T> arg) {\n\t\treturn arg.get(0);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Test.java (at line 4)\n\tpublic <T> T foo(List<@org.eclipse.jdt.annotation.NonNull T> arg) {\n\t                 ^^^^\nIllegal redefinition of parameter arg, inherited method from ITest declares this parameter as 'List<T>' (mismatching null constraints)\n----------\n2. INFO in Test.java (at line 5)\n\treturn arg.get(0);\n\t       ^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type 'List<@NonNull T>'. Type 'List<E>' doesn't seem to be designed with null type annotations in mind\n----------\n");
    }

    public void testTypeVariable16() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass Y { void doit() {} }\n@NonNullByDefault\nclass X {\n\tvoid foo() {\n\t\tX x = new X();\n\t\tY y = x.bar(); // Error: Contradictory null annotations before the fix\n\t\ty.doit(); // check that @Nullable from bar's declaration has effect on 'y'\n\t}\n\n\tpublic <T extends Y> @Nullable T bar() {\n\t\treturn null;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 10)\n\ty.doit(); // check that @Nullable from bar's declaration has effect on 'y'\n\t^\nPotential null pointer access: The variable y may be null at this location\n----------\n");
    }

    public void testTypeVariable16a() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass Y {}\n@NonNullByDefault\npublic class X <T> {\n\tvoid foo() {\n\t\tX<Y> x = new X<Y>();\n\t\tx.bar(); // Error: Contradictory null annotations before the fix\n\t}\n\n\tpublic @Nullable T bar() {\n\t\treturn null;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testTypeVariable16b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.Nullable;\nimport org.eclipse.jdt.annotation.NonNull;\n\nclass Y {}\nclass Y2 extends Y {}\n\nclass X {\n\tvoid foo() {\n\t\tX x = new X();\n\t\tx.bar(null); // null arg is illegal\n\t}\n\tpublic <T extends @NonNull Y> @Nullable T bar(T t) {\n\t\treturn null; // OK\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 10)\n\tx.bar(null); // null arg is illegal\n\t      ^^^^\nNull type mismatch: required '@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testTypeVariable17() {
        this.runNegativeTestWithLibs(new String[]{"Test7.java", "import org.eclipse.jdt.annotation.*;\n\npublic class Test7<@Nullable E> {\n\tE e;\n\n\t@Nullable\n\tE test() {\n\t\treturn null;\n\t}\n\n\t@NonNull\n\tE getNotNull() {\n\t\tif (e == null)\n\t\t\tthrow new NullPointerException();\n\t\treturn e;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Test7.java (at line 15)\n\treturn e;\n\t       ^\nNull type mismatch (type annotations): required '@NonNull E' but this expression has type '@Nullable E'\n----------\n");
    }

    public void testTypeVariable17a() {
        this.runConformTestWithLibs(new String[]{"Test7.java", "import org.eclipse.jdt.annotation.*;\n\npublic class Test7<@Nullable E> {\n\tE e;\n\n\t@Nullable\n\tE test() {\n\t\treturn null;\n\t}\n\n\t@NonNull\n\tE getNotNull() {\n\t\tE el = e;\n\t\tif (el == null)\n\t\t\tthrow new NullPointerException();\n\t\treturn el;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testTypeVariable18() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\n\ninterface Lib1 {\n    <T extends Collection<?>> T constrainedTypeParameter(@NonNull T in);\n}\n\npublic class Test {\n  @NonNull Collection<?> test4(Lib1 lib, @Nullable Collection<String> in) {\n    return lib.constrainedTypeParameter(in);\n  }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Test.java (at line 10)\n\treturn lib.constrainedTypeParameter(in);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Collection<String>' needs unchecked conversion to conform to '@NonNull Collection<?>'\n----------\n2. ERROR in Test.java (at line 10)\n\treturn lib.constrainedTypeParameter(in);\n\t                                    ^^\nNull type mismatch (type annotations): required '@NonNull Collection<String>' but this expression has type '@Nullable Collection<String>'\n----------\n");
    }

    public void testTypeVariable18raw() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\n\ninterface Lib1 {\n    <T extends Collection<?>> T constrainedTypeParameter(@NonNull T in);\n}\n\npublic class Test {\n  @SuppressWarnings(\"rawtypes\")\n  @NonNull Collection test4(Lib1 lib, @Nullable Collection in) {\n    return lib.constrainedTypeParameter(in);\n  }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Test.java (at line 11)\n\treturn lib.constrainedTypeParameter(in);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Collection' needs unchecked conversion to conform to '@NonNull Collection'\n----------\n2. ERROR in Test.java (at line 11)\n\treturn lib.constrainedTypeParameter(in);\n\t                                    ^^\nNull type mismatch (type annotations): required '@NonNull Collection' but this expression has type '@Nullable Collection'\n----------\n");
    }

    public void testTypeVariable19() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation", "ignore");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\ninterface I<T,U extends List<T>> {\n\tU get0();\n\t@Nullable U get1();\n\t@NonNull U get2();\n}\nclass X {\n\tstatic String test (I<@Nullable String, @NonNull ArrayList<@Nullable String>> i1,\n\t\t\t\t\t\tI<@NonNull String, @Nullable ArrayList<@NonNull String>> i2, int s) {\n\t\tswitch(s) {\n\t\t\tcase 0 : return i1.get0().get(0).toUpperCase(); // problem at detail\n\t\t\tcase 1 : return i1.get1().get(0).toUpperCase(); // 2 problems\n\t\t\tcase 2 : return i1.get2().get(0).toUpperCase(); // problem at detail\n\t\t\tcase 3 : return i2.get0().get(0).toUpperCase(); // problem at top\n\t\t\tcase 4 : return i2.get1().get(0).toUpperCase(); // problem at top\n\t\t\tcase 5 : return i2.get2().get(0).toUpperCase(); // OK\n\t\t\tdefault : return \"\";\t\t}\n\t}\n}\n"}, compilerOptions, "----------\n1. ERROR in X.java (at line 15)\n\tcase 0 : return i1.get0().get(0).toUpperCase(); // problem at detail\n\t                ^^^^^^^^^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n2. ERROR in X.java (at line 16)\n\tcase 1 : return i1.get1().get(0).toUpperCase(); // 2 problems\n\t                ^^^^^^^^^\nPotential null pointer access: The method get1() may return null\n----------\n3. ERROR in X.java (at line 16)\n\tcase 1 : return i1.get1().get(0).toUpperCase(); // 2 problems\n\t                ^^^^^^^^^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n4. ERROR in X.java (at line 17)\n\tcase 2 : return i1.get2().get(0).toUpperCase(); // problem at detail\n\t                ^^^^^^^^^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n5. ERROR in X.java (at line 18)\n\tcase 3 : return i2.get0().get(0).toUpperCase(); // problem at top\n\t                ^^^^^^^^^\nPotential null pointer access: The method get0() may return null\n----------\n6. ERROR in X.java (at line 19)\n\tcase 4 : return i2.get1().get(0).toUpperCase(); // problem at top\n\t                ^^^^^^^^^\nPotential null pointer access: The method get1() may return null\n----------\n");
    }

    public void testTypeVariable19a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\ninterface I1<T> {\n\tT @Nullable[] get0();\n\t@Nullable T @NonNull[] get1();\n\t@Nullable T @Nullable[] get2();\n}\ninterface I2<T> {\n\tT @NonNull[] get0();\n\t@NonNull T @NonNull[] get1();\n\t@NonNull T @Nullable[] get2();\n}\nclass X {\n\tstatic String test (I1<@NonNull String> i1, I2<@Nullable String> i2, int s) {\n\t\tswitch (s) {\n\t\t\tcase 0: return i1.get0()[0].toUpperCase(); // problem on array\n\t\t\tcase 1: return i1.get1()[0].toUpperCase(); // problem on element\n\t\t\tcase 2: return i1.get2()[0].toUpperCase(); // 2 problems\n\t\t\tcase 3: return i2.get0()[0].toUpperCase(); // problem on element\n\t\t\tcase 4: return i2.get1()[0].toUpperCase(); // OK\n\t\t\tcase 5: return i2.get2()[0].toUpperCase(); // problem on array\n\t\t\tdefault: return \"\";\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 16)\n\tcase 0: return i1.get0()[0].toUpperCase(); // problem on array\n\t               ^^^^^^^^^\nPotential null pointer access: The method get0() may return null\n----------\n2. ERROR in X.java (at line 17)\n\tcase 1: return i1.get1()[0].toUpperCase(); // problem on element\n\t               ^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n3. ERROR in X.java (at line 18)\n\tcase 2: return i1.get2()[0].toUpperCase(); // 2 problems\n\t               ^^^^^^^^^\nPotential null pointer access: The method get2() may return null\n----------\n4. ERROR in X.java (at line 18)\n\tcase 2: return i1.get2()[0].toUpperCase(); // 2 problems\n\t               ^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n5. ERROR in X.java (at line 19)\n\tcase 3: return i2.get0()[0].toUpperCase(); // problem on element\n\t               ^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n6. ERROR in X.java (at line 21)\n\tcase 5: return i2.get2()[0].toUpperCase(); // problem on array\n\t               ^^^^^^^^^\nPotential null pointer access: The method get2() may return null\n----------\n");
    }

    public void testTypeVariable20() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.Nullable;\ninterface I<@Nullable T> { }\npublic class X implements I<String> {}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 3)\n\tpublic class X implements I<String> {}\n\t                            ^^^^^^\nNull constraint mismatch: The type 'String' is not a valid substitute for the type parameter '@Nullable T'\n----------\n");
    }

    public void testBug434600() {
        this.runConformTestWithLibs(new String[]{"bug/Main.java", "package bug;\npublic class Main {\n\tpublic static void main(final String[] args) {\n\t\tSystem.out.println(\"Hello World\");\n\t}\n}\n", "bug/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage bug;\n", "bug/ExpressionNode.java", "package bug;\n\npublic interface ExpressionNode extends CopyableNode<ExpressionNode> {\n\t\n}\n", "bug/ExtendedNode.java", "package bug;\n\npublic interface ExtendedNode {\n\t\n}\n", "bug/CopyableNode.java", "package bug;\n\npublic interface CopyableNode<T extends ExtendedNode> extends ExtendedNode {\n\t\n}\n"}, this.getCompilerOptions(), "", "Hello World");
    }

    public void testBug434600a() {
        this.runConformTestWithLibs(new String[]{"I.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\ninterface I<S, T extends @Nullable List<@NonNull List<S>>> {\n}\n", "C.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic class C implements I<@Nullable String, @Nullable ArrayList<@NonNull List<@Nullable String>>> {}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug434600a_qualified() {
        this.runConformTestWithLibs(new String[]{"p/I.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic interface I<S, T extends @Nullable List<@NonNull List<S>>> {\n}\n", "C.java", "import org.eclipse.jdt.annotation.*;\npublic class C implements p.I<java.lang.@Nullable String, java.util.@Nullable ArrayList<java.util.@NonNull List<java.lang.@Nullable String>>> {}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug434600b() {
        this.runNegativeTestWithLibs(new String[]{"I.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\ninterface I<S, T extends @NonNull List<@NonNull List<S>>> {\n}\n", "C.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic class C implements I<@Nullable String, ArrayList<@NonNull List<@Nullable String>>> {}\nclass C1 {\n\tI<String, @NonNull ArrayList<@Nullable List<String>>> field;\n}\nclass C2 implements I<@NonNull String, @NonNull ArrayList<@NonNull List<@Nullable String>>> {}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 3)\n\tpublic class C implements I<@Nullable String, ArrayList<@NonNull List<@Nullable String>>> {}\n\t                                              ^^^^^^^^^\nNull constraint mismatch: The type 'ArrayList<@NonNull List<@Nullable String>>' is not a valid substitute for the type parameter 'T extends @NonNull List<@NonNull List<S>>'\n----------\n2. ERROR in C.java (at line 5)\n\tI<String, @NonNull ArrayList<@Nullable List<String>>> field;\n\t          ^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull ArrayList<@Nullable List<String>>' is not a valid substitute for the type parameter 'T extends @NonNull List<@NonNull List<S>>'\n----------\n3. ERROR in C.java (at line 7)\n\tclass C2 implements I<@NonNull String, @NonNull ArrayList<@NonNull List<@Nullable String>>> {}\n\t                                       ^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull ArrayList<@NonNull List<@Nullable String>>' is not a valid substitute for the type parameter 'T extends @NonNull List<@NonNull List<S>>'\n----------\n");
    }

    public void testBug434600b_qualified() {
        this.runNegativeTestWithLibs(new String[]{"p/I.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic interface I<S, T extends @Nullable List<@NonNull List<S>>> {\n}\n", "C.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic class C implements p.I<@Nullable String, ArrayList<@NonNull List<@Nullable String>>> {}\nclass C1 {\n\tp.I<String, @Nullable ArrayList<@Nullable List<String>>> field;\n}\nclass C2 implements p.I<@NonNull String, @Nullable ArrayList<@NonNull List<@Nullable String>>> {}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 5)\n\tp.I<String, @Nullable ArrayList<@Nullable List<String>>> field;\n\t            ^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable ArrayList<@Nullable List<String>>' is not a valid substitute for the type parameter 'T extends @Nullable List<@NonNull List<S>>'\n----------\n2. ERROR in C.java (at line 7)\n\tclass C2 implements p.I<@NonNull String, @Nullable ArrayList<@NonNull List<@Nullable String>>> {}\n\t                                         ^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable ArrayList<@NonNull List<@Nullable String>>' is not a valid substitute for the type parameter 'T extends @Nullable List<@NonNull List<S>>'\n----------\n");
    }

    public void testBug435399() {
        this.runConformTestWithLibs(new String[]{"bug/Bug1.java", "package bug;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class Bug1 {\n    public static <T> void method(@Nullable T value, T defaultValue) {\n    }\n    public void invoke() {\n        method(Integer.valueOf(1), Boolean.TRUE);\n    }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug435962() {
        this.runConformTestWithLibs(new String[]{"interfaces/CopyableNode.java", "package interfaces;\npublic interface CopyableNode<T extends ExtendedNode> extends ExtendedNode {\n\tpublic T deepCopy();\n}\n", "interfaces/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage interfaces;\n", "interfaces/ExtendedNode.java", "package interfaces;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.Nullable;\npublic interface ExtendedNode {\n\tExtendedNode getParent();\n\tvoid setParent(ExtendedNode newParent);\n\tint numChildren();\n\tvoid mutateNode(ExtendedNode root);\n\tvoid getAllNodes(ArrayList<ExtendedNode> array);\n\tExtendedNode getNode(int nodeIndex);\n\t<N extends ExtendedNode> void getNodesOfType(Class<N> desiredType,\n\t\t\tArrayList<N> array);\n\t<N extends ExtendedNode> @Nullable N getRandomNodeOfType(\n\t\t\tClass<N> desiredType, ExtendedNode root, ExtendedNode caller);\n}\n", "interfaces/ValueNode.java", "package interfaces;\npublic interface ValueNode extends ExtendedNode {\n}\n", "framework/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage framework;\n", "framework/BinaryOpNode.java", "package framework;\n\nimport interfaces.CopyableNode;\nimport interfaces.ValueNode;\npublic abstract class BinaryOpNode<T extends ValueNode & CopyableNode<T>, O>\n\t\textends EqualBinaryNode<T> implements ValueNode {\n\t@SuppressWarnings(\"unused\") private O op;\n\t\n\tprotected BinaryOpNode(final T left, @org.eclipse.jdt.annotation.NonNull final O op, final T right) {\n\t\tsuper(left, right);\n\t\tthis.op = op;\n\t}\n}\n", "framework/EqualBinaryNode.java", "package framework;\n\nimport interfaces.CopyableNode;\nimport interfaces.ExtendedNode;\npublic abstract class EqualBinaryNode<T extends ExtendedNode & CopyableNode<T>>\n\t\timplements ExtendedNode {\n\tprotected T left;\n\tprotected T right;\n\t\n\tprotected EqualBinaryNode(final T left, final T right) {\n\t\tthis.left = left;\n\t\tthis.right = right;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug440462() {
        this.runConformTestWithLibs(new String[]{"CompilerError.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\nimport java.util.*;\n@NonNullByDefault\npublic class CompilerError {\n\n    List<@Nullable ? extends Integer> list = new ArrayList<@Nullable Integer>();\n\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug440773() {
        this.runConformTestWithLibs(new String[]{"CountingComparator.java", "import java.util.Comparator;\n\nimport org.eclipse.jdt.annotation.*;\n\n\n@NonNullByDefault\npublic class CountingComparator<T> implements Comparator<T> {\n\n    private int m_accessCount = 0;\n\n    private final Comparator<T> m_wrapped;\n\n    public CountingComparator(final Comparator<T> wrapped) {\n        m_wrapped = wrapped;\n    }\n\n    @Override\n    @NonNullByDefault(DefaultLocation.RETURN_TYPE)\n    public int compare(final T element1, final T element2) {\n        m_accessCount++;\n        return m_wrapped.compare(element1, element2);\n    }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug439298_comment2() {
        this.runConformTestWithLibs(new String[]{"Extract.java", "import org.eclipse.jdt.annotation.*;\n\nclass R<T> {\n\tR(@Nullable T t) {}\n}\nclass A {}\n@NonNullByDefault\npublic class Extract {\n\tR<A> test() {\n\t\treturn new R<A>(null);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug439298_comment3() {
        this.runConformTestWithLibs(new String[]{"Extract.java", "import org.eclipse.jdt.annotation.*;\n\nclass R<T> {\n\tR(@Nullable T t) {}\n}\nclass A {}\npublic class Extract {\n\tR<A> test() {\n\t\treturn new R<@NonNull A>(null);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug439298_comment4() {
        this.runConformTestWithLibs(new String[]{"Extract.java", "import org.eclipse.jdt.annotation.*;\n\nclass R<T> {\n    R(@Nullable T t) {}\n}\nclass A {}\npublic class Extract {\n    R<@NonNull A> test() {\n        return new R<>(null);\n    }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug440764() {
        this.runNegativeTestWithLibs(new String[]{"Extract.java", "import java.util.Comparator;\n\nimport org.eclipse.jdt.annotation.*;\n\n@NonNullByDefault({ DefaultLocation.TYPE_PARAMETER })\npublic class Extract<T> implements Comparator<@NonNull T>  {\n\tpublic Extract(Comparator<T> wrapped) {\n\t}\n\n\t@Override\n\tpublic int compare(T o1, T o2) {\n\t\treturn 0;\n\t}\n\t\n\tvoid test(final Comparator<@Nullable Integer> c) {\n\t\tnew Extract<>(c).compare(1, null);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Extract.java (at line 16)\n\tnew Extract<>(c).compare(1, null);\n\t              ^\nNull type mismatch (type annotations): required 'Comparator<@NonNull Integer>' but this expression has type 'Comparator<@Nullable Integer>'\n----------\n2. ERROR in Extract.java (at line 16)\n\tnew Extract<>(c).compare(1, null);\n\t                            ^^^^\nNull type mismatch: required '@NonNull Integer' but the provided value is null\n----------\n");
    }

    public void testBug440759a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X<T> {\n\tT test(T t) {\n\t\t@NonNull T localT = t; // err#1\n\t\treturn null; // err must mention free type variable, not @NonNull\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 5)\n\t@NonNull T localT = t; // err#1\n\t                    ^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in X.java (at line 6)\n\treturn null; // err must mention free type variable, not @NonNull\n\t       ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'T'\n----------\n");
    }

    public void testBug440759b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\ninterface Y<T> {\n\tT test(T t);\n}\n@NonNullByDefault\npublic class X<T> implements Y<T> {\n\tpublic T test(T t) {\n\t\t@NonNull T localT = t; // err#1\n\t\treturn null; // err must mention free type variable, not @NonNull\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\t@NonNull T localT = t; // err#1\n\t                    ^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in X.java (at line 9)\n\treturn null; // err must mention free type variable, not @NonNull\n\t       ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'T'\n----------\n");
    }

    public void testBug438383() {
        this.runConformTestWithLibs(new String[]{"Foo.java", "import java.util.*;\nimport java.util.function.Supplier;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault public class Foo {\n    static void foo(Supplier<List<?>> f) { }\n    \n    static void test() {\n        foo(ArrayList::new);\n    }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug437270() {
        this.runConformTestWithLibs(new String[]{"Foo.java", "import org.eclipse.jdt.annotation.*;\npublic class Foo {\n\tvoid test(String[] arguments) {\n\t\tif (arguments != null) {\n\t\t\tString @NonNull [] temp = arguments;\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug437270_comment3() {
        this.runConformTestWithLibs(new String[]{"Foo.java", "import org.eclipse.jdt.annotation.*;\npublic class Foo {\n    void test()  {\n        @NonNull Object b = new Object();\n        Object @NonNull[] c = { new Object() };\n        \n        test2( b );\n        test3( c );\n    }\n    \n    void test2(@Nullable Object z)  {  }\n    \n    void test3(Object @Nullable[] z)  {  }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug435841() {
        this.runConformTestWithLibs(new String[]{"ArrayProblem.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class ArrayProblem {\n\tprivate String[] data = new String[0];\n\t\n\tvoid error1() {\n\t\tfoo(data);  // Compiler error: required 'String @Nullable[]', but this expression has type 'String @NonNull[]'\n\t}\n\t\n\tprivate String[] foo(String @Nullable[] input) {\n\t\treturn new String[0];\n\t}\n\t\n\tString @Nullable[] error2() {\n\t\tString @NonNull[] nonnull = new String[0];\n\t\treturn nonnull;  // Compiler error: required 'String @Nullable[]' but this expression has type 'String @NonNull[]'\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug441693() {
        this.runConformTestWithLibs(new String[]{"Foo.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault({})\npublic abstract class Foo {\n    \n    abstract <T> @NonNull T requireNonNull(@Nullable T obj);\n    \n    @NonNull Iterable<@NonNull String> iterable;\n    \n    Foo(@Nullable Iterable<@NonNull String> iterable) {\n        this.iterable = requireNonNull(iterable); // (*)\n    }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug441693other() {
        this.runNegativeTestWithLibs(new String[]{"Foo.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\nimport java.util.*;\n\n@NonNullByDefault({})\npublic abstract class Foo {\n    \n    abstract <T> @NonNull T requireNonNull(@Nullable T obj);\n    \n    @NonNull String @NonNull[] array;\n    \n    Foo(@NonNull String @Nullable[] arr) {\n        this.array = requireNonNull(arr); // (*)\n    }\n    @NonNull Foo testWild1(@Nullable List<? extends @NonNull Foo> foos) {\n        return requireNonNull(foos).get(0);\n    }\n    @NonNull Foo testWild2(@Nullable List<@Nullable ? extends List<@NonNull Foo>> foos) {\n        return requireNonNull(foos.get(0)).get(0);\n    }\n}\n"}, this.getCompilerOptions(), "----------\n1. INFO in Foo.java (at line 17)\n\treturn requireNonNull(foos).get(0);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type '@NonNull List<capture#of ? extends @NonNull Foo>'. Type 'List<E>' doesn't seem to be designed with null type annotations in mind\n----------\n2. INFO in Foo.java (at line 20)\n\treturn requireNonNull(foos.get(0)).get(0);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type 'List<@NonNull Foo>'. Type 'List<E>' doesn't seem to be designed with null type annotations in mind\n----------\n3. ERROR in Foo.java (at line 20)\n\treturn requireNonNull(foos.get(0)).get(0);\n\t                      ^^^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n");
    }

    public void testBug439158() {
        this.runConformTestWithLibs(new String[]{"Test.java", "import java.util.Collection;\nimport java.util.List;\nimport java.util.Set;\nimport org.eclipse.jdt.annotation.*;\n\npublic class Test {\n\tclass X {\n\t\t\n\t}\n\t\n\tpublic static <C extends Collection<?>, A extends C, B extends C>\n\t\t\t@Nullable A transform(B arg) {\n\t\treturn null;\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tList<X> list = null;\n\t\tSet<X> result = transform(list);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug434579() {
        Map options = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"AbstractNode.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\ninterface ExtendedNode {\n\tExtendedNode getParent();\n\tvoid setParent(ExtendedNode newParent);\n}\n@NonNullByDefault\npublic class AbstractNode implements ExtendedNode {\n\tprivate ExtendedNode parent;\n\tprotected AbstractNode() {\n\t\tparent = this;\n\t}\n\t@Override\n\tpublic ExtendedNode getParent() {\n\t\treturn parent;\n\t}\n\t@Override\n\tpublic void setParent(final ExtendedNode newParent) {\n\t\tparent = newParent;\n\t}\n}\n"}, options, "");
        this.runNegativeTestWithLibs(new String[]{"UnequalBinaryNode.java", "public class UnequalBinaryNode<L extends ExtendedNode, R extends ExtendedNode>\n\t\textends AbstractNode {\n\tprivate L left;\n\tprivate R right;\n\tpublic UnequalBinaryNode(final L initialLeft, final R initialRight) {\n\t\tleft = initialLeft;\n\t\tright = initialRight;\n\t\tleft.setParent(this);\n\t\tright.setParent(this); // error on this line without fix\n\t}\n}\n"}, options, "----------\n1. ERROR in UnequalBinaryNode.java (at line 8)\n\tleft.setParent(this);\n\t^^^^\nPotential null pointer access: this expression has type 'L', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in UnequalBinaryNode.java (at line 9)\n\tright.setParent(this); // error on this line without fix\n\t^^^^^\nPotential null pointer access: this expression has type 'R', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug434582() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.Nullable;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\nclass ProgramNode {}\n@NonNullByDefault\ninterface ConcreteNodeVisitor<R, P> {\n\tR visit(ProgramNode node, P extraParameter);\n}\npublic class X implements\n\t\tConcreteNodeVisitor<Boolean, @Nullable Object> {\n\tpublic Boolean visit(ProgramNode node, Object extraParameter) {\n\t\treturn Boolean.FALSE;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\tpublic Boolean visit(ProgramNode node, Object extraParameter) {\n\t                     ^^^^^^^^^^^\nMissing non-null annotation: inherited method from ConcreteNodeVisitor<Boolean,Object> specifies this parameter as @NonNull\n----------\n2. ERROR in X.java (at line 11)\n\tpublic Boolean visit(ProgramNode node, Object extraParameter) {\n\t                                       ^^^^^^\nMissing nullable annotation: inherited method from ConcreteNodeVisitor<Boolean,Object> specifies this parameter as @Nullable\n----------\n");
    }

    public void testBug434582a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.Nullable;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\nclass ProgramNode {}\n@NonNullByDefault\ninterface ConcreteNodeVisitor<R, P> {\n\tvoid visit(ProgramNode node, P extraParameter);\n}\npublic class X implements\n\t\tConcreteNodeVisitor<Boolean, @Nullable Object> {\n\tpublic void visit(ProgramNode node, Object extraParameter) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\tpublic void visit(ProgramNode node, Object extraParameter) {}\n\t                  ^^^^^^^^^^^\nMissing non-null annotation: inherited method from ConcreteNodeVisitor<Boolean,Object> specifies this parameter as @NonNull\n----------\n2. ERROR in X.java (at line 11)\n\tpublic void visit(ProgramNode node, Object extraParameter) {}\n\t                                    ^^^^^^\nMissing nullable annotation: inherited method from ConcreteNodeVisitor<Boolean,Object> specifies this parameter as @Nullable\n----------\n");
    }

    public void test443467() throws Exception {
        this.runNegativeTest(new String[]{"BuildIdeMain.java", "import java.nio.file.Path;\nimport java.time.Instant;\nimport java.util.AbstractMap.SimpleEntry;\nimport java.util.HashMap;\nimport java.util.stream.Stream;\n\npublic class BuildIdeMain {\nstatic void writeUpdates(Stream<Path> filter2, HashMap<Path, SimpleEntry<byte[], Instant>> ideFiles, HashMap<Path, Path> updateToFile) {\n   filter2.map(p -> new SimpleEntry<>(updateToFile.get(p), p->ideFiles.get(p)));\n}\n}\n"}, "----------\n1. ERROR in BuildIdeMain.java (at line 9)\n\tfilter2.map(p -> new SimpleEntry<>(updateToFile.get(p), p->ideFiles.get(p)));\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for SimpleEntry<>\n----------\n", this.LIBS, true);
    }

    public void testBug445227() {
        this.runConformTestWithLibs(new String[]{"Bar.java", "@org.eclipse.jdt.annotation.NonNullByDefault\nclass Bar<E extends Bar.Foo<E>> {\n    final Iterable<E> list;\n\n    Bar() {\n        this((Iterable<E>) emptyList());\n    }\n\n    Bar(Iterable<E> list) { this.list = list; }\n\n    private static <X extends Foo<X>> Iterable<X> emptyList() { throw new UnsupportedOperationException(); }\n\n    interface Foo<F extends Foo<F>> { }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Bar.java (at line 6)\n\tthis((Iterable<E>) emptyList());\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Iterable<Bar.Foo<Bar.Foo<X>>> to Iterable<E>\n----------\n");
    }

    public void test446715() {
        Map options = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class Y {\n\tpublic Z.ZI @NonNull [] zz = new Z.ZI[0];\n}\n", "Z.java", "public class Z {\n\tpublic class ZI {\n\t}\n}\n"}, options, "");
        this.runNegativeTestWithLibs(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tY y = new Y();\n\t\ty.zz = null;\n\t}\n}\n"}, options, "----------\n1. ERROR in X.java (at line 4)\n\ty.zz = null;\n\t       ^^^^\nNull type mismatch: required 'Z.ZI @NonNull[]' but the provided value is null\n----------\n");
    }

    public void test445669() {
        Map options = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.FIELD)\npublic class Y {\n\tpublic Z.ZI zzi = new Z().new ZI();\n\tpublic Z z = new Z();\n}\n", "Z.java", "public class Z {\n\tpublic class ZI {\n\t}\n}\n"}, options, "");
        this.runNegativeTestWithLibs(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tY y = new Y();\n\t\ty.zzi = null;\n       y.z = null;\n\t}\n}\n"}, options, "----------\n1. ERROR in X.java (at line 4)\n\ty.zzi = null;\n\t        ^^^^\nNull type mismatch: required 'Z.@NonNull ZI' but the provided value is null\n----------\n2. ERROR in X.java (at line 5)\n\ty.z = null;\n\t      ^^^^\nNull type mismatch: required '@NonNull Z' but the provided value is null\n----------\n");
    }

    public void testArrayOfArrays() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Arrays;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n   public static void main(String[] args) {\n      String [] @Nullable [] @NonNull [] arr = new String[][][] {};\n      ArrayList<String[][]> al = new ArrayList<String [][]>(Arrays.asList(arr));\n   }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 6)\n\tString [] @Nullable [] @NonNull [] arr = new String[][][] {};\n\t                                         ^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[][][]' needs unchecked conversion to conform to 'String [] @Nullable[] @NonNull[]'\n----------\n");
    }

    public void testBug447088() {
        this.runConformTestWithLibs(new String[]{"FullyQualifiedNullable.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class FullyQualifiedNullable {\n\tjava.lang.@Nullable String text;\n\tjava.lang.@Nullable String getText() {\n\t\treturn text;\n\t}\n}\n"}, null, "");
    }

    public void testBug448777() {
        this.runNegativeTestWithLibs(new String[]{"DoubleInference.java", "import org.eclipse.jdt.annotation.*;\n\npublic class DoubleInference {\n\n\t@FunctionalInterface\n\tinterface Func<@Nullable T>  {\n\t\tT a(T i);\n\t}\n\n\t<X> X applyWith(Func<X> f, X x) { return x; }\n\n\t@NonNull String test1() {\n\t\treturn applyWith(i -> i, \"hallo\");\n\t}\n\tvoid test2(Func<String> f1, Func<@NonNull String> f2) {\n\t\tf1.a(null);\n\t\tf2.a(null);\n\t}\n}\n"}, "----------\n1. ERROR in DoubleInference.java (at line 10)\n\t<X> X applyWith(Func<X> f, X x) { return x; }\n\t                     ^\nNull constraint mismatch: The type 'X' is not a valid substitute for the type parameter '@Nullable T'\n----------\n2. ERROR in DoubleInference.java (at line 13)\n\treturn applyWith(i -> i, \"hallo\");\n\t                 ^^^^^^\nContradictory null annotations: function type was inferred as '@Nullable @NonNull String (@Nullable @NonNull String)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n3. ERROR in DoubleInference.java (at line 15)\n\tvoid test2(Func<String> f1, Func<@NonNull String> f2) {\n\t                ^^^^^^\nNull constraint mismatch: The type 'String' is not a valid substitute for the type parameter '@Nullable T'\n----------\n4. ERROR in DoubleInference.java (at line 15)\n\tvoid test2(Func<String> f1, Func<@NonNull String> f2) {\n\t                                 ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable T'\n----------\n5. ERROR in DoubleInference.java (at line 17)\n\tf2.a(null);\n\t^^^^^^^^^^\nContradictory null annotations: method was inferred as '@Nullable @NonNull String a(@Nullable @NonNull String)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n");
    }

    public void testBug446442_comment2a() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\ninterface Foo<T, N extends Number> {\n\tvoid m(@NonNull N arg2);\n\n\tvoid m(@Nullable T arg1);\n}\n\ninterface Baz extends Foo<Integer, Integer> {}\n\nclass Impl implements Baz {\n  public void m(@NonNull Integer i) {}\n}\n\npublic class Test {\n\tBaz baz= x -> {\n\t\tx= null;\n\t}; \n}\n"}, "----------\n1. ERROR in Test.java (at line 11)\n\tpublic void m(@NonNull Integer i) {}\n\t              ^^^^^^^^^^^^^^^^\nIllegal redefinition of parameter i, inherited method from Foo<Integer,Integer> declares this parameter as @Nullable\n----------\n");
    }

    public void testBug446442_comment2b() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\ninterface Foo<T, N extends Number> {\n\tvoid m(@Nullable T arg1);\n\n\tvoid m(@NonNull N arg2);\n}\n\ninterface Baz extends Foo<Integer, Integer> {}\n\nclass Impl implements Baz {\n  public void m(@NonNull Integer i) {}\n}\n\npublic class Test {\n\tBaz baz= x -> {\n\t\tx= null;\n\t}; \n}\n"}, "----------\n1. ERROR in Test.java (at line 11)\n\tpublic void m(@NonNull Integer i) {}\n\t              ^^^^^^^^^^^^^^^^\nIllegal redefinition of parameter i, inherited method from Foo<Integer,Integer> declares this parameter as @Nullable\n----------\n");
    }

    public void testBug446442_comment2c() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\ninterface Foo0<T, N extends Number> {\n\tvoid m(@Nullable T arg1);\n}\n\ninterface Foo1<T, N extends Number> {\n\tvoid m(@NonNull N arg2);\n}\n\ninterface Baz extends Foo1<Integer, Integer>,  Foo0<Integer, Integer> {}\n\nclass Impl implements Baz {\n  public void m(@NonNull Integer i) {}\n}\n\npublic class Test {\n\tBaz baz= x -> {\n\t\tx= null;\n\t}; \n}\n"}, "----------\n1. ERROR in Test.java (at line 13)\n\tpublic void m(@NonNull Integer i) {}\n\t              ^^^^^^^^^^^^^^^^\nIllegal redefinition of parameter i, inherited method from Foo0<Integer,Integer> declares this parameter as @Nullable\n----------\n");
    }

    public void testBug446442_2a() {
        this.runWarningTestWithLibs(true, new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\ninterface Foo<T, N extends Number> {\n\tvoid m(@NonNull N arg2);\n\n\tvoid m(T arg1);\n}\n\ninterface Baz extends Foo<Integer, Integer> {}\n\npublic class Test {\n\tBaz baz= x -> {\n\t\t@NonNull Object o = x;\n\t}; \n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Test.java (at line 12)\n\t@NonNull Object o = x;\n\t                    ^\nNull type safety (type annotations): The expression of type 'Integer' needs unchecked conversion to conform to '@NonNull Object'\n----------\n");
    }

    public void testBug446442_2b() {
        this.runWarningTestWithLibs(true, new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\ninterface Foo<T, N extends Number> {\n\tvoid m(T arg1);\n\n\tvoid m(@NonNull N arg2);\n}\n\ninterface Baz extends Foo<Integer, Integer> {}\n\npublic class Test {\n\tBaz baz= x -> {\n\t\t@NonNull Object o = x;\n\t}; \n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Test.java (at line 12)\n\t@NonNull Object o = x;\n\t                    ^\nNull type safety (type annotations): The expression of type 'Integer' needs unchecked conversion to conform to '@NonNull Object'\n----------\n");
    }

    public void testBug446442_3() {
        this.runConformTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\ninterface Foo<T, N extends Number> {\n\tvoid m(@NonNull N arg2);\n\n\tvoid m(T arg1);\n}\n\ninterface Baz extends Foo<Integer, Integer> {}\nclass Impl {\n  public void m(Integer a) {}\n}\nclass BazImpl extends Impl implements Baz {}\n\npublic class Test {\n\tvoid test(BazImpl b) {\n\t\tb.m(null);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug446442_4() {
        this.runConformTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\ninterface Foo<T, N extends Number> {\n\tabstract void m(@NonNull N arg2) throws Exception;\n\n\tdefault void m(T arg1) throws java.io.IOException {}\n}\n\ninterface Baz extends Foo<Integer, Integer> {}\nabstract class Impl {\n  public void m(Integer a) throws java.io.IOException {}\n}\nclass BazImpl extends Impl implements Baz {}\n\npublic class Test {\n\tvoid test(BazImpl b) throws java.io.IOException {\n\t\tb.m(null);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug446442_5() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\ninterface Foo<T, N extends Number> {\n\tT m(T t);\n\n\t@NonNull N m(N n);\n}\n\ninterface Baz extends Foo<Integer, Integer> {}\n\nclass Impl implements Baz {\n  public Integer m(Integer i) { return Integer.valueOf(0); }\n}\n\npublic class Test {\n\tBaz baz= x -> null;\n}\n"}, "----------\n1. ERROR in Test.java (at line 11)\n\tpublic Integer m(Integer i) { return Integer.valueOf(0); }\n\t       ^^^^^^^\nThe return type is incompatible with '@NonNull Integer' returned from Foo<Integer,Integer>.m(Integer) (mismatching null constraints)\n----------\n2. ERROR in Test.java (at line 15)\n\tBaz baz= x -> null;\n\t              ^^^^\nNull type mismatch: required '@NonNull Integer' but the provided value is null\n----------\n");
    }

    public void testBug446442_6a() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\ninterface Foo<T,C1 extends Collection<T>, C2 extends List<T>> {\n\tvoid m(C1 a1);\n\n\tvoid m(C2 a2);\n}\n\ninterface Baz extends Foo<Integer, ArrayList<@NonNull Integer>, ArrayList<@Nullable Integer>> {}\n\nclass Impl implements Baz {\n  public void m(ArrayList<@NonNull Integer> i) {} // contradictory type cannot be implemented\n}\n\npublic class Test {\n\tBaz baz= x -> { // contradictory type cannot be used as SAM\n\t\tx.add(null); // contradictory type cause errors at call sites\n\t}; \n}\n"}, "----------\n1. ERROR in Test.java (at line 12)\n\tpublic void m(ArrayList<@NonNull Integer> i) {} // contradictory type cannot be implemented\n\t              ^^^^^^^^^\nIllegal redefinition of parameter i, inherited method from Foo<Integer,ArrayList<Integer>,ArrayList<Integer>> declares this parameter as 'ArrayList<@Nullable Integer>' (mismatching null constraints)\n----------\n2. ERROR in Test.java (at line 16)\n\tBaz baz= x -> { // contradictory type cannot be used as SAM\n\t\tx.add(null); // contradictory type cause errors at call sites\n\t}; \n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nContradictory null annotations: function type was inferred as 'void (ArrayList<@NonNull @Nullable Integer>)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n3. ERROR in Test.java (at line 17)\n\tx.add(null); // contradictory type cause errors at call sites\n\t^^^^^^^^^^^\nContradictory null annotations: method was inferred as 'boolean add(@NonNull @Nullable Integer)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n");
    }

    public void testBug446442_6b() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\ninterface Foo<T,C1 extends Collection<T>, C2 extends List<T>> {\n\tC2 m(C2 a2);\n\n\tC1 m(C1 a1);\n}\n\ninterface Baz extends Foo<Integer, ArrayList<@NonNull Integer>, ArrayList<@Nullable Integer>> {}\n\nclass Impl implements Baz {\n  public ArrayList<@NonNull Integer> m(ArrayList<@Nullable Integer> i) { return i; }\n}\n\npublic class Test {\n\tBaz baz= x -> {\n\t\tx.add(null);\n\t\tx.get(0);\n\t\treturn x;\n\t};\n}\n"}, "----------\n1. ERROR in Test.java (at line 12)\n\tpublic ArrayList<@NonNull Integer> m(ArrayList<@Nullable Integer> i) { return i; }\n\t       ^^^^^^^^^\nThe return type is incompatible with 'ArrayList<@Nullable Integer>' returned from Foo<Integer,ArrayList<Integer>,ArrayList<Integer>>.m(ArrayList<Integer>) (mismatching null constraints)\n----------\n2. ERROR in Test.java (at line 12)\n\tpublic ArrayList<@NonNull Integer> m(ArrayList<@Nullable Integer> i) { return i; }\n\t                                     ^^^^^^^^^\nIllegal redefinition of parameter i, inherited method from Foo<Integer,ArrayList<Integer>,ArrayList<Integer>> declares this parameter as 'ArrayList<@NonNull Integer>' (mismatching null constraints)\n----------\n3. ERROR in Test.java (at line 12)\n\tpublic ArrayList<@NonNull Integer> m(ArrayList<@Nullable Integer> i) { return i; }\n\t                                                                              ^\nNull type mismatch (type annotations): required 'ArrayList<@NonNull Integer>' but this expression has type 'ArrayList<@Nullable Integer>'\n----------\n4. ERROR in Test.java (at line 16)\n\tBaz baz= x -> {\n\t\tx.add(null);\n\t\tx.get(0);\n\t\treturn x;\n\t};\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nContradictory null annotations: function type was inferred as 'ArrayList<@NonNull @Nullable Integer> (ArrayList<@Nullable @NonNull Integer>)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n5. ERROR in Test.java (at line 17)\n\tx.add(null);\n\t^^^^^^^^^^^\nContradictory null annotations: method was inferred as 'boolean add(@Nullable @NonNull Integer)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n6. ERROR in Test.java (at line 18)\n\tx.get(0);\n\t^^^^^^^^\nContradictory null annotations: method was inferred as '@Nullable @NonNull Integer get(int)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n");
    }

    public void testBug453475() {
        this.runConformTestWithLibs(new String[]{"TestMap.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\n\n@NonNullByDefault\npublic abstract class TestMap extends AbstractMap<String,@Nullable String> {\n\n}\n"}, null, "");
        this.runConformTestWithLibs(false, new String[]{"Test.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\n\n@NonNullByDefault\npublic class Test {\n\n  public static final void test(TestMap testMap) {\n    testMap.putAll(new HashMap<String,@Nullable String>()); // Error: Contradictory null annotations: method was inferred as 'void putAll(Map<? extends @NonNull String,? extends @NonNull @Nullable String>)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n  }\n\n}\n"}, null, "");
    }

    public void testBug453475a() {
        this.runConformTestWithLibs(new String[]{"NamespaceStorage.java", "import java.util.*;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic interface NamespaceStorage<T> \n{\n\n\tSet<T> getObjects(); \n\tT getObject(T in);\n}\n"}, null, "");
        this.runConformTestWithLibs(false, new String[]{"NamespaceStorageImpl.java", "import java.util.*;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class NamespaceStorageImpl<T> implements NamespaceStorage<T>\n{\n\t@Override\n\tpublic  Set<T> getObjects() \n\t{\n\t\treturn new TreeSet<T>();\n\t}\n\t@Override\n\tpublic T getObject(T in)\n\t{\n\t\treturn in;\n\t}\n}\n"}, null, "");
    }

    public void testBug453475b() {
        this.runConformTestWithLibs(new String[]{"X.java", "import java.util.*;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic interface X {\n\n\tvoid test(List<?> list);\n\t\n}\n"}, null, "");
        this.runConformTestWithLibs(false, new String[]{"Y.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic class Y {\n\tpublic void run(X x, @NonNull List<@Nullable String> s) \n\t{\n\t\tx.test(s);\n\t}\n}\n"}, null, "");
    }

    public void testBug456236() {
        this.runConformTestWithLibs(new String[]{"Nullsafe.java", "import org.eclipse.jdt.annotation.*;\nclass Nullsafe<T> {\n\tfinal @Nullable T t;\n\n\tNullsafe(@Nullable T t) {\n\t\tthis.t = t;\n\t}\n\tpublic static <U> Nullsafe<U> of(@Nullable U u) {\n\t\treturn new Nullsafe<>(u); // compile error\n\t}\n}\n"}, null, "");
    }

    public void testBug456497() throws Exception {
        this.runConformTestWithLibs(new String[]{"libs/Lib1.java", "package libs;\n\nimport java.util.Collection;\nimport java.util.Iterator;\nimport org.eclipse.jdt.annotation.*;\n\npublic interface Lib1 {\n\t<T> Iterator<T> unconstrainedTypeArguments1(Collection<@Nullable T> in);\n\tIterator<@NonNull String> unconstrainedTypeArguments2(Collection<String> in);\n}\n", "tests/Test1.java", "package tests;\nimport org.eclipse.jdt.annotation.*;\n\nimport java.util.Collection;\nimport java.util.Iterator;\n\nimport libs.Lib1;\n\npublic class Test1 {\n\tIterator<@NonNull String> test1(Lib1 lib, Collection<@Nullable String> coll) {\n\t\treturn lib.unconstrainedTypeArguments1(coll);\n\t}\n\tIterator<@NonNull String> test2(Lib1 lib, Collection<@Nullable String> coll) {\n\t\treturn lib.unconstrainedTypeArguments2(coll);\n\t}\n}\n"}, null, "");
    }

    public void testBug456487a() {
        this.runConformTestWithLibs(new String[]{"Optional.java", "import org.eclipse.jdt.annotation.*;\npublic class Optional<@NonNull T> {\n  @Nullable T value;\n  private Optional(T value) { this.value = value; }\n  public static <@NonNull T> Optional<T> of(T value) { return new Optional<T>(value); }\n  public T get() { \n    @Nullable T t = this.value;\n    if (t != null) return t; \n    throw new RuntimeException(\"No value present\");\n  }\n  public @Nullable T orElse(@Nullable T other) { return (this.value != null) ? this.value : other; }\n}\n"}, null, "");
    }

    public void testBug456487b() {
        this.runNegativeTestWithLibs(new String[]{"Optional.java", "import org.eclipse.jdt.annotation.*;\npublic class Optional<@Nullable T> {\n  @Nullable T value;\n  private Optional(T value) { this.value = value; }\n  public static <@NonNull T> Optional<T> of(T value) { return new Optional<T>(value); }\n  public T get() { \n    @Nullable T t = this.value;\n    if (t != null) return t; \n    throw new RuntimeException(\"No value present\");\n  }\n  public @Nullable T orElse(@Nullable T other) { return (this.value != null) ? this.value : other; }\n}\n", "OTest.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\nclass OTest {\n  public static void good() {\n    Optional<String> os1 = Optional.of(\"yes\");\n    @NonNull String s = os1.get();\n    @Nullable String ns = os1.orElse(null);\n  }\n  public static void bad() {\n    Optional<String> os = Optional.of(null);\n    @NonNull String s = os.orElse(null);\n  }\n}\n"}, "----------\n1. ERROR in Optional.java (at line 5)\n\tpublic static <@NonNull T> Optional<T> of(T value) { return new Optional<T>(value); }\n\t                                    ^\nNull constraint mismatch: The type '@NonNull T' is not a valid substitute for the type parameter '@Nullable T'\n----------\n2. ERROR in Optional.java (at line 5)\n\tpublic static <@NonNull T> Optional<T> of(T value) { return new Optional<T>(value); }\n\t                                                            ^^^^^^^^^^^^^^^^^^^^^^\nContradictory null annotations: method was inferred as 'void <init>(@Nullable @NonNull T)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n3. ERROR in Optional.java (at line 5)\n\tpublic static <@NonNull T> Optional<T> of(T value) { return new Optional<T>(value); }\n\t                                                                         ^\nNull constraint mismatch: The type '@NonNull T' is not a valid substitute for the type parameter '@Nullable T'\n----------\n----------\n1. ERROR in OTest.java (at line 5)\n\tOptional<String> os1 = Optional.of(\"yes\");\n\t         ^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable T'\n----------\n2. ERROR in OTest.java (at line 6)\n\t@NonNull String s = os1.get();\n\t                    ^^^^^^^^^\nContradictory null annotations: method was inferred as '@Nullable @NonNull String get()', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n3. ERROR in OTest.java (at line 7)\n\t@Nullable String ns = os1.orElse(null);\n\t                      ^^^^^^^^^^^^^^^^\nContradictory null annotations: method was inferred as '@Nullable @NonNull String orElse(@Nullable @NonNull String)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n4. ERROR in OTest.java (at line 10)\n\tOptional<String> os = Optional.of(null);\n\t         ^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable T'\n----------\n5. ERROR in OTest.java (at line 10)\n\tOptional<String> os = Optional.of(null);\n\t                                  ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n6. ERROR in OTest.java (at line 11)\n\t@NonNull String s = os.orElse(null);\n\t                    ^^^^^^^^^^^^^^^\nContradictory null annotations: method was inferred as '@Nullable @NonNull String orElse(@Nullable @NonNull String)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n");
    }

    public void testBug454182() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "annot.NonNullByDefault");
        String[] libs = (String[])this.LIBS.clone();
        libs[libs.length - 1] = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Test454182.jar";
        this.runConformTest(new String[]{"p/package-info.java", "@annot.NonNullByDefault package p;\n"}, "", libs, false, null, options, null);
    }

    public void testBug443870() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\ninterface Listener<T> {}\ninterface I0<T,U extends Listener<T>> {}\ninterface I1<T> extends I0<T,Listener<T>> {}\nclass Y<S> {\n\tprivate @NonNull I0<S,Listener<S>> f;\n\tY (@NonNull I0<S,Listener<S>> in) { this.f = in; }\n\t@NonNull I0<S,Listener<S>> getI() { return f; }\n}\npublic class X<V> extends Y<V> {\n\tprivate @NonNull I1<V> f;\n\tX (@NonNull I1<V> in) { super(in); this.f = in; }\n\t@Override\n\t@NonNull I1<V> getI() { return f; }\n}\n"}, null, "");
    }

    public void testBug437072() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.List;\npublic class X {\n\t@NonNull int[][] ints = new int[3][4];\n\t@NonNull int[][] test1() { return new int[3][4]; }\n\tvoid test2(@NonNull boolean[][] bools) {\n\t\t@NonNull boolean[][] bools2 = bools;\n\t}\n\tList<@NonNull int[]> intslist;\n\tList<@NonNull int> intlist;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@NonNull int[][] ints = new int[3][4];\n\t^^^^^^^^\nThe nullness annotation @NonNull is not applicable for the primitive type int\n----------\n2. ERROR in X.java (at line 5)\n\t@NonNull int[][] test1() { return new int[3][4]; }\n\t^^^^^^^^\nThe nullness annotation @NonNull is not applicable for the primitive type int\n----------\n3. ERROR in X.java (at line 6)\n\tvoid test2(@NonNull boolean[][] bools) {\n\t           ^^^^^^^^\nThe nullness annotation @NonNull is not applicable for the primitive type boolean\n----------\n4. ERROR in X.java (at line 7)\n\t@NonNull boolean[][] bools2 = bools;\n\t^^^^^^^^\nThe nullness annotation @NonNull is not applicable for the primitive type boolean\n----------\n5. ERROR in X.java (at line 9)\n\tList<@NonNull int[]> intslist;\n\t     ^^^^^^^^\nThe nullness annotation @Nullable is not applicable for the primitive type int\n----------\n6. ERROR in X.java (at line 10)\n\tList<@NonNull int> intlist;\n\t              ^^^\nSyntax error, insert \"Dimensions\" to complete ReferenceType\n----------\n", this.LIBS, true);
    }

    public void testBug448709() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "warning");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables", "warning");
        this.runWarningTestWithLibs(true, new String[]{"Test.java", "import java.util.*;\nimport java.util.function.*;\nimport org.eclipse.jdt.annotation.*;\n\npublic class Test {\n\n  /**\n   * A null-annotated version of {@link Objects#requireNonNull(Object)}.\n   */\n  public static final <T> @NonNull T requireNonNull(final @Nullable T obj) {\n    if (obj == null) throw new NullPointerException();\n    return obj;\n  }\n\n  /**\n   * A null-annotated version of {@link Optional#map(Function)}.\n   */\n  public static final <T,U> @NonNull Optional<U> map(final @NonNull Optional<T> optional, final Function<@NonNull ? super T,? extends U> mapper) {\n    if (!optional.isPresent()) return requireNonNull(Optional.empty());\n    final T source = optional.get();\n    final U result = mapper.apply(source);\n    System.out.println(source+\"->\"+result);\n    return requireNonNull(Optional.<U> ofNullable(result));\n  }\n\n  /**\n   * A method with a {@link NonNull} {@link DefaultLocation#PARAMETER} and {@link DefaultLocation#RETURN_TYPE}.\n   */\n  public static final @NonNull Integer testMethod(final @NonNull String s) {\n    final Integer r = Integer.valueOf(s);\n    if (r == null) throw new NullPointerException();\n    return r+1;\n  }\n\n  public static void main(final String[] args) {\n    final @NonNull Optional<@Nullable String> optNullableString = requireNonNull(Optional.ofNullable(\"1\"));\n\n    final Function<@NonNull String,@NonNull Integer> testMethodRef = Test::testMethod;\n    map(optNullableString, testMethodRef);\n\n    map(optNullableString, Test::testMethod); // Error: Null type mismatch at parameter 1: required '@NonNull String' but provided '@Nullable String' via method descriptor Function<String,Integer>.apply(String)\n\n    map(optNullableString, (s) -> Test.testMethod(s));\n  }\n\n}\n"}, compilerOptions, "----------\n1. WARNING in Test.java (at line 21)\n\tfinal U result = mapper.apply(source);\n\t                              ^^^^^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. WARNING in Test.java (at line 39)\n\tmap(optNullableString, testMethodRef);\n\t                       ^^^^^^^^^^^^^\nContradictory null annotations: method was inferred as '@NonNull Optional<@NonNull Integer> map(@NonNull Optional<@Nullable String>, Function<@NonNull ? super @Nullable String,? extends @NonNull Integer>)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n3. WARNING in Test.java (at line 41)\n\tmap(optNullableString, Test::testMethod); // Error: Null type mismatch at parameter 1: required '@NonNull String' but provided '@Nullable String' via method descriptor Function<String,Integer>.apply(String)\n\t                       ^^^^^^^^^^^^^^^^\nContradictory null annotations: method was inferred as '@NonNull Optional<@NonNull Integer> map(@NonNull Optional<@Nullable String>, Function<@NonNull ? super @Nullable String,? extends @NonNull Integer>)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n4. WARNING in Test.java (at line 43)\n\tmap(optNullableString, (s) -> Test.testMethod(s));\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^\nContradictory null annotations: method was inferred as '@NonNull Optional<@NonNull Integer> map(@NonNull Optional<@Nullable String>, Function<@NonNull ? super @Nullable String,? extends @NonNull Integer>)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n5. WARNING in Test.java (at line 43)\n\tmap(optNullableString, (s) -> Test.testMethod(s));\n\t                                              ^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n", "1->2\n1->2\n1->2");
    }

    public void testBug448709b() {
        this.runConformTestWithLibs(new String[]{"Test.java", "import java.util.*;\nimport java.util.function.*;\nimport org.eclipse.jdt.annotation.*;\n\npublic class Test {\n\n  public static final <T,U> void map(final @NonNull Optional<T> optional, final Function<@NonNull ? super T,? extends U> mapper) {\n    final T source = optional.get();\n    if (source != null) {\n      final U result = mapper.apply(source);\n      System.out.println(source+\"->\"+result);\n    }\n  }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug459967_Array_constructor() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\ninterface FI<T> {\n\tT @NonNull[] getArray(int size);}\npublic class X {\n\tvoid consumer(FI<String> fis) {}\n\tvoid test() {\n\t\tconsumer(String[]::new);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug459967_Array_constructor_b() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\ninterface FI<T> {\n\t@NonNull T @NonNull[] getArray(int size);}\npublic class X {\n\tvoid consumer(FI<String> fis) {}\n\tvoid test() {\n\t\tconsumer(String[]::new);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 7)\n\tconsumer(String[]::new);\n\t         ^^^^^^^^^^^^^\nNull type safety at method return type: Method descriptor FI<String>.getArray(int) promises '@NonNull String @NonNull[]' but referenced method provides 'String @NonNull[]'\n----------\n");
    }

    public void testBug459967_Array_clone() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\ninterface FI<T> {\n\tT @NonNull[] getArray(T[] orig);}\npublic class X {\n\tvoid consumer(FI<String> fis) {}\n\tvoid test() {\n\t\tconsumer(String[]::clone);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug459967_Array_clone_b() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\ninterface FI<T> {\n\t@NonNull T @NonNull[] getArray(T[] orig);}\npublic class X {\n\tvoid consumer(FI<String> fis) {}\n\tvoid test() {\n\t\tconsumer(String[]::clone);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 7)\n\tconsumer(String[]::clone);\n\t         ^^^^^^^^^^^^^^^\nNull type safety at method return type: Method descriptor FI<String>.getArray(String[]) promises '@NonNull String @NonNull[]' but referenced method provides 'String @NonNull[]'\n----------\n");
    }

    public void testBug448709_allocationExpression1() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\ninterface F0<T> {}\nclass FI<@Nullable T> implements F0<T> {\n}\npublic abstract class X {\n\tabstract <Z> Z zork(F0<Z> f);\n\t@NonNull String test() {\n\t\t return zork(new FI<>());\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\treturn zork(new FI<>());\n\t            ^^^^^^^^^^\nNull type mismatch (type annotations): required 'F0<@NonNull String>' but this expression has type 'FI<@Nullable String>', corresponding supertype is 'F0<@Nullable String>'\n----------\n");
    }

    public void testBug448709_allocationExpression2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nclass F {\n\t<@Nullable U> F(U arg1, U arg2) {}\n}\npublic class X {\n\tF f = new <@NonNull Integer>F(1,2);\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\tF f = new <@NonNull Integer>F(1,2);\n\t           ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Integer' is not a valid substitute for the type parameter '@Nullable U'\n----------\n");
    }

    public void testBug448709_allocationExpression3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tclass F {\n\t\t<@Nullable U> F(U arg1, U arg2) {}\n\t}\n\tF f = this.new <@NonNull Integer>F(1,2);\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\tF f = this.new <@NonNull Integer>F(1,2);\n\t                ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Integer' is not a valid substitute for the type parameter '@Nullable U'\n----------\n");
    }

    public void testBug465513() {
        this.runConformTestWithLibs(new String[]{"pack1/A.java", "package pack1;\r\nimport java.math.BigInteger;\r\n\r\ninterface A { Object m(Class c); }\r\ninterface B<S extends Number> { Object m(Class<S> c); }\r\ninterface C<T extends BigInteger> { Object m(Class<T> c); }\r\n@FunctionalInterface\r\ninterface D<S,T> extends A, B<BigInteger>, C<BigInteger> {}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in pack1\\A.java (at line 4)\n\tinterface A { Object m(Class c); }\n\t                       ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n");
    }

    public void testBug455180() {
        this.runConformTestWithLibs(true, new String[]{"projA/GenericType.java", "package projA;\npublic class GenericType<T> {\n}\n", "projA/ClassWithRawUsage.java", "package projA;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class ClassWithRawUsage {\n   public java.util.List<GenericType> method() {\n           throw new RuntimeException();\n   }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in projA\\ClassWithRawUsage.java (at line 4)\n\tpublic java.util.List<GenericType> method() {\n\t                      ^^^^^^^^^^^\nGenericType is a raw type. References to generic type GenericType<T> should be parameterized\n----------\n");
        this.runConformTestWithLibs(false, new String[]{"projB/ClassThatImports.java", "package projB;\nimport projA.ClassWithRawUsage;\nimport projA.GenericType;\nimport org.eclipse.jdt.annotation.*;\npublic class ClassThatImports {\n\tvoid test(ClassWithRawUsage cwru) {\n\t\t@NonNull GenericType gt = cwru.method().get(0);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in projB\\ClassThatImports.java (at line 7)\n\t@NonNull GenericType gt = cwru.method().get(0);\n\t         ^^^^^^^^^^^\nGenericType is a raw type. References to generic type GenericType<T> should be parameterized\n----------\n2. INFO in projB\\ClassThatImports.java (at line 7)\n\t@NonNull GenericType gt = cwru.method().get(0);\n\t                          ^^^^^^^^^^^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type '@NonNull List<@NonNull GenericType>'. Type 'List<E>' doesn't seem to be designed with null type annotations in mind\n----------\n");
    }

    public void testBug455180WithOtherAnnotation() {
        this.runConformTestWithLibs(new String[]{"proj0/MyAnnotation.java", "package proj0;\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.CLASS)@java.lang.annotation.Target({ java.lang.annotation.ElementType.TYPE_USE })public @interface MyAnnotation {}"}, null, "");
        this.runConformTestWithLibs(false, new String[]{"projA/GenericType.java", "package projA;\npublic class GenericType<T> {\n}\n", "projA/ClassWithRawUsage.java", "package projA;\npublic class ClassWithRawUsage {\n   public java.util.List<@proj0.MyAnnotation GenericType> method() {\n      \t\tthrow new RuntimeException();\n   }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in projA\\ClassWithRawUsage.java (at line 3)\n\tpublic java.util.List<@proj0.MyAnnotation GenericType> method() {\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nGenericType is a raw type. References to generic type GenericType<T> should be parameterized\n----------\n");
        this.runWarningTestWithLibs(false, new String[]{"projB/ClassThatImports.java", "package projB;\nimport projA.ClassWithRawUsage;\nimport projA.GenericType;\npublic class ClassThatImports {\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in projB\\ClassThatImports.java (at line 2)\n\timport projA.ClassWithRawUsage;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nThe import projA.ClassWithRawUsage is never used\n----------\n2. WARNING in projB\\ClassThatImports.java (at line 3)\n\timport projA.GenericType;\n\t       ^^^^^^^^^^^^^^^^^\nThe import projA.GenericType is never used\n----------\n");
    }

    public void testBug466713() {
        this.runConformTestWithLibs(new String[]{"Bug.java", "class Bug {\n    java.util.Iterator<int @org.eclipse.jdt.annotation.Nullable []> x;\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug466713b() {
        this.runNegativeTestWithLibs(new String[]{"Bug.java", "import org.eclipse.jdt.annotation.*;\nclass Bug {\n    java.util.Iterator<@Nullable int @Nullable []> x;\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Bug.java (at line 3)\n\tjava.util.Iterator<@Nullable int @Nullable []> x;\n\t                   ^^^^^^^^^\nThe nullness annotation @Nullable is not applicable for the primitive type int\n----------\n");
    }

    public void testBug466713c() {
        this.runConformTestWithLibs(new String[]{"MyAnnot.java", "import java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface MyAnnot {}\n", "Bug.java", "class Bug {\n    java.util.Iterator<@MyAnnot int @org.eclipse.jdt.annotation.Nullable []> x;\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug466713d() {
        this.runNegativeTest(new String[]{"MyAnnot.java", "import java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface MyAnnot {}\n", "Bug.java", "class Bug {\n\tboolean test(Object o) {\n\t\treturn o instanceof java.util.Iterator<java.lang. @MyAnnot @org.eclipse.jdt.annotation.Nullable String>;\n\t}\n}\n"}, "----------\n1. ERROR in Bug.java (at line 3)\n\treturn o instanceof java.util.Iterator<java.lang. @MyAnnot @org.eclipse.jdt.annotation.Nullable String>;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type Iterator<String>. Use the form Iterator<?> instead since further generic type information will be erased at runtime\n----------\n2. ERROR in Bug.java (at line 3)\n\treturn o instanceof java.util.Iterator<java.lang. @MyAnnot @org.eclipse.jdt.annotation.Nullable String>;\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n", this.LIBS, true);
    }

    public void testBug466969() {
        this.runConformTestWithLibs(new String[]{"GenericType.java", "public abstract class GenericType<T extends @org.eclipse.jdt.annotation.NonNull Runnable> {\n\tabstract T get();\n}", "WildcardUsage.java", "import static org.eclipse.jdt.annotation.DefaultLocation.*;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault({ ARRAY_CONTENTS, FIELD, PARAMETER, RETURN_TYPE, TYPE_ARGUMENT, TYPE_BOUND, TYPE_PARAMETER })\npublic class WildcardUsage {\n\tvoid f(GenericType<?> p) {\n\t\tp.get().run();\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug467032() {
        this.runConformTestWithLibs(new String[]{"Class1.java", "class Class1 {;\n   enum E {}\n   void m1(E @org.eclipse.jdt.annotation.Nullable [] a) {}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"Class2.java", "class Class2 {;\n  Class1 x;}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug467430() {
        this.runConformTestWithLibs(new String[]{"A.java", "public class A {\n\t@org.eclipse.jdt.annotation.NonNullByDefault\n\tvoid m(java.util.@org.eclipse.jdt.annotation.Nullable Map<String, Integer> map) {\n\t}\n\tvoid m2(A a) {\n\t\tfinal java.util.Map<String, Integer> v = null;\n\t\ta.m(v);\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug467430mismatch() {
        this.runConformTestWithLibs(new String[]{"A.java", "public class A {\n\t@org.eclipse.jdt.annotation.NonNullByDefault\n\tvoid m(java.util.@org.eclipse.jdt.annotation.Nullable Map<String, Integer> map) {\n\t}\n\tvoid m2(A a) {\n\t\tfinal java.util.Map<String, @org.eclipse.jdt.annotation.Nullable Integer> v = null;\n\t\ta.m(v);\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug467430array() {
        this.runConformTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n\t@NonNullByDefault\n\tvoid m(@NonNull String @Nullable [] array) {\n\t}\n\tvoid m2(A a) {\n\t\tfinal String[] v = null;\n\t\ta.m(v);\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug467430arrayMismatch() {
        this.runConformTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n\t@NonNullByDefault\n\tvoid m(@NonNull String @Nullable [] array) {\n\t}\n\tvoid m2(A a) {\n\t\tfinal @Nullable String @Nullable [] v = null;\n\t\ta.m(v);\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug446217() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.classLibraries = this.LIBS;
        runner.testFiles = new String[]{"sol/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage sol;", "sol/FuncList.java", "\npackage sol;\n\ninterface FuncList<A> {}\n\t\n@SuppressWarnings(\"unused\")\nfinal class Node<A> implements FuncList<A> {\n\tprivate final A a;\n\tprivate final FuncList<A> tail;\n\t\n\tNode(final A a, final FuncList<A> tail) {\n\t\tthis.a = a;\n\t\tthis.tail = tail;\n\t}\n}\n\nfinal class Empty<A> implements FuncList<A> {\n\tEmpty() {}\n}\n", "sol/Test.java", "package sol;\n\npublic class Test {\n\tpublic static void main(final String[] args) {\n\t\t System.out.println(new Node<>(\"A\", new Empty<>()));\n\t}\n}\n"};
        runner.javacTestOptions = new AbstractRegressionTest.JavacTestOptions.SuppressWarnings("auxiliaryclass");
        runner.runConformTest();
    }

    public void testBug456584() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables", "warning");
        this.runWarningTestWithLibs(true, new String[]{"Test.java", "import java.util.*;\nimport java.util.function.*;\nimport org.eclipse.jdt.annotation.*;\n\n@NonNullByDefault\npublic class Test {\n\n  public static final <T,R> @NonNull R applyRequired(final T input, final Function<? super T,? extends R> function) { // Warning on '@NonNull R': \"The nullness annotation is redundant with a default that applies to this location\"\n    return Objects.requireNonNull(function.apply(input));\n  }\n\n}\n"}, compilerOptions, "----------\n1. INFO in Test.java (at line 9)\n\treturn Objects.requireNonNull(function.apply(input));\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on substitution 'T=@NonNull capture#of ? extends R'. Declaring type 'Objects' doesn't seem to be designed with null type annotations in mind\n----------\n2. WARNING in Test.java (at line 9)\n\treturn Objects.requireNonNull(function.apply(input));\n\t                              ^^^^^^^^^^^^^^^^^^^^^\nNull type safety: required '@NonNull' but this expression has type 'capture#2-of ? extends R', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug447661() {
        this.runConformTestWithLibs(new String[]{"Two.java", "import java.util.*;\npublic class Two {\n\n\t@org.eclipse.jdt.annotation.NonNullByDefault\n\tpublic static Set<String> getSet() {\n\t\treturn new HashSet<>();\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"One.java", "import java.util.*;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class One {\n\n\tpublic void test() {\n\t\tSet<String> set = Two.getSet();\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug436091() {
        this.runConformTestWithLibs(new String[]{"p/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p;\n", "p/Program.java", "package p;\npublic class Program {\n\tprivate final ProgramNode program;\n\t\tpublic Program(final ProgramNode astRoot) {\n\t\tprogram = astRoot;\n\t}\n\t\tpublic Integer execute() {\n\t\treturn program.accept(ExecutionEvaluationVisitor.VISITOR);\n\t}\n\t\tclass ProgramNode {\n\t\tpublic <R> R accept(final ConcreteNodeVisitor<R> visitor) {\n\t\t\treturn visitor.visit(this);\n\t\t}\n\t}\n}\n", "p/ConcreteNodeVisitor.java", "package p;\nimport p.Program.ProgramNode;\npublic interface ConcreteNodeVisitor<R> {\n\tR visit(ProgramNode node);\n}\n", "p/ExecutionEvaluationVisitor.java", "package p;\nimport org.eclipse.jdt.annotation.NonNull;\nimport p.Program.ProgramNode;\npublic enum ExecutionEvaluationVisitor implements ConcreteNodeVisitor<Integer> {\n\t\tVISITOR;\n\t\t@Override\tpublic Integer visit(final ProgramNode node) {\n\t\t@SuppressWarnings(\"null\")\n\t\t@NonNull\n\t\tfinal Integer i = Integer.valueOf(0);\n\t\treturn i;\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"p/Program.java", "package p;\npublic class Program {\n\tprivate final ProgramNode program;\n\t\tpublic Program(final ProgramNode astRoot) {\n\t\tprogram = astRoot;\n\t}\n\t\tpublic Integer execute() {\n\t\treturn program.accept(ExecutionEvaluationVisitor.VISITOR);\n\t}\n\t\tclass ProgramNode {\n\t\tpublic <R> R accept(final ConcreteNodeVisitor<R> visitor) {\n\t\t\treturn visitor.visit(this);\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug474239() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runConformTestWithLibs(new String[]{"Test.java", "public class Test {\n\tstatic String s1 = null, s2 = null;\n\n\tpublic static void main(String[] args) {\n\t\tint val = (int) System.currentTimeMillis();\n\t\tswitch (val % 2) {\n\t\tcase 0:\n\t\t\tif (s1 != null)\n\t\t\t\ts2 = \"\";\n\t\t\tbreak;\n\t\tcase 1:\n\t\t\tif (s1 != null) // compiler thinks s1 is never null at this point\n\t\t\t\tthrow new RuntimeException(\"\");\n\t\t\tbreak;\n\t\t}\n\t}\n}\n"}, options, "");
    }

    public void testBug467482() {
        this.runConformTestWithLibs(new String[]{"Util.java", "public abstract class Util {\n\tpublic static <T> @org.eclipse.jdt.annotation.Nullable T f(T[] valuesArray, java.util.Comparator<T> comparator) {\n\t\t@org.eclipse.jdt.annotation.Nullable\n\t\tT winner = null;\n\t\tfor (T value : valuesArray) {\n\t\t\tif (winner == null) {\n\t\t\t\twinner = value;\n\t\t\t} else {\n\t\t\t\tif (comparator.compare(winner, value) < 0) {\n\t\t\t\t\twinner = value;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn winner;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug467482simple() {
        this.runConformTestWithLibs(new String[]{"Util.java", "public abstract class Util {\npublic static void f(Object unknown) {\n\t@org.eclipse.jdt.annotation.Nullable\n\tObject winner = null;\n\tfor (int i = 0; i < 1; i++) {\n\t\t\twinner = unknown;\n\t}\n\tif (winner == null) {\n\t\tassert false;\n\t}\n}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug467482while() {
        this.runConformTestWithLibs(new String[]{"Util.java", "public abstract class Util {\npublic static void f(Object unknown, boolean flag) {\n\t@org.eclipse.jdt.annotation.Nullable\n\tObject winner = null;\n\twhile (flag) {\n\t\t\twinner = unknown;\n\t\t\tflag = false;\n\t}\n\tif (winner == null) {\n\t\tassert false;\n\t}\n}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug467482switch() {
        this.runConformTestWithLibs(new String[]{"Util.java", "public abstract class Util {\npublic static void f(Object unknown, boolean flag) {\n\t@org.eclipse.jdt.annotation.Nullable\n\tObject winner = null;\n\tswitch (1) {\n\tcase 1:\twinner = unknown;\n\t}\n\tif (winner == null) {\n\t\tassert false;\n\t}\n}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug467482regression() {
        this.runNegativeTestWithLibs(new String[]{"Check.java", "public abstract class Check {\n\tpublic static void check(@org.eclipse.jdt.annotation.NonNull Object x) {\n\t}\n\tpublic static void f(Object unknown, boolean flag) {\n\t\tcheck(unknown); // expected: null type safety warning\n\t\t@org.eclipse.jdt.annotation.Nullable\n\t\tObject nullable = unknown;\n\t\tcheck(nullable); // expected: null type mismatch error\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Check.java (at line 5)\n\tcheck(unknown); // expected: null type safety warning\n\t      ^^^^^^^\nNull type safety (type annotations): The expression of type 'Object' needs unchecked conversion to conform to '@NonNull Object'\n----------\n2. ERROR in Check.java (at line 8)\n\tcheck(nullable); // expected: null type mismatch error\n\t      ^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable Object'\n----------\n");
    }

    public void testBug484735() {
        this.runConformTestWithLibs(new String[]{"test/NullabilityLoopBug.java", "package test;\n\nimport java.util.HashMap;\nimport java.util.Map;\nimport java.util.Map.Entry;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class NullabilityLoopBug {\n\n\tpublic static void main(String[] args)\n\t{\n\t\tMap<String, String> map = new HashMap<>();\n\t\t\n\t\tmap.put(\"key\", \"value\");\n\t\t\n\t\tSystem.out.println(getKeyByValue(map, \"value\"));\n\t}\n\t\n\tprivate static <K, V> K getKeyByValue(Map<K, V> map, @Nullable V value)\n\t{\n\t\t@Nullable K result = null; // some nullability bug? assigning null results in compiler complaining 'result can only be null' below\n\t\tfor (Entry<K, V> entry : map.entrySet())\n\t\t{\n\t\t\tboolean equals;\n\t\t\tif (value == null)\n\t\t\t\tequals = (entry.getValue() == null);\n\t\t\telse\n\t\t\t\tequals = value.equals(entry.getValue());\n\t\t\t\n\t\t\tif (equals)\n\t\t\t{\n\t\t\t\tif (result == null) // Incorrect warning: Redundant null check: The variable result can only be null at this location\n\t\t\t\t\tresult = entry.getKey();\n\t\t\t\telse\n\t\t\t\t\tthrow new IllegalStateException(\"Multiple matches for looking up key via value [\" + value + \"]: [\" + result + \"] and [\" + entry.getKey() + \"]\");\n\t\t\t}\n\t\t}\n\t\t\n\t\tif (result == null) // Incorrect warning: Redundant null check: The variable result can only be null at this location\n\t\t\tthrow new IllegalStateException(\"No matches for looking up key via value [\" + value + \"]\");\n\t\t\n\t\treturn result; // Incorrect warning: Dead code\n\t}\n}\n"}, this.getCompilerOptions(), "", "key");
    }

    public void testBug474239b() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runConformTestWithLibs(new String[]{"Test.java", "public class Test {\n\tstatic String s2 = null;\n\n\tpublic static void main(String[] args) {\n\t\tint val = (int) System.currentTimeMillis();\n\t\tswitch (val % 2) {\n\t\tcase 0:\n\t\t\ts2 = \"\";\n\t\t\tbreak;\n\t\tcase 1:\n\t\t\tif (s2 != null)\n\t\t\t\tthrow new RuntimeException(\"\");\n\t\t\tbreak;\n\t\t}\n\t}\n}\n"}, options, "");
    }

    public void testBug472663() {
        this.runConformTestWithLibs(new String[]{"test/Callee.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Callee {\n\tpublic static String staticOtherClass(String foo) {\n\t\treturn foo;\n\t}\n\n\tpublic String instanceOtherClass(String foo) {\n\t\treturn foo;\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test/Caller.java", "package test;\n\nimport java.util.function.Function;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Caller {\n\tpublic void foo(final Callee callee) {\n\t\tFunction<String, String> function;\n\n\t\t// assignments with warnings (wrong):\n\t\tfunction = Callee::staticOtherClass;\n\t\tfunction = callee::instanceOtherClass;\n\n\t\t// assignments with no warnings (ok):\n\t\tfunction = foo -> Callee.staticOtherClass(foo);\n\t\tfunction = foo -> callee.instanceOtherClass(foo);\n\t\tfunction = Caller::staticSameClass;\n\t\tfunction = this::instanceSameClass;\n\t}\n\n\tpublic static String staticSameClass(String foo) {\n\t\treturn foo;\n\t}\n\n\tpublic String instanceSameClass(String foo) {\n\t\treturn foo;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug467094() {
        this.runConformTestWithLibs(new String[]{"A.java", "class A {;\n   @org.eclipse.jdt.annotation.NonNull String @org.eclipse.jdt.annotation.Nullable [] x;\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug467094_local() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "public class X {\n\tvoid foo(@org.eclipse.jdt.annotation.NonNull Object[] o) {\n\t\to.hashCode();\n\t\tif (o != null) {\n\t\t\tSystem.out.print(o.toString());\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\tif (o != null) {\n\t    ^\nRedundant null check: The variable o cannot be null at this location\n----------\n");
    }

    public void testBug467094_method() {
        this.runConformTestWithLibs(new String[]{"A.java", "class A {;\n\t@org.eclipse.jdt.annotation.NonNull String @org.eclipse.jdt.annotation.Nullable [] m(){\n\t\treturn null;\n\t}\n\tint usage(){\n\t\tif(m() == null) return 1; \n\t\treturn 0; \n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug440398() {
        this.runConformTestWithLibs(new String[]{"NullTest.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault({})\r\npublic class NullTest {\r\n    public static @NonNull Object[] obj = null;\r\n    public static void main(String[] args) {\r\n        obj = null;\r\n        if (obj == null) { // WARNING 1\r\n            System.out.println(\"NULL\"); // WARNING 2\r\n        }\r\n    }\r\n}\n"}, this.getCompilerOptions(), "", "NULL");
    }

    public void testBug440398_comment2() {
        this.runConformTestWithLibs(new String[]{"MyClass.java", "import org.eclipse.jdt.annotation.*;\n\n@NonNullByDefault({DefaultLocation.FIELD})\npublic class MyClass {\n    private @NonNull String [] names = new @NonNull String[]{\"Alice\", \"Bob\", \"Charlie\"};\n\n    public String getName(int index) {\n        String name = names[index];\n        return name; /* statement A */\n    }\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug440398_comment2a() {
        this.runConformTestWithLibs(new String[]{"p/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault({org.eclipse.jdt.annotation.DefaultLocation.FIELD})\npackage p;\n", "p/MyClass.java", "package p;\nimport org.eclipse.jdt.annotation.*;\n\npublic class MyClass {\n    private @NonNull String [] names = new @NonNull String[]{\"Alice\", \"Bob\", \"Charlie\"};\n\n    public String getName(int index) {\n        String name = names[index];\n        return name; /* statement A */\n    }\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug481332() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n\tpublic void foo() {\n\t\t@Nullable\n\t\tList<@NonNull String> list = new ArrayList<>();\n\t\tcheckNotNull(list); // OK\n\n\t\t@Nullable\n\t\tMap<@NonNull String, @NonNull String> map = new HashMap<>();\n\t\tcheckNotNull(map); // OK\n\n\t\t@NonNull\n\t\tObject @Nullable [] objects = new @NonNull Object[0];\n\t\t// Error: Null type mismatch (type annotations): required '@NonNull Object @NonNull[]' but this expression ...\n\t\tcheckNotNull(objects);\n\t}\n\t\n\tpublic static <@Nullable T> T[] checkNotNull(T @Nullable [] array) {\n\t\tif (array == null) {\n\t\t\tthrow new NullPointerException();\n\t\t}\n\t\treturn array;\n\t}\n\n\tpublic static <@Nullable T, C extends Iterable<T>> C checkNotNull(@Nullable C container) {\n\t\tif (container == null) {\n\t\t\tthrow new NullPointerException();\n\t\t}\n\t\treturn container;\n\t}\n\n\tpublic static <@Nullable K, @Nullable V, M extends Map<K, V>> M checkNotNull(@Nullable M map) {\n\t\tif (map == null) {\n\t\t\tthrow new NullPointerException();\n\t\t}\n\t\treturn map;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 7)\n\tcheckNotNull(list); // OK\n\t^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type 'List<@NonNull String>' is not a valid substitute for the type parameter 'C extends Iterable<@Nullable T>'\n----------\n2. ERROR in X.java (at line 11)\n\tcheckNotNull(map); // OK\n\t^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type 'Map<@NonNull String,@NonNull String>' is not a valid substitute for the type parameter 'M extends Map<@Nullable K,@Nullable V>'\n----------\n3. ERROR in X.java (at line 16)\n\tcheckNotNull(objects);\n\t             ^^^^^^^\nNull type mismatch (type annotations): required '@Nullable Object @Nullable[]' but this expression has type '@NonNull Object @Nullable[]'\n----------\n");
    }

    public void testBug481322a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass Super<S, T extends List<S>> {\n\tS pick(T list) {\n\t\treturn list.get(0);\n\t}\n}\npublic class X extends Super<@NonNull String, List<@Nullable String>> {\n\t@Override\n\tpublic @NonNull String pick(List<@Nullable String> list) {\n\t\treturn super.pick(list);\n\t}\n\tpublic static void main(String[] args) {\n\t\tList<@Nullable String> withNulls = new ArrayList<@Nullable String>();\n\t\twithNulls.add(null);\n\t\tSystem.out.println(new X().pick(withNulls).toUpperCase());\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 9)\n\treturn list.get(0);\n\t       ^^^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in X.java (at line 12)\n\tpublic class X extends Super<@NonNull String, List<@Nullable String>> {\n\t                                              ^^^^\nNull constraint mismatch: The type 'List<@Nullable String>' is not a valid substitute for the type parameter 'T extends List<S>'\n----------\n");
    }

    public void testBug477719() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation", "ignore");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        runner.classLibraries = this.LIBS;
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull Number instantiate(@NonNull Class<? extends @NonNull Number> c) throws Exception {\n\t\treturn c.newInstance();\n\t}\n\tvoid test(Double d) throws Exception {\n\t\tinstantiate(Integer.class);\n\t\tinstantiate(d.getClass());\n\t}\n}\n"};
        runner.javacTestOptions = new AbstractRegressionTest.JavacTestOptions.SuppressWarnings("deprecation");
        runner.runConformTest();
    }

    public void testBug482247() {
        this.runWarningTestWithLibs(true, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull String @NonNull[] s1 = new String[0];\n\t@Nullable String @NonNull[] s2 = new String[0];\n\t<T> @NonNull T first(@NonNull T @NonNull[] arr) {\n\t\treturn arr[0];\n\t}\n\tvoid other(@Nullable String[] s) {\n\t\ts[0] = null;\n\t}\n\t@NonNull String test()  {\n\t\tother(new String[0]);\n\t\treturn first(new String[0]);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 12)\n\tother(new String[0]);\n\t      ^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@Nullable String []'\n----------\n2. WARNING in X.java (at line 13)\n\treturn first(new String[0]);\n\t             ^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@NonNull String @NonNull[]'\n----------\n");
    }

    public void testBug482247_comment5() {
        this.runConformTestWithLibs(new String[]{"Snippet.java", "import org.eclipse.jdt.annotation.*;\npublic class Snippet {\n\t@NonNull String[] s1 = new String[0]; // No warning\n\tpublic void handleIncidentBeforeCreate() {\n\t\t@NonNull String[] s = new String[0]; // Warning\n\t\tString [] @NonNull[] s2 = new String[0][];\n\t\tString [] @NonNull[] @Nullable[] s3 = new String[0][][];\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug483146() {
        this.runConformTestWithLibs(new String[]{"Foo.java", "import java.util.ArrayList;\nimport java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass Foo {\n\n\tvoid example1() {\n        @Nullable List<String> container = new ArrayList<>();\n        @NonNull List<String> list = checkNotNull(container);\n\t}\n\n\tvoid example2() {\n        @Nullable List<String> container= new ArrayList<>();\n        @NonNull List<String> list = checkNotNull(container);\n\t}\n    \n    @NonNull <T, C extends  Iterable<T>> C checkNotNull(C container) {\n        if (container == null) {\n            throw new NullPointerException();\n        }\n\t\treturn container;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug483146b() {
        this.runConformTestWithLibs(new String[]{"Foo.java", "import java.util.ArrayList;\nimport java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass Foo {\n\n\tvoid example1() {\n        @Nullable List<String> container = new ArrayList<>();\n        @NonNull List<String> list = checkNotNull(container);\n\t}\n\n\tvoid example2() {\n        @Nullable List<String> container= new ArrayList<>();\n        @NonNull List<String> list = checkNotNull(container);\n\t}\n    \n    <T, C extends  Iterable<T>> @NonNull C checkNotNull(@Nullable C container) {\n        if (container == null) {\n            throw new NullPointerException();\n        }\n\t\treturn container;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug473713() {
        this.runConformTestWithLibs(new String[]{"a/A1.java", "package a;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class A1 {\n\tpublic class NestedInA1 {\n\t}\n}\n", "a/A2.java", "package a;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class A2 {\n\tpublic static abstract class NestedInA2 {\n\t\tpublic final A1 a1 = new A1();\n\t\tprotected abstract void handleApplicationSpecific(A1.NestedInA1 detail);\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"b/B.java", "package b;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class B {\n\tpublic static a.A1 m(a.A2.NestedInA2 nestedInA2) {\n\t\treturn nestedInA2.a1;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug482228() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass Super<S> {\n\t<T extends List<S>> S pick(T list) {\n\t\treturn list.get(0);\n\t}\n}\npublic class X extends Super<@NonNull String> {\n\t@Override\n\t<T extends List<@Nullable String>> @NonNull String pick(T list) {\n\t\treturn super.pick(list);\n\t}\n\tpublic static void main(String[] args) {\n\t\tList<@Nullable String> withNulls = new ArrayList<>();\n\t\twithNulls.add(null);\n\t\tSystem.out.println(new X().pick(withNulls).toUpperCase());\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 9)\n\treturn list.get(0);\n\t       ^^^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in X.java (at line 14)\n\t<T extends List<@Nullable String>> @NonNull String pick(T list) {\n\t ^\nCannot redefine null constraints of type variable 'T extends List<@NonNull String>' declared in 'Super<String>.pick(T)'\n----------\n3. ERROR in X.java (at line 15)\n\treturn super.pick(list);\n\t       ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type 'T extends List<@Nullable String>' is not a valid substitute for the type parameter 'T extends List<@NonNull String>'\n----------\n");
    }

    public void testBug483527() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runConformTestWithLibs(new String[]{"Test.java", "public class Test  {\n    static final short foo;\n\tstatic {\n\t\tfoo = 1;\n\t\tfor (int i=0; i<10; i++) {\n\t\t}\n\t}\n}\n"}, compilerOptions, "");
    }

    public void testMultipleAnnotations1() {
        HashMap<String, String> options1 = new HashMap<String, String>(this.getCompilerOptions());
        options1.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.NonNull");
        options1.put("org.eclipse.jdt.core.compiler.annotation.nullable", "org.foo.Nullable");
        this.runConformTest(new String[]{"org/foo/Nullable.java", "package org.foo;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({ElementType.TYPE_USE})\npublic @interface Nullable {}\n", "org/foo/NonNull.java", "package org.foo;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({ElementType.TYPE_USE})\npublic @interface NonNull {}\n", "p1/TestNulls.java", "package p1;\nimport org.foo.*;\n\npublic class TestNulls {\n\tpublic @Nullable String weaken(@NonNull String theValue) {\n\t\treturn theValue;\n\t}\n\n}"}, options1);
        Map options2 = this.getCompilerOptions();
        options2.put("org.eclipse.jdt.core.compiler.annotation.nonnull.secondary", "org.foo.NonNull");
        options2.put("org.eclipse.jdt.core.compiler.annotation.nullable.secondary", "org.foo.Nullable");
        this.runNegativeTestWithLibs(new String[]{"p2/Test.java", "package p2;\nimport p1.TestNulls;\nimport org.eclipse.jdt.annotation.*;\npublic class Test {\n\t@NonNull String test(TestNulls test, @Nullable String input) {\n\t\treturn test.weaken(input);\n\t}\n}\n"}, options2, "----------\n1. ERROR in p2\\Test.java (at line 6)\n\treturn test.weaken(input);\n\t       ^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n2. ERROR in p2\\Test.java (at line 6)\n\treturn test.weaken(input);\n\t                   ^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void test483952() {
        this.runConformTestWithLibs(new String[]{"test/Test.java", "package test;\nimport java.util.function.Function;\nimport org.eclipse.jdt.annotation.Nullable;\npublic class Test {\n\tvoid test1() {\n\t\tFunction function = x -> x;\n\t\tString @Nullable [] z = test2(function, \"\");\n\t}\n\t<T> T @Nullable [] test2(Function<T, T> function, T t) {\n\t\treturn null;\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. WARNING in test\\Test.java (at line 6)\n\tFunction function = x -> x;\n\t^^^^^^^^\nFunction is a raw type. References to generic type Function<T,R> should be parameterized\n----------\n2. WARNING in test\\Test.java (at line 7)\n\tString @Nullable [] z = test2(function, \"\");\n\t                        ^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation test2(Function, String) of the generic method test2(Function<T,T>, T) of type Test\n----------\n3. WARNING in test\\Test.java (at line 7)\n\tString @Nullable [] z = test2(function, \"\");\n\t                              ^^^^^^^^\nType safety: The expression of type Function needs unchecked conversion to conform to Function<String,String>\n----------\n");
    }

    public void test484055() {
        this.runConformTestWithLibs(new String[]{"B.java", "interface A {\n\tpublic void f(String[] x);\n\n\tpublic void f2(String x);\n}\n\npublic class B implements A {\n\tpublic void f(String @org.eclipse.jdt.annotation.Nullable [] x) {\n\t}\n\n\tpublic void f2(@org.eclipse.jdt.annotation.Nullable String x) {\n\t}\n}"}, null, "");
    }

    public void testBug484108() {
        this.runConformTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic interface Test <T0 extends Other> {\n    public void a ( @NonNull T0 test );\n}\n", "test/Other.java", "package test;\n\npublic interface Other { }\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test/TestImpl.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport java.lang.reflect.*;\n\npublic class TestImpl <T extends Other> implements Test<T> {\n\n    /**\n     * {@inheritDoc}\n     *\n     * @see test.Test#a(java.lang.Object)\n     */\n    @Override\n    public void a ( @NonNull T test ) {\n    }\n\tpublic static void main(String... args) {\n\t\tClass<?> c = TestImpl.class;\n\t\tMethod[] ms = c.getDeclaredMethods();\n\t\tSystem.out.println(ms.length);\n\t}\n}\n"}, this.getCompilerOptions(), "", "2");
    }

    public void testBug484954() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "org.foo.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.NonNull");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runConformTest(new String[]{"org/foo/Nullable.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface Nullable {\n}\n", "org/foo/NonNull.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface NonNull {\n}\n", "Snippet.java", "import java.util.function.*;\nimport org.foo.*;\n\npublic class Snippet {\n\n\tpublic void test() {\n\t\tdoStuff((@NonNull Object[] data) -> updateSelectionData(data)); \n\t}\n\n\tprivate void doStuff(Consumer<Object[]> postAction) { }\n\tprivate void updateSelectionData(final @NonNull Object data) { }\n}\n"}, customOptions, "");
    }

    public void testBug484981() {
        this.runNegativeTestWithLibs(new String[]{"test1/GenericWithNullableBound.java", "package test1;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n@NonNullByDefault\npublic class GenericWithNullableBound<T extends @Nullable Number> {\n}\n", "test1/GenericWithNullableBound2.java", "package test1;\nimport static java.lang.annotation.ElementType.TYPE_USE;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n@Retention(RetentionPolicy.CLASS)\n@Target({ TYPE_USE })\n@interface SomeAnnotation {\n}\n@NonNullByDefault\npublic class GenericWithNullableBound2<@SomeAnnotation T extends @Nullable Number> {\n}\n", "test1/GenericWithNullable.java", "package test1;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n@NonNullByDefault\npublic class GenericWithNullable<@Nullable T> {\n}\n", "test1/GenericWithNonNullBound.java", "package test1;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class GenericWithNonNullBound<T extends @NonNull Number> {\n}\n", "test1/ClassInSameProject.java", "package test1;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\npublic class ClassInSameProject {\n\tstatic void f1() {\n\t\tnew GenericWithNullableBound<@NonNull Number>();\n\t}\n\tstatic void f2() {\n\t\tnew GenericWithNullableBound2<@NonNull Number>();\n\t}\n\tstatic void f3() {\n\t\tnew GenericWithNonNullBound<@Nullable Number>(); // error 1 expected\n\t}\n\tstatic void f4() {\n\t\tnew GenericWithNullable<@NonNull Number>(); // error 2 expected\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in test1\\ClassInSameProject.java (at line 12)\n\tnew GenericWithNonNullBound<@Nullable Number>(); // error 1 expected\n\t                            ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable Number' is not a valid substitute for the type parameter 'T extends @NonNull Number'\n----------\n2. ERROR in test1\\ClassInSameProject.java (at line 15)\n\tnew GenericWithNullable<@NonNull Number>(); // error 2 expected\n\t                        ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Number' is not a valid substitute for the type parameter '@Nullable T'\n----------\n");
        this.runNegativeTestWithLibs(new String[]{"test2/ClassInOtherProject.java", "package test2;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\nimport test1.GenericWithNonNullBound;\nimport test1.GenericWithNullable;\nimport test1.GenericWithNullableBound;\nimport test1.GenericWithNullableBound2;\npublic class ClassInOtherProject {\n\tstatic void g1() {\n\t\tnew GenericWithNullableBound<@NonNull Number>();\n\t}\n\tstatic void g2() {\n\t\tnew GenericWithNullableBound2<@NonNull Number>();\n\t}\n\tstatic void g3() {\n\t\tnew GenericWithNonNullBound<@Nullable Number>(); // error 3 expected\n\t}\n\tstatic void g4() {\n\t\tnew GenericWithNullable<@NonNull Number>(); // error 4 expected\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in test2\\ClassInOtherProject.java (at line 16)\n\tnew GenericWithNonNullBound<@Nullable Number>(); // error 3 expected\n\t                            ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable Number' is not a valid substitute for the type parameter 'T extends @NonNull Number'\n----------\n2. ERROR in test2\\ClassInOtherProject.java (at line 19)\n\tnew GenericWithNullable<@NonNull Number>(); // error 4 expected\n\t                        ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Number' is not a valid substitute for the type parameter '@Nullable T extends Object'\n----------\n");
    }

    public void testBug484981b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1<T extends @NonNull Object> extends ArrayList<T> {\n    public <U, V extends @Nullable Object> void foo(U u, V v) {}\n}\n", "p/X2.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X2<@Nullable W extends Object> {}\n", "Y1.java", "import p.X1;\nimport p.X2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tX1<@Nullable String> maybeStrings;\n   X2<@NonNull String> strings;\n\tvoid test(X1<@NonNull String> x) {\n\t\tx.<Y1, @NonNull Object>foo(this, new Object());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 5)\n\tX1<@Nullable String> maybeStrings;\n\t   ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter 'T extends @NonNull Object'\n----------\n2. ERROR in Y1.java (at line 6)\n\tX2<@NonNull String> strings;\n\t   ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable W extends Object'\n----------\n");
    }

    public void testBug484981c() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1<T extends java.lang.@NonNull Object> extends ArrayList<T> {\n    public <U, V extends java.lang.@Nullable Object> void foo(U u, V v) {}\n}\n", "p/X2.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X2<@Nullable W extends Object> {}\n", "Y1.java", "import org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tp.X1<java.lang.@Nullable String> maybeStrings;\n   p.X2<java.lang.@NonNull String> strings;\n\tvoid test(p.X1<java.lang.@NonNull String> x) {\n\t\tx.<Y1, java.lang.@NonNull Object>foo(this, new Object());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 3)\n\tp.X1<java.lang.@Nullable String> maybeStrings;\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter 'T extends @NonNull Object'\n----------\n2. ERROR in Y1.java (at line 4)\n\tp.X2<java.lang.@NonNull String> strings;\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable W extends Object'\n----------\n");
    }

    public void testBug484981d() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTestWithLibs(new String[]{"p/List.java", "package p;\npublic interface List<T> {\n\tT get(int i);\n}\n", "p/X1.java", "package p;\nimport java.util.Map;\nimport org.eclipse.jdt.annotation.*;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target(TYPE_USE)\n@interface Immutable {}\npublic abstract class X1 {\n    public <@NonNull U, V extends @Nullable Object> List<@NonNull Map<Object, @NonNull String>> foo(@Immutable X1 this, U u, V v) { return null; }\n}\n", "Y1.java", "import p.X1;\nimport org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tvoid test(X1 x) {\n\t\tx.<@NonNull Y1, @NonNull Object>foo(this, new Object())\n\t\t\t.get(0).put(null, null);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 6)\n\t.get(0).put(null, null);\n\t                  ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug466562() {
        this.runNegativeTestWithLibs(new String[]{"x/C.java", "package x;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n@NonNullByDefault({})\npublic class C <T1 extends @Nullable Number> {\n    String consume(T1 t) {\n        @NonNull Object x = t; // error, should warn?\n        x.toString();\n        return t.toString(); // legal???\n    }\n    void y() {\n        consume(null);  // illegal - OK\n        @NonNull Object t = provide();  // error, should warn?\n        t.toString();\n    }\n    T1 provide() {\n        return null; // error, should warn?\n    }\n    C<Integer> cString;  // OK - Null constraint mismatch: The type 'Integer' is not a valid substitute for the type parameter 'T1 extends @Nullable Number'\n    C<@NonNull Integer> c1String;  // Wrong: Null constraint mismatch: The type '@NonNull Integer' is not a valid substitute for the type parameter 'T1 extends @Nullable Number'\n    C<@Nullable Integer> c2String; // legal - OK\n}"}, this.getCompilerOptions(), "----------\n1. WARNING in x\\C.java (at line 5)\n\t@NonNullByDefault({})\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing package x\n----------\n2. ERROR in x\\C.java (at line 8)\n\t@NonNull Object x = t; // error, should warn?\n\t                    ^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type 'T1 extends @Nullable Number'\n----------\n3. ERROR in x\\C.java (at line 10)\n\treturn t.toString(); // legal???\n\t       ^\nPotential null pointer access: this expression has type 'T1', a free type variable that may represent a '@Nullable' type\n----------\n4. ERROR in x\\C.java (at line 13)\n\tconsume(null);  // illegal - OK\n\t        ^^^^\nNull type mismatch: required 'T1 extends @Nullable Number' but the provided value is null\n----------\n5. ERROR in x\\C.java (at line 14)\n\t@NonNull Object t = provide();  // error, should warn?\n\t                    ^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type 'T1 extends @Nullable Number'\n----------\n6. ERROR in x\\C.java (at line 18)\n\treturn null; // error, should warn?\n\t       ^^^^\nNull type mismatch: required 'T1 extends @Nullable Number' but the provided value is null\n----------\n");
    }

    public void testBug485056() {
        this.runConformTestWithLibs(new String[]{"TestExplainedValue.java", "import java.io.Serializable;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\nclass ExplainedValue<T extends Serializable> {\n\tpublic @Nullable T featureValue;\n}\npublic class TestExplainedValue {\n\tstatic @Nullable Serializable g(ExplainedValue<? extends @NonNull Serializable> explainedValue) {\n\t\treturn explainedValue.featureValue;\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug484741() {
        this.runConformTestWithLibs(new String[]{"test/Test.java", "package test;\n\npublic class Test {\n\tstatic <T, E extends T> void f(java.util.ArrayList<T> list, E element) {\n\t\tlist.add(element);\t}\n\n\tstatic <A> void g(A a) {\n\t\tf(new java.util.ArrayList<A>(), a);\n\t}\n\n\tstatic <T1, E1 extends T1> void h(E1 element1, java.util.ArrayList<T1> list1) {\n\t\tf(list1, element1);\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug484741b() {
        this.runConformTestWithLibs(new String[]{"test/TestDep.java", "package test;\npublic class TestDep {\n\tstatic <T, E extends T> T f(E e) {\n\t\treturn e;\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug484741c() {
        this.runConformTestWithLibs(new String[]{"test/Test3.java", "package test;\nimport org.eclipse.jdt.annotation.DefaultLocation;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault({ DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE, DefaultLocation.FIELD, DefaultLocation.TYPE_ARGUMENT })\nclass Feature3<ValueType extends java.io.Serializable, PartitionKeyType> {\n}\n@NonNullByDefault({ DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE, DefaultLocation.FIELD, DefaultLocation.TYPE_ARGUMENT })\npublic class Test3 {\n\tpublic static <T extends java.io.Serializable, F extends Feature3<T, ?>> T[] getValues(F feature) {\n\t\tthrow new RuntimeException();\n\t}\n\tpublic static void f(Feature3<?, ?> feature) {\n\t\tgetValues(feature);\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug484741d() {
        this.runConformTestWithLibs(new String[]{"BaseNNBD.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npublic class BaseNNBD<S extends Runnable, I extends S> {\n}\n", "DerivedNNBD.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npublic class DerivedNNBD<S1 extends Runnable, I1 extends S1> extends BaseNNBD<S1, I1> {\t\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug484741e() {
        this.runConformTestWithLibs(new String[]{"test/AbstractFeature.java", "package test;\nimport java.io.Serializable;\nimport org.eclipse.jdt.annotation.NonNull;\n\nabstract class AbstractFeature<T extends @NonNull Serializable> {\n}\n", "test/SubFeature.java", "package test;\nimport java.io.Serializable;\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class SubFeature<T1 extends @NonNull Serializable> extends AbstractFeature<T1> {\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug484741Invoke() {
        this.runNegativeTestWithLibs(new String[]{"test/TestInterdepInvoke.java", "package test;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class TestInterdepInvoke {\n\tstatic <T, E extends T> T f1(E e) {\n\t\treturn e;\n\t}\n\n\tstatic <T, @Nullable E extends T> T f2(E e) {\n\t\treturn e; // error 1 expected\n\t}\n\n\tstatic <@Nullable T, E extends T> T f3(E e) {\n\t\treturn e;\n\t}\n\n\tstatic <@Nullable T, @Nullable E extends T> T f4(E e) {\n\t\treturn e;\n\t}\n\n\t// -------- invocations of f1 --------\n\n\tstatic <T11, E11 extends T11> T11 g11(E11 e) {\n\t\treturn f1(e);\n\t}\n\n\tstatic <T12, @Nullable E12 extends T12> T12 g12(E12 e) {\n\t\treturn f1(e); // error 2 expected\n\t}\n\n\tstatic <@Nullable T13, E13 extends T13> T13 g13(E13 e) {\n\t\treturn f1(e);\n\t}\n\n\tstatic <@Nullable T14, @Nullable E14 extends T14> T14 g14(E14 e) {\n\t\treturn f1(e);\n\t}\n\n\t// -------- invocations of f2 --------\n\n\tstatic <T21, E21 extends T21> T21 g21(E21 e) {\n\t\treturn f2(e);\n\t}\n\n\tstatic <T22, @Nullable E22 extends T22> T22 g22(E22 e) {\n\t\treturn f2(e);\n\t}\n\n\tstatic <@Nullable T23, E23 extends T23> T23 g23(E23 e) {\n\t\treturn f2(e);\n\t}\n\n\tstatic <@Nullable T24, @Nullable E24 extends T24> T24 g24(E24 e) {\n\t\treturn f2(e);\n\t}\n\n\t// -------- invocations of f3 --------\n\n\tstatic <T31, E31 extends T31> T31 g31(E31 e) {\n\t\treturn f3(e); // error 3 expected\n\t}\n\n\tstatic <T32, @Nullable E32 extends T32> T32 g32(E32 e) {\n\t\treturn f3(e); // error 4 expected\n\t}\n\n\tstatic <@Nullable T33, E33 extends T33> T33 g33(E33 e) {\n\t\treturn f3(e);\n\t}\n\n\tstatic <@Nullable T34, @Nullable E34 extends T34> T34 g34(E34 e) {\n\t\treturn f3(e);\n\t}\n\n\t// -------- invocations of f4 --------\n\n\tstatic <T41, E41 extends T41> T41 g41(E41 e) {\n\t\treturn f4(e); /// error 5 expected\n\t}\n\n\tstatic <T42, @Nullable E42 extends T42> T42 g42(E42 e) {\n\t\treturn f4(e); // error 6 expected\n\t}\n\n\tstatic <@Nullable T43, E43 extends T43> T43 g43(E43 e) {\n\t\treturn f4(e);\n\t}\n\n\tstatic <@Nullable T44, @Nullable E44 extends T44> T44 g44(E44 e) {\n\t\treturn f4(e);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\TestInterdepInvoke.java (at line 11)\n\treturn e; // error 1 expected\n\t       ^\nNull type mismatch (type annotations): required 'T' but this expression has type '@Nullable E extends T', where 'T' is a free type variable\n----------\n2. ERROR in test\\TestInterdepInvoke.java (at line 29)\n\treturn f1(e); // error 2 expected\n\t       ^^^^^\nNull type mismatch (type annotations): required 'T12' but this expression has type '@Nullable E12 extends T12', where 'T12' is a free type variable\n----------\n3. ERROR in test\\TestInterdepInvoke.java (at line 61)\n\treturn f3(e); // error 3 expected\n\t       ^^^^^\nNull type mismatch (type annotations): required 'T31' but this expression has type '@Nullable E31 extends T31', where 'T31' is a free type variable\n----------\n4. ERROR in test\\TestInterdepInvoke.java (at line 65)\n\treturn f3(e); // error 4 expected\n\t       ^^^^^\nNull type mismatch (type annotations): required 'T32' but this expression has type '@Nullable E32 extends T32', where 'T32' is a free type variable\n----------\n5. ERROR in test\\TestInterdepInvoke.java (at line 79)\n\treturn f4(e); /// error 5 expected\n\t       ^^^^^\nNull type mismatch (type annotations): required 'T41' but this expression has type '@Nullable E41 extends T41', where 'T41' is a free type variable\n----------\n6. ERROR in test\\TestInterdepInvoke.java (at line 83)\n\treturn f4(e); // error 6 expected\n\t       ^^^^^\nNull type mismatch (type annotations): required 'T42' but this expression has type '@Nullable E42 extends T42', where 'T42' is a free type variable\n----------\n");
    }

    public void testBug484741Invoke2() {
        this.runNegativeTestWithLibs(new String[]{"test/TestInterdepInvokeNN.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\n@java.lang.annotation.Target({ java.lang.annotation.ElementType.TYPE_USE })\n@interface SomeAnnotation {\n\t// just needed as workaround if bug 484981 is not fixed\n}\n\npublic class TestInterdepInvokeNN {\n\tstatic <T, @SomeAnnotation E extends T> T f1(E e) {\n\t\treturn e;\n\t}\n\n\tstatic <T, @NonNull E extends T> T f2(E e) {\n\t\treturn e;\n\t}\n\n\tstatic <@NonNull T, @SomeAnnotation E extends T> T f3(E e) {\n\t\treturn e;\n\t}\n\n\tstatic <@NonNull T, @NonNull E extends T> T f4(E e) {\n\t\treturn e;\n\t}\n\n\t// -------- invocations of f1 --------\n\n\tstatic <T11, @SomeAnnotation E11 extends T11> T11 g11(E11 e) {\n\t\treturn f1(e);\n\t}\n\n\tstatic <T12, @NonNull E12 extends T12> T12 g12(E12 e) {\n\t\treturn f1(e);\n\t}\n\n\tstatic <@NonNull T13, @SomeAnnotation E13 extends T13> T13 g13(E13 e) {\n\t\treturn f1(e);\n\t}\n\n\tstatic <@NonNull T14, @NonNull E14 extends T14> T14 g14(E14 e) {\n\t\treturn f1(e);\n\t}\n\n\t// -------- invocations of f2 --------\n\n\tstatic <T21, @SomeAnnotation E21 extends T21> T21 g21(E21 e) {\n\t\treturn f2(e); // error 1 expected\n\t}\n\n\tstatic <T22, @NonNull E22 extends T22> T22 g22(E22 e) {\n\t\treturn f2(e);\n\t}\n\n\tstatic <@NonNull T23, @SomeAnnotation E23 extends T23> T23 g23(E23 e) {\n\t\treturn f2(e);\n\t}\n\n\tstatic <@NonNull T24, @NonNull E24 extends T24> T24 g24(E24 e) {\n\t\treturn f2(e);\n\t}\n\n\t// -------- invocations of f3 --------\n\n\tstatic <T31, @SomeAnnotation E31 extends T31> T31 g31(E31 e) {\n\t\treturn f3(e); // error 2 expected\n\t}\n\n\tstatic <T32, @NonNull E32 extends T32> T32 g32(E32 e) {\n\t\treturn f3(e);\n\t}\n\n\tstatic <@NonNull T33, @SomeAnnotation E33 extends T33> T33 g33(E33 e) {\n\t\treturn f3(e);\n\t}\n\n\tstatic <@NonNull T34, @NonNull E34 extends T34> T34 g34(E34 e) {\n\t\treturn f3(e);\n\t}\n\n\t// -------- invocations of f4 --------\n\n\tstatic <T41, @SomeAnnotation E41 extends T41> T41 g41(E41 e) {\n\t\treturn f4(e); // error 3 expected\n\t}\n\n\tstatic <T42, @NonNull E42 extends T42> T42 g42(E42 e) {\n\t\treturn f4(e);\n\t}\n\n\tstatic <@NonNull T43, @SomeAnnotation E43 extends T43> T43 g43(E43 e) {\n\t\treturn f4(e);\n\t}\n\n\tstatic <@NonNull T44, @NonNull E44 extends T44> T44 g44(E44 e) {\n\t\treturn f4(e);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\TestInterdepInvokeNN.java (at line 48)\n\treturn f2(e); // error 1 expected\n\t          ^\nNull type safety: required '@NonNull' but this expression has type 'E21', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in test\\TestInterdepInvokeNN.java (at line 66)\n\treturn f3(e); // error 2 expected\n\t          ^\nNull type safety: required '@NonNull' but this expression has type 'E31', a free type variable that may represent a '@Nullable' type\n----------\n3. ERROR in test\\TestInterdepInvokeNN.java (at line 84)\n\treturn f4(e); // error 3 expected\n\t          ^\nNull type safety: required '@NonNull' but this expression has type 'E41', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug484741Invoke3() {
        this.runNegativeTestWithLibs(new String[]{"test/TestInterdepInvoke.java", "package test;\n\nimport java.util.ArrayList;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class TestInterdepInvoke {\n\tstatic <T1, E1 extends T1> void f1(ArrayList<T1> list, E1 e) {\n\t\tlist.add(e);\n\t}\n\n\tstatic <T2, @Nullable E2 extends T2> void f2(ArrayList<T2> list, E2 e) {\n\t\tlist.add(e); // error expected\n\t}\n\n\tstatic <T3, @NonNull E3 extends T3> void f3(ArrayList<T3> list, E3 e) {\n\t\tlist.add(e);\n\t}\n\n\tstatic <@Nullable T4, E4 extends T4> void f4(ArrayList<T4> list, E4 e) {\n\t\tlist.add(e);\n\t}\n\n\tstatic <@Nullable T5, @Nullable E5 extends T5> void f5(ArrayList<T5> list, E5 e) {\n\t\tlist.add(e);\n\t}\n\n\tstatic <@Nullable T6, @NonNull E6 extends T6> void f6(ArrayList<T6> list, E6 e) {\n\t\tlist.add(e);\n\t}\n\n\tstatic <@NonNull T7, E7 extends T7> void f7(ArrayList<T7> list, E7 e) {\n\t\tlist.add(e);\n\t}\n\n\tstatic <@NonNull T8, @Nullable E8 extends T8> void f8(ArrayList<T8> list, E8 e) {\n\t\tlist.add(e); // error expected\n\t}\n\n\tstatic <@NonNull T9, @NonNull E9 extends T9> void f9(ArrayList<T9> list, E9 e) {\n\t\tlist.add(e);\n\t}\n\n\t// -------- invocations, but all of the 81 combinations removed, that were already handled correctly  -----\n\n\tstatic <S1, F1 extends S1> void g1(ArrayList<S1> list, F1 e) {\n\t\tf1(list, e);\n\t\tf2(list, e);\n\t}\n\n\tstatic <S2, @Nullable F2 extends S2> void g2(ArrayList<S2> list, F2 e) {\n\t\tf1(list, e);\n\t\tf2(list, e);\n\t}\n\n\tstatic <S3, @NonNull F3 extends S3> void g3(ArrayList<S3> list, F3 e) {\n\t\tf2(list, e);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\TestInterdepInvoke.java (at line 14)\n\tlist.add(e); // error expected\n\t         ^\nNull type mismatch (type annotations): required 'T2' but this expression has type '@Nullable E2 extends T2', where 'T2' is a free type variable\n----------\n2. ERROR in test\\TestInterdepInvoke.java (at line 38)\n\tlist.add(e); // error expected\n\t         ^\nNull type mismatch (type annotations): required '@NonNull T8' but this expression has type '@Nullable E8 extends @NonNull T8'\n----------\n");
    }

    public void testBug484471SubclassNullable() {
        this.runNegativeTestWithLibs(new String[]{"test/TestInterdepSubClass.java", "package test;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class TestInterdepSubClass {\n\tstatic class A1<T, E extends T> {\n\t}\n\n\tstatic class A2<T, @Nullable E extends T> {\n\t}\n\n\tstatic class A3<@Nullable T, E extends T> {\n\t}\n\n\tstatic class A4<@Nullable T, @Nullable E extends T> {\n\t}\n\n\t// -------- subclasses of A1<T, E extends T> --------\n\n\tstatic class B11<T11, E11 extends T11> extends A1<T11, E11> {\n\t}\n\n\tstatic class B12<T12, @Nullable E12 extends T12> extends A1<T12, E12> {\n\t}\n\n\tstatic class B13<@Nullable T13, E13 extends T13> extends A1<T13, E13> {\n\t}\n\n\tstatic class B14<@Nullable T14, @Nullable E14 extends T14> extends A1<T14, E14> {\n\t}\n\n\t// -------- subclasses of A2<T, @Nullable E extends T> --------\n\n\tstatic class B21<T21, E21 extends T21> extends A2<T21, E21> { // expect error 1\n\t}\n\n\tstatic class B22<T22, @Nullable E22 extends T22> extends A2<T22, E22> {\n\t}\n\n\tstatic class B23<@Nullable T23, E23 extends T23> extends A2<T23, E23> { // expect error 2\n\t}\n\n\tstatic class B24<@Nullable T24, @Nullable E24 extends T24> extends A2<T24, E24> {\n\t}\n\n\t// -------- subclasses of A3<@Nullable T, E extends T> --------\n\n\tstatic class B31<T31, E31 extends T31> extends A3<T31, E31> { // expect error 3\n\t}\n\n\tstatic class B32<T32, @Nullable E32 extends T32> extends A3<T32, E32> { // expect error 4\n\t}\n\n\tstatic class B33<@Nullable T33, E33 extends T33> extends A3<T33, E33> {\n\t}\n\n\tstatic class B34<@Nullable T34, @Nullable E34 extends T34> extends A3<T34, E34> {\n\t}\n\n\t// -------- subclasses of A4<@Nullable T, @Nullable E extends T> --------\n\n\tstatic class B41<T41, E41 extends T41> extends A4<T41, E41> { // expect errors 5 & 6\n\t}\n\n\tstatic class B42<T42, @Nullable E42 extends T42> extends A4<T42, E42> { // expect error 7\n\t}\n\n\tstatic class B43<@Nullable T43, E43 extends T43> extends A4<T43, E43> { // expect error 8\n\t}\n\n\tstatic class B44<@Nullable T44, @Nullable E44 extends T44> extends A4<T44, E44> {\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\TestInterdepSubClass.java (at line 34)\n\tstatic class B21<T21, E21 extends T21> extends A2<T21, E21> { // expect error 1\n\t                                                       ^^^\nNull constraint mismatch: The type 'E21 extends T21' is not a valid substitute for the type parameter '@Nullable E extends T'\n----------\n2. ERROR in test\\TestInterdepSubClass.java (at line 40)\n\tstatic class B23<@Nullable T23, E23 extends T23> extends A2<T23, E23> { // expect error 2\n\t                                                                 ^^^\nNull constraint mismatch: The type 'E23 extends @Nullable T23' is not a valid substitute for the type parameter '@Nullable E extends T'\n----------\n3. ERROR in test\\TestInterdepSubClass.java (at line 48)\n\tstatic class B31<T31, E31 extends T31> extends A3<T31, E31> { // expect error 3\n\t                                                  ^^^\nNull constraint mismatch: The type 'T31' is not a valid substitute for the type parameter '@Nullable T'\n----------\n4. ERROR in test\\TestInterdepSubClass.java (at line 51)\n\tstatic class B32<T32, @Nullable E32 extends T32> extends A3<T32, E32> { // expect error 4\n\t                                                            ^^^\nNull constraint mismatch: The type 'T32' is not a valid substitute for the type parameter '@Nullable T'\n----------\n5. ERROR in test\\TestInterdepSubClass.java (at line 62)\n\tstatic class B41<T41, E41 extends T41> extends A4<T41, E41> { // expect errors 5 & 6\n\t                                                  ^^^\nNull constraint mismatch: The type 'T41' is not a valid substitute for the type parameter '@Nullable T'\n----------\n6. ERROR in test\\TestInterdepSubClass.java (at line 62)\n\tstatic class B41<T41, E41 extends T41> extends A4<T41, E41> { // expect errors 5 & 6\n\t                                                       ^^^\nNull constraint mismatch: The type 'E41 extends T41' is not a valid substitute for the type parameter '@Nullable E extends @Nullable T'\n----------\n7. ERROR in test\\TestInterdepSubClass.java (at line 65)\n\tstatic class B42<T42, @Nullable E42 extends T42> extends A4<T42, E42> { // expect error 7\n\t                                                            ^^^\nNull constraint mismatch: The type 'T42' is not a valid substitute for the type parameter '@Nullable T'\n----------\n8. ERROR in test\\TestInterdepSubClass.java (at line 68)\n\tstatic class B43<@Nullable T43, E43 extends T43> extends A4<T43, E43> { // expect error 8\n\t                                                                 ^^^\nNull constraint mismatch: The type 'E43 extends @Nullable T43' is not a valid substitute for the type parameter '@Nullable E extends @Nullable T'\n----------\n");
    }

    public void testBug484471SubclassNonNull() {
        this.runNegativeTestWithLibs(new String[]{"test/TestInterdepSubClassNN.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\n@java.lang.annotation.Target({ java.lang.annotation.ElementType.TYPE_USE })\n@interface SomeAnnotation {\n\t// just needed as workaround if bug 484981 is not fixed\n}\n\npublic class TestInterdepSubClassNN {\n\tstatic class A1<T, @SomeAnnotation E extends T> {\n\t}\n\n\tstatic class A2<T, @NonNull E extends T> {\n\t}\n\n\tstatic class A3<@NonNull T, @SomeAnnotation E extends T> {\n\t}\n\n\tstatic class A4<@NonNull T, @NonNull E extends T> {\n\t}\n\n\t// -------- subclasses of A1<T, E extends T> --------\n\n\tstatic class B11<T11, @SomeAnnotation E11 extends T11> extends A1<T11, E11> {\n\t}\n\n\tstatic class B12<T12, @NonNull E12 extends T12> extends A1<T12, E12> {\n\t}\n\n\tstatic class B13<@NonNull T13, @SomeAnnotation E13 extends T13> extends A1<T13, E13> {\n\t}\n\n\tstatic class B14<@NonNull T14, @NonNull E14 extends T14> extends A1<T14, E14> {\n\t}\n\n\t// -------- subclasses of A2<T, @NonNull E extends T> --------\n\n\tstatic class B21<T21, @SomeAnnotation E21 extends T21> extends A2<T21, E21> { // expect error 1\n\t}\n\n\tstatic class B22<T22, @NonNull E22 extends T22> extends A2<T22, E22> {\n\t}\n\n\tstatic class B23<@NonNull T23, @SomeAnnotation E23 extends T23> extends A2<T23, E23> {\n\t}\n\n\tstatic class B24<@NonNull T24, @NonNull E24 extends T24> extends A2<T24, E24> {\n\t}\n\n\t// -------- subclasses of A3<@NonNull T, E extends T> --------\n\n\tstatic class B31<T31, @SomeAnnotation E31 extends T31> extends A3<T31, E31> { // expect errors 2 & 3\n\t}\n\n\tstatic class B32<T32, @NonNull E32 extends T32> extends A3<T32, E32> { // expect error 4\n\t}\n\n\tstatic class B33<@NonNull T33, @SomeAnnotation E33 extends T33> extends A3<T33, E33> {\n\t}\n\n\tstatic class B34<@NonNull T34, @NonNull E34 extends T34> extends A3<T34, E34> {\n\t}\n\n\t// -------- subclasses of A4<@NonNull T, @NonNull E extends T> --------\n\n\tstatic class B41<T41, @SomeAnnotation E41 extends T41> extends A4<T41, E41> { // expect error 5 & 6\n\t}\n\n\tstatic class B42<T42, @NonNull E42 extends T42> extends A4<T42, E42> { // expect error 7\n\t}\n\n\tstatic class B43<@NonNull T43, @SomeAnnotation E43 extends T43> extends A4<T43, E43> {\n\t}\n\n\tstatic class B44<@NonNull T44, @NonNull E44 extends T44> extends A4<T44, E44> {\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\TestInterdepSubClassNN.java (at line 39)\n\tstatic class B21<T21, @SomeAnnotation E21 extends T21> extends A2<T21, E21> { // expect error 1\n\t                                                                       ^^^\nNull constraint mismatch: The type 'E21 extends T21' is not a valid substitute for the type parameter '@NonNull E extends T'\n----------\n2. ERROR in test\\TestInterdepSubClassNN.java (at line 53)\n\tstatic class B31<T31, @SomeAnnotation E31 extends T31> extends A3<T31, E31> { // expect errors 2 & 3\n\t                                                                  ^^^\nNull constraint mismatch: The type 'T31' is not a valid substitute for the type parameter '@NonNull T'\n----------\n3. ERROR in test\\TestInterdepSubClassNN.java (at line 53)\n\tstatic class B31<T31, @SomeAnnotation E31 extends T31> extends A3<T31, E31> { // expect errors 2 & 3\n\t                                                                       ^^^\nNull constraint mismatch: The type 'E31 extends T31' is not a valid substitute for the type parameter 'E extends @NonNull T'\n----------\n4. ERROR in test\\TestInterdepSubClassNN.java (at line 56)\n\tstatic class B32<T32, @NonNull E32 extends T32> extends A3<T32, E32> { // expect error 4\n\t                                                           ^^^\nNull constraint mismatch: The type 'T32' is not a valid substitute for the type parameter '@NonNull T'\n----------\n5. ERROR in test\\TestInterdepSubClassNN.java (at line 67)\n\tstatic class B41<T41, @SomeAnnotation E41 extends T41> extends A4<T41, E41> { // expect error 5 & 6\n\t                                                                  ^^^\nNull constraint mismatch: The type 'T41' is not a valid substitute for the type parameter '@NonNull T'\n----------\n6. ERROR in test\\TestInterdepSubClassNN.java (at line 67)\n\tstatic class B41<T41, @SomeAnnotation E41 extends T41> extends A4<T41, E41> { // expect error 5 & 6\n\t                                                                       ^^^\nNull constraint mismatch: The type 'E41 extends T41' is not a valid substitute for the type parameter '@NonNull E extends @NonNull T'\n----------\n7. ERROR in test\\TestInterdepSubClassNN.java (at line 70)\n\tstatic class B42<T42, @NonNull E42 extends T42> extends A4<T42, E42> { // expect error 7\n\t                                                           ^^^\nNull constraint mismatch: The type 'T42' is not a valid substitute for the type parameter '@NonNull T'\n----------\n");
    }

    public void testBug485058() {
        this.runNegativeTestWithLibs(new String[]{"test/Test4.java", "package test;\n\nimport java.io.Serializable;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault\nclass Feature4<Q extends Serializable> {\n\t\tQ q() {\n\t\t\tthrow new RuntimeException();\n\t\t}\n}\n\n@NonNullByDefault\npublic class Test4 {\n\tpublic static <Q1 extends java.io.Serializable, F extends Feature4<Q1>> Q1[] getValues(F feature) {\n\t\tthrow new RuntimeException();\n\t}\n\n\tpublic static void f(Feature4<?> feature) {\n\t\tgetValues(feature);\n\t}\n\n\tpublic static void g(Feature4<@Nullable ? extends @NonNull Serializable> feature) {\n\t\tgetValues(feature);\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\Test4.java (at line 25)\n\tpublic static void g(Feature4<@Nullable ? extends @NonNull Serializable> feature) {\n\t                              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable ? extends @NonNull Serializable' is not a valid substitute for the type parameter 'Q extends @NonNull Serializable'\n----------\n2. ERROR in test\\Test4.java (at line 25)\n\tpublic static void g(Feature4<@Nullable ? extends @NonNull Serializable> feature) {\n\t                                                  ^^^^^^^^\nThis nullness annotation conflicts with a '@Nullable' annotation which is effective on the same type parameter \n----------\n3. ERROR in test\\Test4.java (at line 26)\n\tgetValues(feature);\n\t^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Feature4<@Nullable capture#of ? extends @NonNull Serializable>' is not a valid substitute for the type parameter 'F extends @NonNull Feature4<Q1 extends @NonNull Serializable>'\n----------\n");
    }

    public void testBug485030() {
        this.runConformTestWithLibs(new String[]{"SomeAnnotation.java", "import static java.lang.annotation.ElementType.TYPE_USE;\nimport java.lang.annotation.Target;\n@Target({ TYPE_USE })\n@interface SomeAnnotation {\n}\n", "TestContradictoryOnGenericArray.java", "import java.io.Serializable;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n@NonNullByDefault\npublic class TestContradictoryOnGenericArray {\n\tpublic <@SomeAnnotation Q extends Serializable> void f() {\n\t\tfinal @Nullable Q[] array = null;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug485302() {
        this.runNegativeTestWithLibs(new String[]{"WildCardNullable.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class WildCardNullable {\n\tstatic class A<T> {\n\t\t@Nullable\n\t\tT returnNull() {\n\t\t\treturn null;\n\t\t}\n\n\t\tvoid acceptNonNullT(@NonNull T t) {\n\t\t}\n\n\t\tvoid acceptNonNullObject(@NonNull Object x) {\n\t\t}\n\t}\n\n\tstatic @NonNull Number g(A<? extends @NonNull Number> a) {\n\t\treturn a.returnNull(); // error 1 expected\n\t}\n\n\tpublic static final <T> void map(final A<@NonNull ? super T> a, T t) {\n\t\ta.acceptNonNullT(t); // warning 2 expected\n\t\ta.acceptNonNullObject(t); // warning 3 expected\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in WildCardNullable.java (at line 21)\n\treturn a.returnNull(); // error 1 expected\n\t       ^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Number' but this expression has type '@Nullable capture#of ? extends Number'\n----------\n2. ERROR in WildCardNullable.java (at line 25)\n\ta.acceptNonNullT(t); // warning 2 expected\n\t                 ^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n3. ERROR in WildCardNullable.java (at line 26)\n\ta.acceptNonNullObject(t); // warning 3 expected\n\t                      ^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug485027() {
        this.runConformTestWithLibs(new String[]{"SomeAnnotation.java", "import static java.lang.annotation.ElementType.TYPE_USE;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Retention(RetentionPolicy.CLASS)\n@Target({ TYPE_USE })\n@interface SomeAnnotation {\n}\n", "Base.java", "import java.io.Serializable;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n@NonNullByDefault\npublic class Base {\n\tpublic <@SomeAnnotation Q extends Serializable> void setValuesArray(Q @Nullable [] value) {\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"Derived.java", "import java.io.Serializable;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n@NonNullByDefault\npublic class Derived extends Base {\n\t@Override\n\tpublic final <@SomeAnnotation Q1 extends Serializable> void setValuesArray(Q1 @Nullable [] value) {\n\t}\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug485565() {
        this.runConformTestWithLibs(new String[]{"test2/ClassWithRegistry.java", "package test2;\n\nimport java.rmi.registry.Registry;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class ClassWithRegistry {\n    @Nullable\n    public Registry registry;\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test1/ClassWithLambda.java", "package test1;\n\nimport test2.ClassWithRegistry;\n\n// must be compiled before ZClassWithBug\npublic class ClassWithLambda {\n\tinterface Lambda {\n\t\tvoid f();\n\t}\n\n\tpublic static void invoke(Lambda lambda) {\n\t\tlambda.f();\n\t}\n\n\tpublic void f() {\n\t\tnew ClassWithRegistry(); // must be accessed as class file\n\t\tinvoke(() -> java.rmi.registry.Registry.class.hashCode());\n\t}\n}\n", "test1/ZClassWithBug.java", "package test1;\n\nimport java.rmi.registry.Registry;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault\npublic abstract class ZClassWithBug {\n\n\t@Nullable\n\tpublic Registry rmiregistry;\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug485814() {
        this.runConformTestWithLibs(new String[]{"test/ExplainedResult.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class ExplainedResult<V2> extends Result<V2> {\n\n\tpublic ExplainedResult(int score, V2 extractedValue2) {\n\t\tsuper(score, extractedValue2);\n\t}\n\n\t@Override\n\tpublic <OtherV2> ExplainedResult<OtherV2> withValue(OtherV2 otherValue2) {\n\t\treturn new ExplainedResult<OtherV2>(this.score, otherValue2);\n\t}\n}\n", "test/Result.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Result<V1> {\n\n\tpublic final int score;\n\n\tpublic final V1 extractedValue;\n\n\tpublic Result(int score, V1 extractedValue1) {\n\t\tthis.score = score;\n\t\tthis.extractedValue = extractedValue1;\n\t}\n\n\tpublic <OtherV1> Result<OtherV1> withValue(OtherV1 otherValue1) {\n\t\treturn new Result<OtherV1>(score, otherValue1);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug485581() {
        this.runConformTestWithLibs(new String[]{"test/MatchResult.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class MatchResult<V> implements Comparable<MatchResult<?>> {\n\tpublic final int score;\n\tpublic final V value;\n\n\tpublic MatchResult(int score, V value) {\n\t\tthis.score = score;\n\t\tthis.value = value;\n\t}\n\n\t@Override\n\tpublic int compareTo(MatchResult<?> o) {\n\t\treturn score - o.score;\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test/FVEHandler.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class FVEHandler {\n\tpublic static void process(MatchResult<?> matchResult) {\n\t\tif (matchResult.value != null) {\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug482752_lambda() {
        this.runConformTestWithLibs(new String[]{"test/StringProcessor.java", "package test;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic interface StringProcessor {\n\tvoid process(String value);\n\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test/Foo.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic final class Foo {\n\n\tpublic static StringProcessor createProcessorLambdaExpression() {\n\t\treturn (@NonNull String value) -> Foo.test(value);\n\t}\n\n\tpublic static void test(@NonNull String value) {\n\t\tSystem.out.println(value);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug482752_methodref() {
        this.runConformTestWithLibs(new String[]{"test/StringProcessor.java", "package test;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic interface StringProcessor {\n\tvoid process(String value);\n\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test/Foo.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic final class Foo {\n\n\tpublic static StringProcessor createProcessorMethodReference() {\n\t\treturn Foo::test;\n\t}\n\n\tpublic static void test(@NonNull String value) {\n\t\tSystem.out.println(value);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug485374() {
        this.runConformTestWithLibs(new String[]{"test/I.java", "package test;\npublic interface I<W> {\n    public class Nested {\n    }\n}\n", "test/D.java", "package test;\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class D implements I<I.@NonNull Nested> {\n}\n"}, this.getCompilerOptions(), "");
        this.runWarningTestWithLibs(false, new String[]{"test2/Import.java", "package test2;\nimport test.D;\nclass Import {}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in test2\\Import.java (at line 2)\n\timport test.D;\n\t       ^^^^^^\nThe import test.D is never used\n----------\n");
    }

    public void testBug466556a() {
        this.runNegativeTestWithLibs(new String[]{"test/C.java", "package test;\nclass C<T extends Number> {\n    int consume(T t) {\n        return t.intValue(); // NOT OK since T could be nullable\n    }\n    T provide() {\n        return null;         // NOT OK since T could require nonnull\n    }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\C.java (at line 4)\n\treturn t.intValue(); // NOT OK since T could be nullable\n\t       ^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in test\\C.java (at line 7)\n\treturn null;         // NOT OK since T could require nonnull\n\t       ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'T'\n----------\n");
    }

    public void testBug466556nonfree() {
        this.runNegativeTestWithLibs(new String[]{"test/C.java", "package test;\nclass C<T extends @org.eclipse.jdt.annotation.NonNull Number> {\n    int consume(T t) {\n        return t.intValue(); // OK since T has upper bound with @NonNull\n    }\n    T provide() {\n        return null;         // NOT OK since T could require nonnull\n    }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\C.java (at line 7)\n\treturn null;         // NOT OK since T could require nonnull\n\t       ^^^^\nNull type mismatch: required 'T extends @NonNull Number' but the provided value is null\n----------\n");
    }

    public void testBug466556b() {
        this.runNegativeTestWithLibs(new String[]{"test/C.java", "package test;\n\nimport java.util.function.Supplier;\n\nclass C<T> {\n\tint consume(T t) {\n\t\treturn t.hashCode();\n\t}\n\tvoid consume2(Supplier<T> s) {\n\t\ts.get().hashCode();\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\C.java (at line 7)\n\treturn t.hashCode();\n\t       ^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in test\\C.java (at line 10)\n\ts.get().hashCode();\n\t^^^^^^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug466556c() {
        this.runNegativeTestWithLibs(new String[]{"test/C.java", "package test;\n\nimport java.util.function.Supplier;\n\nclass C<T extends Number> {\n\tint consume(T t) {\n\t\tNumber n = t;\n\t\treturn n.intValue();\n\t}\n\n\tint consume2(Supplier<T> s) {\n\t\tNumber n = s.get();\n\t\treturn n.intValue();\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\C.java (at line 8)\n\treturn n.intValue();\n\t       ^\nPotential null pointer access: The variable n may be null at this location\n----------\n2. ERROR in test\\C.java (at line 13)\n\treturn n.intValue();\n\t       ^\nPotential null pointer access: The variable n may be null at this location\n----------\n");
    }

    public void testBug466556field() {
        this.runNegativeTestWithLibs(new String[]{"test/D.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass E<T> {\n\tT t;\n}\n\nclass D<T> {\n\tenum X {\n\t\tx\n\t};\n\n\tT t1;\n\tT t2;\n\tT t3;\n\t@Nullable\n\tT t4;\n\t@NonNull\n\tT t5;\n\t@NonNull\n\tT t6;\n\t@NonNull\n\tT t7;\n\n\tD(@NonNull T t) {\n\t\tt2 = t;\n\t\tswitch (X.x) {\n\t\tcase x:\n\t\t\tt1 = t;\n\t\t\tt5 = t;\n\t\t}\n\t\tt6 = t;\n\t}\n\n\tvoid f() {\n\t\tt1.hashCode();\n\t\tt2.hashCode();\n\t\tt3.hashCode();\n\t\tt4.hashCode();\n\t\tt5.hashCode();\n\t\tt6.hashCode();\n\t\tt7.hashCode();\n\t\tT t = t1;\n\t\tt.hashCode();\n\t}\n\tvoid g() {\n\t\tif(t1 != null)\n\t\t\tt1.hashCode();\n // problem report expected because syntactic null analysis for fields is off\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\D.java (at line 7)\n\tT t;\n\t  ^\nThe field t may not have been initialized, whereas its type 'T' is a free type variable that may represent a '@NonNull' type\n----------\n2. ERROR in test\\D.java (at line 27)\n\tD(@NonNull T t) {\n\t^^^^^^^^^^^^^^^\nThe field t1 may not have been initialized, whereas its type 'T' is a free type variable that may represent a '@NonNull' type. Note that a problem regarding missing 'default:' on 'switch' has been suppressed, which is perhaps related to this problem\n----------\n3. ERROR in test\\D.java (at line 27)\n\tD(@NonNull T t) {\n\t^^^^^^^^^^^^^^^\nThe field t3 may not have been initialized, whereas its type 'T' is a free type variable that may represent a '@NonNull' type. Note that a problem regarding missing 'default:' on 'switch' has been suppressed, which is perhaps related to this problem\n----------\n4. ERROR in test\\D.java (at line 27)\n\tD(@NonNull T t) {\n\t^^^^^^^^^^^^^^^\nThe @NonNull field t5 may not have been initialized. Note that a problem regarding missing 'default:' on 'switch' has been suppressed, which is perhaps related to this problem\n----------\n5. ERROR in test\\D.java (at line 27)\n\tD(@NonNull T t) {\n\t^^^^^^^^^^^^^^^\nThe @NonNull field t7 may not have been initialized. Note that a problem regarding missing 'default:' on 'switch' has been suppressed, which is perhaps related to this problem\n----------\n6. ERROR in test\\D.java (at line 38)\n\tt1.hashCode();\n\t^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n7. ERROR in test\\D.java (at line 39)\n\tt2.hashCode();\n\t^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n8. ERROR in test\\D.java (at line 40)\n\tt3.hashCode();\n\t^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n9. ERROR in test\\D.java (at line 41)\n\tt4.hashCode();\n\t^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n10. ERROR in test\\D.java (at line 46)\n\tt.hashCode();\n\t^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n11. ERROR in test\\D.java (at line 50)\n\tt1.hashCode();\n\t^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug466556withRaw() {
        this.runConformTestWithLibs(new String[]{"test/TestWithRaw.java", "package test;\n\npublic class TestWithRaw {\n\t@SuppressWarnings({ \"unchecked\", \"rawtypes\" })\n\tpublic static void uncheckedEnumValueOf(final Class<?> valueClass, final String value) {\n\t\tClass valueClass2 = valueClass;\n\t\tEnum.valueOf(valueClass2, value).name();\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug466556withPGMB() {
        this.runNegativeTestWithLibs(new String[]{"test/TestWithParameterizedGenericMethodBinding.java", "package test;\n\npublic class TestWithParameterizedGenericMethodBinding {\n\tstatic <T, E extends T> T f1(E e) {\n\t\treturn e;\n\t}\n\n\tstatic <T11, E11 extends T11> void g11(E11 e) {\n\t\tf1(e).hashCode();\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\TestWithParameterizedGenericMethodBinding.java (at line 9)\n\tf1(e).hashCode();\n\t^^^^^\nPotential null pointer access: this expression has type 'E11', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug466556captures() {
        this.runNegativeTestWithLibs(new String[]{"test/TestCapture.java", "package test;\n\nclass I {\n\tint i;\n\n\tString s() {\n\t\treturn \"\";\n\t}\n}\n\nclass KE<E extends I> {\n\tpublic final E e;\n\n\tpublic E getE() {\n\t\treturn e;\n\t}\n\n\tpublic KE(E element) {\n\t\tthis.e = element;\n\t}\n}\n\nclass TestFreeTypeVariable<E2 extends I> {\n\tpublic void test(KE<E2> ke) {\n\t\tint i1 = ke.e.i; // error 1\n\t\tke.e.s().substring(i1); // error 2\n\t\tint i2 = ke.getE().i; // error 3\n\t\tke.getE().s().substring(i2); // error 4\n\t}\n}\n\npublic class TestCapture {\n\tpublic void test(KE<? extends I> ke) {\n\t\tint i1 = ke.e.i; // error 5\n\t\tke.e.s().substring(i1); // error 6\n\t\tint i2 = ke.getE().i; // error 7\n\t\tke.getE().s().substring(i2); // error 8\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\TestCapture.java (at line 25)\n\tint i1 = ke.e.i; // error 1\n\t            ^\nPotential null pointer access: this expression has type 'E2', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in test\\TestCapture.java (at line 26)\n\tke.e.s().substring(i1); // error 2\n\t   ^\nPotential null pointer access: this expression has type 'E2', a free type variable that may represent a '@Nullable' type\n----------\n3. ERROR in test\\TestCapture.java (at line 27)\n\tint i2 = ke.getE().i; // error 3\n\t         ^^^^^^^^^\nPotential null pointer access: this expression has type 'E2', a free type variable that may represent a '@Nullable' type\n----------\n4. ERROR in test\\TestCapture.java (at line 28)\n\tke.getE().s().substring(i2); // error 4\n\t^^^^^^^^^\nPotential null pointer access: this expression has type 'E2', a free type variable that may represent a '@Nullable' type\n----------\n5. ERROR in test\\TestCapture.java (at line 34)\n\tint i1 = ke.e.i; // error 5\n\t            ^\nPotential null pointer access: this expression has type 'capture#1-of ? extends test.I', a free type variable that may represent a '@Nullable' type\n----------\n6. ERROR in test\\TestCapture.java (at line 35)\n\tke.e.s().substring(i1); // error 6\n\t   ^\nPotential null pointer access: this expression has type 'capture#2-of ? extends test.I', a free type variable that may represent a '@Nullable' type\n----------\n7. ERROR in test\\TestCapture.java (at line 36)\n\tint i2 = ke.getE().i; // error 7\n\t         ^^^^^^^^^\nPotential null pointer access: this expression has type 'capture#3-of ? extends test.I', a free type variable that may represent a '@Nullable' type\n----------\n8. ERROR in test\\TestCapture.java (at line 37)\n\tke.getE().s().substring(i2); // error 8\n\t^^^^^^^^^\nPotential null pointer access: this expression has type 'capture#4-of ? extends test.I', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug466556Loops() {
        this.runNegativeTestWithLibs(new String[]{"test/TestLoop.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class TestLoop<T> {\n\tboolean b;\n\n\tpublic static void nn(@NonNull Object value) {\n\t\tassert value != null;\n\t}\n\n\tpublic void testDoWhile(T t1) {\n\t\tnn(t1); // 1: unchecked warning\n\t\tdo {\n\t\t\tnn(t1); // 2: unchecked warning\n\t\t\tt1.hashCode(); // 3: Potential null pointer access...free type variable\n\t\t} while (b);\n\t}\n\n\tpublic void testWhileWithBreak(T t1) {\n\t\twhile (true) {\n\t\t\tnn(t1); // 4: unchecked warning\n\t\t\tt1.hashCode(); // 5: Potential null pointer access...free type variable\n\t\t\tif (b)\n\t\t\t\tbreak;\n\t\t}\n\t}\n\n\tpublic void testWhile(T t1) {\n\t\twhile (TestLoop.class.hashCode() == 4711) {\n\t\t\tnn(t1); // 6: unchecked warning\n\t\t\tt1.hashCode(); // 7: Potential null pointer access...free type variable\n\t\t}\n\t}\n\n\tpublic void testFor(T t1) {\n\t\tfor (int i = 0; i < 1; i++) {\n\t\t\tnn(t1); // 8: unchecked warning\n\t\t\tt1.hashCode(); // 9: Potential null pointer access...free type variable\n\t\t}\n\t}\n\n\tpublic void testForEach(T t1) {\n\t\tfor (int i = 0; i < 1; i++) {\n\t\t\tnn(t1); // 10: unchecked warning\n\t\t\tt1.hashCode(); // 11: Potential null pointer access: The variable t1 may be null at this location\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\TestLoop.java (at line 13)\n\tnn(t1); // 1: unchecked warning\n\t   ^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in test\\TestLoop.java (at line 15)\n\tnn(t1); // 2: unchecked warning\n\t   ^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n3. ERROR in test\\TestLoop.java (at line 16)\n\tt1.hashCode(); // 3: Potential null pointer access...free type variable\n\t^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n4. ERROR in test\\TestLoop.java (at line 22)\n\tnn(t1); // 4: unchecked warning\n\t   ^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n5. ERROR in test\\TestLoop.java (at line 23)\n\tt1.hashCode(); // 5: Potential null pointer access...free type variable\n\t^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n6. ERROR in test\\TestLoop.java (at line 31)\n\tnn(t1); // 6: unchecked warning\n\t   ^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n7. ERROR in test\\TestLoop.java (at line 32)\n\tt1.hashCode(); // 7: Potential null pointer access...free type variable\n\t^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n8. ERROR in test\\TestLoop.java (at line 38)\n\tnn(t1); // 8: unchecked warning\n\t   ^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n9. ERROR in test\\TestLoop.java (at line 39)\n\tt1.hashCode(); // 9: Potential null pointer access...free type variable\n\t^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n10. ERROR in test\\TestLoop.java (at line 45)\n\tnn(t1); // 10: unchecked warning\n\t   ^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n11. ERROR in test\\TestLoop.java (at line 46)\n\tt1.hashCode(); // 11: Potential null pointer access: The variable t1 may be null at this location\n\t^^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug461268() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables", "ignore");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.List;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid test(List<@NonNull String> list) {\n\t\t@NonNull String s = list.get(0);\n\t}\n}\n"}, compilerOptions, "----------\n1. ERROR in X.java (at line 5)\n\t@NonNull String s = list.get(0);\n\t                    ^^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type 'List<@NonNull String>'. Type 'List<E>' doesn't seem to be designed with null type annotations in mind\n----------\n");
    }

    public void testBug461268invoke() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.Map;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid test(Map<Object, @NonNull String> map) {\n\t\tmap.get(this).length();\n\t}\n}\n"}, compilerOptions, "----------\n1. ERROR in X.java (at line 5)\n\tmap.get(this).length();\n\t^^^^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type 'Map<Object,@NonNull String>'. Type 'Map<K,V>' doesn't seem to be designed with null type annotations in mind\n----------\n");
    }

    public void testBug461268nnbd() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation", "error");
        this.runConformTestWithLibs(new String[]{"test2/Container.java", "package test2;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Container<T> {\n\tpublic static <T> T getFrom(Container<T> container) {\n\t\treturn container.get();\n\t}\n\n\tprivate final T t;\n\n\tpublic Container(T t) {\n\t\tthis.t = t;\n\t}\n\n\tprivate T get() {\n\t\treturn this.t;\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test/Test.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\nimport test2.Container;\n\n@NonNullByDefault\npublic class Test {\n\tString f(Container<String> c) {\n\t\treturn Container.getFrom(c);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug485988WildcardOverride() {
        this.runConformTestWithLibs(new String[]{"test/Result.java", "package test;\n\npublic class Result<V> implements Comparable<Result<?>> {\n\tpublic final int score;\n\tpublic final V value;\n\n\tprotected Result(int score, V value) {\n\t\tthis.score = score;\n\t\tthis.value = value;\n\t}\n\t@Override\n\tpublic int compareTo(Result<?> o) {\n\t\treturn score - o.score;\n\t}\n}\n", "test/Base.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic abstract class Base {\n\tpublic abstract Result<?> matches();\n}\n", "test/Derived.java", "package test;\n\nimport java.math.BigDecimal;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Derived extends Base {\n\t@Override\n\tpublic Result<BigDecimal> matches() {\n\t\treturn new Result<BigDecimal>(0, new BigDecimal(\"1\"));\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug485988neutral() {
        this.runConformTestWithLibs(new String[]{"neutral/WildcardTest.java", "package neutral;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault\nclass A<T> {\n}\n\nabstract class X {\n\tabstract A<?> g1();\n\n\tabstract A<?> g2();\n\n\tabstract A<?> g2b();\n\n\tabstract A<?> g3();\n\n\tabstract A<?> h1();\n\n\tabstract A<?> h2();\n\n\tabstract A<?> h2b();\n\n\tabstract A<?> h3();\n}\n\nclass Y extends X {\n\t@Override\n\tA<?> g1() {\n\t\treturn new A<@NonNull String>();\n\t}\n\n\t@Override\n\tA<@NonNull ?> g2() {\n\t\treturn new A<@NonNull String>();\n\t}\n\n\t@Override\n\tA<? extends @NonNull Number> g2b() {\n\t\treturn new A<@NonNull Integer>();\n\t}\n\n\t@Override\n\tA<@NonNull String> g3() {\n\t\treturn new A<@NonNull String>();\n\t}\n\n\t@Override\n\tA<?> h1() {\n\t\treturn new A<@Nullable String>();\n\t}\n\n\t@Override\n\tA<@Nullable ?> h2() {\n\t\treturn new A<@Nullable String>();\n\t}\n\n\t@Override\n\tA<? super @Nullable Number> h2b() {\n\t\treturn new A<@Nullable Object>();\n\t}\n\n\t@Override\n\tA<@Nullable String> h3() {\n\t\treturn new A<@Nullable String>();\n\t}\n}\n\n@NonNullByDefault\npublic class WildcardTest {\n\tvoid f(A<?> a) {\n\t}\n\n\t<T1> void g(A<T1> a) {\n\t}\n\n\t<T2> void invoke(T2 t) {\n\t\tf(new A<T2>());\n\t\tg(new A<T2>());\n\n\t\tf(new A<@NonNull T2>());\n\t\tg(new A<@NonNull T2>());\n\n\t\tf(new A<@Nullable T2>());\n\t\tg(new A<@Nullable T2>());\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug485988nonnull() {
        this.runNegativeTestWithLibs(new String[]{"nonnull/WildcardNonNullTest.java", "package nonnull;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault\nclass A<@NonNull T> {\n}\n\nabstract class X {\n\tabstract A<@NonNull ?> g1();\n\n\tabstract A<@NonNull ?> g2();\n\n\tabstract A<@NonNull ?> g2b();\n\n\tabstract A<@NonNull ?> g3();\n\n\tabstract A<@NonNull ?> h1();\n\n\tabstract A<@NonNull ?> h2();\n\n\tabstract A<@NonNull ?> h2b();\n\n\tabstract A<@NonNull ?> h3();\n}\n\nclass Y extends X {\n\t@Override\n\tA<?> g1() {\n\t\treturn new A<@NonNull String>();\n\t}\n\n\t@Override\n\tA<@NonNull ?> g2() {\n\t\treturn new A<@NonNull String>();\n\t}\n\n\t@Override\n\tA<? extends @NonNull Number> g2b() {\n\t\treturn new A<@NonNull Integer>();\n\t}\n\n\t@Override\n\tA<@NonNull String> g3() {\n\t\treturn new A<@NonNull String>();\n\t}\n\n\t@Override\n\tA<?> h1() {\n\t\treturn new A<@Nullable String>();\n\t}\n\n\t@Override\n\tA<@Nullable ?> h2() {\n\t\treturn new A<@Nullable String>();\n\t}\n\n\t@Override\n\tA<? super @Nullable String> h2b() {\n\t\treturn new A<@Nullable String>();\n\t}\n\n\t@Override\n\tA<@Nullable String> h3() {\n\t\treturn new A<@Nullable String>();\n\t}\n}\n\n@NonNullByDefault\npublic class WildcardNonNullTest {\n\tvoid f(A<?> a) {\n\t}\n\n\t<@NonNull T1> void g(A<T1> a) {\n\t}\n\n\t<T2> void invoke(T2 t) {\n\t\tf(new A<T2>());\n\t\tg(new A<T2>());\n\n\t\tf(new A<@NonNull T2>());\n\t\tg(new A<@NonNull T2>());\n\n\t\tf(new A<@Nullable T2>());\n\t\tg(new A<@Nullable T2>());\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in nonnull\\WildcardNonNullTest.java (at line 52)\n\treturn new A<@Nullable String>();\n\t             ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter '@NonNull T'\n----------\n2. ERROR in nonnull\\WildcardNonNullTest.java (at line 56)\n\tA<@Nullable ?> h2() {\n\t^\nThe return type is incompatible with 'A<@NonNull ?>' returned from X.h2() (mismatching null constraints)\n----------\n3. ERROR in nonnull\\WildcardNonNullTest.java (at line 56)\n\tA<@Nullable ?> h2() {\n\t  ^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable ?' is not a valid substitute for the type parameter '@NonNull T'\n----------\n4. ERROR in nonnull\\WildcardNonNullTest.java (at line 57)\n\treturn new A<@Nullable String>();\n\t             ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter '@NonNull T'\n----------\n5. ERROR in nonnull\\WildcardNonNullTest.java (at line 61)\n\tA<? super @Nullable String> h2b() {\n\t^\nThe return type is incompatible with 'A<@NonNull ?>' returned from X.h2b() (mismatching null constraints)\n----------\n6. ERROR in nonnull\\WildcardNonNullTest.java (at line 61)\n\tA<? super @Nullable String> h2b() {\n\t  ^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '? super @Nullable String' is not a valid substitute for the type parameter '@NonNull T'\n----------\n7. ERROR in nonnull\\WildcardNonNullTest.java (at line 62)\n\treturn new A<@Nullable String>();\n\t             ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter '@NonNull T'\n----------\n8. ERROR in nonnull\\WildcardNonNullTest.java (at line 66)\n\tA<@Nullable String> h3() {\n\t^\nThe return type is incompatible with 'A<@NonNull ?>' returned from X.h3() (mismatching null constraints)\n----------\n9. ERROR in nonnull\\WildcardNonNullTest.java (at line 66)\n\tA<@Nullable String> h3() {\n\t  ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter '@NonNull T'\n----------\n10. ERROR in nonnull\\WildcardNonNullTest.java (at line 67)\n\treturn new A<@Nullable String>();\n\t             ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter '@NonNull T'\n----------\n11. ERROR in nonnull\\WildcardNonNullTest.java (at line 80)\n\tf(new A<T2>());\n\t        ^^\nNull constraint mismatch: The type 'T2' is not a valid substitute for the type parameter '@NonNull T'\n----------\n12. WARNING in nonnull\\WildcardNonNullTest.java (at line 81)\n\tg(new A<T2>());\n\t  ^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'A<T2>' needs unchecked conversion to conform to '@NonNull A<@NonNull T2>'\n----------\n13. ERROR in nonnull\\WildcardNonNullTest.java (at line 81)\n\tg(new A<T2>());\n\t        ^^\nNull constraint mismatch: The type 'T2' is not a valid substitute for the type parameter '@NonNull T'\n----------\n14. ERROR in nonnull\\WildcardNonNullTest.java (at line 86)\n\tf(new A<@Nullable T2>());\n\t        ^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable T2' is not a valid substitute for the type parameter '@NonNull T'\n----------\n15. ERROR in nonnull\\WildcardNonNullTest.java (at line 87)\n\tg(new A<@Nullable T2>());\n\t  ^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull A<@NonNull T2>' but this expression has type 'A<@Nullable T2>'\n----------\n16. ERROR in nonnull\\WildcardNonNullTest.java (at line 87)\n\tg(new A<@Nullable T2>());\n\t        ^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable T2' is not a valid substitute for the type parameter '@NonNull T'\n----------\n");
    }

    public void testBug485988nullable() {
        this.runNegativeTestWithLibs(new String[]{"nullable/WildcardNullableTest.java", "package nullable;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault\nclass A<@Nullable T> {\n}\n\nabstract class X {\n\tabstract A<@Nullable ?> g1();\n\n\tabstract A<@Nullable ?> g2();\n\n\tabstract A<@Nullable ?> g2b();\n\n\tabstract A<@Nullable ?> g3();\n\n\tabstract A<@Nullable ?> h1();\n\n\tabstract A<@Nullable ?> h2();\n\n\tabstract A<@Nullable ?> h2b();\n\n\tabstract A<@Nullable ?> h3();\n}\n\nclass Y extends X {\n\t@Override\n\tA<?> g1() {\n\t\treturn new A<@NonNull String>();\n\t}\n\n\t@Override\n\tA<@NonNull ?> g2() {\n\t\treturn new A<@NonNull String>();\n\t}\n\n\t@Override\n\tA<? extends @NonNull Number> g2b() {\n\t\treturn new A<@NonNull Integer>();\n\t}\n\n\t@Override\n\tA<@NonNull String> g3() {\n\t\treturn new A<@NonNull String>();\n\t}\n\n\t@Override\n\tA<?> h1() {\n\t\treturn new A<@Nullable String>();\n\t}\n\n\t@Override\n\tA<@Nullable ?> h2() {\n\t\treturn new A<@Nullable String>();\n\t}\n\n\t@Override\n\tA<? super @Nullable String> h2b() {\n\t\treturn new A<@Nullable String>();\n\t}\n\n\t@Override\n\tA<@Nullable String> h3() {\n\t\treturn new A<@Nullable String>();\n\t}\n}\n\n@NonNullByDefault\npublic class WildcardNullableTest {\n\tvoid f(A<?> a) {\n\t}\n\n\t<@Nullable T1> void g(A<T1> a) {\n\t}\n\n\t<T2> void invoke(T2 t) {\n\t\tf(new A<T2>());\n\t\tg(new A<T2>());\n\n\t\tf(new A<@NonNull T2>());\n\t\tg(new A<@NonNull T2>());\n\n\t\tf(new A<@Nullable T2>());\n\t\tg(new A<@Nullable T2>());\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in nullable\\WildcardNullableTest.java (at line 32)\n\treturn new A<@NonNull String>();\n\t             ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable T'\n----------\n2. ERROR in nullable\\WildcardNullableTest.java (at line 36)\n\tA<@NonNull ?> g2() {\n\t^\nThe return type is incompatible with 'A<@Nullable ?>' returned from X.g2() (mismatching null constraints)\n----------\n3. ERROR in nullable\\WildcardNullableTest.java (at line 36)\n\tA<@NonNull ?> g2() {\n\t  ^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull ?' is not a valid substitute for the type parameter '@Nullable T'\n----------\n4. ERROR in nullable\\WildcardNullableTest.java (at line 37)\n\treturn new A<@NonNull String>();\n\t             ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable T'\n----------\n5. ERROR in nullable\\WildcardNullableTest.java (at line 41)\n\tA<? extends @NonNull Number> g2b() {\n\t^\nThe return type is incompatible with 'A<@Nullable ?>' returned from X.g2b() (mismatching null constraints)\n----------\n6. ERROR in nullable\\WildcardNullableTest.java (at line 41)\n\tA<? extends @NonNull Number> g2b() {\n\t  ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '? extends @NonNull Number' is not a valid substitute for the type parameter '@Nullable T'\n----------\n7. ERROR in nullable\\WildcardNullableTest.java (at line 42)\n\treturn new A<@NonNull Integer>();\n\t             ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Integer' is not a valid substitute for the type parameter '@Nullable T'\n----------\n8. ERROR in nullable\\WildcardNullableTest.java (at line 46)\n\tA<@NonNull String> g3() {\n\t^\nThe return type is incompatible with 'A<@Nullable ?>' returned from X.g3() (mismatching null constraints)\n----------\n9. ERROR in nullable\\WildcardNullableTest.java (at line 46)\n\tA<@NonNull String> g3() {\n\t  ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable T'\n----------\n10. ERROR in nullable\\WildcardNullableTest.java (at line 47)\n\treturn new A<@NonNull String>();\n\t             ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable T'\n----------\n11. ERROR in nullable\\WildcardNullableTest.java (at line 80)\n\tf(new A<T2>());\n\t        ^^\nNull constraint mismatch: The type 'T2' is not a valid substitute for the type parameter '@Nullable T'\n----------\n12. WARNING in nullable\\WildcardNullableTest.java (at line 81)\n\tg(new A<T2>());\n\t  ^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'A<T2>' needs unchecked conversion to conform to '@NonNull A<@Nullable T2>'\n----------\n13. ERROR in nullable\\WildcardNullableTest.java (at line 81)\n\tg(new A<T2>());\n\t        ^^\nNull constraint mismatch: The type 'T2' is not a valid substitute for the type parameter '@Nullable T'\n----------\n14. ERROR in nullable\\WildcardNullableTest.java (at line 83)\n\tf(new A<@NonNull T2>());\n\t        ^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull T2' is not a valid substitute for the type parameter '@Nullable T'\n----------\n15. ERROR in nullable\\WildcardNullableTest.java (at line 84)\n\tg(new A<@NonNull T2>());\n\t  ^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull A<@Nullable T2>' but this expression has type 'A<@NonNull T2>'\n----------\n16. ERROR in nullable\\WildcardNullableTest.java (at line 84)\n\tg(new A<@NonNull T2>());\n\t        ^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull T2' is not a valid substitute for the type parameter '@Nullable T'\n----------\n");
    }

    public void testBug485988WildCardForTVWithNonNullBound() {
        this.runConformTestWithLibs(new String[]{"test/WildCard.java", "package test;\n\nimport java.io.Serializable;\nimport java.util.ArrayList;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\nclass F<T extends Serializable> {\n}\n\n@NonNullByDefault\npublic class WildCard {\n\tvoid f(ArrayList<F<?>> list) {\n\t\tfor (F<? extends Serializable> f : list) {\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug485988WildcardWithGenericBound() {
        this.runWarningTestWithLibs(true, new String[]{"test/Test1.java", "package test;\nimport java.util.Collection;\nimport java.util.Iterator;\n\nimport org.eclipse.jdt.annotation.NonNull;\ninterface LibA {\n\t<T> Iterator<? extends T> constrainedWildcards(Collection<? extends T> in);\n}\npublic class Test1 {\n\tIterator<? extends @NonNull String> test3(LibA lib, Collection<String> coll) {\n\t\treturn lib.constrainedWildcards(coll);\n\t}\n}\n\n"}, this.getCompilerOptions(), "----------\n1. WARNING in test\\Test1.java (at line 11)\n\treturn lib.constrainedWildcards(coll);\n\t                                ^^^^\nNull type safety (type annotations): The expression of type 'Collection<String>' needs unchecked conversion to conform to 'Collection<? extends @NonNull String>'\n----------\n");
    }

    public void testBug485988Contradictory() {
        this.runNegativeTestWithLibs(new String[]{"test/Test1.java", "package test;\n\nimport org.eclipse.jdt.annotation.*;\ninterface A<T> {\n}\npublic class Test1{\n\tvoid f1(A<@Nullable @NonNull ?> a) {\n\t}\n\tvoid f2(A<@NonNull @Nullable ?> a) {\n\t}\n\tvoid f3(A<@Nullable ? extends @NonNull Object> a) {\n\t}\n\tvoid f4(A<@NonNull ? super @Nullable Integer> a) {\n\t}\n\tvoid f5(A<@Nullable ? super @Nullable Integer> a) {\n\t}\n\t@NonNullByDefault void f6(A<@Nullable ? extends Integer> a) {\n\t}\n}\n\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\Test1.java (at line 7)\n\tvoid f1(A<@Nullable @NonNull ?> a) {\n\t                    ^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n2. ERROR in test\\Test1.java (at line 9)\n\tvoid f2(A<@NonNull @Nullable ?> a) {\n\t                   ^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n3. ERROR in test\\Test1.java (at line 11)\n\tvoid f3(A<@Nullable ? extends @NonNull Object> a) {\n\t                              ^^^^^^^^\nThis nullness annotation conflicts with a '@Nullable' annotation which is effective on the same type parameter \n----------\n4. ERROR in test\\Test1.java (at line 13)\n\tvoid f4(A<@NonNull ? super @Nullable Integer> a) {\n\t                           ^^^^^^^^^\nThis nullness annotation conflicts with a '@NonNull' annotation which is effective on the same type parameter \n----------\n");
    }

    public void testBug485988bound() {
        this.runConformTestWithLibs(new String[]{"C.java", "import org.eclipse.jdt.annotation.NonNull;\n\ninterface I<T> { }\n\npublic class C {\n\tI<@NonNull ?> m1(I<? extends @NonNull C> i) {\n\t\treturn i;\n\t}\n\tI<? extends @NonNull C> m2(I<@NonNull ? extends C> i) {\n\t\treturn i;\n\t}\n\t\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug466585_comment_0() {
        this.runConformTestWithLibs(new String[]{"C3.java", "import org.eclipse.jdt.annotation.*;\nclass C3<T extends @NonNull Number> {\n    C3<?> x; // Null constraint mismatch: The type '?' is not a valid substitute for the type parameter 'T extends @NonNull Number'\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug466585_comment_4() {
        this.runNegativeTestWithLibs(new String[]{"C3.java", "import org.eclipse.jdt.annotation.*;\n\nclass C4<T extends @NonNull Number> {\n  C4<@Nullable ?> err1;\n  C4<@Nullable ? extends Integer> err2;\n  C4<? super @Nullable Integer> err3;\n  C4<@Nullable ? super Integer> err4;\n  C4<@NonNull ? super Integer> ok1;\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C3.java (at line 4)\n\tC4<@Nullable ?> err1;\n\t   ^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable ?' is not a valid substitute for the type parameter 'T extends @NonNull Number'\n----------\n2. ERROR in C3.java (at line 5)\n\tC4<@Nullable ? extends Integer> err2;\n\t   ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable ? extends Integer' is not a valid substitute for the type parameter 'T extends @NonNull Number'\n----------\n3. ERROR in C3.java (at line 6)\n\tC4<? super @Nullable Integer> err3;\n\t   ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '? super @Nullable Integer' is not a valid substitute for the type parameter 'T extends @NonNull Number'\n----------\n4. ERROR in C3.java (at line 7)\n\tC4<@Nullable ? super Integer> err4;\n\t   ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable ? super Integer' is not a valid substitute for the type parameter 'T extends @NonNull Number'\n----------\n");
    }

    public void testBug489978() {
        this.runConformTestWithLibs(new String[]{"test/BinaryClass.java", "package test;\n\nimport java.util.ArrayList;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class BinaryClass {\n\tpublic ArrayList<Object> list;\n\n\tpublic BinaryClass(ArrayList<Object> list) {\n\t\tthis.list = list;\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test/Usage.java", "package test;\n\nimport java.util.ArrayList;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Usage {\n\tArrayList<Object> f(BinaryClass b) {\n\t\treturn b.list;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug489245() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables", "info");
        this.runWarningTestWithLibs(true, new String[]{"test/TestBogusProblemReportOnlyAsInfo.java", "package test;\n\nimport java.util.function.Supplier;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class TestBogusProblemReportOnlyAsInfo {\n\tstatic <U> void get(Supplier<U> supplier, @NonNull U defaultValue) {\n\t}\n\n\tstatic void f() {\n\t\tget(() -> {\n\t\t\treturn null; // bogus problem report only as info\n\t\t}, \"\");\n\t}\n\n\tstatic <T> void h(@NonNull T t) {\n\t\tget(() -> {\n\t\t\treturn null; // correctly reported (but twice with the bug)\n\t\t}, t);\n\t}\n}\n"}, compilerOptions, "----------\n1. INFO in test\\TestBogusProblemReportOnlyAsInfo.java (at line 21)\n\treturn null; // correctly reported (but twice with the bug)\n\t       ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'T'\n----------\n");
    }

    public void testBug489674() {
        HashMap<String, String> options = new HashMap<String, String>(this.getCompilerOptions());
        options.put("org.eclipse.jdt.core.compiler.annotation.nonnull.secondary", "org.foo.NonNull");
        options.put("org.eclipse.jdt.core.compiler.annotation.nullable.secondary", "org.foo.Nullable");
        this.runConformTest(new String[]{"org/foo/Nullable.java", "package org.foo;\nimport java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({ FIELD, METHOD, PARAMETER, LOCAL_VARIABLE })\npublic @interface Nullable {}\n", "org/foo/NonNull.java", "package org.foo;\nimport java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({ FIELD, METHOD, PARAMETER, LOCAL_VARIABLE })\npublic @interface NonNull {}\n"}, options);
        this.runConformTestWithLibs(false, new String[]{"with_other_nullable/P1.java", "package with_other_nullable;\n\nimport org.foo.Nullable;\n\npublic class P1 {\n\tpublic static @Nullable String f0() {\n\t\treturn null;\n\t}\n\n\tpublic static <T> T check(T t) {\n\t\treturn t;\n\t}\n}\n", "with_other_nullable/P2.java", "package with_other_nullable;\n\nimport org.foo.NonNull;\n\npublic class P2 {\n\tpublic static void f(@NonNull String s) {\n\t}\n\n\tpublic static <T> T check(T t) {\n\t\treturn t;\n\t}\n}\n"}, options, "");
        this.runNegativeTestWithLibs(false, new String[]{"test/Test4.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\nimport with_other_nullable.P1;\nimport with_other_nullable.P2;\n\n@NonNullByDefault\npublic class Test4 {\n\tvoid m1(String s) {\n\t\tP1.f0().hashCode();\n\t\ts = P1.check(s);\n\t}\n\tvoid m2(String s) {\n\t\tP2.f(null);\n\t\ts = P2.check(s);\n\t}\n}\n"}, options, "----------\n1. ERROR in test\\Test4.java (at line 11)\n\tP1.f0().hashCode();\n\t^^^^^^^\nPotential null pointer access: The method f0() may return null\n----------\n2. ERROR in test\\Test4.java (at line 15)\n\tP2.f(null);\n\t     ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n", false);
    }

    public void testBug492327() {
        this.runConformTestWithLibs(new String[]{"WatchEvent.java", "public interface WatchEvent<T> {\n\tpublic static interface Modifier {\n\t}\n}\n", "Watchable.java", "public interface Watchable {\n\tvoid register(WatchEvent.Modifier[] modifiers);\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"Path.java", "public interface Path extends Watchable {\n  @Override\n  void register(WatchEvent.Modifier[] modifiers);\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug488495collector() {
        this.runConformTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\ninterface Collector<A, R> {\n}\n\ninterface Stream {\n    <A1, R1> R1 collect(Collector<A1, R1> collector);\n}\n\ninterface List<E> {\n}\n\n@NonNullByDefault\npublic class Test {\n    public static <T> Collector<?, List<T>> toList() {\n        return new Collector<Object, List<T>>(){};\n    }\n\n    public static List<String> myMethod(Stream stream) {\n        List<String> list = stream.collect(toList());\n        return list;\n    }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug496591() {
        this.runConformTestWithLibs(new String[]{"test2/Descriptors.java", "package test2;\n\npublic final class Descriptors {\n\tpublic static final class FieldDescriptor implements FieldSet.FieldDescriptorLite<FieldDescriptor> { }\n}\n", "test2/FieldSet.java", "package test2;\n\npublic final class FieldSet<F1 extends FieldSet.FieldDescriptorLite<F1>> {\n\tpublic interface FieldDescriptorLite<F2 extends FieldDescriptorLite<F2>> { }\n\n\tvoid f(final Map.Entry<F1> entry) { }\n}\n", "test2/Map.java", "package test2;\n\npublic class Map<K> {\n\tinterface Entry<K1> { }\n}\n", "test2/MessageOrBuilder.java", "package test2;\n\npublic interface MessageOrBuilder {\n\tMap<Descriptors.FieldDescriptor> getAllFields();\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test1/GeneratedMessage.java", "package test1;\n\nimport test2.Descriptors.FieldDescriptor;\nimport test2.Map;\nimport test2.MessageOrBuilder;\n\npublic abstract class GeneratedMessage implements MessageOrBuilder {\n\t@Override\n\tpublic abstract Map<FieldDescriptor> getAllFields();\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug497698() {
        this.runNegativeTest(new String[]{"test/And.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class And {\n\tpublic static void createAnd() {\n\t\tOr.create();\n\t}\n}\n", "test/Or.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Or<D, V> {\n\tpublic static <V> Or<V> create() {\n\t\treturn new Or<V, V>();\n\t}\n}\n"}, "----------\n1. ERROR in test\\Or.java (at line 7)\n\tpublic static <V> Or<V> create() {\n\t                  ^^\nIncorrect number of arguments for type Or<D,V>; it cannot be parameterized with arguments <V>\n----------\n", this.LIBS, true);
    }

    public void testBug497698raw() {
        this.runNegativeTest(new String[]{"test/And.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class And {\n\tpublic static void createAnd() {\n\t\tnew Or().create();\n\t}\n}\n", "test/Or.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Or<D, V> {\n\tpublic <V1> Or<V1> create() {\n\t\treturn new Or<V1, V1>();\n\t}\n}\n"}, "----------\n1. WARNING in test\\And.java (at line 8)\n\tnew Or().create();\n\t    ^^\nOr is a raw type. References to generic type Or<D,V> should be parameterized\n----------\n----------\n1. ERROR in test\\Or.java (at line 7)\n\tpublic <V1> Or<V1> create() {\n\t            ^^\nIncorrect number of arguments for type Or<D,V>; it cannot be parameterized with arguments <V1>\n----------\n", this.LIBS, false);
    }

    public void testBug497698nestedinraw() {
        this.runNegativeTest(new String[]{"test/And.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class And {\n\tpublic static void createAnd(X.Or x) {\n\t\tx.create();\n\t}\n}\n", "test/X.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class X<Z> {\n\tpublic class Or<D, V> {\n\t\tpublic <V1> Or<V1> create() {\n\t\t\treturn new Or<V1,V1>();\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in test\\And.java (at line 7)\n\tpublic static void createAnd(X.Or x) {\n\t                             ^^^^\nX.Or is a raw type. References to generic type X<Z>.Or<D,V> should be parameterized\n----------\n----------\n1. ERROR in test\\X.java (at line 8)\n\tpublic <V1> Or<V1> create() {\n\t            ^^\nIncorrect number of arguments for type X<Z>.Or<D,V>; it cannot be parameterized with arguments <V1>\n----------\n", this.LIBS, true);
    }

    public void testBug492322() {
        this.runConformTestWithLibs(new String[]{"test1/Base.java", "package test1;\n\nimport org.eclipse.jdt.annotation.DefaultLocation;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic abstract class Base {\n  public class GenericInner<T> {\n  }\n\n  @NonNullByDefault(DefaultLocation.PARAMETER)\n  public Object method(@Nullable GenericInner<Object> nullable) {\n    return new Object();\n  }\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test2/Derived.java", "package test2;\n\nimport test1.Base;\n\nclass Derived extends Base {\n  void test() {\n    method(null);\n  }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug492322field() {
        this.runConformTestWithLibs(new String[]{"test1/Base.java", "package test1;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault\npublic abstract class Base {\n  public class GenericInner<T> {\n  }\n\n  protected @Nullable GenericInner<Object> field;\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test2/Derived.java", "package test2;\n\nimport test1.Base;\n\nclass Derived extends Base {\n  void test() {\n    field = null;\n  }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug492322deep() {
        this.runConformTestWithLibs(new String[]{"test1/Base.java", "package test1;\n\nimport org.eclipse.jdt.annotation.DefaultLocation;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic abstract class Base {\n  public static class Static {\n   public class Middle1 {\n     public class Middle2<M> {\n       public class Middle3 {\n        public class GenericInner<T> {\n        }\n       }\n     }\n   }\n  }\n\n  @NonNullByDefault(DefaultLocation.PARAMETER)\n  public Object method( Static.Middle1.Middle2<Object>.Middle3.@Nullable GenericInner<String> nullable) {\n    return new Object();\n  }\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test2/Derived.java", "package test2;\n\nimport test1.Base;\n\nclass Derived extends Base {\n  void test() {\n    method(null);\n  }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug492322withGenericBase() {
        this.runConformTestWithLibs(new String[]{"test1/Base.java", "package test1;\n\nimport org.eclipse.jdt.annotation.DefaultLocation;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic abstract class Base<B> {\n   static public class Static {\n    public class Middle1 {\n     public class Middle2<M> {\n       public class Middle3 {\n        public class GenericInner<T> {\n        }\n       }\n     }\n   }\n  }\n\n  @NonNullByDefault(DefaultLocation.PARAMETER)\n  public Object method( Static.Middle1.Middle2<Object>.Middle3.@Nullable GenericInner<String> nullable) {\n    return new Object();\n  }\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test2/Derived.java", "package test2;\n\nimport test1.Base;\n\nclass Derived extends Base<Number> {\n  void test() {\n    method(null);\n  }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug499862a() {
        this.runConformTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Test {\n\tstatic void printChecked(Collection<? extends @Nullable String> collection) {\n\t\tfor(String s : collection)\n\t\t\tif (s != null)\n\t\t\t\tSystem.out.println(s.toString());\n\t\t\telse\n\t\t\t\tSystem.out.println(\"NULL\");\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug499862b() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Test {\n\tstatic void printChecked(Collection<? extends @Nullable String> collection) {\n\t\tfor(String s : collection)\n\t\t\tSystem.out.println(s.toString());\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Test.java (at line 6)\n\tSystem.out.println(s.toString());\n\t                   ^\nPotential null pointer access: The variable s may be null at this location\n----------\n");
    }

    public void testBug499862c() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import java.util.*;\npublic class Test {\n\tstatic <T> void printUnchecked(Collection<T> collection) {\n\t\tfor(T t : collection)\n\t\t\tSystem.out.println(t.toString());\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Test.java (at line 5)\n\tSystem.out.println(t.toString());\n\t                   ^\nPotential null pointer access: this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug499597simplified() {
        this.runConformTestWithLibs(new String[]{"Foo2.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\nclass Foo2 {\n\tstatic <T> T of(T t) {\n\t\treturn t;\n\t}\n\n\tstatic String foo() {\n\t\treturn Foo2.<String>of(\"\"); // <-- warning here\n\t}\n\n\tstatic String bar() {\n\t\treturn Foo2.<@NonNull String>of(\"\"); // <-- no warning\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug499597original() {
        this.runWarningTestWithLibs(true, new String[]{"Foo.java", "import static org.eclipse.jdt.annotation.DefaultLocation.*;\nimport org.eclipse.jdt.annotation.*;\n\nimport java.util.Collection;\nimport java.util.Collections;\n\nclass Foo {\n\tstatic @NonNull String @NonNull [] X = { \"A\" };\n\n\t@NonNullByDefault({ PARAMETER, RETURN_TYPE, FIELD, TYPE_PARAMETER, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS })\n\t@SafeVarargs\n\tstatic <T> Collection<T> of(@NonNull T @NonNull... elements) {\n\t\treturn Collections.singleton(elements[0]);\n\t}\n\n\t@NonNullByDefault({ PARAMETER, RETURN_TYPE, FIELD, TYPE_PARAMETER, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS })\n\tstatic Collection<String[]> foo() {\n\t\treturn Foo.<String[]>of(X); // <-- warning here\n\t}\n\n\t@NonNullByDefault({ PARAMETER, RETURN_TYPE, FIELD, TYPE_PARAMETER, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS })\n\tstatic Collection<String[]> bar() {\n\t\treturn Foo.<String @NonNull []>of(X); // <-- no warning\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Foo.java (at line 12)\n\tstatic <T> Collection<T> of(@NonNull T @NonNull... elements) {\n\t                            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe nullness annotation is redundant with a default that applies to this location\n----------\n2. WARNING in Foo.java (at line 13)\n\treturn Collections.singleton(elements[0]);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Set<@NonNull T>' needs unchecked conversion to conform to '@NonNull Collection<@NonNull T>', corresponding supertype is 'Collection<@NonNull T>'\n----------\n");
    }

    public void testBug501031() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.DefaultLocation;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault(DefaultLocation.TYPE_PARAMETER)\nclass X {\n\t<T> @NonNull Object identity(T t) {\n\t\treturn t;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug501031return() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.DefaultLocation;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault(DefaultLocation.TYPE_PARAMETER)\nclass X {\n\t<T> T identity() {\n\t\treturn null;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 7)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n");
    }

    public void testBug501031btb() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.DefaultLocation;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault(DefaultLocation.TYPE_PARAMETER)\nclass X {\n\t<T> void identity(T t) {\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault\nclass Y {\n\tvoid test(X x, @Nullable String string) {\n\t\tx.identity(string);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Y.java (at line 7)\n\tx.identity(string);\n\t           ^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testBug501449() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import org.eclipse.jdt.annotation.Nullable;\n\npublic class Test {\n\t<T, S extends T> void f(T[] objects, @Nullable T nullableValue, T value, S subclassValue) {\n\t\tobjects[0] = null;\n\t\tobjects[1] = nullableValue;\n\t\tobjects[2] = value;\n\t\tobjects[3] = subclassValue;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Test.java (at line 5)\n\tobjects[0] = null;\n\t             ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'T'\n----------\n2. ERROR in Test.java (at line 6)\n\tobjects[1] = nullableValue;\n\t             ^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'T' but this expression has type '@Nullable T', where 'T' is a free type variable\n----------\n");
    }

    public void testBug502112() {
        this.runConformTest(new String[]{"org/foo/Nullable.java", "package org.foo;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\npublic @interface Nullable {}\n"}, this.getCompilerOptions());
        this.runConformTestWithLibs(false, new String[]{"util/Optional.java", "package util;\n\nimport org.foo.Nullable;\n\npublic class Optional {\n\tpublic static <T> T fromNullable(@Nullable T nullableReference, @Nullable T nullableReference2) {\n\t\treturn nullableReference;\n\t}\n\t@Nullable\n\tpublic static <T> T returnNull(T nullableReference) {\n\t\treturn nullableReference;\n\t}\n}\n"}, this.getCompilerOptions(), "");
        HashMap<String, String> options = new HashMap<String, String>(this.getCompilerOptions());
        options.put("org.eclipse.jdt.core.compiler.annotation.nonnull.secondary", "org.foo.NonNull");
        options.put("org.eclipse.jdt.core.compiler.annotation.nullable.secondary", "org.foo.Nullable");
        this.runNegativeTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\nimport util.Optional;\n\n@NonNullByDefault\npublic class Test {\n\tvoid f(@Nullable String s) {\n\t\tOptional.<String>fromNullable(s, null);\n\t}\n\tString g(@Nullable String s) {\n\t\treturn Optional.<String>returnNull(s);\n\t}\n}\n"}, options, "----------\n1. ERROR in test\\Test.java (at line 14)\n\treturn Optional.<String>returnNull(s);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n2. ERROR in test\\Test.java (at line 14)\n\treturn Optional.<String>returnNull(s);\n\t                                   ^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testBug502112b() {
        this.runConformTest(new String[]{"org/foo/NonNull.java", "package org.foo;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\npublic @interface NonNull {}\n", "org/foo/Nullable.java", "package org.foo;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\npublic @interface Nullable {}\n"}, this.getCompilerOptions());
        this.runConformTestWithLibs(false, new String[]{"util/X.java", "package util;\n\nimport org.foo.NonNull;\nimport org.foo.Nullable;\n\npublic class X {\n\t@NonNull\n\tpublic <T> T nonNull(@Nullable T t, @Nullable T t2) {\n\t\treturn java.util.Objects.requireNonNull(t);\n\t}\n}\n"}, this.getCompilerOptions(), "");
        HashMap<String, String> options = new HashMap<String, String>(this.getCompilerOptions());
        options.put("org.eclipse.jdt.core.compiler.annotation.nonnull.secondary", "org.foo.NonNull");
        options.put("org.eclipse.jdt.core.compiler.annotation.nullable.secondary", "org.foo.Nullable");
        this.runNegativeTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\nimport util.X;\n\n@NonNullByDefault\npublic class Test extends X{\n\t@Override\n\tpublic <T> @Nullable T nonNull(@NonNull T t, T t2) {\n\t\treturn t;\n\t}\n}\n"}, options, "----------\n1. ERROR in test\\Test.java (at line 12)\n\tpublic <T> @Nullable T nonNull(@NonNull T t, T t2) {\n\t           ^^^^^^^^^^^\nThe return type is incompatible with '@NonNull T extends Object' returned from X.nonNull(T, T) (mismatching null constraints)\n----------\n2. ERROR in test\\Test.java (at line 12)\n\tpublic <T> @Nullable T nonNull(@NonNull T t, T t2) {\n\t                               ^^^^^^^^^^\nIllegal redefinition of parameter t, inherited method from X declares this parameter as @Nullable\n----------\n3. ERROR in test\\Test.java (at line 12)\n\tpublic <T> @Nullable T nonNull(@NonNull T t, T t2) {\n\t                                             ^\nMissing nullable annotation: inherited method from X specifies this parameter as @Nullable\n----------\n");
    }

    public void testBug484926locals() {
        this.runNegativeTestWithLibs(new String[]{"test/NNBDOnLocalOrField.java", "package test;\n\nimport org.eclipse.jdt.annotation.*;\n\nclass AtomicReference<T> {\n\n\tpublic void set(T object) {\n\t}\n\n}\n\n@NonNullByDefault\npublic class NNBDOnLocalOrField {\n\tvoid someMethod() {\n\t\tAtomicReference<String> x1 = new AtomicReference<>();\n\t\tAtomicReference<String> x2 = new AtomicReference<@NonNull String>(), x3=new AtomicReference<@Nullable String>();\n\t\t@NonNullByDefault({})\n\t\tAtomicReference<String> y1 = new AtomicReference<>();\n\t\t@NonNullByDefault({})\n\t\tAtomicReference<String> y2 = new AtomicReference<@NonNull String>(), y3=new AtomicReference<@Nullable String>();\n\t\tx1.set(null);\n\t\tx2.set(null);\n\t\tx3.set(null);\n\t\ty1.set(null);\n\t\ty2.set(null);\n\t\ty3.set(null);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\NNBDOnLocalOrField.java (at line 16)\n\tAtomicReference<String> x2 = new AtomicReference<@NonNull String>(), x3=new AtomicReference<@Nullable String>();\n\t                                                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'AtomicReference<@NonNull String>' but this expression has type 'AtomicReference<@Nullable String>'\n----------\n2. ERROR in test\\NNBDOnLocalOrField.java (at line 21)\n\tx1.set(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n3. ERROR in test\\NNBDOnLocalOrField.java (at line 22)\n\tx2.set(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n4. ERROR in test\\NNBDOnLocalOrField.java (at line 23)\n\tx3.set(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug484926fields() {
        this.runNegativeTestWithLibs(new String[]{"test/NNBDOnLocalOrField.java", "package test;\n\nimport org.eclipse.jdt.annotation.*;\n\nclass AtomicReference<T> {\n\n\tpublic void set(T object) {\n\t}\n\n}\n\n@NonNullByDefault\npublic class NNBDOnLocalOrField {\n\tAtomicReference<String> x1 = new AtomicReference<>();\n\tAtomicReference<String> x2 = new AtomicReference<@NonNull String>(), x3=new AtomicReference<@Nullable String>();\n\t@NonNullByDefault({})\n\tAtomicReference<String> y1 = new AtomicReference<>();\n\t@NonNullByDefault({})\n\tAtomicReference<String> y2 = new AtomicReference<@NonNull String>(), y3=new AtomicReference<@Nullable String>();\n\tvoid someMethod() {\n\t\tx1.set(null);\n\t\tx2.set(null);\n\t\tx3.set(null);\n\t\ty1.set(null);\n\t\ty2.set(null);\n\t\ty3.set(null);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\NNBDOnLocalOrField.java (at line 15)\n\tAtomicReference<String> x2 = new AtomicReference<@NonNull String>(), x3=new AtomicReference<@Nullable String>();\n\t                                                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull AtomicReference<@NonNull String>' but this expression has type 'AtomicReference<@Nullable String>'\n----------\n2. ERROR in test\\NNBDOnLocalOrField.java (at line 21)\n\tx1.set(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n3. ERROR in test\\NNBDOnLocalOrField.java (at line 22)\n\tx2.set(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n4. ERROR in test\\NNBDOnLocalOrField.java (at line 23)\n\tx3.set(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug484926() {
        this.runConformTestWithLibs(new String[]{"test/NNBDOnLocalOrField.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\nclass AtomicReference<T> {\n\n\tpublic void set(T object) {\n\t}\n\n}\n\n@NonNullByDefault\npublic class NNBDOnLocalOrField {\n\t@NonNullByDefault({})\n\tAtomicReference<String> f = new AtomicReference<>();\n\n\t{\n\t\tf.set(null);\n\t}\n\n\t@NonNullByDefault({})\n\tRunnable r = () -> {\n\t\tAtomicReference<String> x1 = new AtomicReference<>();\n\t\tx1.set(null);\n\t};\n\n\tObject someMethod() {\n\t\t@NonNullByDefault({})\n\t\tAtomicReference<String> x2 = new AtomicReference<>();\n\t\tx2.set(null);\n\n\t\t@NonNullByDefault({})\n\t\tRunnable r1 = () -> {\n\t\t\tAtomicReference<String> x3 = new AtomicReference<>();\n\t\t\tx3.set(null);\n\t\t};\n\t\t\n\t\treturn r1;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug484926nesting() {
        this.runNegativeTestWithLibs(new String[]{"test/NNBDOnLocalOrField.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\nclass AtomicReference<T> {\n\n\tpublic void set(T object) {\n\t}\n\n}\n\npublic class NNBDOnLocalOrField {\n\t@NonNullByDefault()\n\tRunnable r = () -> {\n\t\t@NonNullByDefault({})\n\t\tAtomicReference<String> x1 = new AtomicReference<>();\n\t\tx1.set(null);\n\t};\n\t@NonNullByDefault\n\tObject someMethod() {\n\t\t@NonNullByDefault({})\n\t\tAtomicReference<String> x2 = new AtomicReference<>();\n\t\tx2.set(null);\n\n\t\t@NonNullByDefault({})\n\t\tRunnable r1 = () -> {\n\t\t\t@NonNullByDefault\n\t\t\tAtomicReference<String> x3 = new AtomicReference<>();\n\t\t\tx3.set(null);\n\t\t};\n\t\t\n\t\treturn r1;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\NNBDOnLocalOrField.java (at line 29)\n\tx3.set(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug484926localDeclarationInForLoop() {
        this.runConformTestWithLibs(new String[]{"test/NNBDOnLocalOrField.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\nclass AtomicReference<T> {\n\n\tpublic void set(T object) {\n\t}\n\n}\n\n@NonNullByDefault\npublic class NNBDOnLocalOrField {\n\tvoid someMethod() {\n\t\tfor(@NonNullByDefault({})\n\t\tRunnable r1 = () -> {\n\t\t\tAtomicReference<String> x3 = new AtomicReference<>();\n\t\t\tx3.set(null);\n\t\t}, r2 = () -> {\n\t\t\tAtomicReference<String> x4 = new AtomicReference<>();\n\t\t\tx4.set(null);\n\t\t};;) {\n\t\t\tr1.run();\n\t\t\tr2.run();\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug484926redundantNNBD() {
        this.runNegativeTestWithLibs(new String[]{"testnnbd/NNBDRedundantOnLocalOrField.java", "package testnnbd;\n\nimport org.eclipse.jdt.annotation.DefaultLocation;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault({})\nclass AtomicReference<T> {\n\tpublic void set(T object) {\n\t}\n}\n\npublic class NNBDRedundantOnLocalOrField {\n\t@NonNullByDefault\n\tRunnable r1 = () -> {\n\t\t@NonNullByDefault\n\t\tAtomicReference<String> x3 = new AtomicReference<>();\n\t\tx3.set(null);\n\t}, r2 = () -> {\n\t\t@NonNullByDefault({})\n\t\tAtomicReference<String> x4 = new AtomicReference<String>() {\n\t\t\t@NonNullByDefault({})\n\t\t\tpublic void set(String object) {\n\t\t\t}\n\t\t};\n\t\tx4.set(null);\n\t};\n\n\t@NonNullByDefault\n\tclass X1 {\n\t\t@NonNullByDefault\n\t\tRunnable r = () -> {\n\t\t\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\t\tclass Local extends AtomicReference<String> {\n\t\t\t\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\t\t\tclass X2 {\n\t\t\t\t\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\t\t\t\tString s;\n\t\t\t\t\t\n\t\t\t\t\t{\n\t\t\t\t\t\tset(null);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t{\n\t\t\t\tnew X2().hashCode();\n\t\t\t\t}\n\t\t\t}\n\t\t\tLocal x1 = new Local();\n\t\t\tx1.set(null);\n\t\t};\n\t}\n\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\tObject someMethod() {\n\t\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\tAtomicReference<String> x2 = new AtomicReference<>();\n\t\tx2.set(null);\n\n\t\t@NonNullByDefault({})\n\t\tRunnable r = () -> {\n\t\t\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\t\tAtomicReference<String> x3 = new AtomicReference<>();\n\t\t\tx3.set(null);\n\t\t};\n\n\t\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\tRunnable r2 = new Runnable() {\n\t\t\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\t\t@Override\n\t\t\tpublic void run() {\n\t\t\t}\n\t\t};\n\n\t\tr2.run();\n\t\treturn r;\n\t}\n\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\tvoid forLoopVariable() {\n\t\t{\n\t\t\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\t\tRunnable r = () -> {\n\t\t\t\tAtomicReference<String> x3 = new AtomicReference<>();\n\t\t\t\tx3.set(null);\n\t\t\t}, r2 = () -> {\n\t\t\t\tAtomicReference<String> x4 = new AtomicReference<>();\n\t\t\t\tx4.set(null);\n\t\t\t};\n\t\t\tr.run();\n\t\t\tr2.run();\n\t\t}\n\t\tfor (@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\tRunnable r = () -> {\n\t\t\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\t\tAtomicReference<String> x3 = new AtomicReference<>();\n\t\t\tx3.set(null);\n\t\t}, r2 = () -> {\n\t\t\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t\t\tAtomicReference<String> x4 = new AtomicReference<>();\n\t\t\tx4.set(null);\n\t\t};;) {\n\t\t\tr.run();\n\t\t\tr2.run();\n\t\t}\n\t}\n}\n", "testnnbd/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage testnnbd;\n"}, this.getCompilerOptions(), "----------\n1. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 13)\n\t@NonNullByDefault\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing package testnnbd\n----------\n2. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 15)\n\t@NonNullByDefault\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the field r1\n----------\n3. ERROR in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 17)\n\tx3.set(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n4. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 21)\n\t@NonNullByDefault({})\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the variable x4\n----------\n5. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 22)\n\tpublic void set(String object) {\n\t            ^^^^^^^^^^^^^^^^^^\nThe method set(String) of type new AtomicReference<String>(){} should be tagged with @Override since it actually overrides a superclass method\n----------\n6. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 28)\n\t@NonNullByDefault\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing package testnnbd\n----------\n7. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 30)\n\t@NonNullByDefault\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type NNBDRedundantOnLocalOrField.X1\n----------\n8. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 34)\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type Local\n----------\n9. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 36)\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type Local.X2\n----------\n10. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 37)\n\tString s;\n\t       ^\nThe value of the field Local.X2.s is not used\n----------\n11. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 54)\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing method someMethod()\n----------\n12. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 65)\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing method someMethod()\n----------\n13. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 66)\n\tRunnable r2 = new Runnable() {\n\t         ^^\nThe local variable r2 is hiding a field from type NNBDRedundantOnLocalOrField\n----------\n14. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 67)\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the variable r2\n----------\n15. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 80)\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing method forLoopVariable()\n----------\n16. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 84)\n\t}, r2 = () -> {\n\t   ^^\nThe local variable r2 is hiding a field from type NNBDRedundantOnLocalOrField\n----------\n17. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 91)\n\tfor (@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t     ^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing method forLoopVariable()\n----------\n18. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 91)\n\tfor (@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t     ^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing method forLoopVariable()\n----------\n19. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 93)\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the variable r\n----------\n20. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 96)\n\t}, r2 = () -> {\n\t   ^^\nThe local variable r2 is hiding a field from type NNBDRedundantOnLocalOrField\n----------\n21. WARNING in testnnbd\\NNBDRedundantOnLocalOrField.java (at line 97)\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the variable r2\n----------\n");
    }

    public void testBug484926BTB() {
        this.runConformTestWithLibs(new String[]{"test/ClassWithNNBDOnField.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\nclass AtomicReference<T> {\n\tpublic void set(T object) {\n\t}\n}\n\n@NonNullByDefault()\npublic class ClassWithNNBDOnField {\n\t@NonNullByDefault({})\n\tAtomicReference<String> f = new AtomicReference<>();\n\t{\n\t\tf.set(null);\n\t}\n\n\tpublic static class X {\n\t\t@NonNullByDefault({})\n\t\tAtomicReference<String> nested = new AtomicReference<>();\n\t\t{\n\t\t\tnested.set(null);\n\t\t}\n\t}\n\n\tpublic X x = new X();\n\t\n\tvoid test() {\n\t\tnew ClassWithNNBDOnField().f.set(null);\n\t\tnew ClassWithNNBDOnField().f = null;\n\t\tnew ClassWithNNBDOnField().x.nested.set(null);\n\t\tnew ClassWithNNBDOnField().x.nested = null;\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test/Test.java", "package test;\n\npublic class Test {\n\tvoid test() {\n\t\tnew ClassWithNNBDOnField().f.set(null);\n\t\tnew ClassWithNNBDOnField().f = null;\n\t\tnew ClassWithNNBDOnField().x.nested.set(null);\n\t\tnew ClassWithNNBDOnField().x.nested = null;\n\t}\n\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug500885() {
        this.runConformTest(new String[]{"annot/NonNull.java", "package annot;\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)\npublic @interface NonNull {}\n", "annot/NonNullByDefault.java", "package annot;\n@annot.NonNull\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)\npublic @interface NonNullByDefault {}\n", "annot/package-info.java", "@annot.NonNullByDefault package annot;\n", "test/package-info.java", "@annot.NonNullByDefault package test;\n", "test/X.java", "package test;\npublic interface X {\n\tpublic String get();\n}\n"}, this.getCompilerOptions(), "");
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary", "annot.NonNullByDefault");
        options.put("org.eclipse.jdt.core.compiler.annotation.nonnull.secondary", "annot.NonNull");
        this.runConformTestWithLibs(false, new String[]{"test2/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault package test2;\n", "test2/Y.java", "package test2;\nimport test.X;\npublic class Y implements X {\n\tpublic String get() {\n\t\treturn \"\";\n\t}\n}\n"}, options, "");
    }

    public void testBug505671() {
        this.runConformTestWithLibs(new String[]{"snippet/Pair.java", "package snippet;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Pair {\n\tpublic static <S, T> S make(S left, T right, Object x) {\n\t\tthrow new RuntimeException();\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"snippet/Snippet.java", "package snippet;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class Snippet {\n\tpublic static final @NonNull Object FALSE = new Object();\n\n\tpublic static @NonNull Object abbreviateExplained0() {\n\t\treturn Pair.<String, @NonNull Object>make(null, FALSE, null);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in snippet\\Snippet.java (at line 9)\n\treturn Pair.<String, @NonNull Object>make(null, FALSE, null);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull Object'\n----------\n2. ERROR in snippet\\Snippet.java (at line 9)\n\treturn Pair.<String, @NonNull Object>make(null, FALSE, null);\n\t                                                       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void testBug501564() {
        this.runNegativeTestWithLibs(new String[]{"xxx/Foo.java", "package xxx;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.DefaultLocation;\n\nclass Generic<E1 extends Generic<E1>> { \n}\nclass Foo { \n    static <E2 extends Generic<E2>> Bar<E2> foo() {\n        return new Bar<>();\n    }\n\n    @NonNullByDefault(DefaultLocation.TYPE_PARAMETER)\n    static class Bar<E3 extends Generic<E3>> { }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in xxx\\Foo.java (at line 8)\n\tstatic <E2 extends Generic<E2>> Bar<E2> foo() {\n\t                                    ^^\nNull constraint mismatch: The type 'E2 extends Generic<E2>' is not a valid substitute for the type parameter '@NonNull E3 extends Generic<E3 extends Generic<E3>>'\n----------\n");
    }

    public void testBug501564interface() {
        this.runNegativeTestWithLibs(new String[]{"xxx/Foo.java", "package xxx;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.DefaultLocation;\n\ninterface Generic<E1 extends Generic<E1>> { \n}\nclass Foo { \n    static <E2 extends Generic<E2>> Bar<E2> foo() {\n        return new Bar<>();\n    }\n\n    @NonNullByDefault(DefaultLocation.TYPE_PARAMETER)\n    static class Bar<E3 extends Generic<E3>> { }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in xxx\\Foo.java (at line 8)\n\tstatic <E2 extends Generic<E2>> Bar<E2> foo() {\n\t                                    ^^\nNull constraint mismatch: The type 'E2 extends Generic<E2>' is not a valid substitute for the type parameter '@NonNull E3 extends Generic<E3 extends Generic<E3>>'\n----------\n");
    }

    public void testBug501464() {
        this.runWarningTestWithLibs(true, new String[]{"Foo.java", "import org.eclipse.jdt.annotation.*;\n\ninterface MyList<T> { @NonNull T getAny(); }\n\n@NonNullByDefault({})\nclass Foo {\n    @Nullable Object b;\n    \n    void foo() {\n        @Nullable Object f = b;\n        ((@NonNull Object)f).hashCode(); // Error (unexpected): Potential null pointer access: this expression has a '@Nullable' type\n    }\n    \n    void workaround() {\n        @Nullable Object f = b;\n        @NonNull Object g = (@NonNull Object)f; // Warning (expected): Null type safety: Unchecked cast from @Nullable Object to @NonNull Object\n        g.hashCode();\n    }\n\t String three(@NonNull MyList<@Nullable String> list) {\n\t\treturn ((@NonNull MyList<@NonNull String>) list).getAny().toUpperCase();\n\t }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Foo.java (at line 11)\n\t((@NonNull Object)f).hashCode(); // Error (unexpected): Potential null pointer access: this expression has a '@Nullable' type\n\t^^^^^^^^^^^^^^^^^^^^\nNull type safety: Unchecked cast from @Nullable Object to @NonNull Object\n----------\n2. WARNING in Foo.java (at line 16)\n\t@NonNull Object g = (@NonNull Object)f; // Warning (expected): Null type safety: Unchecked cast from @Nullable Object to @NonNull Object\n\t                    ^^^^^^^^^^^^^^^^^^\nNull type safety: Unchecked cast from @Nullable Object to @NonNull Object\n----------\n3. WARNING in Foo.java (at line 20)\n\treturn ((@NonNull MyList<@NonNull String>) list).getAny().toUpperCase();\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety: Unchecked cast from @NonNull MyList<@Nullable String> to @NonNull MyList<@NonNull String>\n----------\n");
    }

    public void testBug507840() {
        this.runConformTestWithLibs(new String[]{"nnbd_on_typevar/AtomicReference.java", "package nnbd_on_typevar;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\nclass AtomicReference<T> {\n\tpublic void set(T t) {\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"nnbd_on_typevar/Usage.java", "package nnbd_on_typevar;\n\npublic class Usage {\n\tvoid m(AtomicReference<String> ref) {\n\t\tref.set(null);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug508497() {
        this.runConformTestWithLibs(new String[]{"Reference.java", "interface Fluent<SELF extends Fluent<SELF>> {\n\tSELF self();\n}\nabstract class Reference<T> {\n\tabstract T get();\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"B2.java", "class B2 {\n\tvoid b1(Fluent f) {\n\t\tf.self();\n\t}\n\n\tvoid b2(Reference<@org.eclipse.jdt.annotation.NonNull Fluent> ref) {\n\t\tref.get().self();\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in B2.java (at line 2)\n\tvoid b1(Fluent f) {\n\t        ^^^^^^\nFluent is a raw type. References to generic type Fluent<SELF> should be parameterized\n----------\n2. WARNING in B2.java (at line 6)\n\tvoid b2(Reference<@org.eclipse.jdt.annotation.NonNull Fluent> ref) {\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nFluent is a raw type. References to generic type Fluent<SELF> should be parameterized\n----------\n3. INFO in B2.java (at line 7)\n\tref.get().self();\n\t^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type 'Reference<@NonNull Fluent>'. Type 'Reference<T>' doesn't seem to be designed with null type annotations in mind\n----------\n");
    }

    public void testBug509025() {
        this.runConformTestWithLibs(new String[]{"MyAnno.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@Retention(RetentionPolicy.RUNTIME)\n@NonNullByDefault\npublic @interface MyAnno {\n\t@NonNull String[] items();\n\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"AnnoLoop.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class AnnoLoop {\n\t@NonNull\n\tString[] test(MyAnno anno) {\n\t\treturn anno.items();\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug501598() {
        this.runWarningTestWithLibs(true, new String[]{"Foo.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\nclass Foo {\n\tstatic <T> @NonNull List<?> f() {\n\t\tthrow new Error();\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Foo.java (at line 8)\n\tstatic <T> @NonNull List<?> f() {\n\t           ^^^^^^^^^^^^^\nThe nullness annotation is redundant with a default that applies to this location\n----------\n");
    }

    public void testBug509328() {
        this.runConformTestWithLibs(new String[]{"test/Feature.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Feature {\n\tpublic Feature(String name) {\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Test {\n\tpublic static void f() {\n\t\tnew Feature(null) {\n\t\t\t// anonymous subclass\n\t\t};\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\Test.java (at line 8)\n\tnew Feature(null) {\n\t            ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug510799() {
        this.runConformTestWithLibs(new String[]{"test/TestNNBDBreaksDimensionAnnotation.java", "package test;\n\nimport org.eclipse.jdt.annotation.*;\n\n@NonNullByDefault\nclass TestNNBDBreaksDimensionAnnotation {\n\tObject f(String[] @NonNull [] a) {\n\t\treturn a[0];\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug490403() {
        this.runConformTestWithLibs(new String[]{"test/TestNullInt.java", "package test;\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class TestNullInt {\n\n\tpublic void test() {\n\t\t@NonNull Integer[] keys = new @NonNull Integer[12];\n\t\t@NonNull Integer index = 0;\n\t\tfor (int i = 0; i < 10; i++) {\n\t\t\tkeys[index] = index;\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug490403while() {
        this.runConformTestWithLibs(new String[]{"test/TestNullInt.java", "package test;\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic abstract class TestNullInt {\n\tpublic abstract boolean b();\n\n\tpublic void test(@NonNull Object[] keys, @NonNull String o) {\n\t\twhile (b()) {\n\t\t\tkeys[0] = o;\n\t\t\tkeys[1] = b() ? o : o;\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug490403negative() {
        this.runNegativeTestWithLibs(new String[]{"test/TestNullInt.java", "package test;\nimport org.eclipse.jdt.annotation.*;\n\npublic abstract class TestNullInt {\n\tpublic abstract boolean b();\n\n\tpublic void warning(@NonNull Object[] keys, String o) {\n\t\twhile (b()) {\n\t\t\tkeys[0] = o;\n\t\t\tkeys[1] = b() ? o : \"\";\n\t\t}\n\t}\n\tpublic void error(@NonNull Object[] keys, @Nullable String o) {\n\t\twhile (b()) {\n\t\t\tkeys[0] = o;\n\t\t\tkeys[1] = b() ? \"\" : o;\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in test\\TestNullInt.java (at line 9)\n\tkeys[0] = o;\n\t          ^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull Object'\n----------\n2. WARNING in test\\TestNullInt.java (at line 10)\n\tkeys[1] = b() ? o : \"\";\n\t                ^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull Object'\n----------\n3. ERROR in test\\TestNullInt.java (at line 15)\n\tkeys[0] = o;\n\t          ^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable String'\n----------\n4. ERROR in test\\TestNullInt.java (at line 16)\n\tkeys[1] = b() ? \"\" : o;\n\t                     ^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testBug490403typeArgAnnotationMismatch() {
        this.runNegativeTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass Ref<T> {\n}\n\npublic abstract class Test {\n    abstract boolean b();\n\n    public void testAnnotationMismatch(@NonNull Ref<@Nullable String> x, @NonNull Ref<@NonNull String>[] keys) {\n        keys[0] = x;\n        while (b()) {\n            keys[0] = x;\n            keys[1] = b() ? keys[0] : x;\n        }\n    }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\Test.java (at line 13)\n\tkeys[0] = x;\n\t          ^\nNull type mismatch (type annotations): required '@NonNull Ref<@NonNull String>' but this expression has type '@NonNull Ref<@Nullable String>'\n----------\n2. ERROR in test\\Test.java (at line 15)\n\tkeys[0] = x;\n\t          ^\nNull type mismatch (type annotations): required '@NonNull Ref<@NonNull String>' but this expression has type '@NonNull Ref<@Nullable String>'\n----------\n3. ERROR in test\\Test.java (at line 16)\n\tkeys[1] = b() ? keys[0] : x;\n\t                          ^\nNull type mismatch (type annotations): required '@NonNull Ref<@NonNull String>' but this expression has type '@NonNull Ref<@Nullable String>'\n----------\n");
    }

    public void testBug499589() {
        this.runConformTestWithLibs(new String[]{"test/BogusWarning.java", "package test;\nimport static org.eclipse.jdt.annotation.DefaultLocation.ARRAY_CONTENTS;\nimport static org.eclipse.jdt.annotation.DefaultLocation.PARAMETER;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault({ PARAMETER, ARRAY_CONTENTS })\nclass BogusWarning {\n\tstatic void a(String[] array) {\n\t\tx(array[0]); // <----- bogus warning\n\t}\n\n\tstatic void x(String s) {\n\t\tSystem.out.println(s);\n\t}\n\n\tstatic void b(String[][] array) {\n\t\ty(array[0]); // <----- bogus warning\n\t}\n\n\tstatic void y(String[] s) {\n\t\tSystem.out.println(s[0]);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug499589multidim() {
        this.runNegativeTestWithLibs(new String[]{"test/BogusWarning.java", "package test;\nimport static org.eclipse.jdt.annotation.DefaultLocation.ARRAY_CONTENTS;\nimport static org.eclipse.jdt.annotation.DefaultLocation.PARAMETER;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault({ PARAMETER, ARRAY_CONTENTS })\nclass BogusWarning {\n\tstatic void foo(String[] @Nullable [] array) {\n\t\tx(array[0]);\n\t}\n\tstatic void x(String[] s) {\n\t\tSystem.out.println(s[0]);\n\t}\n\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\BogusWarning.java (at line 11)\n\tx(array[0]);\n\t  ^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[]' but this expression has type '@NonNull String @Nullable[]'\n----------\n");
    }

    public void testBug499589leafTypeNullable() {
        this.runNegativeTestWithLibs(new String[]{"test/BogusWarning.java", "package test;\nimport static org.eclipse.jdt.annotation.DefaultLocation.ARRAY_CONTENTS;\nimport static org.eclipse.jdt.annotation.DefaultLocation.PARAMETER;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault({ PARAMETER, ARRAY_CONTENTS })\nclass BogusWarning {\n\tstatic void foo(@Nullable String[] array) {\n\t\tx(array[0]);\n\t}\n\n\tstatic void x(String s) {\n\t\tSystem.out.println(s);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\BogusWarning.java (at line 11)\n\tx(array[0]);\n\t  ^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testBug499589qualified() {
        this.runConformTestWithLibs(new String[]{"test/BogusWarning.java", "package test;\nimport static org.eclipse.jdt.annotation.DefaultLocation.ARRAY_CONTENTS;\nimport static org.eclipse.jdt.annotation.DefaultLocation.PARAMETER;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault({ PARAMETER, ARRAY_CONTENTS })\nclass BogusWarning {\n\tstatic void foo(java.lang.String[] array) {\n\t\tx(array[0]);\n\t}\n\n\tstatic void x(String s) {\n\t\tSystem.out.println(s);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug499589qualified_leafTypeNullable() {
        this.runNegativeTestWithLibs(new String[]{"test/BogusWarning.java", "package test;\nimport static org.eclipse.jdt.annotation.DefaultLocation.ARRAY_CONTENTS;\nimport static org.eclipse.jdt.annotation.DefaultLocation.PARAMETER;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault({ PARAMETER, ARRAY_CONTENTS })\nclass BogusWarning {\n\tstatic void foo(java.lang.@Nullable String[] array) {\n\t\tx(array[0]);\n\t}\n\n\tstatic void x(String s) {\n\t\tSystem.out.println(s);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\BogusWarning.java (at line 11)\n\tx(array[0]);\n\t  ^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testBug499589qualified_multidim() {
        this.runNegativeTestWithLibs(new String[]{"test/BogusWarning.java", "package test;\nimport static org.eclipse.jdt.annotation.DefaultLocation.ARRAY_CONTENTS;\nimport static org.eclipse.jdt.annotation.DefaultLocation.PARAMETER;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault({ PARAMETER, ARRAY_CONTENTS })\nclass BogusWarning {\n\tstatic void foo(java.lang.String[] @Nullable [] array) {\n\t\tx(array[0]);\n\t}\n\tstatic void x(java.lang.String[] s) {\n\t\tSystem.out.println(s[0]);\n\t}\n\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\BogusWarning.java (at line 11)\n\tx(array[0]);\n\t  ^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[]' but this expression has type '@NonNull String @Nullable[]'\n----------\n");
    }

    public void testBug499589STB() {
        this.runNegativeTestWithLibs(new String[]{"test/Ref.java", "package test;\n\npublic class Ref<T> {\n\tT get() {\n\t\tthrow new RuntimeException();\n\t}\n}\n", "test/X.java", "package test;\n\nimport static org.eclipse.jdt.annotation.DefaultLocation.*;\n\nimport org.eclipse.jdt.annotation.*;\n\n@SuppressWarnings({ \"unchecked\" })\n@NonNullByDefault({ FIELD, RETURN_TYPE, PARAMETER, ARRAY_CONTENTS, TYPE_ARGUMENT })\npublic abstract class X {\n\tpublic final String[][] field = {};\n\tpublic final @Nullable String[][] fieldWithNullable1 = {};\n\tpublic final String[] @Nullable [] fieldWithNullable2 = {};\n\n\tpublic final Ref<String[][]> list = new Ref<>();\n\tpublic final Ref<@Nullable String[][]> listWithNullable1 = new Ref<>();\n\tpublic final Ref<String[] @Nullable []> listWithNullable2 = new Ref<>();\n\n\tpublic abstract String[][] method();\n\tpublic abstract @Nullable String[][] methodWithNullable1();\n\tpublic abstract String[] @Nullable [] methodWithNullable2();\n\n\tpublic final Ref<String[][]>[][] genericField = new Ref[0][];\n\tpublic final @Nullable Ref<@Nullable String[][]>[][] genericFieldWithNullable1 = new Ref[0][];\n\tpublic final Ref<String[] @Nullable []>[] @Nullable [] genericFieldWithNullable2 = new Ref[0][];\n}\n\nclass SourceUsage {\n\tvoid check(@NonNull String @NonNull [] @NonNull [] s) {\n\t}\n\n\tvoid checkGeneric(@NonNull Ref<@NonNull String @NonNull [] @NonNull []> @NonNull [] @NonNull [] s) {\n\t}\n\n\tvoid f(X x) {\n\t\tcheck(x.field);\n\t\tcheck(x.fieldWithNullable1);\n\t\tcheck(x.fieldWithNullable2);\n\t\tcheck(x.list.get());\n\t\tcheck(x.listWithNullable1.get());\n\t\tcheck(x.listWithNullable2.get());\n\t\tcheck(x.method());\n\t\tcheck(x.methodWithNullable1());\n\t\tcheck(x.methodWithNullable2());\n\t\tcheckGeneric(x.genericField);\n\t\tcheckGeneric(x.genericFieldWithNullable1);\n\t\tcheckGeneric(x.genericFieldWithNullable2);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\X.java (at line 36)\n\tcheck(x.fieldWithNullable1);\n\t      ^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@Nullable String @NonNull[] @NonNull[]'\n----------\n2. ERROR in test\\X.java (at line 37)\n\tcheck(x.fieldWithNullable2);\n\t      ^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@NonNull String @NonNull[] @Nullable[]'\n----------\n3. ERROR in test\\X.java (at line 39)\n\tcheck(x.listWithNullable1.get());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@Nullable String @NonNull[] @NonNull[]'\n----------\n4. ERROR in test\\X.java (at line 40)\n\tcheck(x.listWithNullable2.get());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@NonNull String @NonNull[] @Nullable[]'\n----------\n5. ERROR in test\\X.java (at line 42)\n\tcheck(x.methodWithNullable1());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@Nullable String @NonNull[] @NonNull[]'\n----------\n6. ERROR in test\\X.java (at line 43)\n\tcheck(x.methodWithNullable2());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@NonNull String @NonNull[] @Nullable[]'\n----------\n7. ERROR in test\\X.java (at line 45)\n\tcheckGeneric(x.genericFieldWithNullable1);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Ref<@NonNull String @NonNull[] @NonNull[]> @NonNull[] @NonNull[]' but this expression has type '@Nullable Ref<@Nullable String @NonNull[] @NonNull[]> @NonNull[] @NonNull[]'\n----------\n8. ERROR in test\\X.java (at line 46)\n\tcheckGeneric(x.genericFieldWithNullable2);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Ref<@NonNull String @NonNull[] @NonNull[]> @NonNull[] @NonNull[]' but this expression has type '@NonNull Ref<@NonNull String @NonNull[] @Nullable[]> @NonNull[] @Nullable[]'\n----------\n");
    }

    public void testBug499589BTB() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.classLibraries = this.LIBS;
        runner.testFiles = new String[]{"test/Ref.java", "package test;\n\npublic class Ref<T> {\n\tT get() {\n\t\tthrow new RuntimeException();\n\t}\n}\n", "test/X.java", "package test;\n\nimport static org.eclipse.jdt.annotation.DefaultLocation.ARRAY_CONTENTS;\nimport static org.eclipse.jdt.annotation.DefaultLocation.FIELD;\nimport static org.eclipse.jdt.annotation.DefaultLocation.PARAMETER;\nimport static org.eclipse.jdt.annotation.DefaultLocation.RETURN_TYPE;\nimport static org.eclipse.jdt.annotation.DefaultLocation.TYPE_ARGUMENT;\n\nimport org.eclipse.jdt.annotation.*;\n\n@SuppressWarnings({ \"unchecked\" })\n@NonNullByDefault({ FIELD, RETURN_TYPE, PARAMETER, ARRAY_CONTENTS, TYPE_ARGUMENT })\npublic abstract class X {\n\tpublic final String[][] field = {};\n\tpublic final @Nullable String[][] fieldWithNullable1 = {};\n\tpublic final String[] @Nullable [] fieldWithNullable2 = {};\n\n\tpublic final Ref<String[][]> list = new Ref<>();\n\tpublic final Ref<@Nullable String[][]> listWithNullable1 = new Ref<>();\n\tpublic final Ref<String[] @Nullable []> listWithNullable2 = new Ref<>();\n\n\tpublic abstract String[][] method();\n\tpublic abstract @Nullable String[][] methodWithNullable1();\n\tpublic abstract String[] @Nullable [] methodWithNullable2();\n\n\tpublic final Ref<String[][]>[][] genericField = new Ref[0][];\n\tpublic final @Nullable Ref<@Nullable String[][]>[][] genericFieldWithNullable1 = new Ref[0][];\n\tpublic final Ref<String[] @Nullable []>[] @Nullable [] genericFieldWithNullable2 = new Ref[0][];\n}\n"};
        runner.javacTestOptions = new AbstractRegressionTest.JavacTestOptions.SuppressWarnings("rawtypes");
        runner.runConformTest();
        this.runNegativeTestWithLibs(new String[]{"test/BinaryUsage.java", "package test;\n\n\nimport org.eclipse.jdt.annotation.NonNull;\n\nclass BinaryUsage {\n\tvoid check(@NonNull String @NonNull [] @NonNull [] s) {\n\t}\n\n\tvoid checkGeneric(@NonNull Ref<@NonNull String @NonNull [] @NonNull []> @NonNull [] @NonNull [] s) {\n\t}\n\n\tvoid f(X x) {\n\t\tcheck(x.field);\n\t\tcheck(x.fieldWithNullable1);\n\t\tcheck(x.fieldWithNullable2);\n\t\tcheck(x.list.get());\n\t\tcheck(x.listWithNullable1.get());\n\t\tcheck(x.listWithNullable2.get());\n\t\tcheck(x.method());\n\t\tcheck(x.methodWithNullable1());\n\t\tcheck(x.methodWithNullable2());\n\t\tcheckGeneric(x.genericField);\n\t\tcheckGeneric(x.genericFieldWithNullable1);\n\t\tcheckGeneric(x.genericFieldWithNullable2);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\BinaryUsage.java (at line 15)\n\tcheck(x.fieldWithNullable1);\n\t      ^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@Nullable String @NonNull[] @NonNull[]'\n----------\n2. ERROR in test\\BinaryUsage.java (at line 16)\n\tcheck(x.fieldWithNullable2);\n\t      ^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@NonNull String @NonNull[] @Nullable[]'\n----------\n3. ERROR in test\\BinaryUsage.java (at line 18)\n\tcheck(x.listWithNullable1.get());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@Nullable String @NonNull[] @NonNull[]'\n----------\n4. ERROR in test\\BinaryUsage.java (at line 19)\n\tcheck(x.listWithNullable2.get());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@NonNull String @NonNull[] @Nullable[]'\n----------\n5. ERROR in test\\BinaryUsage.java (at line 21)\n\tcheck(x.methodWithNullable1());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@Nullable String @NonNull[] @NonNull[]'\n----------\n6. ERROR in test\\BinaryUsage.java (at line 22)\n\tcheck(x.methodWithNullable2());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[] @NonNull[]' but this expression has type '@NonNull String @NonNull[] @Nullable[]'\n----------\n7. ERROR in test\\BinaryUsage.java (at line 24)\n\tcheckGeneric(x.genericFieldWithNullable1);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Ref<@NonNull String @NonNull[] @NonNull[]> @NonNull[] @NonNull[]' but this expression has type '@Nullable Ref<@Nullable String @NonNull[] @NonNull[]> @NonNull[] @NonNull[]'\n----------\n8. ERROR in test\\BinaryUsage.java (at line 25)\n\tcheckGeneric(x.genericFieldWithNullable2);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Ref<@NonNull String @NonNull[] @NonNull[]> @NonNull[] @NonNull[]' but this expression has type '@NonNull Ref<@NonNull String @NonNull[] @Nullable[]> @NonNull[] @Nullable[]'\n----------\n");
    }

    public void testBug499589STBqualified() {
        this.runNegativeTestWithLibs(new String[]{"test/Ref.java", "package test;\n\npublic class Ref<T> {\n\tT get() {\n\t\tthrow new RuntimeException();\n\t}\n}\n", "test/A.java", "package test;\n\npublic class A {\n\tclass B {\n\t}\n}\n", "test/X.java", "package test;\n\nimport static org.eclipse.jdt.annotation.DefaultLocation.*;\n\nimport org.eclipse.jdt.annotation.*;\n\n@SuppressWarnings({ \"unchecked\" })\n@NonNullByDefault({ FIELD, RETURN_TYPE, PARAMETER, ARRAY_CONTENTS, TYPE_ARGUMENT })\npublic abstract class X {\n\tpublic final test.A.B[][] field = {};\n\tpublic final test.A.@Nullable B[][] fieldWithNullable1 = {};\n\tpublic final test.A.B[] @Nullable [] fieldWithNullable2 = {};\n\n\tpublic final test.Ref<test.A.B[][]> list = new Ref<>();\n\tpublic final test.Ref<test.A.@Nullable B[][]> listWithNullable1 = new Ref<>();\n\tpublic final test.Ref<test.A.B[] @Nullable []> listWithNullable2 = new Ref<>();\n\n\tpublic abstract test.A.B[][] method();\n\tpublic abstract test.A.@Nullable B[][] methodWithNullable1();\n\tpublic abstract test.A.B[] @Nullable [] methodWithNullable2();\n\n\tpublic final test.Ref<test.A.B[][]>[][] genericField = new Ref[0][];\n\tpublic final test.@Nullable Ref<test.A.@Nullable B[][]>[][] genericFieldWithNullable1 = new Ref[0][];;\n\tpublic final test.Ref<test.A.B[] @Nullable []>[] @Nullable[] genericFieldWithNullable2 = new Ref[0][];;\n}\n\nclass SourceUsage {\n\tvoid check(test.A.@NonNull B @NonNull [] @NonNull [] s) {\n\t}\n\tvoid checkGeneric(test.@NonNull Ref<test.A.@NonNull B @NonNull [] @NonNull []> @NonNull [] @NonNull [] s) {\n\t}\n\n\tvoid f(X x) {\n\t\tcheck(x.field);\n\t\tcheck(x.fieldWithNullable1);\n\t\tcheck(x.fieldWithNullable2);\n\t\tcheck(x.list.get());\n\t\tcheck(x.listWithNullable1.get());\n\t\tcheck(x.listWithNullable2.get());\n\t\tcheck(x.method());\n\t\tcheck(x.methodWithNullable1());\n\t\tcheck(x.methodWithNullable2());\n\t\tcheckGeneric(x.genericField);\n\t\tcheckGeneric(x.genericFieldWithNullable1);\n\t\tcheckGeneric(x.genericFieldWithNullable2);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\X.java (at line 35)\n\tcheck(x.fieldWithNullable1);\n\t      ^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@Nullable B @NonNull[] @NonNull[]'\n----------\n2. ERROR in test\\X.java (at line 36)\n\tcheck(x.fieldWithNullable2);\n\t      ^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@NonNull B @NonNull[] @Nullable[]'\n----------\n3. ERROR in test\\X.java (at line 38)\n\tcheck(x.listWithNullable1.get());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@Nullable B @NonNull[] @NonNull[]'\n----------\n4. ERROR in test\\X.java (at line 39)\n\tcheck(x.listWithNullable2.get());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@NonNull B @NonNull[] @Nullable[]'\n----------\n5. ERROR in test\\X.java (at line 41)\n\tcheck(x.methodWithNullable1());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@Nullable B @NonNull[] @NonNull[]'\n----------\n6. ERROR in test\\X.java (at line 42)\n\tcheck(x.methodWithNullable2());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@NonNull B @NonNull[] @Nullable[]'\n----------\n7. ERROR in test\\X.java (at line 44)\n\tcheckGeneric(x.genericFieldWithNullable1);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Ref<A.@NonNull B @NonNull[] @NonNull[]> @NonNull[] @NonNull[]' but this expression has type '@Nullable Ref<A.@Nullable B @NonNull[] @NonNull[]> @NonNull[] @NonNull[]'\n----------\n8. ERROR in test\\X.java (at line 45)\n\tcheckGeneric(x.genericFieldWithNullable2);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Ref<A.@NonNull B @NonNull[] @NonNull[]> @NonNull[] @NonNull[]' but this expression has type '@NonNull Ref<A.@NonNull B @NonNull[] @Nullable[]> @NonNull[] @Nullable[]'\n----------\n");
    }

    public void testBug499589BTBqualified() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.classLibraries = this.LIBS;
        runner.testFiles = new String[]{"test/Ref.java", "package test;\n\npublic class Ref<T> {\n\tT get() {\n\t\tthrow new RuntimeException();\n\t}\n}\n", "test/A.java", "package test;\n\npublic class A {\n\tclass B {\n\t}\n}\n", "test/X.java", "package test;\n\nimport static org.eclipse.jdt.annotation.DefaultLocation.*;\n\nimport org.eclipse.jdt.annotation.*;\n\n@SuppressWarnings({ \"unchecked\" })\n@NonNullByDefault({ FIELD, RETURN_TYPE, PARAMETER, ARRAY_CONTENTS, TYPE_ARGUMENT })\npublic abstract class X {\n\tpublic final test.A.B[][] field = {};\n\tpublic final test.A.@Nullable B[][] fieldWithNullable1 = {};\n\tpublic final test.A.B[] @Nullable [] fieldWithNullable2 = {};\n\n\tpublic final test.Ref<test.A.B[][]> list = new Ref<>();\n\tpublic final test.Ref<test.A.@Nullable B[][]> listWithNullable1 = new Ref<>();\n\tpublic final test.Ref<test.A.B[] @Nullable []> listWithNullable2 = new Ref<>();\n\n\tpublic abstract test.A.B[][] method();\n\tpublic abstract test.A.@Nullable B[][] methodWithNullable1();\n\tpublic abstract test.A.B[] @Nullable [] methodWithNullable2();\n\n\tpublic final test.Ref<test.A.B[][]>[][] genericField = new Ref[0][];\n\tpublic final test.@Nullable Ref<test.A.@Nullable B[][]>[][] genericFieldWithNullable1 = new Ref[0][];;\n\tpublic final test.Ref<test.A.B[] @Nullable []>[] @Nullable[] genericFieldWithNullable2 = new Ref[0][];;\n}\n"};
        runner.javacTestOptions = new AbstractRegressionTest.JavacTestOptions.SuppressWarnings("rawtypes");
        runner.runConformTest();
        this.runNegativeTestWithLibs(new String[]{"test/BinaryUsage.java", "package test;\n\n\nimport org.eclipse.jdt.annotation.NonNull;\n\nclass BinaryUsage {\n\tvoid check(test.A.@NonNull B @NonNull [] @NonNull [] s) {\n\t}\n\tvoid checkGeneric(test.@NonNull Ref<test.A.@NonNull B @NonNull [] @NonNull []> @NonNull [] @NonNull [] s) {\n\t}\n\n\tvoid f(X x) {\n\t\tcheck(x.field);\n\t\tcheck(x.fieldWithNullable1);\n\t\tcheck(x.fieldWithNullable2);\n\t\tcheck(x.list.get());\n\t\tcheck(x.listWithNullable1.get());\n\t\tcheck(x.listWithNullable2.get());\n\t\tcheck(x.method());\n\t\tcheck(x.methodWithNullable1());\n\t\tcheck(x.methodWithNullable2());\n\t\tcheckGeneric(x.genericField);\n\t\tcheckGeneric(x.genericFieldWithNullable1);\n\t\tcheckGeneric(x.genericFieldWithNullable2);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\BinaryUsage.java (at line 14)\n\tcheck(x.fieldWithNullable1);\n\t      ^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@Nullable B @NonNull[] @NonNull[]'\n----------\n2. ERROR in test\\BinaryUsage.java (at line 15)\n\tcheck(x.fieldWithNullable2);\n\t      ^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@NonNull B @NonNull[] @Nullable[]'\n----------\n3. ERROR in test\\BinaryUsage.java (at line 17)\n\tcheck(x.listWithNullable1.get());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@Nullable B @NonNull[] @NonNull[]'\n----------\n4. ERROR in test\\BinaryUsage.java (at line 18)\n\tcheck(x.listWithNullable2.get());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@NonNull B @NonNull[] @Nullable[]'\n----------\n5. ERROR in test\\BinaryUsage.java (at line 20)\n\tcheck(x.methodWithNullable1());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@Nullable B @NonNull[] @NonNull[]'\n----------\n6. ERROR in test\\BinaryUsage.java (at line 21)\n\tcheck(x.methodWithNullable2());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'A.@NonNull B @NonNull[] @NonNull[]' but this expression has type 'A.@NonNull B @NonNull[] @Nullable[]'\n----------\n7. ERROR in test\\BinaryUsage.java (at line 23)\n\tcheckGeneric(x.genericFieldWithNullable1);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Ref<A.@NonNull B @NonNull[] @NonNull[]> @NonNull[] @NonNull[]' but this expression has type '@Nullable Ref<A.@Nullable B @NonNull[] @NonNull[]> @NonNull[] @NonNull[]'\n----------\n8. ERROR in test\\BinaryUsage.java (at line 24)\n\tcheckGeneric(x.genericFieldWithNullable2);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Ref<A.@NonNull B @NonNull[] @NonNull[]> @NonNull[] @NonNull[]' but this expression has type '@NonNull Ref<A.@NonNull B @NonNull[] @Nullable[]> @NonNull[] @Nullable[]'\n----------\n");
    }

    public void testBug499589arrayAllocation() {
        this.runNegativeTestWithLibs(new String[]{"test/ArrayAllocation.java", "package test;\n\nimport static org.eclipse.jdt.annotation.DefaultLocation.ARRAY_CONTENTS;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault({ ARRAY_CONTENTS })\npublic class ArrayAllocation {\n\tpublic Integer[] x1 = { 1, 2, 3, null };\n\tpublic Integer[] x2 = new Integer[] { 1, 2, 3 };\n\tpublic Integer[] x3 = new Integer[] { 1, 2, 3, null };\n\tpublic Integer[] x4 = new Integer[3];\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\ArrayAllocation.java (at line 9)\n\tpublic Integer[] x1 = { 1, 2, 3, null };\n\t                                 ^^^^\nNull type mismatch: required '@NonNull Integer' but the provided value is null\n----------\n2. ERROR in test\\ArrayAllocation.java (at line 11)\n\tpublic Integer[] x3 = new Integer[] { 1, 2, 3, null };\n\t                                               ^^^^\nNull type mismatch: required '@NonNull Integer' but the provided value is null\n----------\n3. WARNING in test\\ArrayAllocation.java (at line 12)\n\tpublic Integer[] x4 = new Integer[3];\n\t                      ^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Integer[]' needs unchecked conversion to conform to '@NonNull Integer []'\n----------\n");
    }

    public void testBug499589generics() {
        this.runNegativeTestWithLibs(new String[]{"test/Methods.java", "package test;\n\nimport org.eclipse.jdt.annotation.DefaultLocation;\nimport org.eclipse.jdt.annotation.NonNull;\n\n@org.eclipse.jdt.annotation.NonNullByDefault({ DefaultLocation.TYPE_ARGUMENT, DefaultLocation.ARRAY_CONTENTS })\npublic class Methods {\n\tstatic interface List<T> {\n\t\tT get(int i);\n\t}\n\n\tpublic static List<String> f0(List<String> list) {\n\t\t@NonNull\n\t\tObject o = list.get(0);\n\t\treturn list;\n\t}\n\n\tpublic static String[] f1(String[] array) {\n\t\t@NonNull\n\t\tObject o = array[0];\n\t\treturn array;\n\t}\n\n\tpublic static <T> List<T> g0(List<T> list) {\n\t\t@NonNull\n\t\tObject o = list.get(0); // problem\n\t\treturn list;\n\t}\n\n\tpublic static <T> T[] g1(T[] array) {\n\t\t@NonNull\n\t\tObject o = array[0]; // problem\n\t\treturn array;\n\t}\n\n\tpublic static <@NonNull T> List<@NonNull T> h0(List<T> list) {\n\t\t@NonNull\n\t\tObject o = list.get(0);\n\t\treturn list;\n\t}\n\n\tpublic static <@NonNull T> @NonNull T[] h1(T[] array) {\n\t\t@NonNull\n\t\tObject o = array[0];\n\t\treturn array;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\Methods.java (at line 26)\n\tObject o = list.get(0); // problem\n\t           ^^^^^^^^^^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in test\\Methods.java (at line 32)\n\tObject o = array[0]; // problem\n\t           ^^^^^^^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug511723() {
        this.runNegativeTestWithLibs(new String[]{"test/ArrayVsList.java", "package test;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class ArrayVsList {\n\tstatic interface List<T> {\n\t\tT get(int i);\n\t}\n\tpublic static <T> void f(List<T> list) {\n\t\t@NonNull\n\t\tObject o = list.get(0); // problem\n\t\to.hashCode();\n\t}\n\n\tpublic static <T> void g(T[] array) {\n\t\t@NonNull\n\t\tObject o = array[0]; // problem\n\t\to.hashCode();\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\ArrayVsList.java (at line 11)\n\tObject o = list.get(0); // problem\n\t           ^^^^^^^^^^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n2. ERROR in test\\ArrayVsList.java (at line 17)\n\tObject o = array[0]; // problem\n\t           ^^^^^^^^\nNull type safety: required '@NonNull' but this expression has type 'T', a free type variable that may represent a '@Nullable' type\n----------\n");
    }

    public void testBug498084() {
        this.runConformTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport java.util.HashMap;\nimport java.util.Map;\nimport java.util.function.Function;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Test {\n\n\tprotected static final <K, V> V cache(final Map<K, V> cache, final V value, final Function<V, K> keyFunction) {\n\t\tcache.put(keyFunction.apply(value), value);\n\t\treturn value;\n\t}\n\n\tpublic static final void main(final String[] args) {\n\t\tMap<Integer, String> cache = new HashMap<>();\n\t\tcache(cache, \"test\", String::length); // Warning: Null type safety at\n\t\t\t\t\t\t\t\t\t\t\t// method return type: Method\n\t\t\t\t\t\t\t\t\t\t\t// descriptor\n\t\t\t\t\t\t\t\t\t\t\t// Function<String,Integer>.apply(String)\n\t\t\t\t\t\t\t\t\t\t\t// promises '@NonNull Integer'\n\t\t\t\t\t\t\t\t\t\t\t// but referenced method\n\t\t\t\t\t\t\t\t\t\t\t// provides 'int'\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug498084b() {
        this.runNegativeTestWithLibs(new String[]{"test/Test2.java", "package test;\n\nimport java.util.function.Consumer;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class Test2 {\n\tstatic void f(int i) {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tConsumer<@Nullable Integer> sam = Test2::f;\n\t\tsam.accept(null); // <- NullPointerExpection when run\n\t\tConsumer<Integer> sam2 = Test2::f;\n\t\tsam2.accept(null); // variation: unchecked \n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\Test2.java (at line 12)\n\tConsumer<@Nullable Integer> sam = Test2::f;\n\t                                  ^^^^^^^^\nNull type mismatch at parameter 1: required 'int' but provided '@Nullable Integer' via method descriptor Consumer<Integer>.accept(Integer)\n----------\n2. WARNING in test\\Test2.java (at line 14)\n\tConsumer<Integer> sam2 = Test2::f;\n\t                         ^^^^^^^^\nNull type safety: parameter 1 provided via method descriptor Consumer<Integer>.accept(Integer) needs unchecked conversion to conform to 'int'\n----------\n");
    }

    public void testBug513495() {
        this.runNegativeTestWithLibs(new String[]{"test/Test3.java", "package test;\n\nimport java.util.function.Function;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class Test3 {\n\tpublic static void main(String[] args) {\n\t\tFunction<@Nullable Integer, Object> sam = Integer::intValue;\n\t\tsam.apply(null); // <- NullPointerExpection\n\t\tFunction<Integer, Object> sam2 = Integer::intValue;\n\t\tsam2.apply(null); // variation: unchecked, so intentionally no warning reported, but would give NPE too \n\t}\n\tvoid wildcards(Class<?>[] params) { // unchecked case with wildcards\n\t\tjava.util.Arrays.stream(params).map(Class::getName).toArray(String[]::new);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\Test3.java (at line 9)\n\tFunction<@Nullable Integer, Object> sam = Integer::intValue;\n\t                                          ^^^^^^^^^^^^^^^^^\nNull type mismatch at parameter 'this': required '@NonNull Integer' but provided '@Nullable Integer' via method descriptor Function<Integer,Object>.apply(Integer)\n----------\n");
    }

    public void testBug513855() {
        this.runConformTestWithLibs(new String[]{"test1/X.java", "package test1;\n\nimport java.math.BigDecimal;\n\nimport org.eclipse.jdt.annotation.*;\n\n@NonNullByDefault\npublic class X {\n\tinterface Sink<T extends Number> {\n\t\tvoid receive(T t);\n\t}\n\n\tinterface Source<U extends BigDecimal> {\n\t\tU get();\n\t}\n\n\tvoid nn(Object x) {\n\t}\n\n\tvoid f(Source<?> source) {\n\t\tnn(source.get());\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug513855lambda() {
        this.runConformTestWithLibs(new String[]{"test1/Lambda3.java", "package test1;\n\nimport java.math.BigDecimal;\n\nimport org.eclipse.jdt.annotation.*;\n\n@NonNullByDefault\npublic class Lambda3 {\n\tinterface Sink<T extends Number> {\n\t\tvoid receive(T t);\n\t}\n\n\tinterface Source<U extends BigDecimal> {\n\t\tvoid sendTo(Sink<? super U> c);\n\t}\n\n\tvoid f(Source<?> source) {\n\t\tsource.sendTo(a -> a.scale());\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug514091() {
        this.runConformTestWithLibs(new String[]{"test1/SAM.java", "package test1;\n\n@org.eclipse.jdt.annotation.NonNullByDefault\ninterface SAM<A> {\n\tvoid f(A[] a);\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"test1/LambdaNN.java", "package test1;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic class LambdaNN {\n\tvoid g1() {\n\t\tSAM<? super Number> sam = (Number @NonNull [] a) -> {};\n\t\tsam.f(new Number[0]);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug514570() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runConformTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class Test {\n\t/**\n\t * {@link #bug()}\n\t */\n\t<E, T extends List<@NonNull E>> void bug() {\n\t}\n}\n"}, compilerOptions, "");
    }

    public void testBug514977() {
        this.runNegativeTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport org.eclipse.jdt.annotation.DefaultLocation;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\npublic class Test {\n\tstatic void nn(@NonNull Object i) {\n\t\ti.hashCode();\n\t}\n\n\tstatic void f(@NonNull Integer @NonNull... args) {\n\t\tnn(args);\n\t\tfor (Integer s : args) {\n\t\t\tnn(s);\n\t\t}\n\t}\n\n\t@NonNullByDefault({ DefaultLocation.ARRAY_CONTENTS, DefaultLocation.PARAMETER })\n\tstatic void g(Integer... args) {\n\t\tnn(args);\n\t\tfor (Integer s : args) {\n\t\t\tnn(s);\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tInteger i = args.length == 0 ? null : 1;\n\t\tInteger[] array = i == null ? null : new Integer[] {i};\n\t\tf(array);\n\t\tf(i);\n\t\tf(1, i);\n\t\tg(array);\n\t\tg(i);\n\t\tg(1, i);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in test\\Test.java (at line 30)\n\tf(array);\n\t  ^^^^^\nNull type mismatch: required '@NonNull Integer @NonNull[]' but the provided value is inferred as @Nullable\n----------\n2. ERROR in test\\Test.java (at line 31)\n\tf(i);\n\t  ^\nNull type mismatch: required '@NonNull Integer' but the provided value is inferred as @Nullable\n----------\n3. ERROR in test\\Test.java (at line 32)\n\tf(1, i);\n\t     ^\nNull type mismatch: required '@NonNull Integer' but the provided value is inferred as @Nullable\n----------\n4. ERROR in test\\Test.java (at line 33)\n\tg(array);\n\t  ^^^^^\nNull type mismatch: required '@NonNull Integer @NonNull[]' but the provided value is inferred as @Nullable\n----------\n5. ERROR in test\\Test.java (at line 34)\n\tg(i);\n\t  ^\nNull type mismatch: required '@NonNull Integer' but the provided value is inferred as @Nullable\n----------\n6. ERROR in test\\Test.java (at line 35)\n\tg(1, i);\n\t     ^\nNull type mismatch: required '@NonNull Integer' but the provided value is inferred as @Nullable\n----------\n");
    }

    public void testBug515292() {
        this.runConformTestWithLibs(new String[]{"test/BoundedByFinal.java", "package test;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic abstract class BoundedByFinal {\n\tabstract <T extends @Nullable String> void setSelection(T[] selectedObjects);\n\n\tabstract @NonNull String @NonNull [] toArray1();\n\n\tabstract @Nullable String @NonNull [] toArray2();\n\n\tvoid test() {\n\t\tsetSelection(toArray1());\n\t\tsetSelection(toArray2());\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug526555() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "warning");
        this.runWarningTestWithLibs(true, new String[]{"ztest/OverrideTest.java", "package ztest;\n\nimport static org.eclipse.jdt.annotation.DefaultLocation.ARRAY_CONTENTS;\nimport static org.eclipse.jdt.annotation.DefaultLocation.FIELD;\nimport static org.eclipse.jdt.annotation.DefaultLocation.PARAMETER;\nimport static org.eclipse.jdt.annotation.DefaultLocation.RETURN_TYPE;\nimport static org.eclipse.jdt.annotation.DefaultLocation.TYPE_ARGUMENT;\nimport static org.eclipse.jdt.annotation.DefaultLocation.TYPE_BOUND;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\ninterface X509TrustManager {\n\tvoid checkClientTrusted(String[] arg0, String arg1);\n\n}\n\n@NonNullByDefault({ PARAMETER, RETURN_TYPE, FIELD, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS })\npublic class OverrideTest implements X509TrustManager {\n\t@Override\n\tpublic void checkClientTrusted(String @Nullable [] arg0, @Nullable String arg1) {\n\t}\n}"}, customOptions, "----------\n1. WARNING in ztest\\OverrideTest.java (at line 21)\n\tpublic void checkClientTrusted(String @Nullable [] arg0, @Nullable String arg1) {\n\t                               ^^^^^^^^^^^^^^^^^^^\nIllegal redefinition of parameter arg0, inherited method from X509TrustManager declares this parameter as 'String[]' (mismatching null constraints)\n----------\n");
    }

    public void testBug530913() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "annotation.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "annotation.NonNull");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "annotation.NonNullByDefault");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runConformTestWithLibs(new String[]{"annotation/DefaultLocation.java", "package annotation;\n\npublic enum DefaultLocation {\n    PARAMETER, RETURN_TYPE, FIELD, TYPE_PARAMETER, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS\n}\n", "annotation/NonNull.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface NonNull {\n}\n", "annotation/NonNullByDefault.java", "package annotation;\n\nimport static annotation.DefaultLocation.*;\n \npublic @interface NonNullByDefault {\n\tDefaultLocation[] value() default { PARAMETER, RETURN_TYPE, FIELD, TYPE_BOUND, TYPE_ARGUMENT };\n}\n", "annotation/Nullable.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface Nullable {\n}\n"}, customOptions, "");
        this.runConformTestWithLibs(false, new String[]{"nnbd_test2/Data.java", "package nnbd_test2;\n\nimport java.util.function.Supplier;\n\nimport annotation.DefaultLocation;\nimport annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Data {\n    public void f(@NonNullByDefault({}) String s1, String s2) {\n        s1.equals(s2);\n    }\n\n    public void g(String s1, @NonNullByDefault({}) String s2) {\n        s1.equals(s2);\n    }\n    \n    @NonNullByDefault({})\n    public void h(@NonNullByDefault({ DefaultLocation.PARAMETER }) Supplier<String> s1, @NonNullByDefault Supplier<String> s2) {\n        s1.equals(s2);\n    }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"nnbd_test1/Test.java", "package nnbd_test1;\n\nimport java.util.function.Supplier;\n\nimport annotation.DefaultLocation;\nimport annotation.NonNullByDefault;\nimport nnbd_test2.Data;\n\n@NonNullByDefault\npublic class Test {\n    void f(@NonNullByDefault({}) String s1, String s2) {\n        if (s1 == null) {\n            System.out.println(\"s is null\");\n        }\n        if (s2 == null) { // warning expected\n            System.out.println(\"s2 is null\");\n        }\n    }\n\n    void g(String s1, @NonNullByDefault({}) String s2) {\n        if (s1 == null) { // warning expected\n            System.out.println(\"s is null\");\n        }\n        if (s2 == null) {\n            System.out.println(\"s2 is null\");\n        }\n    }\n\n    @NonNullByDefault({})\n    void h(@NonNullByDefault({ DefaultLocation.PARAMETER }) Supplier<String> s1, @NonNullByDefault Supplier<String> s2) {\n        if (s1 == null) { // warning expected\n            System.out.println(\"s is null\");\n            return;\n        }\n        if (s2 == null) { // warning expected\n            System.out.println(\"s2 is null\");\n            return;\n        }\n        if (s1.get() == null) {\n            System.out.println(\"s is null\");\n        }\n        if (s2.get() == null) { // warning expected\n            System.out.println(\"s2 is null\");\n        }\n    }\n\n    void checkInvocation() {\n        Test d = new Test();\n        d.f(null, null); // warning on the second null expected\n        d.g(null, null); // warning on the first null expected\n    }\n\n    void checkBTBInvocation() {\n        Data d = new Data();\n        d.f(null, null); // warning on the second null expected\n        d.g(null, null); // warning on the first null expected\n    }\n\n    void checkInheritance() {\n        Test t = new Test() {\n            @Override\n            void f(String s1, String s2) { // warning on the first parameter expected\n                super.f(null, null); // warning on the second null expected\n            }\n\n            @Override\n            void g(String s1, String s2) { // warning on the second parameter expected\n                super.g(null, null); // warning on the first null expected\n            }\n\n            @Override\n            void h(Supplier<String> s1, Supplier<String> s2) { // warning on the first parameter expected\n            }\n        };\n    }\n\n    void checkBTBInheritance() {\n        Data d = new Data() {\n            @Override\n            public void f(String s1, String s2) { // warning on the first parameter expected\n                super.f(null, null); // warning on the second null expected\n            }\n\n            @Override\n            public void g(String s1, String s2) { // warning on the second parameter expected\n                super.g(null, null); // warning on the first null expected\n            }\n\n            @Override\n            public void h(Supplier<String> s1, Supplier<String> s2) { // warning on the first parameter expected\n            }\n        };\n    }\n}\n"}, customOptions, "----------\n1. ERROR in nnbd_test1\\Test.java (at line 15)\n\tif (s2 == null) { // warning expected\n\t    ^^\nRedundant null check: comparing '@NonNull String' against null\n----------\n2. ERROR in nnbd_test1\\Test.java (at line 21)\n\tif (s1 == null) { // warning expected\n\t    ^^\nRedundant null check: comparing '@NonNull String' against null\n----------\n3. ERROR in nnbd_test1\\Test.java (at line 31)\n\tif (s1 == null) { // warning expected\n\t    ^^\nRedundant null check: comparing '@NonNull Supplier<String>' against null\n----------\n4. ERROR in nnbd_test1\\Test.java (at line 35)\n\tif (s2 == null) { // warning expected\n\t    ^^\nRedundant null check: comparing '@NonNull Supplier<@NonNull String>' against null\n----------\n5. ERROR in nnbd_test1\\Test.java (at line 42)\n\tif (s2.get() == null) { // warning expected\n\t    ^^^^^^^^\nRedundant null check: comparing '@NonNull String' against null\n----------\n6. ERROR in nnbd_test1\\Test.java (at line 49)\n\td.f(null, null); // warning on the second null expected\n\t          ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n7. ERROR in nnbd_test1\\Test.java (at line 50)\n\td.g(null, null); // warning on the first null expected\n\t    ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n8. ERROR in nnbd_test1\\Test.java (at line 55)\n\td.f(null, null); // warning on the second null expected\n\t          ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n9. ERROR in nnbd_test1\\Test.java (at line 56)\n\td.g(null, null); // warning on the first null expected\n\t    ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n10. ERROR in nnbd_test1\\Test.java (at line 62)\n\tvoid f(String s1, String s2) { // warning on the first parameter expected\n\t       ^^^^^^\nIllegal redefinition of parameter s1, inherited method from Test does not constrain this parameter\n----------\n11. ERROR in nnbd_test1\\Test.java (at line 63)\n\tsuper.f(null, null); // warning on the second null expected\n\t              ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n12. ERROR in nnbd_test1\\Test.java (at line 67)\n\tvoid g(String s1, String s2) { // warning on the second parameter expected\n\t                  ^^^^^^\nIllegal redefinition of parameter s2, inherited method from Test does not constrain this parameter\n----------\n13. ERROR in nnbd_test1\\Test.java (at line 68)\n\tsuper.g(null, null); // warning on the first null expected\n\t        ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n14. ERROR in nnbd_test1\\Test.java (at line 72)\n\tvoid h(Supplier<String> s1, Supplier<String> s2) { // warning on the first parameter expected\n\t       ^^^^^^^^\nIllegal redefinition of parameter s1, inherited method from Test declares this parameter as '@NonNull Supplier<String>' (mismatching null constraints)\n----------\n15. ERROR in nnbd_test1\\Test.java (at line 80)\n\tpublic void f(String s1, String s2) { // warning on the first parameter expected\n\t              ^^^^^^\nIllegal redefinition of parameter s1, inherited method from Data does not constrain this parameter\n----------\n16. ERROR in nnbd_test1\\Test.java (at line 81)\n\tsuper.f(null, null); // warning on the second null expected\n\t              ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n17. ERROR in nnbd_test1\\Test.java (at line 85)\n\tpublic void g(String s1, String s2) { // warning on the second parameter expected\n\t                         ^^^^^^\nIllegal redefinition of parameter s2, inherited method from Data does not constrain this parameter\n----------\n18. ERROR in nnbd_test1\\Test.java (at line 86)\n\tsuper.g(null, null); // warning on the first null expected\n\t        ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n19. ERROR in nnbd_test1\\Test.java (at line 90)\n\tpublic void h(Supplier<String> s1, Supplier<String> s2) { // warning on the first parameter expected\n\t              ^^^^^^^^\nIllegal redefinition of parameter s1, inherited method from Data declares this parameter as '@NonNull Supplier<String>' (mismatching null constraints)\n----------\n");
    }

    public void testBug530913b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "annotation.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "annotation.NonNull");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "annotation.NonNullByDefault");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary", "annotation.NNBDField,annotation.NNBDParam,annotation.NNBDReturn,annotation.NNBDTypeArg,annotation.NNBDTypeBound");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.runConformTestWithLibs(new String[]{"annotation/DefaultLocation.java", "package annotation;\n\npublic enum DefaultLocation {\n    PARAMETER, RETURN_TYPE, FIELD, TYPE_PARAMETER, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS\n}\n", "annotation/NonNull.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface NonNull {\n}\n", "annotation/NonNullByDefault.java", "package annotation;\n\nimport static annotation.DefaultLocation.FIELD;\nimport static annotation.DefaultLocation.PARAMETER;\nimport static annotation.DefaultLocation.RETURN_TYPE;\nimport static annotation.DefaultLocation.TYPE_ARGUMENT;\nimport static annotation.DefaultLocation.TYPE_BOUND;\n \npublic @interface NonNullByDefault {\n    DefaultLocation[] value() default { PARAMETER, RETURN_TYPE, FIELD, TYPE_BOUND, TYPE_ARGUMENT };\n}\n", "annotation/Nullable.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface Nullable {\n}\n"}, customOptions, "");
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.classLibraries = this.LIBS;
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"test/X.java", "package test;\n\nimport annotation.*;\n\ninterface C<T1, T2> {\n}\n\nabstract class X {\n    @NonNullByDefault(DefaultLocation.RETURN_TYPE) abstract void f2(@NonNullByDefault C<Object, ? extends Number> p1);\n}\n"};
        runner.customOptions = customOptions;
        runner.javacTestOptions = new AbstractRegressionTest.JavacTestOptions.SuppressWarnings("auxiliaryclass");
        runner.runConformTest();
        runner.testFiles = new String[]{"test/ExplicitNonNull.java", "package test;\n\nimport annotation.*;\n\n\nclass ExplicitNonNull extends X {\n    void f2(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1) {\n    }\n}\n"};
        runner.runConformTest();
    }

    public void testBug530971() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "annotation.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "annotation.NonNull");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "annotation.NonNullByDefault");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary", "annotation.NNBDField,annotation.NNBDParam,annotation.NNBDReturn,annotation.NNBDTypeArg,annotation.NNBDTypeBound");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.runConformTestWithLibs(new String[]{"annotation/DefaultLocation.java", "package annotation;\n\npublic enum DefaultLocation {\n    PARAMETER, RETURN_TYPE, FIELD, TYPE_PARAMETER, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS\n}\n", "annotation/NNBDField.java", "package annotation;\n\nimport static annotation.DefaultLocation.FIELD;\n \npublic @interface NNBDField {\n\tDefaultLocation[] value() default { FIELD };\n}\n", "annotation/NNBDParam.java", "package annotation;\n\nimport static annotation.DefaultLocation.PARAMETER;\n\npublic @interface NNBDParam {\n    DefaultLocation[] value() default { PARAMETER };\n}\n", "annotation/NNBDReturn.java", "package annotation;\n\nimport static annotation.DefaultLocation.RETURN_TYPE;\n\npublic @interface NNBDReturn {\n    DefaultLocation[] value() default { RETURN_TYPE };\n}\n", "annotation/NNBDTypeArg.java", "package annotation;\n\nimport static annotation.DefaultLocation.TYPE_ARGUMENT;\n\npublic @interface NNBDTypeArg {\n    DefaultLocation[] value() default { TYPE_ARGUMENT };\n}\n", "annotation/NNBDTypeBound.java", "package annotation;\n\nimport static annotation.DefaultLocation.TYPE_BOUND;\n\npublic @interface NNBDTypeBound {\n    DefaultLocation[] value() default { TYPE_BOUND };\n}\n", "annotation/NonNull.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface NonNull {\n}\n", "annotation/NonNullByDefault.java", "package annotation;\n\nimport static annotation.DefaultLocation.FIELD;\nimport static annotation.DefaultLocation.PARAMETER;\nimport static annotation.DefaultLocation.RETURN_TYPE;\nimport static annotation.DefaultLocation.TYPE_ARGUMENT;\nimport static annotation.DefaultLocation.TYPE_BOUND;\n \npublic @interface NonNullByDefault {\n    DefaultLocation[] value() default { PARAMETER, RETURN_TYPE, FIELD, TYPE_BOUND, TYPE_ARGUMENT };\n}\n", "annotation/Nullable.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface Nullable {\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport annotation.NNBDField;\nimport annotation.NNBDParam;\nimport annotation.NNBDReturn;\nimport annotation.NNBDTypeArg;\nimport annotation.NNBDTypeBound;\nimport annotation.NonNull;\n\ninterface C<T1, T2> {\n}\n\nabstract class X {\n    @NNBDTypeArg\n    @NNBDField\n    @NNBDTypeBound\n    C<Object, ? extends Number> f1; // warning 1\n\n    @NonNull\n    C<@NonNull Object, ? extends @NonNull Number> f2; // warning 2\n\n    @NNBDTypeArg\n    @NNBDReturn\n    @NNBDParam\n    @NNBDTypeBound\n    abstract Object m1(C<Object, ? extends Number> p1, Object p2);\n\n    abstract @NNBDReturn Object m2(@NNBDParam @NNBDTypeArg @NNBDTypeBound C<Object, ? extends Number> p1,\n            @NNBDParam Object p2);\n\n    abstract @NonNull Object m3(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2);\n}\n\nclass ExplicitNonNull extends X {\n    Object m1(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 3 on return type\n        f1 = null; // warning 4\n        f2 = null; // warning 5\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n\n    Object m2(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 6 on return type\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n\n    Object m3(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 7 on return type\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n}\n\n@NNBDParam\n@NNBDTypeArg\n@NNBDTypeBound\nclass OnClass extends X {\n    Object m1(C<Object, ? extends Number> p1, Object p2) { // warning 8 on return type\n        f1 = null; // warning 9\n        f2 = null; // warning 10\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n\n    Object m2(C<Object, ? extends Number> p1, Object p2) { // warning 11 on return type\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n\n    Object m3(C<Object, ? extends Number> p1, Object p2) { // warning 12 on return type\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n}\n\nclass Test {\n    @NNBDParam\n    @NNBDTypeArg\n    @NNBDTypeBound\n    X onField = new X() {\n        Object m1(C<Object, ? extends Number> p1, Object p2) { // warning 13 on return type\n            f1 = null; // warning 14\n            f2 = null; // warning 15\n            f1 = p1;\n            f2 = p1;\n            return p2;\n        }\n\n        Object m2(C<Object, ? extends Number> p1, Object p2) { // warning 16 on return type\n            f1 = p1;\n            f2 = p1;\n            return p2;\n        }\n\n        Object m3(C<Object, ? extends Number> p1, Object p2) { // warning 17 on return type\n            f1 = p1;\n            f2 = p1;\n            return p2;\n        }\n    };\n\n    {\n        @NNBDParam\n        @NNBDTypeArg\n        @NNBDTypeBound\n        X onLocal = new X() {\n            Object m1(C<Object, ? extends Number> p1, Object p2) { // warning 18 on return type\n                f1 = null; // warning 19\n                f2 = null; // warning 20\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n\n            Object m2(C<Object, ? extends Number> p1, Object p2) { // warning 21 on return type\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n\n            Object m3(C<Object, ? extends Number> p1, Object p2) { // warning 22 on return type\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n        };\n    }\n\n    @NNBDParam\n    @NNBDTypeArg\n    @NNBDTypeBound\n    void onMethod() {\n        X l1 = new X() {\n            Object m1(C<Object, ? extends Number> p1, Object p2) { // warning 23 on return type\n                f1 = null; // warning 24\n                f2 = null; // warning 25\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n\n            Object m2(C<Object, ? extends Number> p1, Object p2) { // warning 26 on return type\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n\n            Object m3(C<Object, ? extends Number> p1, Object p2) { // warning 27 on return type\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n        };\n    }\n}\n"}, customOptions, "----------\n1. ERROR in test\\Test.java (at line 17)\n\tC<Object, ? extends Number> f1; // warning 1\n\t                            ^^\nThe @NonNull field f1 may not have been initialized\n----------\n2. ERROR in test\\Test.java (at line 20)\n\tC<@NonNull Object, ? extends @NonNull Number> f2; // warning 2\n\t                                              ^^\nThe @NonNull field f2 may not have been initialized\n----------\n3. ERROR in test\\Test.java (at line 35)\n\tObject m1(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 3 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m1(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n4. ERROR in test\\Test.java (at line 36)\n\tf1 = null; // warning 4\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n5. ERROR in test\\Test.java (at line 37)\n\tf2 = null; // warning 5\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n6. ERROR in test\\Test.java (at line 43)\n\tObject m2(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 6 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m2(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n7. ERROR in test\\Test.java (at line 49)\n\tObject m3(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 7 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m3(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n8. ERROR in test\\Test.java (at line 60)\n\tObject m1(C<Object, ? extends Number> p1, Object p2) { // warning 8 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m1(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n9. ERROR in test\\Test.java (at line 61)\n\tf1 = null; // warning 9\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n10. ERROR in test\\Test.java (at line 62)\n\tf2 = null; // warning 10\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n11. ERROR in test\\Test.java (at line 68)\n\tObject m2(C<Object, ? extends Number> p1, Object p2) { // warning 11 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m2(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n12. ERROR in test\\Test.java (at line 74)\n\tObject m3(C<Object, ? extends Number> p1, Object p2) { // warning 12 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m3(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n13. ERROR in test\\Test.java (at line 86)\n\tObject m1(C<Object, ? extends Number> p1, Object p2) { // warning 13 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m1(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n14. ERROR in test\\Test.java (at line 87)\n\tf1 = null; // warning 14\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n15. ERROR in test\\Test.java (at line 88)\n\tf2 = null; // warning 15\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n16. ERROR in test\\Test.java (at line 94)\n\tObject m2(C<Object, ? extends Number> p1, Object p2) { // warning 16 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m2(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n17. ERROR in test\\Test.java (at line 100)\n\tObject m3(C<Object, ? extends Number> p1, Object p2) { // warning 17 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m3(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n18. ERROR in test\\Test.java (at line 112)\n\tObject m1(C<Object, ? extends Number> p1, Object p2) { // warning 18 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m1(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n19. ERROR in test\\Test.java (at line 113)\n\tf1 = null; // warning 19\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n20. ERROR in test\\Test.java (at line 114)\n\tf2 = null; // warning 20\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n21. ERROR in test\\Test.java (at line 120)\n\tObject m2(C<Object, ? extends Number> p1, Object p2) { // warning 21 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m2(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n22. ERROR in test\\Test.java (at line 126)\n\tObject m3(C<Object, ? extends Number> p1, Object p2) { // warning 22 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m3(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n23. ERROR in test\\Test.java (at line 139)\n\tObject m1(C<Object, ? extends Number> p1, Object p2) { // warning 23 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m1(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n24. ERROR in test\\Test.java (at line 140)\n\tf1 = null; // warning 24\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n25. ERROR in test\\Test.java (at line 141)\n\tf2 = null; // warning 25\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n26. ERROR in test\\Test.java (at line 147)\n\tObject m2(C<Object, ? extends Number> p1, Object p2) { // warning 26 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m2(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n27. ERROR in test\\Test.java (at line 153)\n\tObject m3(C<Object, ? extends Number> p1, Object p2) { // warning 27 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m3(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n");
    }

    public void testBug530971_BTB() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "annotation.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "annotation.NonNull");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "annotation.NonNullByDefault");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary", "annotation.NNBDField,annotation.NNBDParam,annotation.NNBDReturn,annotation.NNBDTypeArg,annotation.NNBDTypeBound");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.runConformTestWithLibs(new String[]{"annotation/DefaultLocation.java", "package annotation;\n\npublic enum DefaultLocation {\n    PARAMETER, RETURN_TYPE, FIELD, TYPE_PARAMETER, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS\n}\n", "annotation/NNBDField.java", "package annotation;\n\nimport static annotation.DefaultLocation.FIELD;\n \npublic @interface NNBDField {\n\tDefaultLocation[] value() default { FIELD };\n}\n", "annotation/NNBDParam.java", "package annotation;\n\nimport static annotation.DefaultLocation.PARAMETER;\n\npublic @interface NNBDParam {\n    DefaultLocation[] value() default { PARAMETER };\n}\n", "annotation/NNBDReturn.java", "package annotation;\n\nimport static annotation.DefaultLocation.RETURN_TYPE;\n\npublic @interface NNBDReturn {\n    DefaultLocation[] value() default { RETURN_TYPE };\n}\n", "annotation/NNBDTypeArg.java", "package annotation;\n\nimport static annotation.DefaultLocation.TYPE_ARGUMENT;\n\npublic @interface NNBDTypeArg {\n    DefaultLocation[] value() default { TYPE_ARGUMENT };\n}\n", "annotation/NNBDTypeBound.java", "package annotation;\n\nimport static annotation.DefaultLocation.TYPE_BOUND;\n\npublic @interface NNBDTypeBound {\n    DefaultLocation[] value() default { TYPE_BOUND };\n}\n", "annotation/NonNull.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface NonNull {\n}\n", "annotation/NonNullByDefault.java", "package annotation;\n\nimport static annotation.DefaultLocation.FIELD;\nimport static annotation.DefaultLocation.PARAMETER;\nimport static annotation.DefaultLocation.RETURN_TYPE;\nimport static annotation.DefaultLocation.TYPE_ARGUMENT;\nimport static annotation.DefaultLocation.TYPE_BOUND;\n \npublic @interface NonNullByDefault {\n    DefaultLocation[] value() default { PARAMETER, RETURN_TYPE, FIELD, TYPE_BOUND, TYPE_ARGUMENT };\n}\n", "annotation/Nullable.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface Nullable {\n}\n"}, customOptions, "");
        this.runConformTestWithLibs(false, new String[]{"test/X.java", "package test;\n\nimport annotation.NNBDField;\nimport annotation.NNBDParam;\nimport annotation.NNBDReturn;\nimport annotation.NNBDTypeArg;\nimport annotation.NNBDTypeBound;\nimport annotation.NonNull;\n\ninterface C<T1, T2> {\n}\n\n@SuppressWarnings(\"null\")\nabstract class X {\n    @NNBDTypeArg\n    @NNBDField\n    @NNBDTypeBound\n    C<Object, ? extends Number> f1; // warning 1\n\n    @NonNull\n    C<@NonNull Object, ? extends @NonNull Number> f2; // warning 2\n\n    @NNBDTypeArg\n    @NNBDReturn\n    @NNBDParam\n    @NNBDTypeBound\n    abstract Object m1(C<Object, ? extends Number> p1, Object p2);\n\n    abstract @NNBDReturn Object m2(@NNBDParam @NNBDTypeArg @NNBDTypeBound C<Object, ? extends Number> p1,\n            @NNBDParam Object p2);\n\n    abstract @NonNull Object m3(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2);\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"test/Test.java", "package test;\n\nimport annotation.NNBDField;\nimport annotation.NNBDParam;\nimport annotation.NNBDReturn;\nimport annotation.NNBDTypeArg;\nimport annotation.NNBDTypeBound;\nimport annotation.NonNull;\n\ninterface C_IGNORED<T1, T2> {\n}\n\nabstract class X_IGNORED {\n    @NNBDTypeArg\n    @NNBDField\n    @NNBDTypeBound\n    C<Object, ? extends Number> f1; // warning 1\n\n    @NonNull\n    C<@NonNull Object, ? extends @NonNull Number> f2; // warning 2\n\n    @NNBDTypeArg\n    @NNBDReturn\n    @NNBDParam\n    @NNBDTypeBound\n    abstract Object m1(C<Object, ? extends Number> p1, Object p2);\n\n    abstract @NNBDReturn Object m2(@NNBDParam @NNBDTypeArg @NNBDTypeBound C<Object, ? extends Number> p1,\n            @NNBDParam Object p2);\n\n    abstract @NonNull Object m3(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2);\n}\n\nclass ExplicitNonNull extends X {\n    Object m1(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 3 on return type\n        f1 = null; // warning 4\n        f2 = null; // warning 5\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n\n    Object m2(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 6 on return type\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n\n    Object m3(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 7 on return type\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n}\n\n@NNBDParam\n@NNBDTypeArg\n@NNBDTypeBound\nclass OnClass extends X {\n    Object m1(C<Object, ? extends Number> p1, Object p2) { // warning 8 on return type\n        f1 = null; // warning 9\n        f2 = null; // warning 10\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n\n    Object m2(C<Object, ? extends Number> p1, Object p2) { // warning 11 on return type\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n\n    Object m3(C<Object, ? extends Number> p1, Object p2) { // warning 12 on return type\n        f1 = p1;\n        f2 = p1;\n        return p2;\n    }\n}\n\nclass Test {\n    @NNBDParam\n    @NNBDTypeArg\n    @NNBDTypeBound\n    X onField = new X() {\n        Object m1(C<Object, ? extends Number> p1, Object p2) { // warning 13 on return type\n            f1 = null; // warning 14\n            f2 = null; // warning 15\n            f1 = p1;\n            f2 = p1;\n            return p2;\n        }\n\n        Object m2(C<Object, ? extends Number> p1, Object p2) { // warning 16 on return type\n            f1 = p1;\n            f2 = p1;\n            return p2;\n        }\n\n        Object m3(C<Object, ? extends Number> p1, Object p2) { // warning 17 on return type\n            f1 = p1;\n            f2 = p1;\n            return p2;\n        }\n    };\n\n    {\n        @NNBDParam\n        @NNBDTypeArg\n        @NNBDTypeBound\n        X onLocal = new X() {\n            Object m1(C<Object, ? extends Number> p1, Object p2) { // warning 18 on return type\n                f1 = null; // warning 19\n                f2 = null; // warning 20\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n\n            Object m2(C<Object, ? extends Number> p1, Object p2) { // warning 21 on return type\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n\n            Object m3(C<Object, ? extends Number> p1, Object p2) { // warning 22 on return type\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n        };\n    }\n\n    @NNBDParam\n    @NNBDTypeArg\n    @NNBDTypeBound\n    void onMethod() {\n        X l1 = new X() {\n            Object m1(C<Object, ? extends Number> p1, Object p2) { // warning 23 on return type\n                f1 = null; // warning 24\n                f2 = null; // warning 25\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n\n            Object m2(C<Object, ? extends Number> p1, Object p2) { // warning 26 on return type\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n\n            Object m3(C<Object, ? extends Number> p1, Object p2) { // warning 27 on return type\n                f1 = p1;\n                f2 = p1;\n                return p2;\n            }\n        };\n    }\n}\n"}, customOptions, "----------\n1. ERROR in test\\Test.java (at line 17)\n\tC<Object, ? extends Number> f1; // warning 1\n\t                            ^^\nThe @NonNull field f1 may not have been initialized\n----------\n2. ERROR in test\\Test.java (at line 20)\n\tC<@NonNull Object, ? extends @NonNull Number> f2; // warning 2\n\t                                              ^^\nThe @NonNull field f2 may not have been initialized\n----------\n3. ERROR in test\\Test.java (at line 35)\n\tObject m1(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 3 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m1(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n4. ERROR in test\\Test.java (at line 36)\n\tf1 = null; // warning 4\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n5. ERROR in test\\Test.java (at line 37)\n\tf2 = null; // warning 5\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n6. ERROR in test\\Test.java (at line 43)\n\tObject m2(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 6 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m2(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n7. ERROR in test\\Test.java (at line 49)\n\tObject m3(@NonNull C<@NonNull Object, ? extends @NonNull Number> p1, @NonNull Object p2) { // warning 7 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m3(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n8. ERROR in test\\Test.java (at line 60)\n\tObject m1(C<Object, ? extends Number> p1, Object p2) { // warning 8 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m1(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n9. ERROR in test\\Test.java (at line 61)\n\tf1 = null; // warning 9\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n10. ERROR in test\\Test.java (at line 62)\n\tf2 = null; // warning 10\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n11. ERROR in test\\Test.java (at line 68)\n\tObject m2(C<Object, ? extends Number> p1, Object p2) { // warning 11 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m2(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n12. ERROR in test\\Test.java (at line 74)\n\tObject m3(C<Object, ? extends Number> p1, Object p2) { // warning 12 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m3(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n13. ERROR in test\\Test.java (at line 86)\n\tObject m1(C<Object, ? extends Number> p1, Object p2) { // warning 13 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m1(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n14. ERROR in test\\Test.java (at line 87)\n\tf1 = null; // warning 14\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n15. ERROR in test\\Test.java (at line 88)\n\tf2 = null; // warning 15\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n16. ERROR in test\\Test.java (at line 94)\n\tObject m2(C<Object, ? extends Number> p1, Object p2) { // warning 16 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m2(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n17. ERROR in test\\Test.java (at line 100)\n\tObject m3(C<Object, ? extends Number> p1, Object p2) { // warning 17 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m3(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n18. ERROR in test\\Test.java (at line 112)\n\tObject m1(C<Object, ? extends Number> p1, Object p2) { // warning 18 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m1(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n19. ERROR in test\\Test.java (at line 113)\n\tf1 = null; // warning 19\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n20. ERROR in test\\Test.java (at line 114)\n\tf2 = null; // warning 20\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n21. ERROR in test\\Test.java (at line 120)\n\tObject m2(C<Object, ? extends Number> p1, Object p2) { // warning 21 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m2(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n22. ERROR in test\\Test.java (at line 126)\n\tObject m3(C<Object, ? extends Number> p1, Object p2) { // warning 22 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m3(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n23. ERROR in test\\Test.java (at line 139)\n\tObject m1(C<Object, ? extends Number> p1, Object p2) { // warning 23 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m1(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n24. ERROR in test\\Test.java (at line 140)\n\tf1 = null; // warning 24\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n25. ERROR in test\\Test.java (at line 141)\n\tf2 = null; // warning 25\n\t     ^^^^\nNull type mismatch: required '@NonNull C<@NonNull Object,? extends @NonNull Number>' but the provided value is null\n----------\n26. ERROR in test\\Test.java (at line 147)\n\tObject m2(C<Object, ? extends Number> p1, Object p2) { // warning 26 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m2(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n27. ERROR in test\\Test.java (at line 153)\n\tObject m3(C<Object, ? extends Number> p1, Object p2) { // warning 27 on return type\n\t^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.m3(C<Object,? extends Number>, Object) (mismatching null constraints)\n----------\n");
    }

    public void testBug530971_redundant() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "annotation.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "annotation.NonNull");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "annotation.NonNullByDefault");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary", "annotation.NNBDField,annotation.NNBDParam,annotation.NNBDReturn,annotation.NNBDTypeArg,annotation.NNBDTypeBound");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.runConformTestWithLibs(new String[]{"annotation/DefaultLocation.java", "package annotation;\n\npublic enum DefaultLocation {\n    PARAMETER, RETURN_TYPE, FIELD, TYPE_PARAMETER, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS\n}\n", "annotation/NNBDField.java", "package annotation;\n\nimport static annotation.DefaultLocation.FIELD;\n \npublic @interface NNBDField {\n\tDefaultLocation[] value() default { FIELD };\n}\n", "annotation/NNBDParam.java", "package annotation;\n\nimport static annotation.DefaultLocation.PARAMETER;\n\npublic @interface NNBDParam {\n    DefaultLocation[] value() default { PARAMETER };\n}\n", "annotation/NNBDReturn.java", "package annotation;\n\nimport static annotation.DefaultLocation.RETURN_TYPE;\n\npublic @interface NNBDReturn {\n    DefaultLocation[] value() default { RETURN_TYPE };\n}\n", "annotation/NNBDTypeArg.java", "package annotation;\n\nimport static annotation.DefaultLocation.TYPE_ARGUMENT;\n\npublic @interface NNBDTypeArg {\n    DefaultLocation[] value() default { TYPE_ARGUMENT };\n}\n", "annotation/NNBDTypeBound.java", "package annotation;\n\nimport static annotation.DefaultLocation.TYPE_BOUND;\n\npublic @interface NNBDTypeBound {\n    DefaultLocation[] value() default { TYPE_BOUND };\n}\n", "annotation/NonNull.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface NonNull {\n}\n", "annotation/NonNullByDefault.java", "package annotation;\n\nimport static annotation.DefaultLocation.FIELD;\nimport static annotation.DefaultLocation.PARAMETER;\nimport static annotation.DefaultLocation.RETURN_TYPE;\nimport static annotation.DefaultLocation.TYPE_ARGUMENT;\nimport static annotation.DefaultLocation.TYPE_BOUND;\n \npublic @interface NonNullByDefault {\n    DefaultLocation[] value() default { PARAMETER, RETURN_TYPE, FIELD, TYPE_BOUND, TYPE_ARGUMENT };\n}\n", "annotation/Nullable.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface Nullable {\n}\n"}, customOptions, "");
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"test/X.java", "package test;\n\nimport annotation.*;\n\n@NNBDReturn\n@NNBDParam\n@NNBDField\nabstract class X {\n    @NNBDReturn\n    @NNBDParam\n    @NNBDField // warning 1\n    abstract class OnClass {\n    }\n\n    @NNBDReturn\n    @NNBDParam\n    @NNBDField // warning 2\n    Object onField = \"\";\n\n    {\n        @NNBDReturn\n        @NNBDParam\n        @NNBDField // warning 3\n        Object onLocal;\n    }\n\n    @NNBDReturn\n    @NNBDParam\n    @NNBDField // warning 4\n    abstract void onMethod();\n\n    abstract void m(//\n            @NNBDReturn //\n            @NNBDParam //\n            @NNBDField // warning 5\n            Object onParameter);\n}\n"};
        runner.customOptions = customOptions;
        runner.expectedCompilerLog = "----------\n1. WARNING in test\\X.java (at line 11)\n\t@NNBDField // warning 1\n\t^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type X\n----------\n2. WARNING in test\\X.java (at line 17)\n\t@NNBDField // warning 2\n\t^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type X\n----------\n3. WARNING in test\\X.java (at line 23)\n\t@NNBDField // warning 3\n\t^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type X\n----------\n4. WARNING in test\\X.java (at line 29)\n\t@NNBDField // warning 4\n\t^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type X\n----------\n5. WARNING in test\\X.java (at line 35)\n\t@NNBDField // warning 5\n\t^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type X\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings;
        runner.runWarningTest();
    }

    public void testBug530971_locally_redundant() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "annotation.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "annotation.NonNull");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "annotation.NonNullByDefault");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary", "annotation.NNBDField,annotation.NNBDParam,annotation.NNBDReturn,annotation.NNBDTypeArg,annotation.NNBDTypeBound");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.runConformTestWithLibs(new String[]{"annotation/DefaultLocation.java", "package annotation;\n\npublic enum DefaultLocation {\n    PARAMETER, RETURN_TYPE, FIELD, TYPE_PARAMETER, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS\n}\n", "annotation/NNBDField.java", "package annotation;\n\nimport static annotation.DefaultLocation.FIELD;\n \npublic @interface NNBDField {\n\tDefaultLocation[] value() default { FIELD };\n}\n", "annotation/NNBDParam.java", "package annotation;\n\nimport static annotation.DefaultLocation.PARAMETER;\n\npublic @interface NNBDParam {\n    DefaultLocation[] value() default { PARAMETER };\n}\n", "annotation/NNBDReturn.java", "package annotation;\n\nimport static annotation.DefaultLocation.RETURN_TYPE;\n\npublic @interface NNBDReturn {\n    DefaultLocation[] value() default { RETURN_TYPE };\n}\n", "annotation/NNBDTypeArg.java", "package annotation;\n\nimport static annotation.DefaultLocation.TYPE_ARGUMENT;\n\npublic @interface NNBDTypeArg {\n    DefaultLocation[] value() default { TYPE_ARGUMENT };\n}\n", "annotation/NNBDTypeBound.java", "package annotation;\n\nimport static annotation.DefaultLocation.TYPE_BOUND;\n\npublic @interface NNBDTypeBound {\n    DefaultLocation[] value() default { TYPE_BOUND };\n}\n", "annotation/NonNull.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface NonNull {\n}\n", "annotation/NonNullByDefault.java", "package annotation;\n\nimport static annotation.DefaultLocation.FIELD;\nimport static annotation.DefaultLocation.PARAMETER;\nimport static annotation.DefaultLocation.RETURN_TYPE;\nimport static annotation.DefaultLocation.TYPE_ARGUMENT;\nimport static annotation.DefaultLocation.TYPE_BOUND;\n \npublic @interface NonNullByDefault {\n    DefaultLocation[] value() default { PARAMETER, RETURN_TYPE, FIELD, TYPE_BOUND, TYPE_ARGUMENT };\n}\n", "annotation/Nullable.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\npublic @interface Nullable {\n}\n"}, customOptions, "");
        this.runConformTestWithLibs(false, new String[]{"testredundant/TestRedundantOnSame.java", "package testredundant;\n\nimport annotation.DefaultLocation;\nimport annotation.NNBDField;\nimport annotation.NNBDParam;\nimport annotation.NNBDReturn;\nimport annotation.NonNullByDefault;\n\n@NNBDReturn\n@NNBDParam\n@NNBDField\n@NonNullByDefault({ DefaultLocation.RETURN_TYPE, DefaultLocation.PARAMETER, DefaultLocation.FIELD })\nabstract class TestRedundantOnSame {\n    @NNBDReturn\n    @NNBDParam\n    @NonNullByDefault({ DefaultLocation.RETURN_TYPE, DefaultLocation.PARAMETER })\n    abstract class OnClass {\n    }\n\n    @NNBDReturn\n    @NNBDParam\n    @NonNullByDefault({ DefaultLocation.RETURN_TYPE, DefaultLocation.PARAMETER })\n    Object onField = \"\";\n\n    {\n        @NNBDReturn\n        @NNBDParam\n        @NonNullByDefault({ DefaultLocation.RETURN_TYPE, DefaultLocation.PARAMETER })\n        Object onLocal;\n    }\n\n    @NNBDReturn\n    @NNBDParam\n    @NonNullByDefault({ DefaultLocation.RETURN_TYPE, DefaultLocation.PARAMETER })\n    abstract void onMethod();\n\n    abstract void m(//\n            @NNBDReturn //\n            @NNBDParam //\n            @NonNullByDefault({ DefaultLocation.RETURN_TYPE, DefaultLocation.PARAMETER }) //\n            Object onParameter);\n}\n"}, customOptions, "");
    }

    public void testBug518839() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "annotation.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "annotation.NonNull");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "annotation.NonNullApi");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary", "annotation.NonNullFields");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runConformTestWithLibs(new String[]{"annotation/NonNull.java", "package annotation;\n\npublic @interface NonNull {\n}\n", "annotation/NonNullApi.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\n\n@TypeQualifierDefault({ElementType.METHOD, ElementType.PARAMETER})\npublic @interface NonNullApi {\n}\n", "annotation/NonNullFields.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\n\n@TypeQualifierDefault(ElementType.FIELD)\npublic @interface NonNullFields {\n}\n", "annotation/Nullable.java", "package annotation;\n\npublic @interface Nullable {\n}\n", "annotation/TypeQualifierDefault.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\n\npublic @interface TypeQualifierDefault {\n    ElementType[] value();\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"nn_api/NNApi.java", "package nn_api;\n\npublic class NNApi {\n    public String f;\n\n    public Object m(Object p) {\n        if (p != null) { // warning\n            //\n        }\n        return null; // warning\n    }\n}\n", "nn_api/package-info.java", "@annotation.NonNullApi\npackage nn_api;\n", "nn_api_and_fields/NNApiAndFields.java", "package nn_api_and_fields;\n\npublic class NNApiAndFields {\n    public String f; // warning 1\n\n    public Object m(Object p) {\n        if (p != null) { // warning 2\n            //\n        }\n        return null; // warning 3\n    }\n}\n", "nn_api_and_fields/package-info.java", "@annotation.NonNullApi\n@annotation.NonNullFields\npackage nn_api_and_fields;\n", "nn_fields/NNFields.java", "package nn_fields;\n\npublic class NNFields {\n    public String f; // warning\n\n    public Object m(Object p) {\n        if (p != null) {\n            //\n        }\n        return null;\n    }\n}\n", "nn_fields/package-info.java", "@annotation.NonNullFields\npackage nn_fields;\n"}, customOptions, "----------\n1. ERROR in nn_api\\NNApi.java (at line 7)\n\tif (p != null) { // warning\n\t    ^\nRedundant null check: The variable p is specified as @NonNull\n----------\n2. ERROR in nn_api\\NNApi.java (at line 10)\n\treturn null; // warning\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n----------\n1. ERROR in nn_api_and_fields\\NNApiAndFields.java (at line 4)\n\tpublic String f; // warning 1\n\t              ^\nThe @NonNull field f may not have been initialized\n----------\n2. ERROR in nn_api_and_fields\\NNApiAndFields.java (at line 7)\n\tif (p != null) { // warning 2\n\t    ^\nRedundant null check: The variable p is specified as @NonNull\n----------\n3. ERROR in nn_api_and_fields\\NNApiAndFields.java (at line 10)\n\treturn null; // warning 3\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n----------\n1. ERROR in nn_fields\\NNFields.java (at line 4)\n\tpublic String f; // warning\n\t              ^\nThe @NonNull field f may not have been initialized\n----------\n");
    }

    public void testBug518839_BTB() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "annotation.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "annotation.NonNull");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "annotation.NonNullApi");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary", "annotation.NonNullFields");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runConformTestWithLibs(new String[]{"annotation/NonNull.java", "package annotation;\n\npublic @interface NonNull {\n}\n", "annotation/NonNullApi.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\n\n@TypeQualifierDefault({ElementType.METHOD, ElementType.PARAMETER})\npublic @interface NonNullApi {\n}\n", "annotation/NonNullFields.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\n\n@TypeQualifierDefault(ElementType.FIELD)\npublic @interface NonNullFields {\n}\n", "annotation/Nullable.java", "package annotation;\n\npublic @interface Nullable {\n}\n", "annotation/TypeQualifierDefault.java", "package annotation;\n\nimport java.lang.annotation.ElementType;\n\npublic @interface TypeQualifierDefault {\n    ElementType[] value();\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"nn_api/NNApi.java", "package nn_api;\n\npublic class NNApi {\n    public String f;\n\n    public Object m(Object p) {\n        if (p != null) { // warning\n            //\n        }\n        return null; // warning\n    }\n}\n", "nn_api/package-info.java", "@annotation.NonNullApi\npackage nn_api;\n", "nn_api_and_fields/NNApiAndFields.java", "package nn_api_and_fields;\n\npublic class NNApiAndFields {\n    public String f; // warning 1\n\n    public Object m(Object p) {\n        if (p != null) { // warning 2\n            //\n        }\n        return null; // warning 3\n    }\n}\n", "nn_api_and_fields/package-info.java", "@annotation.NonNullApi\n@annotation.NonNullFields\npackage nn_api_and_fields;\n", "nn_fields/NNFields.java", "package nn_fields;\n\npublic class NNFields {\n    public String f; // warning\n\n    public Object m(Object p) {\n        if (p != null) {\n            //\n        }\n        return null;\n    }\n}\n", "nn_fields/package-info.java", "@annotation.NonNullFields\npackage nn_fields;\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"btbtest/BTBTest.java", "package btbtest;\n\nimport nn_api.NNApi;\nimport nn_api_and_fields.NNApiAndFields;\nimport nn_fields.NNFields;\n\npublic class BTBTest {\n    void api(NNApi p) {\n        if (p.m(null) == null) { // 2 warnings\n        }\n        p.f = null;\n    }\n\n    void apiAndFields(NNApiAndFields p) {\n        if (p.m(null) == null) { // 2 warnings\n        }\n        p.f = null; // warning\n    }\n\n    void fields(NNFields p) {\n        if (p.m(null) == null) {\n        }\n        p.f = null; // warning\n    }\n}\n"}, customOptions, "----------\n1. ERROR in btbtest\\BTBTest.java (at line 9)\n\tif (p.m(null) == null) { // 2 warnings\n\t    ^^^^^^^^^\nNull comparison always yields false: The method m(Object) cannot return null\n----------\n2. ERROR in btbtest\\BTBTest.java (at line 9)\n\tif (p.m(null) == null) { // 2 warnings\n\t        ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n3. ERROR in btbtest\\BTBTest.java (at line 15)\n\tif (p.m(null) == null) { // 2 warnings\n\t    ^^^^^^^^^\nNull comparison always yields false: The method m(Object) cannot return null\n----------\n4. ERROR in btbtest\\BTBTest.java (at line 15)\n\tif (p.m(null) == null) { // 2 warnings\n\t        ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n5. ERROR in btbtest\\BTBTest.java (at line 17)\n\tp.f = null; // warning\n\t      ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n6. ERROR in btbtest\\BTBTest.java (at line 23)\n\tp.f = null; // warning\n\t      ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug531040() {
        if (this.complianceLevel < 0x360000L) {
            return;
        }
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import java.util.*;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class Test {\n\tvoid test() {\n\t\tvar list1 = new ArrayList<@NonNull String>();\n\t\tlist1.add(null);\n\t\t@NonNull String val = \"\";\n\t\tvar list2 = getList(val);\n\t\tlist2.add(null);\n\t}\n\t<T> List<T> getList(T... in) {\n\t\treturn Arrays.asList(in);\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 8)\n\tlist1.add(null);\n\t          ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. ERROR in Test.java (at line 11)\n\tlist2.add(null);\n\t          ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n3. WARNING in Test.java (at line 13)\n\t<T> List<T> getList(T... in) {\n\t                         ^^\nType safety: Potential heap pollution via varargs parameter in\n----------\n");
    }

    public void testBug533339() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.testFiles = new String[]{"Test.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class Test {\n\n\tinterface Foo {\n\n\t\t@Nullable\n\t\tString getString();\n\t}\n\n\tclass Bar {\n\n\t\tBar(@NonNull String s) {\n\t\t}\n\t}\n\n\tBar hasWarning(Foo foo) {\n\t\t@NonNull String s = checkNotNull(foo.getString());\n\t\treturn new Bar(s);// Null type mismatch: required '@NonNull String' but the provided value is inferred as @Nullable\n\t}\n\n\tBar hasNoWarning(Foo foo) {\n\t\treturn new Bar(checkNotNull(foo.getString()));// no warning when s is inlined\n\t}\n\tstatic <T> T checkNotNull(T reference) {\n\t\tif (reference == null) throw new NullPointerException();\n\t\treturn reference;\n\t}\n}\n"};
        runner.classLibraries = this.LIBS;
        runner.expectedCompilerLog = "----------\n1. WARNING in Test.java (at line 19)\n\t@NonNull String s = checkNotNull(foo.getString());\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n2. WARNING in Test.java (at line 24)\n\treturn new Bar(checkNotNull(foo.getString()));// no warning when s is inlined\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings;
        runner.runWarningTest();
    }

    public void testBug534516() {
        this.runConformTestWithLibs(new String[]{"testbug/nullannotations/Utility.java", "package testbug.nullannotations;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic class Utility {\n\n\tpublic static String massageString(final String input) {\n\t\treturn input + \" .\";\n\t}\n\n\tprivate Utility() {\n\n\t}\n\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(false, new String[]{"testbug/nullannotations/ApplyIfNonNullElseGetBugDemo.java", "package testbug.nullannotations;\n\nimport java.util.function.Function;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class ApplyIfNonNullElseGetBugDemo {\n\n\tpublic static <T, U> U applyIfNonNullElse(@Nullable T value, @NonNull Function<@NonNull ? super T, ? extends U> function, U fallbackValue) {\n\t\tif (value != null)\n\t\t\treturn function.apply(value);\n\t\treturn fallbackValue;\n\t}\n\n\tpublic static void main(final @Nullable String[] args) {\n\t\tfinal @Nullable String arg = args.length == 0 ? null : args[0];\n\t\tSystem.out.println(applyIfNonNullElse(arg, Utility::massageString, \"\")); // incorrect warning here\n\t}\n\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug536459() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.Nullable;\n\npublic class X {\n    static void x() {\n        @Nullable String x1 = \"\";\n        @Nullable String[] x2 = { \"\" };\n    }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug536555() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner(this);
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        runner.testFiles = new String[]{"Foo.java", "public class Foo\n{\n\t/** Test {@link #foo(boolean)}. */\n\tpublic static final String TEST = \"foo\";\n\n\tpublic void foo(@SuppressWarnings(TEST) final boolean test)\n\t{\n\t\tSystem.out.println(test);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in Foo.java (at line 6)\n\tpublic void foo(@SuppressWarnings(TEST) final boolean test)\n\t                                  ^^^^\nUnsupported @SuppressWarnings(\"foo\")\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings;
        runner.runWarningTest();
    }
}

