/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.util.Util;

public class SwitchTest
extends AbstractRegressionTest {
    private static final long JDKLevelSupportingStringSwitch = 0x330000L;

    public SwitchTest(String name) {
        super(name);
    }

    public static Test suite() {
        return SwitchTest.buildAllCompliancesTestSuite(SwitchTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public static void main(String args[]) {\n    foo();\n  }\n  public static void foo() {\n    try {\n      switch(0) {\n      case 0 :\n      case 1 - (1 << 31) :\n      case (1 << 30) :\n      }\n    } catch (OutOfMemoryError e) {\n    }\n  }\n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  int k;\n  public void foo() {\n    int c;\n    switch (k) {\n      default :\n        c = 2;\n        break;\n      case 2 :\n        c = 3;\n        break;\n    }\n  }\n}\n"});
    }

    public void test003() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  int i = 0;\n  void foo() {\n    switch (i) {\n      case 1 :\n        {\n          int j;\n          break;\n        }\n    }\n  }\n}\n"});
    }

    public void test004() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public static int foo() {\n    int i = 0, j;\n    switch (i) {\n      default :\n        int k = 2;\n        j = k;\n    }\n    if (j != -2) {\n      return 1;\n    }\n    return 0;\n  }\n}\n"});
    }

    public void test005() {
        this.runConformTest(new String[]{"p/BugJavaCase.java", "package p;\nclass BugJavaCase {\n  public static final int BC_ZERO_ARG = 1;\n  public void test01(int i) {\n    switch (i) {\n      case BC_ZERO_ARG :\n        System.out.println(\"i = \" + i);\n        break;\n    }\n  }\n}\n"});
    }

    public void test006() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public static void main(String args[]) {\n    foo(); \n  } \n \n  public static void foo() { \n    char x = 5;\n    final short b = 5;\n    int a;\n    \n    switch (x) {\n      case b:        // compile time error\n        a = 0;\n        break; \n      default:\n        a=1;\n    }\n    \n  }\n}\n"});
    }

    public void test007() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nclass X {\n  void v() {\n    switch (1) {\n      case (int) (1.0 / 0.0) :\n        break;\n      case (int) (2.0 / 0.0) :\n        break;\n    }\n  }\n}"}, "----------\n1. ERROR in p\\X.java (at line 5)\n\tcase (int) (1.0 / 0.0) :\n\t^^^^^^^^^^^^^^^^^^^^^^\nDuplicate case\n----------\n2. ERROR in p\\X.java (at line 7)\n\tcase (int) (2.0 / 0.0) :\n\t^^^^^^^^^^^^^^^^^^^^^^\nDuplicate case\n----------\n");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tswitch(args.length){\n\t\t}\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String argv[]) {\n        switch (81391861) {\n        case (81391861) :\n        \tSystem.out.println(\"SUCCESS\");\n            break;\n        default:\n        \tSystem.out.println(\"FAILED\");\n        }\n    }\n}\n"}, "SUCCESS");
    }

    public void test010() {
        String newMessage = "----------\n1. ERROR in X.java (at line 4)\n\tswitch(this){\n\t       ^^^^\nCannot switch on a value of type X. Only convertible int values, strings or enum variables are permitted\n----------\n2. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 11)\n\tswitch(x){\n\t       ^\nx cannot be resolved to a variable\n----------\n4. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        String oldMessage = "----------\n1. ERROR in X.java (at line 4)\n\tswitch(this){\n\t       ^^^^\nCannot switch on a value of type X. Only convertible int values or enum variables are permitted\n----------\n2. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 11)\n\tswitch(x){\n\t       ^\nx cannot be resolved to a variable\n----------\n4. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tvoid foo(){\n\t\tswitch(this){\n\t\t\tcase 0 : \n\t\t\t\tZork z;\n\t\t}\n\t}\n\t\n\tvoid bar(){\n\t\tswitch(x){\n\t\t\tcase 0 : \n\t\t\t\tZork z;\n\t\t}\n\t}\t\n}\n"}, this.complianceLevel >= 0x330000L ? newMessage : oldMessage);
    }

    public void test011() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String args[]) {\n\t\tswitch (args.length) {\n\t\t\tcase 1 :\n\t\t\t\tSystem.out.println();\n\t\t\tcase 3 :\n\t\t\t\tbreak;\n\t\t\tdefault :\n\t\t}\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test012() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    boolean x= true;\n    try {\n      int i= 1;\n      switch (i) { // <-- breakpoint here\n        case 1:\n          break;      //step 1 \n        case 2:\n          x = false;   //step 2 \n          break;\n      }\n    }catch(Exception e) {\n    }\n    System.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS");
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_1\n     1  istore_1 [x]\n     2  iconst_1\n     3  istore_2 [i]\n     4  iload_2 [i]\n     5  tableswitch default: 33\n          case 1: 28\n          case 2: 31\n    28  goto 37\n    31  iconst_0\n    32  istore_1 [x]\n    33  goto 37\n    36  astore_2\n    37  getstatic java.lang.System.out : java.io.PrintStream [16]\n    40  ldc <String \"SUCCESS\"> [22]\n    42  invokevirtual java.io.PrintStream.println(java.lang.String) : void [24]\n    45  return\n      Exception Table:\n        [pc: 2, pc: 33] -> 36 when : java.lang.Exception\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 4, line: 6]\n        [pc: 28, line: 8]\n        [pc: 31, line: 10]\n        [pc: 33, line: 13]\n        [pc: 37, line: 15]\n        [pc: 45, line: 16]\n      Local variable table:\n        [pc: 0, pc: 46] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 46] local: x index: 1 type: boolean\n        [pc: 4, pc: 33] local: i index: 2 type: int\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            SwitchTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test013() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tX x;\n\t\tObject o = null;\n\t\tfor (int i = 0; i < 10; i++) {\n\t\t\tif (i < 90) {\n\t\t\t\tx = new X();\n\t\t\t\tif (i > 4) {\n\t\t\t\t\to = new Object();\n\t\t\t\t} else {\n\t\t\t\t\to = null;\n\t\t\t\t}\n\t\t\t\tswitch (2) {\n\t\t\t\t\tcase 0:\n\t\t\t\t\t\tif (o instanceof String) {\n\t\t\t\t\t\t\tSystem.out.print(\"1\");\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\tdefault: {\n\t\t\t\t\t\tObject diff = o;\n\t\t\t\t\t\tif (diff != null) {\n\t\t\t\t\t\t\tSystem.out.print(\"2\");\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tSystem.out.print(\"3\");\t\t\t\t\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "333332323232323");
        String expectedOutput = new CompilerOptions(this.getCompilerOptions()).complianceLevel < 0x320000L ? "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 5\n  public static void main(java.lang.String[] args);\n      0  aconst_null\n      1  astore_2 [o]\n      2  iconst_0\n      3  istore_3 [i]\n      4  goto 103\n      7  iload_3 [i]\n      8  bipush 90\n     10  if_icmpge 100\n     13  new X [1]\n     16  dup\n     17  invokespecial X() [16]\n     20  astore_1 [x]\n     21  iload_3 [i]\n     22  iconst_4\n     23  if_icmple 37\n     26  new java.lang.Object [3]\n     29  dup\n     30  invokespecial java.lang.Object() [8]\n     33  astore_2 [o]\n     34  goto 39\n     37  aconst_null\n     38  astore_2 [o]\n     39  iconst_2\n     40  tableswitch default: 76\n          case 0: 60\n     60  aload_2 [o]\n     61  instanceof java.lang.String [17]\n     64  ifeq 92\n     67  getstatic java.lang.System.out : java.io.PrintStream [19]\n     70  ldc <String \"1\"> [25]\n     72  invokevirtual java.io.PrintStream.print(java.lang.String) : void [27]\n     75  return\n     76  aload_2 [o]\n     77  astore 4 [diff]\n     79  aload 4 [diff]\n     81  ifnull 92\n     84  getstatic java.lang.System.out : java.io.PrintStream [19]\n     87  ldc <String \"2\"> [33]\n     89  invokevirtual java.io.PrintStream.print(java.lang.String) : void [27]\n     92  getstatic java.lang.System.out : java.io.PrintStream [19]\n     95  ldc <String \"3\"> [35]\n     97  invokevirtual java.io.PrintStream.print(java.lang.String) : void [27]\n    100  iinc 3 1 [i]\n    103  iload_3 [i]\n    104  bipush 10\n    106  if_icmplt 7\n    109  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 2, line: 6]\n        [pc: 7, line: 7]\n        [pc: 13, line: 8]\n        [pc: 21, line: 9]\n        [pc: 26, line: 10]\n        [pc: 34, line: 11]\n        [pc: 37, line: 12]\n        [pc: 39, line: 14]\n        [pc: 60, line: 16]\n        [pc: 67, line: 17]\n        [pc: 75, line: 18]\n        [pc: 76, line: 23]\n        [pc: 79, line: 24]\n        [pc: 84, line: 25]\n        [pc: 92, line: 30]\n        [pc: 100, line: 6]\n        [pc: 109, line: 33]\n      Local variable table:\n        [pc: 0, pc: 110] local: args index: 0 type: java.lang.String[]\n        [pc: 21, pc: 100] local: x index: 1 type: X\n        [pc: 2, pc: 110] local: o index: 2 type: java.lang.Object\n        [pc: 4, pc: 109] local: i index: 3 type: int\n        [pc: 79, pc: 92] local: diff index: 4 type: java.lang.Object\n" : "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 5\n  public static void main(java.lang.String[] args);\n      0  aconst_null\n      1  astore_2 [o]\n      2  iconst_0\n      3  istore_3 [i]\n      4  goto 103\n      7  iload_3 [i]\n      8  bipush 90\n     10  if_icmpge 100\n     13  new X [1]\n     16  dup\n     17  invokespecial X() [16]\n     20  astore_1 [x]\n     21  iload_3 [i]\n     22  iconst_4\n     23  if_icmple 37\n     26  new java.lang.Object [3]\n     29  dup\n     30  invokespecial java.lang.Object() [8]\n     33  astore_2 [o]\n     34  goto 39\n     37  aconst_null\n     38  astore_2 [o]\n     39  iconst_2\n     40  tableswitch default: 76\n          case 0: 60\n     60  aload_2 [o]\n     61  instanceof java.lang.String [17]\n     64  ifeq 92\n     67  getstatic java.lang.System.out : java.io.PrintStream [19]\n     70  ldc <String \"1\"> [25]\n     72  invokevirtual java.io.PrintStream.print(java.lang.String) : void [27]\n     75  return\n     76  aload_2 [o]\n     77  astore 4 [diff]\n     79  aload 4 [diff]\n     81  ifnull 92\n     84  getstatic java.lang.System.out : java.io.PrintStream [19]\n     87  ldc <String \"2\"> [33]\n     89  invokevirtual java.io.PrintStream.print(java.lang.String) : void [27]\n     92  getstatic java.lang.System.out : java.io.PrintStream [19]\n     95  ldc <String \"3\"> [35]\n     97  invokevirtual java.io.PrintStream.print(java.lang.String) : void [27]\n    100  iinc 3 1 [i]\n    103  iload_3 [i]\n    104  bipush 10\n    106  if_icmplt 7\n    109  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 2, line: 6]\n        [pc: 7, line: 7]\n        [pc: 13, line: 8]\n        [pc: 21, line: 9]\n        [pc: 26, line: 10]\n        [pc: 34, line: 11]\n        [pc: 37, line: 12]\n        [pc: 39, line: 14]\n        [pc: 60, line: 16]\n        [pc: 67, line: 17]\n        [pc: 75, line: 18]\n        [pc: 76, line: 23]\n        [pc: 79, line: 24]\n        [pc: 84, line: 25]\n        [pc: 92, line: 30]\n        [pc: 100, line: 6]\n        [pc: 109, line: 33]\n      Local variable table:\n        [pc: 0, pc: 110] local: args index: 0 type: java.lang.String[]\n        [pc: 21, pc: 100] local: x index: 1 type: X\n        [pc: 2, pc: 110] local: o index: 2 type: java.lang.Object\n        [pc: 4, pc: 109] local: i index: 3 type: int\n        [pc: 79, pc: 92] local: diff index: 4 type: java.lang.Object\n      Stack map table: number of frames 8\n        [pc: 7, full, stack: {}, locals: {java.lang.String[], _, java.lang.Object, int}]\n        [pc: 37, full, stack: {}, locals: {java.lang.String[], X, java.lang.Object, int}]\n        [pc: 39, same]\n        [pc: 60, same]\n        [pc: 76, same]\n        [pc: 92, same]\n        [pc: 100, full, stack: {}, locals: {java.lang.String[], _, java.lang.Object, int}]\n        [pc: 103, same]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            SwitchTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test014() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo1(int i) {\n\t\tswitch (i) {\n\t\t\tcase 0://OK\n\t\t\tcase 1://OK\n\t\t\t\tSystem.out.println();\n\t\t\t\t//$FALL-THROUGH$\n\t\t\tcase 2://OK\n\t\t\t\tSystem.out.println(); //$FALL-THROUGH$\n\t\t\tcase 3://OK\n\t\t\t\tSystem.out.println();\n\t\t\t\t//$FALL-THROUGH$ - some allowed explanation\n\t\t\tcase 4://OK\n\t\t\tcase 5://OK\n\t\t\t\tSystem.out.println();\n\t\t\t\t//$FALL-THROUGH$ - not last comment, thus inoperant\n\t\t\t\t// last comment is not fall-through explanation\n\t\t\tcase 6://WRONG\n\t\t\t\t//$FALL-THROUGH$ - useless since not leading the case\n\t\t\t\tSystem.out.println();\n\t\t\t\t/*$FALL-THROUGH$ - block comment, is also allowed */\n\t\t\tcase 7://OK\n\t\t\t\tSystem.out.println(\"aa\"); //$NON-NLS-1$\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tcase 6://WRONG\n\t^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", null, true, options);
    }

    public void test015() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo1(int i) {\n\t\tswitch (i) {\n\t\t\tcase 0://OK\n\t\t\tcase 1://OK\n\t\t\t\tSystem.out.println();\n\t\t\t\t//\t  $FALL-THROUGH$\n\t\t\tcase 2://OK\n\t\t\t\tSystem.out.println(); // \t $FALL-THROUGH$\n\t\t\tcase 3://OK\n\t\t\t\tSystem.out.println();\n\t\t\t\t//\t$FALL-THROUGH$ - some allowed explanation\n\t\t\tcase 4://OK\n\t\t\tcase 5://OK\n\t\t\t\tSystem.out.println();\n\t\t\t\t// $FALL-THROUGH$ - not last comment, thus inoperant\n\t\t\t\t// last comment is not fall-through explanation\n\t\t\tcase 6://WRONG\n\t\t\t\t// $FALL-THROUGH$ - useless since not leading the case\n\t\t\t\tSystem.out.println();\n\t\t\t\t/* $FALL-THROUGH$ - block comment, is also allowed */\n\t\t\tcase 7://OK\n\t\t\t\tSystem.out.println(\"aa\"); //$NON-NLS-1$\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tcase 6://WRONG\n\t^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", null, true, options);
    }

    public void test016() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo1(int i) {\n\t\tswitch (i) {\n\t\t\tcase 0://OK\n\t\t\tcase 1://OK\n\t\t\t\tSystem.out.println();\n\t\t\t\t//\t  $FALL-THROUGH - missing trailing $ in tag\n\t\t\tcase 2://WRONG\n\t\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase 2://WRONG\n\t^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", null, true, options);
    }

    public void test017() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo1(char previousChar) {\n\t\tswitch(previousChar) {\n\t\t\tcase '/':\n\t\t\t\tif (previousChar == '*') {\n\t\t\t\t\t// End of javadoc\n\t\t\t\t\tbreak;\n\t\t\t\t\t//$FALL-THROUGH$ into default case\n\t\t\t\t}\n\t\t\tdefault :\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tdefault :\n\t^^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", null, true, options);
    }

    public void test018() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public static void foo(int i) { \n    switch (i) {\n    }\n  }\n}\n"}, new ASTVisitor(){

            public boolean visit(SingleNameReference reference, BlockScope scope) {
                SwitchTest.assertNotNull((String)"No scope", (Object)scope);
                return true;
            }
        });
    }

    public void test019() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tswitch((Integer) null) {};\n\t\t\tSystem.out.println(\"FAILED\");\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test020() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tswitch(foo()) {};\n\t\t\tSystem.out.println(\"FAILED\");\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\tstatic Integer foo() {\n\t\treturn (Integer) null;\n\t}\n}\n"}, "SUCCESS");
    }

    public void test021() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tswitch((Character) null) {\n\t\t\t\tdefault: System.out.println(\"FAILED\");\n\t\t\t}\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test022() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tjava.math.RoundingMode mode = null;\n\t\ttry {\n\t\t\tswitch (mode) {}\n\t\t\tSystem.out.println(\"FAILED\");\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test023() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tjava.math.RoundingMode mode = java.math.RoundingMode.FLOOR;\n\t\ttry {\n\t\t\tswitch (mode) {\n\t\t\t\tdefault: System.out.println(\"SUCCESS\");\n\t\t\t}\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"FAILED\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void testStringSwitchAtJDK6() {
        String newMessage = "----------\n1. ERROR in X.java (at line 4)\n\tdefault: return args;\n\t         ^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n";
        String oldMessage = "----------\n1. ERROR in X.java (at line 3)\n\tswitch(args[0]) {\n\t       ^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n2. ERROR in X.java (at line 4)\n\tdefault: return args;\n\t         ^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tswitch(args[0]) {\n\t\tdefault: return args;\n\t\t}\n\t}\n}\n"}, this.complianceLevel >= 0x330000L ? newMessage : oldMessage);
    }

    public void testCaseTypeMismatch() {
        String newMessage = "----------\n1. ERROR in X.java (at line 4)\n\tcase 123: break;\n\t     ^^^\nType mismatch: cannot convert from int to String\n----------\n2. ERROR in X.java (at line 5)\n\tcase (byte) 1: break;\n\t     ^^^^^^^^\nType mismatch: cannot convert from byte to String\n----------\n3. ERROR in X.java (at line 6)\n\tcase (char) 2: break;\n\t     ^^^^^^^^\nType mismatch: cannot convert from char to String\n----------\n4. ERROR in X.java (at line 7)\n\tcase (short)3: break;\n\t     ^^^^^^^^\nType mismatch: cannot convert from short to String\n----------\n5. ERROR in X.java (at line 8)\n\tcase (int) 4: break;\n\t     ^^^^^^^\nType mismatch: cannot convert from int to String\n----------\n6. ERROR in X.java (at line 9)\n\tcase (long) 5: break;\n\t     ^^^^^^^^\nType mismatch: cannot convert from long to String\n----------\n7. ERROR in X.java (at line 10)\n\tcase (float) 6: break;\n\t     ^^^^^^^^^\nType mismatch: cannot convert from float to String\n----------\n8. ERROR in X.java (at line 11)\n\tcase (double) 7: break;\n\t     ^^^^^^^^^^\nType mismatch: cannot convert from double to String\n----------\n9. ERROR in X.java (at line 12)\n\tcase (boolean) 8: break;\n\t     ^^^^^^^^^^^\nCannot cast from int to boolean\n----------\n10. ERROR in X.java (at line 12)\n\tcase (boolean) 8: break;\n\t     ^^^^^^^^^^^\nType mismatch: cannot convert from boolean to String\n----------\n";
        String oldMessage = "----------\n1. ERROR in X.java (at line 3)\n\tswitch(args[0]) {\n\t       ^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n2. ERROR in X.java (at line 12)\n\tcase (boolean) 8: break;\n\t     ^^^^^^^^^^^\nCannot cast from int to boolean\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tswitch(args[0]) {\n\t\tcase 123: break;\n       case (byte) 1: break;\n       case (char) 2: break;\n       case (short)3: break;\n       case (int) 4: break;\n       case (long) 5: break;\n       case (float) 6: break;\n       case (double) 7: break;\n       case (boolean) 8: break;\n\t\t}\n\t}\n}\n"}, this.complianceLevel >= 0x330000L ? newMessage : oldMessage);
    }

    public void testCaseTypeMismatch2() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        String newMessage = "----------\n1. ERROR in X.java (at line 7)\n\tcase Days.Sunday: break;\n\t     ^^^^^^^^^^^\nType mismatch: cannot convert from Days to String\n----------\n";
        String oldMessage = "----------\n1. ERROR in X.java (at line 6)\n\tswitch (\"Sunday\") {\n\t        ^^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "enum Days { Sunday, Monday, Tuesday, Wednesday, Thuresday, Friday, Satuday };\n\npublic class X {\n\n    public static void main(String argv[]) {\n        switch (\"Sunday\") {\n            case Days.Sunday: break;\n        }\n    }\n}\n"}, this.complianceLevel >= 0x330000L ? newMessage : oldMessage);
    }

    public void testCaseTypeMismatch3() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        String newMessage = "----------\n1. ERROR in X.java (at line 7)\n\tcase \"0\": break;\n\t     ^^^\nType mismatch: cannot convert from String to int\n----------\n2. ERROR in X.java (at line 10)\n\tcase \"Sunday\": break;\n\t     ^^^^^^^^\nType mismatch: cannot convert from String to Days\n----------\n3. ERROR in X.java (at line 13)\n\tcase \"0\": break;\n\t     ^^^\nType mismatch: cannot convert from String to Integer\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "enum Days { Sunday, Monday, Tuesday, Wednesday, Thuresday, Friday, Satuday };\n\npublic class X {\n\n    public static void main(String argv[]) {\n        switch (argv.length) {\n            case \"0\": break;\n        }\n        switch(Days.Sunday) {\n            case \"Sunday\": break;\n        }\n        switch (Integer.valueOf(argv.length)) {\n            case \"0\": break;\n        }\n    }\n}\n"}, newMessage);
    }

    public void testDuplicateCase() {
        String newMessage = "----------\n1. ERROR in X.java (at line 4)\n\tcase \"123\": break;\n\t^^^^^^^^^^\nDuplicate case\n----------\n2. ERROR in X.java (at line 5)\n\tcase \"123\": break;\n\t^^^^^^^^^^\nDuplicate case\n----------\n3. ERROR in X.java (at line 6)\n\tdefault: return args;\n\t         ^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n";
        String oldMessage = "----------\n1. ERROR in X.java (at line 3)\n\tswitch(args[0]) {\n\t       ^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n2. ERROR in X.java (at line 6)\n\tdefault: return args;\n\t         ^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tswitch(args[0]) {\n\t\tcase \"123\": break;\n\t\tcase \"123\": break;\n       default: return args;\n\t\t}\n\t}\n}\n"}, this.complianceLevel >= 0x330000L ? newMessage : oldMessage);
    }

    public void testDuplicateCase2() {
        String newMessage = "----------\n1. ERROR in X.java (at line 9)\n\tcase \"123\": break;\n\t^^^^^^^^^^\nDuplicate case\n----------\n2. ERROR in X.java (at line 10)\n\tcase \"123\": break;\n\t^^^^^^^^^^\nDuplicate case\n----------\n3. ERROR in X.java (at line 11)\n\tcase \"1\" + \"2\" + \"3\": break;\n\t^^^^^^^^^^^^^^^^^^^^\nDuplicate case\n----------\n4. ERROR in X.java (at line 13)\n\tcase local: break;\n\t^^^^^^^^^^\nDuplicate case\n----------\n5. ERROR in X.java (at line 14)\n\tcase field: break;\n\t^^^^^^^^^^\nDuplicate case\n----------\n6. ERROR in X.java (at line 15)\n\tcase ifield: break;\n\t     ^^^^^^\nCannot make a static reference to the non-static field ifield\n----------\n7. ERROR in X.java (at line 16)\n\tcase inffield: break;\n\t     ^^^^^^^^\nCannot make a static reference to the non-static field inffield\n----------\n8. ERROR in X.java (at line 19)\n\tdefault: break;\n\t^^^^^^^\nThe default case is already defined\n----------\n";
        String oldMessage = "----------\n1. ERROR in X.java (at line 8)\n\tswitch(args[0]) {\n\t       ^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n2. ERROR in X.java (at line 15)\n\tcase ifield: break;\n\t     ^^^^^^\nCannot make a static reference to the non-static field ifield\n----------\n3. ERROR in X.java (at line 16)\n\tcase inffield: break;\n\t     ^^^^^^^^\nCannot make a static reference to the non-static field inffield\n----------\n4. ERROR in X.java (at line 19)\n\tdefault: break;\n\t^^^^^^^\nThe default case is already defined\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static final String field = \"123\";\n    final String ifield = \"123\";\n    String inffield = \"123\";\n    static String nffield = \"123\";\n    public static void main(String [] args, final String argument) {\n        final String local = \"123\";\n\tswitch(args[0]) {\n\t   case \"123\": break;\n      case \"123\": break;\n\t   case \"1\" + \"2\" + \"3\": break;\n           default: break;\n\t   case local: break;\n           case field: break;\n           case ifield: break;\n           case inffield: break;\n           case nffield: break;\n           case argument: break;\n           default: break;\n\t}\n    }\n}\n"}, this.complianceLevel >= 0x330000L ? newMessage : oldMessage);
    }

    public void testVariableCase() {
        String newMessage = "----------\n1. ERROR in X.java (at line 7)\n\tcase local: break;\n\t     ^^^^^\ncase expressions must be constant expressions\n----------\n2. ERROR in X.java (at line 8)\n\tcase argument: break;\n\t     ^^^^^^^^\ncase expressions must be constant expressions\n----------\n3. ERROR in X.java (at line 9)\n\tcase inffield: break;\n\t     ^^^^^^^^\ncase expressions must be constant expressions\n----------\n4. ERROR in X.java (at line 10)\n\tcase nffield: break;\n\t     ^^^^^^^\ncase expressions must be constant expressions\n----------\n5. ERROR in X.java (at line 11)\n\tcase argument: break;\n\t     ^^^^^^^^\ncase expressions must be constant expressions\n----------\n";
        String oldMessage = "----------\n1. ERROR in X.java (at line 6)\n\tswitch(args[0]) {\n\t       ^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    String inffield = \"123\";\n    static String nffield = \"123\";\n    public void main(String [] args, final String argument) {\n        String local = \"123\";\n\tswitch(args[0]) {\n\t   case local: break;\n\t   case argument: break;\n      case inffield: break;\n      case nffield: break;\n      case argument: break;\n\t}\n    }\n}\n"}, this.complianceLevel >= 0x330000L ? newMessage : oldMessage);
    }

    public void testVariableCaseFinal() {
        String newMessage = "----------\n1. ERROR in X.java (at line 8)\n\tcase argument: break;\n\t     ^^^^^^^^\ncase expressions must be constant expressions\n----------\n2. ERROR in X.java (at line 11)\n\tcase argument: break;\n\t     ^^^^^^^^\ncase expressions must be constant expressions\n----------\n";
        String oldMessage = "----------\n1. ERROR in X.java (at line 6)\n\tswitch(args[0]) {\n\t       ^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    final String inffield = \"12312\";\n    final static String nffield = \"123123\";\n    public void main(String [] args, final String argument) {\n        final String local = \"1233\";\n\tswitch(args[0]) {\n\t   case local: break;\n\t   case argument: break;\n      case inffield: break;\n      case nffield: break;\n      case argument: break;\n\t}\n    }\n}\n"}, this.complianceLevel >= 0x330000L ? newMessage : oldMessage);
    }

    public void testNullCase() {
        String newMessage = "----------\n1. ERROR in X.java (at line 7)\n\tcase local: break;\n\t     ^^^^^\ncase expressions must be constant expressions\n----------\n2. ERROR in X.java (at line 8)\n\tcase argument: break;\n\t     ^^^^^^^^\ncase expressions must be constant expressions\n----------\n3. ERROR in X.java (at line 9)\n\tcase inffield: break;\n\t     ^^^^^^^^\ncase expressions must be constant expressions\n----------\n4. ERROR in X.java (at line 10)\n\tcase nffield: break;\n\t     ^^^^^^^\ncase expressions must be constant expressions\n----------\n5. ERROR in X.java (at line 11)\n\tcase (String) null: break;\n\t     ^^^^^^^^^^^^^\ncase expressions must be constant expressions\n----------\n6. ERROR in X.java (at line 12)\n\tcase true ? (String) null : (String) null : break;\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\ncase expressions must be constant expressions\n----------\n7. WARNING in X.java (at line 12)\n\tcase true ? (String) null : (String) null : break;\n\t                            ^^^^^^^^^^^^^\nDead code\n----------\n";
        String oldMessage = "----------\n1. ERROR in X.java (at line 6)\n\tswitch(args[0]) {\n\t       ^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    final String inffield = null;\n    final static String nffield = null;\n    public void main(String [] args, final String argument) {\n        final String local = null;\n\tswitch(args[0]) {\n\t   case local: break;\n\t   case argument: break;\n      case inffield: break;\n      case nffield: break;\n      case (String) null: break;\n      case true ? (String) null : (String) null : break;\n\t}\n    }\n}\n"}, this.complianceLevel >= 0x330000L ? newMessage : oldMessage);
    }

    public void testDuplicateCase3() {
        String newMessage = "----------\n1. ERROR in X.java (at line 9)\n\tcase \"123\": break;\n\t^^^^^^^^^^\nDuplicate case\n----------\n2. ERROR in X.java (at line 10)\n\tcase \"1\" + \"2\" + \"3\": break;\n\t^^^^^^^^^^^^^^^^^^^^\nDuplicate case\n----------\n3. ERROR in X.java (at line 12)\n\tcase local: break;\n\t^^^^^^^^^^\nDuplicate case\n----------\n4. ERROR in X.java (at line 13)\n\tcase field: break;\n\t^^^^^^^^^^\nDuplicate case\n----------\n5. ERROR in X.java (at line 14)\n\tcase ifield: break;\n\t^^^^^^^^^^^\nDuplicate case\n----------\n6. ERROR in X.java (at line 18)\n\tdefault: break;\n\t^^^^^^^\nThe default case is already defined\n----------\n";
        String oldMessage = "----------\n1. ERROR in X.java (at line 8)\n\tswitch(args[0]) {\n\t       ^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n2. ERROR in X.java (at line 18)\n\tdefault: break;\n\t^^^^^^^\nThe default case is already defined\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static final String field = \"123\";\n    final String ifield = \"123\";\n    String inffield = \"123\";\n    static String nffield = \"123\";\n    public  void main(String [] args, final String argument) {\n        final String local = \"123\";\n\tswitch(args[0]) {\n\t   case \"123\": break;\n\t   case \"1\" + \"2\" + \"3\": break;\n           default: break;\n\t   case local: break;\n           case field: break;\n           case ifield: break;\n           case inffield: break;\n           case nffield: break;\n           case argument: break;\n           default: break;\n\t}\n    }\n}\n"}, this.complianceLevel >= 0x330000L ? newMessage : oldMessage);
    }

    public void testDuplicateHashCode() {
        String errorMsg = "----------\n1. ERROR in testDuplicateHashCode.java (at line 5)\n\tswitch (dispatcher) {\n\t        ^^^^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"testDuplicateHashCode.java", "public class testDuplicateHashCode {\n\tpublic static void main(String[] argv) {\n\t\tString dispatcher = \"\u0000\";\n\t\touter: for (int i = 0; i < 100; i++) {\n\t\t\tswitch (dispatcher) {\n\t\t\tcase \"\u0000\":\n\t\t\t\tSystem.out.print(\"1 \");\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"2 \");\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"3 \");\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"4 \");\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"5 \");\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tSystem.out.println(\"Default\");\n\t\t\t\tbreak outer;\n\t\t\tcase \"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"8 \");\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"7 \");\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\u0000\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"6 \");\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tdispatcher += \"\u0000\";\n\t\t}\n\t}\n}\n"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "1 2 3 4 5 6 7 8 Default");
        }
    }

    public void testDuplicateHashCode2() {
        String errorMsg = "----------\n1. ERROR in testDuplicateHashCode.java (at line 5)\n\tswitch (dispatcher) {\n\t        ^^^^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"testDuplicateHashCode.java", "public class testDuplicateHashCode {\n\tpublic static void main(String[] argv) {\n\t\tString dispatcher = \"\u0000\";\n\t\touter: while(true) {\n\t\t\tswitch (dispatcher) {\n\t\t\tcase \"\u0000\":\n\t\t\t\tSystem.out.print(\"1 \");\n               dispatcher += \"\u0000\u0000\";\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"2 \");\n               dispatcher = \"\";\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"3 \");\n               dispatcher += \"\u0000\u0000\";\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"4 \");\n               dispatcher = \"\u0000\u0000\";\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"5 \");\n               dispatcher += \"\u0000\u0000\";\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tSystem.out.println(\"Default\");\n\t\t\t\tbreak outer;\n\t\t\tcase \"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"8 \");\n               dispatcher = \"\u0000\u0000\u0000\u0000\u0000\u0000\";\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"7 \");\n               dispatcher += \"\u0000\";\n\t\t\t\tbreak;\n\t\t\tcase \"\u0000\u0000\u0000\u0000\u0000\u0000\":\n\t\t\t\tSystem.out.print(\"6 \");\n               dispatcher = \"\u0000\u0000\u0000\u0000\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t}\n}\n"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "1 3 5 7 8 6 4 2 Default");
        }
    }

    public void testSwitchOnNull() {
        String errorMsg = "----------\n1. ERROR in testSwitchOnNull.java (at line 13)\n\tswitch (s) {\n\t        ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n2. ERROR in testSwitchOnNull.java (at line 23)\n\tswitch ((String) null) {\n\t        ^^^^^^^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n3. ERROR in testSwitchOnNull.java (at line 33)\n\tswitch (someMethod()) {\n\t        ^^^^^^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n4. ERROR in testSwitchOnNull.java (at line 40)\n\tswitch (nullString) {\n\t        ^^^^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n5. ERROR in testSwitchOnNull.java (at line 47)\n\tswitch (someMethod()) {\n\t        ^^^^^^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"testSwitchOnNull.java", "public class testSwitchOnNull {\n\n    private static String someMethod() {\n        return null;\n    }\n\n    static String nullString = null;\n    public static void main(String [] args) {\n\n        String s = null;\n\n        try {\n            switch (s) {\n                default: \n                    System.out.println(\"OOPS\");\n\t            break;\n            }\n            System.out.println(\"OOPS\");\n        } catch (NullPointerException e) {\n            System.out.print(\"NPE1\");\n        }\n        try {\n            switch ((String) null) {\n                default: \n                    System.out.println(\"OOPS\");\n\t            break;\n            }\n            System.out.println(\"OOPS\");\n        } catch (NullPointerException e) {\n            System.out.print(\"NPE2\");\n        }\n        try {\n            switch (someMethod()) {\n            }\n            System.out.println(\"OOPS\");\n        } catch (NullPointerException e) {\n            System.out.print(\"NPE3\");\n        }\n        try {\n            switch (nullString) {\n            }\n            System.out.println(\"OOPS\");\n        } catch (NullPointerException e) {\n            System.out.print(\"NPE4\");\n        }\n        try {\n            switch (someMethod()) {\n                default: \n                    System.out.println(\"OOPS\");\n\t            break;\n            }\n            System.out.println(\"OOPS\");\n        } catch (NullPointerException e) {\n            System.out.print(\"NPE5\");\n        }\n    }\n}\n"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "NPE1NPE2NPE3NPE4NPE5");
        }
    }

    public void testSideEffect() {
        String errorMsg = "----------\n1. ERROR in testSideEffect.java (at line 11)\n\tswitch(dispatcher()) {\n\t       ^^^^^^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"testSideEffect.java", "public class testSideEffect {\n    static boolean firstTime = true;\n\tprivate static String dispatcher() {\n    \tif (!firstTime) {\n\t\tSystem.out.print(\"OOPS\");\n    \t}\n    \tfirstTime = false;\n    \treturn \"\u0000\";\n    }\n    public static void main(String [] args) {\n    \t\tswitch(dispatcher()) {\n    \t\tcase \"\u0000\u0000\": break;\n    \t\tcase \"\u0000\u0000\u0000\":\tbreak;\n    \t\tcase \"\u0000\u0000\u0000\u0000\": break;\n    \t\tcase \"\u0000\u0000\u0000\u0000\u0000\": break;\n    \t\tdefault: System.out.println(\"DONE\");\n    \t\t}\n    }\n}\n"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "DONE");
        }
    }

    public void testFallThrough() {
        String errorMsg = "----------\n1. ERROR in testFallThrough.java (at line 11)\n\tswitch(s = dispatcher()) {\n\t       ^^^^^^^^^^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"testFallThrough.java", "public class testFallThrough {\n    static int index = -1;\n    static String string = \"0123456789*\";\n    private static String dispatcher() {\n    \tindex++;\n     \treturn string.substring(index,index + 1);\n    }\n    public static void main(String [] args) {\n    \touter: while (true) {\n    \t\tString s = null;\n    \t\tswitch(s = dispatcher()) {\n    \t\tcase \"2\":\n    \t\tcase \"0\":\n    \t\tcase \"4\":\n    \t\tcase \"8\":\n    \t\tcase \"6\":\n    \t\t\t\tSystem.out.print(s + \"(even) \");\n    \t\t\t\tbreak;\n    \t\tcase \"1\":\n    \t\tcase \"3\":\n    \t\tcase \"9\":\n    \t\tcase \"5\":\n    \t\tcase \"7\":\n    \t\t\t\tSystem.out.print(s + \"(odd) \");\n    \t\t\t\tbreak;\n    \t\tdefault: System.out.print(\"DONE\");\n    \t\t\t\tbreak outer;\n    \t\t}\n    \t}\n    }\n}\n"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "0(even) 1(odd) 2(even) 3(odd) 4(even) 5(odd) 6(even) 7(odd) 8(even) 9(odd) DONE");
        }
    }

    public void testFallThrough2() {
        String errorMsg = "----------\n1. ERROR in testFallThrough.java (at line 11)\n\tswitch(s = dispatcher()) {\n\t       ^^^^^^^^^^^^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"testFallThrough.java", "public class testFallThrough {\n    static int index = -1;\n    static String string = \"0123456789*\";\n    private static String dispatcher() {\n    \tindex++;\n     \treturn string.substring(index,index + 1);\n    }\n    public static void main(String [] args) {\n    \touter: while (true) {\n    \t\tString s = null;\n    \t\tswitch(s = dispatcher()) {\n    \t\tcase \"4\": System.out.print(s);\n    \t\tcase \"3\": System.out.print(s);\n    \t\tcase \"2\": System.out.print(s);\n    \t\tcase \"1\": System.out.print(s + \" \");\n    \t\tcase \"0\": break;\n    \t\tdefault: System.out.print(\"DONE\");\n    \t\t\t\tbreak outer;\n    \t\t}\n    \t}\n    }\n}\n"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "1 22 333 4444 DONE");
        }
    }

    public void testMarysLamb() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        String errorMsg = "----------\n1. ERROR in testMarysLamb.java (at line 4)\n\tswitch(s) {\n\t       ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"testMarysLamb.java", "public class testMarysLamb {\n    public static void main(String [] args) {\n    \tfor (String s : new String [] { \"Mary\", \"Had\", \"A\", \"Little\", \"Lamb\" }) {\n    \t\tswitch(s) {\n    \t\t\tdefault: System.out.print(s + \" \");\n    \t\t}\n    \t}\n    }\n}\n"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "Mary Had A Little Lamb");
        }
    }

    public void testBreakOut() {
        String errorMsg = "----------\n1. ERROR in testBreakOut.java (at line 5)\n\tswitch(s) {\n\t       ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"testBreakOut.java", "public class testBreakOut {\n    public static void main(String [] args) {\n    \tjunk: while (true) {\n    \t\tString s = \"\";\n    \t\tswitch(s) {\n    \t\tcase \"7\":\n    \t\t\t\tSystem.out.print(s + \"(odd) \");\n    \t\t\t\tbreak;\n    \t\tdefault: System.out.print(\"DONE\");\n    \t\t\t\t break junk;\n    \t\t}\n    \t}\n    }\n}\n"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "DONE");
        }
    }

    public void testMultipleSwitches() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        String errorMsg = "----------\n1. ERROR in X.java (at line 6)\n\tswitch (s) {\n\t        ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n2. ERROR in X.java (at line 35)\n\tswitch (s) {\n\t        ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n3. ERROR in X.java (at line 51)\n\tswitch (s) {\n\t        ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\t\n\t\tfor (String s: new String [] { \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\", \"DONE\"}) {\n\t\t\tswitch (s) {\n\t\t\tcase \"Sunday\" : \n\t\t\t\tSystem.out.print(\"Sunday\");\n\t\t\t\tbreak;\n\t\t\tcase \"Monday\" :\n\t\t\t\tSystem.out.print(\"Monday\");\n\t\t\t\tbreak;\n\t\t\tcase \"Tuesday\" :\n\t\t\t\tSystem.out.print(\"Tuesday\");\n\t\t\t\tbreak;\n\t\t\tcase \"Wednesday\":\n\t\t\t\tSystem.out.print(\"Wednesday\");\n\t\t\t\tbreak;\n\t\t\tcase \"Thursday\":\n\t\t\t\tSystem.out.print(\"Thursday\");\n\t\t\t\tbreak;\n\t\t\tcase \"Friday\":\n\t\t\t\tSystem.out.print(\"Friday\");\n\t\t\t\tbreak;\n\t\t\tcase \"Saturday\":\n\t\t\t\tSystem.out.print(\"Saturday\");\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tSystem.out.print(\" ---- \");\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t  \n\t\tfor (String s: new String [] { \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\", \"DONE\"}) {\n\t\t\tswitch (s) {\n\t\t\tcase \"Sunday\" : \n\t\t\tcase \"Monday\" :\n\t\t\tcase \"Tuesday\" :\n\t\t\tcase \"Wednesday\":\n\t\t\tcase \"Thursday\":\n\t\t\tcase \"Friday\":\n\t\t\tcase \"Saturday\":\n\t\t\t\tSystem.out.print(s);\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tSystem.out.print(\" ---- \");\n\t\t\t\tbreak;\n\t\t\t}\t\n\t\t}\n\t\tfor (String s: new String [] { \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\", \"DONE\"}) {\n\t\t\tswitch (s) {\n\t\t\tcase \"Saturday\":\n\t\t\tcase \"Sunday\" : \n\t\t\t\tSystem.out.print(\"Holiday\");\n\t\t\t\tbreak;\n\t\t\tcase \"Monday\" :\n\t\t\tcase \"Tuesday\" :\n\t\t\tcase \"Wednesday\":\n\t\t\tcase \"Thursday\":\n\t\t\tcase \"Friday\":\n\t\t\t\tSystem.out.print(\"Workday\");\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tSystem.out.print(\" DONE\");\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t}\n\n}\n"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "SundayMondayTuesdayWednesdayThursdayFridaySaturday ---- SundayMondayTuesdayWednesdayThursdayFridaySaturday ---- HolidayWorkdayWorkdayWorkdayWorkdayWorkdayHoliday DONE");
        }
    }

    public void testNestedSwitches() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        String errorMsg = "----------\n1. ERROR in X.java (at line 4)\n\tswitch (s) {\n\t        ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n2. ERROR in X.java (at line 7)\n\tswitch (s) {\n\t        ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n3. ERROR in X.java (at line 18)\n\tswitch (s) {\n\t        ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tfor (String s: new String [] { \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\", \"DONE\"}) {\n\t\t\tswitch (s) {\n\t\t\tcase \"Saturday\":\n\t\t\tcase \"Sunday\" : \n\t\t\t\tswitch (s) {\n\t\t\t\t\tcase \"Saturday\" : System.out.println (\"Saturday is a holiday\"); break;\n\t\t\t\t\tcase \"Sunday\"  :  System.out.println (\"Sunday is a holiday\"); break;\n\t\t\t\t\tdefault:          System.out.println(\"Broken\");\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase \"Monday\" :\n\t\t\tcase \"Tuesday\" :\n\t\t\tcase \"Wednesday\":\n\t\t\tcase \"Thursday\":\n\t\t\tcase \"Friday\":\n\t\t\t\tswitch (s) {\n\t\t\t\t\tcase \"Monday\" :  System.out.println (\"Monday is a workday\"); break;\n\t\t\t\t\tcase \"Tuesday\" : System.out.println (\"Tuesday is a workday\"); break;\n\t\t\t\t\tcase \"Wednesday\": System.out.println (\"Wednesday is a workday\"); break;\n\t\t\t\t\tcase \"Thursday\": System.out.println (\"Thursday is a workday\"); break;\n\t\t\t\t\tcase \"Friday\":System.out.println (\"Friday is a workday\"); break;\n\t\t\t\t\tdefault: System.out.println(\"Broken\");\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tSystem.out.println(\"DONE\");\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t}\n}\n"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "Sunday is a holiday\nMonday is a workday\nTuesday is a workday\nWednesday is a workday\nThursday is a workday\nFriday is a workday\nSaturday is a holiday\nDONE");
        }
    }

    public void testFor356002() {
        String errorMsg = "----------\n1. ERROR in X.java (at line 6)\n\tswitch (foo()) {\n\t        ^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n\tprivate static String foo() {\n\t\treturn \"\";\n\t}\n\tpublic static void main(String[] args) {\n\t\tswitch (foo()) {\n\t\t\tdefault: {\n\t\t\t\tint j = 0;\n\t\t\t\tif (j <= 0)\n\t\t\t\t\tSystem.out.println(\"DONE\");\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\t}\n}"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "DONE");
        }
    }

    public void testFor356002_2() {
        String errorMsg = "----------\n1. ERROR in X.java (at line 3)\n\tswitch (\"\") {\n\t        ^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tswitch (\"\") {\n\t\t\tdefault: {\n\t\t\t\tint j = 0;\n\t\t\t\tif (j <= 0)\n\t\t\t\t\tSystem.out.println(\"DONE\");\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\t}\n}"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "DONE");
        }
    }

    public void testFor356002_3() {
        String errorMsg = "----------\n1. ERROR in X.java (at line 7)\n\tswitch (foo()) {\n\t        ^^^^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n\tprivate static String foo() {\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tswitch (foo()) {\n\t\t\t\tdefault: {\n\t\t\t\t\tint j = 0;\n\t\t\t\t\tif (j <= 0)\n\t\t\t\t\t\t;\n\t\t\t\t}\n\t\t\t\treturn;\n\t\t\t}\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"DONE\");\n\t\t}\n\t}\n}"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "DONE");
        }
    }

    public void testBug374605() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nclass X {\n  void v(int i) {\n    switch (i) {\n      case 1 :\n        break;\n      case 2 :\n        break;\n    }\n  }\n}"}, "----------\n1. WARNING in p\\X.java (at line 4)\n\tswitch (i) {\n\t        ^\nThe switch statement should have a default case\n----------\n", null, true, options);
    }

    public void testBug380927() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static Object f() {\n        final Object a = null;\n        Object b;\n        label: do {\n            switch (0) {\n            case 1: {\n                b = a;\n            }\n                break;\n            default:\n                break label;\n            }\n        } while (true);\n        return a;\n    }\n    public static void main(final String[] args) {\n        f();\n        System.out.println(\"Success\");\n    }\n}\n"}, "Success");
    }

    public void testBug380927a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static Object f() {\n        final Object a = null;\n        Object b;\n        label: while (true) {\n            switch (0) {\n            case 1: {\n                b = a;\n            }\n                break;\n            default:\n                break label;\n            }\n        }\n        return a;\n    }\n    public static void main(final String[] args) {\n        f();\n        System.out.println(\"Success\");\n    }\n}\n"}, "Success");
    }

    public void testBug380927b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static Object f() {\n        final Object a = null;\n        Object b;\n        label: for(;;) {\n            switch (0) {\n            case 1: {\n                b = a;\n            }\n                break;\n            default:\n                break label;\n            }\n        }\n        return a;\n    }\n    public static void main(final String[] args) {\n        f();\n        System.out.println(\"Success\");\n    }\n}\n"}, "Success");
    }

    public void testBug380927c() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static Object f() {\n        final Object a = null;\n        Object b;\n        label: for(int i : new int [] { 10 }) {\n            switch (0) {\n            case 1: {\n                b = a;\n            }\n                break;\n            default:\n                break label;\n            }\n        }\n        return a;\n    }\n    public static void main(final String[] args) {\n        f();\n        System.out.println(\"Success\");\n    }\n}\n"}, "Success");
    }

    public void testBug380927d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        Object b;\n        label: do {\n            switch (0) {\n            case 1:\n                b = null;\n                break;\n            default:\n                break label;\n            }\n        } while (true);\n        System.out.println(b);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tSystem.out.println(b);\n\t                   ^\nThe local variable b may not have been initialized\n----------\n");
    }

    public void testBug380927e() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        Object b;\n        label: while (true) {\n            switch (0) {\n            case 1:\n                b = null;\n                break;\n            default:\n                break label;\n            }\n        }\n        System.out.println(b);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tSystem.out.println(b);\n\t                   ^\nThe local variable b may not have been initialized\n----------\n");
    }

    public void testBug380927f() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        Object b;\n        label: for(;;) {\n            switch (0) {\n            case 1:\n                b = null;\n                break;\n            default:\n                break label;\n            }\n        }\n        System.out.println(b);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tSystem.out.println(b);\n\t                   ^\nThe local variable b may not have been initialized\n----------\n");
    }

    public void testBug380927g() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        Object b;\n        label: for(int i : new int [] { 10 }) {\n            switch (0) {\n            case 1:\n                b = null;\n                break;\n            default:\n                break label;\n            }\n        }\n        System.out.println(b);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tSystem.out.println(b);\n\t                   ^\nThe local variable b may not have been initialized\n----------\n");
    }

    public void testBug383629() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t  public static void main(String[] args) {\n\t    char  chc;         \n\t     do {      \n\t        if (args == null) {      \n\t           switch ('a') {     \n\t           case '\\n':      \n\t                 chc = 'b';\n\t           }               \n\t        } else {            \n\t           switch ('a') {       \n\t              case '\\r':\n\t           }          \n\t        }\n\t     } while (false);\n\t     System.out.println(\"Done\");\n\t  }\n}"});
        String expectedOutput = this.complianceLevel < 0x320000L ? "      Local variable table:\n        [pc: 0, pc: 61] local: args index: 0 type: java.lang.String[]\n" : "      Local variable table:\n        [pc: 0, pc: 61] local: args index: 0 type: java.lang.String[]\n      Stack map table: number of frames 4\n        [pc: 24, same]\n        [pc: 27, same]\n        [pc: 30, same]\n        [pc: 52, same]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            SwitchTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void testBug381172() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args){\n        System.out.println(\"Test\");\n    }\n    public void method() {\n        try {\n            int rc;\n            switch ( 0 )\n            {\n                case 0:\n                    rc = 0;\n                    setRC( rc );\n                    break;\n                case 1:\n                    rc = 1;\n                    setRC( 0 );\n                    break;\n                case 2:\n                    rc = 2;\n                    setRC( 0 );\n                    break;\n                default:\n                    break;\n            }\n        }\n        catch ( final Exception ex ) {}\n    }\n    private void setRC(int rc) {}\n}"});
        String expectedOutput = this.complianceLevel < 0x320000L ? "      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n        [pc: 0, pc: 1] local: rc index: 1 type: int\n" : "      Local variable table:\n        [pc: 0, pc: 63] local: this index: 0 type: X\n        [pc: 30, pc: 38] local: rc index: 1 type: int\n        [pc: 40, pc: 48] local: rc index: 1 type: int\n        [pc: 50, pc: 58] local: rc index: 1 type: int\n      Stack map table: number of frames 6\n        [pc: 28, same]\n        [pc: 38, same]\n        [pc: 48, same]\n        [pc: 58, same]\n        [pc: 61, same_locals_1_stack_item, stack: {java.lang.Exception}]\n        [pc: 62, same]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            SwitchTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test383643() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    void foo() {\n        String s;\n        switch (p) {\n            case ONE:\n                s= \"1\";\n                break;\n            case TWO:\n                s= \"2\";\n                break;\n        }\n\n        s.toString();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tswitch (p) {\n\t        ^\np cannot be resolved to a variable\n----------\n2. WARNING in X.java (at line 4)\n\tswitch (p) {\n\t        ^\nThe switch statement should have a default case\n----------\n3. ERROR in X.java (at line 5)\n\tcase ONE:\n\t     ^^^\nONE cannot be resolved to a variable\n----------\n4. ERROR in X.java (at line 8)\n\tcase TWO:\n\t     ^^^\nTWO cannot be resolved to a variable\n----------\n", null, true, options);
    }

    public void test387146a() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate Object someLock;\n\tpublic void foo1(int i) {\n\t\tswitch (i) {\n\t\tcase 1:\n\t\t\tsynchronized (someLock) {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\t//$FALL-THROUGH$\n\t\tcase 2:\n\t\t\tSystem.out.println();\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\n"}, "", null, true, options);
    }

    public void test387146b() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate boolean someFlag;\n\tpublic void foo1(int i) {\n\t\tswitch (i) {\n\t\tcase 1:\n\t\t\tif (someFlag) {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\t//$FALL-THROUGH$\n\t\tcase 2:\n\t\t\tSystem.out.println();\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\n"}, "", null, true, options);
    }

    public void test393537() {
        String errorMsg = "----------\n1. ERROR in X.java (at line 3)\n\tswitch (\"\") {\n\t        ^^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tswitch (\"\") {\n\t\t\tcase \"\":\n\t\t\tdefault:\n\t\t}\n\t}\n}"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            this.runConformTest(sourceFiles, "");
        }
    }

    public void test410892() {
        String errorMsg = "----------\n1. ERROR in X.java (at line 5)\n\tswitch (s) {\n\t        ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n   public void testFunction(String s) {\n        int var1 = 0;\n        int var2 = 0;\n        switch (s) {\n        case \"test\": \n            var2 = ++var1 % 2;\n            break;\n        }\n   }\n}"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            Map<String, String> options = this.getCompilerOptions();
            options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
            this.runConformTest(sourceFiles, options);
        }
    }

    public void test410892_2() {
        String errorMsg = "----------\n1. ERROR in X.java (at line 5)\n\tswitch (s) {\n\t        ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n   public X(String s) {\n        int var1 = 0;\n        int var2 = 0;\n        switch (s) {\n        case \"test\": \n            var2 = ++var1 % 2;\n            break;\n        }\n   }\n}"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            Map<String, String> options = this.getCompilerOptions();
            options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
            this.runConformTest(sourceFiles, options);
        }
    }

    public void test410892_3() {
        String errorMsg = "----------\n1. ERROR in X.java (at line 6)\n\tswitch (s) {\n\t        ^\nCannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n   static {\n        int var1 = 0;\n        int var2 = 0;\n        String s = \"test2\";\n        switch (s) {\n        case \"test\": \n            var2 = ++var1 % 2;\n            break;\n        }\n   }\n}"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg);
        } else {
            Map<String, String> options = this.getCompilerOptions();
            options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
            this.runConformTest(sourceFiles, options);
        }
    }

    public void test410892_4() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        String errorMsg = "----------\n1. WARNING in X.java (at line 4)\n\tint var2 = 0;\n\t    ^^^^\nThe value of the local variable var2 is not used\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n   public void testFunction(String s) {\n        int var1 = 0;\n        int var2 = 0;\n        switch (s) {\n        case \"test\": \n            var2 = ++var1 % 2;\n            break;\n        }\n   }\n}"};
        if (this.complianceLevel >= 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg, null, true, options);
        }
    }

    public void test410892_5() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        String errorMsg = "----------\n1. WARNING in X.java (at line 4)\n\tint var2 = 0;\n\t    ^^^^\nThe value of the local variable var2 is not used\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n   public X(String s) {\n        int var1 = 0;\n        int var2 = 0;\n        switch (s) {\n        case \"test\": \n            var2 = ++var1 % 2;\n            break;\n        }\n   }\n}"};
        if (this.complianceLevel >= 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg, null, true, options);
        }
    }

    public void test410892_6() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        String errorMsg = "----------\n1. WARNING in X.java (at line 4)\n\tint var2 = 0;\n\t    ^^^^\nThe value of the local variable var2 is not used\n----------\n";
        String[] sourceFiles = new String[]{"X.java", "public class X {\n   static {\n        int var1 = 0;\n        int var2 = 0;\n        String s = \"Test2\";\n        switch (s) {\n        case \"test\": \n            var2 = ++var1 % 2;\n            break;\n        }\n   }\n}"};
        if (this.complianceLevel >= 0x330000L) {
            this.runNegativeTest(sourceFiles, errorMsg, null, true, options);
        }
    }

    public void test526911() {
        String[] sourceFiles = new String[]{"Main.java", "public class Main {\n\tpublic static void main(String[] args) {\n\t\tnew Main().run();\n\t}\n\t\n\tprivate void run() {\n\t\tV v = new VA();\n\t\tI i = I.create(v);\n\t\tSystem.out.printf(\"%d %d\", i.m1(), i.m2());\n\t}\n}\n", "XI.java", "public class XI implements I {\n\tV v;\n\tpublic XI(V v) {\n\t\tthis.v = v;\n\t}\n\t@Override\n\tpublic int m1() {\n\t\treturn 1;\n\t}\n\t@Override\n\tpublic int m2() {\n\t\treturn 11;\n\t}\n}\n", "YI.java", "public class YI implements I {\n\tV v;\n\tpublic YI(V v) {\n\t\tthis.v = v;\n\t}\n\t@Override\n\tpublic int m1() {\n\t\treturn 2;\n\t}\n\t@Override\n\tpublic int m2() {\n\t\treturn 22;\n\t}\n}\n", "V.java", "public class V {\n\tpublic enum T { A, B, C }\n\tprivate T t;\n\tpublic V(T t) {\n\t\tthis.t = t;\n\t}\n\tpublic T getT() { return t; }\n}\nclass VA extends V {\n\tVA() {\n\t\tsuper(T.A);\n\t}\n}", "I.java", "enum H { X, Y }\npublic interface I {\n\tpublic static final int i = 0;\n\tpublic int m1();\n\tpublic int m2();\n\tpublic static I create(V v) { \n\t\tV.T t = v.getT();\n\t\tH h = getH(t);\n\t\tswitch (h) { // depending on H i need different implementations of I. XI and YI provide them\n\t\tcase X:\n\t\t\treturn new XI(v);\n\t\tcase Y:\n\t\t\treturn new YI(v);\n\t\tdefault:\n\t\t\tthrow new Error();\n\t\t}\t\n\t}\n\tstatic H getH(V.T t) { // different T's require different H's to handle them\n\t\tswitch (t) {\n\t\tcase A:\n\t\t\treturn H.X;\n\t\tcase B:\n\t\tcase C:\n\t\t\treturn H.Y;\n\t\t}\n\t\tthrow new Error();\n\t}\n}", "X.java", "public class X {\n   static {\n        int var1 = 0;\n        int var2 = 0;\n        String s = \"Test2\";\n        switch (s) {\n        case \"test\": \n            var2 = ++var1 % 2;\n            break;\n        }\n   }\n}"};
        if (this.complianceLevel >= 0x340000L) {
            this.runConformTest(sourceFiles, "1 11");
        }
    }

    public void test526911a() {
        if (this.complianceLevel < 0x350000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        String[] sourceFiles = new String[]{"Main.java", "public class Main {\n\tpublic static void main(String[] args) {\n\t\tnew Main().run();\n\t}\n\t\n\tprivate void run() {\n\t\tV v = new VA();\n\t\tI i = I.create(v);\n\t\tSystem.out.printf(\"%d %d\", i.m1(), i.m2());\n\t}\n}\n", "XI.java", "public class XI implements I {\n\tV v;\n\tpublic XI(V v) {\n\t\tthis.v = v;\n\t}\n\t@Override\n\tpublic int m1() {\n\t\treturn 1;\n\t}\n\t@Override\n\tpublic int m2() {\n\t\treturn 11;\n\t}\n}\n", "YI.java", "public class YI implements I {\n\tV v;\n\tpublic YI(V v) {\n\t\tthis.v = v;\n\t}\n\t@Override\n\tpublic int m1() {\n\t\treturn 2;\n\t}\n\t@Override\n\tpublic int m2() {\n\t\treturn 22;\n\t}\n}\n", "V.java", "public class V {\n\tpublic enum T { A, B, C }\n\tprivate T t;\n\tpublic V(T t) {\n\t\tthis.t = t;\n\t}\n\tpublic T getT() { return t; }\n}\nclass VA extends V {\n\tVA() {\n\t\tsuper(T.A);\n\t}\n}", "I.java", "enum H { X, Y }\npublic interface I {\n\tpublic static final int i = 0;\n\tpublic int m1();\n\tpublic int m2();\n\tpublic static I create(V v) { \n\t\tV.T t = v.getT();\n\t\tH h = getH(t);\n\t\tswitch (h) { // depending on H i need different implementations of I. XI and YI provide them\n\t\tcase X:\n\t\t\treturn new XI(v);\n\t\tcase Y:\n\t\t\treturn new YI(v);\n\t\tdefault:\n\t\t\tthrow new Error();\n\t\t}\t\n\t}\n\tstatic H getH(V.T t) { // different T's require different H's to handle them\n\t\tswitch (t) {\n\t\tcase A:\n\t\t\treturn H.X;\n\t\tcase B:\n\t\tcase C:\n\t\t\treturn H.Y;\n\t\t}\n\t\tthrow new Error();\n\t}\n}", "X.java", "public class X {\n   static {\n        int var1 = 0;\n        int var2 = 0;\n        String s = \"Test2\";\n        switch (s) {\n        case \"test\": \n            var2 = ++var1 % 2;\n            break;\n        }\n   }\n}"};
        this.runConformTest(sourceFiles, "1 11", options);
    }

    public static Class testClass() {
        return SwitchTest.class;
    }
}

