/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class UnderscoresInLiteralsTest
extends AbstractRegressionTest {
    public UnderscoresInLiteralsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return UnderscoresInLiteralsTest.buildMinimalComplianceTestSuite(UnderscoresInLiteralsTest.testClass(), 16);
    }

    public static Class testClass() {
        return UnderscoresInLiteralsTest.class;
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0b_001);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0b_001);\n\t                   ^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0_b001);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0_b001);\n\t                   ^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0b001_);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0b001_);\n\t                   ^^^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x_11.0p33f);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0x_11.0p33f);\n\t                   ^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x11_.0p33f);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0x11_.0p33f);\n\t                   ^^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x11._0p33f);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0x11._0p33f);\n\t                   ^^^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x11.0_p33f);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0x11.0_p33f);\n\t                   ^^^^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x11.0p_33f);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0x11.0p_33f);\n\t                   ^^^^^^^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x11.0p33_f);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0x11.0p33_f);\n\t                   ^^^^^^^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x_0001AEFBBA);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0x_0001AEFBBA);\n\t                   ^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0_x0001AEFBBA);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0_x0001AEFBBA);\n\t                   ^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x0001AEFBBA_);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0x0001AEFBBA_);\n\t                   ^^^^^^^^^^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(_01234567);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(_01234567);\n\t                   ^^^^^^^^^\n_01234567 cannot be resolved to a variable\n----------\n");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(01234567_);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(01234567_);\n\t                   ^^^^^^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(1_.236589954f);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(1_.236589954f);\n\t                   ^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(1._236589954f);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(1._236589954f);\n\t                   ^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(1_e2);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(1_e2);\n\t                   ^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(1e_2);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(1e_2);\n\t                   ^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(1e2_);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(1e2_);\n\t                   ^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(01e2_);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(01e2_);\n\t                   ^^^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(01_e2_);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(01_e2_);\n\t                   ^^^\nUnderscores have to be located within digits\n----------\n");
    }

    public void test022() {
        Map<String, String> customedOptions = this.getCompilerOptions();
        customedOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
        customedOptions.put("org.eclipse.jdt.core.compiler.source", "1.6");
        customedOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0b1110000_);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0b1110000_);\n\t                   ^^^^^^^^^^\nUnderscores can only be used with source level 1.7 or greater\n----------\n", null, true, customedOptions);
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x1234____5678____90L);\n\t}\n}"}, "78187493520");
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(90_00__00_0);\n\t}\n}"}, "9000000");
    }
}

