/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.List;
import java.util.Map;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.core.tests.eval.EvaluationSetup;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.runtime.TargetInterface;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.eval.EvaluationContext;

public class DebugEvaluationSetup
extends EvaluationSetup {
    VirtualMachine vm;

    public DebugEvaluationSetup(long complianceLevel) {
        super(complianceLevel);
    }

    @Override
    protected void setUp() {
        if (this.context == null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ServerSocket evalServer = new ServerSocket(0);){
                    LocalVMLauncher launcher;
                    int debugPort = Util.getFreePort();
                    int evalPort = evalServer.getLocalPort();
                    try {
                        launcher = LocalVMLauncher.getLauncher();
                        launcher.setVMArguments(new String[]{"-verify"});
                        launcher.setVMPath(JRE_PATH);
                        launcher.setEvalPort(evalPort);
                        launcher.setEvalTargetPath(EVAL_DIRECTORY);
                        launcher.setDebugPort(debugPort);
                        this.launchedVM = launcher.launch();
                    }
                    catch (TargetException e) {
                        throw new Error(e.getMessage());
                    }
                    try {
                        this.startReader("VM's stdout reader", this.launchedVM.getInputStream(), System.out);
                    }
                    catch (TargetException targetException) {}
                    try {
                        this.startReader("VM's sterr reader", this.launchedVM.getErrorStream(), System.err);
                    }
                    catch (TargetException targetException) {}
                    int i = 0;
                    while (i < 10) {
                        try {
                            VirtualMachineManager manager = Bootstrap.virtualMachineManager();
                            List<AttachingConnector> connectors = manager.attachingConnectors();
                            if (connectors.size() == 0) break;
                            AttachingConnector connector = connectors.get(0);
                            Map<String, Connector.Argument> args = connector.defaultArguments();
                            Connector.Argument argument = args.get("port");
                            if (argument != null) {
                                argument.setValue(String.valueOf(debugPort));
                            }
                            if ((argument = args.get("hostname")) != null) {
                                argument.setValue(launcher.getTargetAddress());
                            }
                            if ((argument = args.get("timeout")) != null) {
                                argument.setValue("10000");
                            }
                            this.vm = connector.attach(args);
                            this.vm.resume();
                            break;
                        }
                        catch (IllegalConnectorArgumentsException e) {
                            e.printStackTrace();
                            try {
                                System.out.println("Could not contact the VM at " + launcher.getTargetAddress() + ":" + debugPort + ". Retrying...");
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                System.out.println("Could not contact the VM at " + launcher.getTargetAddress() + ":" + debugPort + ". Retrying...");
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        ++i;
                    }
                    if (this.vm == null) {
                        if (this.launchedVM != null) {
                            try {
                                if (!this.launchedVM.isRunning()) {
                                    int read;
                                    InputStream in = this.launchedVM.getErrorStream();
                                    do {
                                        if ((read = in.read()) == -1) continue;
                                        System.out.print((char)read);
                                    } while (read != -1);
                                }
                            }
                            catch (TargetException targetException) {
                            }
                            catch (IOException iOException) {}
                            try {
                                if (this.target != null) {
                                    this.target.disconnect();
                                }
                                int retry = 0;
                                while (this.launchedVM.isRunning() && ++retry < 20) {
                                    try {
                                        Thread.sleep(retry * 100);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                if (this.launchedVM.isRunning()) {
                                    this.launchedVM.shutDown();
                                }
                            }
                            catch (TargetException targetException) {}
                        }
                        System.err.println("Could not contact the VM");
                        return;
                    }
                    this.context = new EvaluationContext();
                    this.target = new TargetInterface();
                    this.target.connect(evalServer, 30000);
                    this.env = new FileSystem(Util.getJavaClassLibs(), new String[0], null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                throw new Error("Failed to open socket", e1);
            }
        }
        super.setUp();
    }
}

