/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.request.BreakpointRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jdt.core.tests.eval.DebugEvaluationTest;
import org.eclipse.jdt.core.tests.eval.EvaluationTest;
import org.eclipse.jdt.core.tests.runtime.RuntimeConstants;
import org.eclipse.jdt.internal.eval.EvaluationConstants;
import org.eclipse.jdt.internal.eval.EvaluationResult;
import org.eclipse.jdt.internal.eval.IRequestor;
import org.eclipse.jdt.internal.eval.InstallException;

public class JDIStackFrame
implements EvaluationConstants,
RuntimeConstants {
    VirtualMachine jdiVM;
    ThreadReference jdiThread;
    String userCode;
    String breakpointClassName;
    String breakpointMethodName;
    int breakpointLine;
    long timeout;

    public JDIStackFrame(VirtualMachine jdiVM, DebugEvaluationTest test, String userCode) {
        this(jdiVM, test, userCode, "_JDIStackFrame_", "foo", Integer.MAX_VALUE);
    }

    public JDIStackFrame(VirtualMachine jdiVM, DebugEvaluationTest test, String userCode, String breakpointClassName, String breakpointMethodName, int breakpointLine) {
        this(jdiVM, test, userCode, breakpointClassName, breakpointMethodName, breakpointLine, 10000L);
    }

    public JDIStackFrame(VirtualMachine jdiVM, DebugEvaluationTest test, String userCode, String breakpointClassName, String breakpointMethodName, int breakpointLine, long timeout) {
        this.jdiVM = jdiVM;
        this.userCode = userCode;
        this.breakpointClassName = breakpointClassName;
        this.breakpointMethodName = breakpointMethodName;
        this.breakpointLine = breakpointLine;
        this.timeout = timeout;
        test.jdiStackFrame = null;
        this.jdiThread = this.getDebuggedThread(test);
        test.jdiStackFrame = this;
    }

    public char[] declaringTypeName() {
        if (this.breakpointLine != Integer.MAX_VALUE) {
            StackFrame frame = this.getStackFrame();
            return frame.location().declaringType().name().toCharArray();
        }
        return null;
    }

    protected ThreadReference getDebuggedThread(DebugEvaluationTest test) {
        try {
            this.jdiVM.eventRequestManager().deleteAllBreakpoints();
            List<ReferenceType> classes = this.jdiVM.classesByName(this.breakpointClassName);
            if (classes.size() == 0) {
                if (this.breakpointClassName.equals("_JDIStackFrame_")) {
                    String source = "public class _JDIStackFrame_ {\n  public int foo() {\n    return -1;\n  }\n}";
                    test.compileAndDeploy(source, "_JDIStackFrame_");
                }
                test.evaluateWithExpectedDisplayString(("return Class.forName(\"" + this.breakpointClassName + "\");").toCharArray(), ("class " + this.breakpointClassName).toCharArray());
                classes = this.jdiVM.classesByName(this.breakpointClassName);
                if (classes.size() == 0) {
                    for (ReferenceType type : this.jdiVM.allClasses()) {
                        if (!type.name().equals(this.breakpointClassName)) continue;
                        classes = new ArrayList<ReferenceType>(1);
                        classes.add(type);
                        break;
                    }
                    if (classes.size() == 0) {
                        throw new Error("JDI could not retrieve class for " + this.breakpointClassName);
                    }
                }
            }
            ClassType clazz = (ClassType)classes.get(0);
            Method method = clazz.methodsByName(this.breakpointMethodName).get(0);
            Location location = this.breakpointLine < 0 || this.breakpointLine == Integer.MAX_VALUE ? method.location() : method.locationsOfLine(this.breakpointLine).get(0);
            BreakpointRequest request = this.jdiVM.eventRequestManager().createBreakpointRequest(location);
            request.setSuspendPolicy(1);
            request.enable();
            EvaluationTest.Requestor requestor = new EvaluationTest.Requestor(test);
            try {
                test.resetEnv();
                test.context.evaluate(("(new Thread() {\n  public void run() {\n" + this.userCode + "\n" + (this.breakpointClassName.equals("_JDIStackFrame_") ? "    new _JDIStackFrame_().foo();\n" : "") + "  }\n" + "  public String toString() {\n" + "    return \"my thread\";\n" + "  }\n" + "}).start();\n").toCharArray(), test.getEnv(), test.getCompilerOptions(), (IRequestor)requestor, test.getProblemFactory());
            }
            catch (InstallException e) {
                TestCase.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
            }
            EvaluationResult[] results = requestor.results;
            int i = 0;
            while (i < requestor.resultIndex + 1) {
                if (results[i].hasErrors()) {
                    TestCase.assertTrue((String)"Compilation error in user code", (boolean)false);
                }
                ++i;
            }
            Event event = null;
            block7: do {
                EventSet set = this.jdiVM.eventQueue().remove();
                EventIterator iterator = set.eventIterator();
                while (iterator.hasNext()) {
                    event = (Event)iterator.next();
                    if (event instanceof BreakpointEvent) continue block7;
                }
            } while (!(event instanceof BreakpointEvent));
            return ((BreakpointEvent)event).thread();
        }
        catch (AbsentInformationException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected StackFrame getStackFrame() {
        try {
            if (this.breakpointLine == Integer.MAX_VALUE) {
                return this.jdiThread.frame(1);
            }
            return this.jdiThread.frame(0);
        }
        catch (IncompatibleThreadStateException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isConstructorCall() {
        if (this.breakpointLine != Integer.MAX_VALUE) {
            StackFrame frame = this.getStackFrame();
            return frame.location().method().isConstructor();
        }
        return false;
    }

    public boolean isStatic() {
        if (this.breakpointLine != Integer.MAX_VALUE) {
            StackFrame frame = this.getStackFrame();
            return frame.location().method().isStatic();
        }
        return false;
    }

    public int[] localVariableModifiers() {
        try {
            StackFrame frame = this.getStackFrame();
            List<LocalVariable> variables = frame.visibleVariables();
            int[] modifiers = new int[variables.size()];
            return modifiers;
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    public char[][] localVariableNames() {
        try {
            StackFrame frame = this.getStackFrame();
            Iterator<LocalVariable> variables = frame.visibleVariables().iterator();
            Vector<char[]> names = new Vector<char[]>();
            while (variables.hasNext()) {
                LocalVariable var = variables.next();
                names.addElement(var.name().toCharArray());
            }
            char[][] result = new char[names.size()][];
            names.copyInto((Object[])result);
            return result;
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    public char[][] localVariableTypeNames() {
        try {
            StackFrame frame = this.getStackFrame();
            Iterator<LocalVariable> variables = frame.visibleVariables().iterator();
            Vector<char[]> names = new Vector<char[]>();
            while (variables.hasNext()) {
                LocalVariable var = variables.next();
                names.addElement(var.typeName().toCharArray());
            }
            char[][] result = new char[names.size()][];
            names.copyInto((Object[])result);
            return result;
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(String codeSnippetClassName) {
        ArrayList<ObjectReference> arguments;
        Method method;
        ObjectReference codeSnippetRunner;
        ObjectReference codeSnippet;
        ClassType codeSnippetClass;
        try {
            ObjectReference thisObject;
            long start = System.currentTimeMillis();
            List<ReferenceType> classes = this.jdiVM.classesByName(codeSnippetClassName);
            while (classes.size() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                classes = this.jdiVM.classesByName(codeSnippetClassName);
                if (classes.size() != 0) continue;
                for (ReferenceType type : this.jdiVM.allClasses()) {
                    if (!type.name().equals(codeSnippetClassName)) continue;
                    classes = new ArrayList<ReferenceType>(1);
                    classes.add(type);
                    break;
                }
                if (classes.size() != 0 || System.currentTimeMillis() - start <= this.timeout) continue;
                return false;
            }
            codeSnippetClass = (ClassType)classes.get(0);
            Method constructor = codeSnippetClass.methodsByName("<init>").get(0);
            codeSnippet = codeSnippetClass.newInstance(this.jdiThread, constructor, new ArrayList(), 1);
            StackFrame stackFrame = this.getStackFrame();
            try {
                for (LocalVariable jdiVariable : stackFrame.visibleVariables()) {
                    Value value = stackFrame.getValue(jdiVariable);
                    Field field = codeSnippetClass.fieldByName(String.valueOf(new String(LOCAL_VAR_PREFIX)) + jdiVariable.name());
                    codeSnippet.setValue(field, value);
                }
            }
            catch (AbsentInformationException absentInformationException) {}
            Field delegateThis = codeSnippetClass.fieldByName(new String(DELEGATE_THIS));
            if (delegateThis != null && (thisObject = stackFrame.thisObject()) != null) {
                codeSnippet.setValue(delegateThis, thisObject);
            }
            ClassType codeSnippetRunnerClass = (ClassType)this.jdiVM.classesByName("org.eclipse.jdt.core.tests.eval.target.CodeSnippetRunner").get(0);
            Field theRunner = codeSnippetRunnerClass.fieldByName("theRunner");
            codeSnippetRunner = (ObjectReference)codeSnippetRunnerClass.getValue(theRunner);
            method = codeSnippetRunnerClass.methodsByName("runCodeSnippet").get(0);
            arguments = new ArrayList<ObjectReference>();
            arguments.add(codeSnippet);
        }
        catch (ClassNotLoadedException e) {
            e.printStackTrace();
            return false;
        }
        catch (IncompatibleThreadStateException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvalidTypeException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvocationException e) {
            e.printStackTrace();
            return false;
        }
        try {
            codeSnippetRunner.invokeMethod(this.jdiThread, method, arguments, 1);
            StackFrame stackFrame = this.getStackFrame();
            try {
                for (LocalVariable jdiVariable : stackFrame.visibleVariables()) {
                    Field field = codeSnippetClass.fieldByName(String.valueOf(new String(LOCAL_VAR_PREFIX)) + jdiVariable.name());
                    Value value = codeSnippet.getValue(field);
                    stackFrame.setValue(jdiVariable, value);
                }
                return true;
            }
            catch (AbsentInformationException absentInformationException) {
                return true;
            }
        }
        catch (ClassNotLoadedException e) {
            e.printStackTrace();
            return true;
        }
        catch (IncompatibleThreadStateException e) {
            e.printStackTrace();
            return true;
        }
        catch (InvalidTypeException e) {
            e.printStackTrace();
            return true;
        }
        catch (InvocationException e) {
            e.printStackTrace();
        }
        return true;
    }
}

