/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval.target;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.jdt.core.tests.eval.target.CodeSnippetClassLoader;
import org.eclipse.jdt.core.tests.eval.target.IDEInterface;

public class CodeSnippetRunner {
    public static CodeSnippetRunner theRunner;
    static final String CODE_SNIPPET_CLASS_NAME = "org.eclipse.jdt.internal.eval.target.CodeSnippet";
    static final String RUN_METHOD_NAME = "run";
    static final String GET_RESULT_TYPE_METHOD_NAME = "getResultType";
    static final String GET_RESULT_VALUE_METHOD_NAME = "getResultValue";
    IDEInterface ide;
    String classPathDirectory;
    String bootclassPathDirectory;
    CodeSnippetClassLoader loader;
    Class codeSnippetClass = null;

    public CodeSnippetRunner(int portNumber, String classPathDirectory, String bootclassPathDirectory) {
        this.ide = new IDEInterface(portNumber);
        if (classPathDirectory != null) {
            this.classPathDirectory = classPathDirectory;
            if (bootclassPathDirectory != null) {
                this.bootclassPathDirectory = bootclassPathDirectory;
            }
        } else {
            this.loader = new CodeSnippetClassLoader();
        }
    }

    private String className(byte[] classDefinition) {
        int readOffset = 10;
        try {
            int constantPoolCount = this.u2At(8, classDefinition);
            int[] constantPoolOffsets = new int[constantPoolCount];
            int i = 1;
            while (i < constantPoolCount) {
                int tag = this.u1At(readOffset, classDefinition);
                switch (tag) {
                    case 1: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += this.u2At(readOffset + 1, classDefinition);
                        readOffset += 3;
                        break;
                    }
                    case 3: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += 5;
                        break;
                    }
                    case 4: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += 5;
                        break;
                    }
                    case 5: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += 9;
                        ++i;
                        break;
                    }
                    case 6: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += 9;
                        ++i;
                        break;
                    }
                    case 7: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += 3;
                        break;
                    }
                    case 8: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += 3;
                        break;
                    }
                    case 9: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += 5;
                        break;
                    }
                    case 10: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += 5;
                        break;
                    }
                    case 11: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += 5;
                        break;
                    }
                    case 12: {
                        constantPoolOffsets[i] = readOffset;
                        readOffset += 5;
                    }
                }
                ++i;
            }
            int constantPoolIndex = this.u2At(readOffset += 2, classDefinition);
            int utf8Offset = constantPoolOffsets[this.u2At(constantPoolOffsets[constantPoolIndex] + 1, classDefinition)];
            char[] className = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1, classDefinition), classDefinition);
            return new String(className);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return null;
        }
    }

    Object createCodeSnippet(Class snippetClass) {
        Object object = null;
        try {
            object = snippetClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            this.ide.sendResult(Void.TYPE, null);
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            this.ide.sendResult(Void.TYPE, null);
            return null;
        }
        return object;
    }

    public boolean isRunning() {
        return this.ide.isConnected();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int length = args.length;
        if (length < 2 || !args[0].toLowerCase().equals("-evalport")) {
            CodeSnippetRunner.printUsage();
            return;
        }
        int evalPort = Integer.parseInt(args[1]);
        String classPath = null;
        String bootPath = null;
        int mainClass = -1;
        int i = 2;
        while (i < length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                mainClass = i;
                break;
            }
            if (arg.toLowerCase().equals("-cscp")) {
                if (++i >= length) {
                    CodeSnippetRunner.printUsage();
                    return;
                }
                classPath = args[i];
            } else if (arg.toLowerCase().equals("-csbp")) {
                if (++i >= length) {
                    CodeSnippetRunner.printUsage();
                    return;
                }
                bootPath = args[i];
            }
            ++i;
        }
        theRunner = new CodeSnippetRunner(evalPort, classPath, bootPath);
        if (mainClass == -1) {
            theRunner.start();
            return;
        }
        Thread server = new Thread(){

            @Override
            public void run() {
                theRunner.start();
            }
        };
        server.setDaemon(true);
        server.start();
        int mainArgsLength = length - mainClass - 1;
        Object[] mainArgs = new String[mainArgsLength];
        System.arraycopy(args, mainClass + 1, mainArgs, 0, mainArgsLength);
        try {
            Class<?> clazz = Class.forName(args[mainClass]);
            Method mainMethod = clazz.getMethod("main", String[].class);
            mainMethod.invoke(null, mainArgs);
            return;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.jdt.tests.eval.target.CodeSnippetRunner -evalport <portNumber> [-options] [<mainClassName>] [<arguments>]");
        System.out.println("where options include:");
        System.out.println("-cscp <codeSnippetClasspath> the the classpath directory for the code snippet classes.");
        System.out.println("that are not defined in a \"java.*\" package.");
        System.out.println("-csbp <codeSnippetBootClasspath> the bootclasspath directory for the code snippet classes");
        System.out.println("that are defined in a \"java.*\" package.");
    }

    void processClasses(boolean mustRun, byte[][] classDefinitions) {
        String[] newClasses = new String[classDefinitions.length];
        int i = 0;
        while (i < classDefinitions.length) {
            byte[] classDefinition = classDefinitions[i];
            String classFileName = this.className(classDefinition);
            String className = classFileName.replace('/', '.');
            if (this.loader != null) {
                this.loader.storeClassDefinition(className, classDefinition);
            } else {
                this.writeClassOnDisk(classFileName, classDefinition);
            }
            newClasses[i] = className;
            ++i;
        }
        Vector<Class> codeSnippetClasses = new Vector<Class>();
        int i2 = 0;
        while (i2 < newClasses.length) {
            String className = newClasses[i2];
            Class clazz = null;
            if (this.loader != null) {
                clazz = this.loader.loadIfNeeded(className);
                if (clazz == null) {
                    System.err.println("Could not find class definition for " + className);
                    break;
                }
            } else {
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    this.ide.sendResult(Void.TYPE, null);
                    break;
                }
            }
            Class superclass = clazz.getSuperclass();
            Method[] methods = clazz.getDeclaredMethods();
            if (this.codeSnippetClass == null) {
                if (superclass.equals(Object.class) && clazz.getName().equals(CODE_SNIPPET_CLASS_NAME)) {
                    this.codeSnippetClass = clazz;
                } else {
                    System.out.println("Expecting CodeSnippet class to be deployed first");
                }
            } else if (superclass.equals(this.codeSnippetClass)) {
                if (methods.length == 1 && methods[0].getName().equals(RUN_METHOD_NAME)) {
                    codeSnippetClasses.addElement(clazz);
                }
                Field[] fields = clazz.getDeclaredFields();
                int j = 0;
                while (j < fields.length) {
                    Field field = fields[j];
                    if (Modifier.isPublic(field.getModifiers())) {
                        try {
                            this.ide.sendResult(field.getType(), field.get(null));
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                            this.ide.sendResult(Void.TYPE, null);
                            break;
                        }
                    }
                    ++j;
                }
            } else if (this.codeSnippetClass.equals(superclass.getSuperclass()) && methods.length == 1 && methods[0].getName().equals(RUN_METHOD_NAME)) {
                codeSnippetClasses.addElement(clazz);
            }
            ++i2;
        }
        if (codeSnippetClasses.size() != 0 && mustRun) {
            Enumeration e = codeSnippetClasses.elements();
            while (e.hasMoreElements()) {
                Object codeSnippet = this.createCodeSnippet((Class)e.nextElement());
                if (codeSnippet == null) continue;
                this.runCodeSnippet(codeSnippet);
            }
        }
    }

    void runCodeSnippet(final Object snippet) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        Method runMethod = CodeSnippetRunner.this.codeSnippetClass.getMethod(CodeSnippetRunner.RUN_METHOD_NAME, new Class[0]);
                        runMethod.invoke(snippet, new Object[0]);
                    }
                    finally {
                        Method getResultTypeMethod = CodeSnippetRunner.this.codeSnippetClass.getMethod(CodeSnippetRunner.GET_RESULT_TYPE_METHOD_NAME, new Class[0]);
                        Class resultType = (Class)getResultTypeMethod.invoke(snippet, new Object[0]);
                        Method getResultValueMethod = CodeSnippetRunner.this.codeSnippetClass.getMethod(CodeSnippetRunner.GET_RESULT_VALUE_METHOD_NAME, new Class[0]);
                        Object resultValue = getResultValueMethod.invoke(snippet, new Object[0]);
                        CodeSnippetRunner.this.ide.sendResult(resultType, resultValue);
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    System.out.println("codeSnippetClass = " + CodeSnippetRunner.this.codeSnippetClass.getName());
                    System.out.println("snippet.class = " + snippet.getClass().getName());
                    Class<?> superclass = snippet.getClass().getSuperclass();
                    System.out.println("snippet.superclass = " + (superclass == null ? "null" : superclass.getName()));
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.getTargetException().printStackTrace();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void start() {
        Thread thread = new Thread("Code snippet runner"){

            @Override
            public void run() {
                try {
                    CodeSnippetRunner.this.ide.connect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                while (CodeSnippetRunner.this.ide.isConnected()) {
                    try {
                        CodeSnippetRunner.this.processClasses(CodeSnippetRunner.this.ide.getRunFlag(), CodeSnippetRunner.this.ide.getNextClasses());
                    }
                    catch (Error e) {
                        CodeSnippetRunner.this.ide.sendResult(Void.TYPE, null);
                        e.printStackTrace();
                    }
                    catch (RuntimeException e) {
                        CodeSnippetRunner.this.ide.sendResult(Void.TYPE, null);
                        e.printStackTrace();
                    }
                }
            }
        };
        thread.start();
    }

    public void stop() {
        this.ide.disconnect();
    }

    private int u1At(int position, byte[] bytes) {
        return bytes[position] & 0xFF;
    }

    private int u2At(int position, byte[] bytes) {
        return ((bytes[position++] & 0xFF) << 8) + (bytes[position] & 0xFF);
    }

    private char[] utf8At(int readOffset, int bytesAvailable, byte[] bytes) {
        int length = bytesAvailable;
        char[] outputBuf = new char[bytesAvailable];
        int outputPos = 0;
        while (length != 0) {
            int x = bytes[readOffset++] & 0xFF;
            --length;
            if ((0x80 & x) != 0) {
                int y = bytes[readOffset++] & 0xFF;
                --length;
                if ((x & 0x20) != 0) {
                    int z = bytes[readOffset++] & 0xFF;
                    --length;
                    x = ((x & 0x1F) << 12) + ((y & 0x3F) << 6) + (z & 0x3F);
                } else {
                    x = ((x & 0x1F) << 6) + (y & 0x3F);
                }
            }
            outputBuf[outputPos++] = (char)x;
        }
        if (outputPos != bytesAvailable) {
            char[] cArray = outputBuf;
            outputBuf = new char[outputPos];
            System.arraycopy(cArray, 0, outputBuf, 0, outputPos);
        }
        return outputBuf;
    }

    private void writeClassOnDisk(String className, byte[] classDefinition) {
        try {
            String fileName = String.valueOf(className.replace('/', File.separatorChar)) + ".class";
            File classFile = new File(this.bootclassPathDirectory != null && (className.startsWith("java") || className.replace('/', '.').equals(CODE_SNIPPET_CLASS_NAME)) ? this.bootclassPathDirectory : this.classPathDirectory, fileName);
            File parent = new File(classFile.getParent());
            parent.mkdirs();
            if (!parent.exists()) {
                throw new IOException("Could not create directory " + parent.getPath());
            }
            try (FileOutputStream out = null;){
                out = new FileOutputStream(classFile);
                out.write(classDefinition);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

