/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.junit.extension;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PerformanceTestSuite
extends TestSuite {
    public PerformanceTestSuite(Class theClass) {
        this.setName(theClass.getName());
        try {
            PerformanceTestSuite.getTestConstructor((Class)theClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.addTest(PerformanceTestSuite.addWarningTest("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()"));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(PerformanceTestSuite.addWarningTest("Class " + theClass.getName() + " is not public"));
            return;
        }
        Class superClass = theClass;
        Vector names = new Vector();
        while (Test.class.isAssignableFrom(superClass)) {
            Method[] methods = superClass.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                this.addTestMethod(methods[i], names, theClass);
                ++i;
            }
            superClass = superClass.getSuperclass();
        }
        if (this.countTestCases() == 0) {
            this.addTest(PerformanceTestSuite.addWarningTest("No tests found in " + theClass.getName()));
        }
    }

    public PerformanceTestSuite(String name) {
        this.setName(name);
    }

    private void addTestMethod(Method m, Vector names, Class theClass) {
        String name = m.getName();
        if (names.contains(name)) {
            return;
        }
        if (!this.isPublicTestMethod(m)) {
            if (this.isTestMethod(m)) {
                this.addTest(PerformanceTestSuite.addWarningTest("Test method isn't public: " + m.getName()));
            }
            return;
        }
        names.addElement(name);
        this.addTest(PerformanceTestSuite.createTest((Class)theClass, (String)name));
    }

    public void addTestSuite(Class theClass) {
        this.addTest((Test)new PerformanceTestSuite(theClass));
    }

    private boolean isPublicTestMethod(Method m) {
        return this.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private boolean isTestMethod(Method m) {
        String name = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 0 && name.startsWith("testPerf") && returnType.equals(Void.TYPE);
    }

    private static Test addWarningTest(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail((String)message);
            }
        };
    }
}

