/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;

public class FullSourceWorkspaceASTTests
extends FullSourceWorkspaceTests {
    static final int JLS3_INTERNAL = 3;
    private static int TESTS_COUNT = 0;
    private static final int ITERATIONS_COUNT = 10;
    int nodesCount = 0;
    private static PrintStream[] LOG_STREAMS = new PrintStream[DIM_NAMES.length];

    public FullSourceWorkspaceASTTests(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = FullSourceWorkspaceASTTests.buildSuite(FullSourceWorkspaceASTTests.testClass());
        TESTS_COUNT = suite.countTestCases();
        FullSourceWorkspaceASTTests.createPrintStream(FullSourceWorkspaceASTTests.testClass(), LOG_STREAMS, TESTS_COUNT, null);
        return suite;
    }

    private static Class testClass() {
        return FullSourceWorkspaceASTTests.class;
    }

    @Override
    protected void setUp() throws Exception {
        AbstractJavaModelTests.waitUntilIndexesReady();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        --TESTS_COUNT;
        if (LOG_DIR != null) {
            this.logPerfResult(LOG_STREAMS, TESTS_COUNT);
        }
        if (TESTS_COUNT == 0) {
            System.out.println("-------------------------------------");
            System.out.println("DOM/AST creation performance test statistics:");
            NumberFormat intFormat = NumberFormat.getIntegerInstance();
            System.out.println("  - " + intFormat.format(this.nodesCount) + " nodes have been parsed.");
            System.out.println("-------------------------------------\n");
        }
        super.tearDown();
    }

    private void createAST(ICompilationUnit unit, int astLevel) throws JavaModelException {
        int i = 0;
        while (i < 2) {
            ASTParser parser = ASTParser.newParser((int)astLevel);
            parser.setSource(unit);
            parser.setResolveBindings(false);
            parser.createAST(null);
            ++i;
        }
        int measures = MEASURES_COUNT * 2;
        int iterations = 5;
        int i2 = 0;
        while (i2 < measures) {
            ASTNode result = null;
            this.runGc();
            this.startMeasuring();
            int j = 0;
            while (j < iterations) {
                ASTParser parser = ASTParser.newParser((int)astLevel);
                parser.setSource(unit);
                parser.setResolveBindings(false);
                result = parser.createAST(null);
                ++j;
            }
            this.stopMeasuring();
            FullSourceWorkspaceASTTests.assertEquals((String)("Wrong type for node" + result), (int)result.getNodeType(), (int)15);
            CompilationUnit compilationUnit = (CompilationUnit)result;
            CommentMapperASTVisitor visitor = new CommentMapperASTVisitor(compilationUnit);
            compilationUnit.accept((ASTVisitor)visitor);
            this.nodesCount += visitor.nodes * iterations;
            ++i2;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testPerfDomAstCreationJLS2() throws JavaModelException {
        this.tagAsSummary("DOM AST tree for one file using JLS2", false);
        ICompilationUnit unit = this.getCompilationUnit("org.eclipse.jdt.core", "org.eclipse.jdt.internal.compiler.parser", "Parser.java");
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "ignore");
        JavaCore.setOptions((Hashtable)options);
        this.createAST(unit, 2);
    }

    public void testPerfDomAstCreationJLS3() throws JavaModelException {
        this.tagAsSummary("DOM AST tree for one file using JLS3", false);
        ICompilationUnit unit = this.getCompilationUnit("org.eclipse.jdt.core", "org.eclipse.jdt.internal.compiler.parser", "Parser.java");
        this.createAST(unit, 3);
    }

    private int runAllProjectsAstCreation(int astLevel) throws JavaModelException {
        int unitsCount = 0;
        this.startMeasuring();
        if (DEBUG) {
            System.out.println("Creating AST hierarchy for all units of projects:");
        }
        int i = 0;
        while (i < ALL_PROJECTS.length) {
            List units;
            int size;
            if (DEBUG) {
                System.out.print("\t- " + ALL_PROJECTS[i].getElementName());
            }
            if ((size = (units = this.getProjectCompilationUnits(ALL_PROJECTS[i])).size()) == 0) {
                if (DEBUG) {
                    System.out.println(": empty!");
                }
            } else {
                unitsCount += size;
                List unitsArrays = this.splitListInSmallArrays(units, 20);
                int n = unitsArrays.size();
                if (DEBUG) {
                    if (n == 1) {
                        System.out.print(": " + size + " units to proceed (" + n + " step): ");
                    } else {
                        System.out.print(": " + size + " units to proceed (" + n + " steps): ");
                    }
                }
                while (unitsArrays.size() > 0) {
                    ICompilationUnit[] unitsArray = (ICompilationUnit[])unitsArrays.remove(0);
                    if (DEBUG) {
                        System.out.print('.');
                    }
                    int length = unitsArray.length;
                    CompilationUnit[] compilationUnits = new CompilationUnit[length];
                    int ptr = 0;
                    while (ptr < length) {
                        ICompilationUnit unit = unitsArray[ptr];
                        unitsArray[ptr] = null;
                        ASTParser parser = ASTParser.newParser((int)astLevel);
                        parser.setSource(unit);
                        parser.setResolveBindings(false);
                        ASTNode result = parser.createAST(null);
                        FullSourceWorkspaceASTTests.assertEquals((String)("Wrong type for node" + result), (int)result.getNodeType(), (int)15);
                        compilationUnits[ptr] = (CompilationUnit)result;
                        ++ptr;
                    }
                }
                if (DEBUG) {
                    System.out.println(" done!");
                }
            }
            ++i;
        }
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
        return unitsCount;
    }

    public void testWkspDomAstCreationJLS2() throws JavaModelException {
        this.tagAsSummary("DOM AST tree for workspace files (JLS2)", false);
        this.runAllProjectsAstCreation(2);
    }

    private void runAstCreation(IJavaProject javaProject) throws JavaModelException {
        if (DEBUG) {
            System.out.println("Creating AST for project" + javaProject.getElementName());
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setProject(javaProject);
        Map options = javaProject.getOptions(true);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if ("error".equals(value) || "warning".equals(value)) {
                options.put(key, "ignore");
                continue;
            }
            if (!"enabled".equals(value)) continue;
            options.put(key, "disabled");
        }
        options.put("org.eclipse.jdt.core.compiler.taskTags", "");
        parser.setCompilerOptions(options);
        List units = this.getProjectCompilationUnits(javaProject);
        ICompilationUnit[] compilationUnits = new ICompilationUnit[units.size()];
        units.toArray(compilationUnits);
        if (PRINT) {
            System.out.println("\t- options: " + options);
            System.out.println("\t- " + compilationUnits.length + " units will be parsed in " + javaProject.getElementName() + " project");
        }
        parser.createASTs(compilationUnits, new String[0], new ASTRequestor(){

            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                IProblem[] problems = ast.getProblems();
                int length = problems.length;
                if (length > 0) {
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    while (i < length) {
                        buffer.append(problems[i].getMessage());
                        buffer.append('\n');
                        ++i;
                    }
                    FullSourceWorkspaceASTTests.assertEquals((String)("Unexpected problems: " + buffer.toString()), (int)0, (int)length);
                }
            }
        }, null);
        int measures = MEASURES_COUNT * 2;
        int i = 0;
        while (i < measures) {
            this.runGc();
            this.startMeasuring();
            parser.createASTs(compilationUnits, new String[0], new ASTRequestor(){}, null);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testDomAstCreationProjectJLS3() throws JavaModelException {
        this.tagAsSummary("DOM AST tree for project files (JLS3)", true);
        this.runAstCreation(this.getProject("org.eclipse.search"));
    }

    class CommentMapperASTVisitor
    extends ASTVisitor {
        CompilationUnit compilationUnit;
        int nodes = 0;
        int extendedStartPositions = 0;
        int extendedEndPositions = 0;

        public CommentMapperASTVisitor(CompilationUnit unit) {
            this.compilationUnit = unit;
        }

        protected boolean visitNode(ASTNode node) {
            int nodeStart = node.getStartPosition();
            int nodeEnd = node.getLength() - 1 - nodeStart;
            int extendedStart = this.compilationUnit.getExtendedStartPosition(node);
            int extendedEnd = this.compilationUnit.getExtendedLength(node) - 1 - extendedStart;
            if (extendedStart < nodeStart) {
                ++this.extendedStartPositions;
            }
            if (extendedEnd > nodeEnd) {
                ++this.extendedEndPositions;
            }
            ++this.nodes;
            return true;
        }

        protected void endVisitNode(ASTNode node) {
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ArrayAccess node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ArrayCreation node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ArrayInitializer node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ArrayType node) {
            this.visitNode((ASTNode)node);
            return false;
        }

        public boolean visit(AssertStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(Assignment node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(Block node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(BooleanLiteral node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(BreakStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(CastExpression node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(CatchClause node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(CharacterLiteral node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ClassInstanceCreation node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(CompilationUnit node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ConditionalExpression node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ConstructorInvocation node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ContinueStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(DoStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(EmptyStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ExpressionStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(FieldAccess node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(FieldDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ForStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(IfStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ImportDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(InfixExpression node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(InstanceofExpression node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(Initializer node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(Javadoc node) {
            if (super.visit(node)) {
                return this.visitNode((ASTNode)node);
            }
            return false;
        }

        public boolean visit(LabeledStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(MethodDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ModuleDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(MethodInvocation node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(NullLiteral node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(NumberLiteral node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(PackageDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ParenthesizedExpression node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(PostfixExpression node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(PrefixExpression node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(PrimitiveType node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(QualifiedName node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ReturnStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SimpleName node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SimpleType node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(StringLiteral node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SuperConstructorInvocation node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SuperFieldAccess node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SuperMethodInvocation node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SwitchCase node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SwitchStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SynchronizedStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ThisExpression node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(ThrowStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(TryStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(TypeDeclarationStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(TypeLiteral node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SingleVariableDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(VariableDeclarationExpression node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(VariableDeclarationStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(VariableDeclarationFragment node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(WhileStatement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(BlockComment node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(LineComment node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(MemberRef node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(MethodRef node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(MethodRefParameter node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(TagElement node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(TextElement node) {
            return this.visitNode((ASTNode)node);
        }

        public void endVisit(AnonymousClassDeclaration node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ArrayAccess node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ArrayCreation node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ArrayInitializer node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ArrayType node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(AssertStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(Assignment node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(Block node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(BooleanLiteral node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(BreakStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(CastExpression node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(CatchClause node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(CharacterLiteral node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ClassInstanceCreation node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(CompilationUnit node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ConditionalExpression node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ConstructorInvocation node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ContinueStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(DoStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(EmptyStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ExpressionStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(FieldAccess node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(FieldDeclaration node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ForStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(IfStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ImportDeclaration node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(InfixExpression node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(InstanceofExpression node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(Initializer node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(Javadoc node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(LabeledStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(MethodDeclaration node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ModuleDeclaration node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(MethodInvocation node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(NullLiteral node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(NumberLiteral node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(PackageDeclaration node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ParenthesizedExpression node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(PostfixExpression node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(PrefixExpression node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(PrimitiveType node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(QualifiedName node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ReturnStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(SimpleName node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(SimpleType node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(StringLiteral node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(SuperConstructorInvocation node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(SuperFieldAccess node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(SuperMethodInvocation node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(SwitchCase node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(SwitchStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(SynchronizedStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ThisExpression node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(ThrowStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(TryStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(TypeDeclaration node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(TypeDeclarationStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(TypeLiteral node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(SingleVariableDeclaration node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(VariableDeclarationExpression node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(VariableDeclarationStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(VariableDeclarationFragment node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(WhileStatement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(BlockComment node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(LineComment node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(MemberRef node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(MethodRef node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(MethodRefParameter node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(TagElement node) {
            this.endVisitNode((ASTNode)node);
        }

        public void endVisit(TextElement node) {
            this.endVisitNode((ASTNode)node);
        }
    }
}

