/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;
import org.eclipse.jdt.internal.core.search.processing.IJob;

public class FullSourceWorkspaceSearchTests
extends FullSourceWorkspaceTests
implements IJavaSearchConstants {
    private static int TESTS_COUNT = 0;
    private static final int ITERATIONS_COUNT = 10;
    private static final int WARMUP_COUNT = 4;
    private static PrintStream[] LOG_STREAMS = new PrintStream[DIM_NAMES.length];
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance();
    static int SEARCH_ALL_TYPE_NAMES_COUNT = -1;

    public FullSourceWorkspaceSearchTests(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = FullSourceWorkspaceSearchTests.buildSuite(FullSourceWorkspaceSearchTests.testClass());
        TESTS_COUNT = suite.countTestCases();
        FullSourceWorkspaceSearchTests.createPrintStream(FullSourceWorkspaceSearchTests.testClass(), LOG_STREAMS, TESTS_COUNT, null);
        return suite;
    }

    private static Class testClass() {
        return FullSourceWorkspaceSearchTests.class;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        --TESTS_COUNT;
        if (LOG_DIR != null) {
            this.logPerfResult(LOG_STREAMS, TESTS_COUNT);
        }
        super.tearDown();
    }

    protected void search(String patternString, int searchFor, int limitTo, IJavaSearchScope scope, SearchRequestor resultCollector) throws CoreException {
        int matchMode = patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1 ? 2 : 0;
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)(matchMode | 8));
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, resultCollector, null);
    }

    protected void cleanCategoryTableCache(boolean type, IJavaSearchScope scope, JavaSearchResultCollector resultCollector) throws CoreException {
        long time = System.currentTimeMillis();
        if (type) {
            this.search("foo", 4, 0, scope, resultCollector);
        } else {
            this.search("Foo", 0, 0, scope, resultCollector);
        }
        if (DEBUG) {
            System.out.println("Time to clean category table cache: " + (System.currentTimeMillis() - time));
        }
    }

    public void testIndexing() throws CoreException {
        this.tagAsSummary("Indexing all workspace projects", false);
        AbstractJavaModelTests.waitUntilIndexesReady();
        INDEX_MANAGER.removeIndexFamily((IPath)new Path(""));
        INDEX_MANAGER.reset();
        this.runGc();
        INDEX_MANAGER.request((IJob)new Measuring(true));
        int j = 0;
        int length = ALL_PROJECTS.length;
        while (j < length) {
            INDEX_MANAGER.indexAll(ALL_PROJECTS[j].getProject());
            ++j;
        }
        AbstractJavaModelTests.waitUntilIndexesReady();
        INDEX_MANAGER.request((IJob)new Measuring(false));
        AbstractJavaModelTests.waitUntilIndexesReady();
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testIndexingOneProject() throws CoreException {
        this.tagAsSummary("Indexing JDT/Core project", true);
        int i = 0;
        while (i < 4) {
            INDEX_MANAGER.removeIndexFamily(JDT_CORE_PROJECT.getPath());
            INDEX_MANAGER.indexAll(JDT_CORE_PROJECT.getProject());
            AbstractJavaModelTests.waitUntilIndexesReady();
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            INDEX_MANAGER.removeIndexFamily(JDT_CORE_PROJECT.getPath());
            INDEX_MANAGER.request((IJob)new Measuring(true));
            INDEX_MANAGER.indexAll(JDT_CORE_PROJECT.getProject());
            AbstractJavaModelTests.waitUntilIndexesReady();
            INDEX_MANAGER.request((IJob)new Measuring(false));
            AbstractJavaModelTests.waitUntilIndexesReady();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchAllTypeNames() throws CoreException {
        this.tagAsGlobalSummary("Search all type names", true);
        OldSearchTypeNameRequestor requestor = new OldSearchTypeNameRequestor();
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        int i = 0;
        while (i < 4) {
            new SearchEngine().searchAllTypeNames(null, null, 10, 0, scope, (ITypeNameRequestor)requestor, 3, null);
            if (i == 0) {
                System.out.println("\tAll type names = " + INT_FORMAT.format(requestor.count));
                if (SEARCH_ALL_TYPE_NAMES_COUNT == -1) {
                    SEARCH_ALL_TYPE_NAMES_COUNT = requestor.count;
                } else {
                    FullSourceWorkspaceSearchTests.assertEquals((String)"We should find same number of types in the workspace whatever the search method is!", (int)SEARCH_ALL_TYPE_NAMES_COUNT, (int)requestor.count);
                }
            }
            ++i;
        }
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        int i2 = 0;
        while (i2 < MEASURES_COUNT) {
            this.cleanCategoryTableCache(true, scope, resultCollector);
            this.runGc();
            this.startMeasuring();
            int j = 0;
            while (j < 10) {
                new SearchEngine().searchAllTypeNames(null, null, 10, 0, scope, (ITypeNameRequestor)requestor, 3, null);
                ++j;
            }
            this.stopMeasuring();
            ++i2;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testNewSearchAllTypeNames() throws CoreException {
        this.tagAsSummary("Cold search all type names", true);
        SearchTypeNameRequestor requestor = new SearchTypeNameRequestor();
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        int i = 0;
        while (i < 4) {
            new SearchEngine().searchAllTypeNames(null, 10, null, 10, 0, scope, (TypeNameRequestor)requestor, 3, null);
            if (i == 0) {
                System.out.println("\tAll type names = " + INT_FORMAT.format(requestor.count));
                if (SEARCH_ALL_TYPE_NAMES_COUNT == -1) {
                    SEARCH_ALL_TYPE_NAMES_COUNT = requestor.count;
                } else {
                    FullSourceWorkspaceSearchTests.assertEquals((String)"We should find same number of types in the workspace whatever the search method is!", (int)SEARCH_ALL_TYPE_NAMES_COUNT, (int)requestor.count);
                }
            }
            ++i;
        }
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        int i2 = 0;
        while (i2 < MEASURES_COUNT) {
            this.cleanCategoryTableCache(true, scope, resultCollector);
            this.runGc();
            this.startMeasuring();
            new SearchEngine().searchAllTypeNames(null, 10, null, 10, 0, scope, (TypeNameRequestor)requestor, 3, null);
            this.stopMeasuring();
            ++i2;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchAllTypeNameMatches() throws CoreException {
        this.tagAsSummary("Search all type name matches", false);
        SearchTypeNameMatchRequestor requestor = new SearchTypeNameMatchRequestor();
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        int i = 0;
        while (i < 4) {
            new SearchEngine().searchAllTypeNames(null, 10, null, 10, 0, scope, (TypeNameMatchRequestor)requestor, 3, null);
            if (i == 0) {
                System.out.println("\tAll type names = " + INT_FORMAT.format(requestor.count));
                if (SEARCH_ALL_TYPE_NAMES_COUNT == -1) {
                    SEARCH_ALL_TYPE_NAMES_COUNT = requestor.count;
                } else {
                    FullSourceWorkspaceSearchTests.assertEquals((String)"We should find same number of types in the workspace whatever the search method is!", (int)SEARCH_ALL_TYPE_NAMES_COUNT, (int)requestor.count);
                }
            }
            ++i;
        }
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        int i2 = 0;
        while (i2 < MEASURES_COUNT) {
            this.cleanCategoryTableCache(true, scope, resultCollector);
            this.runGc();
            this.startMeasuring();
            new SearchEngine().searchAllTypeNames(null, 10, null, 10, 0, scope, (TypeNameMatchRequestor)requestor, 3, null);
            this.stopMeasuring();
            ++i2;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchType() throws CoreException {
        this.tagAsSummary("Search type occurences", true);
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JDT_CORE_PROJECT}, (int)1);
        String name = "JavaCore";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        int i = 0;
        while (i < 4) {
            this.search(name, 0, 3, scope, resultCollector);
            if (i == 0) {
                System.out.println("\t- " + INT_FORMAT.format(resultCollector.count) + " occurences for type '" + name + "' in project " + JDT_CORE_PROJECT.getElementName());
            }
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.cleanCategoryTableCache(true, scope, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 0, 3, scope, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchField() throws CoreException {
        this.tagAsSummary("Search field occurences", true);
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JDT_CORE_PROJECT}, (int)1);
        String name = "TYPE";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        int i = 0;
        while (i < 4) {
            this.search(name, 4, 3, scope, resultCollector);
            if (i == 0) {
                System.out.println("\t- " + INT_FORMAT.format(resultCollector.count) + " occurences for field '" + name + "' in project " + JDT_CORE_PROJECT.getElementName());
            }
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.cleanCategoryTableCache(false, scope, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 4, 3, scope, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchMethod() throws CoreException {
        this.tagAsSummary("Search method occurences (no resolution)", false);
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JDT_CORE_PROJECT}, (int)1);
        String name = "equals";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        int i = 0;
        while (i < 4) {
            this.search(name, 1, 3, scope, resultCollector);
            if (i == 0) {
                System.out.println("\t- " + INT_FORMAT.format(resultCollector.count) + " occurences for method '" + name + "' in project " + JDT_CORE_PROJECT.getElementName());
            }
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.cleanCategoryTableCache(false, scope, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 1, 3, scope, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchBinaryMethod() throws CoreException {
        this.tagAsSummary("Search method occurences", true);
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JDT_CORE_PROJECT}, (int)1);
        String name = "java.lang.Object.hashCode()";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        int i = 0;
        while (i < 4) {
            this.search(name, 1, 3, scope, resultCollector);
            if (i == 0) {
                System.out.println("\t- " + INT_FORMAT.format(resultCollector.count) + " occurences for method '" + name + "' in project " + JDT_CORE_PROJECT.getElementName());
            }
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.cleanCategoryTableCache(false, scope, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 1, 3, scope, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchConstructor() throws CoreException {
        this.tagAsSummary("Search constructor occurences", false);
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JDT_CORE_PROJECT}, (int)1);
        String name = "String";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        int i = 0;
        while (i < 4) {
            this.search(name, 3, 3, scope, resultCollector);
            if (i == 0) {
                System.out.println("\t- " + INT_FORMAT.format(resultCollector.count) + " occurences for constructor '" + name + "' in project " + JDT_CORE_PROJECT.getElementName());
            }
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.cleanCategoryTableCache(false, scope, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 3, 3, scope, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void _testSearchPackageDeclarations() throws CoreException {
        this.tagAsSummary("Search package declarations", false);
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JDT_CORE_PROJECT}, (int)1);
        String name = "*";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        int i = 0;
        while (i < 4) {
            this.search(name, 2, 0, scope, resultCollector);
            if (i == 0) {
                System.out.println("\t- " + INT_FORMAT.format(resultCollector.count) + " package declarations in project " + JDT_CORE_PROJECT.getElementName());
            }
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.cleanCategoryTableCache(false, scope, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 2, 0, scope, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchPackageDeclarationsWorkspace() throws CoreException {
        this.tagAsSummary("Search workspace package declarations", false);
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        String name = "*";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        int i = 0;
        while (i < 4) {
            this.search(name, 2, 0, scope, resultCollector);
            if (i == 0) {
                System.out.println("\t- " + INT_FORMAT.format(resultCollector.count) + " package declarations in workspace.");
            }
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.cleanCategoryTableCache(false, scope, resultCollector);
            this.runGc();
            this.startMeasuring();
            int j = 0;
            while (j < 10) {
                this.search(name, 2, 0, scope, resultCollector);
                ++j;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void _testGotoPackage() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        String name = "*";
        final ArrayList packageList = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IJavaElement enclosingElement = (IJavaElement)match.getElement();
                enclosingElement.getElementName();
                IPackageFragment pkg = (IPackageFragment)enclosingElement;
                if (pkg.getCompilationUnits().length == 0 && pkg.getClassFiles().length == 0) {
                    return;
                }
                packageList.add(enclosingElement);
            }
        };
        int i = 0;
        while (i < 4) {
            this.search(name, 2, 0, scope, requestor);
            if (i == 0) {
                System.out.println("\t- " + INT_FORMAT.format(packageList.size()) + " package declarations in workspace.");
            }
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.cleanCategoryTableCache(false, scope, new JavaSearchResultCollector());
            this.runGc();
            this.startMeasuring();
            this.search(name, 2, 0, scope, requestor);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    class JavaSearchResultCollector
    extends SearchRequestor {
        int count = 0;

        JavaSearchResultCollector() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            ++this.count;
        }
    }

    class Measuring
    implements IJob {
        boolean start;

        Measuring(boolean start) {
            this.start = start;
        }

        public boolean belongsTo(String jobFamily) {
            return true;
        }

        public void cancel() {
        }

        public void ensureReadyToRun() {
        }

        public boolean execute(IProgressMonitor progress) {
            if (this.start) {
                FullSourceWorkspaceSearchTests.this.startMeasuring();
            } else {
                FullSourceWorkspaceSearchTests.this.stopMeasuring();
            }
            return true;
        }

        public String getJobFamily() {
            return "FullSourceWorkspaceSearchTests.Measuring";
        }
    }

    class OldSearchTypeNameRequestor
    implements ITypeNameRequestor {
        int count = 0;

        OldSearchTypeNameRequestor() {
        }

        public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            ++this.count;
        }

        public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            ++this.count;
        }
    }

    class SearchTypeNameMatchRequestor
    extends TypeNameMatchRequestor {
        int count = 0;

        SearchTypeNameMatchRequestor() {
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            ++this.count;
        }
    }

    class SearchTypeNameRequestor
    extends TypeNameRequestor {
        int count = 0;

        SearchTypeNameRequestor() {
        }

        public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            ++this.count;
        }
    }
}

