/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.contentprovider.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.swt.widgets.Display;

public class AsynchronousTestSet
extends ObservableSet<Object> {
    private static Random randomNumberGenerator = new Random();
    private Display display = Display.getCurrent();
    private boolean stale = false;
    private static final int AVERAGE_DELTA = 4;
    private static final int AVERAGE_BUSY_TIME = 1000;
    private static List<Object> allSets = new ArrayList<Object>();

    public AsynchronousTestSet() {
        super(new HashSet(), Object.class);
        if (this.display == null) {
            throw new IllegalStateException("This object can only be created in the UI thread");
        }
        this.recompute();
    }

    protected void firstListenerAdded() {
        super.firstListenerAdded();
        allSets.add((Object)this);
    }

    protected void lastListenerRemoved() {
        allSets.remove((Object)this);
        super.lastListenerRemoved();
    }

    public static void recomputeAll() {
        for (AsynchronousTestSet asynchronousTestSet : allSets) {
            asynchronousTestSet.recompute();
        }
    }

    public void remove(Collection<Object> toRemove) {
        HashSet<Object> removed = new HashSet<Object>();
        removed.addAll(toRemove);
        removed.retainAll(this.wrappedSet);
        this.wrappedSet.removeAll(removed);
        this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, removed));
    }

    public boolean isStale() {
        return this.stale;
    }

    public void recompute() {
        if (!this.isStale()) {
            this.setStale(true);
            int sleepTime = (int)(randomNumberGenerator.nextDouble() * 2000.0);
            Thread newThread = new Thread(() -> {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {}
                this.display.asyncExec(() -> {
                    HashSet<Integer> toAdd = new HashSet<Integer>();
                    HashSet toRemove = new HashSet();
                    int delta = randomNumberGenerator.nextInt(16) - 8;
                    int extraAdds = randomNumberGenerator.nextInt(4);
                    int addCount = delta + extraAdds;
                    int removeCount = -delta + extraAdds;
                    if (addCount > 0) {
                        int i1 = 0;
                        while (i1 < addCount) {
                            toAdd.add(randomNumberGenerator.nextInt(20));
                            ++i1;
                        }
                    }
                    if (removeCount > 0) {
                        Iterator oldElements = this.wrappedSet.iterator();
                        int i2 = 0;
                        while (i2 < removeCount && oldElements.hasNext()) {
                            toRemove.add(oldElements.next());
                            ++i2;
                        }
                    }
                    toAdd.removeAll(this.wrappedSet);
                    this.wrappedSet.addAll(toAdd);
                    this.wrappedSet.removeAll(toRemove);
                    this.setStale(false);
                    this.fireSetChange(Diffs.createSetDiff(toAdd, toRemove));
                });
            });
            newThread.start();
        }
    }
}

