/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.contentprovider.test;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.ComputedObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.IObservableSet;

public class SomeMathFunction<K>
extends ComputedObservableMap<K, Double> {
    public static final int OP_IDENTITY = 0;
    public static final int OP_MULTIPLY = 1;
    public static final int OP_ROUND = 2;
    private int op = 2;

    public SomeMathFunction(IObservableSet<K> domain) {
        super(domain);
        this.init();
    }

    public void setOperation(final int operation) {
        final int oldOp = this.op;
        this.op = operation;
        this.fireMapChange(new MapDiff<K, Double>(){

            public Set<K> getAddedKeys() {
                return Collections.EMPTY_SET;
            }

            public Set<K> getChangedKeys() {
                return SomeMathFunction.this.keySet();
            }

            public Double getNewValue(Object key) {
                return SomeMathFunction.this.doComputeResult(key, operation);
            }

            public Double getOldValue(Object key) {
                return SomeMathFunction.this.doComputeResult(key, oldOp);
            }

            public Set<K> getRemovedKeys() {
                return Collections.EMPTY_SET;
            }
        });
    }

    private Double doComputeResult(Object element, int op) {
        switch (op) {
            case 0: {
                return (Double)element;
            }
            case 1: {
                return new Double((Double)element * 2.0);
            }
            case 2: {
                return new Double(Math.floor((Double)element));
            }
        }
        return (Double)element;
    }

    protected Double doGet(K key) {
        return this.doComputeResult(key, this.op);
    }

    protected Double doPut(K key, Double value) {
        throw new UnsupportedOperationException();
    }

    protected void hookListener(K addedKey) {
    }

    protected void unhookListener(K removedKey) {
    }
}

