/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.mask.internal;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class WorkQueue {
    private boolean updateScheduled = false;
    private boolean paintListenerAttached = false;
    private Deque<Runnable> pendingWork = new LinkedList<Runnable>();
    private Display d;
    private Set<Runnable> pendingWorkSet = new HashSet<Runnable>();
    private Runnable updateJob = () -> {
        this.doUpdate();
        this.updateScheduled = false;
    };
    private Listener paintListener = new Listener(){

        public void handleEvent(Event event) {
            WorkQueue.this.paintListenerAttached = false;
            WorkQueue.this.d.removeFilter(9, (Listener)this);
            WorkQueue.this.doUpdate();
        }
    };

    public WorkQueue(Display targetDisplay) {
        this.d = targetDisplay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        while (true) {
            Runnable next;
            Deque<Runnable> deque = this.pendingWork;
            synchronized (deque) {
                if (this.pendingWork.isEmpty()) {
                    break;
                }
                next = this.pendingWork.removeFirst();
                this.pendingWorkSet.remove(next);
            }
            next.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnce(Runnable work) {
        Deque<Runnable> deque = this.pendingWork;
        synchronized (deque) {
            if (this.pendingWorkSet.contains(work)) {
                return;
            }
            this.pendingWorkSet.add(work);
            this.asyncExec(work);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable work) {
        Deque<Runnable> deque = this.pendingWork;
        synchronized (deque) {
            this.pendingWork.add(work);
            if (!this.updateScheduled) {
                this.updateScheduled = true;
                this.d.asyncExec(this.updateJob);
            }
            if (Display.getCurrent() == this.d && !this.paintListenerAttached) {
                this.paintListenerAttached = true;
                this.d.addFilter(9, this.paintListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExec(Runnable toCancel) {
        Deque<Runnable> deque = this.pendingWork;
        synchronized (deque) {
            this.pendingWork.remove(toCancel);
            this.pendingWorkSet.remove(toCancel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Deque<Runnable> deque = this.pendingWork;
        synchronized (deque) {
            this.pendingWork.clear();
            this.pendingWorkSet.clear();
        }
    }
}

