/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.radioGroup;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.examples.databinding.ducks.DuckType;
import org.eclipse.jface.examples.databinding.radioGroup.VetoableSelectionListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class RadioGroup {
    private final IRadioButton[] buttons;
    private final Object[] values;
    IRadioButton oldSelection = null;
    IRadioButton selectedButton = null;
    IRadioButton potentialNewSelection = null;
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            RadioGroup.this.potentialNewSelection = this.getButton(e);
            if (!RadioGroup.this.potentialNewSelection.getSelection()) {
                return;
            }
            if (RadioGroup.this.potentialNewSelection.equals(RadioGroup.this.selectedButton)) {
                return;
            }
            if (RadioGroup.this.fireWidgetChangeSelectionEvent(e)) {
                RadioGroup.this.oldSelection = RadioGroup.this.selectedButton;
                RadioGroup.this.selectedButton = RadioGroup.this.potentialNewSelection;
                if (RadioGroup.this.oldSelection == null) {
                    RadioGroup.this.oldSelection = RadioGroup.this.selectedButton;
                }
                RadioGroup.this.fireWidgetSelectedEvent(e);
            }
        }

        private IRadioButton getButton(SelectionEvent e) {
            if (e.data != null) {
                return (IRadioButton)e.data;
            }
            return (IRadioButton)DuckType.implement(IRadioButton.class, e.widget);
        }
    };
    private List widgetChangeListeners = new LinkedList();
    private List widgetSelectedListeners = new ArrayList();

    public RadioGroup(Object[] radioButtons, Object[] values) {
        IRadioButton[] buttons = new IRadioButton[radioButtons.length];
        if (buttons.length < 1) {
            throw new IllegalArgumentException("A RadioGroup must manage at least one Button");
        }
        int i = 0;
        while (i < buttons.length) {
            if (!DuckType.instanceOf(IRadioButton.class, radioButtons[i])) {
                throw new IllegalArgumentException("A radio button was not passed");
            }
            buttons[i] = (IRadioButton)DuckType.implement(IRadioButton.class, radioButtons[i]);
            buttons[i].setData(Integer.toString(i), i);
            buttons[i].addSelectionListener(this.selectionListener);
            ++i;
        }
        this.buttons = buttons;
        this.values = values;
    }

    public Object getSelection() {
        int selectionIndex = this.getSelectionIndex();
        if (selectionIndex < 0) {
            return "";
        }
        return this.values[selectionIndex];
    }

    public void setSelection(Object newSelection) {
        this.deselectAll();
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i].equals(newSelection)) {
                this.setSelection(i);
                return;
            }
            ++i;
        }
    }

    protected boolean fireWidgetChangeSelectionEvent(SelectionEvent e) {
        for (VetoableSelectionListener listener : this.widgetChangeListeners) {
            listener.canWidgetChangeSelection(e);
            if (e.doit) continue;
            this.rollbackSelection();
            return false;
        }
        return true;
    }

    private void rollbackSelection() {
        Display.getCurrent().asyncExec(() -> {
            this.potentialNewSelection.setSelection(false);
            this.selectedButton.setSelection(true);
        });
    }

    public void addVetoableSelectionListener(VetoableSelectionListener listener) {
        this.widgetChangeListeners.add(listener);
    }

    public void removeVetoableSelectionListener(VetoableSelectionListener listener) {
        this.widgetChangeListeners.remove(listener);
    }

    protected void fireWidgetSelectedEvent(SelectionEvent e) {
        for (SelectionListener listener : this.widgetSelectedListeners) {
            listener.widgetSelected(e);
        }
    }

    protected void fireWidgetDefaultSelectedEvent(SelectionEvent e) {
        this.fireWidgetSelectedEvent(e);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.widgetSelectedListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.widgetSelectedListeners.remove(listener);
    }

    public void deselect(int index) {
        if (index < 0 || index >= this.buttons.length) {
            return;
        }
        this.buttons[index].setSelection(false);
    }

    public void deselectAll() {
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i].setSelection(false);
            ++i;
        }
    }

    public int getFocusIndex() {
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i].isFocusControl()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getItem(int index) {
        if (index < 0 || index >= this.buttons.length) {
            SWT.error((int)6, null, (String)"getItem for a nonexistant item");
        }
        return this.buttons[index].getText();
    }

    public int getItemCount() {
        return this.buttons.length;
    }

    public String[] getItems() {
        ArrayList<String> itemStrings = new ArrayList<String>();
        int i = 0;
        while (i < this.buttons.length) {
            itemStrings.add(this.buttons[i].getText());
            ++i;
        }
        return itemStrings.toArray(new String[itemStrings.size()]);
    }

    public Object[] getButtons() {
        return this.buttons;
    }

    public int getSelectionIndex() {
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String string) {
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i].getText().equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String string, int start) {
        int i = start;
        while (i < this.buttons.length) {
            if (this.buttons[i].getText().equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        return this.buttons[index].getSelection();
    }

    public void select(int index) {
        if (index < 0 || index >= this.buttons.length) {
            return;
        }
        this.buttons[index].setSelection(true);
    }

    public void setItem(int index, String string) {
        if (index < 0 || index >= this.buttons.length) {
            SWT.error((int)6, null, (String)"setItem for a nonexistant item");
        }
        this.buttons[index].setText(string);
    }

    public void setSelection(int index) {
        if (index < 0 || index > this.buttons.length - 1) {
            return;
        }
        this.buttons[index].setSelection(true);
    }

    public static interface IRadioButton {
        public void setData(String var1, Object var2);

        public void addSelectionListener(SelectionListener var1);

        public void setSelection(boolean var1);

        public boolean getSelection();

        public boolean isFocusControl();

        public String getText();

        public void setText(String var1);

        public void notifyListeners(int var1, Event var2);
    }
}

