/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Snippet003UpdateComboBindUsingViewer {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            ViewModel viewModel = new ViewModel();
            Shell shell = new View(viewModel).createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            System.out.println(viewModel.getText());
        });
        display.dispose();
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class View {
        private ViewModel viewModel;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Shell shell = new Shell(Display.getCurrent());
            shell.setLayout((Layout)new RowLayout(512));
            Combo combo = new Combo((Composite)shell, 2056);
            ComboViewer viewer = new ComboViewer(combo);
            Button reset = new Button((Composite)shell, 0);
            reset.setText("reset collection");
            reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<String> newList = new ArrayList<String>();
                    newList.add("Chocolate");
                    newList.add("Vanilla");
                    newList.add("Mango Parfait");
                    newList.add("beef");
                    newList.add("Cheesecake");
                    viewModel.setChoices(newList);
                }
            });
            System.out.println(this.viewModel.getText());
            DataBindingContext dbc = new DataBindingContext();
            ViewerSupport.bind((StructuredViewer)viewer, (IObservableList)BeanProperties.list(this.viewModel.getClass(), (String)"choices", String.class).observe((Object)this.viewModel), (IValueProperty)Properties.selfValue(String.class));
            dbc.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)viewer), BeanProperties.value(this.viewModel.getClass(), (String)"text").observe((Object)this.viewModel));
            shell.pack();
            shell.open();
            return shell;
        }
    }

    public static class ViewModel
    extends AbstractModelObject {
        private String text = "beef";
        private List choices = new ArrayList();

        public ViewModel() {
            this.choices.add("pork");
            this.choices.add("beef");
            this.choices.add("poultry");
            this.choices.add("vegatables");
        }

        public List getChoices() {
            return this.choices;
        }

        public void setChoices(List choices) {
            this.choices = choices;
            this.firePropertyChange("choices", null, null);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.firePropertyChange("text", oldValue, text);
        }
    }
}

