/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet011ValidateMultipleBindingsSnippet {
    public static void main(String[] args) {
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)Display.getDefault()), () -> Snippet011ValidateMultipleBindingsSnippet.run());
    }

    private static void run() {
        Shell shell = new Shell();
        View view = new View((Composite)shell);
        final Model model = new Model();
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)view.text1), model.value1, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new CrossFieldValidator((IObservableValue)model.value2)), null);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)view.text2), model.value2, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new CrossFieldValidator((IObservableValue)model.value1)), null);
        model.value1.addValueChangeListener(event -> System.out.println("Value 1: " + (String)model.value1.getValue()));
        model.value2.addValueChangeListener((IValueChangeListener)new IValueChangeListener<Object>(){

            public void handleValueChange(ValueChangeEvent<?> event) {
                System.out.println("Value 2: " + (String)model.value2.getValue());
            }
        });
        shell.pack();
        shell.open();
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static final class CrossFieldValidator
    implements IValidator<Object> {
        private final IObservableValue<?> other;

        private CrossFieldValidator(IObservableValue<?> other) {
            this.other = other;
        }

        public IStatus validate(Object value) {
            if (!value.equals(this.other.getValue())) {
                System.out.println("Validation fine");
                return ValidationStatus.ok();
            }
            System.out.println("Validation error: values cannot be the same");
            return ValidationStatus.error((String)"values cannot be the same");
        }
    }

    static class Model {
        WritableValue<String> value1 = new WritableValue();
        WritableValue<String> value2 = new WritableValue();

        Model() {
        }
    }

    static class View {
        Text text1;
        Text text2;

        View(Composite composite) {
            composite.setLayout((Layout)new GridLayout(2, true));
            this.text1 = new Text(composite, 2048);
            this.text2 = new Text(composite, 2048);
        }
    }
}

