/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.internal.databinding.provisional.swt.CompositeUpdater;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Snippet012CompositeUpdater {
    static Timer timer = new Timer(true);

    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new Shell(display);
            final WritableList list = new WritableList();
            Button button = new Button((Composite)shell, 8);
            button.setText("add");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    list.add(0, (Object)new Counter());
                }
            });
            final Composite composite = new Composite((Composite)shell, 0);
            new CompositeUpdater(composite, (IObservableList)list){

                protected Widget createWidget(int index) {
                    Label label = new Label(composite, 2048);
                    return label;
                }

                protected void updateWidget(Widget widget, Object element) {
                    ((Label)widget).setText("" + ((Counter)((Object)element)).getValue());
                    this.requestLayout((Control)((Label)widget));
                }
            };
            GridLayoutFactory.fillDefaults().numColumns(10).generateLayout(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            GridLayoutFactory.fillDefaults().generateLayout((Composite)shell);
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    static class Counter
    extends WritableValue {
        Counter() {
            super((Object)0, Integer.class);
            this.scheduleIncrementTask();
        }

        private void scheduleIncrementTask() {
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    this.getRealm().asyncExec(() -> {
                        Integer currentVal = (Integer)this.getValue();
                        this.setValue(currentVal + 1);
                    });
                    this.scheduleIncrementTask();
                }
            }, 1000L);
        }
    }
}

