/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.util.Date;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet014WizardDialog {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            SampleWizard wizard = new SampleWizard();
            WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
            dialog.open();
            Display display1 = Display.getCurrent();
            while (dialog.getShell() != null && !dialog.getShell().isDisposed()) {
                if (display1.readAndDispatch()) continue;
                display1.sleep();
            }
        });
    }

    static class FirstWizardPage
    extends WizardPage {
        protected FirstWizardPage() {
            super("First", "First Page", ImageDescriptor.createFromImage((Image)new Image((Device)Display.getDefault(), 16, 16)));
        }

        public void createControl(Composite parent) {
            DataBindingContext dbc = new DataBindingContext();
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
            Composite composite = new Composite(parent, 0);
            Label label = new Label(composite, 0);
            label.setText("Enter a number between 0 and 9:");
            Text text = new Text(composite, 2048);
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), ((SampleWizard)this.getWizard()).getModel().intValue, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new SingleDigitValidator()), null);
            GridLayoutFactory.swtDefaults().numColumns(2).generateLayout(composite);
            this.setControl((Control)composite);
        }

        private final class SingleDigitValidator
        implements IValidator<Integer> {
            private SingleDigitValidator() {
            }

            public IStatus validate(Integer value) {
                if (value == null) {
                    return ValidationStatus.info((String)"Please enter a value.");
                }
                if (value < 0 || value > 9) {
                    return ValidationStatus.error((String)"Value must be between 0 and 9.");
                }
                return ValidationStatus.ok();
            }
        }
    }

    static class SampleWizard
    extends Wizard {
        private SampleWizardModel model = new SampleWizardModel();

        SampleWizard() {
        }

        public void addPages() {
            this.addPage((IWizardPage)new FirstWizardPage());
            this.addPage((IWizardPage)new SecondWizardPage());
        }

        public SampleWizardModel getModel() {
            return this.model;
        }

        public String getWindowTitle() {
            return "Data Binding Snippet014";
        }

        public boolean performFinish() {
            return true;
        }
    }

    static class SampleWizardModel {
        IObservableValue<Integer> intValue = new WritableValue(null, Integer.class);
        IObservableValue<Integer> dateValue = new WritableValue(null, Date.class);

        SampleWizardModel() {
        }
    }

    static class SecondWizardPage
    extends WizardPage {
        protected SecondWizardPage() {
            super("Second", "Second Page", ImageDescriptor.createFromImage((Image)new Image((Device)Display.getDefault(), 16, 16)));
        }

        public void createControl(Composite parent) {
            DataBindingContext dbc = new DataBindingContext();
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
            Composite composite = new Composite(parent, 0);
            Label label = new Label(composite, 0);
            label.setText("Enter a date:");
            Text text = new Text(composite, 2048);
            dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)text), ((SampleWizard)this.getWizard()).getModel().dateValue);
            GridLayoutFactory.swtDefaults().numColumns(2).generateLayout(composite);
            this.setControl((Control)composite);
        }
    }
}

