/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet027ExternalValidator
extends WizardPage {
    private Text nameValue;
    private Text emailValue;
    private Text phoneNumberValue;
    private Contact contact;

    public Snippet027ExternalValidator() {
        super("snippet024");
        this.setTitle("Snippet 024 - External Validation");
        this.setDescription("Please enter contact details.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("Name");
        this.nameValue = new Text(container, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.nameValue.setLayoutData((Object)gd);
        Label emailLabel = new Label(container, 0);
        emailLabel.setText("Email");
        this.emailValue = new Text(container, 2048);
        this.emailValue.setLayoutData((Object)gd);
        Label phoneLabel = new Label(container, 0);
        phoneLabel.setText("Phone");
        this.phoneNumberValue = new Text(container, 2048);
        this.phoneNumberValue.setLayoutData((Object)gd);
        this.contact = new Contact("BorisBokowski", "boris.at.somecompany.com", "1-123-456-7890");
        this.bindUI();
    }

    private void bindUI() {
        DataBindingContext dbc = new DataBindingContext();
        final IObservableValue name = BeanProperties.value(this.contact.getClass(), (String)"name").observe((Object)this.contact);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameValue), name, null, null);
        final IObservableValue email = BeanProperties.value(this.contact.getClass(), (String)"email").observe((Object)this.contact);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.emailValue), email, null, null);
        final IObservableValue phone = BeanProperties.value(this.contact.getClass(), (String)"phoneNumber").observe((Object)this.contact);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.phoneNumberValue), phone, null, null);
        MultiValidator validator = new MultiValidator(){

            protected IStatus validate() {
                name.getValue();
                email.getValue();
                phone.getValue();
                System.out.println("Validating...");
                return Snippet027ExternalValidator.this.contact.validate();
            }
        };
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            ExternalValidationWizard wizard = new ExternalValidationWizard();
            WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
            dialog.open();
            Display display1 = Display.getCurrent();
            while (dialog.getShell() != null && !dialog.getShell().isDisposed()) {
                if (display1.readAndDispatch()) continue;
                display1.sleep();
            }
        });
        display.dispose();
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class Contact
    extends AbstractModelObject {
        String name;
        String email;
        String phoneNumber;

        public Contact(String name, String email, String number) {
            this.name = name;
            this.email = email;
            this.phoneNumber = number;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            String oldValue = this.email;
            this.email = email;
            this.firePropertyChange("email", oldValue, email);
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String number) {
            String oldValue = this.phoneNumber;
            this.phoneNumber = number;
            this.firePropertyChange("phoneNumber", oldValue, number);
        }

        public IStatus validate() {
            if (this.name.indexOf(32) == -1) {
                return ValidationStatus.error((String)"Please enter both first and last name separated by a space.");
            }
            if (this.email.indexOf(64) == -1) {
                return ValidationStatus.error((String)"Please enter a valid email address containing '@'.");
            }
            if (!this.phoneNumber.startsWith("+")) {
                return ValidationStatus.error((String)"Please enter the phone number in international format starting with '+'.");
            }
            return Status.OK_STATUS;
        }
    }

    static class ExternalValidationWizard
    extends Wizard {
        ExternalValidationWizard() {
        }

        public void addPages() {
            this.addPage((IWizardPage)new Snippet027ExternalValidator());
        }

        public String getWindowTitle() {
            return "Snippet 024 - External Validation";
        }

        public boolean performFinish() {
            return true;
        }
    }
}

