/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet034ComboViewerAndEnum {
    public static void main(String[] args) {
        Display display = new Display();
        Person model = new Person("Pat", Gender.Unknown);
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new View(model).createShell();
            Display display1 = Display.getCurrent();
            while (!shell.isDisposed()) {
                if (display1.readAndDispatch()) continue;
                display1.sleep();
            }
        });
        System.out.println("person.getName() = " + model.getName());
        System.out.println("person.getGender() = " + (Object)((Object)model.getGender()));
    }

    static enum Gender {
        Male,
        Female,
        Unknown;

    }

    static class Person {
        String name;
        Gender gender;

        public Person(String name, Gender gender) {
            this.name = name;
            this.gender = gender;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Gender getGender() {
            return this.gender;
        }

        public void setGender(Gender newGender) {
            this.gender = newGender;
        }
    }

    static class View {
        private Person viewModel;
        private Text name;
        private ComboViewer gender;

        public View(Person viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            RowLayout layout = new RowLayout(512);
            layout.fill = true;
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            shell.setLayout((Layout)layout);
            this.name = new Text((Composite)shell, 2048);
            this.gender = new ComboViewer((Composite)shell, 8);
            this.gender.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.gender.setInput((Object)Gender.values());
            DataBindingContext bindingContext = new DataBindingContext();
            ISWTObservableValue widgetObservable = WidgetProperties.text((int)24).observe((Widget)this.name);
            bindingContext.bindValue((IObservableValue)widgetObservable, PojoProperties.value(this.viewModel.getClass(), (String)"name").observe((Object)this.viewModel));
            widgetObservable = ViewersObservables.observeSingleSelection((Viewer)this.gender);
            bindingContext.bindValue((IObservableValue)widgetObservable, PojoProperties.value(this.viewModel.getClass(), (String)"gender").observe((Object)this.viewModel));
            shell.pack();
            shell.open();
            return shell;
        }
    }
}

