/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.dialog.IValidationMessageProvider;
import org.eclipse.jface.databinding.dialog.ValidationMessageProvider;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet036ValidationMessageProvider {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            MessageProviderWizard wizard = new MessageProviderWizard();
            WizardDialog wizardDialog = new WizardDialog(null, (IWizard)wizard);
            wizardDialog.open();
            Display display1 = Display.getCurrent();
            while (wizardDialog.getShell() != null && !wizardDialog.getShell().isDisposed()) {
                if (display1.readAndDispatch()) continue;
                display1.sleep();
            }
        });
    }

    private static final class CustomMessageProvider
    extends ValidationMessageProvider {
        private final Map<Binding, String> bindingMapName;

        public CustomMessageProvider(Map<Binding, String> bindingMapName) {
            this.bindingMapName = bindingMapName;
        }

        public String getMessage(ValidationStatusProvider statusProvider) {
            String name;
            if (statusProvider != null && (name = this.bindingMapName.get(statusProvider)) != null) {
                String message = super.getMessage(statusProvider);
                return String.valueOf(name) + ": " + message;
            }
            return super.getMessage(statusProvider);
        }

        public int getMessageType(ValidationStatusProvider statusProvider) {
            IObservableValue target;
            Binding binding;
            IStatus status;
            if (statusProvider instanceof Binding && (status = (IStatus)(binding = (Binding)statusProvider).getValidationStatus().getValue()).matches(4) && "".equals((target = (IObservableValue)binding.getTarget()).getValue())) {
                return 0;
            }
            return super.getMessageType(statusProvider);
        }
    }

    private static final class MessageProviderWizard
    extends Wizard {
        private MessageProviderWizard() {
        }

        public void addPages() {
            this.addPage((IWizardPage)new MessageProviderWizardPage());
        }

        public String getWindowTitle() {
            return "Snippet 036 - IValidationMessageProvider";
        }

        public boolean performFinish() {
            return true;
        }
    }

    private static final class MessageProviderWizardPage
    extends WizardPage {
        private DataBindingContext dbc;
        private Map<Binding, String> bindingMapName;

        protected MessageProviderWizardPage() {
            super(MessageProviderWizardPage.class.getName());
            this.setTitle("Snippet 036 - IValidationMessageProvider");
            this.setDescription("Please fill in the form.");
        }

        public void createControl(Composite parent) {
            this.dbc = new DataBindingContext();
            this.bindingMapName = new HashMap<Binding, String>();
            Composite container = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).spacing(15, 5).applyTo(container);
            this.setControl((Control)container);
            this.createTextLine(container, "Name", (IObservableValue)WritableValue.withValueType(String.class));
            this.createTextLine(container, "Age", (IObservableValue)WritableValue.withValueType(Integer.class));
            this.createTextLine(container, "Birthday", (IObservableValue)WritableValue.withValueType(Date.class));
            WizardPageSupport wps = WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
            wps.setValidationMessageProvider((IValidationMessageProvider)new CustomMessageProvider(this.bindingMapName));
        }

        private <T> void createTextLine(Composite parent, String labelText, IObservableValue<T> modelValue) {
            Label label = new Label(parent, 16384);
            label.setText(labelText);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
            final Text text = new Text(parent, 2048);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
            ISWTObservableValue textObservable = WidgetProperties.text((int)24).observe((Widget)text);
            Binding binding = this.dbc.bindValue((IObservableValue)textObservable, modelValue, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new RequiredValidator()), new UpdateValueStrategy());
            ControlDecorationUpdater decorationUpdater = new ControlDecorationUpdater(){

                protected Image getImage(IStatus status) {
                    if (text.getText().length() == 0) {
                        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED");
                        return fieldDecoration.getImage();
                    }
                    return super.getImage(status);
                }
            };
            ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)128, null, (ControlDecorationUpdater)decorationUpdater);
            this.bindingMapName.put(binding, labelText);
        }
    }

    private static final class RequiredValidator
    implements IValidator<Object> {
        private RequiredValidator() {
        }

        public IStatus validate(Object value) {
            if (value == null || "".equals(value)) {
                return ValidationStatus.error((String)"Please specify a value.");
            }
            return ValidationStatus.ok();
        }
    }
}

